# -*- coding: utf8 -*-
# Copyright (c) 2017-2021 THL A29 Limited, a Tencent company. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class ABTestConfig(AbstractModel):
    """Canary project configuration

    """

    def __init__(self):
        r"""
        :param ProjectName: Canary project name
        :type ProjectName: str
        :param Status: Valid values: `true` (in canary upgrade); `false` (not in canary upgrade).
        :type Status: bool
        """
        self.ProjectName = None
        self.Status = None


    def _deserialize(self, params):
        self.ProjectName = params.get("ProjectName")
        self.Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbnormalProcessChildRuleInfo(AbstractModel):
    """Container runtime security - Sub-policy information

    """

    def __init__(self):
        r"""
        :param RuleMode: Policy mode. `RULE_MODE_RELEASE`: Allow.
   `RULE_MODE_ALERT`: Alert.
   `RULE_MODE_HOLDUP`: Block.
        :type RuleMode: str
        :param ProcessPath: Process path
        :type ProcessPath: str
        :param RuleId: Sub-policy ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleId: str
        :param RuleLevel: Severity. Valid values: `HIGH` (high); `MIDDLE` (medium); `LOW` (low).
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleLevel: str
        """
        self.RuleMode = None
        self.ProcessPath = None
        self.RuleId = None
        self.RuleLevel = None


    def _deserialize(self, params):
        self.RuleMode = params.get("RuleMode")
        self.ProcessPath = params.get("ProcessPath")
        self.RuleId = params.get("RuleId")
        self.RuleLevel = params.get("RuleLevel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbnormalProcessEventDescription(AbstractModel):
    """Description of the abnormal container process event at runtime

    """

    def __init__(self):
        r"""
        :param Description: Event rule
        :type Description: str
        :param Solution: Solution
        :type Solution: str
        :param Remark: Event remarks
Note: This field may return null, indicating that no valid values can be obtained.
        :type Remark: str
        :param MatchRule: Details of the hit rule
        :type MatchRule: :class:`tencentcloud.tcss.v20201101.models.AbnormalProcessChildRuleInfo`
        :param RuleName: Name of the hit rule. Valid values: `PROXY_TOOL` (proxy); `TRANSFER_CONTROL` (lateral movement); `ATTACK_CMD` (malicious command); `REVERSE_SHELL` (reverse shell); `FILELESS` (fileless execution); `RISK_CMD` (high-risk command); `ABNORMAL_CHILD_PROC` (unusual start found in the child process of the sensitive service); `USER_DEFINED_RULE` (custom rule).
        :type RuleName: str
        :param RuleId: ID of the hit rule
        :type RuleId: str
        :param OperationTime: Last processing time of the event
Note: This field may return null, indicating that no valid values can be obtained.
        :type OperationTime: str
        :param GroupName: Name of the hit policy. Valid values: `SYSTEM_DEFINED_RULE` (preset policy); name of the custom policy.
Note: This field may return null, indicating that no valid values can be obtained.
        :type GroupName: str
        """
        self.Description = None
        self.Solution = None
        self.Remark = None
        self.MatchRule = None
        self.RuleName = None
        self.RuleId = None
        self.OperationTime = None
        self.GroupName = None


    def _deserialize(self, params):
        self.Description = params.get("Description")
        self.Solution = params.get("Solution")
        self.Remark = params.get("Remark")
        if params.get("MatchRule") is not None:
            self.MatchRule = AbnormalProcessChildRuleInfo()
            self.MatchRule._deserialize(params.get("MatchRule"))
        self.RuleName = params.get("RuleName")
        self.RuleId = params.get("RuleId")
        self.OperationTime = params.get("OperationTime")
        self.GroupName = params.get("GroupName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbnormalProcessEventInfo(AbstractModel):
    """Container runtime security - Information of the abnormal process

    """

    def __init__(self):
        r"""
        :param ProcessPath: Process directory
        :type ProcessPath: str
        :param EventType: Event type. `MALICE_PROCESS_START`: Malicious process startup.
        :type EventType: str
        :param MatchRuleName: Name of the hit rule. Valid values: `PROXY_TOOL` (proxy); `TRANSFER_CONTROL` (lateral movement); `ATTACK_CMD` (malicious command); `REVERSE_SHELL` (reverse shell); `FILELESS` (fileless execution); `RISK_CMD` (high-risk command); `ABNORMAL_CHILD_PROC` (unusual start found in the child process of the sensitive service); `USER_DEFINED_RULE` (custom rule).
        :type MatchRuleName: str
        :param FoundTime: Generation time
        :type FoundTime: str
        :param ContainerName: Container name
        :type ContainerName: str
        :param ImageName: Image name
        :type ImageName: str
        :param Behavior: Action execution result. `BEHAVIOR_NONE`: None.
    `BEHAVIOR_ALERT`: Alert.
    `BEHAVIOR_RELEASE`: Allow.
    `BEHAVIOR_HOLDUP_FAILED`: Failed to block.
    `BEHAVIOR_HOLDUP_SUCCESSED`: Blocked.
        :type Behavior: str
        :param Status: Status. `EVENT_UNDEAL`: Pending.
    `EVENT_DEALED`: Processed.
    `EVENT_INGNORE`: Ignored.
        :type Status: str
        :param Id: Unique event ID
        :type Id: str
        :param ImageId: Image ID, which is used for redirect.
        :type ImageId: str
        :param ContainerId: Container ID, which is used for redirect.
        :type ContainerId: str
        :param Solution: Event solution
        :type Solution: str
        :param Description: Event description
        :type Description: str
        :param MatchRuleId: Hit policy ID
        :type MatchRuleId: str
        :param MatchAction: Action of the hit rule:
`RULE_MODE_RELEASE`: Allow.
`RULE_MODE_ALERT`: Alert.
`RULE_MODE_HOLDUP`: Block.
        :type MatchAction: str
        :param MatchProcessPath: Information of the process that hits the rule
        :type MatchProcessPath: str
        :param RuleExist: Whether the rule exists
        :type RuleExist: bool
        :param EventCount: Number of events
        :type EventCount: int
        :param LatestFoundTime: Last generation time
        :type LatestFoundTime: str
        :param RuleId: Rule group ID
        :type RuleId: str
        :param MatchGroupName: Name of the hit policy. Valid values: `SYSTEM_DEFINED_RULE` (preset policy); name of the custom policy.
        :type MatchGroupName: str
        :param MatchRuleLevel: Level of the hit rule. Valid values: `HIGH` (high); `MIDDLE` (medium); `LOW` (low).
        :type MatchRuleLevel: str
        :param ContainerNetStatus: Network status
`NORMAL`: 	Not isolated.
`ISOLATED`: 		Isolated.
`ISOLATING`: 		Isolating.
`ISOLATE_FAILED`: 	Isolation failed.
`RESTORING`: Recovering.
`RESTORE_FAILED`: Recovery failed.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ContainerNetStatus: str
        :param ContainerNetSubStatus: Sub-status of the container
"AGENT_OFFLINE"       // The agent is offline.
"NODE_DESTROYED"      // The node is terminated.
"CONTAINER_EXITED"    // The container exited.
"CONTAINER_DESTROYED" // The container was terminated.
"SHARED_HOST"         // The container shares the network with the server.
"RESOURCE_LIMIT"      // The number of resources to be isolated exceeds the limit.
"UNKNOW"              // The reason is unknown.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ContainerNetSubStatus: str
        :param ContainerIsolateOperationSrc: Container isolation operation source
Note: This field may return null, indicating that no valid values can be obtained.
        :type ContainerIsolateOperationSrc: str
        :param ContainerStatus: Container status
`RUNNING`: Running.
`PAUSED`: Paused.
`STOPPED`: Stopped.
`CREATED`: Created.
`DESTROYED`: Terminated.
`RESTARTING`: Restarting.
`REMOVING`: Removing.
        :type ContainerStatus: str
        """
        self.ProcessPath = None
        self.EventType = None
        self.MatchRuleName = None
        self.FoundTime = None
        self.ContainerName = None
        self.ImageName = None
        self.Behavior = None
        self.Status = None
        self.Id = None
        self.ImageId = None
        self.ContainerId = None
        self.Solution = None
        self.Description = None
        self.MatchRuleId = None
        self.MatchAction = None
        self.MatchProcessPath = None
        self.RuleExist = None
        self.EventCount = None
        self.LatestFoundTime = None
        self.RuleId = None
        self.MatchGroupName = None
        self.MatchRuleLevel = None
        self.ContainerNetStatus = None
        self.ContainerNetSubStatus = None
        self.ContainerIsolateOperationSrc = None
        self.ContainerStatus = None


    def _deserialize(self, params):
        self.ProcessPath = params.get("ProcessPath")
        self.EventType = params.get("EventType")
        self.MatchRuleName = params.get("MatchRuleName")
        self.FoundTime = params.get("FoundTime")
        self.ContainerName = params.get("ContainerName")
        self.ImageName = params.get("ImageName")
        self.Behavior = params.get("Behavior")
        self.Status = params.get("Status")
        self.Id = params.get("Id")
        self.ImageId = params.get("ImageId")
        self.ContainerId = params.get("ContainerId")
        self.Solution = params.get("Solution")
        self.Description = params.get("Description")
        self.MatchRuleId = params.get("MatchRuleId")
        self.MatchAction = params.get("MatchAction")
        self.MatchProcessPath = params.get("MatchProcessPath")
        self.RuleExist = params.get("RuleExist")
        self.EventCount = params.get("EventCount")
        self.LatestFoundTime = params.get("LatestFoundTime")
        self.RuleId = params.get("RuleId")
        self.MatchGroupName = params.get("MatchGroupName")
        self.MatchRuleLevel = params.get("MatchRuleLevel")
        self.ContainerNetStatus = params.get("ContainerNetStatus")
        self.ContainerNetSubStatus = params.get("ContainerNetSubStatus")
        self.ContainerIsolateOperationSrc = params.get("ContainerIsolateOperationSrc")
        self.ContainerStatus = params.get("ContainerStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbnormalProcessEventTendencyInfo(AbstractModel):
    """Trend of pending abnormal process events

    """

    def __init__(self):
        r"""
        :param Date: Date
        :type Date: str
        :param ProxyToolEventCount: Number of pending proxy events
        :type ProxyToolEventCount: int
        :param TransferControlEventCount: Number of pending lateral movement events
        :type TransferControlEventCount: int
        :param AttackCmdEventCount: Number of pending malicious command events
        :type AttackCmdEventCount: int
        :param ReverseShellEventCount: Number of pending reverse shell events
        :type ReverseShellEventCount: int
        :param FilelessEventCount: Number of pending fileless execution events
        :type FilelessEventCount: int
        :param RiskCmdEventCount: Number of pending high-risk command events
        :type RiskCmdEventCount: int
        :param AbnormalChildProcessEventCount: Number of pending events of unusual startups found in the child process of the sensitive service
        :type AbnormalChildProcessEventCount: int
        :param UserDefinedRuleEventCount: Number of pending custom rule events
        :type UserDefinedRuleEventCount: int
        """
        self.Date = None
        self.ProxyToolEventCount = None
        self.TransferControlEventCount = None
        self.AttackCmdEventCount = None
        self.ReverseShellEventCount = None
        self.FilelessEventCount = None
        self.RiskCmdEventCount = None
        self.AbnormalChildProcessEventCount = None
        self.UserDefinedRuleEventCount = None


    def _deserialize(self, params):
        self.Date = params.get("Date")
        self.ProxyToolEventCount = params.get("ProxyToolEventCount")
        self.TransferControlEventCount = params.get("TransferControlEventCount")
        self.AttackCmdEventCount = params.get("AttackCmdEventCount")
        self.ReverseShellEventCount = params.get("ReverseShellEventCount")
        self.FilelessEventCount = params.get("FilelessEventCount")
        self.RiskCmdEventCount = params.get("RiskCmdEventCount")
        self.AbnormalChildProcessEventCount = params.get("AbnormalChildProcessEventCount")
        self.UserDefinedRuleEventCount = params.get("UserDefinedRuleEventCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbnormalProcessRuleInfo(AbstractModel):
    """Runtime security - Abnormal process detection policy

    """

    def __init__(self):
        r"""
        :param IsEnable: Valid values: `true` (enabled); `false` (disabled).
        :type IsEnable: bool
        :param ImageIds: IDs of associated images. An empty array indicates all images.
        :type ImageIds: list of str
        :param ChildRules: Array of sub-policies of the user policy
        :type ChildRules: list of AbnormalProcessChildRuleInfo
        :param RuleName: Policy name
        :type RuleName: str
        :param RuleId: Policy ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleId: str
        :param SystemChildRules: Array of sub-policies of the preset policy
        :type SystemChildRules: list of AbnormalProcessSystemChildRuleInfo
        :param IsDefault: Whether it is the default preset policy
        :type IsDefault: bool
        """
        self.IsEnable = None
        self.ImageIds = None
        self.ChildRules = None
        self.RuleName = None
        self.RuleId = None
        self.SystemChildRules = None
        self.IsDefault = None


    def _deserialize(self, params):
        self.IsEnable = params.get("IsEnable")
        self.ImageIds = params.get("ImageIds")
        if params.get("ChildRules") is not None:
            self.ChildRules = []
            for item in params.get("ChildRules"):
                obj = AbnormalProcessChildRuleInfo()
                obj._deserialize(item)
                self.ChildRules.append(obj)
        self.RuleName = params.get("RuleName")
        self.RuleId = params.get("RuleId")
        if params.get("SystemChildRules") is not None:
            self.SystemChildRules = []
            for item in params.get("SystemChildRules"):
                obj = AbnormalProcessSystemChildRuleInfo()
                obj._deserialize(item)
                self.SystemChildRules.append(obj)
        self.IsDefault = params.get("IsDefault")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbnormalProcessSystemChildRuleInfo(AbstractModel):
    """Information of the sub-policy of the preset policy for abnormal processes

    """

    def __init__(self):
        r"""
        :param RuleId: Sub-policy ID
        :type RuleId: str
        :param IsEnable: Sub-policy status. Valid values: `true` (enabled); `false` (disabled).
        :type IsEnable: bool
        :param RuleMode: Policy mode. `RULE_MODE_RELEASE`: Allow.
   `RULE_MODE_ALERT`: Alert.
   `RULE_MODE_HOLDUP`: Block.
        :type RuleMode: str
        :param RuleType: Behavior type detected by the sub-policy
`PROXY_TOOL`: Proxy.
`TRANSFER_CONTROL`: Lateral movement.
`ATTACK_CMD`: Malicious command.
`REVERSE_SHELL`: Reverse shell.
`FILELESS`: Fileless execution.
`RISK_CMD`: High-risk command.
`ABNORMAL_CHILD_PROC`: Unusual start found in the child process of the sensitive service.
        :type RuleType: str
        :param RuleLevel: Severity. Valid values: `HIGH` (high); `MIDDLE` (medium); `LOW` (low).
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleLevel: str
        """
        self.RuleId = None
        self.IsEnable = None
        self.RuleMode = None
        self.RuleType = None
        self.RuleLevel = None


    def _deserialize(self, params):
        self.RuleId = params.get("RuleId")
        self.IsEnable = params.get("IsEnable")
        self.RuleMode = params.get("RuleMode")
        self.RuleType = params.get("RuleType")
        self.RuleLevel = params.get("RuleLevel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccessControlChildRuleInfo(AbstractModel):
    """Container runtime security - Information of the access control sub-policy

    """

    def __init__(self):
        r"""
        :param RuleMode: Policy mode. `RULE_MODE_RELEASE`: Allow.
   `RULE_MODE_ALERT`: Alert.
   `RULE_MODE_HOLDUP`: Block.
        :type RuleMode: str
        :param ProcessPath: Process path
        :type ProcessPath: str
        :param TargetFilePath: Accessed file path, which is valid only for access control.
        :type TargetFilePath: str
        :param RuleId: Sub-policy ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleId: str
        """
        self.RuleMode = None
        self.ProcessPath = None
        self.TargetFilePath = None
        self.RuleId = None


    def _deserialize(self, params):
        self.RuleMode = params.get("RuleMode")
        self.ProcessPath = params.get("ProcessPath")
        self.TargetFilePath = params.get("TargetFilePath")
        self.RuleId = params.get("RuleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccessControlEventDescription(AbstractModel):
    """Description of the container access control event at runtime

    """

    def __init__(self):
        r"""
        :param Description: Event rule
        :type Description: str
        :param Solution: Solution
        :type Solution: str
        :param Remark: Event remarks
Note: This field may return null, indicating that no valid values can be obtained.
        :type Remark: str
        :param MatchRule: Details of the hit rule
        :type MatchRule: :class:`tencentcloud.tcss.v20201101.models.AccessControlChildRuleInfo`
        :param RuleName: Name of the hit rule
        :type RuleName: str
        :param RuleId: ID of the hit rule
        :type RuleId: str
        :param OperationTime: Last processing time of the event
Note: This field may return null, indicating that no valid values can be obtained.
        :type OperationTime: str
        """
        self.Description = None
        self.Solution = None
        self.Remark = None
        self.MatchRule = None
        self.RuleName = None
        self.RuleId = None
        self.OperationTime = None


    def _deserialize(self, params):
        self.Description = params.get("Description")
        self.Solution = params.get("Solution")
        self.Remark = params.get("Remark")
        if params.get("MatchRule") is not None:
            self.MatchRule = AccessControlChildRuleInfo()
            self.MatchRule._deserialize(params.get("MatchRule"))
        self.RuleName = params.get("RuleName")
        self.RuleId = params.get("RuleId")
        self.OperationTime = params.get("OperationTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccessControlEventInfo(AbstractModel):
    """Container runtime security - Information of the access control event

    """

    def __init__(self):
        r"""
        :param ProcessName: Process name
        :type ProcessName: str
        :param MatchRuleName: Name of the hit rule
        :type MatchRuleName: str
        :param FoundTime: Generation time
        :type FoundTime: str
        :param ContainerName: Container name
        :type ContainerName: str
        :param ImageName: Image name
        :type ImageName: str
        :param Behavior: Action execution result. `BEHAVIOR_NONE`: None.
    `BEHAVIOR_ALERT`: Alert.
    `BEHAVIOR_RELEASE`: Allow.
    `BEHAVIOR_HOLDUP_FAILED`: Failed to block.
    `BEHAVIOR_HOLDUP_SUCCESSED`: Blocked.
        :type Behavior: str
        :param Status: Status. `0`: Pending. `EVENT_UNDEAL`: Pending.
    `EVENT_DEALED`: Processed.
    `EVENT_INGNORE`: Ignored.
        :type Status: str
        :param Id: Unique event ID
        :type Id: str
        :param FileName: Filename
        :type FileName: str
        :param EventType: Event type. `FILE_ABNORMAL_READ`: Abnormal file read.
        :type EventType: str
        :param ImageId: Image ID, which is used for redirect.
        :type ImageId: str
        :param ContainerId: Container ID, which is used for redirect.
        :type ContainerId: str
        :param Solution: Event solution
        :type Solution: str
        :param Description: Event description
        :type Description: str
        :param MatchRuleId: Hit policy ID
        :type MatchRuleId: str
        :param MatchAction: Action of the hit rule:
`RULE_MODE_RELEASE`: Allow.
`RULE_MODE_ALERT`: Alert.
`RULE_MODE_HOLDUP`: Block.
        :type MatchAction: str
        :param MatchProcessPath: Information of the process that hits the rule
        :type MatchProcessPath: str
        :param MatchFilePath: Information of the file that hits the rule
        :type MatchFilePath: str
        :param FilePath: File path containing the name
        :type FilePath: str
        :param RuleExist: Whether the rule exists
        :type RuleExist: bool
        :param EventCount: Number of events
        :type EventCount: int
        :param LatestFoundTime: Last generation time
        :type LatestFoundTime: str
        :param RuleId: Rule group ID
        :type RuleId: str
        :param ContainerNetStatus: Network status
`NORMAL`: 	Not isolated.
`ISOLATED`: 		Isolated.
`ISOLATING`: 		Isolating.
`ISOLATE_FAILED`: 	Isolation failed.
`RESTORING`: Recovering.
`RESTORE_FAILED`: Recovery failed.
        :type ContainerNetStatus: str
        :param ContainerNetSubStatus: Sub-status of the container
"AGENT_OFFLINE"       // The agent is offline.
"NODE_DESTROYED"      // The node is terminated.
"CONTAINER_EXITED"    // The container exited.
"CONTAINER_DESTROYED" // The container was terminated.
"SHARED_HOST"         // The container shares the network with the server.
"RESOURCE_LIMIT"      // The number of resources to be isolated exceeds the limit.
"UNKNOW"              // The reason is unknown.
        :type ContainerNetSubStatus: str
        :param ContainerIsolateOperationSrc: Container isolation operation source
        :type ContainerIsolateOperationSrc: str
        :param ContainerStatus: Container status
`RUNNING`: Running.
`PAUSED`: Paused.
`STOPPED`: Stopped.
`CREATED`: Created.
`DESTROYED`: Terminated.
`RESTARTING`: Restarting.
`REMOVING`: Removing.
        :type ContainerStatus: str
        """
        self.ProcessName = None
        self.MatchRuleName = None
        self.FoundTime = None
        self.ContainerName = None
        self.ImageName = None
        self.Behavior = None
        self.Status = None
        self.Id = None
        self.FileName = None
        self.EventType = None
        self.ImageId = None
        self.ContainerId = None
        self.Solution = None
        self.Description = None
        self.MatchRuleId = None
        self.MatchAction = None
        self.MatchProcessPath = None
        self.MatchFilePath = None
        self.FilePath = None
        self.RuleExist = None
        self.EventCount = None
        self.LatestFoundTime = None
        self.RuleId = None
        self.ContainerNetStatus = None
        self.ContainerNetSubStatus = None
        self.ContainerIsolateOperationSrc = None
        self.ContainerStatus = None


    def _deserialize(self, params):
        self.ProcessName = params.get("ProcessName")
        self.MatchRuleName = params.get("MatchRuleName")
        self.FoundTime = params.get("FoundTime")
        self.ContainerName = params.get("ContainerName")
        self.ImageName = params.get("ImageName")
        self.Behavior = params.get("Behavior")
        self.Status = params.get("Status")
        self.Id = params.get("Id")
        self.FileName = params.get("FileName")
        self.EventType = params.get("EventType")
        self.ImageId = params.get("ImageId")
        self.ContainerId = params.get("ContainerId")
        self.Solution = params.get("Solution")
        self.Description = params.get("Description")
        self.MatchRuleId = params.get("MatchRuleId")
        self.MatchAction = params.get("MatchAction")
        self.MatchProcessPath = params.get("MatchProcessPath")
        self.MatchFilePath = params.get("MatchFilePath")
        self.FilePath = params.get("FilePath")
        self.RuleExist = params.get("RuleExist")
        self.EventCount = params.get("EventCount")
        self.LatestFoundTime = params.get("LatestFoundTime")
        self.RuleId = params.get("RuleId")
        self.ContainerNetStatus = params.get("ContainerNetStatus")
        self.ContainerNetSubStatus = params.get("ContainerNetSubStatus")
        self.ContainerIsolateOperationSrc = params.get("ContainerIsolateOperationSrc")
        self.ContainerStatus = params.get("ContainerStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccessControlRuleInfo(AbstractModel):
    """Container runtime - Access control policy information

    """

    def __init__(self):
        r"""
        :param IsEnable: Switch. Valid values: `true` (on); `false` (off).
        :type IsEnable: bool
        :param ImageIds: IDs of associated images. An empty array indicates all images.
        :type ImageIds: list of str
        :param ChildRules: Array of sub-policies of the user policy
        :type ChildRules: list of AccessControlChildRuleInfo
        :param RuleName: Policy name
        :type RuleName: str
        :param RuleId: Policy ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleId: str
        :param SystemChildRules: Array of sub-policies of the preset policy
        :type SystemChildRules: list of AccessControlSystemChildRuleInfo
        :param IsDefault: Whether it is the default preset policy
        :type IsDefault: bool
        """
        self.IsEnable = None
        self.ImageIds = None
        self.ChildRules = None
        self.RuleName = None
        self.RuleId = None
        self.SystemChildRules = None
        self.IsDefault = None


    def _deserialize(self, params):
        self.IsEnable = params.get("IsEnable")
        self.ImageIds = params.get("ImageIds")
        if params.get("ChildRules") is not None:
            self.ChildRules = []
            for item in params.get("ChildRules"):
                obj = AccessControlChildRuleInfo()
                obj._deserialize(item)
                self.ChildRules.append(obj)
        self.RuleName = params.get("RuleName")
        self.RuleId = params.get("RuleId")
        if params.get("SystemChildRules") is not None:
            self.SystemChildRules = []
            for item in params.get("SystemChildRules"):
                obj = AccessControlSystemChildRuleInfo()
                obj._deserialize(item)
                self.SystemChildRules.append(obj)
        self.IsDefault = params.get("IsDefault")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccessControlSystemChildRuleInfo(AbstractModel):
    """Container runtime security - Information of the sub-policy of the preset access control policy

    """

    def __init__(self):
        r"""
        :param RuleId: Sub-policy ID
        :type RuleId: str
        :param RuleMode: Policy mode. `RULE_MODE_RELEASE`: Allow.
   `RULE_MODE_ALERT`: Alert.
   `RULE_MODE_HOLDUP`: Block.
        :type RuleMode: str
        :param IsEnable: Sub-policy status. Valid values: `true` (enabled); `false` (disabled).
        :type IsEnable: bool
        :param RuleType: Intrusion behavior type detected by the sub-policy
`CHANGE_CRONTAB`: Tampering with the scheduled task.
`CHANGE_SYS_BIN`: Tampering with the system program.
`CHANGE_USRCFG`: Tampering with user configuration.
        :type RuleType: str
        """
        self.RuleId = None
        self.RuleMode = None
        self.IsEnable = None
        self.RuleType = None


    def _deserialize(self, params):
        self.RuleId = params.get("RuleId")
        self.RuleMode = params.get("RuleMode")
        self.IsEnable = params.get("IsEnable")
        self.RuleType = params.get("RuleType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddAndPublishNetworkFirewallPolicyDetailRequest(AbstractModel):
    """AddAndPublishNetworkFirewallPolicyDetail request structure.

    """

    def __init__(self):
        r"""
        :param ClusterId: Cluster ID
        :type ClusterId: str
        :param PolicyName: Policy name
        :type PolicyName: str
        :param FromPolicyRule: Inbound rule

`1`: Allow all.

`2`: Reject all.

`3`: Custom.
        :type FromPolicyRule: int
        :param ToPolicyRule: Outbound rule

`1`: Allow all.

`2`: Reject all.

`3`: Custom.
        :type ToPolicyRule: int
        :param PodSelector: Pod selector
        :type PodSelector: str
        :param Namespace: Namespace
        :type Namespace: str
        :param Description: Policy description
        :type Description: str
        :param CustomPolicy: Custom rule
        :type CustomPolicy: list of NetworkCustomPolicy
        """
        self.ClusterId = None
        self.PolicyName = None
        self.FromPolicyRule = None
        self.ToPolicyRule = None
        self.PodSelector = None
        self.Namespace = None
        self.Description = None
        self.CustomPolicy = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        self.PolicyName = params.get("PolicyName")
        self.FromPolicyRule = params.get("FromPolicyRule")
        self.ToPolicyRule = params.get("ToPolicyRule")
        self.PodSelector = params.get("PodSelector")
        self.Namespace = params.get("Namespace")
        self.Description = params.get("Description")
        if params.get("CustomPolicy") is not None:
            self.CustomPolicy = []
            for item in params.get("CustomPolicy"):
                obj = NetworkCustomPolicy()
                obj._deserialize(item)
                self.CustomPolicy.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddAndPublishNetworkFirewallPolicyDetailResponse(AbstractModel):
    """AddAndPublishNetworkFirewallPolicyDetail response structure.

    """

    def __init__(self):
        r"""
        :param TaskId: ID of the created task. `0` indicates that the creation failed.
        :type TaskId: int
        :param Result: Result of creating the task. Valid values: `Succ`, `Failed`.
        :type Result: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskId = None
        self.Result = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.Result = params.get("Result")
        self.RequestId = params.get("RequestId")


class AddAndPublishNetworkFirewallPolicyYamlDetailRequest(AbstractModel):
    """AddAndPublishNetworkFirewallPolicyYamlDetail request structure.

    """

    def __init__(self):
        r"""
        :param ClusterId: Cluster ID
        :type ClusterId: str
        :param PolicyName: Policy name
        :type PolicyName: str
        :param Yaml: Base64-encoded NetworkPolicy YAML string
        :type Yaml: str
        :param Description: Policy description
        :type Description: str
        """
        self.ClusterId = None
        self.PolicyName = None
        self.Yaml = None
        self.Description = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        self.PolicyName = params.get("PolicyName")
        self.Yaml = params.get("Yaml")
        self.Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddAndPublishNetworkFirewallPolicyYamlDetailResponse(AbstractModel):
    """AddAndPublishNetworkFirewallPolicyYamlDetail response structure.

    """

    def __init__(self):
        r"""
        :param TaskId: ID of the created task. `0` indicates that the creation failed.
        :type TaskId: int
        :param Result: Result of creating the task. Valid values: `Succ`, `Failed`.
        :type Result: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskId = None
        self.Result = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.Result = params.get("Result")
        self.RequestId = params.get("RequestId")


class AddAssetImageRegistryRegistryDetailRequest(AbstractModel):
    """AddAssetImageRegistryRegistryDetail request structure.

    """

    def __init__(self):
        r"""
        :param Name: Repository name
        :type Name: str
        :param Username: Username
        :type Username: str
        :param Password: Password
        :type Password: str
        :param Url: Repository URL
        :type Url: str
        :param RegistryType: Repository type, which can be `harbor`.
        :type RegistryType: str
        :param NetType: Network type, which can be `public` (public network).
        :type NetType: str
        :param RegistryVersion: Repository version
        :type RegistryVersion: str
        :param RegistryRegion: Region. Default value: `default`.
        :type RegistryRegion: str
        :param SpeedLimit: Speed limit
        :type SpeedLimit: int
        :param Insecure: Valid values: `0` (secure mode with certificate verification, which is the default value); `1` (unsecure mode that skips certificate verification).
        :type Insecure: int
        """
        self.Name = None
        self.Username = None
        self.Password = None
        self.Url = None
        self.RegistryType = None
        self.NetType = None
        self.RegistryVersion = None
        self.RegistryRegion = None
        self.SpeedLimit = None
        self.Insecure = None


    def _deserialize(self, params):
        self.Name = params.get("Name")
        self.Username = params.get("Username")
        self.Password = params.get("Password")
        self.Url = params.get("Url")
        self.RegistryType = params.get("RegistryType")
        self.NetType = params.get("NetType")
        self.RegistryVersion = params.get("RegistryVersion")
        self.RegistryRegion = params.get("RegistryRegion")
        self.SpeedLimit = params.get("SpeedLimit")
        self.Insecure = params.get("Insecure")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddAssetImageRegistryRegistryDetailResponse(AbstractModel):
    """AddAssetImageRegistryRegistryDetail response structure.

    """

    def __init__(self):
        r"""
        :param HealthCheckErr: Connection error message
Note: This field may return null, indicating that no valid values can be obtained.
        :type HealthCheckErr: str
        :param NameRepeatErr: Name error message
Note: This field may return null, indicating that no valid values can be obtained.
        :type NameRepeatErr: str
        :param RegistryId: Unique repository ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type RegistryId: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.HealthCheckErr = None
        self.NameRepeatErr = None
        self.RegistryId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.HealthCheckErr = params.get("HealthCheckErr")
        self.NameRepeatErr = params.get("NameRepeatErr")
        self.RegistryId = params.get("RegistryId")
        self.RequestId = params.get("RequestId")


class AddComplianceAssetPolicySetToWhitelistRequest(AbstractModel):
    """AddComplianceAssetPolicySetToWhitelist request structure.

    """

    def __init__(self):
        r"""
        :param AssetPolicySetList: List of asset IDs and check item IDs
        :type AssetPolicySetList: list of ComplianceAssetPolicySetItem
        """
        self.AssetPolicySetList = None


    def _deserialize(self, params):
        if params.get("AssetPolicySetList") is not None:
            self.AssetPolicySetList = []
            for item in params.get("AssetPolicySetList"):
                obj = ComplianceAssetPolicySetItem()
                obj._deserialize(item)
                self.AssetPolicySetList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddComplianceAssetPolicySetToWhitelistResponse(AbstractModel):
    """AddComplianceAssetPolicySetToWhitelist response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class AddCompliancePolicyAssetSetToWhitelistRequest(AbstractModel):
    """AddCompliancePolicyAssetSetToWhitelist request structure.

    """

    def __init__(self):
        r"""
        :param CustomerPolicyItemId: Check item ID
        :type CustomerPolicyItemId: int
        :param CustomerAssetItemIdSet: List of IDs of assets to be ignored in the specified check item
        :type CustomerAssetItemIdSet: list of int non-negative
        """
        self.CustomerPolicyItemId = None
        self.CustomerAssetItemIdSet = None


    def _deserialize(self, params):
        self.CustomerPolicyItemId = params.get("CustomerPolicyItemId")
        self.CustomerAssetItemIdSet = params.get("CustomerAssetItemIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddCompliancePolicyAssetSetToWhitelistResponse(AbstractModel):
    """AddCompliancePolicyAssetSetToWhitelist response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class AddCompliancePolicyItemToWhitelistRequest(AbstractModel):
    """AddCompliancePolicyItemToWhitelist request structure.

    """

    def __init__(self):
        r"""
        :param CustomerPolicyItemIdSet: List of IDs of check items to be ignored
        :type CustomerPolicyItemIdSet: list of int non-negative
        """
        self.CustomerPolicyItemIdSet = None


    def _deserialize(self, params):
        self.CustomerPolicyItemIdSet = params.get("CustomerPolicyItemIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddCompliancePolicyItemToWhitelistResponse(AbstractModel):
    """AddCompliancePolicyItemToWhitelist response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class AddEditAbnormalProcessRuleRequest(AbstractModel):
    """AddEditAbnormalProcessRule request structure.

    """

    def __init__(self):
        r"""
        :param RuleInfo: Information of the added policy. The policy ID is empty here but cannot be empty when you edit a policy.
        :type RuleInfo: :class:`tencentcloud.tcss.v20201101.models.AbnormalProcessRuleInfo`
        :param EventId: Required only when an item is allowed
        :type EventId: str
        """
        self.RuleInfo = None
        self.EventId = None


    def _deserialize(self, params):
        if params.get("RuleInfo") is not None:
            self.RuleInfo = AbnormalProcessRuleInfo()
            self.RuleInfo._deserialize(params.get("RuleInfo"))
        self.EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddEditAbnormalProcessRuleResponse(AbstractModel):
    """AddEditAbnormalProcessRule response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class AddEditAccessControlRuleRequest(AbstractModel):
    """AddEditAccessControlRule request structure.

    """

    def __init__(self):
        r"""
        :param RuleInfo: Information of the added policy. The policy ID is empty here but cannot be empty when you edit a policy.
        :type RuleInfo: :class:`tencentcloud.tcss.v20201101.models.AccessControlRuleInfo`
        :param EventId: Used only for an allowed item
        :type EventId: str
        """
        self.RuleInfo = None
        self.EventId = None


    def _deserialize(self, params):
        if params.get("RuleInfo") is not None:
            self.RuleInfo = AccessControlRuleInfo()
            self.RuleInfo._deserialize(params.get("RuleInfo"))
        self.EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddEditAccessControlRuleResponse(AbstractModel):
    """AddEditAccessControlRule response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class AddEditImageAutoAuthorizedRuleRequest(AbstractModel):
    """AddEditImageAutoAuthorizedRule request structure.

    """

    def __init__(self):
        r"""
        :param RangeType: Scope. Valid values: `MANUAL` (specified servers); `ALL` (all images).
        :type RangeType: str
        :param MaxDailyCount: Maximum number of image licenses per day. `0`: Unlimited.
        :type MaxDailyCount: int
        :param IsEnabled: Whether the rule takes effect. Valid values: `0` (no); `1` (yes).
        :type IsEnabled: int
        :param HostIdSet: IDs of specified servers. This parameter is required when the scope is `MANUAL` and `HostIdFilters` is empty.
        :type HostIdSet: list of str
        :param RuleId: Rule ID, which is required during editing.
        :type RuleId: int
        :param HostIdFilters: Filter. This parameter is required when the scope is `MANUAL` and `HostIdSet` is empty.
        :type HostIdFilters: list of AssetFilters
        :param ExcludeHostIdSet: Specified server IDs to be excluded
        :type ExcludeHostIdSet: list of str
        """
        self.RangeType = None
        self.MaxDailyCount = None
        self.IsEnabled = None
        self.HostIdSet = None
        self.RuleId = None
        self.HostIdFilters = None
        self.ExcludeHostIdSet = None


    def _deserialize(self, params):
        self.RangeType = params.get("RangeType")
        self.MaxDailyCount = params.get("MaxDailyCount")
        self.IsEnabled = params.get("IsEnabled")
        self.HostIdSet = params.get("HostIdSet")
        self.RuleId = params.get("RuleId")
        if params.get("HostIdFilters") is not None:
            self.HostIdFilters = []
            for item in params.get("HostIdFilters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.HostIdFilters.append(obj)
        self.ExcludeHostIdSet = params.get("ExcludeHostIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddEditImageAutoAuthorizedRuleResponse(AbstractModel):
    """AddEditImageAutoAuthorizedRule response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class AddEditReverseShellWhiteListRequest(AbstractModel):
    """AddEditReverseShellWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param WhiteListInfo: Information of the allowed item to be added or edited. When an allowed item is added, `WhiteListInfo.id` can be empty; when an allowed item is edited, `WhiteListInfo.id` cannot be empty.
        :type WhiteListInfo: :class:`tencentcloud.tcss.v20201101.models.ReverseShellWhiteListInfo`
        :param EventId: Used only when an event is added to the allowlist
        :type EventId: str
        """
        self.WhiteListInfo = None
        self.EventId = None


    def _deserialize(self, params):
        if params.get("WhiteListInfo") is not None:
            self.WhiteListInfo = ReverseShellWhiteListInfo()
            self.WhiteListInfo._deserialize(params.get("WhiteListInfo"))
        self.EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddEditReverseShellWhiteListResponse(AbstractModel):
    """AddEditReverseShellWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class AddEditRiskSyscallWhiteListRequest(AbstractModel):
    """AddEditRiskSyscallWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param EventId: Used only when an event is added to the allowlist
        :type EventId: str
        :param WhiteListInfo: Information of the allowed item to be added or edited. When an allowed item is added, `WhiteListInfo.id` can be empty; when an allowed item is edited, `WhiteListInfo.id` cannot be empty.
        :type WhiteListInfo: :class:`tencentcloud.tcss.v20201101.models.RiskSyscallWhiteListInfo`
        """
        self.EventId = None
        self.WhiteListInfo = None


    def _deserialize(self, params):
        self.EventId = params.get("EventId")
        if params.get("WhiteListInfo") is not None:
            self.WhiteListInfo = RiskSyscallWhiteListInfo()
            self.WhiteListInfo._deserialize(params.get("WhiteListInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddEditRiskSyscallWhiteListResponse(AbstractModel):
    """AddEditRiskSyscallWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class AddEditWarningRulesRequest(AbstractModel):
    """AddEditWarningRules request structure.

    """

    def __init__(self):
        r"""
        :param WarningRules: Alert switch policy
        :type WarningRules: list of WarningRule
        """
        self.WarningRules = None


    def _deserialize(self, params):
        if params.get("WarningRules") is not None:
            self.WarningRules = []
            for item in params.get("WarningRules"):
                obj = WarningRule()
                obj._deserialize(item)
                self.WarningRules.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddEditWarningRulesResponse(AbstractModel):
    """AddEditWarningRules response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class AddEscapeWhiteListRequest(AbstractModel):
    """AddEscapeWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param EventType: Allowed event type
   `ESCAPE_CGROUPS`: Cgroup escape.
   `ESCAPE_TAMPER_SENSITIVE_FILE`: File tamper escape.
   `ESCAPE_DOCKER_API`: Docker API access escape.
   `ESCAPE_VUL_OCCURRED`: Vulnerability exploit.
   `MOUNT_SENSITIVE_PTAH`: Sensitive path mount.
   `PRIVILEGE_CONTAINER_START`: Privileged container.
   `PRIVILEGE`: Program privilege escalation escape.
        :type EventType: list of str
        :param ImageIDs: Array of allowed image IDs
        :type ImageIDs: list of str
        """
        self.EventType = None
        self.ImageIDs = None


    def _deserialize(self, params):
        self.EventType = params.get("EventType")
        self.ImageIDs = params.get("ImageIDs")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddEscapeWhiteListResponse(AbstractModel):
    """AddEscapeWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class AddIgnoreVulRequest(AbstractModel):
    """AddIgnoreVul request structure.

    """

    def __init__(self):
        r"""
        :param List: List of POC IDs
        :type List: list of ModifyIgnoreVul
        """
        self.List = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = ModifyIgnoreVul()
                obj._deserialize(item)
                self.List.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddIgnoreVulResponse(AbstractModel):
    """AddIgnoreVul response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class AddNetworkFirewallPolicyDetailRequest(AbstractModel):
    """AddNetworkFirewallPolicyDetail request structure.

    """

    def __init__(self):
        r"""
        :param ClusterId: Cluster ID
        :type ClusterId: str
        :param PolicyName: Policy name
        :type PolicyName: str
        :param FromPolicyRule: Inbound rule

`1`: Allow all.

`2`: Reject all.

`3`: Custom.
        :type FromPolicyRule: int
        :param ToPolicyRule: Outbound rule

`1`: Allow all.

`2`: Reject all.

`3`: Custom.
        :type ToPolicyRule: int
        :param PodSelector: Pod selector
        :type PodSelector: str
        :param Namespace: Namespace
        :type Namespace: str
        :param Description: Policy description
        :type Description: str
        :param CustomPolicy: Custom rule
        :type CustomPolicy: list of NetworkCustomPolicy
        """
        self.ClusterId = None
        self.PolicyName = None
        self.FromPolicyRule = None
        self.ToPolicyRule = None
        self.PodSelector = None
        self.Namespace = None
        self.Description = None
        self.CustomPolicy = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        self.PolicyName = params.get("PolicyName")
        self.FromPolicyRule = params.get("FromPolicyRule")
        self.ToPolicyRule = params.get("ToPolicyRule")
        self.PodSelector = params.get("PodSelector")
        self.Namespace = params.get("Namespace")
        self.Description = params.get("Description")
        if params.get("CustomPolicy") is not None:
            self.CustomPolicy = []
            for item in params.get("CustomPolicy"):
                obj = NetworkCustomPolicy()
                obj._deserialize(item)
                self.CustomPolicy.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddNetworkFirewallPolicyDetailResponse(AbstractModel):
    """AddNetworkFirewallPolicyDetail response structure.

    """

    def __init__(self):
        r"""
        :param TaskId: ID of the created task. `0` indicates that the creation failed.
        :type TaskId: int
        :param Result: Result of creating the task. Valid values: `Succ`, `Failed`.
        :type Result: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskId = None
        self.Result = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.Result = params.get("Result")
        self.RequestId = params.get("RequestId")


class AddNetworkFirewallPolicyYamlDetailRequest(AbstractModel):
    """AddNetworkFirewallPolicyYamlDetail request structure.

    """

    def __init__(self):
        r"""
        :param ClusterId: Cluster ID
        :type ClusterId: str
        :param PolicyName: Policy name
        :type PolicyName: str
        :param Yaml: Base64-encoded NetworkPolicy YAML string
        :type Yaml: str
        :param Description: Policy description
        :type Description: str
        """
        self.ClusterId = None
        self.PolicyName = None
        self.Yaml = None
        self.Description = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        self.PolicyName = params.get("PolicyName")
        self.Yaml = params.get("Yaml")
        self.Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddNetworkFirewallPolicyYamlDetailResponse(AbstractModel):
    """AddNetworkFirewallPolicyYamlDetail response structure.

    """

    def __init__(self):
        r"""
        :param TaskId: ID of the created task. `0` indicates that the creation failed.
        :type TaskId: int
        :param Result: Result of creating the task. Valid values: `Succ`, `Failed`.
        :type Result: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskId = None
        self.Result = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.Result = params.get("Result")
        self.RequestId = params.get("RequestId")


class AffectedNodeItem(AbstractModel):
    """Structure of the affected node type

    """

    def __init__(self):
        r"""
        :param ClusterId: Cluster ID
        :type ClusterId: str
        :param ClusterName: Cluster name
        :type ClusterName: str
        :param InstanceId: Instance ID
        :type InstanceId: str
        :param PrivateIpAddresses: Private IP
        :type PrivateIpAddresses: str
        :param InstanceRole: Node role, such as `Master` and `Work`.
        :type InstanceRole: str
        :param ClusterVersion: K8s version
        :type ClusterVersion: str
        :param ContainerRuntime: Runtime component. Valid values: `docker`, `containerd`.
        :type ContainerRuntime: str
        :param Region: Region
        :type Region: str
        :param VerifyInfo: Verification information of the check result
        :type VerifyInfo: str
        """
        self.ClusterId = None
        self.ClusterName = None
        self.InstanceId = None
        self.PrivateIpAddresses = None
        self.InstanceRole = None
        self.ClusterVersion = None
        self.ContainerRuntime = None
        self.Region = None
        self.VerifyInfo = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        self.ClusterName = params.get("ClusterName")
        self.InstanceId = params.get("InstanceId")
        self.PrivateIpAddresses = params.get("PrivateIpAddresses")
        self.InstanceRole = params.get("InstanceRole")
        self.ClusterVersion = params.get("ClusterVersion")
        self.ContainerRuntime = params.get("ContainerRuntime")
        self.Region = params.get("Region")
        self.VerifyInfo = params.get("VerifyInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AffectedWorkloadItem(AbstractModel):
    """Affected workload item in the cluster security check

    """

    def __init__(self):
        r"""
        :param ClusterId: Cluster ID
        :type ClusterId: str
        :param ClusterName: Cluster name
        :type ClusterName: str
        :param WorkloadName: Workload name
        :type WorkloadName: str
        :param WorkloadType: Workload type
        :type WorkloadType: str
        :param Region: Region
        :type Region: str
        :param VerifyInfo: Verification information of the check result
        :type VerifyInfo: str
        """
        self.ClusterId = None
        self.ClusterName = None
        self.WorkloadName = None
        self.WorkloadType = None
        self.Region = None
        self.VerifyInfo = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        self.ClusterName = params.get("ClusterName")
        self.WorkloadName = params.get("WorkloadName")
        self.WorkloadType = params.get("WorkloadType")
        self.Region = params.get("Region")
        self.VerifyInfo = params.get("VerifyInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetClusterListItem(AbstractModel):
    """List of clusters

    """

    def __init__(self):
        r"""
        :param ClusterID: Cluster ID
        :type ClusterID: str
        :param ClusterName: Cluster name
        :type ClusterName: str
        :param Status: Cluster status
`CSR_RUNNING`: Running
`CSR_EXCEPTION`: Abnormal
`CSR_DEL`: Deleted
        :type Status: str
        :param BindRuleName: Bound rule name
        :type BindRuleName: str
        :param ClusterType: Cluster type:
`CT_TKE`: TKE cluster
`CT_USER_CREATE`: External cluster
        :type ClusterType: str
        """
        self.ClusterID = None
        self.ClusterName = None
        self.Status = None
        self.BindRuleName = None
        self.ClusterType = None


    def _deserialize(self, params):
        self.ClusterID = params.get("ClusterID")
        self.ClusterName = params.get("ClusterName")
        self.Status = params.get("Status")
        self.BindRuleName = params.get("BindRuleName")
        self.ClusterType = params.get("ClusterType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetFilters(AbstractModel):
    """TCSS
    Key-value pair filter for conditional filtering queries, such as filter ID, name, and status
    If more than one filter exists, the logical relationship between these filters is `AND`.
    If multiple values exist in one filter, the logical relationship between these values is `OR`.

    """

    def __init__(self):
        r"""
        :param Name: Filter name
        :type Name: str
        :param Values: One or more filter values
        :type Values: list of str
        :param ExactMatch: Whether to use fuzzy query
        :type ExactMatch: bool
        """
        self.Name = None
        self.Values = None
        self.ExactMatch = None


    def _deserialize(self, params):
        self.Name = params.get("Name")
        self.Values = params.get("Values")
        self.ExactMatch = params.get("ExactMatch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetSimpleImageInfo(AbstractModel):
    """Brief information of the image

    """

    def __init__(self):
        r"""
        :param ImageID: Image ID
        :type ImageID: str
        :param ImageName: Image name
        :type ImageName: str
        :param ContainerCnt: Number of associated containers
        :type ContainerCnt: int
        :param ScanTime: Last scan time
        :type ScanTime: str
        :param Size: Image size
        :type Size: int
        """
        self.ImageID = None
        self.ImageName = None
        self.ContainerCnt = None
        self.ScanTime = None
        self.Size = None


    def _deserialize(self, params):
        self.ImageID = params.get("ImageID")
        self.ImageName = params.get("ImageName")
        self.ContainerCnt = params.get("ContainerCnt")
        self.ScanTime = params.get("ScanTime")
        self.Size = params.get("Size")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AutoAuthorizedImageInfo(AbstractModel):
    """Result of the automatic image licensing

    """

    def __init__(self):
        r"""
        :param ImageId: Image ID
        :type ImageId: str
        :param ImageName: Image name
        :type ImageName: str
        :param AuthorizedTime: Licensing time
        :type AuthorizedTime: str
        :param Status: Licensing result. Valid values: `SUCCESS` (success); `REACH_LIMIT` (reaching the upper limit on licenses); `LICENSE_INSUFFICIENT` (insufficient licenses).
        :type Status: str
        :param IsAuthorized: Whether it is licensed. Valid values: `1` (yes); `0` (no).
        :type IsAuthorized: int
        """
        self.ImageId = None
        self.ImageName = None
        self.AuthorizedTime = None
        self.Status = None
        self.IsAuthorized = None


    def _deserialize(self, params):
        self.ImageId = params.get("ImageId")
        self.ImageName = params.get("ImageName")
        self.AuthorizedTime = params.get("AuthorizedTime")
        self.Status = params.get("Status")
        self.IsAuthorized = params.get("IsAuthorized")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AutoAuthorizedRuleHostInfo(AbstractModel):
    """List of servers licensed based on the automatic image licensing rule

    """

    def __init__(self):
        r"""
        :param HostID: Server ID
        :type HostID: str
        :param HostIP: Server IP, which is the private IP
        :type HostIP: str
        :param HostName: Server name
        :type HostName: str
        :param ImageCnt: Number of images
        :type ImageCnt: int
        :param ContainerCnt: Number of containers
        :type ContainerCnt: int
        :param PublicIp: Public IP
        :type PublicIp: str
        :param InstanceID: Server instance ID
        :type InstanceID: str
        :param MachineType: Server source. Valid values: `CVM`, `ECM`, `LH`, `BM`, `Other`. The first four values indicate Tencent Cloud instances, while the last one indicates non-Tencent Cloud instances.
        :type MachineType: str
        :param DockerVersion: Docker version
        :type DockerVersion: str
        :param Status: Agent status
        :type Status: str
        """
        self.HostID = None
        self.HostIP = None
        self.HostName = None
        self.ImageCnt = None
        self.ContainerCnt = None
        self.PublicIp = None
        self.InstanceID = None
        self.MachineType = None
        self.DockerVersion = None
        self.Status = None


    def _deserialize(self, params):
        self.HostID = params.get("HostID")
        self.HostIP = params.get("HostIP")
        self.HostName = params.get("HostName")
        self.ImageCnt = params.get("ImageCnt")
        self.ContainerCnt = params.get("ContainerCnt")
        self.PublicIp = params.get("PublicIp")
        self.InstanceID = params.get("InstanceID")
        self.MachineType = params.get("MachineType")
        self.DockerVersion = params.get("DockerVersion")
        self.Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CKafkaInstanceInfo(AbstractModel):
    """Optional information of the security log Kafka

    """

    def __init__(self):
        r"""
        :param InstanceID: Instance ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceID: str
        :param InstanceName: Instance name
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceName: str
        :param TopicList: Topic list
Note: This field may return null, indicating that no valid values can be obtained.
        :type TopicList: list of CKafkaTopicInfo
        :param RouteList: Route list
Note: This field may return null, indicating that no valid values can be obtained.
        :type RouteList: list of CkafkaRouteInfo
        :param KafkaVersion: Kafka version number
Note: This field may return null, indicating that no valid values can be obtained.
        :type KafkaVersion: str
        """
        self.InstanceID = None
        self.InstanceName = None
        self.TopicList = None
        self.RouteList = None
        self.KafkaVersion = None


    def _deserialize(self, params):
        self.InstanceID = params.get("InstanceID")
        self.InstanceName = params.get("InstanceName")
        if params.get("TopicList") is not None:
            self.TopicList = []
            for item in params.get("TopicList"):
                obj = CKafkaTopicInfo()
                obj._deserialize(item)
                self.TopicList.append(obj)
        if params.get("RouteList") is not None:
            self.RouteList = []
            for item in params.get("RouteList"):
                obj = CkafkaRouteInfo()
                obj._deserialize(item)
                self.RouteList.append(obj)
        self.KafkaVersion = params.get("KafkaVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CKafkaTopicInfo(AbstractModel):
    """CKafka topic information

    """

    def __init__(self):
        r"""
        :param TopicID: Topic ID
        :type TopicID: str
        :param TopicName: Topic name
        :type TopicName: str
        """
        self.TopicID = None
        self.TopicName = None


    def _deserialize(self, params):
        self.TopicID = params.get("TopicID")
        self.TopicName = params.get("TopicName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckNetworkFirewallPolicyYamlRequest(AbstractModel):
    """CheckNetworkFirewallPolicyYaml request structure.

    """

    def __init__(self):
        r"""
        :param ClusterId: Cluster ID
        :type ClusterId: str
        :param PolicyName: Policy name
        :type PolicyName: str
        :param Yaml: Base64-encoded NetworkPolicy YAML string
        :type Yaml: str
        :param Description: Policy description
        :type Description: str
        """
        self.ClusterId = None
        self.PolicyName = None
        self.Yaml = None
        self.Description = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        self.PolicyName = params.get("PolicyName")
        self.Yaml = params.get("Yaml")
        self.Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckNetworkFirewallPolicyYamlResponse(AbstractModel):
    """CheckNetworkFirewallPolicyYaml response structure.

    """

    def __init__(self):
        r"""
        :param TaskId: ID of the created task. `0` indicates that the creation failed.
        :type TaskId: int
        :param Result: Result of creating the task. Valid values: `Succ`, `Failed`.
        :type Result: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskId = None
        self.Result = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.Result = params.get("Result")
        self.RequestId = params.get("RequestId")


class CheckRepeatAssetImageRegistryRequest(AbstractModel):
    """CheckRepeatAssetImageRegistry request structure.

    """

    def __init__(self):
        r"""
        :param Name: Repository name
        :type Name: str
        """
        self.Name = None


    def _deserialize(self, params):
        self.Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckRepeatAssetImageRegistryResponse(AbstractModel):
    """CheckRepeatAssetImageRegistry response structure.

    """

    def __init__(self):
        r"""
        :param IsRepeat: Whether it is repeated
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsRepeat: bool
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.IsRepeat = None
        self.RequestId = None


    def _deserialize(self, params):
        self.IsRepeat = params.get("IsRepeat")
        self.RequestId = params.get("RequestId")


class CkafkaRouteInfo(AbstractModel):
    """CKafka route details

    """

    def __init__(self):
        r"""
        :param RouteID: Route ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type RouteID: int
        :param Domain: Domain name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Domain: str
        :param DomainPort: Domain port
Note: This field may return null, indicating that no valid values can be obtained.
        :type DomainPort: int
        :param Vip: VIP
Note: This field may return null, indicating that no valid values can be obtained.
        :type Vip: str
        :param VipType: VIP type
Note: This field may return null, indicating that no valid values can be obtained.
        :type VipType: int
        :param AccessType: Access type
// `0`: PLAINTEXT (plaintext method, which does not carry user information and is supported for legacy versions and Community Edition)
	// `1`: SASL_PLAINTEXT (plaintext method, which authenticates the login through SASL before data start and is supported only for Community Edition)
	// `2`: SSL (SSL-encrypted communication, which does not carry user information and is supported for legacy versions and Community Edition)
	// `3`: SASL_SSL (SSL-encrypted communication, which authenticates the login through SASL before data start and is supported only for Community Edition)
Note: This field may return null, indicating that no valid values can be obtained.
        :type AccessType: int
        """
        self.RouteID = None
        self.Domain = None
        self.DomainPort = None
        self.Vip = None
        self.VipType = None
        self.AccessType = None


    def _deserialize(self, params):
        self.RouteID = params.get("RouteID")
        self.Domain = params.get("Domain")
        self.DomainPort = params.get("DomainPort")
        self.Vip = params.get("Vip")
        self.VipType = params.get("VipType")
        self.AccessType = params.get("AccessType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClsLogsetInfo(AbstractModel):
    """CLS logset information

    """

    def __init__(self):
        r"""
        :param LogsetID: Logset ID
        :type LogsetID: str
        :param LogsetName: Logset name
Note: This field may return null, indicating that no valid values can be obtained.
        :type LogsetName: str
        :param TopicList: List of CLS topics
Note: This field may return null, indicating that no valid values can be obtained.
        :type TopicList: list of ClsTopicInfo
        """
        self.LogsetID = None
        self.LogsetName = None
        self.TopicList = None


    def _deserialize(self, params):
        self.LogsetID = params.get("LogsetID")
        self.LogsetName = params.get("LogsetName")
        if params.get("TopicList") is not None:
            self.TopicList = []
            for item in params.get("TopicList"):
                obj = ClsTopicInfo()
                obj._deserialize(item)
                self.TopicList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClsTopicInfo(AbstractModel):
    """CLS topic information

    """

    def __init__(self):
        r"""
        :param TopicID: Topic ID
        :type TopicID: str
        :param TopicName: Topic name
        :type TopicName: str
        """
        self.TopicID = None
        self.TopicName = None


    def _deserialize(self, params):
        self.TopicID = params.get("TopicID")
        self.TopicName = params.get("TopicName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterCheckItem(AbstractModel):
    """Details of a cluster security check item

    """

    def __init__(self):
        r"""
        :param CheckItemId: Unique ID of the check item
Note: This field may return null, indicating that no valid values can be obtained.
        :type CheckItemId: int
        :param Name: Name of the risk item
        :type Name: str
        :param ItemDetail: Detailed description of the check item
Note: This field may return null, indicating that no valid values can be obtained.
        :type ItemDetail: str
        :param RiskLevel: Severity. Valid values: `Serious` (critical); `High` (high); `Middle` (medium); `Hint` (prompt).
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskLevel: str
        :param RiskTarget: Check target and risky target. Valid values: `Runc`, `Kubelet`, `Containerd`, `Pods`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskTarget: str
        :param RiskType: Risk type. Valid values: `CVERisk` (vulnerability risk); `ConfigRisk` (configuration risk).
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskType: str
        :param RiskAttribute: Risk type of the check item. Valid values: `PrivilegePromotion` (privilege escalation); `RefuseService` (service rejected); `DirectoryEscape` (directory traversal); `UnauthorizedAccess` (unauthorized access); `PrivilegeAndAccessControl` (permissions, privileges, and access controls); `SensitiveInfoLeak` (sensitive data leakage).
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskAttribute: str
        :param RiskProperty: Risk characteristic and tag. Valid values: `ExistEXP` (an EXP exists); `ExistPOC` (a POC exists); `NoNeedReboot` (restart not required); `ServerRestart` (service restart); `RemoteInfoLeak` (remote information leakage); `RemoteRefuseService` (remote denial of service); `RemoteExploit` (remote exploit); `RemoteExecute` (remote execution).
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskProperty: str
        :param CVENumber: CVE No.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CVENumber: str
        :param DiscoverTime: Disclosure time
Note: This field may return null, indicating that no valid values can be obtained.
        :type DiscoverTime: str
        :param Solution: Solution
Note: This field may return null, indicating that no valid values can be obtained.
        :type Solution: str
        :param CVSS: CVSS information, which is used for drawing.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CVSS: str
        :param CVSSScore: CVSS score
Note: This field may return null, indicating that no valid values can be obtained.
        :type CVSSScore: str
        :param RelateLink: Reference link
Note: This field may return null, indicating that no valid values can be obtained.
        :type RelateLink: str
        :param AffectedType: Affected type. Valid values: `Node`, `Workload`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AffectedType: str
        :param AffectedVersion: Affected version information
Note: This field may return null, indicating that no valid values can be obtained.
        :type AffectedVersion: str
        :param IgnoredAssetNum: Number of ignored assets
Note: This field may return null, indicating that no valid values can be obtained.
        :type IgnoredAssetNum: int
        :param IsIgnored: Whether to ignore the check item
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsIgnored: bool
        :param RiskAssessment: Impact assessment
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskAssessment: str
        """
        self.CheckItemId = None
        self.Name = None
        self.ItemDetail = None
        self.RiskLevel = None
        self.RiskTarget = None
        self.RiskType = None
        self.RiskAttribute = None
        self.RiskProperty = None
        self.CVENumber = None
        self.DiscoverTime = None
        self.Solution = None
        self.CVSS = None
        self.CVSSScore = None
        self.RelateLink = None
        self.AffectedType = None
        self.AffectedVersion = None
        self.IgnoredAssetNum = None
        self.IsIgnored = None
        self.RiskAssessment = None


    def _deserialize(self, params):
        self.CheckItemId = params.get("CheckItemId")
        self.Name = params.get("Name")
        self.ItemDetail = params.get("ItemDetail")
        self.RiskLevel = params.get("RiskLevel")
        self.RiskTarget = params.get("RiskTarget")
        self.RiskType = params.get("RiskType")
        self.RiskAttribute = params.get("RiskAttribute")
        self.RiskProperty = params.get("RiskProperty")
        self.CVENumber = params.get("CVENumber")
        self.DiscoverTime = params.get("DiscoverTime")
        self.Solution = params.get("Solution")
        self.CVSS = params.get("CVSS")
        self.CVSSScore = params.get("CVSSScore")
        self.RelateLink = params.get("RelateLink")
        self.AffectedType = params.get("AffectedType")
        self.AffectedVersion = params.get("AffectedVersion")
        self.IgnoredAssetNum = params.get("IgnoredAssetNum")
        self.IsIgnored = params.get("IsIgnored")
        self.RiskAssessment = params.get("RiskAssessment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterCheckTaskItem(AbstractModel):
    """Input parameters for a cluster check task

    """

    def __init__(self):
        r"""
        :param ClusterId: ID of the specified cluster to be scanned
        :type ClusterId: str
        :param ClusterRegion: Cluster region
        :type ClusterRegion: str
        :param NodeIp: IP of the specified node to be scanned
        :type NodeIp: str
        :param WorkloadName: Name of the specified workload to be scanned
        :type WorkloadName: str
        """
        self.ClusterId = None
        self.ClusterRegion = None
        self.NodeIp = None
        self.WorkloadName = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        self.ClusterRegion = params.get("ClusterRegion")
        self.NodeIp = params.get("NodeIp")
        self.WorkloadName = params.get("WorkloadName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterCreateComponentItem(AbstractModel):
    """Input parameters for `CreateCheckComponent`, which are used to batch install defenders.

    """

    def __init__(self):
        r"""
        :param ClusterId: ID of the cluster for which to install the component
        :type ClusterId: str
        :param ClusterRegion: Cluster region
        :type ClusterRegion: str
        """
        self.ClusterId = None
        self.ClusterRegion = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        self.ClusterRegion = params.get("ClusterRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterInfoItem(AbstractModel):
    """Response parameters structure of the cluster asset

    """

    def __init__(self):
        r"""
        :param ClusterId: Cluster ID
        :type ClusterId: str
        :param ClusterName: Cluster name
        :type ClusterName: str
        :param ClusterVersion: Cluster version
        :type ClusterVersion: str
        :param ClusterOs: Cluster OS
        :type ClusterOs: str
        :param ClusterType: Cluster type
        :type ClusterType: str
        :param ClusterNodeNum: Number of nodes in the cluster
        :type ClusterNodeNum: int
        :param Region: Cluster region
        :type Region: str
        :param DefenderStatus: Status of the monitoring component. Valid values: `Defender_Uninstall`, `Defender_Normal`, `Defender_Error`, `Defender_Installing`.
        :type DefenderStatus: str
        :param ClusterStatus: Cluster status
        :type ClusterStatus: str
        :param ClusterCheckMode: Cluster check mode. Valid values: `Cluster_Normal`, `Cluster_Actived`.
        :type ClusterCheckMode: str
        :param ClusterAutoCheck: Whether automatic and regular check is enabled
        :type ClusterAutoCheck: bool
        :param DefenderErrorReason: Cause of the failure to deploy the defender. When it is `UserDaemonSetNotReady`, `UnreadyNodeNum` is changed to "The defenders on N nodes are ready". If it is another value, the error message is directly displayed.
        :type DefenderErrorReason: str
        :param UnreadyNodeNum: Number of nodes where the defender is not ready
        :type UnreadyNodeNum: int
        :param SeriousRiskCount: Number of critical check items
        :type SeriousRiskCount: int
        :param HighRiskCount: Number of high-risk check items
        :type HighRiskCount: int
        :param MiddleRiskCount: Number of medium-risk check items
        :type MiddleRiskCount: int
        :param HintRiskCount: Number of prompt-risk check items
        :type HintRiskCount: int
        :param CheckFailReason: Check failure cause
        :type CheckFailReason: str
        :param CheckStatus: Check status. Valid values: `Task_Running`, `NoRisk`, `HasRisk`, `Uncheck`, `Task_Error`.
        :type CheckStatus: str
        :param TaskCreateTime: Task creation time and check time
        :type TaskCreateTime: str
        """
        self.ClusterId = None
        self.ClusterName = None
        self.ClusterVersion = None
        self.ClusterOs = None
        self.ClusterType = None
        self.ClusterNodeNum = None
        self.Region = None
        self.DefenderStatus = None
        self.ClusterStatus = None
        self.ClusterCheckMode = None
        self.ClusterAutoCheck = None
        self.DefenderErrorReason = None
        self.UnreadyNodeNum = None
        self.SeriousRiskCount = None
        self.HighRiskCount = None
        self.MiddleRiskCount = None
        self.HintRiskCount = None
        self.CheckFailReason = None
        self.CheckStatus = None
        self.TaskCreateTime = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        self.ClusterName = params.get("ClusterName")
        self.ClusterVersion = params.get("ClusterVersion")
        self.ClusterOs = params.get("ClusterOs")
        self.ClusterType = params.get("ClusterType")
        self.ClusterNodeNum = params.get("ClusterNodeNum")
        self.Region = params.get("Region")
        self.DefenderStatus = params.get("DefenderStatus")
        self.ClusterStatus = params.get("ClusterStatus")
        self.ClusterCheckMode = params.get("ClusterCheckMode")
        self.ClusterAutoCheck = params.get("ClusterAutoCheck")
        self.DefenderErrorReason = params.get("DefenderErrorReason")
        self.UnreadyNodeNum = params.get("UnreadyNodeNum")
        self.SeriousRiskCount = params.get("SeriousRiskCount")
        self.HighRiskCount = params.get("HighRiskCount")
        self.MiddleRiskCount = params.get("MiddleRiskCount")
        self.HintRiskCount = params.get("HintRiskCount")
        self.CheckFailReason = params.get("CheckFailReason")
        self.CheckStatus = params.get("CheckStatus")
        self.TaskCreateTime = params.get("TaskCreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterRiskItem(AbstractModel):
    """A risk item is a check item with an issue found in the check, with certain information of the check result.

    """

    def __init__(self):
        r"""
        :param CheckItem: Check item information
        :type CheckItem: :class:`tencentcloud.tcss.v20201101.models.ClusterCheckItem`
        :param VerifyInfo: Verification information
        :type VerifyInfo: str
        :param ErrorMessage: Event description and check error message
        :type ErrorMessage: str
        :param AffectedClusterCount: Number of affected clusters
        :type AffectedClusterCount: int
        :param AffectedNodeCount: Number of affected nodes
        :type AffectedNodeCount: int
        """
        self.CheckItem = None
        self.VerifyInfo = None
        self.ErrorMessage = None
        self.AffectedClusterCount = None
        self.AffectedNodeCount = None


    def _deserialize(self, params):
        if params.get("CheckItem") is not None:
            self.CheckItem = ClusterCheckItem()
            self.CheckItem._deserialize(params.get("CheckItem"))
        self.VerifyInfo = params.get("VerifyInfo")
        self.ErrorMessage = params.get("ErrorMessage")
        self.AffectedClusterCount = params.get("AffectedClusterCount")
        self.AffectedNodeCount = params.get("AffectedNodeCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceAffectedAsset(AbstractModel):
    """Information of the asset affected by the check item

    """

    def __init__(self):
        r"""
        :param CustomerAssetId: Unique ID of the customer asset
        :type CustomerAssetId: int
        :param AssetName: Asset name
        :type AssetName: str
        :param AssetType: Asset type
        :type AssetType: str
        :param CheckStatus: Check status

`CHECK_INIT`: To be checked.

`CHECK_RUNNING`: Checking.

`CHECK_FINISHED`: Checked.

`CHECK_FAILED`: Check failed.
        :type CheckStatus: str
        :param NodeName: Node name
        :type NodeName: str
        :param LastCheckTime: Last check time in the format of "YYYY-MM-DD HH:m::SS"

It is "0000-00-00 00:00:00" if no check has been performed.
        :type LastCheckTime: str
        :param CheckResult: Check result. Valid values:

`RESULT_FAILED`: Failed.

`RESULT_PASSED`: Passed.
        :type CheckResult: str
        :param HostIP: Server IP
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostIP: str
        :param ImageTag: Image tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageTag: str
        :param VerifyInfo: Verification information of the check item
Note: This field may return null, indicating that no valid values can be obtained.
        :type VerifyInfo: str
        :param InstanceId: Instance ID
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type InstanceId: str
        """
        self.CustomerAssetId = None
        self.AssetName = None
        self.AssetType = None
        self.CheckStatus = None
        self.NodeName = None
        self.LastCheckTime = None
        self.CheckResult = None
        self.HostIP = None
        self.ImageTag = None
        self.VerifyInfo = None
        self.InstanceId = None


    def _deserialize(self, params):
        self.CustomerAssetId = params.get("CustomerAssetId")
        self.AssetName = params.get("AssetName")
        self.AssetType = params.get("AssetType")
        self.CheckStatus = params.get("CheckStatus")
        self.NodeName = params.get("NodeName")
        self.LastCheckTime = params.get("LastCheckTime")
        self.CheckResult = params.get("CheckResult")
        self.HostIP = params.get("HostIP")
        self.ImageTag = params.get("ImageTag")
        self.VerifyInfo = params.get("VerifyInfo")
        self.InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceAssetDetailInfo(AbstractModel):
    """Asset details

    """

    def __init__(self):
        r"""
        :param CustomerAssetId: Customer asset ID
        :type CustomerAssetId: int
        :param AssetType: Asset type
        :type AssetType: str
        :param AssetName: Asset name
        :type AssetName: str
        :param NodeName: Node name of the asset
        :type NodeName: str
        :param HostName: Server name of the asset
        :type HostName: str
        :param HostIP: Server IP of the asset
        :type HostIP: str
        :param CheckStatus: Check status
`CHECK_INIT`: To be checked.
`CHECK_RUNNING`: Checking.
`CHECK_FINISHED`: Checked.
`CHECK_FAILED`: Check failed.
        :type CheckStatus: str
        :param PassedPolicyItemCount: Number of check items that the asset passed
        :type PassedPolicyItemCount: int
        :param FailedPolicyItemCount: Number of check items that the asset failed
        :type FailedPolicyItemCount: int
        :param LastCheckTime: Last check time
Note: This field may return null, indicating that no valid values can be obtained.
        :type LastCheckTime: str
        :param CheckResult: Check result. Valid values:
`RESULT_FAILED`: Failed.
`RESULT_PASSED`: Passed.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CheckResult: str
        :param AssetStatus: Asset status
        :type AssetStatus: str
        :param AssetCreateTime: Asset creation time
`ASSET_NORMAL`: Running.
`ASSET_PAUSED`: Suspended.
`ASSET_STOPPED`: Stopped.
`ASSET_ABNORMAL`: Abnormal.
        :type AssetCreateTime: str
        """
        self.CustomerAssetId = None
        self.AssetType = None
        self.AssetName = None
        self.NodeName = None
        self.HostName = None
        self.HostIP = None
        self.CheckStatus = None
        self.PassedPolicyItemCount = None
        self.FailedPolicyItemCount = None
        self.LastCheckTime = None
        self.CheckResult = None
        self.AssetStatus = None
        self.AssetCreateTime = None


    def _deserialize(self, params):
        self.CustomerAssetId = params.get("CustomerAssetId")
        self.AssetType = params.get("AssetType")
        self.AssetName = params.get("AssetName")
        self.NodeName = params.get("NodeName")
        self.HostName = params.get("HostName")
        self.HostIP = params.get("HostIP")
        self.CheckStatus = params.get("CheckStatus")
        self.PassedPolicyItemCount = params.get("PassedPolicyItemCount")
        self.FailedPolicyItemCount = params.get("FailedPolicyItemCount")
        self.LastCheckTime = params.get("LastCheckTime")
        self.CheckResult = params.get("CheckResult")
        self.AssetStatus = params.get("AssetStatus")
        self.AssetCreateTime = params.get("AssetCreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceAssetInfo(AbstractModel):
    """Asset information

    """

    def __init__(self):
        r"""
        :param CustomerAssetId: Customer asset ID
        :type CustomerAssetId: int
        :param AssetType: Asset type
        :type AssetType: str
        :param AssetName: Asset name
        :type AssetName: str
        :param ImageTag: This field is the image tag when the asset is an image.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageTag: str
        :param HostIP: Server IP of the asset
        :type HostIP: str
        :param NodeName: Node name of the asset
        :type NodeName: str
        :param CheckStatus: Check status

`CHECK_INIT`: To be checked.

`CHECK_RUNNING`: Checking.

`CHECK_FINISHED`: Checked.

`CHECK_FAILED`: Check failed.
        :type CheckStatus: str
        :param PassedPolicyItemCount: Number of check items that the asset passed
Note: This field may return null, indicating that no valid values can be obtained.
        :type PassedPolicyItemCount: int
        :param FailedPolicyItemCount: Number of check items that the asset failed
Note: This field may return null, indicating that no valid values can be obtained.
        :type FailedPolicyItemCount: int
        :param LastCheckTime: Last check time
Note: This field may return null, indicating that no valid values can be obtained.
        :type LastCheckTime: str
        :param CheckResult: Check result. Valid values:
`RESULT_FAILED`: Failed.
`RESULT_PASSED`: Passed.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CheckResult: str
        :param InstanceId: Node instance ID
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type InstanceId: str
        """
        self.CustomerAssetId = None
        self.AssetType = None
        self.AssetName = None
        self.ImageTag = None
        self.HostIP = None
        self.NodeName = None
        self.CheckStatus = None
        self.PassedPolicyItemCount = None
        self.FailedPolicyItemCount = None
        self.LastCheckTime = None
        self.CheckResult = None
        self.InstanceId = None


    def _deserialize(self, params):
        self.CustomerAssetId = params.get("CustomerAssetId")
        self.AssetType = params.get("AssetType")
        self.AssetName = params.get("AssetName")
        self.ImageTag = params.get("ImageTag")
        self.HostIP = params.get("HostIP")
        self.NodeName = params.get("NodeName")
        self.CheckStatus = params.get("CheckStatus")
        self.PassedPolicyItemCount = params.get("PassedPolicyItemCount")
        self.FailedPolicyItemCount = params.get("FailedPolicyItemCount")
        self.LastCheckTime = params.get("LastCheckTime")
        self.CheckResult = params.get("CheckResult")
        self.InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceAssetPolicyItem(AbstractModel):
    """Information of a check item

    """

    def __init__(self):
        r"""
        :param CustomerPolicyItemId: Unique ID of the customer check item
        :type CustomerPolicyItemId: int
        :param BasePolicyItemId: Original ID of the check item
        :type BasePolicyItemId: int
        :param Name: Check item name
        :type Name: str
        :param Category: Category of the check item
        :type Category: str
        :param BenchmarkStandardId: Compliance standard ID
        :type BenchmarkStandardId: int
        :param BenchmarkStandardName: Compliance standard name
        :type BenchmarkStandardName: str
        :param RiskLevel: Severity
        :type RiskLevel: str
        :param CheckStatus: Check status
`CHECK_INIT`: To be checked.
`CHECK_RUNNING`: Checking.
`CHECK_FINISHED`: Checked.
`CHECK_FAILED`: Check failed.
        :type CheckStatus: str
        :param CheckResult: Check result
`RESULT_PASSED`: Passed.
`RESULT_FAILED`: Failed.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CheckResult: str
        :param WhitelistId: Allowed item ID of the check item. If it exists and is not `0`, the check item is ignored.
Note: This field may return null, indicating that no valid values can be obtained.
        :type WhitelistId: int
        :param FixSuggestion: Handling suggestion
        :type FixSuggestion: str
        :param LastCheckTime: Last check time
Note: This field may return null, indicating that no valid values can be obtained.
        :type LastCheckTime: str
        :param VerifyInfo: Verification information
Note: This field may return null, indicating that no valid values can be obtained.
        :type VerifyInfo: str
        """
        self.CustomerPolicyItemId = None
        self.BasePolicyItemId = None
        self.Name = None
        self.Category = None
        self.BenchmarkStandardId = None
        self.BenchmarkStandardName = None
        self.RiskLevel = None
        self.CheckStatus = None
        self.CheckResult = None
        self.WhitelistId = None
        self.FixSuggestion = None
        self.LastCheckTime = None
        self.VerifyInfo = None


    def _deserialize(self, params):
        self.CustomerPolicyItemId = params.get("CustomerPolicyItemId")
        self.BasePolicyItemId = params.get("BasePolicyItemId")
        self.Name = params.get("Name")
        self.Category = params.get("Category")
        self.BenchmarkStandardId = params.get("BenchmarkStandardId")
        self.BenchmarkStandardName = params.get("BenchmarkStandardName")
        self.RiskLevel = params.get("RiskLevel")
        self.CheckStatus = params.get("CheckStatus")
        self.CheckResult = params.get("CheckResult")
        self.WhitelistId = params.get("WhitelistId")
        self.FixSuggestion = params.get("FixSuggestion")
        self.LastCheckTime = params.get("LastCheckTime")
        self.VerifyInfo = params.get("VerifyInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceAssetPolicySetItem(AbstractModel):
    """List of asset IDs and check item IDs

    """

    def __init__(self):
        r"""
        :param CustomerAssetItemId: Asset ID
        :type CustomerAssetItemId: int
        :param CustomerPolicyItemIdSet: List of IDs of check items to be ignored in the specified asset. If it is empty, it indicates all.
        :type CustomerPolicyItemIdSet: list of int non-negative
        """
        self.CustomerAssetItemId = None
        self.CustomerPolicyItemIdSet = None


    def _deserialize(self, params):
        self.CustomerAssetItemId = params.get("CustomerAssetItemId")
        self.CustomerPolicyItemIdSet = params.get("CustomerPolicyItemIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceAssetSummary(AbstractModel):
    """Asset overview

    """

    def __init__(self):
        r"""
        :param AssetType: Asset type
        :type AssetType: str
        :param IsCustomerFirstCheck: Whether it is the first check. This parameter is used together with `CheckStatus`.
        :type IsCustomerFirstCheck: bool
        :param CheckStatus: Check status

`CHECK_UNINIT`: Feature not enabled.

`CHECK_INIT`: To be checked.

`CHECK_RUNNING`: Checking.

`CHECK_FINISHED`: Checked.

`CHECK_FAILED`: Check failed.
        :type CheckStatus: str
        :param CheckProgress: Check progress. Value range: 0-100. This field is valid only if the check is running.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CheckProgress: float
        :param PassedPolicyItemCount: Number of check items that the asset passed
        :type PassedPolicyItemCount: int
        :param FailedPolicyItemCount: Number of check items that the asset failed
        :type FailedPolicyItemCount: int
        :param FailedCriticalPolicyItemCount: Number of critical check items that the asset failed
        :type FailedCriticalPolicyItemCount: int
        :param FailedHighRiskPolicyItemCount: Number of high-risk check items that the asset failed
        :type FailedHighRiskPolicyItemCount: int
        :param FailedMediumRiskPolicyItemCount: Number of medium-risk check items that the asset failed
        :type FailedMediumRiskPolicyItemCount: int
        :param FailedLowRiskPolicyItemCount: Number of low-risk check items that the asset failed
        :type FailedLowRiskPolicyItemCount: int
        :param NoticePolicyItemCount: Number of prompt check items of the asset
        :type NoticePolicyItemCount: int
        :param PassedAssetCount: Number of assets that passed the check
        :type PassedAssetCount: int
        :param FailedAssetCount: Number of assets that failed the check
        :type FailedAssetCount: int
        :param AssetPassedRate: Asset compliance rate. Value range: 0-100.
        :type AssetPassedRate: float
        :param ScanFailedAssetCount: Number of assets that failed the check
        :type ScanFailedAssetCount: int
        :param CheckCostTime: Last check duration in seconds
Note: This field may return null, indicating that no valid values can be obtained.
        :type CheckCostTime: float
        :param LastCheckTime: Last check time
Note: This field may return null, indicating that no valid values can be obtained.
        :type LastCheckTime: str
        :param PeriodRule: Scheduled check rule
        :type PeriodRule: :class:`tencentcloud.tcss.v20201101.models.CompliancePeriodTaskRule`
        :param OpenPolicyItemCount: Total number of enabled check items
Note: This field may return null, indicating that no valid values can be obtained.
        :type OpenPolicyItemCount: int
        :param IgnoredPolicyItemCount: Total number of ignored check items
Note: This field may return null, indicating that no valid values can be obtained.
        :type IgnoredPolicyItemCount: int
        """
        self.AssetType = None
        self.IsCustomerFirstCheck = None
        self.CheckStatus = None
        self.CheckProgress = None
        self.PassedPolicyItemCount = None
        self.FailedPolicyItemCount = None
        self.FailedCriticalPolicyItemCount = None
        self.FailedHighRiskPolicyItemCount = None
        self.FailedMediumRiskPolicyItemCount = None
        self.FailedLowRiskPolicyItemCount = None
        self.NoticePolicyItemCount = None
        self.PassedAssetCount = None
        self.FailedAssetCount = None
        self.AssetPassedRate = None
        self.ScanFailedAssetCount = None
        self.CheckCostTime = None
        self.LastCheckTime = None
        self.PeriodRule = None
        self.OpenPolicyItemCount = None
        self.IgnoredPolicyItemCount = None


    def _deserialize(self, params):
        self.AssetType = params.get("AssetType")
        self.IsCustomerFirstCheck = params.get("IsCustomerFirstCheck")
        self.CheckStatus = params.get("CheckStatus")
        self.CheckProgress = params.get("CheckProgress")
        self.PassedPolicyItemCount = params.get("PassedPolicyItemCount")
        self.FailedPolicyItemCount = params.get("FailedPolicyItemCount")
        self.FailedCriticalPolicyItemCount = params.get("FailedCriticalPolicyItemCount")
        self.FailedHighRiskPolicyItemCount = params.get("FailedHighRiskPolicyItemCount")
        self.FailedMediumRiskPolicyItemCount = params.get("FailedMediumRiskPolicyItemCount")
        self.FailedLowRiskPolicyItemCount = params.get("FailedLowRiskPolicyItemCount")
        self.NoticePolicyItemCount = params.get("NoticePolicyItemCount")
        self.PassedAssetCount = params.get("PassedAssetCount")
        self.FailedAssetCount = params.get("FailedAssetCount")
        self.AssetPassedRate = params.get("AssetPassedRate")
        self.ScanFailedAssetCount = params.get("ScanFailedAssetCount")
        self.CheckCostTime = params.get("CheckCostTime")
        self.LastCheckTime = params.get("LastCheckTime")
        if params.get("PeriodRule") is not None:
            self.PeriodRule = CompliancePeriodTaskRule()
            self.PeriodRule._deserialize(params.get("PeriodRule"))
        self.OpenPolicyItemCount = params.get("OpenPolicyItemCount")
        self.IgnoredPolicyItemCount = params.get("IgnoredPolicyItemCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceBenchmarkStandard(AbstractModel):
    """Information of a compliance standard

    """

    def __init__(self):
        r"""
        :param StandardId: Compliance standard ID
        :type StandardId: int
        :param Name: Compliance standard name
        :type Name: str
        :param PolicyItemCount: Number of items contained in the compliance standard
        :type PolicyItemCount: int
        :param Enabled: Whether to enable the standard
        :type Enabled: bool
        :param Description: Description of the standard
        :type Description: str
        """
        self.StandardId = None
        self.Name = None
        self.PolicyItemCount = None
        self.Enabled = None
        self.Description = None


    def _deserialize(self, params):
        self.StandardId = params.get("StandardId")
        self.Name = params.get("Name")
        self.PolicyItemCount = params.get("PolicyItemCount")
        self.Enabled = params.get("Enabled")
        self.Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceBenchmarkStandardEnable(AbstractModel):
    """Whether to enable the compliance standard

    """

    def __init__(self):
        r"""
        :param StandardId: Compliance standard ID
        :type StandardId: int
        :param Enable: Whether to enable the compliance standard
        :type Enable: bool
        """
        self.StandardId = None
        self.Enable = None


    def _deserialize(self, params):
        self.StandardId = params.get("StandardId")
        self.Enable = params.get("Enable")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceContainerDetailInfo(AbstractModel):
    """Container asset details

    """

    def __init__(self):
        r"""
        :param ContainerId: Container ID on the server
        :type ContainerId: str
        :param PodName: Pod name of the container
Note: This field may return null, indicating that no valid values can be obtained.
        :type PodName: str
        """
        self.ContainerId = None
        self.PodName = None


    def _deserialize(self, params):
        self.ContainerId = params.get("ContainerId")
        self.PodName = params.get("PodName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceFilters(AbstractModel):
    """Key-value pair filter for conditional filtering queries, such as filter ID, name, and status. If more than one filter exists, the logical relationship between these filters is `AND`. If multiple values exist in one filter, the logical relationship between these values is `OR`.

    """

    def __init__(self):
        r"""
        :param Name: Filter name
        :type Name: str
        :param Values: One or more filter values
        :type Values: list of str
        :param ExactMatch: Whether to use fuzzy query. Default value: `true`.
        :type ExactMatch: bool
        """
        self.Name = None
        self.Values = None
        self.ExactMatch = None


    def _deserialize(self, params):
        self.Name = params.get("Name")
        self.Values = params.get("Values")
        self.ExactMatch = params.get("ExactMatch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceHostDetailInfo(AbstractModel):
    """Server asset details

    """

    def __init__(self):
        r"""
        :param DockerVersion: Docker version on the server
Note: This field may return null, indicating that no valid values can be obtained.
        :type DockerVersion: str
        :param K8SVersion: K8s version on the server
Note: This field may return null, indicating that no valid values can be obtained.
        :type K8SVersion: str
        """
        self.DockerVersion = None
        self.K8SVersion = None


    def _deserialize(self, params):
        self.DockerVersion = params.get("DockerVersion")
        self.K8SVersion = params.get("K8SVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceImageDetailInfo(AbstractModel):
    """Image asset details

    """

    def __init__(self):
        r"""
        :param ImageId: Image ID on the server
        :type ImageId: str
        :param ImageName: Image name
        :type ImageName: str
        :param ImageTag: Image tag
        :type ImageTag: str
        :param Repository: Path of the remote repository of the image
Note: This field may return null, indicating that no valid values can be obtained.
        :type Repository: str
        """
        self.ImageId = None
        self.ImageName = None
        self.ImageTag = None
        self.Repository = None


    def _deserialize(self, params):
        self.ImageId = params.get("ImageId")
        self.ImageName = params.get("ImageName")
        self.ImageTag = params.get("ImageTag")
        self.Repository = params.get("Repository")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceK8SDetailInfo(AbstractModel):
    """K8s asset details

    """

    def __init__(self):
        r"""
        :param ClusterName: K8s cluster name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ClusterName: str
        :param ClusterVersion: K8s cluster version
Note: This field may return null, indicating that no valid values can be obtained.
        :type ClusterVersion: str
        """
        self.ClusterName = None
        self.ClusterVersion = None


    def _deserialize(self, params):
        self.ClusterName = params.get("ClusterName")
        self.ClusterVersion = params.get("ClusterVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompliancePeriodTask(AbstractModel):
    """Information of a scheduled task of the compliance baseline check

    """

    def __init__(self):
        r"""
        :param PeriodTaskId: Scheduled task ID
        :type PeriodTaskId: int
        :param AssetType: Asset type
`ASSET_CONTAINER`: Container.
`ASSET_IMAGE`: Image.
`ASSET_HOST`: Server.
`ASSET_K8S`: K8s asset.
        :type AssetType: str
        :param LastTriggerTime: Last trigger time
Note: This field may return null, indicating that no valid values can be obtained.
        :type LastTriggerTime: str
        :param TotalPolicyItemCount: Total number of check items
        :type TotalPolicyItemCount: int
        :param PeriodRule: Cycle settings
        :type PeriodRule: :class:`tencentcloud.tcss.v20201101.models.CompliancePeriodTaskRule`
        :param BenchmarkStandardSet: List of compliance standards
        :type BenchmarkStandardSet: list of ComplianceBenchmarkStandard
        """
        self.PeriodTaskId = None
        self.AssetType = None
        self.LastTriggerTime = None
        self.TotalPolicyItemCount = None
        self.PeriodRule = None
        self.BenchmarkStandardSet = None


    def _deserialize(self, params):
        self.PeriodTaskId = params.get("PeriodTaskId")
        self.AssetType = params.get("AssetType")
        self.LastTriggerTime = params.get("LastTriggerTime")
        self.TotalPolicyItemCount = params.get("TotalPolicyItemCount")
        if params.get("PeriodRule") is not None:
            self.PeriodRule = CompliancePeriodTaskRule()
            self.PeriodRule._deserialize(params.get("PeriodRule"))
        if params.get("BenchmarkStandardSet") is not None:
            self.BenchmarkStandardSet = []
            for item in params.get("BenchmarkStandardSet"):
                obj = ComplianceBenchmarkStandard()
                obj._deserialize(item)
                self.BenchmarkStandardSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompliancePeriodTaskRule(AbstractModel):
    """Cycle of a scheduled task

    """

    def __init__(self):
        r"""
        :param Frequency: Execution frequency (days). Valid values: `1`, `3`, `7`.
        :type Frequency: int
        :param ExecutionTime: Execution time in the format of "HH:mm:SS"
        :type ExecutionTime: str
        :param Enable: Whether to enable
Note: This field may return null, indicating that no valid values can be obtained.
        :type Enable: bool
        """
        self.Frequency = None
        self.ExecutionTime = None
        self.Enable = None


    def _deserialize(self, params):
        self.Frequency = params.get("Frequency")
        self.ExecutionTime = params.get("ExecutionTime")
        self.Enable = params.get("Enable")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompliancePolicyAssetSetItem(AbstractModel):
    """List of check item IDs and asset IDs

    """

    def __init__(self):
        r"""
        :param CustomerPolicyItemId: Check item ID
        :type CustomerPolicyItemId: int
        :param CustomerAssetItemIdSet: List of IDs of assets to be ignored in the specified check item. If it is empty, it indicates all.
        :type CustomerAssetItemIdSet: list of int non-negative
        """
        self.CustomerPolicyItemId = None
        self.CustomerAssetItemIdSet = None


    def _deserialize(self, params):
        self.CustomerPolicyItemId = params.get("CustomerPolicyItemId")
        self.CustomerAssetItemIdSet = params.get("CustomerAssetItemIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompliancePolicyItemSummary(AbstractModel):
    """Aggregated information of a check item

    """

    def __init__(self):
        r"""
        :param CustomerPolicyItemId: Unique ID of the customer check item
        :type CustomerPolicyItemId: int
        :param BasePolicyItemId: Original ID of the check item
        :type BasePolicyItemId: int
        :param Name: Check item name
        :type Name: str
        :param Category: Category of the check item, which is an enumerated string.
        :type Category: str
        :param BenchmarkStandardName: Compliance standard
        :type BenchmarkStandardName: str
        :param RiskLevel: Severity. Valid values: `RISK_CRITICAL`, `RISK_HIGH`, `RISK_MEDIUM`, `RISK_LOW`, `RISK_NOTICE`.
        :type RiskLevel: str
        :param AssetType: Asset type of the check item
        :type AssetType: str
        :param LastCheckTime: Last check time
Note: This field may return null, indicating that no valid values can be obtained.
        :type LastCheckTime: str
        :param CheckStatus: Check status

`CHECK_INIT`: To be checked.

`CHECK_RUNNING`: Checking.

`CHECK_FINISHED`: Checked.

`CHECK_FAILED`: Check failed.
        :type CheckStatus: str
        :param CheckResult: Check result. Valid values: `RESULT_PASSED`: Passed.

`RESULT_FAILED`: Failed.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CheckResult: str
        :param PassedAssetCount: Number of assets that passed the check
Note: This field may return null, indicating that no valid values can be obtained.
        :type PassedAssetCount: int
        :param FailedAssetCount: Number of assets that failed the check
Note: This field may return null, indicating that no valid values can be obtained.
        :type FailedAssetCount: int
        :param WhitelistId: Allowed item ID of the check item. If it exists and is not `0`, the check item is ignored.
Note: This field may return null, indicating that no valid values can be obtained.
        :type WhitelistId: int
        :param FixSuggestion: Handling suggestion
        :type FixSuggestion: str
        :param BenchmarkStandardId: Compliance standard ID
        :type BenchmarkStandardId: int
        :param ApplicableVersion: TCSS editions that support this check item
Note: This field may return `null`, indicating that no valid value was found.
        :type ApplicableVersion: str
        """
        self.CustomerPolicyItemId = None
        self.BasePolicyItemId = None
        self.Name = None
        self.Category = None
        self.BenchmarkStandardName = None
        self.RiskLevel = None
        self.AssetType = None
        self.LastCheckTime = None
        self.CheckStatus = None
        self.CheckResult = None
        self.PassedAssetCount = None
        self.FailedAssetCount = None
        self.WhitelistId = None
        self.FixSuggestion = None
        self.BenchmarkStandardId = None
        self.ApplicableVersion = None


    def _deserialize(self, params):
        self.CustomerPolicyItemId = params.get("CustomerPolicyItemId")
        self.BasePolicyItemId = params.get("BasePolicyItemId")
        self.Name = params.get("Name")
        self.Category = params.get("Category")
        self.BenchmarkStandardName = params.get("BenchmarkStandardName")
        self.RiskLevel = params.get("RiskLevel")
        self.AssetType = params.get("AssetType")
        self.LastCheckTime = params.get("LastCheckTime")
        self.CheckStatus = params.get("CheckStatus")
        self.CheckResult = params.get("CheckResult")
        self.PassedAssetCount = params.get("PassedAssetCount")
        self.FailedAssetCount = params.get("FailedAssetCount")
        self.WhitelistId = params.get("WhitelistId")
        self.FixSuggestion = params.get("FixSuggestion")
        self.BenchmarkStandardId = params.get("BenchmarkStandardId")
        self.ApplicableVersion = params.get("ApplicableVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceScanFailedAsset(AbstractModel):
    """Information of the asset that failed the check

    """

    def __init__(self):
        r"""
        :param CustomerAssetId: Customer asset ID
        :type CustomerAssetId: int
        :param AssetType: Asset type
        :type AssetType: str
        :param CheckStatus: Check status
`CHECK_INIT`: To be checked.
`CHECK_RUNNING`: Checking.
`CHECK_FINISHED`: Checked.
`CHECK_FAILED`: Check failed.
        :type CheckStatus: str
        :param AssetName: Asset name
        :type AssetName: str
        :param FailureReason: Cause of the asset check failure
        :type FailureReason: str
        :param Suggestion: Suggestion for handling the check failure
        :type Suggestion: str
        :param CheckTime: Check time
        :type CheckTime: str
        """
        self.CustomerAssetId = None
        self.AssetType = None
        self.CheckStatus = None
        self.AssetName = None
        self.FailureReason = None
        self.Suggestion = None
        self.CheckTime = None


    def _deserialize(self, params):
        self.CustomerAssetId = params.get("CustomerAssetId")
        self.AssetType = params.get("AssetType")
        self.CheckStatus = params.get("CheckStatus")
        self.AssetName = params.get("AssetName")
        self.FailureReason = params.get("FailureReason")
        self.Suggestion = params.get("Suggestion")
        self.CheckTime = params.get("CheckTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceWhitelistItem(AbstractModel):
    """Allowed item

    """

    def __init__(self):
        r"""
        :param WhitelistItemId: Allowed item ID
        :type WhitelistItemId: int
        :param CustomerPolicyItemId: ID of the customer check item
        :type CustomerPolicyItemId: int
        :param Name: Check item name
        :type Name: str
        :param StandardName: Compliance standard name
        :type StandardName: str
        :param StandardId: Compliance standard ID
        :type StandardId: int
        :param AffectedAssetCount: Number of assets affected by the check item
        :type AffectedAssetCount: int
        :param LastUpdateTime: Last update time
        :type LastUpdateTime: str
        :param InsertTime: Allowed time
        :type InsertTime: str
        """
        self.WhitelistItemId = None
        self.CustomerPolicyItemId = None
        self.Name = None
        self.StandardName = None
        self.StandardId = None
        self.AffectedAssetCount = None
        self.LastUpdateTime = None
        self.InsertTime = None


    def _deserialize(self, params):
        self.WhitelistItemId = params.get("WhitelistItemId")
        self.CustomerPolicyItemId = params.get("CustomerPolicyItemId")
        self.Name = params.get("Name")
        self.StandardName = params.get("StandardName")
        self.StandardId = params.get("StandardId")
        self.AffectedAssetCount = params.get("AffectedAssetCount")
        self.LastUpdateTime = params.get("LastUpdateTime")
        self.InsertTime = params.get("InsertTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComponentInfo(AbstractModel):
    """Container component information

    """

    def __init__(self):
        r"""
        :param Name: Name
        :type Name: str
        :param Version: Version
        :type Version: str
        """
        self.Name = None
        self.Version = None


    def _deserialize(self, params):
        self.Name = params.get("Name")
        self.Version = params.get("Version")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComponentsInfo(AbstractModel):
    """Component information

    """

    def __init__(self):
        r"""
        :param Component: Component name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Component: str
        :param Version: Component version information
Note: This field may return null, indicating that no valid values can be obtained.
        :type Version: str
        """
        self.Component = None
        self.Version = None


    def _deserialize(self, params):
        self.Component = params.get("Component")
        self.Version = params.get("Version")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfirmNetworkFirewallPolicyRequest(AbstractModel):
    """ConfirmNetworkFirewallPolicy request structure.

    """

    def __init__(self):
        r"""
        :param ClusterId: Cluster ID
        :type ClusterId: str
        :param Id: Array of cluster IDs
        :type Id: list of int non-negative
        """
        self.ClusterId = None
        self.Id = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        self.Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfirmNetworkFirewallPolicyResponse(AbstractModel):
    """ConfirmNetworkFirewallPolicy response structure.

    """

    def __init__(self):
        r"""
        :param TaskId: ID of the created task. `0` indicates that the creation failed.
        :type TaskId: int
        :param Result: Result of creating the confirmation task. Valid values: `Succ`, `Failed`.
        :type Result: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskId = None
        self.Result = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.Result = params.get("Result")
        self.RequestId = params.get("RequestId")


class ContainerInfo(AbstractModel):
    """List of containers

    """

    def __init__(self):
        r"""
        :param ContainerID: Container ID
        :type ContainerID: str
        :param ContainerName: Container name
        :type ContainerName: str
        :param Status: Container status
        :type Status: str
        :param CreateTime: Creation time
        :type CreateTime: str
        :param RunAs: Operator
        :type RunAs: str
        :param Cmd: Command line
        :type Cmd: str
        :param CPUUsage: CPU utilization * 1000
        :type CPUUsage: int
        :param RamUsage: Memory usage in KB
        :type RamUsage: int
        :param ImageName: Image name
        :type ImageName: str
        :param ImageID: Image ID
        :type ImageID: str
        :param POD: Image ID
        :type POD: str
        :param HostID: Server ID
        :type HostID: str
        :param HostIP: Server IP
        :type HostIP: str
        :param UpdateTime: Update time
        :type UpdateTime: str
        :param HostName: Server name
        :type HostName: str
        :param PublicIp: Public IP
        :type PublicIp: str
        :param NetStatus: Network status
`NORMAL`: 	Not isolated.
`ISOLATED`: 		Isolated.
`ISOLATING`: 		Isolating.
`ISOLATE_FAILED`: 	Isolation failed.
`RESTORING`: Recovering.
`RESTORE_FAILED`: Recovery failed.
        :type NetStatus: str
        :param NetSubStatus: Sub-status of the network
        :type NetSubStatus: str
        :param IsolateSource: Isolation source
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsolateSource: str
        :param IsolateTime: Isolation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsolateTime: str
        """
        self.ContainerID = None
        self.ContainerName = None
        self.Status = None
        self.CreateTime = None
        self.RunAs = None
        self.Cmd = None
        self.CPUUsage = None
        self.RamUsage = None
        self.ImageName = None
        self.ImageID = None
        self.POD = None
        self.HostID = None
        self.HostIP = None
        self.UpdateTime = None
        self.HostName = None
        self.PublicIp = None
        self.NetStatus = None
        self.NetSubStatus = None
        self.IsolateSource = None
        self.IsolateTime = None


    def _deserialize(self, params):
        self.ContainerID = params.get("ContainerID")
        self.ContainerName = params.get("ContainerName")
        self.Status = params.get("Status")
        self.CreateTime = params.get("CreateTime")
        self.RunAs = params.get("RunAs")
        self.Cmd = params.get("Cmd")
        self.CPUUsage = params.get("CPUUsage")
        self.RamUsage = params.get("RamUsage")
        self.ImageName = params.get("ImageName")
        self.ImageID = params.get("ImageID")
        self.POD = params.get("POD")
        self.HostID = params.get("HostID")
        self.HostIP = params.get("HostIP")
        self.UpdateTime = params.get("UpdateTime")
        self.HostName = params.get("HostName")
        self.PublicIp = params.get("PublicIp")
        self.NetStatus = params.get("NetStatus")
        self.NetSubStatus = params.get("NetSubStatus")
        self.IsolateSource = params.get("IsolateSource")
        self.IsolateTime = params.get("IsolateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContainerMount(AbstractModel):
    """Container mount information

    """

    def __init__(self):
        r"""
        :param Type: Mount type: `bind`.
        :type Type: str
        :param Source: Host path
        :type Source: str
        :param Destination: Path in the container
        :type Destination: str
        :param Mode: Mode
        :type Mode: str
        :param RW: Read/Write permission
        :type RW: bool
        :param Propagation: Propagation type
        :type Propagation: str
        :param Name: Name
        :type Name: str
        :param Driver: Driver
        :type Driver: str
        """
        self.Type = None
        self.Source = None
        self.Destination = None
        self.Mode = None
        self.RW = None
        self.Propagation = None
        self.Name = None
        self.Driver = None


    def _deserialize(self, params):
        self.Type = params.get("Type")
        self.Source = params.get("Source")
        self.Destination = params.get("Destination")
        self.Mode = params.get("Mode")
        self.RW = params.get("RW")
        self.Propagation = params.get("Propagation")
        self.Name = params.get("Name")
        self.Driver = params.get("Driver")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContainerNetwork(AbstractModel):
    """Container network information

    """

    def __init__(self):
        r"""
        :param EndpointID: Endpoint ID
        :type EndpointID: str
        :param Mode: Mode: `bridge`.
        :type Mode: str
        :param Name: Network name
        :type Name: str
        :param NetworkID: Network ID
        :type NetworkID: str
        :param Gateway: Gateway
        :type Gateway: str
        :param Ipv4: IPv4 address
        :type Ipv4: str
        :param Ipv6: IPv6 address
        :type Ipv6: str
        :param MAC: MAC address
        :type MAC: str
        """
        self.EndpointID = None
        self.Mode = None
        self.Name = None
        self.NetworkID = None
        self.Gateway = None
        self.Ipv4 = None
        self.Ipv6 = None
        self.MAC = None


    def _deserialize(self, params):
        self.EndpointID = params.get("EndpointID")
        self.Mode = params.get("Mode")
        self.Name = params.get("Name")
        self.NetworkID = params.get("NetworkID")
        self.Gateway = params.get("Gateway")
        self.Ipv4 = params.get("Ipv4")
        self.Ipv6 = params.get("Ipv6")
        self.MAC = params.get("MAC")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAbnormalProcessRulesExportJobRequest(AbstractModel):
    """CreateAbnormalProcessRulesExportJob request structure.

    """

    def __init__(self):
        r"""
        :param Filters: Filter conditions
<li>`RuleType` - String  - Optional - Rule type</li>
<li>`Status` - String - Optional - Status</li>
        :type Filters: list of RunTimeFilters
        :param Order: Sorting order
        :type Order: str
        :param By: Sorting field
        :type By: str
        :param ExportField: Fields to export
        :type ExportField: list of str
        """
        self.Filters = None
        self.Order = None
        self.By = None
        self.ExportField = None


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        self.ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAbnormalProcessRulesExportJobResponse(AbstractModel):
    """CreateAbnormalProcessRulesExportJob response structure.

    """

    def __init__(self):
        r"""
        :param JobId: ID of the exportation task. You can query the task progress by using this ID in the console.
        :type JobId: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.JobId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.JobId = params.get("JobId")
        self.RequestId = params.get("RequestId")


class CreateAccessControlsRuleExportJobRequest(AbstractModel):
    """CreateAccessControlsRuleExportJob request structure.

    """

    def __init__(self):
        r"""
        :param Filters: Filter conditions
<li>`RuleType` - String  - Optional - Rule type</li>
<li>`Status` - String - Optional - Status</li>
        :type Filters: list of RunTimeFilters
        :param Order: Sorting order
        :type Order: str
        :param By: Sorting field
        :type By: list of str
        :param ExportField: Fields to export
        :type ExportField: list of str
        """
        self.Filters = None
        self.Order = None
        self.By = None
        self.ExportField = None


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        self.ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAccessControlsRuleExportJobResponse(AbstractModel):
    """CreateAccessControlsRuleExportJob response structure.

    """

    def __init__(self):
        r"""
        :param JobId: ID of the exportation task. You can query the task progress by using this ID in the console.
        :type JobId: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.JobId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.JobId = params.get("JobId")
        self.RequestId = params.get("RequestId")


class CreateAssetImageRegistryScanTaskOneKeyRequest(AbstractModel):
    """CreateAssetImageRegistryScanTaskOneKey request structure.

    """

    def __init__(self):
        r"""
        :param All: Whether to scan all images
        :type All: bool
        :param Images: List of scanned images
        :type Images: list of ImageInfo
        :param ScanType: Array of scan types
        :type ScanType: list of str
        :param Id: List of IDs of scanned images
        :type Id: list of int non-negative
        """
        self.All = None
        self.Images = None
        self.ScanType = None
        self.Id = None


    def _deserialize(self, params):
        self.All = params.get("All")
        if params.get("Images") is not None:
            self.Images = []
            for item in params.get("Images"):
                obj = ImageInfo()
                obj._deserialize(item)
                self.Images.append(obj)
        self.ScanType = params.get("ScanType")
        self.Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAssetImageRegistryScanTaskOneKeyResponse(AbstractModel):
    """CreateAssetImageRegistryScanTaskOneKey response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class CreateAssetImageRegistryScanTaskRequest(AbstractModel):
    """CreateAssetImageRegistryScanTask request structure.

    """

    def __init__(self):
        r"""
        :param All: Whether to scan all images
        :type All: bool
        :param Images: List of scanned images
        :type Images: list of ImageInfo
        :param ScanType: Array of scan types
        :type ScanType: list of str
        :param Id: List of scanned images
        :type Id: list of int non-negative
        :param Filters: Filter
        :type Filters: list of AssetFilters
        :param ExcludeImageList: List of images not to be scanned, which is used together with `Filters`.
        :type ExcludeImageList: list of int non-negative
        :param OnlyScanLatest: Whether to scan only the latest repository images, which is used together with `Filters`.
        :type OnlyScanLatest: bool
        """
        self.All = None
        self.Images = None
        self.ScanType = None
        self.Id = None
        self.Filters = None
        self.ExcludeImageList = None
        self.OnlyScanLatest = None


    def _deserialize(self, params):
        self.All = params.get("All")
        if params.get("Images") is not None:
            self.Images = []
            for item in params.get("Images"):
                obj = ImageInfo()
                obj._deserialize(item)
                self.Images.append(obj)
        self.ScanType = params.get("ScanType")
        self.Id = params.get("Id")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.ExcludeImageList = params.get("ExcludeImageList")
        self.OnlyScanLatest = params.get("OnlyScanLatest")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAssetImageRegistryScanTaskResponse(AbstractModel):
    """CreateAssetImageRegistryScanTask response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class CreateAssetImageScanSettingRequest(AbstractModel):
    """CreateAssetImageScanSetting request structure.

    """

    def __init__(self):
        r"""
        :param Enable: Switch
        :type Enable: bool
        :param ScanTime: Scan time
        :type ScanTime: str
        :param ScanPeriod: Scan cycle
        :type ScanPeriod: int
        :param ScanVirus: Trojan scan
        :type ScanVirus: bool
        :param ScanRisk: Sensitive data scan
        :type ScanRisk: bool
        :param ScanVul: Vulnerability scan
        :type ScanVul: bool
        :param All: All images
        :type All: bool
        :param Images: Custom image
        :type Images: list of str
        """
        self.Enable = None
        self.ScanTime = None
        self.ScanPeriod = None
        self.ScanVirus = None
        self.ScanRisk = None
        self.ScanVul = None
        self.All = None
        self.Images = None


    def _deserialize(self, params):
        self.Enable = params.get("Enable")
        self.ScanTime = params.get("ScanTime")
        self.ScanPeriod = params.get("ScanPeriod")
        self.ScanVirus = params.get("ScanVirus")
        self.ScanRisk = params.get("ScanRisk")
        self.ScanVul = params.get("ScanVul")
        self.All = params.get("All")
        self.Images = params.get("Images")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAssetImageScanSettingResponse(AbstractModel):
    """CreateAssetImageScanSetting response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class CreateAssetImageScanTaskRequest(AbstractModel):
    """CreateAssetImageScanTask request structure.

    """

    def __init__(self):
        r"""
        :param All: Whether to scan all images.
        :type All: bool
        :param Images: List of images to be scanned.
        :type Images: list of str
        :param ScanVul: Scan for vulnerabilities.
        :type ScanVul: bool
        :param ScanVirus: Scan for trojans.
        :type ScanVirus: bool
        :param ScanRisk: Scan for risks.
        :type ScanRisk: bool
        :param Filters: Filter
        :type Filters: list of AssetFilters
        :param ExcludeImageIds: Specified image IDs to be excluded
        :type ExcludeImageIds: list of str
        """
        self.All = None
        self.Images = None
        self.ScanVul = None
        self.ScanVirus = None
        self.ScanRisk = None
        self.Filters = None
        self.ExcludeImageIds = None


    def _deserialize(self, params):
        self.All = params.get("All")
        self.Images = params.get("Images")
        self.ScanVul = params.get("ScanVul")
        self.ScanVirus = params.get("ScanVirus")
        self.ScanRisk = params.get("ScanRisk")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.ExcludeImageIds = params.get("ExcludeImageIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAssetImageScanTaskResponse(AbstractModel):
    """CreateAssetImageScanTask response structure.

    """

    def __init__(self):
        r"""
        :param TaskID: Task ID
        :type TaskID: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskID = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskID = params.get("TaskID")
        self.RequestId = params.get("RequestId")


class CreateAssetImageVirusExportJobRequest(AbstractModel):
    """CreateAssetImageVirusExportJob request structure.

    """

    def __init__(self):
        r"""
        :param ExportField: Export field
        :type ExportField: list of str
        :param ImageID: Image ID
        :type ImageID: str
        :param Filters: Number of results to be returned. Default value: `10`. Maximum value: `10000`.
        :type Filters: list of AssetFilters
        :param Limit: Offset. Default value: `0`.
        :type Limit: int
        :param Offset: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Offset: int
        :param By: Sorting field
        :type By: str
        :param Order: Valid values: `asc`, `desc`.
        :type Order: str
        """
        self.ExportField = None
        self.ImageID = None
        self.Filters = None
        self.Limit = None
        self.Offset = None
        self.By = None
        self.Order = None


    def _deserialize(self, params):
        self.ExportField = params.get("ExportField")
        self.ImageID = params.get("ImageID")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        self.By = params.get("By")
        self.Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAssetImageVirusExportJobResponse(AbstractModel):
    """CreateAssetImageVirusExportJob response structure.

    """

    def __init__(self):
        r"""
        :param JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.JobId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.JobId = params.get("JobId")
        self.RequestId = params.get("RequestId")


class CreateCheckComponentRequest(AbstractModel):
    """CreateCheckComponent request structure.

    """

    def __init__(self):
        r"""
        :param ClusterInfoList: Information of the list of clusters for installation
        :type ClusterInfoList: list of ClusterCreateComponentItem
        """
        self.ClusterInfoList = None


    def _deserialize(self, params):
        if params.get("ClusterInfoList") is not None:
            self.ClusterInfoList = []
            for item in params.get("ClusterInfoList"):
                obj = ClusterCreateComponentItem()
                obj._deserialize(item)
                self.ClusterInfoList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCheckComponentResponse(AbstractModel):
    """CreateCheckComponent response structure.

    """

    def __init__(self):
        r"""
        :param InstallResult: Valid values: `InstallSucc` (installed successfully); `InstallFailed` (failed to install).
        :type InstallResult: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.InstallResult = None
        self.RequestId = None


    def _deserialize(self, params):
        self.InstallResult = params.get("InstallResult")
        self.RequestId = params.get("RequestId")


class CreateClusterCheckTaskRequest(AbstractModel):
    """CreateClusterCheckTask request structure.

    """

    def __init__(self):
        r"""
        :param ClusterCheckTaskList: Information of the specified cluster to be scanned
        :type ClusterCheckTaskList: list of ClusterCheckTaskItem
        """
        self.ClusterCheckTaskList = None


    def _deserialize(self, params):
        if params.get("ClusterCheckTaskList") is not None:
            self.ClusterCheckTaskList = []
            for item in params.get("ClusterCheckTaskList"):
                obj = ClusterCheckTaskItem()
                obj._deserialize(item)
                self.ClusterCheckTaskList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateClusterCheckTaskResponse(AbstractModel):
    """CreateClusterCheckTask response structure.

    """

    def __init__(self):
        r"""
        :param TaskId: ID of the created cluster check task. `0` indicates that the creation failed.
        :type TaskId: int
        :param CreateResult: Result of creating the check task. Valid values: `Succ` (success); others (failure cause).
        :type CreateResult: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskId = None
        self.CreateResult = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.CreateResult = params.get("CreateResult")
        self.RequestId = params.get("RequestId")


class CreateComplianceTaskRequest(AbstractModel):
    """CreateComplianceTask request structure.

    """

    def __init__(self):
        r"""
        :param AssetTypeSet: List of asset types to be scanned
`ASSET_CONTAINER`: Container.
`ASSET_IMAGE`: Image.
`ASSET_HOST`: Server.
`ASSET_K8S`: K8s asset.
A valid value must be entered for the `AssetTypeSet`, `PolicySetId`, or `PeriodTaskId` parameter.
        :type AssetTypeSet: list of str
        :param PolicySetId: Policy set ID
        :type PolicySetId: int
        :param PeriodTaskId: Scheduled task ID
        :type PeriodTaskId: int
        """
        self.AssetTypeSet = None
        self.PolicySetId = None
        self.PeriodTaskId = None


    def _deserialize(self, params):
        self.AssetTypeSet = params.get("AssetTypeSet")
        self.PolicySetId = params.get("PolicySetId")
        self.PeriodTaskId = params.get("PeriodTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateComplianceTaskResponse(AbstractModel):
    """CreateComplianceTask response structure.

    """

    def __init__(self):
        r"""
        :param TaskId: ID of the created compliance check task
        :type TaskId: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class CreateComponentExportJobRequest(AbstractModel):
    """CreateComponentExportJob request structure.

    """

    def __init__(self):
        r"""
        :param ImageID: Image ID
        :type ImageID: str
        :param ExportField: Export field
        :type ExportField: list of str
        :param Limit: Number of results to be returned. Default value: `10000`. Maximum value: `10000`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>ComponentName- String - Required: No - Image component name</li><li>ComponentVersion- String - Required: No - Image component version</li><li>ComponentType- String - Required: No - Image component type</li><li>VulLevel- String - Required: No - Vulnerability severity</li><li>HasVul- String - Required: No - Whether there is a vulnerability. Valid values: `true` (yes); `false` (no). If `ComponentName` is not passed in or is `ALL`, it indicates all.</li>
        :type Filters: list of AssetFilters
        :param By: Sorting field
        :type By: str
        :param Order: Sorting order. Valid values: `desc`, `asc`.
        :type Order: str
        """
        self.ImageID = None
        self.ExportField = None
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.By = None
        self.Order = None


    def _deserialize(self, params):
        self.ImageID = params.get("ImageID")
        self.ExportField = params.get("ExportField")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.By = params.get("By")
        self.Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateComponentExportJobResponse(AbstractModel):
    """CreateComponentExportJob response structure.

    """

    def __init__(self):
        r"""
        :param JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.JobId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.JobId = params.get("JobId")
        self.RequestId = params.get("RequestId")


class CreateDefenceVulExportJobRequest(AbstractModel):
    """CreateDefenceVulExportJob request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10000`. Maximum value: `10000`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>Level- String - Required: No - Severity. Valid values: `CRITICAL` (critical); `HIGH` (high); `MIDDLE` (medium); `LOW` (low).</li>
<li>CVEID- string - Required: No - CVE No.</li>
<li>Name- string - Required: No - Vulnerability name</li>
        :type Filters: list of RunTimeFilters
        :param Order: Sorting order
        :type Order: str
        :param By: Sorting field
        :type By: str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDefenceVulExportJobResponse(AbstractModel):
    """CreateDefenceVulExportJob response structure.

    """

    def __init__(self):
        r"""
        :param JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.JobId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.JobId = params.get("JobId")
        self.RequestId = params.get("RequestId")


class CreateEmergencyVulExportJobRequest(AbstractModel):
    """CreateEmergencyVulExportJob request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `50000`. Maximum value: `50000`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>Level- String - Required: No - Severity. Valid values: `CRITICAL` (critical); `HIGH` (high); `MIDDLE` (medium); `LOW` (low).</li>
<li>Tags- string - Required: No - Vulnerability tag. Valid values: `POC`, `EXP`.</li>
<li>CanBeFixed- string - Required: No - Whether the vulnerability can be fixed. Valid values: `true`, `false`.</li>
<li>CVEID- string - Required: No - CVE No.</li>
<li>ImageID- string - Required: No - Image ID</li>
<li>ImageName- String - Required: No - Image name</li>
<li>ContainerID- string - Required: No - Container ID</li>
<li>ContainerName- string - Required: No - Container name</li>
<li>ComponentName- string - Required: No - Component name</li>
<li>ComponentVersion- string - Required: No - Component version</li>
<li>Name- string - Required: No - Vulnerability name</li>
        :type Filters: list of RunTimeFilters
        :param Order: Sorting order
        :type Order: str
        :param By: Sorting field
        :type By: str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateEmergencyVulExportJobResponse(AbstractModel):
    """CreateEmergencyVulExportJob response structure.

    """

    def __init__(self):
        r"""
        :param JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.JobId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.JobId = params.get("JobId")
        self.RequestId = params.get("RequestId")


class CreateEscapeEventsExportJobRequest(AbstractModel):
    """CreateEscapeEventsExportJob request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Maximum value: `10000`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter parameter - status. Valid values: `EVENT_UNDEAL` (pending); `EVENT_DEALED` (processed); `EVENT_INGNORE` (ignored).
        :type Filters: list of RunTimeFilters
        :param Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param By: Sorting field: `latest_found_time`.
        :type By: str
        :param ExportField: Export field
        :type ExportField: list of str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None
        self.ExportField = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        self.ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateEscapeEventsExportJobResponse(AbstractModel):
    """CreateEscapeEventsExportJob response structure.

    """

    def __init__(self):
        r"""
        :param JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.JobId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.JobId = params.get("JobId")
        self.RequestId = params.get("RequestId")


class CreateEscapeWhiteListExportJobRequest(AbstractModel):
    """CreateEscapeWhiteListExportJob request structure.

    """

    def __init__(self):
        r"""
        :param Filters: Filter
<li>EventType- String - Required: No - Allowed event type. Valid values: `ESCAPE_CGROUPS` (cgroup escape); `ESCAPE_TAMPER_SENSITIVE_FILE` (file tamper escape); `ESCAPE_DOCKER_API` (Docker API access escape); `ESCAPE_VUL_OCCURRED` (vulnerability exploit); `MOUNT_SENSITIVE_PTAH` (sensitive path mount); `PRIVILEGE_CONTAINER_START` (privileged container); `PRIVILEGE` (program privilege escalation escape).</li>
<li>ImageName- string - Required: No - Image name</li>
<li>ImageID- string - Required: No - Image ID</li>
        :type Filters: list of RunTimeFilters
        :param Limit: Number of results to be returned. Default value: `10000`. Maximum value: `10000`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        :param By: Sorting field. Valid values: `HostCount` (number of servers); `ContainerCount` (number of containers); `UpdateTime` (update time).
        :type By: str
        """
        self.Filters = None
        self.Limit = None
        self.Offset = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateEscapeWhiteListExportJobResponse(AbstractModel):
    """CreateEscapeWhiteListExportJob response structure.

    """

    def __init__(self):
        r"""
        :param JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.JobId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.JobId = params.get("JobId")
        self.RequestId = params.get("RequestId")


class CreateExportComplianceStatusListJobRequest(AbstractModel):
    """CreateExportComplianceStatusListJob request structure.

    """

    def __init__(self):
        r"""
        :param AssetType: Asset type of the information to be exported
        :type AssetType: str
        :param ExportByAsset: Export by check item or asset. Valid values: `true` (export by asset); `false` (export by check item).
        :type ExportByAsset: bool
        :param ExportAll: Valid values: `true` (export all); `false` (export based on the `IdList`).
        :type ExportAll: bool
        :param IdList: List of IDs of assets or check items to be exported, which is determined by the value of `ExportByAsset`.
        :type IdList: list of int non-negative
        """
        self.AssetType = None
        self.ExportByAsset = None
        self.ExportAll = None
        self.IdList = None


    def _deserialize(self, params):
        self.AssetType = params.get("AssetType")
        self.ExportByAsset = params.get("ExportByAsset")
        self.ExportAll = params.get("ExportAll")
        self.IdList = params.get("IdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateExportComplianceStatusListJobResponse(AbstractModel):
    """CreateExportComplianceStatusListJob response structure.

    """

    def __init__(self):
        r"""
        :param JobId: ID of the created export task
Note: This field may return null, indicating that no valid values can be obtained.
        :type JobId: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.JobId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.JobId = params.get("JobId")
        self.RequestId = params.get("RequestId")


class CreateHostExportJobRequest(AbstractModel):
    """CreateHostExportJob request structure.

    """

    def __init__(self):
        r"""
        :param Filters: Filters.
<li>`Status` - String - Optional - Agent status. Values: `ALL`; `UNINSTALL` (Not installed); `OFFLINE`, `ONLINE`. Default to `All` if it's not specified. </li>
<li>`HostName` - String - Optional - Server name</li>
<li>`Group - String - Optional - Server group</li>
<li>`HostIP` - String - Optional - Server IP</li>
<li>`HostID - String - Optional - Server ID</li>
<li>`DockerVersion` - String - Optional - Docker version</li>
<li>`MachineType` - String - Optional - Server type. Values: `ALL`; `CVM` (Cloud Virtual Machine); `ECM` (Edge Computing Machine); `LH` (Lighthouse), `BM` (Cloud Bare Metal); `Other` (non-Tencent Cloud server). Default to `ALL` if it's not specified.</li>
<li>`DockerStatus` - String - Optional - Docker installation status. Values: `ALL`; `INSTALL` (Installed); `UNINSTALL` (Not installed)</li>
<li>`ProjectID` - String - Optional - Project ID</li>
<li>`Tag:xxx(tag:key)` - String - Optional - Tag key-value pair; Example: `Filters":[{"Name":"tag:tke-kind","Values":["service"]}]`</li>
        :type Filters: list of AssetFilters
        :param Limit: Offset. Default value: `0`.
        :type Limit: int
        :param Offset: The number of results to return. Default value: 10. Maximum value: 10,000.
        :type Offset: int
        :param By: Sorting field
        :type By: str
        :param Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param ExportField: Export field
        :type ExportField: list of str
        """
        self.Filters = None
        self.Limit = None
        self.Offset = None
        self.By = None
        self.Order = None
        self.ExportField = None


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        self.By = params.get("By")
        self.Order = params.get("Order")
        self.ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateHostExportJobResponse(AbstractModel):
    """CreateHostExportJob response structure.

    """

    def __init__(self):
        r"""
        :param JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.JobId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.JobId = params.get("JobId")
        self.RequestId = params.get("RequestId")


class CreateImageExportJobRequest(AbstractModel):
    """CreateImageExportJob request structure.

    """

    def __init__(self):
        r"""
        :param Filters: Filter
<li>ImageName- String - Required: No - Image name</li>
<li>ScanStatus - String - Required: No - Image scanning status. Valid values: `notScan`, `scanning`, `scanned`, `scanErr`.</li>
<li>ImageID- String - Required: No - Image ID</li>
<li>SecurityRisk- String - Required: No - Security risks. Valid values: `VulCnt`, `VirusCnt`, `RiskCnt`, `IsTrustImage`.</li>
        :type Filters: list of RunTimeFilters
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param By: Sorting field
        :type By: str
        :param Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        :param ExportField: Export field
        :type ExportField: list of str
        """
        self.Filters = None
        self.Offset = None
        self.Limit = None
        self.By = None
        self.Order = None
        self.ExportField = None


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        self.By = params.get("By")
        self.Order = params.get("Order")
        self.ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateImageExportJobResponse(AbstractModel):
    """CreateImageExportJob response structure.

    """

    def __init__(self):
        r"""
        :param JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param DownloadUrl: Excel file download URL
        :type DownloadUrl: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.JobId = None
        self.DownloadUrl = None
        self.RequestId = None


    def _deserialize(self, params):
        self.JobId = params.get("JobId")
        self.DownloadUrl = params.get("DownloadUrl")
        self.RequestId = params.get("RequestId")


class CreateK8sApiAbnormalEventExportJobRequest(AbstractModel):
    """CreateK8sApiAbnormalEventExportJob request structure.

    """

    def __init__(self):
        r"""
        :param Filters: Filters.
<li>TimeRange - String - Optional - Time range. Example: ["2022-03-31 16:55:00", "2022-03-31 17:00:00"]</li>
<li>`MatchRules` - String - Optional - Hit rule</li>
<li>`RiskLevel` - String - Optional - Threat level</li>
<li>`Status` - String - Optional - Event status</li>
<li>`MatchRuleType` - String - Optional - Hit rule type</li>
<li>`ClusterRunningStatus` - String - Optional - Cluster running status</li>
<li>`ClusterName` - String - Optional - Cluster name</li>
<li>`ClusterID` - String - Optional - Cluster ID</li>
        :type Filters: list of RunTimeFilters
        :param Order: Sort order
        :type Order: str
        :param By: Sorting field
        :type By: str
        :param ExportField: Export field
        :type ExportField: list of str
        """
        self.Filters = None
        self.Order = None
        self.By = None
        self.ExportField = None


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        self.ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateK8sApiAbnormalEventExportJobResponse(AbstractModel):
    """CreateK8sApiAbnormalEventExportJob response structure.

    """

    def __init__(self):
        r"""
        :param JobId: ID of the exportation job. You can query the job progress by using this ID on the console.
        :type JobId: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.JobId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.JobId = params.get("JobId")
        self.RequestId = params.get("RequestId")


class CreateK8sApiAbnormalRuleExportJobRequest(AbstractModel):
    """CreateK8sApiAbnormalRuleExportJob request structure.

    """

    def __init__(self):
        r"""
        :param Filters: Filters.
<li>`RuleType` - String - Optional - Rule type</li>
<li>`Status` - String - Optional - Status</li>
        :type Filters: list of RunTimeFilters
        :param Order: Sort order
        :type Order: str
        :param By: Sorting field
        :type By: list of str
        :param ExportField: Export field
        :type ExportField: list of str
        """
        self.Filters = None
        self.Order = None
        self.By = None
        self.ExportField = None


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        self.ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateK8sApiAbnormalRuleExportJobResponse(AbstractModel):
    """CreateK8sApiAbnormalRuleExportJob response structure.

    """

    def __init__(self):
        r"""
        :param JobId: ID of the exportation job. You can query the job progress by using this ID on the console.
        :type JobId: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.JobId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.JobId = params.get("JobId")
        self.RequestId = params.get("RequestId")


class CreateK8sApiAbnormalRuleInfoRequest(AbstractModel):
    """CreateK8sApiAbnormalRuleInfo request structure.

    """

    def __init__(self):
        r"""
        :param RuleInfo: Rule details
        :type RuleInfo: :class:`tencentcloud.tcss.v20201101.models.K8sApiAbnormalRuleInfo`
        :param CopySrcRuleID: The ID of the copy rule (for copy rule scenarios)
        :type CopySrcRuleID: str
        :param EventID: Event ID (for adding events to an allowlist)
        :type EventID: int
        """
        self.RuleInfo = None
        self.CopySrcRuleID = None
        self.EventID = None


    def _deserialize(self, params):
        if params.get("RuleInfo") is not None:
            self.RuleInfo = K8sApiAbnormalRuleInfo()
            self.RuleInfo._deserialize(params.get("RuleInfo"))
        self.CopySrcRuleID = params.get("CopySrcRuleID")
        self.EventID = params.get("EventID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateK8sApiAbnormalRuleInfoResponse(AbstractModel):
    """CreateK8sApiAbnormalRuleInfo response structure.

    """

    def __init__(self):
        r"""
        :param RuleID: Rule ID
        :type RuleID: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RuleID = None
        self.RequestId = None


    def _deserialize(self, params):
        self.RuleID = params.get("RuleID")
        self.RequestId = params.get("RequestId")


class CreateNetworkFirewallClusterRefreshRequest(AbstractModel):
    """CreateNetworkFirewallClusterRefresh request structure.

    """


class CreateNetworkFirewallClusterRefreshResponse(AbstractModel):
    """CreateNetworkFirewallClusterRefresh response structure.

    """

    def __init__(self):
        r"""
        :param TaskId: ID of the created cluster check task. `0` indicates that the creation failed.
        :type TaskId: int
        :param Result: Result of creating the check task. Valid values: `Succ`, `Failed`.
        :type Result: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskId = None
        self.Result = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.Result = params.get("Result")
        self.RequestId = params.get("RequestId")


class CreateNetworkFirewallPolicyDiscoverRequest(AbstractModel):
    """CreateNetworkFirewallPolicyDiscover request structure.

    """

    def __init__(self):
        r"""
        :param ClusterId: Cluster ID
        :type ClusterId: str
        """
        self.ClusterId = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNetworkFirewallPolicyDiscoverResponse(AbstractModel):
    """CreateNetworkFirewallPolicyDiscover response structure.

    """

    def __init__(self):
        r"""
        :param TaskId: ID of the created cluster check task. `0` indicates that the creation failed.
        :type TaskId: int
        :param Result: Result of creating the check task. Valid values: `Succ`, `Failed`.
        :type Result: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskId = None
        self.Result = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.Result = params.get("Result")
        self.RequestId = params.get("RequestId")


class CreateNetworkFirewallPublishRequest(AbstractModel):
    """CreateNetworkFirewallPublish request structure.

    """

    def __init__(self):
        r"""
        :param ClusterId: Cluster ID
        :type ClusterId: str
        :param Id: Array of cluster IDs
        :type Id: list of int non-negative
        """
        self.ClusterId = None
        self.Id = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        self.Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNetworkFirewallPublishResponse(AbstractModel):
    """CreateNetworkFirewallPublish response structure.

    """

    def __init__(self):
        r"""
        :param TaskId: ID of the created task. `0` indicates that the creation failed.
        :type TaskId: int
        :param Result: Result of creating the task. Valid values: `Succ`, `Failed`.
        :type Result: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskId = None
        self.Result = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.Result = params.get("Result")
        self.RequestId = params.get("RequestId")


class CreateNetworkFirewallUndoPublishRequest(AbstractModel):
    """CreateNetworkFirewallUndoPublish request structure.

    """

    def __init__(self):
        r"""
        :param ClusterId: Cluster ID
        :type ClusterId: str
        :param Id: Array of cluster IDs
        :type Id: list of int non-negative
        """
        self.ClusterId = None
        self.Id = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        self.Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNetworkFirewallUndoPublishResponse(AbstractModel):
    """CreateNetworkFirewallUndoPublish response structure.

    """

    def __init__(self):
        r"""
        :param TaskId: ID of the created task. `0` indicates that the creation failed.
        :type TaskId: int
        :param Result: Result of creating the task. Valid values: `Succ`, `Failed`.
        :type Result: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskId = None
        self.Result = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.Result = params.get("Result")
        self.RequestId = params.get("RequestId")


class CreateOrModifyPostPayCoresRequest(AbstractModel):
    """CreateOrModifyPostPayCores request structure.

    """

    def __init__(self):
        r"""
        :param CoresCnt: Upper limit for elastic billing. Minimum value: `500`.
        :type CoresCnt: int
        """
        self.CoresCnt = None


    def _deserialize(self, params):
        self.CoresCnt = params.get("CoresCnt")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOrModifyPostPayCoresResponse(AbstractModel):
    """CreateOrModifyPostPayCores response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class CreateProcessEventsExportJobRequest(AbstractModel):
    """CreateProcessEventsExportJob request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Maximum value: `10000`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter parameter - status. Valid values: `EVENT_UNDEAL` (pending); `EVENT_DEALED` (processed); `EVENT_INGNORE` (ignored).
        :type Filters: list of AssetFilters
        :param Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param By: Sorting field: `latest_found_time`.
        :type By: str
        :param ExportField: Export field
        :type ExportField: list of str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None
        self.ExportField = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        self.ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateProcessEventsExportJobResponse(AbstractModel):
    """CreateProcessEventsExportJob response structure.

    """

    def __init__(self):
        r"""
        :param JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.JobId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.JobId = params.get("JobId")
        self.RequestId = params.get("RequestId")


class CreateRefreshTaskRequest(AbstractModel):
    """CreateRefreshTask request structure.

    """


class CreateRefreshTaskResponse(AbstractModel):
    """CreateRefreshTask response structure.

    """

    def __init__(self):
        r"""
        :param TaskId: ID of the created cluster check task. `0` indicates that the creation failed.
        :type TaskId: int
        :param CreateResult: Result of creating the check task. Valid values: `Succ`, `Failed`.
        :type CreateResult: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskId = None
        self.CreateResult = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.CreateResult = params.get("CreateResult")
        self.RequestId = params.get("RequestId")


class CreateRiskDnsEventExportJobRequest(AbstractModel):
    """CreateRiskDnsEventExportJob request structure.

    """

    def __init__(self):
        r"""
        :param Filters: Filters.
<li>`EventStatus` - String - Optional - Event status. Values: `EVENT_UNDEAL` (Pending); `EVENT_DEALED` (Handled); `EVENT_IGNORE` (Ignored); `EVENT_ADD_WHITE` (Added to the allowlist)</li>
<li>`ContainerStatus` - String - Optional - Container running status. `CREATED`, `RUNNING`, `PAUSED`, `STOPPED`, `RESTARTING`: `REMOVING`, `DESTROYED (Terminated)</li>
<li>`ContainerNetStatus` - String - Optional - Container network status. Values: `NORMAL`, `ISOLATED`, `ISOLATE_FAILED` (Isolation failed`; `RESTORE_FAILED` (Failed to restore from isolation), `RESTORING` (Restoring); `ISOLATING`</li>
<li>`EventType` - String - Optional - Event type. Values: `DOMAIN` (Malicious domain); `IP` (Malicious IP)</li>
<li>`TimeRange` - String - Optional - Time range, where the first value represents the start time and the second value represents the end time</li>
<li>`RiskDns` - String - Optional - Malicious domain. </li>
<li>`RiskIP`- String - Optional - Malicious IP. </li>
<li>`ContainerName` - String - Optional - Container name. </li>
<li>`ContainerID` - String - Optional - Container ID. </li>
<li>`ImageName` - String - Optional - Image name. </li>
<li>`ImageID` - String - Optional - Image ID. </li>
<li>`HostName` - String - Optional - Server name. </li>
<li>`HostIP` - String - Optional - Private IP. </li>
<li>`PublicIP` - String - Optional - Public IP. </li>
        :type Filters: list of RunTimeFilters
        :param Limit: The number of results displayed per page. The maximum value is 100,000.
        :type Limit: int
        :param Offset: Offset. Default value: 0
        :type Offset: int
        :param Order: Sort order: `asc`, `desc`
        :type Order: str
        :param By: Sorting field: Number of events: EventCount
        :type By: str
        """
        self.Filters = None
        self.Limit = None
        self.Offset = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRiskDnsEventExportJobResponse(AbstractModel):
    """CreateRiskDnsEventExportJob response structure.

    """

    def __init__(self):
        r"""
        :param JobId: ID of the exportation job. You can query the job progress by using this ID on the console.
        :type JobId: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.JobId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.JobId = params.get("JobId")
        self.RequestId = params.get("RequestId")


class CreateSearchTemplateRequest(AbstractModel):
    """CreateSearchTemplate request structure.

    """

    def __init__(self):
        r"""
        :param SearchTemplate: Search template
        :type SearchTemplate: :class:`tencentcloud.tcss.v20201101.models.SearchTemplate`
        """
        self.SearchTemplate = None


    def _deserialize(self, params):
        if params.get("SearchTemplate") is not None:
            self.SearchTemplate = SearchTemplate()
            self.SearchTemplate._deserialize(params.get("SearchTemplate"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSearchTemplateResponse(AbstractModel):
    """CreateSearchTemplate response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class CreateSystemVulExportJobRequest(AbstractModel):
    """CreateSystemVulExportJob request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `50000`. Maximum value: `50000`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>OnlyAffectedContainer- string - Required: No - Show only vulnerabilities that affect containers. Valid values: `true`, `false`.</li>
<li>OnlyAffectedNewestImage-string - Required: No - Show only vulnerabilities that affect the latest image tags. Valid values: `true`, `false`.</li>
<li>Level- String - Required: No - Severity. Valid values: `CRITICAL` (critical); `HIGH` (high); `MIDDLE` (medium); `LOW` (low).</li>
<li>Tags- string - Required: No - Vulnerability tag. Valid values: `POC`, `EXP`.</li>
<li>CanBeFixed- string - Required: No - Whether the vulnerability can be fixed. Valid values: `true`, `false`.</li>
<li>CategoryType- string - Required: No - Sub-type of the vulnerability</li>
<li>CVEID- string - Required: No - CVE No.</li>
<li>ImageID- string - Required: No - Image ID</li>
<li>ImageName- String - Required: No - Image name</li>
<li>ContainerID- string - Required: No - Container ID</li>
<li>ContainerName- string - Required: No - Container name</li>
<li>ComponentName- string - Required: No - Component name</li>
<li>ComponentVersion- string - Required: No - Component version</li>
<li>Name- string - Required: No - Vulnerability name</li>
<li>FocusOnType - string - Required: No - Urgency. Valid values: `ALL` (all); `SERIOUS_LEVEL (critical and high risks); `IS_SUGGEST` (high-priority); `POC_EXP` (POC/EXP); `NETWORK_EXP` (remote EXP).</li>
        :type Filters: list of RunTimeFilters
        :param Order: Sorting order
        :type Order: str
        :param By: Sorting field
        :type By: str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSystemVulExportJobResponse(AbstractModel):
    """CreateSystemVulExportJob response structure.

    """

    def __init__(self):
        r"""
        :param JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.JobId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.JobId = params.get("JobId")
        self.RequestId = params.get("RequestId")


class CreateVirusScanAgainRequest(AbstractModel):
    """CreateVirusScanAgain request structure.

    """

    def __init__(self):
        r"""
        :param TaskId: Task ID
        :type TaskId: str
        :param ContainerIds: Set of IDs of containers to be scanned
        :type ContainerIds: list of str
        :param TimeoutAll: Whether to scan all timed-out containers
        :type TimeoutAll: bool
        :param Timeout: New timeout period
        :type Timeout: int
        """
        self.TaskId = None
        self.ContainerIds = None
        self.TimeoutAll = None
        self.Timeout = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.ContainerIds = params.get("ContainerIds")
        self.TimeoutAll = params.get("TimeoutAll")
        self.Timeout = params.get("Timeout")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVirusScanAgainResponse(AbstractModel):
    """CreateVirusScanAgain response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class CreateVirusScanTaskRequest(AbstractModel):
    """CreateVirusScanTask request structure.

    """

    def __init__(self):
        r"""
        :param ScanPathAll: Whether to scan all paths
        :type ScanPathAll: bool
        :param ScanRangeType: Scanning scope. Valid values: `0` (container); `1` (server).
        :type ScanRangeType: int
        :param ScanRangeAll: Valid values: `true` (all); `false` (specified).
        :type ScanRangeAll: bool
        :param Timeout: Timeout period in hours
        :type Timeout: int
        :param ScanPathType: Valid when `ScanPathAll` is `false`. Valid values: `0` (scan the following paths); `1` (scan all paths except the following).
        :type ScanPathType: int
        :param ScanIds: ID of the specified container or server to be scanned, which is based on `ScanRangeType`.
        :type ScanIds: list of str
        :param ScanPath: Specified path to be excluded or scanned
        :type ScanPath: list of str
        """
        self.ScanPathAll = None
        self.ScanRangeType = None
        self.ScanRangeAll = None
        self.Timeout = None
        self.ScanPathType = None
        self.ScanIds = None
        self.ScanPath = None


    def _deserialize(self, params):
        self.ScanPathAll = params.get("ScanPathAll")
        self.ScanRangeType = params.get("ScanRangeType")
        self.ScanRangeAll = params.get("ScanRangeAll")
        self.Timeout = params.get("Timeout")
        self.ScanPathType = params.get("ScanPathType")
        self.ScanIds = params.get("ScanIds")
        self.ScanPath = params.get("ScanPath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVirusScanTaskResponse(AbstractModel):
    """CreateVirusScanTask response structure.

    """

    def __init__(self):
        r"""
        :param TaskID: Task ID
        :type TaskID: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskID = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskID = params.get("TaskID")
        self.RequestId = params.get("RequestId")


class CreateVulContainerExportJobRequest(AbstractModel):
    """CreateVulContainerExportJob request structure.

    """

    def __init__(self):
        r"""
        :param PocID: POC ID
        :type PocID: str
        :param Limit: Number of results to be returned. Default value: `50000`. Maximum value: `50000`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>OnlyAffectedNewestImage- Bool- Required: No - Show only vulnerabilities that affect the latest image tags</li>
<li>ContainerID- string - Required: No - Container ID</li>
<li>ContainerName- String - Required: No - Container name</li>
        :type Filters: list of RunTimeFilters
        """
        self.PocID = None
        self.Limit = None
        self.Offset = None
        self.Filters = None


    def _deserialize(self, params):
        self.PocID = params.get("PocID")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVulContainerExportJobResponse(AbstractModel):
    """CreateVulContainerExportJob response structure.

    """

    def __init__(self):
        r"""
        :param JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.JobId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.JobId = params.get("JobId")
        self.RequestId = params.get("RequestId")


class CreateVulDefenceEventExportJobRequest(AbstractModel):
    """CreateVulDefenceEventExportJob request structure.

    """

    def __init__(self):
        r"""
        :param Filters: Filter
<li>Status- String - Required: No - Plugin status. Valid values: `EVENT_UNDEAL` (pending); `EVENT_DEALED` (processed); `EVENT_IGNORE` (ignored); `EVENT_DEFENDED` (defended).</li>
<li>ContainerStatus- String - Required: No - Container status. Valid values: `CREATED` (created); `RUNNING` (running); `PAUSED` (suspended); 	`STOPPED` (stopped); `RESTARTING` (restarting); `REMOVING` (removing); `DESTROYED` (terminated).</li>
<li>ContainerNetStatus- String - Required: No - Container network status. Valid values: `NORMAL` (not isolated); `ISOLATED` (isolated); `ISOLATE_FAILED` (isolation failed); `RESTORE_FAILED` (recovery failed); `RESTORING` (recovering); `ISOLATING` (isolating).</li>
<li>EventType - String - Required: No - Intrusion status. Valid values: `EVENT_DEFENDED` (defended successfully); `EVENT_ATTACK` (attack attempt).</li>
<li>TimeRange- String - Required: No - Time range. The first value indicates the start time, and the second the end time.</li>
<li>VulName- string - Required: No - Vulnerability name</li>
<li>CVEID- string - Required: No - CVE No.</li>
<li>SourceIP- string - Required: No - Attacker IP</li>
<li>ContainerName- string - Required: No - Container name</li>
<li>ContainerID- string - Required: No - Container ID</li>
<li>ImageName- string - Required: No - Image name</li>
<li>ImageID- string - Required: No - Image ID</li>
<li>HostName- string - Required: No - Server name</li>
<li>HostIP- string - Required: No - Private IP</li>
        :type Filters: list of RunTimeFilters
        :param Limit: Number of results to be returned. Maximum value: `100000`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        :param By: Sorting field: `EventCount` (number of events).
        :type By: str
        """
        self.Filters = None
        self.Limit = None
        self.Offset = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVulDefenceEventExportJobResponse(AbstractModel):
    """CreateVulDefenceEventExportJob response structure.

    """

    def __init__(self):
        r"""
        :param JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.JobId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.JobId = params.get("JobId")
        self.RequestId = params.get("RequestId")


class CreateVulDefenceHostExportJobRequest(AbstractModel):
    """CreateVulDefenceHostExportJob request structure.

    """

    def __init__(self):
        r"""
        :param Filters: Filter
<li>Status- String - Required: No - Plugin status. Valid values: `SUCCESS` (normal); `FAIL` (abnormal); `NO_DEFENCE` (not defended).</li>
<li>KeyWords- string - Required: No - Server name/IP</li>
        :type Filters: list of RunTimeFilters
        :param Limit: Number of results to be returned. Maximum value: `100000`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        :param By: Sorting field. Valid values: `ModifyTime` (update time); `CreateTime` (first enablement time).
        :type By: str
        """
        self.Filters = None
        self.Limit = None
        self.Offset = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVulDefenceHostExportJobResponse(AbstractModel):
    """CreateVulDefenceHostExportJob response structure.

    """

    def __init__(self):
        r"""
        :param JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.JobId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.JobId = params.get("JobId")
        self.RequestId = params.get("RequestId")


class CreateVulExportJobRequest(AbstractModel):
    """CreateVulExportJob request structure.

    """

    def __init__(self):
        r"""
        :param ImageID: Image ID
        :type ImageID: str
        :param ExportField: Export field
        :type ExportField: list of str
        :param Limit: Number of results to be returned. Default value: `10000`. Maximum value: `10000`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>ComponentName- String - Required: No - Image component name</li><li>ComponentVersion- String - Required: No - Image component version</li><li>ComponentType- String - Required: No - Image component type</li><li>VulLevel- String - Required: No - Vulnerability severity</li><li>HasVul- String - Required: No - Whether there is a vulnerability. Valid values: `true` (yes); `false` (no). If `ComponentName` is not passed in or is `ALL`, it indicates all.</li>
        :type Filters: list of AssetFilters
        :param By: Sorting field
        :type By: str
        :param Order: Sorting order. Valid values: `desc`, `asc`.
        :type Order: str
        """
        self.ImageID = None
        self.ExportField = None
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.By = None
        self.Order = None


    def _deserialize(self, params):
        self.ImageID = params.get("ImageID")
        self.ExportField = params.get("ExportField")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.By = params.get("By")
        self.Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVulExportJobResponse(AbstractModel):
    """CreateVulExportJob response structure.

    """

    def __init__(self):
        r"""
        :param JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.JobId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.JobId = params.get("JobId")
        self.RequestId = params.get("RequestId")


class CreateVulImageExportJobRequest(AbstractModel):
    """CreateVulImageExportJob request structure.

    """

    def __init__(self):
        r"""
        :param PocID: POC ID
        :type PocID: str
        :param Limit: Number of results to be returned. Default value: `50000`. Maximum value: `50000`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>OnlyAffectedNewestImage- Bool- Required: No - Show only vulnerabilities that affect the latest image tags</li>
<li>ImageID- string - Required: No - Image ID</li>
<li>ImageName- String - Required: No - Image name</li>
<li>ClientIP- string - Required: No - Private IP</li>
<li>PublicIP- string - Required: No - Public IP</li>
<li>ComponentName- string - Required: No - Component name</li>
<li>ComponentVersion- string - Required: No - Component version</li>
<li>HostName- string - Required: No - Server name</li>
        :type Filters: list of RunTimeFilters
        :param Order: Sorting order
        :type Order: str
        :param By: Sorting field
        :type By: str
        """
        self.PocID = None
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.PocID = params.get("PocID")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVulImageExportJobResponse(AbstractModel):
    """CreateVulImageExportJob response structure.

    """

    def __init__(self):
        r"""
        :param JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.JobId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.JobId = params.get("JobId")
        self.RequestId = params.get("RequestId")


class CreateVulScanTaskRequest(AbstractModel):
    """CreateVulScanTask request structure.

    """

    def __init__(self):
        r"""
        :param LocalImageScanType: Local image scan scope. Valid values: `ALL` (all local images); `NOT_SCAN` (all licensed but not scanned local images); `IMAGEIDS` (IDs of specified local images).
        :type LocalImageScanType: str
        :param LocalImageIDs: Scan by licensed local image ID, with a higher priority than scan by licensed local image that meets the condition.
        :type LocalImageIDs: list of str
        :param RegistryImageScanType: Repository image scan scope. Valid values: `ALL` (all repository images); `NOT_SCAN` (all licensed but not scanned repository images); `IMAGEIDS` (IDs of specified repository images).
        :type RegistryImageScanType: str
        :param RegistryImageIDs: Scan by licensed repository image ID, with a higher priority than scan by licensed repository image that meets the condition.
        :type RegistryImageIDs: list of int non-negative
        :param LocalTaskID: ID of the task to scan local images again for vulnerabilities
        :type LocalTaskID: int
        :param RegistryTaskID: ID of the task to scan repository images again for vulnerabilities
        :type RegistryTaskID: int
        """
        self.LocalImageScanType = None
        self.LocalImageIDs = None
        self.RegistryImageScanType = None
        self.RegistryImageIDs = None
        self.LocalTaskID = None
        self.RegistryTaskID = None


    def _deserialize(self, params):
        self.LocalImageScanType = params.get("LocalImageScanType")
        self.LocalImageIDs = params.get("LocalImageIDs")
        self.RegistryImageScanType = params.get("RegistryImageScanType")
        self.RegistryImageIDs = params.get("RegistryImageIDs")
        self.LocalTaskID = params.get("LocalTaskID")
        self.RegistryTaskID = params.get("RegistryTaskID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVulScanTaskResponse(AbstractModel):
    """CreateVulScanTask response structure.

    """

    def __init__(self):
        r"""
        :param LocalTaskID: ID of the task to scan local images again for vulnerabilities
        :type LocalTaskID: int
        :param RegistryTaskID: ID of the task to scan repository images again for vulnerabilities
        :type RegistryTaskID: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.LocalTaskID = None
        self.RegistryTaskID = None
        self.RequestId = None


    def _deserialize(self, params):
        self.LocalTaskID = params.get("LocalTaskID")
        self.RegistryTaskID = params.get("RegistryTaskID")
        self.RequestId = params.get("RequestId")


class CreateWebVulExportJobRequest(AbstractModel):
    """CreateWebVulExportJob request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `50000`. Maximum value: `50000`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>OnlyAffectedContainer- string - Required: No - Show only vulnerabilities that affect containers. Valid values: `true`, `false`.</li>
<li>OnlyAffectedNewestImage-string - Required: No - Show only vulnerabilities that affect the latest image tags. Valid values: `true`, `false`.</li>
<li>Level- String - Required: No - Severity. Valid values: `CRITICAL` (critical); `HIGH` (high); `MIDDLE` (medium); `LOW` (low).</li>
<li>Tags- string - Required: No - Vulnerability tag. Valid values: `POC`, `EXP`.</li>
<li>CanBeFixed- string - Required: No - Whether the vulnerability can be fixed. Valid values: `true`, `false`.</li>
<li>CategoryType- string - Required: No - Sub-type of the vulnerability</li>
<li>CVEID- string - Required: No - CVE No.</li>
<li>ImageID- string - Required: No - Image ID</li>
<li>ImageName- String - Required: No - Image name</li>
<li>ContainerID- string - Required: No - Container ID</li>
<li>ContainerName- string - Required: No - Container name</li>
<li>ComponentName- string - Required: No - Component name</li>
<li>ComponentVersion- string - Required: No - Component version</li>
<li>Name- string - Required: No - Vulnerability name</li>
<li>FocusOnType - string - Required: No - Urgency. Valid values: `ALL` (all); `SERIOUS_LEVEL (critical and high risks); `IS_SUGGEST` (high-priority); `POC_EXP` (POC/EXP); `NETWORK_EXP` (remote EXP).</li>
        :type Filters: list of RunTimeFilters
        :param Order: Sorting order
        :type Order: str
        :param By: Sorting field
        :type By: str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWebVulExportJobResponse(AbstractModel):
    """CreateWebVulExportJob response structure.

    """

    def __init__(self):
        r"""
        :param JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.JobId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.JobId = params.get("JobId")
        self.RequestId = params.get("RequestId")


class DeleteAbnormalProcessRulesRequest(AbstractModel):
    """DeleteAbnormalProcessRules request structure.

    """

    def __init__(self):
        r"""
        :param RuleIdSet: Policy IDs
        :type RuleIdSet: list of str
        """
        self.RuleIdSet = None


    def _deserialize(self, params):
        self.RuleIdSet = params.get("RuleIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAbnormalProcessRulesResponse(AbstractModel):
    """DeleteAbnormalProcessRules response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class DeleteAccessControlRulesRequest(AbstractModel):
    """DeleteAccessControlRules request structure.

    """

    def __init__(self):
        r"""
        :param RuleIdSet: Policy IDs
        :type RuleIdSet: list of str
        """
        self.RuleIdSet = None


    def _deserialize(self, params):
        self.RuleIdSet = params.get("RuleIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAccessControlRulesResponse(AbstractModel):
    """DeleteAccessControlRules response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class DeleteComplianceAssetPolicySetFromWhitelistRequest(AbstractModel):
    """DeleteComplianceAssetPolicySetFromWhitelist request structure.

    """

    def __init__(self):
        r"""
        :param AssetItemId: Asset ID
        :type AssetItemId: int
        :param CustomerPolicyItemIdSet: List of IDs of check items to be ignored in the specified asset
        :type CustomerPolicyItemIdSet: list of int non-negative
        """
        self.AssetItemId = None
        self.CustomerPolicyItemIdSet = None


    def _deserialize(self, params):
        self.AssetItemId = params.get("AssetItemId")
        self.CustomerPolicyItemIdSet = params.get("CustomerPolicyItemIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteComplianceAssetPolicySetFromWhitelistResponse(AbstractModel):
    """DeleteComplianceAssetPolicySetFromWhitelist response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class DeleteCompliancePolicyAssetSetFromWhitelistRequest(AbstractModel):
    """DeleteCompliancePolicyAssetSetFromWhitelist request structure.

    """

    def __init__(self):
        r"""
        :param PolicyAssetSetList: List of check item IDs and asset IDs
        :type PolicyAssetSetList: list of CompliancePolicyAssetSetItem
        """
        self.PolicyAssetSetList = None


    def _deserialize(self, params):
        if params.get("PolicyAssetSetList") is not None:
            self.PolicyAssetSetList = []
            for item in params.get("PolicyAssetSetList"):
                obj = CompliancePolicyAssetSetItem()
                obj._deserialize(item)
                self.PolicyAssetSetList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCompliancePolicyAssetSetFromWhitelistResponse(AbstractModel):
    """DeleteCompliancePolicyAssetSetFromWhitelist response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class DeleteCompliancePolicyItemFromWhitelistRequest(AbstractModel):
    """DeleteCompliancePolicyItemFromWhitelist request structure.

    """

    def __init__(self):
        r"""
        :param WhitelistIdSet: List of IDs of specified allowed items
        :type WhitelistIdSet: list of int non-negative
        """
        self.WhitelistIdSet = None


    def _deserialize(self, params):
        self.WhitelistIdSet = params.get("WhitelistIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCompliancePolicyItemFromWhitelistResponse(AbstractModel):
    """DeleteCompliancePolicyItemFromWhitelist response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class DeleteEscapeWhiteListRequest(AbstractModel):
    """DeleteEscapeWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param IDSet: Array of allowed item IDs
        :type IDSet: list of int
        """
        self.IDSet = None


    def _deserialize(self, params):
        self.IDSet = params.get("IDSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteEscapeWhiteListResponse(AbstractModel):
    """DeleteEscapeWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class DeleteIgnoreVulRequest(AbstractModel):
    """DeleteIgnoreVul request structure.

    """

    def __init__(self):
        r"""
        :param List: List of POC IDs
        :type List: list of ModifyIgnoreVul
        """
        self.List = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = ModifyIgnoreVul()
                obj._deserialize(item)
                self.List.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteIgnoreVulResponse(AbstractModel):
    """DeleteIgnoreVul response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class DeleteK8sApiAbnormalRuleRequest(AbstractModel):
    """DeleteK8sApiAbnormalRule request structure.

    """

    def __init__(self):
        r"""
        :param RuleIDSet: Rule ID set
        :type RuleIDSet: list of str
        """
        self.RuleIDSet = None


    def _deserialize(self, params):
        self.RuleIDSet = params.get("RuleIDSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteK8sApiAbnormalRuleResponse(AbstractModel):
    """DeleteK8sApiAbnormalRule response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class DeleteMachineRequest(AbstractModel):
    """DeleteMachine request structure.

    """

    def __init__(self):
        r"""
        :param Uuid: Agent UUID
        :type Uuid: str
        """
        self.Uuid = None


    def _deserialize(self, params):
        self.Uuid = params.get("Uuid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteMachineResponse(AbstractModel):
    """DeleteMachine response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class DeleteNetworkFirewallPolicyDetailRequest(AbstractModel):
    """DeleteNetworkFirewallPolicyDetail request structure.

    """

    def __init__(self):
        r"""
        :param ClusterId: Cluster ID
        :type ClusterId: str
        :param Id: Array of cluster IDs
        :type Id: list of int non-negative
        """
        self.ClusterId = None
        self.Id = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        self.Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNetworkFirewallPolicyDetailResponse(AbstractModel):
    """DeleteNetworkFirewallPolicyDetail response structure.

    """

    def __init__(self):
        r"""
        :param TaskId: ID of the created task. `0` indicates that the creation failed.
        :type TaskId: int
        :param Result: Result of creating the deletion task. Valid values: `Succ`, `Failed`.
        :type Result: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskId = None
        self.Result = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.Result = params.get("Result")
        self.RequestId = params.get("RequestId")


class DeleteReverseShellEventsRequest(AbstractModel):
    """DeleteReverseShellEvents request structure.

    """

    def __init__(self):
        r"""
        :param EventIdSet: Event IDs
        :type EventIdSet: list of str
        """
        self.EventIdSet = None


    def _deserialize(self, params):
        self.EventIdSet = params.get("EventIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteReverseShellEventsResponse(AbstractModel):
    """DeleteReverseShellEvents response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class DeleteReverseShellWhiteListsRequest(AbstractModel):
    """DeleteReverseShellWhiteLists request structure.

    """

    def __init__(self):
        r"""
        :param WhiteListIdSet: IDs of allowed items
        :type WhiteListIdSet: list of str
        """
        self.WhiteListIdSet = None


    def _deserialize(self, params):
        self.WhiteListIdSet = params.get("WhiteListIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteReverseShellWhiteListsResponse(AbstractModel):
    """DeleteReverseShellWhiteLists response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class DeleteRiskSyscallEventsRequest(AbstractModel):
    """DeleteRiskSyscallEvents request structure.

    """

    def __init__(self):
        r"""
        :param EventIdSet: Event IDs
        :type EventIdSet: list of str
        """
        self.EventIdSet = None


    def _deserialize(self, params):
        self.EventIdSet = params.get("EventIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRiskSyscallEventsResponse(AbstractModel):
    """DeleteRiskSyscallEvents response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class DeleteRiskSyscallWhiteListsRequest(AbstractModel):
    """DeleteRiskSyscallWhiteLists request structure.

    """

    def __init__(self):
        r"""
        :param WhiteListIdSet: IDs of allowed items
        :type WhiteListIdSet: list of str
        """
        self.WhiteListIdSet = None


    def _deserialize(self, params):
        self.WhiteListIdSet = params.get("WhiteListIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRiskSyscallWhiteListsResponse(AbstractModel):
    """DeleteRiskSyscallWhiteLists response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class DeleteSearchTemplateRequest(AbstractModel):
    """DeleteSearchTemplate request structure.

    """

    def __init__(self):
        r"""
        :param Id: Template ID
        :type Id: int
        """
        self.Id = None


    def _deserialize(self, params):
        self.Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSearchTemplateResponse(AbstractModel):
    """DeleteSearchTemplate response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class DescribeABTestConfigRequest(AbstractModel):
    """DescribeABTestConfig request structure.

    """

    def __init__(self):
        r"""
        :param ProjectName: Canary project name
        :type ProjectName: str
        """
        self.ProjectName = None


    def _deserialize(self, params):
        self.ProjectName = params.get("ProjectName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeABTestConfigResponse(AbstractModel):
    """DescribeABTestConfig response structure.

    """

    def __init__(self):
        r"""
        :param Config: Canary project configuration
        :type Config: list of ABTestConfig
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.Config = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("Config") is not None:
            self.Config = []
            for item in params.get("Config"):
                obj = ABTestConfig()
                obj._deserialize(item)
                self.Config.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeAbnormalProcessDetailRequest(AbstractModel):
    """DescribeAbnormalProcessDetail request structure.

    """

    def __init__(self):
        r"""
        :param EventId: Unique event ID
        :type EventId: str
        """
        self.EventId = None


    def _deserialize(self, params):
        self.EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAbnormalProcessDetailResponse(AbstractModel):
    """DescribeAbnormalProcessDetail response structure.

    """

    def __init__(self):
        r"""
        :param EventBaseInfo: Basic information of the event
        :type EventBaseInfo: :class:`tencentcloud.tcss.v20201101.models.RunTimeEventBaseInfo`
        :param ProcessInfo: Process information
        :type ProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessDetailInfo`
        :param ParentProcessInfo: Parent process information
        :type ParentProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessDetailBaseInfo`
        :param EventDetail: Event description
        :type EventDetail: :class:`tencentcloud.tcss.v20201101.models.AbnormalProcessEventDescription`
        :param AncestorProcessInfo: Ancestor process information
Note: This field may return null, indicating that no valid values can be obtained.
        :type AncestorProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessBaseInfo`
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.EventBaseInfo = None
        self.ProcessInfo = None
        self.ParentProcessInfo = None
        self.EventDetail = None
        self.AncestorProcessInfo = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("EventBaseInfo") is not None:
            self.EventBaseInfo = RunTimeEventBaseInfo()
            self.EventBaseInfo._deserialize(params.get("EventBaseInfo"))
        if params.get("ProcessInfo") is not None:
            self.ProcessInfo = ProcessDetailInfo()
            self.ProcessInfo._deserialize(params.get("ProcessInfo"))
        if params.get("ParentProcessInfo") is not None:
            self.ParentProcessInfo = ProcessDetailBaseInfo()
            self.ParentProcessInfo._deserialize(params.get("ParentProcessInfo"))
        if params.get("EventDetail") is not None:
            self.EventDetail = AbnormalProcessEventDescription()
            self.EventDetail._deserialize(params.get("EventDetail"))
        if params.get("AncestorProcessInfo") is not None:
            self.AncestorProcessInfo = ProcessBaseInfo()
            self.AncestorProcessInfo._deserialize(params.get("AncestorProcessInfo"))
        self.RequestId = params.get("RequestId")


class DescribeAbnormalProcessEventTendencyRequest(AbstractModel):
    """DescribeAbnormalProcessEventTendency request structure.

    """

    def __init__(self):
        r"""
        :param StartTime: Start time
        :type StartTime: str
        :param EndTime: End time
        :type EndTime: str
        """
        self.StartTime = None
        self.EndTime = None


    def _deserialize(self, params):
        self.StartTime = params.get("StartTime")
        self.EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAbnormalProcessEventTendencyResponse(AbstractModel):
    """DescribeAbnormalProcessEventTendency response structure.

    """

    def __init__(self):
        r"""
        :param List: Trend of pending abnormal process events
        :type List: list of AbnormalProcessEventTendencyInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = AbnormalProcessEventTendencyInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeAbnormalProcessEventsExportRequest(AbstractModel):
    """DescribeAbnormalProcessEventsExport request structure.

    """

    def __init__(self):
        r"""
        :param ExportField: Export field
        :type ExportField: list of str
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param By: Sorting field
        :type By: str
        """
        self.ExportField = None
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.ExportField = params.get("ExportField")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAbnormalProcessEventsExportResponse(AbstractModel):
    """DescribeAbnormalProcessEventsExport response structure.

    """

    def __init__(self):
        r"""
        :param DownloadUrl: Excel download URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type DownloadUrl: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.DownloadUrl = None
        self.RequestId = None


    def _deserialize(self, params):
        self.DownloadUrl = params.get("DownloadUrl")
        self.RequestId = params.get("RequestId")


class DescribeAbnormalProcessEventsRequest(AbstractModel):
    """DescribeAbnormalProcessEvents request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param By: Sorting field
        :type By: str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAbnormalProcessEventsResponse(AbstractModel):
    """DescribeAbnormalProcessEvents response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number of events
        :type TotalCount: int
        :param EventSet: Array of abnormal processes
        :type EventSet: list of AbnormalProcessEventInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.EventSet = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("EventSet") is not None:
            self.EventSet = []
            for item in params.get("EventSet"):
                obj = AbnormalProcessEventInfo()
                obj._deserialize(item)
                self.EventSet.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeAbnormalProcessLevelSummaryRequest(AbstractModel):
    """DescribeAbnormalProcessLevelSummary request structure.

    """


class DescribeAbnormalProcessLevelSummaryResponse(AbstractModel):
    """DescribeAbnormalProcessLevelSummary response structure.

    """

    def __init__(self):
        r"""
        :param HighLevelEventCount: Number of pending high-risk events of abnormal processes
        :type HighLevelEventCount: int
        :param MediumLevelEventCount: Number of pending medium-risk events of abnormal processes
        :type MediumLevelEventCount: int
        :param LowLevelEventCount: Number of pending low-risk events of abnormal processes
        :type LowLevelEventCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.HighLevelEventCount = None
        self.MediumLevelEventCount = None
        self.LowLevelEventCount = None
        self.RequestId = None


    def _deserialize(self, params):
        self.HighLevelEventCount = params.get("HighLevelEventCount")
        self.MediumLevelEventCount = params.get("MediumLevelEventCount")
        self.LowLevelEventCount = params.get("LowLevelEventCount")
        self.RequestId = params.get("RequestId")


class DescribeAbnormalProcessRuleDetailRequest(AbstractModel):
    """DescribeAbnormalProcessRuleDetail request structure.

    """

    def __init__(self):
        r"""
        :param RuleId: Unique policy ID
        :type RuleId: str
        :param ImageId: Image ID, which is used when an image is added to the allowlist.
        :type ImageId: str
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        """
        self.RuleId = None
        self.ImageId = None
        self.Limit = None
        self.Offset = None


    def _deserialize(self, params):
        self.RuleId = params.get("RuleId")
        self.ImageId = params.get("ImageId")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAbnormalProcessRuleDetailResponse(AbstractModel):
    """DescribeAbnormalProcessRuleDetail response structure.

    """

    def __init__(self):
        r"""
        :param RuleDetail: Details of the abnormal process policy
        :type RuleDetail: :class:`tencentcloud.tcss.v20201101.models.AbnormalProcessRuleInfo`
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RuleDetail = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("RuleDetail") is not None:
            self.RuleDetail = AbnormalProcessRuleInfo()
            self.RuleDetail._deserialize(params.get("RuleDetail"))
        self.RequestId = params.get("RequestId")


class DescribeAbnormalProcessRulesExportRequest(AbstractModel):
    """DescribeAbnormalProcessRulesExport request structure.

    """

    def __init__(self):
        r"""
        :param ExportField: Export field
        :type ExportField: list of str
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param By: Sorting field
        :type By: str
        """
        self.ExportField = None
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.ExportField = params.get("ExportField")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAbnormalProcessRulesExportResponse(AbstractModel):
    """DescribeAbnormalProcessRulesExport response structure.

    """

    def __init__(self):
        r"""
        :param DownloadUrl: Excel download URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type DownloadUrl: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.DownloadUrl = None
        self.RequestId = None


    def _deserialize(self, params):
        self.DownloadUrl = params.get("DownloadUrl")
        self.RequestId = params.get("RequestId")


class DescribeAbnormalProcessRulesRequest(AbstractModel):
    """DescribeAbnormalProcessRules request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param By: Sorting field
        :type By: str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAbnormalProcessRulesResponse(AbstractModel):
    """DescribeAbnormalProcessRules response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number of events
        :type TotalCount: int
        :param RuleSet: List of abnormal process policies
        :type RuleSet: list of RuleBaseInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.RuleSet = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("RuleSet") is not None:
            self.RuleSet = []
            for item in params.get("RuleSet"):
                obj = RuleBaseInfo()
                obj._deserialize(item)
                self.RuleSet.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeAccessControlDetailRequest(AbstractModel):
    """DescribeAccessControlDetail request structure.

    """

    def __init__(self):
        r"""
        :param EventId: Unique event ID
        :type EventId: str
        """
        self.EventId = None


    def _deserialize(self, params):
        self.EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccessControlDetailResponse(AbstractModel):
    """DescribeAccessControlDetail response structure.

    """

    def __init__(self):
        r"""
        :param EventBaseInfo: Basic information of the event
        :type EventBaseInfo: :class:`tencentcloud.tcss.v20201101.models.RunTimeEventBaseInfo`
        :param ProcessInfo: Process information
        :type ProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessDetailInfo`
        :param TamperedFileInfo: Information tampered with
        :type TamperedFileInfo: :class:`tencentcloud.tcss.v20201101.models.FileAttributeInfo`
        :param EventDetail: Event description
        :type EventDetail: :class:`tencentcloud.tcss.v20201101.models.AccessControlEventDescription`
        :param ParentProcessInfo: Parent process information
        :type ParentProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessBaseInfo`
        :param AncestorProcessInfo: Ancestor process information
Note: This field may return null, indicating that no valid values can be obtained.
        :type AncestorProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessBaseInfo`
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.EventBaseInfo = None
        self.ProcessInfo = None
        self.TamperedFileInfo = None
        self.EventDetail = None
        self.ParentProcessInfo = None
        self.AncestorProcessInfo = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("EventBaseInfo") is not None:
            self.EventBaseInfo = RunTimeEventBaseInfo()
            self.EventBaseInfo._deserialize(params.get("EventBaseInfo"))
        if params.get("ProcessInfo") is not None:
            self.ProcessInfo = ProcessDetailInfo()
            self.ProcessInfo._deserialize(params.get("ProcessInfo"))
        if params.get("TamperedFileInfo") is not None:
            self.TamperedFileInfo = FileAttributeInfo()
            self.TamperedFileInfo._deserialize(params.get("TamperedFileInfo"))
        if params.get("EventDetail") is not None:
            self.EventDetail = AccessControlEventDescription()
            self.EventDetail._deserialize(params.get("EventDetail"))
        if params.get("ParentProcessInfo") is not None:
            self.ParentProcessInfo = ProcessBaseInfo()
            self.ParentProcessInfo._deserialize(params.get("ParentProcessInfo"))
        if params.get("AncestorProcessInfo") is not None:
            self.AncestorProcessInfo = ProcessBaseInfo()
            self.AncestorProcessInfo._deserialize(params.get("AncestorProcessInfo"))
        self.RequestId = params.get("RequestId")


class DescribeAccessControlEventsExportRequest(AbstractModel):
    """DescribeAccessControlEventsExport request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param By: Sorting field
        :type By: str
        :param ExportField: Export field
        :type ExportField: list of str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None
        self.ExportField = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        self.ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccessControlEventsExportResponse(AbstractModel):
    """DescribeAccessControlEventsExport response structure.

    """

    def __init__(self):
        r"""
        :param DownloadUrl: Excel download URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type DownloadUrl: str
        :param JobId: Task ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type JobId: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.DownloadUrl = None
        self.JobId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.DownloadUrl = params.get("DownloadUrl")
        self.JobId = params.get("JobId")
        self.RequestId = params.get("RequestId")


class DescribeAccessControlEventsRequest(AbstractModel):
    """DescribeAccessControlEvents request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param By: Sorting field
        :type By: str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccessControlEventsResponse(AbstractModel):
    """DescribeAccessControlEvents response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number of events
        :type TotalCount: int
        :param EventSet: Array of access control events
        :type EventSet: list of AccessControlEventInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.EventSet = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("EventSet") is not None:
            self.EventSet = []
            for item in params.get("EventSet"):
                obj = AccessControlEventInfo()
                obj._deserialize(item)
                self.EventSet.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeAccessControlRuleDetailRequest(AbstractModel):
    """DescribeAccessControlRuleDetail request structure.

    """

    def __init__(self):
        r"""
        :param RuleId: Unique policy ID
        :type RuleId: str
        :param ImageId: Image ID, which is used only when allowing an event.
        :type ImageId: str
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        """
        self.RuleId = None
        self.ImageId = None
        self.Limit = None
        self.Offset = None


    def _deserialize(self, params):
        self.RuleId = params.get("RuleId")
        self.ImageId = params.get("ImageId")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccessControlRuleDetailResponse(AbstractModel):
    """DescribeAccessControlRuleDetail response structure.

    """

    def __init__(self):
        r"""
        :param RuleDetail: Runtime policy details
        :type RuleDetail: :class:`tencentcloud.tcss.v20201101.models.AccessControlRuleInfo`
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RuleDetail = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("RuleDetail") is not None:
            self.RuleDetail = AccessControlRuleInfo()
            self.RuleDetail._deserialize(params.get("RuleDetail"))
        self.RequestId = params.get("RequestId")


class DescribeAccessControlRulesExportRequest(AbstractModel):
    """DescribeAccessControlRulesExport request structure.

    """

    def __init__(self):
        r"""
        :param ExportField: Export field
        :type ExportField: list of str
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param By: Sorting field
        :type By: str
        """
        self.ExportField = None
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.ExportField = params.get("ExportField")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccessControlRulesExportResponse(AbstractModel):
    """DescribeAccessControlRulesExport response structure.

    """

    def __init__(self):
        r"""
        :param DownloadUrl: Excel download URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type DownloadUrl: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.DownloadUrl = None
        self.RequestId = None


    def _deserialize(self, params):
        self.DownloadUrl = params.get("DownloadUrl")
        self.RequestId = params.get("RequestId")


class DescribeAccessControlRulesRequest(AbstractModel):
    """DescribeAccessControlRules request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param By: Sorting field
        :type By: str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccessControlRulesResponse(AbstractModel):
    """DescribeAccessControlRules response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number of events
        :type TotalCount: int
        :param RuleSet: List of access control policies
        :type RuleSet: list of RuleBaseInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.RuleSet = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("RuleSet") is not None:
            self.RuleSet = []
            for item in params.get("RuleSet"):
                obj = RuleBaseInfo()
                obj._deserialize(item)
                self.RuleSet.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeAffectedClusterCountRequest(AbstractModel):
    """DescribeAffectedClusterCount request structure.

    """


class DescribeAffectedClusterCountResponse(AbstractModel):
    """DescribeAffectedClusterCount response structure.

    """

    def __init__(self):
        r"""
        :param SeriousRiskClusterCount: Number of critical clusters
        :type SeriousRiskClusterCount: int
        :param HighRiskClusterCount: Number of high-risk clusters
        :type HighRiskClusterCount: int
        :param MiddleRiskClusterCount: Number of medium-risk clusters
        :type MiddleRiskClusterCount: int
        :param HintRiskClusterCount: Number of low-risk clusters
        :type HintRiskClusterCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.SeriousRiskClusterCount = None
        self.HighRiskClusterCount = None
        self.MiddleRiskClusterCount = None
        self.HintRiskClusterCount = None
        self.RequestId = None


    def _deserialize(self, params):
        self.SeriousRiskClusterCount = params.get("SeriousRiskClusterCount")
        self.HighRiskClusterCount = params.get("HighRiskClusterCount")
        self.MiddleRiskClusterCount = params.get("MiddleRiskClusterCount")
        self.HintRiskClusterCount = params.get("HintRiskClusterCount")
        self.RequestId = params.get("RequestId")


class DescribeAffectedNodeListRequest(AbstractModel):
    """DescribeAffectedNodeList request structure.

    """

    def __init__(self):
        r"""
        :param CheckItemId: Unique ID of the check item
        :type CheckItemId: int
        :param Offset: Offset
        :type Offset: int
        :param Limit: Maximum number of records per query
        :type Limit: int
        :param Filters: Name - String
Name. Valid values: `ClusterName`, `ClusterId`, `InstanceId`, `PrivateIpAddresses`.
        :type Filters: list of ComplianceFilters
        :param By: Sorting field
        :type By: str
        :param Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self.CheckItemId = None
        self.Offset = None
        self.Limit = None
        self.Filters = None
        self.By = None
        self.Order = None


    def _deserialize(self, params):
        self.CheckItemId = params.get("CheckItemId")
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.By = params.get("By")
        self.Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAffectedNodeListResponse(AbstractModel):
    """DescribeAffectedNodeList response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number of affected nodes
        :type TotalCount: int
        :param AffectedNodeList: List of affected nodes
        :type AffectedNodeList: list of AffectedNodeItem
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.AffectedNodeList = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("AffectedNodeList") is not None:
            self.AffectedNodeList = []
            for item in params.get("AffectedNodeList"):
                obj = AffectedNodeItem()
                obj._deserialize(item)
                self.AffectedNodeList.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeAffectedWorkloadListRequest(AbstractModel):
    """DescribeAffectedWorkloadList request structure.

    """

    def __init__(self):
        r"""
        :param CheckItemId: Unique ID of the check item
        :type CheckItemId: int
        :param Offset: Offset
        :type Offset: int
        :param Limit: Maximum number of records per query
        :type Limit: int
        :param Filters: Name - String
Name. Valid values: `WorkloadType`, `ClusterId`.
        :type Filters: list of ComplianceFilters
        :param By: Sorting field
        :type By: str
        :param Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self.CheckItemId = None
        self.Offset = None
        self.Limit = None
        self.Filters = None
        self.By = None
        self.Order = None


    def _deserialize(self, params):
        self.CheckItemId = params.get("CheckItemId")
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.By = params.get("By")
        self.Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAffectedWorkloadListResponse(AbstractModel):
    """DescribeAffectedWorkloadList response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Number of affected workloads
        :type TotalCount: int
        :param AffectedWorkloadList: List of affected workloads
        :type AffectedWorkloadList: list of AffectedWorkloadItem
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.AffectedWorkloadList = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("AffectedWorkloadList") is not None:
            self.AffectedWorkloadList = []
            for item in params.get("AffectedWorkloadList"):
                obj = AffectedWorkloadItem()
                obj._deserialize(item)
                self.AffectedWorkloadList.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeAgentDaemonSetCmdRequest(AbstractModel):
    """DescribeAgentDaemonSetCmd request structure.

    """

    def __init__(self):
        r"""
        :param IsCloud: Whether it is from Tencent Cloud
        :type IsCloud: bool
        :param NetType: Network type. Valid values: `basic` (classic network); `private` (VPC); `public` (public network); `direct` (Direct Connect).
        :type NetType: str
        :param RegionCode: Region, which is required when `NetType` is `direct`.
        :type RegionCode: str
        :param VpcId: VpcId, which is required when `NetType` is `direct`.
        :type VpcId: str
        :param ExpireDate: Command validity, which is required for non-Tencent Cloud instances.
        :type ExpireDate: str
        """
        self.IsCloud = None
        self.NetType = None
        self.RegionCode = None
        self.VpcId = None
        self.ExpireDate = None


    def _deserialize(self, params):
        self.IsCloud = params.get("IsCloud")
        self.NetType = params.get("NetType")
        self.RegionCode = params.get("RegionCode")
        self.VpcId = params.get("VpcId")
        self.ExpireDate = params.get("ExpireDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAgentDaemonSetCmdResponse(AbstractModel):
    """DescribeAgentDaemonSetCmd response structure.

    """

    def __init__(self):
        r"""
        :param Command: Installation command
        :type Command: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.Command = None
        self.RequestId = None


    def _deserialize(self, params):
        self.Command = params.get("Command")
        self.RequestId = params.get("RequestId")


class DescribeAgentInstallCommandRequest(AbstractModel):
    """DescribeAgentInstallCommand request structure.

    """

    def __init__(self):
        r"""
        :param IsCloud: Whether it is from Tencent Cloud
        :type IsCloud: bool
        :param NetType: Network type. Valid values: `basic` (classic network); `private` (VPC); `public` (public network); `direct` (Direct Connect).
        :type NetType: str
        :param RegionCode: Region, which is required when `NetType` is `direct`.
        :type RegionCode: str
        :param VpcId: VpcId, which is required when `NetType` is `direct`.
        :type VpcId: str
        :param ExpireDate: Command validity, which is required for non-Tencent Cloud instances.
        :type ExpireDate: str
        :param TagIds: Tag ID list, which is valid only when `IsCloud` is `false`.
        :type TagIds: list of int non-negative
        """
        self.IsCloud = None
        self.NetType = None
        self.RegionCode = None
        self.VpcId = None
        self.ExpireDate = None
        self.TagIds = None


    def _deserialize(self, params):
        self.IsCloud = params.get("IsCloud")
        self.NetType = params.get("NetType")
        self.RegionCode = params.get("RegionCode")
        self.VpcId = params.get("VpcId")
        self.ExpireDate = params.get("ExpireDate")
        self.TagIds = params.get("TagIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAgentInstallCommandResponse(AbstractModel):
    """DescribeAgentInstallCommand response structure.

    """

    def __init__(self):
        r"""
        :param LinuxCommand: Linux installation command
        :type LinuxCommand: str
        :param WindowsCommand: Windows installation command (Windows 2008 or later)
        :type WindowsCommand: str
        :param WindowsStepOne: Step 1 in the Window installation command (Windows 2003)
        :type WindowsStepOne: str
        :param WindowsStepTwo: Step 2 in the Window installation command (Windows 2003)
        :type WindowsStepTwo: str
        :param WindowsDownloadUrl: Download URL of the agent for Windows
        :type WindowsDownloadUrl: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.LinuxCommand = None
        self.WindowsCommand = None
        self.WindowsStepOne = None
        self.WindowsStepTwo = None
        self.WindowsDownloadUrl = None
        self.RequestId = None


    def _deserialize(self, params):
        self.LinuxCommand = params.get("LinuxCommand")
        self.WindowsCommand = params.get("WindowsCommand")
        self.WindowsStepOne = params.get("WindowsStepOne")
        self.WindowsStepTwo = params.get("WindowsStepTwo")
        self.WindowsDownloadUrl = params.get("WindowsDownloadUrl")
        self.RequestId = params.get("RequestId")


class DescribeAssetAppServiceListRequest(AbstractModel):
    """DescribeAssetAppServiceList request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>Keywords- String - Required: No - Optional field for the fuzzy query</li>
        :type Filters: list of AssetFilters
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetAppServiceListResponse(AbstractModel):
    """DescribeAssetAppServiceList response structure.

    """

    def __init__(self):
        r"""
        :param List: List of database services
        :type List: list of ServiceInfo
        :param TotalCount: Total number
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = ServiceInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeAssetClusterListRequest(AbstractModel):
    """DescribeAssetClusterList request structure.

    """

    def __init__(self):
        r"""
        :param Filters: Filters.
<li>`ClusterID` - String - Optional - Cluster ID</li>
<li>`ClusterName` - String - Optional - Cluster name</li>
<li>`Status` - String - Optional - Cluster status</li>
        :type Filters: list of RunTimeFilters
        :param Limit: The number of results returned. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param Offset: Offset. Default value: 0
        :type Offset: int
        :param Order: Sort order
        :type Order: str
        :param By: Sorting field.
        :type By: str
        """
        self.Filters = None
        self.Limit = None
        self.Offset = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetClusterListResponse(AbstractModel):
    """DescribeAssetClusterList response structure.

    """

    def __init__(self):
        r"""
        :param List: Cluster list
        :type List: list of AssetClusterListItem
        :param TotalCount: Total number of clusters
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = AssetClusterListItem()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeAssetComponentListRequest(AbstractModel):
    """DescribeAssetComponentList request structure.

    """

    def __init__(self):
        r"""
        :param ContainerID: Container ID
        :type ContainerID: str
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
        :type Filters: list of AssetFilters
        """
        self.ContainerID = None
        self.Limit = None
        self.Offset = None
        self.Filters = None


    def _deserialize(self, params):
        self.ContainerID = params.get("ContainerID")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetComponentListResponse(AbstractModel):
    """DescribeAssetComponentList response structure.

    """

    def __init__(self):
        r"""
        :param List: List of components
        :type List: list of ComponentInfo
        :param TotalCount: Total number
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = ComponentInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeAssetContainerDetailRequest(AbstractModel):
    """DescribeAssetContainerDetail request structure.

    """

    def __init__(self):
        r"""
        :param ContainerId: Container ID
        :type ContainerId: str
        """
        self.ContainerId = None


    def _deserialize(self, params):
        self.ContainerId = params.get("ContainerId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetContainerDetailResponse(AbstractModel):
    """DescribeAssetContainerDetail response structure.

    """

    def __init__(self):
        r"""
        :param HostID: Server ID
        :type HostID: str
        :param HostIP: Server IP
        :type HostIP: str
        :param ContainerName: Container name
        :type ContainerName: str
        :param Status: Status
        :type Status: str
        :param RunAs: Operator
        :type RunAs: str
        :param Cmd: Command line
        :type Cmd: str
        :param CPUUsage: CPU utilization * 1000
        :type CPUUsage: int
        :param RamUsage: Memory usage in KB
        :type RamUsage: int
        :param ImageName: Image name
        :type ImageName: str
        :param ImageID: Image ID
        :type ImageID: str
        :param POD: Pod
        :type POD: str
        :param K8sMaster: K8s master node
        :type K8sMaster: str
        :param ProcessCnt: Number of processes in the container
        :type ProcessCnt: int
        :param PortCnt: Number of ports in the container
        :type PortCnt: int
        :param ComponentCnt: Number of components
        :type ComponentCnt: int
        :param AppCnt: Number of applications
        :type AppCnt: int
        :param WebServiceCnt: Number of web services
        :type WebServiceCnt: int
        :param Mounts: Mount
        :type Mounts: list of ContainerMount
        :param Network: Container network information
        :type Network: :class:`tencentcloud.tcss.v20201101.models.ContainerNetwork`
        :param CreateTime: Creation time
        :type CreateTime: str
        :param ImageCreateTime: Image creation time
        :type ImageCreateTime: str
        :param ImageSize: Image size
        :type ImageSize: int
        :param HostStatus: Server status. Valid values: `offline`, `online`, `pause`.
        :type HostStatus: str
        :param NetStatus: Network status
`NORMAL`: 	Not isolated.
`ISOLATED`: 		Isolated.
`ISOLATING`: 		Isolating.
`ISOLATE_FAILED`: 	Isolation failed.
`RESTORING`: Recovering.
`RESTORE_FAILED`: Recovery failed.
        :type NetStatus: str
        :param NetSubStatus: Sub-status of the network
        :type NetSubStatus: str
        :param IsolateSource: Isolation source
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsolateSource: str
        :param IsolateTime: Isolation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsolateTime: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.HostID = None
        self.HostIP = None
        self.ContainerName = None
        self.Status = None
        self.RunAs = None
        self.Cmd = None
        self.CPUUsage = None
        self.RamUsage = None
        self.ImageName = None
        self.ImageID = None
        self.POD = None
        self.K8sMaster = None
        self.ProcessCnt = None
        self.PortCnt = None
        self.ComponentCnt = None
        self.AppCnt = None
        self.WebServiceCnt = None
        self.Mounts = None
        self.Network = None
        self.CreateTime = None
        self.ImageCreateTime = None
        self.ImageSize = None
        self.HostStatus = None
        self.NetStatus = None
        self.NetSubStatus = None
        self.IsolateSource = None
        self.IsolateTime = None
        self.RequestId = None


    def _deserialize(self, params):
        self.HostID = params.get("HostID")
        self.HostIP = params.get("HostIP")
        self.ContainerName = params.get("ContainerName")
        self.Status = params.get("Status")
        self.RunAs = params.get("RunAs")
        self.Cmd = params.get("Cmd")
        self.CPUUsage = params.get("CPUUsage")
        self.RamUsage = params.get("RamUsage")
        self.ImageName = params.get("ImageName")
        self.ImageID = params.get("ImageID")
        self.POD = params.get("POD")
        self.K8sMaster = params.get("K8sMaster")
        self.ProcessCnt = params.get("ProcessCnt")
        self.PortCnt = params.get("PortCnt")
        self.ComponentCnt = params.get("ComponentCnt")
        self.AppCnt = params.get("AppCnt")
        self.WebServiceCnt = params.get("WebServiceCnt")
        if params.get("Mounts") is not None:
            self.Mounts = []
            for item in params.get("Mounts"):
                obj = ContainerMount()
                obj._deserialize(item)
                self.Mounts.append(obj)
        if params.get("Network") is not None:
            self.Network = ContainerNetwork()
            self.Network._deserialize(params.get("Network"))
        self.CreateTime = params.get("CreateTime")
        self.ImageCreateTime = params.get("ImageCreateTime")
        self.ImageSize = params.get("ImageSize")
        self.HostStatus = params.get("HostStatus")
        self.NetStatus = params.get("NetStatus")
        self.NetSubStatus = params.get("NetSubStatus")
        self.IsolateSource = params.get("IsolateSource")
        self.IsolateTime = params.get("IsolateTime")
        self.RequestId = params.get("RequestId")


class DescribeAssetContainerListRequest(AbstractModel):
    """DescribeAssetContainerList request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>ContainerName - String - Required: No - Container name</li>
<li>Status - String - Required: No - Container status. Valid values: `0` (created); `1` (running); `2` (paused); `3` (restarting); `4` (removing); `5` (exited); `6` (dead).</li>
<li>Runas - String - Required: No - Operator</li>
<li>ImageName- String - Required: No - Image name</li>
<li>HostIP- string - Required: No - Server IP</li>
<li>OrderBy - String - Required: No - Sorting field, which supports dynamic sorting by `cpu_usage` or `mem_usage` such as ["cpu_usage","+"]. '+' indicates ascending, and '-' indicates descending.</li>
<li>NetStatus - String - Required: No - Container network status. Valid values: `normal`, `isolated`, `isolating`, `isolate_failed`, `restoring`, `restore_failed`.</li>
        :type Filters: list of AssetFilters
        :param By: Sorting field
        :type By: str
        :param Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.By = None
        self.Order = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.By = params.get("By")
        self.Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetContainerListResponse(AbstractModel):
    """DescribeAssetContainerList response structure.

    """

    def __init__(self):
        r"""
        :param List: List of containers
        :type List: list of ContainerInfo
        :param TotalCount: Total number
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = ContainerInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeAssetDBServiceListRequest(AbstractModel):
    """DescribeAssetDBServiceList request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>Keywords- String - Required: No - Optional field for the fuzzy query</li>
        :type Filters: list of AssetFilters
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetDBServiceListResponse(AbstractModel):
    """DescribeAssetDBServiceList response structure.

    """

    def __init__(self):
        r"""
        :param List: List of database services
        :type List: list of ServiceInfo
        :param TotalCount: Total number
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = ServiceInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeAssetHostDetailRequest(AbstractModel):
    """DescribeAssetHostDetail request structure.

    """

    def __init__(self):
        r"""
        :param HostId: Server ID
        :type HostId: str
        """
        self.HostId = None


    def _deserialize(self, params):
        self.HostId = params.get("HostId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetHostDetailResponse(AbstractModel):
    """DescribeAssetHostDetail response structure.

    """

    def __init__(self):
        r"""
        :param UUID: CWPP UUID
        :type UUID: str
        :param UpdateTime: Update time
        :type UpdateTime: str
        :param HostName: Server name
        :type HostName: str
        :param Group: Server group
        :type Group: str
        :param HostIP: Server IP
        :type HostIP: str
        :param OsName: OS
        :type OsName: str
        :param AgentVersion: Agent version
        :type AgentVersion: str
        :param KernelVersion: Kernel version
        :type KernelVersion: str
        :param DockerVersion: Docker version
        :type DockerVersion: str
        :param DockerAPIVersion: Docker API version
        :type DockerAPIVersion: str
        :param DockerGoVersion: Docker version for Go
        :type DockerGoVersion: str
        :param DockerFileSystemDriver: Docker file system type
        :type DockerFileSystemDriver: str
        :param DockerRootDir: Docker root directory
        :type DockerRootDir: str
        :param ImageCnt: Number of images
        :type ImageCnt: int
        :param ContainerCnt: Number of containers
        :type ContainerCnt: int
        :param K8sMasterIP: K8s IP
        :type K8sMasterIP: str
        :param K8sVersion: K8s version
        :type K8sVersion: str
        :param KubeProxyVersion: kube proxy
        :type KubeProxyVersion: str
        :param Status: Valid values: `UNINSTALL` (not installed); `OFFLINE` (offline); `ONLINE` (defended).
        :type Status: str
        :param IsContainerd: Whether it is Containerd
        :type IsContainerd: bool
        :param MachineType: Server source. Valid values: `TENCENTCLOUD` (Tencent Cloud instance); `OTHERCLOUD` (non-Tencent Cloud instance).
        :type MachineType: str
        :param PublicIp: Public IP
        :type PublicIp: str
        :param InstanceID: Server instance ID
        :type InstanceID: str
        :param RegionID: Region ID
        :type RegionID: int
        :param Project: Project
        :type Project: :class:`tencentcloud.tcss.v20201101.models.ProjectInfo`
        :param Tags: Tags
        :type Tags: list of TagInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.UUID = None
        self.UpdateTime = None
        self.HostName = None
        self.Group = None
        self.HostIP = None
        self.OsName = None
        self.AgentVersion = None
        self.KernelVersion = None
        self.DockerVersion = None
        self.DockerAPIVersion = None
        self.DockerGoVersion = None
        self.DockerFileSystemDriver = None
        self.DockerRootDir = None
        self.ImageCnt = None
        self.ContainerCnt = None
        self.K8sMasterIP = None
        self.K8sVersion = None
        self.KubeProxyVersion = None
        self.Status = None
        self.IsContainerd = None
        self.MachineType = None
        self.PublicIp = None
        self.InstanceID = None
        self.RegionID = None
        self.Project = None
        self.Tags = None
        self.RequestId = None


    def _deserialize(self, params):
        self.UUID = params.get("UUID")
        self.UpdateTime = params.get("UpdateTime")
        self.HostName = params.get("HostName")
        self.Group = params.get("Group")
        self.HostIP = params.get("HostIP")
        self.OsName = params.get("OsName")
        self.AgentVersion = params.get("AgentVersion")
        self.KernelVersion = params.get("KernelVersion")
        self.DockerVersion = params.get("DockerVersion")
        self.DockerAPIVersion = params.get("DockerAPIVersion")
        self.DockerGoVersion = params.get("DockerGoVersion")
        self.DockerFileSystemDriver = params.get("DockerFileSystemDriver")
        self.DockerRootDir = params.get("DockerRootDir")
        self.ImageCnt = params.get("ImageCnt")
        self.ContainerCnt = params.get("ContainerCnt")
        self.K8sMasterIP = params.get("K8sMasterIP")
        self.K8sVersion = params.get("K8sVersion")
        self.KubeProxyVersion = params.get("KubeProxyVersion")
        self.Status = params.get("Status")
        self.IsContainerd = params.get("IsContainerd")
        self.MachineType = params.get("MachineType")
        self.PublicIp = params.get("PublicIp")
        self.InstanceID = params.get("InstanceID")
        self.RegionID = params.get("RegionID")
        if params.get("Project") is not None:
            self.Project = ProjectInfo()
            self.Project._deserialize(params.get("Project"))
        if params.get("Tags") is not None:
            self.Tags = []
            for item in params.get("Tags"):
                obj = TagInfo()
                obj._deserialize(item)
                self.Tags.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeAssetHostListRequest(AbstractModel):
    """DescribeAssetHostList request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filters.
<li>`Status` - String - Optional - Agent status. Values: `ALL`; `UNINSTALL` (Not installed); `OFFLINE`, `ONLINE`. Default to `All` if it's not specified. </li>
<li>`HostName` - String - Optional - Server name</li>
<li>`Group - String - Optional - Server group</li>
<li>`HostIP` - String - Optional - Server IP</li>
<li>`HostID - String - Optional - Server ID</li>
<li>`DockerVersion` - String - Optional - Docker version</li>
<li>`MachineType` - String - Optional - Server type. Values: `ALL`; `CVM` (Cloud Virtual Machine); `ECM` (Edge Computing Machine); `LH` (Lighthouse), `BM` (Cloud Bare Metal); `Other` (non-Tencent Cloud server). Default to `ALL` if it's not specified.</li>
<li>`DockerStatus` - String - Optional - Docker installation status. Values: `ALL`; `INSTALL` (Installed); `UNINSTALL` (Not installed)</li>
<li>`ProjectID` - String - Optional - Project ID</li>
<li>`Tag:xxx(tag:key)` - String - Optional - Tag key-value pair; Example: `Filters":[{"Name":"tag:tke-kind","Values":["service"]}]`</li>
        :type Filters: list of AssetFilters
        :param By: Sorting field
        :type By: str
        :param Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.By = None
        self.Order = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.By = params.get("By")
        self.Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetHostListResponse(AbstractModel):
    """DescribeAssetHostList response structure.

    """

    def __init__(self):
        r"""
        :param List: List of servers
        :type List: list of HostInfo
        :param TotalCount: Total number
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = HostInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeAssetImageBindRuleInfoRequest(AbstractModel):
    """DescribeAssetImageBindRuleInfo request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter parameter. "Filters":[{"Name":"EventType","Values":[""]}]
EventType. Valid values:
`FILE_ABNORMAL_READ`: Access control.
`MALICE_PROCESS_START`: Malicious process startup.
        :type Filters: list of RunTimeFilters
        :param Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param By: Sorting field
        :type By: str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageBindRuleInfoResponse(AbstractModel):
    """DescribeAssetImageBindRuleInfo response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number of events
        :type TotalCount: int
        :param ImageBindRuleSet: List of rules bound to images
        :type ImageBindRuleSet: list of ImagesBindRuleInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.ImageBindRuleSet = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("ImageBindRuleSet") is not None:
            self.ImageBindRuleSet = []
            for item in params.get("ImageBindRuleSet"):
                obj = ImagesBindRuleInfo()
                obj._deserialize(item)
                self.ImageBindRuleSet.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeAssetImageDetailRequest(AbstractModel):
    """DescribeAssetImageDetail request structure.

    """

    def __init__(self):
        r"""
        :param ImageID: Image ID
        :type ImageID: str
        """
        self.ImageID = None


    def _deserialize(self, params):
        self.ImageID = params.get("ImageID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageDetailResponse(AbstractModel):
    """DescribeAssetImageDetail response structure.

    """

    def __init__(self):
        r"""
        :param ImageID: Image ID
        :type ImageID: str
        :param ImageName: Image name
        :type ImageName: str
        :param CreateTime: Creation time
        :type CreateTime: str
        :param Size: Image size
        :type Size: int
        :param HostCnt: Number of associated servers
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostCnt: int
        :param ContainerCnt: Number of associated containers
Note: This field may return null, indicating that no valid values can be obtained.
        :type ContainerCnt: int
        :param ScanTime: Last scan time
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanTime: str
        :param VulCnt: Number of vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained.
        :type VulCnt: int
        :param RiskCnt: Number of risky behaviors
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskCnt: int
        :param SensitiveInfoCnt: Number of sensitive data items
Note: This field may return null, indicating that no valid values can be obtained.
        :type SensitiveInfoCnt: int
        :param IsTrustImage: Whether it is a trusted image
        :type IsTrustImage: bool
        :param OsName: Image system
        :type OsName: str
        :param AgentError: Image scan error in the agent
Note: This field may return null, indicating that no valid values can be obtained.
        :type AgentError: str
        :param ScanError: Image scan error on the backend
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanError: str
        :param Architecture: System architecture
Note: This field may return null, indicating that no valid values can be obtained.
        :type Architecture: str
        :param Author: Author
Note: This field may return null, indicating that no valid values can be obtained.
        :type Author: str
        :param BuildHistory: Build history
Note: This field may return null, indicating that no valid values can be obtained.
        :type BuildHistory: str
        :param ScanVirusProgress: Trojan scanning progress
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanVirusProgress: int
        :param ScanVulProgress: Vulnerability scan progress
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanVulProgress: int
        :param ScanRiskProgress: Sensitive data scanning progress
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanRiskProgress: int
        :param ScanVirusError: Trojan scan error
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanVirusError: str
        :param ScanVulError: Vulnerability scan error
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanVulError: str
        :param ScanRiskError: Sensitive data error
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanRiskError: str
        :param ScanStatus: Image scanning status
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanStatus: str
        :param VirusCnt: Number of viruses and trojans
Note: This field may return null, indicating that no valid values can be obtained.
        :type VirusCnt: int
        :param Status: Image scanning status
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        :param RemainScanTime: Remaining scan time
Note: This field may return null, indicating that no valid values can be obtained.
        :type RemainScanTime: int
        :param IsAuthorized: Valid values: `1` (licensed); `0` (unlicensed).
        :type IsAuthorized: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.ImageID = None
        self.ImageName = None
        self.CreateTime = None
        self.Size = None
        self.HostCnt = None
        self.ContainerCnt = None
        self.ScanTime = None
        self.VulCnt = None
        self.RiskCnt = None
        self.SensitiveInfoCnt = None
        self.IsTrustImage = None
        self.OsName = None
        self.AgentError = None
        self.ScanError = None
        self.Architecture = None
        self.Author = None
        self.BuildHistory = None
        self.ScanVirusProgress = None
        self.ScanVulProgress = None
        self.ScanRiskProgress = None
        self.ScanVirusError = None
        self.ScanVulError = None
        self.ScanRiskError = None
        self.ScanStatus = None
        self.VirusCnt = None
        self.Status = None
        self.RemainScanTime = None
        self.IsAuthorized = None
        self.RequestId = None


    def _deserialize(self, params):
        self.ImageID = params.get("ImageID")
        self.ImageName = params.get("ImageName")
        self.CreateTime = params.get("CreateTime")
        self.Size = params.get("Size")
        self.HostCnt = params.get("HostCnt")
        self.ContainerCnt = params.get("ContainerCnt")
        self.ScanTime = params.get("ScanTime")
        self.VulCnt = params.get("VulCnt")
        self.RiskCnt = params.get("RiskCnt")
        self.SensitiveInfoCnt = params.get("SensitiveInfoCnt")
        self.IsTrustImage = params.get("IsTrustImage")
        self.OsName = params.get("OsName")
        self.AgentError = params.get("AgentError")
        self.ScanError = params.get("ScanError")
        self.Architecture = params.get("Architecture")
        self.Author = params.get("Author")
        self.BuildHistory = params.get("BuildHistory")
        self.ScanVirusProgress = params.get("ScanVirusProgress")
        self.ScanVulProgress = params.get("ScanVulProgress")
        self.ScanRiskProgress = params.get("ScanRiskProgress")
        self.ScanVirusError = params.get("ScanVirusError")
        self.ScanVulError = params.get("ScanVulError")
        self.ScanRiskError = params.get("ScanRiskError")
        self.ScanStatus = params.get("ScanStatus")
        self.VirusCnt = params.get("VirusCnt")
        self.Status = params.get("Status")
        self.RemainScanTime = params.get("RemainScanTime")
        self.IsAuthorized = params.get("IsAuthorized")
        self.RequestId = params.get("RequestId")


class DescribeAssetImageHostListRequest(AbstractModel):
    """DescribeAssetImageHostList request structure.

    """

    def __init__(self):
        r"""
        :param Filters: Filter. Valid values: `ImageID`, `HostID`.
        :type Filters: list of AssetFilters
        """
        self.Filters = None


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageHostListResponse(AbstractModel):
    """DescribeAssetImageHostList response structure.

    """

    def __init__(self):
        r"""
        :param List: List of images
        :type List: list of ImageHost
        :param TotalCount: Total number
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = ImageHost()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeAssetImageListExportRequest(AbstractModel):
    """DescribeAssetImageListExport request structure.

    """

    def __init__(self):
        r"""
        :param ExportField: Export field
        :type ExportField: list of str
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>ImageName- String - Required: No - Image name</li>
<li>ScanStatus - String - Required: No - Image scanning status. Valid values: `notScan`, `scanning`, `scanned`, `scanErr`.</li>
<li>ImageID- String - Required: No - Image ID</li>
<li>SecurityRisk- String - Required: No - Security risks. Valid values: `VulCnt`, `VirusCnt`, `RiskCnt`, `IsTrustImage`.</li>
        :type Filters: list of AssetFilters
        :param By: Sorting field
        :type By: str
        :param Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self.ExportField = None
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.By = None
        self.Order = None


    def _deserialize(self, params):
        self.ExportField = params.get("ExportField")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.By = params.get("By")
        self.Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageListExportResponse(AbstractModel):
    """DescribeAssetImageListExport response structure.

    """

    def __init__(self):
        r"""
        :param DownloadUrl: Excel file download URL
        :type DownloadUrl: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.DownloadUrl = None
        self.RequestId = None


    def _deserialize(self, params):
        self.DownloadUrl = params.get("DownloadUrl")
        self.RequestId = params.get("RequestId")


class DescribeAssetImageListRequest(AbstractModel):
    """DescribeAssetImageList request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>ImageName- String - Required: No - Image name</li>
<li>ScanStatus - String - Required: No - Image scanning status. Valid values: `notScan`, `scanning`, `scanned`, `scanErr`.</li>
<li>ImageID- String - Required: No - Image ID</li>
<li>SecurityRisk- String - Required: No - Security risks. Valid values: `VulCnt`, `VirusCnt`, `RiskCnt`, `IsTrustImage`.</li>
        :type Filters: list of AssetFilters
        :param By: Sorting field
        :type By: str
        :param Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.By = None
        self.Order = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.By = params.get("By")
        self.Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageListResponse(AbstractModel):
    """DescribeAssetImageList response structure.

    """

    def __init__(self):
        r"""
        :param List: List of images
        :type List: list of ImagesInfo
        :param TotalCount: Total number
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = ImagesInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeAssetImageRegistryAssetStatusRequest(AbstractModel):
    """DescribeAssetImageRegistryAssetStatus request structure.

    """


class DescribeAssetImageRegistryAssetStatusResponse(AbstractModel):
    """DescribeAssetImageRegistryAssetStatus response structure.

    """

    def __init__(self):
        r"""
        :param Status: Update progress. Valid values: `doing` (updating); `success` (updated successfully); `failed` (failed to update).
        :type Status: str
        :param Err: Error message
Note: This field may return null, indicating that no valid values can be obtained.
        :type Err: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.Status = None
        self.Err = None
        self.RequestId = None


    def _deserialize(self, params):
        self.Status = params.get("Status")
        self.Err = params.get("Err")
        self.RequestId = params.get("RequestId")


class DescribeAssetImageRegistryDetailRequest(AbstractModel):
    """DescribeAssetImageRegistryDetail request structure.

    """

    def __init__(self):
        r"""
        :param Id: List of repository IDs
        :type Id: int
        :param ImageId: Image ID
        :type ImageId: str
        """
        self.Id = None
        self.ImageId = None


    def _deserialize(self, params):
        self.Id = params.get("Id")
        self.ImageId = params.get("ImageId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryDetailResponse(AbstractModel):
    """DescribeAssetImageRegistryDetail response structure.

    """

    def __init__(self):
        r"""
        :param ImageDigest: Image digest
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageDigest: str
        :param ImageRepoAddress: Image address
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageRepoAddress: str
        :param RegistryType: Image type
Note: This field may return null, indicating that no valid values can be obtained.
        :type RegistryType: str
        :param ImageName: Repository name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageName: str
        :param ImageTag: Image tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageTag: str
        :param ScanTime: Scan time
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanTime: str
        :param ScanStatus: Scanning status
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanStatus: str
        :param VulCnt: Number of vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained.
        :type VulCnt: int
        :param VirusCnt: Number of viruses and trojans
Note: This field may return null, indicating that no valid values can be obtained.
        :type VirusCnt: int
        :param RiskCnt: Number of risky behaviors
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskCnt: int
        :param SentiveInfoCnt: Number of sensitive data items
Note: This field may return null, indicating that no valid values can be obtained.
        :type SentiveInfoCnt: int
        :param OsName: Image system
Note: This field may return null, indicating that no valid values can be obtained.
        :type OsName: str
        :param ScanVirusError: Trojan scan error
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanVirusError: str
        :param ScanVulError: Vulnerability scan error
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanVulError: str
        :param LayerInfo: Layer file information
Note: This field may return null, indicating that no valid values can be obtained.
        :type LayerInfo: str
        :param InstanceId: Instance ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceId: str
        :param InstanceName: Instance name
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceName: str
        :param Namespace: Namespace
Note: This field may return null, indicating that no valid values can be obtained.
        :type Namespace: str
        :param ScanRiskError: High-risk scan error
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanRiskError: str
        :param ScanVirusProgress: Trojan scanning progress
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanVirusProgress: int
        :param ScanVulProgress: Vulnerability scanning progress
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanVulProgress: int
        :param ScanRiskProgress: Sensitive data scanning progress
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanRiskProgress: int
        :param ScanRemainTime: Remaining scan time in seconds
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanRemainTime: int
        :param CveStatus: CVE scanning status
Note: This field may return null, indicating that no valid values can be obtained.
        :type CveStatus: str
        :param RiskStatus: High-risk scanning status
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskStatus: str
        :param VirusStatus: Trojan scanning status
Note: This field may return null, indicating that no valid values can be obtained.
        :type VirusStatus: str
        :param Progress: Overall progress
Note: This field may return null, indicating that no valid values can be obtained.
        :type Progress: int
        :param IsAuthorized: Licensing status
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsAuthorized: int
        :param ImageSize: Image size
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageSize: int
        :param ImageId: Image ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageId: str
        :param RegistryRegion: Image region
Note: This field may return null, indicating that no valid values can be obtained.
        :type RegistryRegion: str
        :param ImageCreateTime: Image creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageCreateTime: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.ImageDigest = None
        self.ImageRepoAddress = None
        self.RegistryType = None
        self.ImageName = None
        self.ImageTag = None
        self.ScanTime = None
        self.ScanStatus = None
        self.VulCnt = None
        self.VirusCnt = None
        self.RiskCnt = None
        self.SentiveInfoCnt = None
        self.OsName = None
        self.ScanVirusError = None
        self.ScanVulError = None
        self.LayerInfo = None
        self.InstanceId = None
        self.InstanceName = None
        self.Namespace = None
        self.ScanRiskError = None
        self.ScanVirusProgress = None
        self.ScanVulProgress = None
        self.ScanRiskProgress = None
        self.ScanRemainTime = None
        self.CveStatus = None
        self.RiskStatus = None
        self.VirusStatus = None
        self.Progress = None
        self.IsAuthorized = None
        self.ImageSize = None
        self.ImageId = None
        self.RegistryRegion = None
        self.ImageCreateTime = None
        self.RequestId = None


    def _deserialize(self, params):
        self.ImageDigest = params.get("ImageDigest")
        self.ImageRepoAddress = params.get("ImageRepoAddress")
        self.RegistryType = params.get("RegistryType")
        self.ImageName = params.get("ImageName")
        self.ImageTag = params.get("ImageTag")
        self.ScanTime = params.get("ScanTime")
        self.ScanStatus = params.get("ScanStatus")
        self.VulCnt = params.get("VulCnt")
        self.VirusCnt = params.get("VirusCnt")
        self.RiskCnt = params.get("RiskCnt")
        self.SentiveInfoCnt = params.get("SentiveInfoCnt")
        self.OsName = params.get("OsName")
        self.ScanVirusError = params.get("ScanVirusError")
        self.ScanVulError = params.get("ScanVulError")
        self.LayerInfo = params.get("LayerInfo")
        self.InstanceId = params.get("InstanceId")
        self.InstanceName = params.get("InstanceName")
        self.Namespace = params.get("Namespace")
        self.ScanRiskError = params.get("ScanRiskError")
        self.ScanVirusProgress = params.get("ScanVirusProgress")
        self.ScanVulProgress = params.get("ScanVulProgress")
        self.ScanRiskProgress = params.get("ScanRiskProgress")
        self.ScanRemainTime = params.get("ScanRemainTime")
        self.CveStatus = params.get("CveStatus")
        self.RiskStatus = params.get("RiskStatus")
        self.VirusStatus = params.get("VirusStatus")
        self.Progress = params.get("Progress")
        self.IsAuthorized = params.get("IsAuthorized")
        self.ImageSize = params.get("ImageSize")
        self.ImageId = params.get("ImageId")
        self.RegistryRegion = params.get("RegistryRegion")
        self.ImageCreateTime = params.get("ImageCreateTime")
        self.RequestId = params.get("RequestId")


class DescribeAssetImageRegistryListExportRequest(AbstractModel):
    """DescribeAssetImageRegistryListExport request structure.

    """

    def __init__(self):
        r"""
        :param ExportField: Export field
        :type ExportField: list of str
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Sorting field
        :type Filters: list of AssetFilters
        :param By: Sorting field
        :type By: str
        :param Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        :param OnlyShowLatest: Whether to show only the latest repository images. Default value: `false`.
        :type OnlyShowLatest: bool
        """
        self.ExportField = None
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.By = None
        self.Order = None
        self.OnlyShowLatest = None


    def _deserialize(self, params):
        self.ExportField = params.get("ExportField")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.By = params.get("By")
        self.Order = params.get("Order")
        self.OnlyShowLatest = params.get("OnlyShowLatest")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryListExportResponse(AbstractModel):
    """DescribeAssetImageRegistryListExport response structure.

    """

    def __init__(self):
        r"""
        :param DownloadUrl: Excel file download URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type DownloadUrl: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.DownloadUrl = None
        self.RequestId = None


    def _deserialize(self, params):
        self.DownloadUrl = params.get("DownloadUrl")
        self.RequestId = params.get("RequestId")


class DescribeAssetImageRegistryListRequest(AbstractModel):
    """DescribeAssetImageRegistryList request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter field
`IsAuthorized` (whether licensed). Valid values: `all` (all); `0` (unlicensed); `1` (licensed).
        :type Filters: list of AssetFilters
        :param By: Sorting field
        :type By: str
        :param Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        :param OnlyShowLatest: Whether to show only the latest repository images. Default value: `false`.
        :type OnlyShowLatest: bool
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.By = None
        self.Order = None
        self.OnlyShowLatest = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.By = params.get("By")
        self.Order = params.get("Order")
        self.OnlyShowLatest = params.get("OnlyShowLatest")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryListResponse(AbstractModel):
    """DescribeAssetImageRegistryList response structure.

    """

    def __init__(self):
        r"""
        :param List: List of image repositories
Note: This field may return null, indicating that no valid values can be obtained.
        :type List: list of ImageRepoInfo
        :param TotalCount: Total number
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = ImageRepoInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeAssetImageRegistryRegistryDetailRequest(AbstractModel):
    """DescribeAssetImageRegistryRegistryDetail request structure.

    """

    def __init__(self):
        r"""
        :param RegistryId: Unique repository ID
        :type RegistryId: int
        """
        self.RegistryId = None


    def _deserialize(self, params):
        self.RegistryId = params.get("RegistryId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryRegistryDetailResponse(AbstractModel):
    """DescribeAssetImageRegistryRegistryDetail response structure.

    """

    def __init__(self):
        r"""
        :param Name: Repository name
        :type Name: str
        :param Username: Username
        :type Username: str
        :param Password: Password
        :type Password: str
        :param Url: Repository URL
        :type Url: str
        :param RegistryType: Repository type, which can be `harbor`.
        :type RegistryType: str
        :param RegistryVersion: Repository version
Note: This field may return null, indicating that no valid values can be obtained.
        :type RegistryVersion: str
        :param NetType: Network type, which can be `public` (public network).
        :type NetType: str
        :param RegistryRegion: Region. Default value: `default`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RegistryRegion: str
        :param SpeedLimit: Speed limit
Note: This field may return null, indicating that no valid values can be obtained.
        :type SpeedLimit: int
        :param Insecure: Valid values: `0` (secure mode with certificate verification, which is the default value); `1` (unsecure mode that skips certificate verification).
Note: This field may return null, indicating that no valid values can be obtained.
        :type Insecure: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.Name = None
        self.Username = None
        self.Password = None
        self.Url = None
        self.RegistryType = None
        self.RegistryVersion = None
        self.NetType = None
        self.RegistryRegion = None
        self.SpeedLimit = None
        self.Insecure = None
        self.RequestId = None


    def _deserialize(self, params):
        self.Name = params.get("Name")
        self.Username = params.get("Username")
        self.Password = params.get("Password")
        self.Url = params.get("Url")
        self.RegistryType = params.get("RegistryType")
        self.RegistryVersion = params.get("RegistryVersion")
        self.NetType = params.get("NetType")
        self.RegistryRegion = params.get("RegistryRegion")
        self.SpeedLimit = params.get("SpeedLimit")
        self.Insecure = params.get("Insecure")
        self.RequestId = params.get("RequestId")


class DescribeAssetImageRegistryRegistryListRequest(AbstractModel):
    """DescribeAssetImageRegistryRegistryList request structure.

    """


class DescribeAssetImageRegistryRegistryListResponse(AbstractModel):
    """DescribeAssetImageRegistryRegistryList response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class DescribeAssetImageRegistryRiskInfoListRequest(AbstractModel):
    """DescribeAssetImageRegistryRiskInfoList request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>Level- String - Required: No - Vulnerability level</li>
<li>Name - String - Required: No - Vulnerability name</li>
        :type Filters: list of AssetFilters
        :param ImageInfo: Image ID
        :type ImageInfo: :class:`tencentcloud.tcss.v20201101.models.ImageInfo`
        :param By: Sorting field: `Level`.
        :type By: str
        :param Order: Sorting order. Valid values: `+`, `-`.
        :type Order: str
        :param Id: Image ID
        :type Id: int
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.ImageInfo = None
        self.By = None
        self.Order = None
        self.Id = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        if params.get("ImageInfo") is not None:
            self.ImageInfo = ImageInfo()
            self.ImageInfo._deserialize(params.get("ImageInfo"))
        self.By = params.get("By")
        self.Order = params.get("Order")
        self.Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryRiskInfoListResponse(AbstractModel):
    """DescribeAssetImageRegistryRiskInfoList response structure.

    """

    def __init__(self):
        r"""
        :param List: List of image vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained.
        :type List: list of ImageRisk
        :param TotalCount: Total number
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = ImageRisk()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeAssetImageRegistryRiskListExportRequest(AbstractModel):
    """DescribeAssetImageRegistryRiskListExport request structure.

    """

    def __init__(self):
        r"""
        :param ExportField: Export field
        :type ExportField: list of str
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>Level- String - Required: No - Vulnerability level</li>
<li>Name - String - Required: No - Vulnerability name</li>
        :type Filters: list of AssetFilters
        :param ImageInfo: Image information
        :type ImageInfo: :class:`tencentcloud.tcss.v20201101.models.ImageInfo`
        :param Id: Image ID
        :type Id: int
        """
        self.ExportField = None
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.ImageInfo = None
        self.Id = None


    def _deserialize(self, params):
        self.ExportField = params.get("ExportField")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        if params.get("ImageInfo") is not None:
            self.ImageInfo = ImageInfo()
            self.ImageInfo._deserialize(params.get("ImageInfo"))
        self.Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryRiskListExportResponse(AbstractModel):
    """DescribeAssetImageRegistryRiskListExport response structure.

    """

    def __init__(self):
        r"""
        :param DownloadUrl: Excel file download URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type DownloadUrl: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.DownloadUrl = None
        self.RequestId = None


    def _deserialize(self, params):
        self.DownloadUrl = params.get("DownloadUrl")
        self.RequestId = params.get("RequestId")


class DescribeAssetImageRegistryScanStatusOneKeyRequest(AbstractModel):
    """DescribeAssetImageRegistryScanStatusOneKey request structure.

    """

    def __init__(self):
        r"""
        :param Images: List of images for which to get the progress
        :type Images: list of ImageInfo
        :param All: Whether to get all images
        :type All: bool
        :param Id: List of IDs of images for which to get the progress
        :type Id: list of int non-negative
        """
        self.Images = None
        self.All = None
        self.Id = None


    def _deserialize(self, params):
        if params.get("Images") is not None:
            self.Images = []
            for item in params.get("Images"):
                obj = ImageInfo()
                obj._deserialize(item)
                self.Images.append(obj)
        self.All = params.get("All")
        self.Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryScanStatusOneKeyResponse(AbstractModel):
    """DescribeAssetImageRegistryScanStatusOneKey response structure.

    """

    def __init__(self):
        r"""
        :param ImageTotal: Number of images
        :type ImageTotal: int
        :param ImageScanCnt: Number of scanned images
        :type ImageScanCnt: int
        :param ImageStatus: Scanning progress list
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageStatus: list of ImageProgress
        :param SuccessCount: Number of successfully scanned images
        :type SuccessCount: int
        :param RiskCount: Number of risks
        :type RiskCount: int
        :param Schedule: Scanning progress
        :type Schedule: int
        :param Status: Scanning status
        :type Status: str
        :param ScanRemainTime: Remaining scan time
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanRemainTime: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.ImageTotal = None
        self.ImageScanCnt = None
        self.ImageStatus = None
        self.SuccessCount = None
        self.RiskCount = None
        self.Schedule = None
        self.Status = None
        self.ScanRemainTime = None
        self.RequestId = None


    def _deserialize(self, params):
        self.ImageTotal = params.get("ImageTotal")
        self.ImageScanCnt = params.get("ImageScanCnt")
        if params.get("ImageStatus") is not None:
            self.ImageStatus = []
            for item in params.get("ImageStatus"):
                obj = ImageProgress()
                obj._deserialize(item)
                self.ImageStatus.append(obj)
        self.SuccessCount = params.get("SuccessCount")
        self.RiskCount = params.get("RiskCount")
        self.Schedule = params.get("Schedule")
        self.Status = params.get("Status")
        self.ScanRemainTime = params.get("ScanRemainTime")
        self.RequestId = params.get("RequestId")


class DescribeAssetImageRegistrySummaryRequest(AbstractModel):
    """DescribeAssetImageRegistrySummary request structure.

    """


class DescribeAssetImageRegistrySummaryResponse(AbstractModel):
    """DescribeAssetImageRegistrySummary response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class DescribeAssetImageRegistryVirusListExportRequest(AbstractModel):
    """DescribeAssetImageRegistryVirusListExport request structure.

    """

    def __init__(self):
        r"""
        :param ExportField: Export field
        :type ExportField: list of str
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>Level- String - Required: No - Vulnerability level</li>
<li>Name - String - Required: No - Vulnerability name</li>
        :type Filters: list of AssetFilters
        :param ImageInfo: Image information
        :type ImageInfo: :class:`tencentcloud.tcss.v20201101.models.ImageInfo`
        :param Id: Image ID
        :type Id: int
        """
        self.ExportField = None
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.ImageInfo = None
        self.Id = None


    def _deserialize(self, params):
        self.ExportField = params.get("ExportField")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        if params.get("ImageInfo") is not None:
            self.ImageInfo = ImageInfo()
            self.ImageInfo._deserialize(params.get("ImageInfo"))
        self.Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryVirusListExportResponse(AbstractModel):
    """DescribeAssetImageRegistryVirusListExport response structure.

    """

    def __init__(self):
        r"""
        :param DownloadUrl: Excel file download URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type DownloadUrl: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.DownloadUrl = None
        self.RequestId = None


    def _deserialize(self, params):
        self.DownloadUrl = params.get("DownloadUrl")
        self.RequestId = params.get("RequestId")


class DescribeAssetImageRegistryVirusListRequest(AbstractModel):
    """DescribeAssetImageRegistryVirusList request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>Level- String - Required: No - Vulnerability level</li>
<li>Name - String - Required: No - Vulnerability name</li>
        :type Filters: list of AssetFilters
        :param ImageInfo: Image information
        :type ImageInfo: :class:`tencentcloud.tcss.v20201101.models.ImageInfo`
        :param Id: Image ID
        :type Id: int
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.ImageInfo = None
        self.Id = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        if params.get("ImageInfo") is not None:
            self.ImageInfo = ImageInfo()
            self.ImageInfo._deserialize(params.get("ImageInfo"))
        self.Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryVirusListResponse(AbstractModel):
    """DescribeAssetImageRegistryVirusList response structure.

    """

    def __init__(self):
        r"""
        :param List: List of image vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained.
        :type List: list of ImageVirus
        :param TotalCount: Total number
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = ImageVirus()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeAssetImageRegistryVulListExportRequest(AbstractModel):
    """DescribeAssetImageRegistryVulListExport request structure.

    """

    def __init__(self):
        r"""
        :param ExportField: Export field
        :type ExportField: list of str
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>Level- String - Required: No - Vulnerability level</li>
<li>Name - String - Required: No - Vulnerability name</li>
        :type Filters: list of AssetFilters
        :param ImageInfo: Image information
        :type ImageInfo: :class:`tencentcloud.tcss.v20201101.models.ImageInfo`
        :param Id: Image ID
        :type Id: int
        """
        self.ExportField = None
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.ImageInfo = None
        self.Id = None


    def _deserialize(self, params):
        self.ExportField = params.get("ExportField")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        if params.get("ImageInfo") is not None:
            self.ImageInfo = ImageInfo()
            self.ImageInfo._deserialize(params.get("ImageInfo"))
        self.Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryVulListExportResponse(AbstractModel):
    """DescribeAssetImageRegistryVulListExport response structure.

    """

    def __init__(self):
        r"""
        :param DownloadUrl: Excel file download URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type DownloadUrl: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.DownloadUrl = None
        self.RequestId = None


    def _deserialize(self, params):
        self.DownloadUrl = params.get("DownloadUrl")
        self.RequestId = params.get("RequestId")


class DescribeAssetImageRegistryVulListRequest(AbstractModel):
    """DescribeAssetImageRegistryVulList request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>Level- String - Required: No - Vulnerability level</li>
<li>Name - String - Required: No - Vulnerability name</li>
        :type Filters: list of AssetFilters
        :param ImageInfo: Image information
        :type ImageInfo: :class:`tencentcloud.tcss.v20201101.models.ImageInfo`
        :param Id: Image ID
        :type Id: int
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.ImageInfo = None
        self.Id = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        if params.get("ImageInfo") is not None:
            self.ImageInfo = ImageInfo()
            self.ImageInfo._deserialize(params.get("ImageInfo"))
        self.Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryVulListResponse(AbstractModel):
    """DescribeAssetImageRegistryVulList response structure.

    """

    def __init__(self):
        r"""
        :param List: List of image vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained.
        :type List: list of ImageVul
        :param TotalCount: Total number
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = ImageVul()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeAssetImageRiskListExportRequest(AbstractModel):
    """DescribeAssetImageRiskListExport request structure.

    """

    def __init__(self):
        r"""
        :param ExportField: Export field
        :type ExportField: list of str
        :param ImageID: Image ID
        :type ImageID: str
        :param Filters: Filter
<li>Level- String - Required: No - Risk level. Valid values: `1`, `2`, `3`, `4`.</li>
<li>Behavior - String - Required: No - Risky behavior. Valid values: `1`, `2`, `3`, `4`.</li>
<li>Type - String - Required: No - Risk type. Valid values: `1`, `2`.</li>
        :type Filters: list of AssetFilters
        """
        self.ExportField = None
        self.ImageID = None
        self.Filters = None


    def _deserialize(self, params):
        self.ExportField = params.get("ExportField")
        self.ImageID = params.get("ImageID")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRiskListExportResponse(AbstractModel):
    """DescribeAssetImageRiskListExport response structure.

    """

    def __init__(self):
        r"""
        :param DownloadUrl: Excel file download URL
        :type DownloadUrl: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.DownloadUrl = None
        self.RequestId = None


    def _deserialize(self, params):
        self.DownloadUrl = params.get("DownloadUrl")
        self.RequestId = params.get("RequestId")


class DescribeAssetImageRiskListRequest(AbstractModel):
    """DescribeAssetImageRiskList request structure.

    """

    def __init__(self):
        r"""
        :param ImageID: Image ID
        :type ImageID: str
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>Level- String - Required: No - Risk level. Valid values: `1`, `2`, `3`, `4`.</li>
<li>Behavior - String - Required: No - Risky behavior. Valid values: `1`, `2`, `3`, `4`.</li>
<li>Type - String - Required: No - Risk type. Valid values: `1`, `2`.</li>
        :type Filters: list of AssetFilters
        :param By: Sorting field
        :type By: str
        :param Order: Sorting order
        :type Order: str
        """
        self.ImageID = None
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.By = None
        self.Order = None


    def _deserialize(self, params):
        self.ImageID = params.get("ImageID")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.By = params.get("By")
        self.Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRiskListResponse(AbstractModel):
    """DescribeAssetImageRiskList response structure.

    """

    def __init__(self):
        r"""
        :param List: List of viruses in the image
        :type List: list of ImageRiskInfo
        :param TotalCount: Total number
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = ImageRiskInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeAssetImageScanSettingRequest(AbstractModel):
    """DescribeAssetImageScanSetting request structure.

    """


class DescribeAssetImageScanSettingResponse(AbstractModel):
    """DescribeAssetImageScanSetting response structure.

    """

    def __init__(self):
        r"""
        :param Enable: Switch
        :type Enable: bool
        :param ScanTime: Scan time, which is a complete time and parsed as hour/minute/second in time zone 0 on the backend.
        :type ScanTime: str
        :param ScanPeriod: Scan interval
        :type ScanPeriod: int
        :param ScanVirus: Trojan scan
        :type ScanVirus: bool
        :param ScanRisk: Sensitive data scan
        :type ScanRisk: bool
        :param ScanVul: Vulnerability scan
        :type ScanVul: bool
        :param All: Scan of all images
        :type All: bool
        :param Images: Scan of specified images
        :type Images: list of str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.Enable = None
        self.ScanTime = None
        self.ScanPeriod = None
        self.ScanVirus = None
        self.ScanRisk = None
        self.ScanVul = None
        self.All = None
        self.Images = None
        self.RequestId = None


    def _deserialize(self, params):
        self.Enable = params.get("Enable")
        self.ScanTime = params.get("ScanTime")
        self.ScanPeriod = params.get("ScanPeriod")
        self.ScanVirus = params.get("ScanVirus")
        self.ScanRisk = params.get("ScanRisk")
        self.ScanVul = params.get("ScanVul")
        self.All = params.get("All")
        self.Images = params.get("Images")
        self.RequestId = params.get("RequestId")


class DescribeAssetImageScanStatusRequest(AbstractModel):
    """DescribeAssetImageScanStatus request structure.

    """

    def __init__(self):
        r"""
        :param TaskID: Task ID
        :type TaskID: str
        """
        self.TaskID = None


    def _deserialize(self, params):
        self.TaskID = params.get("TaskID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageScanStatusResponse(AbstractModel):
    """DescribeAssetImageScanStatus response structure.

    """

    def __init__(self):
        r"""
        :param ImageTotal: Number of images
        :type ImageTotal: int
        :param ImageScanCnt: Number of scanned images
        :type ImageScanCnt: int
        :param Status: Scanning status
        :type Status: str
        :param Schedule: Scanning progress, the value of which is calculated as `ImageScanCnt`/`ImageTotal` * 100.
        :type Schedule: int
        :param SuccessCount: Number of successfully scanned images
        :type SuccessCount: int
        :param RiskCount: Number of risks
        :type RiskCount: int
        :param LeftSeconds: Remaining scan time
        :type LeftSeconds: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.ImageTotal = None
        self.ImageScanCnt = None
        self.Status = None
        self.Schedule = None
        self.SuccessCount = None
        self.RiskCount = None
        self.LeftSeconds = None
        self.RequestId = None


    def _deserialize(self, params):
        self.ImageTotal = params.get("ImageTotal")
        self.ImageScanCnt = params.get("ImageScanCnt")
        self.Status = params.get("Status")
        self.Schedule = params.get("Schedule")
        self.SuccessCount = params.get("SuccessCount")
        self.RiskCount = params.get("RiskCount")
        self.LeftSeconds = params.get("LeftSeconds")
        self.RequestId = params.get("RequestId")


class DescribeAssetImageScanTaskRequest(AbstractModel):
    """DescribeAssetImageScanTask request structure.

    """


class DescribeAssetImageScanTaskResponse(AbstractModel):
    """DescribeAssetImageScanTask response structure.

    """

    def __init__(self):
        r"""
        :param TaskID: Task ID
        :type TaskID: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskID = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskID = params.get("TaskID")
        self.RequestId = params.get("RequestId")


class DescribeAssetImageSimpleListRequest(AbstractModel):
    """DescribeAssetImageSimpleList request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>Keywords- String - Required: No - Image name/ID</li>
        :type Filters: list of AssetFilters
        :param By: Sorting field
        :type By: str
        :param Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.By = None
        self.Order = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.By = params.get("By")
        self.Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageSimpleListResponse(AbstractModel):
    """DescribeAssetImageSimpleList response structure.

    """

    def __init__(self):
        r"""
        :param List: List of images
        :type List: list of AssetSimpleImageInfo
        :param TotalCount: Total number
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = AssetSimpleImageInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeAssetImageVirusListExportRequest(AbstractModel):
    """DescribeAssetImageVirusListExport request structure.

    """

    def __init__(self):
        r"""
        :param ExportField: Fields supported in the list
        :type ExportField: list of str
        :param ImageID: Image ID
        :type ImageID: str
        :param Filters: Filter
<li>Name- String - Required: No - Image name</li>
<li>RiskLevel - String - Required: No - Risk level. Valid values: `1`, `2`, `3`, `4`.</li>
        :type Filters: list of AssetFilters
        """
        self.ExportField = None
        self.ImageID = None
        self.Filters = None


    def _deserialize(self, params):
        self.ExportField = params.get("ExportField")
        self.ImageID = params.get("ImageID")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageVirusListExportResponse(AbstractModel):
    """DescribeAssetImageVirusListExport response structure.

    """

    def __init__(self):
        r"""
        :param DownloadUrl: Excel file download URL
        :type DownloadUrl: str
        :param JobId: Task ID
        :type JobId: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.DownloadUrl = None
        self.JobId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.DownloadUrl = params.get("DownloadUrl")
        self.JobId = params.get("JobId")
        self.RequestId = params.get("RequestId")


class DescribeAssetImageVirusListRequest(AbstractModel):
    """DescribeAssetImageVirusList request structure.

    """

    def __init__(self):
        r"""
        :param ImageID: Image ID
        :type ImageID: str
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>Name- String - Required: No - Image name</li>
<li>RiskLevel - String - Required: No - Risk level. Valid values: `1`, `2`, `3`, `4`.</li>
        :type Filters: list of AssetFilters
        :param Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        :param By: Sorting field
        :type By: str
        """
        self.ImageID = None
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.ImageID = params.get("ImageID")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageVirusListResponse(AbstractModel):
    """DescribeAssetImageVirusList response structure.

    """

    def __init__(self):
        r"""
        :param List: List of viruses in the image
        :type List: list of ImageVirusInfo
        :param TotalCount: Total number
        :type TotalCount: int
        :param VirusScanStatus: Virus scanning status
`0`: Not scanned.
`1`: Scanning.
`2`: Scanned.
`3`: Scan error.
`4`: Scan canceled.
        :type VirusScanStatus: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.VirusScanStatus = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = ImageVirusInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.VirusScanStatus = params.get("VirusScanStatus")
        self.RequestId = params.get("RequestId")


class DescribeAssetImageVulListExportRequest(AbstractModel):
    """DescribeAssetImageVulListExport request structure.

    """

    def __init__(self):
        r"""
        :param ExportField: Export field
        :type ExportField: list of str
        :param ImageID: Image ID
        :type ImageID: str
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>Name- String - Required: No - Vulnerability name</li>
<li>Level - String - Required: No - Risk level. Valid values: `1`, `2`, `3`, `4`.</li>
        :type Filters: list of AssetFilters
        """
        self.ExportField = None
        self.ImageID = None
        self.Limit = None
        self.Offset = None
        self.Filters = None


    def _deserialize(self, params):
        self.ExportField = params.get("ExportField")
        self.ImageID = params.get("ImageID")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageVulListExportResponse(AbstractModel):
    """DescribeAssetImageVulListExport response structure.

    """

    def __init__(self):
        r"""
        :param DownloadUrl: Excel file download URL
        :type DownloadUrl: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.DownloadUrl = None
        self.RequestId = None


    def _deserialize(self, params):
        self.DownloadUrl = params.get("DownloadUrl")
        self.RequestId = params.get("RequestId")


class DescribeAssetImageVulListRequest(AbstractModel):
    """DescribeAssetImageVulList request structure.

    """

    def __init__(self):
        r"""
        :param ImageID: Image ID
        :type ImageID: str
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>Name- String - Required: No - Vulnerability name</li>
<li>Level - String - Required: No - Risk level. Valid values: `1`, `2`, `3`, `4`.</li>
        :type Filters: list of AssetFilters
        :param By: Sorting field: `Level`.
        :type By: str
        :param Order: Sorting order. Valid values: `+`, `-`.
        :type Order: str
        """
        self.ImageID = None
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.By = None
        self.Order = None


    def _deserialize(self, params):
        self.ImageID = params.get("ImageID")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.By = params.get("By")
        self.Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageVulListResponse(AbstractModel):
    """DescribeAssetImageVulList response structure.

    """

    def __init__(self):
        r"""
        :param List: List of image vulnerabilities
        :type List: list of ImagesVul
        :param TotalCount: Total number
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = ImagesVul()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeAssetPortListRequest(AbstractModel):
    """DescribeAssetPortList request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>All - String - Required: No - Optional field for the fuzzy query</li>
<li>RunAs - String - Required: No - Operator</li>
<li>ContainerID - String - Required: No - Container ID</li>
<li>HostID- String - Required: Yes - Server ID</li>
<li>HostIP- string - Required: No - Server IP</li>
<li>ProcessName- string - Required: No - Process name</li>
        :type Filters: list of AssetFilters
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetPortListResponse(AbstractModel):
    """DescribeAssetPortList response structure.

    """

    def __init__(self):
        r"""
        :param List: List of ports
        :type List: list of PortInfo
        :param TotalCount: Total number
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = PortInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeAssetProcessListRequest(AbstractModel):
    """DescribeAssetProcessList request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>RunAs - String - Required: No - Operator</li>
<li>ContainerID - String - Required: No - Container ID</li>
<li>HostID- String - Required: Yes - Server ID</li>
<li>HostIP- string - Required: No - Server IP</li>
<li>ProcessName- string - Required: No - Process name</li>
<li>Pid- string - Required: No - Process ID (associated process)</li>
        :type Filters: list of AssetFilters
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetProcessListResponse(AbstractModel):
    """DescribeAssetProcessList response structure.

    """

    def __init__(self):
        r"""
        :param List: List of ports
        :type List: list of ProcessInfo
        :param TotalCount: Total number
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = ProcessInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeAssetSummaryRequest(AbstractModel):
    """DescribeAssetSummary request structure.

    """


class DescribeAssetSummaryResponse(AbstractModel):
    """DescribeAssetSummary response structure.

    """

    def __init__(self):
        r"""
        :param AppCnt: Number of applications
        :type AppCnt: int
        :param ContainerCnt: Number of containers
        :type ContainerCnt: int
        :param ContainerPause: Number of paused containers
        :type ContainerPause: int
        :param ContainerRunning: Number of running containers
        :type ContainerRunning: int
        :param ContainerStop: Number of stopped containers
        :type ContainerStop: int
        :param CreateTime: Creation time
        :type CreateTime: str
        :param DbCnt: Number of databases
        :type DbCnt: int
        :param ImageCnt: Number of images
        :type ImageCnt: int
        :param HostOnline: Number of online servers
        :type HostOnline: int
        :param HostCnt: Number of servers
        :type HostCnt: int
        :param ImageHasRiskInfoCnt: Number of images at risk
        :type ImageHasRiskInfoCnt: int
        :param ImageHasVirusCnt: Number of images with viruses
        :type ImageHasVirusCnt: int
        :param ImageHasVulsCnt: Number of images with vulnerabilities
        :type ImageHasVulsCnt: int
        :param ImageUntrustCnt: Number of untrusted images
        :type ImageUntrustCnt: int
        :param ListenPortCnt: Number of listened ports
        :type ListenPortCnt: int
        :param ProcessCnt: Number of processes
        :type ProcessCnt: int
        :param WebServiceCnt: Number of web services
        :type WebServiceCnt: int
        :param LatestImageScanTime: Last image scan time
        :type LatestImageScanTime: str
        :param ImageUnsafeCnt: Number of images at risk
        :type ImageUnsafeCnt: int
        :param HostUnInstallCnt: Number of servers not installed with the agent
        :type HostUnInstallCnt: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.AppCnt = None
        self.ContainerCnt = None
        self.ContainerPause = None
        self.ContainerRunning = None
        self.ContainerStop = None
        self.CreateTime = None
        self.DbCnt = None
        self.ImageCnt = None
        self.HostOnline = None
        self.HostCnt = None
        self.ImageHasRiskInfoCnt = None
        self.ImageHasVirusCnt = None
        self.ImageHasVulsCnt = None
        self.ImageUntrustCnt = None
        self.ListenPortCnt = None
        self.ProcessCnt = None
        self.WebServiceCnt = None
        self.LatestImageScanTime = None
        self.ImageUnsafeCnt = None
        self.HostUnInstallCnt = None
        self.RequestId = None


    def _deserialize(self, params):
        self.AppCnt = params.get("AppCnt")
        self.ContainerCnt = params.get("ContainerCnt")
        self.ContainerPause = params.get("ContainerPause")
        self.ContainerRunning = params.get("ContainerRunning")
        self.ContainerStop = params.get("ContainerStop")
        self.CreateTime = params.get("CreateTime")
        self.DbCnt = params.get("DbCnt")
        self.ImageCnt = params.get("ImageCnt")
        self.HostOnline = params.get("HostOnline")
        self.HostCnt = params.get("HostCnt")
        self.ImageHasRiskInfoCnt = params.get("ImageHasRiskInfoCnt")
        self.ImageHasVirusCnt = params.get("ImageHasVirusCnt")
        self.ImageHasVulsCnt = params.get("ImageHasVulsCnt")
        self.ImageUntrustCnt = params.get("ImageUntrustCnt")
        self.ListenPortCnt = params.get("ListenPortCnt")
        self.ProcessCnt = params.get("ProcessCnt")
        self.WebServiceCnt = params.get("WebServiceCnt")
        self.LatestImageScanTime = params.get("LatestImageScanTime")
        self.ImageUnsafeCnt = params.get("ImageUnsafeCnt")
        self.HostUnInstallCnt = params.get("HostUnInstallCnt")
        self.RequestId = params.get("RequestId")


class DescribeAssetSyncLastTimeRequest(AbstractModel):
    """DescribeAssetSyncLastTime request structure.

    """


class DescribeAssetSyncLastTimeResponse(AbstractModel):
    """DescribeAssetSyncLastTime response structure.

    """

    def __init__(self):
        r"""
        :param AssetSyncLastTime: Last asset sync time
        :type AssetSyncLastTime: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.AssetSyncLastTime = None
        self.RequestId = None


    def _deserialize(self, params):
        self.AssetSyncLastTime = params.get("AssetSyncLastTime")
        self.RequestId = params.get("RequestId")


class DescribeAssetWebServiceListRequest(AbstractModel):
    """DescribeAssetWebServiceList request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>Keywords- String - Required: No - Optional field for the fuzzy query</li>
<li>Type- String - Required: No - Server status. "Apache"
"Jboss"
"lighttpd"
"Nginx"
"Tomcat"</li>
        :type Filters: list of AssetFilters
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetWebServiceListResponse(AbstractModel):
    """DescribeAssetWebServiceList response structure.

    """

    def __init__(self):
        r"""
        :param List: List of servers
        :type List: list of ServiceInfo
        :param TotalCount: Total number
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = ServiceInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeAutoAuthorizedRuleHostRequest(AbstractModel):
    """DescribeAutoAuthorizedRuleHost request structure.

    """

    def __init__(self):
        r"""
        :param RuleId: Rule ID
        :type RuleId: int
        :param Limit: Number of results to be returned. Default value: `all`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Order: Sorting field
        :type Order: str
        :param By: Sorting order. Valid values: `asc`, `desc`.
        :type By: str
        """
        self.RuleId = None
        self.Limit = None
        self.Offset = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.RuleId = params.get("RuleId")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoAuthorizedRuleHostResponse(AbstractModel):
    """DescribeAutoAuthorizedRuleHost response structure.

    """

    def __init__(self):
        r"""
        :param List: List of servers licensed based on the automatic image licensing rule
        :type List: list of AutoAuthorizedRuleHostInfo
        :param TotalCount: Total number
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = AutoAuthorizedRuleHostInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeCheckItemListRequest(AbstractModel):
    """DescribeCheckItemList request structure.

    """

    def __init__(self):
        r"""
        :param Offset: Offset
        :type Offset: int
        :param Limit: Maximum number of records per query
        :type Limit: int
        :param Filters: Name. Valid values: `risk_level` (risk level); `risk_target` (check target and risky target); `risk_type` (risk type); `risk_attri` (risk type of the check item).
        :type Filters: list of ComplianceFilters
        """
        self.Offset = None
        self.Limit = None
        self.Filters = None


    def _deserialize(self, params):
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCheckItemListResponse(AbstractModel):
    """DescribeCheckItemList response structure.

    """

    def __init__(self):
        r"""
        :param ClusterCheckItems: Array of check item details
        :type ClusterCheckItems: list of ClusterCheckItem
        :param TotalCount: Total number of check items
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.ClusterCheckItems = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("ClusterCheckItems") is not None:
            self.ClusterCheckItems = []
            for item in params.get("ClusterCheckItems"):
                obj = ClusterCheckItem()
                obj._deserialize(item)
                self.ClusterCheckItems.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeClusterDetailRequest(AbstractModel):
    """DescribeClusterDetail request structure.

    """

    def __init__(self):
        r"""
        :param ClusterId: Cluster ID
        :type ClusterId: str
        """
        self.ClusterId = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterDetailResponse(AbstractModel):
    """DescribeClusterDetail response structure.

    """

    def __init__(self):
        r"""
        :param ClusterId: Cluster ID
        :type ClusterId: str
        :param ClusterName: Cluster name
        :type ClusterName: str
        :param ScanTaskProgress: Progress of the current cluster scan task. `100` indicates that the scan is completed.
        :type ScanTaskProgress: int
        :param ClusterVersion: Cluster version
        :type ClusterVersion: str
        :param ContainerRuntime: Runtime component
        :type ContainerRuntime: str
        :param ClusterNodeNum: Number of nodes in the cluster
        :type ClusterNodeNum: int
        :param ClusterStatus: Cluster status. Valid values: `Running`, `Creating`, `Abnormal`.
        :type ClusterStatus: str
        :param ClusterType: Cluster type. Valid values: `MANAGED_CLUSTER` (managed cluster); `INDEPENDENT_CLUSTER` (self-deployed cluster).
        :type ClusterType: str
        :param Region: Cluster region
        :type Region: str
        :param SeriousRiskCount: Number of critical check items
        :type SeriousRiskCount: int
        :param HighRiskCount: Number of high-risk check items
        :type HighRiskCount: int
        :param MiddleRiskCount: Number of medium-risk check items
        :type MiddleRiskCount: int
        :param HintRiskCount: Number of prompt-risk check items
        :type HintRiskCount: int
        :param CheckStatus: Status of the check task
        :type CheckStatus: str
        :param DefenderStatus: Status of the defender
        :type DefenderStatus: str
        :param TaskCreateTime: Creation time of the scan task
        :type TaskCreateTime: str
        :param NetworkType: Network type. Valid values: `PublicNetwork` (public network); `VPCNetwork` (VPC).
        :type NetworkType: str
        :param ApiServerAddress: API server address
        :type ApiServerAddress: str
        :param NodeCount: Number of nodes
        :type NodeCount: int
        :param NamespaceCount: Number of namespaces
        :type NamespaceCount: int
        :param WorkloadCount: Number of workloads
        :type WorkloadCount: int
        :param PodCount: Number of Pods
        :type PodCount: int
        :param ServiceCount: Number of Services
        :type ServiceCount: int
        :param IngressCount: Number of Ingresses
        :type IngressCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.ClusterId = None
        self.ClusterName = None
        self.ScanTaskProgress = None
        self.ClusterVersion = None
        self.ContainerRuntime = None
        self.ClusterNodeNum = None
        self.ClusterStatus = None
        self.ClusterType = None
        self.Region = None
        self.SeriousRiskCount = None
        self.HighRiskCount = None
        self.MiddleRiskCount = None
        self.HintRiskCount = None
        self.CheckStatus = None
        self.DefenderStatus = None
        self.TaskCreateTime = None
        self.NetworkType = None
        self.ApiServerAddress = None
        self.NodeCount = None
        self.NamespaceCount = None
        self.WorkloadCount = None
        self.PodCount = None
        self.ServiceCount = None
        self.IngressCount = None
        self.RequestId = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        self.ClusterName = params.get("ClusterName")
        self.ScanTaskProgress = params.get("ScanTaskProgress")
        self.ClusterVersion = params.get("ClusterVersion")
        self.ContainerRuntime = params.get("ContainerRuntime")
        self.ClusterNodeNum = params.get("ClusterNodeNum")
        self.ClusterStatus = params.get("ClusterStatus")
        self.ClusterType = params.get("ClusterType")
        self.Region = params.get("Region")
        self.SeriousRiskCount = params.get("SeriousRiskCount")
        self.HighRiskCount = params.get("HighRiskCount")
        self.MiddleRiskCount = params.get("MiddleRiskCount")
        self.HintRiskCount = params.get("HintRiskCount")
        self.CheckStatus = params.get("CheckStatus")
        self.DefenderStatus = params.get("DefenderStatus")
        self.TaskCreateTime = params.get("TaskCreateTime")
        self.NetworkType = params.get("NetworkType")
        self.ApiServerAddress = params.get("ApiServerAddress")
        self.NodeCount = params.get("NodeCount")
        self.NamespaceCount = params.get("NamespaceCount")
        self.WorkloadCount = params.get("WorkloadCount")
        self.PodCount = params.get("PodCount")
        self.ServiceCount = params.get("ServiceCount")
        self.IngressCount = params.get("IngressCount")
        self.RequestId = params.get("RequestId")


class DescribeClusterSummaryRequest(AbstractModel):
    """DescribeClusterSummary request structure.

    """


class DescribeClusterSummaryResponse(AbstractModel):
    """DescribeClusterSummary response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number of clusters
        :type TotalCount: int
        :param RiskClusterCount: Number of clusters at risk
        :type RiskClusterCount: int
        :param UncheckClusterCount: Number of clusters not checked
        :type UncheckClusterCount: int
        :param ManagedClusterCount: Number of managed clusters
        :type ManagedClusterCount: int
        :param IndependentClusterCount: Number of self-deployed clusters
        :type IndependentClusterCount: int
        :param NoRiskClusterCount: Number of clusters involving no risks
        :type NoRiskClusterCount: int
        :param CheckedClusterCount: Number of checked clusters
        :type CheckedClusterCount: int
        :param AutoCheckClusterCount: Number of clusters automatically checked
        :type AutoCheckClusterCount: int
        :param ManualCheckClusterCount: Number of clusters manually checked
        :type ManualCheckClusterCount: int
        :param FailedClusterCount: Number of clusters that failed the check
        :type FailedClusterCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.RiskClusterCount = None
        self.UncheckClusterCount = None
        self.ManagedClusterCount = None
        self.IndependentClusterCount = None
        self.NoRiskClusterCount = None
        self.CheckedClusterCount = None
        self.AutoCheckClusterCount = None
        self.ManualCheckClusterCount = None
        self.FailedClusterCount = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        self.RiskClusterCount = params.get("RiskClusterCount")
        self.UncheckClusterCount = params.get("UncheckClusterCount")
        self.ManagedClusterCount = params.get("ManagedClusterCount")
        self.IndependentClusterCount = params.get("IndependentClusterCount")
        self.NoRiskClusterCount = params.get("NoRiskClusterCount")
        self.CheckedClusterCount = params.get("CheckedClusterCount")
        self.AutoCheckClusterCount = params.get("AutoCheckClusterCount")
        self.ManualCheckClusterCount = params.get("ManualCheckClusterCount")
        self.FailedClusterCount = params.get("FailedClusterCount")
        self.RequestId = params.get("RequestId")


class DescribeComplianceAssetDetailInfoRequest(AbstractModel):
    """DescribeComplianceAssetDetailInfo request structure.

    """

    def __init__(self):
        r"""
        :param CustomerAssetId: Customer asset ID
        :type CustomerAssetId: int
        """
        self.CustomerAssetId = None


    def _deserialize(self, params):
        self.CustomerAssetId = params.get("CustomerAssetId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeComplianceAssetDetailInfoResponse(AbstractModel):
    """DescribeComplianceAssetDetailInfo response structure.

    """

    def __init__(self):
        r"""
        :param AssetDetailInfo: Asset details
        :type AssetDetailInfo: :class:`tencentcloud.tcss.v20201101.models.ComplianceAssetDetailInfo`
        :param ContainerDetailInfo: This field is returned when the asset is a container.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ContainerDetailInfo: :class:`tencentcloud.tcss.v20201101.models.ComplianceContainerDetailInfo`
        :param ImageDetailInfo: This field is returned when the asset is an image.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageDetailInfo: :class:`tencentcloud.tcss.v20201101.models.ComplianceImageDetailInfo`
        :param HostDetailInfo: This field is returned when the asset is a server.
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostDetailInfo: :class:`tencentcloud.tcss.v20201101.models.ComplianceHostDetailInfo`
        :param K8SDetailInfo: This field is returned when the asset is a K8s asset.
Note: This field may return null, indicating that no valid values can be obtained.
        :type K8SDetailInfo: :class:`tencentcloud.tcss.v20201101.models.ComplianceK8SDetailInfo`
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.AssetDetailInfo = None
        self.ContainerDetailInfo = None
        self.ImageDetailInfo = None
        self.HostDetailInfo = None
        self.K8SDetailInfo = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("AssetDetailInfo") is not None:
            self.AssetDetailInfo = ComplianceAssetDetailInfo()
            self.AssetDetailInfo._deserialize(params.get("AssetDetailInfo"))
        if params.get("ContainerDetailInfo") is not None:
            self.ContainerDetailInfo = ComplianceContainerDetailInfo()
            self.ContainerDetailInfo._deserialize(params.get("ContainerDetailInfo"))
        if params.get("ImageDetailInfo") is not None:
            self.ImageDetailInfo = ComplianceImageDetailInfo()
            self.ImageDetailInfo._deserialize(params.get("ImageDetailInfo"))
        if params.get("HostDetailInfo") is not None:
            self.HostDetailInfo = ComplianceHostDetailInfo()
            self.HostDetailInfo._deserialize(params.get("HostDetailInfo"))
        if params.get("K8SDetailInfo") is not None:
            self.K8SDetailInfo = ComplianceK8SDetailInfo()
            self.K8SDetailInfo._deserialize(params.get("K8SDetailInfo"))
        self.RequestId = params.get("RequestId")


class DescribeComplianceAssetListRequest(AbstractModel):
    """DescribeComplianceAssetList request structure.

    """

    def __init__(self):
        r"""
        :param AssetTypeSet: List of asset types
        :type AssetTypeSet: list of str
        :param Offset: Initial offset. Default value: `0`.
        :type Offset: int
        :param Limit: Number of results. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Filters: Query filter
        :type Filters: list of ComplianceFilters
        """
        self.AssetTypeSet = None
        self.Offset = None
        self.Limit = None
        self.Filters = None


    def _deserialize(self, params):
        self.AssetTypeSet = params.get("AssetTypeSet")
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeComplianceAssetListResponse(AbstractModel):
    """DescribeComplianceAssetList response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number of assets
        :type TotalCount: int
        :param AssetInfoList: List of assets
Note: This field may return null, indicating that no valid values can be obtained.
        :type AssetInfoList: list of ComplianceAssetInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.AssetInfoList = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("AssetInfoList") is not None:
            self.AssetInfoList = []
            for item in params.get("AssetInfoList"):
                obj = ComplianceAssetInfo()
                obj._deserialize(item)
                self.AssetInfoList.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeComplianceAssetPolicyItemListRequest(AbstractModel):
    """DescribeComplianceAssetPolicyItemList request structure.

    """

    def __init__(self):
        r"""
        :param CustomerAssetId: Customer asset ID
        :type CustomerAssetId: int
        :param Offset: Initial offset. Default value: `0`.
        :type Offset: int
        :param Limit: Number of results to be obtained. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Filters: Filter list, which is supported by the `Name` field.
RiskLevel
        :type Filters: list of ComplianceFilters
        """
        self.CustomerAssetId = None
        self.Offset = None
        self.Limit = None
        self.Filters = None


    def _deserialize(self, params):
        self.CustomerAssetId = params.get("CustomerAssetId")
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeComplianceAssetPolicyItemListResponse(AbstractModel):
    """DescribeComplianceAssetPolicyItemList response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number of check items, which is `0` if the baseline check is not enabled.
        :type TotalCount: int
        :param AssetPolicyItemList: List of check items of an asset
        :type AssetPolicyItemList: list of ComplianceAssetPolicyItem
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.AssetPolicyItemList = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("AssetPolicyItemList") is not None:
            self.AssetPolicyItemList = []
            for item in params.get("AssetPolicyItemList"):
                obj = ComplianceAssetPolicyItem()
                obj._deserialize(item)
                self.AssetPolicyItemList.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeCompliancePeriodTaskListRequest(AbstractModel):
    """DescribeCompliancePeriodTaskList request structure.

    """

    def __init__(self):
        r"""
        :param AssetType: Asset type. Valid values:
`ASSET_CONTAINER`: Container.
`ASSET_IMAGE`: Image.
`ASSET_HOST`: Server.
`ASSET_K8S`: K8s asset.
        :type AssetType: str
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        """
        self.AssetType = None
        self.Offset = None
        self.Limit = None


    def _deserialize(self, params):
        self.AssetType = params.get("AssetType")
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCompliancePeriodTaskListResponse(AbstractModel):
    """DescribeCompliancePeriodTaskList response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number of scheduled tasks
        :type TotalCount: int
        :param PeriodTaskSet: List of scheduled task information
        :type PeriodTaskSet: list of CompliancePeriodTask
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.PeriodTaskSet = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("PeriodTaskSet") is not None:
            self.PeriodTaskSet = []
            for item in params.get("PeriodTaskSet"):
                obj = CompliancePeriodTask()
                obj._deserialize(item)
                self.PeriodTaskSet.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeCompliancePolicyItemAffectedAssetListRequest(AbstractModel):
    """DescribeCompliancePolicyItemAffectedAssetList request structure.

    """

    def __init__(self):
        r"""
        :param CustomerPolicyItemId: `CustomerPolicyItemId` returned by `DescribeComplianceTaskPolicyItemSummaryList`, which indicates the check item ID.
        :type CustomerPolicyItemId: int
        :param Offset: Initial offset. Default value: `0`.
        :type Offset: int
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Filters: Filter
Name - String
Name. Valid values: `NodeName`, `CheckResult`.
        :type Filters: list of ComplianceFilters
        """
        self.CustomerPolicyItemId = None
        self.Offset = None
        self.Limit = None
        self.Filters = None


    def _deserialize(self, params):
        self.CustomerPolicyItemId = params.get("CustomerPolicyItemId")
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCompliancePolicyItemAffectedAssetListResponse(AbstractModel):
    """DescribeCompliancePolicyItemAffectedAssetList response structure.

    """

    def __init__(self):
        r"""
        :param AffectedAssetList: List of assets affected by each check item
        :type AffectedAssetList: list of ComplianceAffectedAsset
        :param TotalCount: Total number of assets affected by the check item
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.AffectedAssetList = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("AffectedAssetList") is not None:
            self.AffectedAssetList = []
            for item in params.get("AffectedAssetList"):
                obj = ComplianceAffectedAsset()
                obj._deserialize(item)
                self.AffectedAssetList.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeCompliancePolicyItemAffectedSummaryRequest(AbstractModel):
    """DescribeCompliancePolicyItemAffectedSummary request structure.

    """

    def __init__(self):
        r"""
        :param CustomerPolicyItemId: `CustomerPolicyItemId` returned by `DescribeComplianceTaskPolicyItemSummaryList`, which indicates the check item ID.
        :type CustomerPolicyItemId: int
        """
        self.CustomerPolicyItemId = None


    def _deserialize(self, params):
        self.CustomerPolicyItemId = params.get("CustomerPolicyItemId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCompliancePolicyItemAffectedSummaryResponse(AbstractModel):
    """DescribeCompliancePolicyItemAffectedSummary response structure.

    """

    def __init__(self):
        r"""
        :param PolicyItemSummary: Aggregated information of the assets affected by each check item
        :type PolicyItemSummary: :class:`tencentcloud.tcss.v20201101.models.CompliancePolicyItemSummary`
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.PolicyItemSummary = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("PolicyItemSummary") is not None:
            self.PolicyItemSummary = CompliancePolicyItemSummary()
            self.PolicyItemSummary._deserialize(params.get("PolicyItemSummary"))
        self.RequestId = params.get("RequestId")


class DescribeComplianceScanFailedAssetListRequest(AbstractModel):
    """DescribeComplianceScanFailedAssetList request structure.

    """

    def __init__(self):
        r"""
        :param AssetTypeSet: List of asset types
`ASSET_CONTAINER`: Container.
`ASSET_IMAGE`: Image.
`ASSET_HOST`: Server.
`ASSET_K8S`: K8s asset.
        :type AssetTypeSet: list of str
        :param Offset: Initial offset. Default value: `0`.
        :type Offset: int
        :param Limit: Number of results. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Filters: Query filter
        :type Filters: list of ComplianceFilters
        """
        self.AssetTypeSet = None
        self.Offset = None
        self.Limit = None
        self.Filters = None


    def _deserialize(self, params):
        self.AssetTypeSet = params.get("AssetTypeSet")
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeComplianceScanFailedAssetListResponse(AbstractModel):
    """DescribeComplianceScanFailedAssetList response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number of assets that failed the check
        :type TotalCount: int
        :param ScanFailedAssetList: List of aggregated information of each type of asset that failed the check
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanFailedAssetList: list of ComplianceScanFailedAsset
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.ScanFailedAssetList = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("ScanFailedAssetList") is not None:
            self.ScanFailedAssetList = []
            for item in params.get("ScanFailedAssetList"):
                obj = ComplianceScanFailedAsset()
                obj._deserialize(item)
                self.ScanFailedAssetList.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeComplianceTaskAssetSummaryRequest(AbstractModel):
    """DescribeComplianceTaskAssetSummary request structure.

    """

    def __init__(self):
        r"""
        :param AssetTypeSet: List of asset types
`ASSET_CONTAINER`: Container.
`ASSET_IMAGE`: Image.
`ASSET_HOST`: Server.
`ASSET_K8S`: K8s asset.
        :type AssetTypeSet: list of str
        """
        self.AssetTypeSet = None


    def _deserialize(self, params):
        self.AssetTypeSet = params.get("AssetTypeSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeComplianceTaskAssetSummaryResponse(AbstractModel):
    """DescribeComplianceTaskAssetSummary response structure.

    """

    def __init__(self):
        r"""
        :param Status: Status

`USER_UNINIT`: Not initialized.
`USER_INITIALIZING`: Initializing.
`USER_NORMAL`: Normal.
        :type Status: str
        :param AssetSummaryList: List of aggregated information of each type of asset
        :type AssetSummaryList: list of ComplianceAssetSummary
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.Status = None
        self.AssetSummaryList = None
        self.RequestId = None


    def _deserialize(self, params):
        self.Status = params.get("Status")
        if params.get("AssetSummaryList") is not None:
            self.AssetSummaryList = []
            for item in params.get("AssetSummaryList"):
                obj = ComplianceAssetSummary()
                obj._deserialize(item)
                self.AssetSummaryList.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeComplianceTaskPolicyItemSummaryListRequest(AbstractModel):
    """DescribeComplianceTaskPolicyItemSummaryList request structure.

    """

    def __init__(self):
        r"""
        :param AssetType: Asset type, which indicates to only query check items related to the specified asset type.

`ASSET_CONTAINER`: Container.

`ASSET_IMAGE`: Image.

`ASSET_HOST`: Server.

`ASSET_K8S`: K8s asset.
        :type AssetType: str
        :param Offset: Initial offset. Default value: `0`.
        :type Offset: int
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Filters: Filter
Name - String
Name. Valid values: `ItemType`, `StandardId`, `RiskLevel`.
`ClusterName` is also available for K8s assets.
        :type Filters: list of ComplianceFilters
        """
        self.AssetType = None
        self.Offset = None
        self.Limit = None
        self.Filters = None


    def _deserialize(self, params):
        self.AssetType = params.get("AssetType")
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeComplianceTaskPolicyItemSummaryListResponse(AbstractModel):
    """DescribeComplianceTaskPolicyItemSummaryList response structure.

    """

    def __init__(self):
        r"""
        :param TaskId: ID of the last compliance check task, which is the source of the displayed data.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskId: int
        :param TotalCount: Total number of check items
        :type TotalCount: int
        :param PolicyItemSummaryList: List of the aggregated information of each check item
        :type PolicyItemSummaryList: list of CompliancePolicyItemSummary
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskId = None
        self.TotalCount = None
        self.PolicyItemSummaryList = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.TotalCount = params.get("TotalCount")
        if params.get("PolicyItemSummaryList") is not None:
            self.PolicyItemSummaryList = []
            for item in params.get("PolicyItemSummaryList"):
                obj = CompliancePolicyItemSummary()
                obj._deserialize(item)
                self.PolicyItemSummaryList.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeComplianceWhitelistItemListRequest(AbstractModel):
    """DescribeComplianceWhitelistItemList request structure.

    """

    def __init__(self):
        r"""
        :param Offset: Initial offset. Default value: `0`.
        :type Offset: int
        :param Limit: Number of results to be obtained. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param AssetTypeSet: List of asset types
        :type AssetTypeSet: list of str
        :param Filters: Query filter
        :type Filters: list of ComplianceFilters
        :param By: Sorting field
        :type By: str
        :param Order: Sorting order. Valid values: `desc`, `asc`.
        :type Order: str
        """
        self.Offset = None
        self.Limit = None
        self.AssetTypeSet = None
        self.Filters = None
        self.By = None
        self.Order = None


    def _deserialize(self, params):
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        self.AssetTypeSet = params.get("AssetTypeSet")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.By = params.get("By")
        self.Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeComplianceWhitelistItemListResponse(AbstractModel):
    """DescribeComplianceWhitelistItemList response structure.

    """

    def __init__(self):
        r"""
        :param WhitelistItemSet: Allowlist
        :type WhitelistItemSet: list of ComplianceWhitelistItem
        :param TotalCount: Total number of allowed items
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.WhitelistItemSet = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("WhitelistItemSet") is not None:
            self.WhitelistItemSet = []
            for item in params.get("WhitelistItemSet"):
                obj = ComplianceWhitelistItem()
                obj._deserialize(item)
                self.WhitelistItemSet.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeContainerAssetSummaryRequest(AbstractModel):
    """DescribeContainerAssetSummary request structure.

    """


class DescribeContainerAssetSummaryResponse(AbstractModel):
    """DescribeContainerAssetSummary response structure.

    """

    def __init__(self):
        r"""
        :param ContainerTotalCnt: Total number of containers
        :type ContainerTotalCnt: int
        :param ContainerRunningCnt: Number of running containers
        :type ContainerRunningCnt: int
        :param ContainerPauseCnt: Number of suspended containers
        :type ContainerPauseCnt: int
        :param ContainerStopped: Number of stopped containers
        :type ContainerStopped: int
        :param ImageCnt: Number of local images
        :type ImageCnt: int
        :param HostCnt: Number of server nodes
        :type HostCnt: int
        :param HostRunningCnt: Number of running nodes on the server
        :type HostRunningCnt: int
        :param HostOfflineCnt: Number of offline nodes on the server
        :type HostOfflineCnt: int
        :param ImageRegistryCnt: Number of image repositories
        :type ImageRegistryCnt: int
        :param ImageTotalCnt: Total number of images
        :type ImageTotalCnt: int
        :param HostUnInstallCnt: Number of servers not installed with the agent
        :type HostUnInstallCnt: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.ContainerTotalCnt = None
        self.ContainerRunningCnt = None
        self.ContainerPauseCnt = None
        self.ContainerStopped = None
        self.ImageCnt = None
        self.HostCnt = None
        self.HostRunningCnt = None
        self.HostOfflineCnt = None
        self.ImageRegistryCnt = None
        self.ImageTotalCnt = None
        self.HostUnInstallCnt = None
        self.RequestId = None


    def _deserialize(self, params):
        self.ContainerTotalCnt = params.get("ContainerTotalCnt")
        self.ContainerRunningCnt = params.get("ContainerRunningCnt")
        self.ContainerPauseCnt = params.get("ContainerPauseCnt")
        self.ContainerStopped = params.get("ContainerStopped")
        self.ImageCnt = params.get("ImageCnt")
        self.HostCnt = params.get("HostCnt")
        self.HostRunningCnt = params.get("HostRunningCnt")
        self.HostOfflineCnt = params.get("HostOfflineCnt")
        self.ImageRegistryCnt = params.get("ImageRegistryCnt")
        self.ImageTotalCnt = params.get("ImageTotalCnt")
        self.HostUnInstallCnt = params.get("HostUnInstallCnt")
        self.RequestId = params.get("RequestId")


class DescribeContainerSecEventSummaryRequest(AbstractModel):
    """DescribeContainerSecEventSummary request structure.

    """


class DescribeContainerSecEventSummaryResponse(AbstractModel):
    """DescribeContainerSecEventSummary response structure.

    """

    def __init__(self):
        r"""
        :param UnhandledEscapeCnt: Pending escape event
        :type UnhandledEscapeCnt: int
        :param UnhandledReverseShellCnt: Pending reverse shell event
        :type UnhandledReverseShellCnt: int
        :param UnhandledRiskSyscallCnt: Pending high-risk syscall
        :type UnhandledRiskSyscallCnt: int
        :param UnhandledAbnormalProcessCnt: Pending abnormal process
        :type UnhandledAbnormalProcessCnt: int
        :param UnhandledFileCnt: Pending file tampering event
        :type UnhandledFileCnt: int
        :param UnhandledVirusEventCnt: Pending trojan event
        :type UnhandledVirusEventCnt: int
        :param UnhandledMaliciousConnectionEventCnt: Unhandled malicious outgoing connections
        :type UnhandledMaliciousConnectionEventCnt: int
        :param UnhandledK8sApiEventCnt: Unhandled K8sApi events
Note: This field may return `null`, indicating that no valid value was found.
        :type UnhandledK8sApiEventCnt: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.UnhandledEscapeCnt = None
        self.UnhandledReverseShellCnt = None
        self.UnhandledRiskSyscallCnt = None
        self.UnhandledAbnormalProcessCnt = None
        self.UnhandledFileCnt = None
        self.UnhandledVirusEventCnt = None
        self.UnhandledMaliciousConnectionEventCnt = None
        self.UnhandledK8sApiEventCnt = None
        self.RequestId = None


    def _deserialize(self, params):
        self.UnhandledEscapeCnt = params.get("UnhandledEscapeCnt")
        self.UnhandledReverseShellCnt = params.get("UnhandledReverseShellCnt")
        self.UnhandledRiskSyscallCnt = params.get("UnhandledRiskSyscallCnt")
        self.UnhandledAbnormalProcessCnt = params.get("UnhandledAbnormalProcessCnt")
        self.UnhandledFileCnt = params.get("UnhandledFileCnt")
        self.UnhandledVirusEventCnt = params.get("UnhandledVirusEventCnt")
        self.UnhandledMaliciousConnectionEventCnt = params.get("UnhandledMaliciousConnectionEventCnt")
        self.UnhandledK8sApiEventCnt = params.get("UnhandledK8sApiEventCnt")
        self.RequestId = params.get("RequestId")


class DescribeESAggregationsRequest(AbstractModel):
    """DescribeESAggregations request structure.

    """

    def __init__(self):
        r"""
        :param Query: ES aggregation condition in JSON
        :type Query: str
        """
        self.Query = None


    def _deserialize(self, params):
        self.Query = params.get("Query")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeESAggregationsResponse(AbstractModel):
    """DescribeESAggregations response structure.

    """

    def __init__(self):
        r"""
        :param Data: ES aggregation result in JSON
        :type Data: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.Data = None
        self.RequestId = None


    def _deserialize(self, params):
        self.Data = params.get("Data")
        self.RequestId = params.get("RequestId")


class DescribeESHitsRequest(AbstractModel):
    """DescribeESHits request structure.

    """

    def __init__(self):
        r"""
        :param Query: ES query condition in JSON
        :type Query: str
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Limit: Number of results to be returned. Maximum value: `100`.
        :type Limit: int
        """
        self.Query = None
        self.Offset = None
        self.Limit = None


    def _deserialize(self, params):
        self.Query = params.get("Query")
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeESHitsResponse(AbstractModel):
    """DescribeESHits response structure.

    """

    def __init__(self):
        r"""
        :param Data: ES query result in JSON
        :type Data: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.Data = None
        self.RequestId = None


    def _deserialize(self, params):
        self.Data = params.get("Data")
        self.RequestId = params.get("RequestId")


class DescribeEmergencyVulListRequest(AbstractModel):
    """DescribeEmergencyVulList request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>Level- String - Required: No - Severity. Valid values: `CRITICAL` (critical); `HIGH` (high); `MIDDLE` (medium); `LOW` (low).</li>
<li>Tags- string - Required: No - Vulnerability tag. Valid values: `POC`, `EXP`.</li>
<li>CanBeFixed- string - Required: No - Whether the vulnerability can be fixed. Valid values: `true`, `false`.</li>
<li>CVEID- string - Required: No - CVE No.</li>
<li>ImageID- string - Required: No - Image ID</li>
<li>ImageName- String - Required: No - Image name</li>
<li>ContainerID- string - Required: No - Container ID</li>
<li>ContainerName- string - Required: No - Container name</li>
<li>ComponentName- string - Required: No - Component name</li>
<li>ComponentVersion- string - Required: No - Component version</li>
<li>Name- string - Required: No - Vulnerability name</li>
        :type Filters: list of RunTimeFilters
        :param Order: Sorting order
        :type Order: str
        :param By: Sorting field
        :type By: str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEmergencyVulListResponse(AbstractModel):
    """DescribeEmergencyVulList response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number of vulnerabilities
        :type TotalCount: int
        :param List: List of vulnerabilities
        :type List: list of EmergencyVulInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.List = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = EmergencyVulInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeEscapeEventDetailRequest(AbstractModel):
    """DescribeEscapeEventDetail request structure.

    """

    def __init__(self):
        r"""
        :param EventId: Unique event ID
        :type EventId: str
        """
        self.EventId = None


    def _deserialize(self, params):
        self.EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEscapeEventDetailResponse(AbstractModel):
    """DescribeEscapeEventDetail response structure.

    """

    def __init__(self):
        r"""
        :param EventBaseInfo: Basic information of the event
        :type EventBaseInfo: :class:`tencentcloud.tcss.v20201101.models.RunTimeEventBaseInfo`
        :param ProcessInfo: Process information
        :type ProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessDetailInfo`
        :param EventDetail: Event description
        :type EventDetail: :class:`tencentcloud.tcss.v20201101.models.EscapeEventDescription`
        :param ParentProcessInfo: Parent process information
        :type ParentProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessBaseInfo`
        :param AncestorProcessInfo: Ancestor process information
Note: This field may return null, indicating that no valid values can be obtained.
        :type AncestorProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessBaseInfo`
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.EventBaseInfo = None
        self.ProcessInfo = None
        self.EventDetail = None
        self.ParentProcessInfo = None
        self.AncestorProcessInfo = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("EventBaseInfo") is not None:
            self.EventBaseInfo = RunTimeEventBaseInfo()
            self.EventBaseInfo._deserialize(params.get("EventBaseInfo"))
        if params.get("ProcessInfo") is not None:
            self.ProcessInfo = ProcessDetailInfo()
            self.ProcessInfo._deserialize(params.get("ProcessInfo"))
        if params.get("EventDetail") is not None:
            self.EventDetail = EscapeEventDescription()
            self.EventDetail._deserialize(params.get("EventDetail"))
        if params.get("ParentProcessInfo") is not None:
            self.ParentProcessInfo = ProcessBaseInfo()
            self.ParentProcessInfo._deserialize(params.get("ParentProcessInfo"))
        if params.get("AncestorProcessInfo") is not None:
            self.AncestorProcessInfo = ProcessBaseInfo()
            self.AncestorProcessInfo._deserialize(params.get("AncestorProcessInfo"))
        self.RequestId = params.get("RequestId")


class DescribeEscapeEventInfoRequest(AbstractModel):
    """DescribeEscapeEventInfo request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter parameter - status. Valid values: `EVENT_UNDEAL` (pending); `EVENT_DEALED` (processed); `EVENT_INGNORE` (ignored).
        :type Filters: list of RunTimeFilters
        :param Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param By: Sorting field
        :type By: str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEscapeEventInfoResponse(AbstractModel):
    """DescribeEscapeEventInfo response structure.

    """

    def __init__(self):
        r"""
        :param EventSet: Array of escape events
        :type EventSet: list of EscapeEventInfo
        :param TotalCount: Total number of events
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.EventSet = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("EventSet") is not None:
            self.EventSet = []
            for item in params.get("EventSet"):
                obj = EscapeEventInfo()
                obj._deserialize(item)
                self.EventSet.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeEscapeEventTendencyRequest(AbstractModel):
    """DescribeEscapeEventTendency request structure.

    """

    def __init__(self):
        r"""
        :param EndTime: End time
        :type EndTime: str
        :param StartTime: Start time
        :type StartTime: str
        """
        self.EndTime = None
        self.StartTime = None


    def _deserialize(self, params):
        self.EndTime = params.get("EndTime")
        self.StartTime = params.get("StartTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEscapeEventTendencyResponse(AbstractModel):
    """DescribeEscapeEventTendency response structure.

    """

    def __init__(self):
        r"""
        :param List: Trend of pending escape events
        :type List: list of EscapeEventTendencyInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = EscapeEventTendencyInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeEscapeEventTypeSummaryRequest(AbstractModel):
    """DescribeEscapeEventTypeSummary request structure.

    """


class DescribeEscapeEventTypeSummaryResponse(AbstractModel):
    """DescribeEscapeEventTypeSummary response structure.

    """

    def __init__(self):
        r"""
        :param ContainerEscapeEventCount: Number of container escape events
        :type ContainerEscapeEventCount: int
        :param ProcessPrivilegeEventCount: Number of program privilege escalation events
        :type ProcessPrivilegeEventCount: int
        :param RiskContainerEventCount: Number of risky container events
        :type RiskContainerEventCount: int
        :param PendingEscapeEventCount: Number of pending escape events
        :type PendingEscapeEventCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.ContainerEscapeEventCount = None
        self.ProcessPrivilegeEventCount = None
        self.RiskContainerEventCount = None
        self.PendingEscapeEventCount = None
        self.RequestId = None


    def _deserialize(self, params):
        self.ContainerEscapeEventCount = params.get("ContainerEscapeEventCount")
        self.ProcessPrivilegeEventCount = params.get("ProcessPrivilegeEventCount")
        self.RiskContainerEventCount = params.get("RiskContainerEventCount")
        self.PendingEscapeEventCount = params.get("PendingEscapeEventCount")
        self.RequestId = params.get("RequestId")


class DescribeEscapeEventsExportRequest(AbstractModel):
    """DescribeEscapeEventsExport request structure.

    """

    def __init__(self):
        r"""
        :param ExportField: Export field
        :type ExportField: list of str
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param By: Sorting field
        :type By: str
        """
        self.ExportField = None
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.ExportField = params.get("ExportField")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEscapeEventsExportResponse(AbstractModel):
    """DescribeEscapeEventsExport response structure.

    """

    def __init__(self):
        r"""
        :param DownloadUrl: Excel download URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type DownloadUrl: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.DownloadUrl = None
        self.RequestId = None


    def _deserialize(self, params):
        self.DownloadUrl = params.get("DownloadUrl")
        self.RequestId = params.get("RequestId")


class DescribeEscapeRuleInfoRequest(AbstractModel):
    """DescribeEscapeRuleInfo request structure.

    """


class DescribeEscapeRuleInfoResponse(AbstractModel):
    """DescribeEscapeRuleInfo response structure.

    """

    def __init__(self):
        r"""
        :param RuleSet: Rule information
        :type RuleSet: list of EscapeRule
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RuleSet = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("RuleSet") is not None:
            self.RuleSet = []
            for item in params.get("RuleSet"):
                obj = EscapeRule()
                obj._deserialize(item)
                self.RuleSet.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeEscapeSafeStateRequest(AbstractModel):
    """DescribeEscapeSafeState request structure.

    """


class DescribeEscapeSafeStateResponse(AbstractModel):
    """DescribeEscapeSafeState response structure.

    """

    def __init__(self):
        r"""
        :param IsSafe: Valid values: `Unsafe` (at risk); `Safe` (no risks); `UnKnown` (unknown risks).
        :type IsSafe: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.IsSafe = None
        self.RequestId = None


    def _deserialize(self, params):
        self.IsSafe = params.get("IsSafe")
        self.RequestId = params.get("RequestId")


class DescribeEscapeWhiteListRequest(AbstractModel):
    """DescribeEscapeWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param Filters: Filter
<li>EventType- String - Required: No - Allowed event type. Valid values: `ESCAPE_CGROUPS` (cgroup escape); `ESCAPE_TAMPER_SENSITIVE_FILE` (file tamper escape); `ESCAPE_DOCKER_API` (Docker API access escape); `ESCAPE_VUL_OCCURRED` (vulnerability exploit); `MOUNT_SENSITIVE_PTAH` (sensitive path mount); `PRIVILEGE_CONTAINER_START` (privileged container); `PRIVILEGE` (program privilege escalation escape).</li>
<li>ImageName- string - Required: No - Image name</li>
<li>ImageID- string - Required: No - Image ID</li>
        :type Filters: list of RunTimeFilters
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        :param By: Sorting field. Valid values: `HostCount` (number of servers); `ContainerCount` (number of containers); `UpdateTime` (update time).
        :type By: str
        """
        self.Filters = None
        self.Limit = None
        self.Offset = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEscapeWhiteListResponse(AbstractModel):
    """DescribeEscapeWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number
        :type TotalCount: int
        :param List: Allowlist of escapes
        :type List: list of EscapeWhiteListInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.List = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = EscapeWhiteListInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeExportJobDownloadURLRequest(AbstractModel):
    """DescribeExportJobDownloadURL request structure.

    """

    def __init__(self):
        r"""
        :param JobID: Job ID
        :type JobID: str
        """
        self.JobID = None


    def _deserialize(self, params):
        self.JobID = params.get("JobID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeExportJobDownloadURLResponse(AbstractModel):
    """DescribeExportJobDownloadURL response structure.

    """

    def __init__(self):
        r"""
        :param DownloadURL: Download URL
        :type DownloadURL: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.DownloadURL = None
        self.RequestId = None


    def _deserialize(self, params):
        self.DownloadURL = params.get("DownloadURL")
        self.RequestId = params.get("RequestId")


class DescribeExportJobManageListRequest(AbstractModel):
    """DescribeExportJobManageList request structure.

    """

    def __init__(self):
        r"""
        :param Filters: Filters.
<li>ExportStatus- String - Optional - Export status. Value: `RUNNING` (Exporting); `SUCCESS` (Exported); `FAILURE` (Failed to export)
<li>ExportSource- String - Optional - Source of the exportation task. Values: `LocalImage` (Local image).
</li>
        :type Filters: list of RunTimeFilters
        :param Offset: Offset. Default value: 0
        :type Offset: int
        :param Limit: The number of results returned. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param Order: Sort order
        :type Order: str
        :param By: Sorting field
InsertTime: Creation time
        :type By: str
        """
        self.Filters = None
        self.Offset = None
        self.Limit = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeExportJobManageListResponse(AbstractModel):
    """DescribeExportJobManageList response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total count
        :type TotalCount: int
        :param List: Job list
        :type List: list of ExportJobInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.List = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = ExportJobInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeExportJobResultRequest(AbstractModel):
    """DescribeExportJobResult request structure.

    """

    def __init__(self):
        r"""
        :param JobId: Value of the `JobId` field returned by `CreateExportComplianceStatusListJob`
        :type JobId: str
        """
        self.JobId = None


    def _deserialize(self, params):
        self.JobId = params.get("JobId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeExportJobResultResponse(AbstractModel):
    """DescribeExportJobResult response structure.

    """

    def __init__(self):
        r"""
        :param ExportStatus: Export status. Valid values: `SUCCESS`, `FAILURE`, `RUNNING`.
        :type ExportStatus: str
        :param DownloadURL: Download URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type DownloadURL: str
        :param ExportProgress: Export progress when `ExportStatus` is `RUNNING`. Value range: Floating points between `0` and `100`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExportProgress: float
        :param FailureMsg: Failure cause
Note: This field may return null, indicating that no valid values can be obtained.
        :type FailureMsg: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.ExportStatus = None
        self.DownloadURL = None
        self.ExportProgress = None
        self.FailureMsg = None
        self.RequestId = None


    def _deserialize(self, params):
        self.ExportStatus = params.get("ExportStatus")
        self.DownloadURL = params.get("DownloadURL")
        self.ExportProgress = params.get("ExportProgress")
        self.FailureMsg = params.get("FailureMsg")
        self.RequestId = params.get("RequestId")


class DescribeImageAuthorizedInfoRequest(AbstractModel):
    """DescribeImageAuthorizedInfo request structure.

    """


class DescribeImageAuthorizedInfoResponse(AbstractModel):
    """DescribeImageAuthorizedInfo response structure.

    """

    def __init__(self):
        r"""
        :param TotalAuthorizedCnt: Total number of valid image licenses
        :type TotalAuthorizedCnt: int
        :param UsedAuthorizedCnt: Number of used image licenses
        :type UsedAuthorizedCnt: int
        :param ScannedImageCnt: Number of images with scan enabled
        :type ScannedImageCnt: int
        :param NotScannedImageCnt: Number of images with scan not enabled
        :type NotScannedImageCnt: int
        :param NotScannedLocalImageCnt: Number of local images with scan not enabled
        :type NotScannedLocalImageCnt: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalAuthorizedCnt = None
        self.UsedAuthorizedCnt = None
        self.ScannedImageCnt = None
        self.NotScannedImageCnt = None
        self.NotScannedLocalImageCnt = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalAuthorizedCnt = params.get("TotalAuthorizedCnt")
        self.UsedAuthorizedCnt = params.get("UsedAuthorizedCnt")
        self.ScannedImageCnt = params.get("ScannedImageCnt")
        self.NotScannedImageCnt = params.get("NotScannedImageCnt")
        self.NotScannedLocalImageCnt = params.get("NotScannedLocalImageCnt")
        self.RequestId = params.get("RequestId")


class DescribeImageAutoAuthorizedLogListRequest(AbstractModel):
    """DescribeImageAutoAuthorizedLogList request structure.

    """

    def __init__(self):
        r"""
        :param TaskId: ID of the automatic licensing task
        :type TaskId: int
        :param Filters: `Status` (licensing result). Valid values: `SUCCESS` (success); `REACH_LIMIT` (reaching the upper limit on licenses); `LICENSE_INSUFFICIENT` (insufficient licenses).
        :type Filters: list of AssetFilters
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param By: Sorting field: `AuthorizedTime`.
        :type By: str
        :param Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self.TaskId = None
        self.Filters = None
        self.Limit = None
        self.Offset = None
        self.By = None
        self.Order = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        self.By = params.get("By")
        self.Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageAutoAuthorizedLogListResponse(AbstractModel):
    """DescribeImageAutoAuthorizedLogList response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number
        :type TotalCount: int
        :param List: List of automatically licensed images
        :type List: list of AutoAuthorizedImageInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.List = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = AutoAuthorizedImageInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeImageAutoAuthorizedRuleRequest(AbstractModel):
    """DescribeImageAutoAuthorizedRule request structure.

    """


class DescribeImageAutoAuthorizedRuleResponse(AbstractModel):
    """DescribeImageAutoAuthorizedRule response structure.

    """

    def __init__(self):
        r"""
        :param IsEnabled: Whether the rule takes effect. Valid values: `0` (no); `1` (yes).
        :type IsEnabled: int
        :param RangeType: Scope. Valid values: `MANUAL` (specified servers); `ALL` (all images).
Note: This field may return null, indicating that no valid values can be obtained.
        :type RangeType: str
        :param HostCount: Number of servers when the scope is `MANUAL`
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostCount: int
        :param MaxDailyCount: Maximum number of image licenses per day. `0`: Unlimited.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MaxDailyCount: int
        :param RuleId: Rule ID, which is `0` if not specified.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleId: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.IsEnabled = None
        self.RangeType = None
        self.HostCount = None
        self.MaxDailyCount = None
        self.RuleId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.IsEnabled = params.get("IsEnabled")
        self.RangeType = params.get("RangeType")
        self.HostCount = params.get("HostCount")
        self.MaxDailyCount = params.get("MaxDailyCount")
        self.RuleId = params.get("RuleId")
        self.RequestId = params.get("RequestId")


class DescribeImageAutoAuthorizedTaskListRequest(AbstractModel):
    """DescribeImageAutoAuthorizedTaskList request structure.

    """

    def __init__(self):
        r"""
        :param StartTime: Start time
        :type StartTime: str
        :param EndTime: End time
        :type EndTime: str
        :param Filters: Filter field
`Status` (licensing result). Valid values: `ALLSUCCSESS` (licensing succeeded); `PARTIALFAIL` (failed to license some images); `ALLFAIL` (failed to license all images).
Licensing method. Valid values: `AUTO` (automatic licensing); `MANUAL` (manual licensing).
Image source. Valid values: `LOCAL` (local image); `REGISTRY` (repository image).
        :type Filters: list of AssetFilters
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        """
        self.StartTime = None
        self.EndTime = None
        self.Filters = None
        self.Limit = None
        self.Offset = None


    def _deserialize(self, params):
        self.StartTime = params.get("StartTime")
        self.EndTime = params.get("EndTime")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageAutoAuthorizedTaskListResponse(AbstractModel):
    """DescribeImageAutoAuthorizedTaskList response structure.

    """

    def __init__(self):
        r"""
        :param List: List of automatic licensing tasks
        :type List: list of ImageAutoAuthorizedTask
        :param TotalCount: Total number
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = ImageAutoAuthorizedTask()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeImageComponentListRequest(AbstractModel):
    """DescribeImageComponentList request structure.

    """

    def __init__(self):
        r"""
        :param ImageID: Image ID
        :type ImageID: str
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>ComponentName- String - Required: No - Image component name</li><li>ComponentVersion- String - Required: No - Image component version</li><li>ComponentType- String - Required: No - Image component type</li><li>VulLevel- String - Required: No - Vulnerability severity</li><li>HasVul- String - Required: No - Whether there is a vulnerability. Valid values: `true` (yes); `false` (no). If `ComponentName` is not passed in or is `ALL`, it indicates all.</li>
        :type Filters: list of AssetFilters
        :param By: Sorting field
        :type By: str
        :param Order: Sorting order. Valid values: `desc`, `asc`.
        :type Order: str
        """
        self.ImageID = None
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.By = None
        self.Order = None


    def _deserialize(self, params):
        self.ImageID = params.get("ImageID")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.By = params.get("By")
        self.Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageComponentListResponse(AbstractModel):
    """DescribeImageComponentList response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number
        :type TotalCount: int
        :param List: List of image components
        :type List: list of ImageComponent
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.List = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = ImageComponent()
                obj._deserialize(item)
                self.List.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeImageRegistryNamespaceListRequest(AbstractModel):
    """DescribeImageRegistryNamespaceList request structure.

    """

    def __init__(self):
        r"""
        :param Offset: Initial offset of the query. Default value: `0`.
        :type Offset: int
        :param Limit: Number of results to be returned by the query. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Filters: Query filter. The `Name` field can be "Namespace".
        :type Filters: list of AssetFilters
        """
        self.Offset = None
        self.Limit = None
        self.Filters = None


    def _deserialize(self, params):
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageRegistryNamespaceListResponse(AbstractModel):
    """DescribeImageRegistryNamespaceList response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number of namespaces that can be returned
        :type TotalCount: int
        :param NamespaceList: List of namespaces
        :type NamespaceList: list of str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.NamespaceList = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        self.NamespaceList = params.get("NamespaceList")
        self.RequestId = params.get("RequestId")


class DescribeImageRegistryTimingScanTaskRequest(AbstractModel):
    """DescribeImageRegistryTimingScanTask request structure.

    """


class DescribeImageRegistryTimingScanTaskResponse(AbstractModel):
    """DescribeImageRegistryTimingScanTask response structure.

    """

    def __init__(self):
        r"""
        :param Enable: Scheduled scan switch
Note: This field may return null, indicating that no valid values can be obtained.
        :type Enable: bool
        :param ScanTime: Scheduled scan time
        :type ScanTime: str
        :param ScanPeriod: Scheduled scan interval
        :type ScanPeriod: int
        :param ScanType: Array of scan types
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanType: list of str
        :param All: Scan of all images
        :type All: bool
        :param Images: Scan of specified images
Note: This field may return null, indicating that no valid values can be obtained.
        :type Images: list of ImageInfo
        :param Id: ID of the specified image
Note: This field may return null, indicating that no valid values can be obtained.
        :type Id: list of int non-negative
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.Enable = None
        self.ScanTime = None
        self.ScanPeriod = None
        self.ScanType = None
        self.All = None
        self.Images = None
        self.Id = None
        self.RequestId = None


    def _deserialize(self, params):
        self.Enable = params.get("Enable")
        self.ScanTime = params.get("ScanTime")
        self.ScanPeriod = params.get("ScanPeriod")
        self.ScanType = params.get("ScanType")
        self.All = params.get("All")
        if params.get("Images") is not None:
            self.Images = []
            for item in params.get("Images"):
                obj = ImageInfo()
                obj._deserialize(item)
                self.Images.append(obj)
        self.Id = params.get("Id")
        self.RequestId = params.get("RequestId")


class DescribeImageRiskSummaryRequest(AbstractModel):
    """DescribeImageRiskSummary request structure.

    """


class DescribeImageRiskSummaryResponse(AbstractModel):
    """DescribeImageRiskSummary response structure.

    """

    def __init__(self):
        r"""
        :param VulnerabilityCnt: Vulnerability
        :type VulnerabilityCnt: list of RunTimeRiskInfo
        :param MalwareVirusCnt: Virus and trojan
        :type MalwareVirusCnt: list of RunTimeRiskInfo
        :param RiskCnt: Sensitive data
        :type RiskCnt: list of RunTimeRiskInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.VulnerabilityCnt = None
        self.MalwareVirusCnt = None
        self.RiskCnt = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("VulnerabilityCnt") is not None:
            self.VulnerabilityCnt = []
            for item in params.get("VulnerabilityCnt"):
                obj = RunTimeRiskInfo()
                obj._deserialize(item)
                self.VulnerabilityCnt.append(obj)
        if params.get("MalwareVirusCnt") is not None:
            self.MalwareVirusCnt = []
            for item in params.get("MalwareVirusCnt"):
                obj = RunTimeRiskInfo()
                obj._deserialize(item)
                self.MalwareVirusCnt.append(obj)
        if params.get("RiskCnt") is not None:
            self.RiskCnt = []
            for item in params.get("RiskCnt"):
                obj = RunTimeRiskInfo()
                obj._deserialize(item)
                self.RiskCnt.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeImageRiskTendencyRequest(AbstractModel):
    """DescribeImageRiskTendency request structure.

    """

    def __init__(self):
        r"""
        :param StartTime: Start time
        :type StartTime: str
        :param EndTime: End time
        :type EndTime: str
        """
        self.StartTime = None
        self.EndTime = None


    def _deserialize(self, params):
        self.StartTime = params.get("StartTime")
        self.EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageRiskTendencyResponse(AbstractModel):
    """DescribeImageRiskTendency response structure.

    """

    def __init__(self):
        r"""
        :param ImageRiskTendencySet: List of new risk trends of local images
        :type ImageRiskTendencySet: list of ImageRiskTendencyInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.ImageRiskTendencySet = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("ImageRiskTendencySet") is not None:
            self.ImageRiskTendencySet = []
            for item in params.get("ImageRiskTendencySet"):
                obj = ImageRiskTendencyInfo()
                obj._deserialize(item)
                self.ImageRiskTendencySet.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeImageSimpleListRequest(AbstractModel):
    """DescribeImageSimpleList request structure.

    """

    def __init__(self):
        r"""
        :param Filters: `IsAuthorized` (whether it is licensed). Valid values: `0` (no); `1` (yes); none (all).
        :type Filters: list of RunTimeFilters
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Order: Sorting order
        :type Order: str
        :param By: Sorting field
        :type By: str
        """
        self.Filters = None
        self.Limit = None
        self.Offset = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageSimpleListResponse(AbstractModel):
    """DescribeImageSimpleList response structure.

    """

    def __init__(self):
        r"""
        :param ImageList: List of images
        :type ImageList: list of ImageSimpleInfo
        :param ImageCnt: Number of images
        :type ImageCnt: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.ImageList = None
        self.ImageCnt = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("ImageList") is not None:
            self.ImageList = []
            for item in params.get("ImageList"):
                obj = ImageSimpleInfo()
                obj._deserialize(item)
                self.ImageList.append(obj)
        self.ImageCnt = params.get("ImageCnt")
        self.RequestId = params.get("RequestId")


class DescribeIndexListRequest(AbstractModel):
    """DescribeIndexList request structure.

    """


class DescribeIndexListResponse(AbstractModel):
    """DescribeIndexList response structure.

    """

    def __init__(self):
        r"""
        :param Data: ES index information
        :type Data: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.Data = None
        self.RequestId = None


    def _deserialize(self, params):
        self.Data = params.get("Data")
        self.RequestId = params.get("RequestId")


class DescribeInspectionReportRequest(AbstractModel):
    """DescribeInspectionReport request structure.

    """


class DescribeInspectionReportResponse(AbstractModel):
    """DescribeInspectionReport response structure.

    """

    def __init__(self):
        r"""
        :param ReportName: Report name
        :type ReportName: str
        :param ReportUrl: Download URL
        :type ReportUrl: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.ReportName = None
        self.ReportUrl = None
        self.RequestId = None


    def _deserialize(self, params):
        self.ReportName = params.get("ReportName")
        self.ReportUrl = params.get("ReportUrl")
        self.RequestId = params.get("RequestId")


class DescribeK8sApiAbnormalEventInfoRequest(AbstractModel):
    """DescribeK8sApiAbnormalEventInfo request structure.

    """

    def __init__(self):
        r"""
        :param ID: Event ID
        :type ID: int
        """
        self.ID = None


    def _deserialize(self, params):
        self.ID = params.get("ID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeK8sApiAbnormalEventInfoResponse(AbstractModel):
    """DescribeK8sApiAbnormalEventInfo response structure.

    """

    def __init__(self):
        r"""
        :param Info: Event details
        :type Info: :class:`tencentcloud.tcss.v20201101.models.K8sApiAbnormalEventInfo`
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.Info = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("Info") is not None:
            self.Info = K8sApiAbnormalEventInfo()
            self.Info._deserialize(params.get("Info"))
        self.RequestId = params.get("RequestId")


class DescribeK8sApiAbnormalEventListRequest(AbstractModel):
    """DescribeK8sApiAbnormalEventList request structure.

    """

    def __init__(self):
        r"""
        :param Filters: Filters.
<li>TimeRange - String - Optional - Time range. Example: ["2022-03-31 16:55:00", "2022-03-31 17:00:00"]</li>
<li>`MatchRules` - String - Optional - Hit rule</li>
<li>`RiskLevel` - String - Optional - Threat level</li>
<li>`Status` - String - Optional - Event status</li>
<li>`MatchRuleType` - String - Optional - Hit rule type</li>
<li>`ClusterRunningStatus` - String - Optional - Cluster running status</li>
<li>`ClusterName` - String - Optional - Cluster name</li>
<li>`ClusterID` - String - Optional - Cluster ID</li>
        :type Filters: list of RunTimeFilters
        :param Limit: The number of results returned. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param Offset: Offset. Default value: 0
        :type Offset: int
        :param Order: Sort order
        :type Order: str
        :param By: Sorting field
`LatestFoundTime`: Last creation time
`AlarmCount`: Number of alarms
        :type By: str
        """
        self.Filters = None
        self.Limit = None
        self.Offset = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeK8sApiAbnormalEventListResponse(AbstractModel):
    """DescribeK8sApiAbnormalEventList response structure.

    """

    def __init__(self):
        r"""
        :param List: Event list
        :type List: list of K8sApiAbnormalEventListItem
        :param TotalCount: Total count
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = K8sApiAbnormalEventListItem()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeK8sApiAbnormalRuleInfoRequest(AbstractModel):
    """DescribeK8sApiAbnormalRuleInfo request structure.

    """

    def __init__(self):
        r"""
        :param RuleID: Rule ID
        :type RuleID: str
        """
        self.RuleID = None


    def _deserialize(self, params):
        self.RuleID = params.get("RuleID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeK8sApiAbnormalRuleInfoResponse(AbstractModel):
    """DescribeK8sApiAbnormalRuleInfo response structure.

    """

    def __init__(self):
        r"""
        :param Info: Rule details
        :type Info: :class:`tencentcloud.tcss.v20201101.models.K8sApiAbnormalRuleInfo`
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.Info = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("Info") is not None:
            self.Info = K8sApiAbnormalRuleInfo()
            self.Info._deserialize(params.get("Info"))
        self.RequestId = params.get("RequestId")


class DescribeK8sApiAbnormalRuleListRequest(AbstractModel):
    """DescribeK8sApiAbnormalRuleList request structure.

    """

    def __init__(self):
        r"""
        :param Filters: Filters.
<li>`RuleType` - String - Optional - Rule type</li>
<li>`Status` - String - Optional - Status</li>
        :type Filters: list of RunTimeFilters
        :param Limit: The number of results returned. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param Offset: Offset. Default value: 0
        :type Offset: int
        :param Order: Sort order
        :type Order: str
        :param By: Sorting field.
<li>`UpdateTime` - String - Optional - Last updated</li>
<li>`EffectClusterCount` - String - Optional - Number of clusters affected</li>
        :type By: str
        """
        self.Filters = None
        self.Limit = None
        self.Offset = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeK8sApiAbnormalRuleListResponse(AbstractModel):
    """DescribeK8sApiAbnormalRuleList response structure.

    """

    def __init__(self):
        r"""
        :param List: Rule list
        :type List: list of K8sApiAbnormalRuleListItem
        :param TotalCount: Total count
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = K8sApiAbnormalRuleListItem()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeK8sApiAbnormalRuleScopeListRequest(AbstractModel):
    """DescribeK8sApiAbnormalRuleScopeList request structure.

    """

    def __init__(self):
        r"""
        :param RuleID: Rule ID
        :type RuleID: str
        :param Offset: Offset
        :type Offset: int
        :param Limit: The number of results returned. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param Filters: Filters.
<li>`Action` - String - Optional - Filter by action</li>
<li>`RiskLevel` - String - Optional - Threat level</li>
        :type Filters: list of RunTimeFilters
        """
        self.RuleID = None
        self.Offset = None
        self.Limit = None
        self.Filters = None


    def _deserialize(self, params):
        self.RuleID = params.get("RuleID")
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeK8sApiAbnormalRuleScopeListResponse(AbstractModel):
    """DescribeK8sApiAbnormalRuleScopeList response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total count
        :type TotalCount: int
        :param List: List
        :type List: list of K8sApiAbnormalRuleScopeInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.List = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = K8sApiAbnormalRuleScopeInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeK8sApiAbnormalSummaryRequest(AbstractModel):
    """DescribeK8sApiAbnormalSummary request structure.

    """


class DescribeK8sApiAbnormalSummaryResponse(AbstractModel):
    """DescribeK8sApiAbnormalSummary response structure.

    """

    def __init__(self):
        r"""
        :param UnhandleEventCount: The number of pending events
        :type UnhandleEventCount: int
        :param UnhandleHighLevelEventCount: The number of pending high-risk events
        :type UnhandleHighLevelEventCount: int
        :param UnhandleMediumLevelEventCount: The number of pending medium-risk events
        :type UnhandleMediumLevelEventCount: int
        :param UnhandleLowLevelEventCount: The number of pending low-risk events
        :type UnhandleLowLevelEventCount: int
        :param UnhandleNoticeLevelEventCount: The number of pending notice-level events
        :type UnhandleNoticeLevelEventCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.UnhandleEventCount = None
        self.UnhandleHighLevelEventCount = None
        self.UnhandleMediumLevelEventCount = None
        self.UnhandleLowLevelEventCount = None
        self.UnhandleNoticeLevelEventCount = None
        self.RequestId = None


    def _deserialize(self, params):
        self.UnhandleEventCount = params.get("UnhandleEventCount")
        self.UnhandleHighLevelEventCount = params.get("UnhandleHighLevelEventCount")
        self.UnhandleMediumLevelEventCount = params.get("UnhandleMediumLevelEventCount")
        self.UnhandleLowLevelEventCount = params.get("UnhandleLowLevelEventCount")
        self.UnhandleNoticeLevelEventCount = params.get("UnhandleNoticeLevelEventCount")
        self.RequestId = params.get("RequestId")


class DescribeK8sApiAbnormalTendencyRequest(AbstractModel):
    """DescribeK8sApiAbnormalTendency request structure.

    """

    def __init__(self):
        r"""
        :param TendencyPeriod: Trend period (default value: 7 days)
        :type TendencyPeriod: int
        """
        self.TendencyPeriod = None


    def _deserialize(self, params):
        self.TendencyPeriod = params.get("TendencyPeriod")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeK8sApiAbnormalTendencyResponse(AbstractModel):
    """DescribeK8sApiAbnormalTendency response structure.

    """

    def __init__(self):
        r"""
        :param List: Trend list
        :type List: list of K8sApiAbnormalTendencyItem
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = K8sApiAbnormalTendencyItem()
                obj._deserialize(item)
                self.List.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeLogStorageStatisticRequest(AbstractModel):
    """DescribeLogStorageStatistic request structure.

    """


class DescribeLogStorageStatisticResponse(AbstractModel):
    """DescribeLogStorageStatistic response structure.

    """

    def __init__(self):
        r"""
        :param TotalSize: Total capacity in GB
        :type TotalSize: int
        :param UsedSize: Used capacity in GB
        :type UsedSize: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalSize = None
        self.UsedSize = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalSize = params.get("TotalSize")
        self.UsedSize = params.get("UsedSize")
        self.RequestId = params.get("RequestId")


class DescribeNetworkFirewallAuditRecordRequest(AbstractModel):
    """DescribeNetworkFirewallAuditRecord request structure.

    """

    def __init__(self):
        r"""
        :param Offset: Offset
        :type Offset: int
        :param Limit: Maximum number of records per query
        :type Limit: int
        :param Filters: Name - Action
Name. Valid values: `publish`, `unpublish`, `confirm`, `add`, `update`, `delete`.
        :type Filters: list of ComplianceFilters
        :param By: Sorting field
        :type By: str
        :param Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self.Offset = None
        self.Limit = None
        self.Filters = None
        self.By = None
        self.Order = None


    def _deserialize(self, params):
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.By = params.get("By")
        self.Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallAuditRecordResponse(AbstractModel):
    """DescribeNetworkFirewallAuditRecord response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number of cluster audits
        :type TotalCount: int
        :param AuditList: Audit details of the cluster
        :type AuditList: list of NetworkAuditRecord
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.AuditList = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("AuditList") is not None:
            self.AuditList = []
            for item in params.get("AuditList"):
                obj = NetworkAuditRecord()
                obj._deserialize(item)
                self.AuditList.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeNetworkFirewallClusterListRequest(AbstractModel):
    """DescribeNetworkFirewallClusterList request structure.

    """

    def __init__(self):
        r"""
        :param Offset: Offset
        :type Offset: int
        :param Limit: Maximum number of records per query
        :type Limit: int
        :param Filters: Name - String
Name. Valid values: `ClusterName`, `ClusterId`, `ClusterType`, `Region`, `ClusterCheckMode`, `ClusterAutoCheck`.
        :type Filters: list of ComplianceFilters
        :param By: Sorting field
        :type By: str
        :param Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self.Offset = None
        self.Limit = None
        self.Filters = None
        self.By = None
        self.Order = None


    def _deserialize(self, params):
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.By = params.get("By")
        self.Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallClusterListResponse(AbstractModel):
    """DescribeNetworkFirewallClusterList response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number of clusters
        :type TotalCount: int
        :param ClusterInfoList: Cluster details
        :type ClusterInfoList: list of NetworkClusterInfoItem
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.ClusterInfoList = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("ClusterInfoList") is not None:
            self.ClusterInfoList = []
            for item in params.get("ClusterInfoList"):
                obj = NetworkClusterInfoItem()
                obj._deserialize(item)
                self.ClusterInfoList.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeNetworkFirewallClusterRefreshStatusRequest(AbstractModel):
    """DescribeNetworkFirewallClusterRefreshStatus request structure.

    """

    def __init__(self):
        r"""
        :param TaskId: Task ID
        :type TaskId: int
        """
        self.TaskId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallClusterRefreshStatusResponse(AbstractModel):
    """DescribeNetworkFirewallClusterRefreshStatus response structure.

    """

    def __init__(self):
        r"""
        :param TaskStatus: Task status. Valid values: `Task_Running`, `Task_Succ`, `Task_Error`, `Task_NoExist`.
        :type TaskStatus: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskStatus = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskStatus = params.get("TaskStatus")
        self.RequestId = params.get("RequestId")


class DescribeNetworkFirewallNamespaceLabelListRequest(AbstractModel):
    """DescribeNetworkFirewallNamespaceLabelList request structure.

    """

    def __init__(self):
        r"""
        :param ClusterId: Cluster ID
        :type ClusterId: str
        :param Offset: Offset
        :type Offset: int
        :param Limit: Maximum number of records per query
        :type Limit: int
        :param Filters: Name - String
Name. Valid values: `ClusterName`, `ClusterId`, `ClusterType`, `Region`, `ClusterCheckMode`, `ClusterAutoCheck`.
        :type Filters: list of ComplianceFilters
        :param By: Sorting field
        :type By: str
        :param Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self.ClusterId = None
        self.Offset = None
        self.Limit = None
        self.Filters = None
        self.By = None
        self.Order = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.By = params.get("By")
        self.Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallNamespaceLabelListResponse(AbstractModel):
    """DescribeNetworkFirewallNamespaceLabelList response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number of clusters
        :type TotalCount: int
        :param ClusterNamespaceLabelList: Cluster namespace label details
        :type ClusterNamespaceLabelList: list of NetworkClusterNamespaceLabelInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.ClusterNamespaceLabelList = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("ClusterNamespaceLabelList") is not None:
            self.ClusterNamespaceLabelList = []
            for item in params.get("ClusterNamespaceLabelList"):
                obj = NetworkClusterNamespaceLabelInfo()
                obj._deserialize(item)
                self.ClusterNamespaceLabelList.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeNetworkFirewallPodLabelsListRequest(AbstractModel):
    """DescribeNetworkFirewallPodLabelsList request structure.

    """

    def __init__(self):
        r"""
        :param ClusterId: Cluster ID
        :type ClusterId: str
        :param Offset: Offset
        :type Offset: int
        :param Limit: Maximum number of records per query
        :type Limit: int
        :param Filters: Name - String
Name. Valid values: `ClusterName`, `ClusterId`, `ClusterType`, `Region`, `ClusterCheckMode`, `ClusterAutoCheck`.
        :type Filters: list of ComplianceFilters
        :param By: Sorting field
        :type By: str
        :param Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self.ClusterId = None
        self.Offset = None
        self.Limit = None
        self.Filters = None
        self.By = None
        self.Order = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.By = params.get("By")
        self.Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallPodLabelsListResponse(AbstractModel):
    """DescribeNetworkFirewallPodLabelsList response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number of cluster Pods
        :type TotalCount: int
        :param PodList: Details of the cluster Pod
Note: This field may return null, indicating that no valid values can be obtained.
        :type PodList: list of NetworkClusterPodInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.PodList = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("PodList") is not None:
            self.PodList = []
            for item in params.get("PodList"):
                obj = NetworkClusterPodInfo()
                obj._deserialize(item)
                self.PodList.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeNetworkFirewallPolicyDetailRequest(AbstractModel):
    """DescribeNetworkFirewallPolicyDetail request structure.

    """

    def __init__(self):
        r"""
        :param Id: Policy ID
        :type Id: int
        """
        self.Id = None


    def _deserialize(self, params):
        self.Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallPolicyDetailResponse(AbstractModel):
    """DescribeNetworkFirewallPolicyDetail response structure.

    """

    def __init__(self):
        r"""
        :param ClusterId: Cluster ID
        :type ClusterId: str
        :param PolicyName: Policy name
        :type PolicyName: str
        :param Namespace: Namespace
Note: This field may return null, indicating that no valid values can be obtained.
        :type Namespace: str
        :param FromPolicyRule: Inbound type
        :type FromPolicyRule: int
        :param ToPolicyRule: Outbound type
        :type ToPolicyRule: int
        :param CustomPolicy: Custom rule
Note: This field may return null, indicating that no valid values can be obtained.
        :type CustomPolicy: list of NetworkCustomPolicy
        :param PodSelector: Pod selector
        :type PodSelector: str
        :param Description: Policy description
Note: This field may return null, indicating that no valid values can be obtained.
        :type Description: str
        :param PolicyCreateTime: Policy creation time
        :type PolicyCreateTime: str
        :param PolicySourceType: Policy source type. Valid values: `System` (synched from the cluster); `Manual` (added manually).
        :type PolicySourceType: str
        :param NetworkPolicyPlugin: Network plugin of the network policy
Note: This field may return null, indicating that no valid values can be obtained.
        :type NetworkPolicyPlugin: str
        :param PublishStatus: Network policy status
        :type PublishStatus: str
        :param PublishResult: Policy publishing result
Note: This field may return null, indicating that no valid values can be obtained.
        :type PublishResult: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.ClusterId = None
        self.PolicyName = None
        self.Namespace = None
        self.FromPolicyRule = None
        self.ToPolicyRule = None
        self.CustomPolicy = None
        self.PodSelector = None
        self.Description = None
        self.PolicyCreateTime = None
        self.PolicySourceType = None
        self.NetworkPolicyPlugin = None
        self.PublishStatus = None
        self.PublishResult = None
        self.RequestId = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        self.PolicyName = params.get("PolicyName")
        self.Namespace = params.get("Namespace")
        self.FromPolicyRule = params.get("FromPolicyRule")
        self.ToPolicyRule = params.get("ToPolicyRule")
        if params.get("CustomPolicy") is not None:
            self.CustomPolicy = []
            for item in params.get("CustomPolicy"):
                obj = NetworkCustomPolicy()
                obj._deserialize(item)
                self.CustomPolicy.append(obj)
        self.PodSelector = params.get("PodSelector")
        self.Description = params.get("Description")
        self.PolicyCreateTime = params.get("PolicyCreateTime")
        self.PolicySourceType = params.get("PolicySourceType")
        self.NetworkPolicyPlugin = params.get("NetworkPolicyPlugin")
        self.PublishStatus = params.get("PublishStatus")
        self.PublishResult = params.get("PublishResult")
        self.RequestId = params.get("RequestId")


class DescribeNetworkFirewallPolicyDiscoverRequest(AbstractModel):
    """DescribeNetworkFirewallPolicyDiscover request structure.

    """

    def __init__(self):
        r"""
        :param TaskId: Task ID
        :type TaskId: int
        """
        self.TaskId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallPolicyDiscoverResponse(AbstractModel):
    """DescribeNetworkFirewallPolicyDiscover response structure.

    """

    def __init__(self):
        r"""
        :param TaskStatus: Task status. Valid values: `Task_Running`, `Task_Succ`, `Task_Error`, `Task_NoExist`.
        :type TaskStatus: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskStatus = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskStatus = params.get("TaskStatus")
        self.RequestId = params.get("RequestId")


class DescribeNetworkFirewallPolicyListRequest(AbstractModel):
    """DescribeNetworkFirewallPolicyList request structure.

    """

    def __init__(self):
        r"""
        :param ClusterId: Cluster ID
        :type ClusterId: str
        :param Offset: Offset
        :type Offset: int
        :param Limit: Maximum number of records per query
        :type Limit: int
        :param Filters: Name - String
Name. Valid values: `ClusterName`, `ClusterId`, `ClusterType`, `Region`, `ClusterCheckMode`, `ClusterAutoCheck`.
        :type Filters: list of ComplianceFilters
        :param By: Sorting field
        :type By: str
        :param Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self.ClusterId = None
        self.Offset = None
        self.Limit = None
        self.Filters = None
        self.By = None
        self.Order = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.By = params.get("By")
        self.Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallPolicyListResponse(AbstractModel):
    """DescribeNetworkFirewallPolicyList response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number of clusters
        :type TotalCount: int
        :param NetPolicy: Cluster details
        :type NetPolicy: list of NetworkPolicyInfoItem
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.NetPolicy = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("NetPolicy") is not None:
            self.NetPolicy = []
            for item in params.get("NetPolicy"):
                obj = NetworkPolicyInfoItem()
                obj._deserialize(item)
                self.NetPolicy.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeNetworkFirewallPolicyStatusRequest(AbstractModel):
    """DescribeNetworkFirewallPolicyStatus request structure.

    """

    def __init__(self):
        r"""
        :param TaskId: Task ID
        :type TaskId: int
        """
        self.TaskId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallPolicyStatusResponse(AbstractModel):
    """DescribeNetworkFirewallPolicyStatus response structure.

    """

    def __init__(self):
        r"""
        :param TaskStatus: Task status. Valid values: `Task_Running`, `Task_Succ`, `Task_Error`, `Task_NoExist`.
        :type TaskStatus: str
        :param TaskResult: Task result, such as `NameRepeat` and `K8sRuleIngressPortError`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskResult: list of str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskStatus = None
        self.TaskResult = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskStatus = params.get("TaskStatus")
        self.TaskResult = params.get("TaskResult")
        self.RequestId = params.get("RequestId")


class DescribeNetworkFirewallPolicyYamlDetailRequest(AbstractModel):
    """DescribeNetworkFirewallPolicyYamlDetail request structure.

    """

    def __init__(self):
        r"""
        :param Id: Policy ID
        :type Id: int
        """
        self.Id = None


    def _deserialize(self, params):
        self.Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallPolicyYamlDetailResponse(AbstractModel):
    """DescribeNetworkFirewallPolicyYamlDetail response structure.

    """

    def __init__(self):
        r"""
        :param ClusterId: Cluster ID
        :type ClusterId: str
        :param PolicyName: Policy name
        :type PolicyName: str
        :param Yaml: Base64-encoded YAML string
Note: This field may return null, indicating that no valid values can be obtained.
        :type Yaml: str
        :param Description: Policy description
Note: This field may return null, indicating that no valid values can be obtained.
        :type Description: str
        :param PolicyCreateTime: Policy creation time
        :type PolicyCreateTime: str
        :param PolicySourceType: Policy source type. Valid values: `System` (synched from the cluster); `Manual` (added manually).
        :type PolicySourceType: str
        :param NetworkPolicyPlugin: Network plugin of the network policy
Note: This field may return null, indicating that no valid values can be obtained.
        :type NetworkPolicyPlugin: str
        :param PublishStatus: Network policy status
        :type PublishStatus: str
        :param PublishResult: Policy publishing result
Note: This field may return null, indicating that no valid values can be obtained.
        :type PublishResult: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.ClusterId = None
        self.PolicyName = None
        self.Yaml = None
        self.Description = None
        self.PolicyCreateTime = None
        self.PolicySourceType = None
        self.NetworkPolicyPlugin = None
        self.PublishStatus = None
        self.PublishResult = None
        self.RequestId = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        self.PolicyName = params.get("PolicyName")
        self.Yaml = params.get("Yaml")
        self.Description = params.get("Description")
        self.PolicyCreateTime = params.get("PolicyCreateTime")
        self.PolicySourceType = params.get("PolicySourceType")
        self.NetworkPolicyPlugin = params.get("NetworkPolicyPlugin")
        self.PublishStatus = params.get("PublishStatus")
        self.PublishResult = params.get("PublishResult")
        self.RequestId = params.get("RequestId")


class DescribeNewestVulRequest(AbstractModel):
    """DescribeNewestVul request structure.

    """


class DescribeNewestVulResponse(AbstractModel):
    """DescribeNewestVul response structure.

    """

    def __init__(self):
        r"""
        :param PocID: POC ID
        :type PocID: str
        :param VulName: Vulnerability name
        :type VulName: str
        :param SubmitTime: Disclosure time
        :type SubmitTime: str
        :param Status: Emergency vulnerability risk information. Valid values: `NOT_SCAN` (not scanned); `SCANNING` (scanning); `SCANNED` (scanned).
        :type Status: str
        :param CVEID: Vulnerability CVE ID
        :type CVEID: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.PocID = None
        self.VulName = None
        self.SubmitTime = None
        self.Status = None
        self.CVEID = None
        self.RequestId = None


    def _deserialize(self, params):
        self.PocID = params.get("PocID")
        self.VulName = params.get("VulName")
        self.SubmitTime = params.get("SubmitTime")
        self.Status = params.get("Status")
        self.CVEID = params.get("CVEID")
        self.RequestId = params.get("RequestId")


class DescribePostPayDetailRequest(AbstractModel):
    """DescribePostPayDetail request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        """
        self.Limit = None
        self.Offset = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePostPayDetailResponse(AbstractModel):
    """DescribePostPayDetail response structure.

    """

    def __init__(self):
        r"""
        :param SoftQuotaDayDetail: Elastic billing details
Note: This field may return null, indicating that no valid values can be obtained.
        :type SoftQuotaDayDetail: list of SoftQuotaDayInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.SoftQuotaDayDetail = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("SoftQuotaDayDetail") is not None:
            self.SoftQuotaDayDetail = []
            for item in params.get("SoftQuotaDayDetail"):
                obj = SoftQuotaDayInfo()
                obj._deserialize(item)
                self.SoftQuotaDayDetail.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeProVersionInfoRequest(AbstractModel):
    """DescribeProVersionInfo request structure.

    """


class DescribeProVersionInfoResponse(AbstractModel):
    """DescribeProVersionInfo response structure.

    """

    def __init__(self):
        r"""
        :param StartTime: Start time of the Pro Edition, which is not empty only when the edition is purchased.
Note: This field may return null, indicating that no valid values can be obtained.
        :type StartTime: str
        :param EndTime: End time of the Pro Edition, which is not empty only when more resources are purchased.
Note: This field may return null, indicating that no valid values can be obtained.
        :type EndTime: str
        :param CoresCnt: Number of cores to be purchased
        :type CoresCnt: int
        :param MaxPostPayCoresCnt: Upper limit for elastic billing
        :type MaxPostPayCoresCnt: int
        :param ResourceId: Resource ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ResourceId: str
        :param BuyStatus: Purchase status
`Pending`: To be purchased.
`Normal`: Purchased.
`Isolate`: Isolated.
        :type BuyStatus: str
        :param IsPurchased: Whether it has been purchased before. Valid values: `false` (no); `true` (yes).
        :type IsPurchased: bool
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.StartTime = None
        self.EndTime = None
        self.CoresCnt = None
        self.MaxPostPayCoresCnt = None
        self.ResourceId = None
        self.BuyStatus = None
        self.IsPurchased = None
        self.RequestId = None


    def _deserialize(self, params):
        self.StartTime = params.get("StartTime")
        self.EndTime = params.get("EndTime")
        self.CoresCnt = params.get("CoresCnt")
        self.MaxPostPayCoresCnt = params.get("MaxPostPayCoresCnt")
        self.ResourceId = params.get("ResourceId")
        self.BuyStatus = params.get("BuyStatus")
        self.IsPurchased = params.get("IsPurchased")
        self.RequestId = params.get("RequestId")


class DescribePromotionActivityRequest(AbstractModel):
    """DescribePromotionActivity request structure.

    """

    def __init__(self):
        r"""
        :param ActiveID: Promotion ID
        :type ActiveID: int
        """
        self.ActiveID = None


    def _deserialize(self, params):
        self.ActiveID = params.get("ActiveID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePromotionActivityResponse(AbstractModel):
    """DescribePromotionActivity response structure.

    """

    def __init__(self):
        r"""
        :param List: Promotion content
        :type List: list of PromotionActivityContent
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = PromotionActivityContent()
                obj._deserialize(item)
                self.List.append(obj)
        self.RequestId = params.get("RequestId")


class DescribePublicKeyRequest(AbstractModel):
    """DescribePublicKey request structure.

    """


class DescribePublicKeyResponse(AbstractModel):
    """DescribePublicKey response structure.

    """

    def __init__(self):
        r"""
        :param PublicKey: Public key
        :type PublicKey: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.PublicKey = None
        self.RequestId = None


    def _deserialize(self, params):
        self.PublicKey = params.get("PublicKey")
        self.RequestId = params.get("RequestId")


class DescribePurchaseStateInfoRequest(AbstractModel):
    """DescribePurchaseStateInfo request structure.

    """


class DescribePurchaseStateInfoResponse(AbstractModel):
    """DescribePurchaseStateInfo response structure.

    """

    def __init__(self):
        r"""
        :param State: Valid values: `0` (available for trial and purchase); `1` (available for purchase only after failed trial review or trial expiration); `2` (trial effective); `3` (Pro Edition effective); `4` (Pro Edition expired).
        :type State: int
        :param CoresCnt: Total number of cores
Note: This field may return null, indicating that no valid values can be obtained.
        :type CoresCnt: int
        :param AuthorizedCoresCnt: Number of purchased cores
Note: This field may return null, indicating that no valid values can be obtained.
        :type AuthorizedCoresCnt: int
        :param ImageCnt: Number of images
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageCnt: int
        :param AuthorizedImageCnt: Number of licensed images
Note: This field may return null, indicating that no valid values can be obtained.
        :type AuthorizedImageCnt: int
        :param PurchasedAuthorizedCnt: Number of purchased image licenses
Note: This field may return null, indicating that no valid values can be obtained.
        :type PurchasedAuthorizedCnt: int
        :param ExpirationTime: Expiration time
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExpirationTime: str
        :param AutomaticRenewal: Valid values: `0` (initial status, which is the default value and not set by the user); `1` (auto-renewal); `2` (no auto-renewal, which is specified by the user).
Note: This field may return null, indicating that no valid values can be obtained.
        :type AutomaticRenewal: int
        :param GivenAuthorizedCnt: Number of free image licenses during the trial, which may expire.
Note: This field may return null, indicating that no valid values can be obtained.
        :type GivenAuthorizedCnt: int
        :param BeginTime: Start time
Note: This field may return null, indicating that no valid values can be obtained.
        :type BeginTime: str
        :param SubState: Sub-status, the meaning of which is subject to the `State` field.
Valid values when `State` is `4`: `ISOLATE` (isolated); `DESTROED` (terminated).
Note: This field may return null, indicating that no valid values can be obtained.
        :type SubState: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.State = None
        self.CoresCnt = None
        self.AuthorizedCoresCnt = None
        self.ImageCnt = None
        self.AuthorizedImageCnt = None
        self.PurchasedAuthorizedCnt = None
        self.ExpirationTime = None
        self.AutomaticRenewal = None
        self.GivenAuthorizedCnt = None
        self.BeginTime = None
        self.SubState = None
        self.RequestId = None


    def _deserialize(self, params):
        self.State = params.get("State")
        self.CoresCnt = params.get("CoresCnt")
        self.AuthorizedCoresCnt = params.get("AuthorizedCoresCnt")
        self.ImageCnt = params.get("ImageCnt")
        self.AuthorizedImageCnt = params.get("AuthorizedImageCnt")
        self.PurchasedAuthorizedCnt = params.get("PurchasedAuthorizedCnt")
        self.ExpirationTime = params.get("ExpirationTime")
        self.AutomaticRenewal = params.get("AutomaticRenewal")
        self.GivenAuthorizedCnt = params.get("GivenAuthorizedCnt")
        self.BeginTime = params.get("BeginTime")
        self.SubState = params.get("SubState")
        self.RequestId = params.get("RequestId")


class DescribeRefreshTaskRequest(AbstractModel):
    """DescribeRefreshTask request structure.

    """

    def __init__(self):
        r"""
        :param TaskId: Task ID
        :type TaskId: int
        """
        self.TaskId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRefreshTaskResponse(AbstractModel):
    """DescribeRefreshTask response structure.

    """

    def __init__(self):
        r"""
        :param TaskStatus: Refresh task status. Valid values: `Task_New`, `Task_Running`, `Task_Finish`, `Task_Error`, `Task_NoExist`.
        :type TaskStatus: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskStatus = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskStatus = params.get("TaskStatus")
        self.RequestId = params.get("RequestId")


class DescribeReverseShellDetailRequest(AbstractModel):
    """DescribeReverseShellDetail request structure.

    """

    def __init__(self):
        r"""
        :param EventId: Unique event ID
        :type EventId: str
        """
        self.EventId = None


    def _deserialize(self, params):
        self.EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReverseShellDetailResponse(AbstractModel):
    """DescribeReverseShellDetail response structure.

    """

    def __init__(self):
        r"""
        :param EventBaseInfo: Basic information of the event
        :type EventBaseInfo: :class:`tencentcloud.tcss.v20201101.models.RunTimeEventBaseInfo`
        :param ProcessInfo: Process information
        :type ProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessDetailInfo`
        :param ParentProcessInfo: Parent process information
        :type ParentProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessDetailBaseInfo`
        :param EventDetail: Event description
        :type EventDetail: :class:`tencentcloud.tcss.v20201101.models.ReverseShellEventDescription`
        :param AncestorProcessInfo: Ancestor process information
Note: This field may return null, indicating that no valid values can be obtained.
        :type AncestorProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessBaseInfo`
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.EventBaseInfo = None
        self.ProcessInfo = None
        self.ParentProcessInfo = None
        self.EventDetail = None
        self.AncestorProcessInfo = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("EventBaseInfo") is not None:
            self.EventBaseInfo = RunTimeEventBaseInfo()
            self.EventBaseInfo._deserialize(params.get("EventBaseInfo"))
        if params.get("ProcessInfo") is not None:
            self.ProcessInfo = ProcessDetailInfo()
            self.ProcessInfo._deserialize(params.get("ProcessInfo"))
        if params.get("ParentProcessInfo") is not None:
            self.ParentProcessInfo = ProcessDetailBaseInfo()
            self.ParentProcessInfo._deserialize(params.get("ParentProcessInfo"))
        if params.get("EventDetail") is not None:
            self.EventDetail = ReverseShellEventDescription()
            self.EventDetail._deserialize(params.get("EventDetail"))
        if params.get("AncestorProcessInfo") is not None:
            self.AncestorProcessInfo = ProcessBaseInfo()
            self.AncestorProcessInfo._deserialize(params.get("AncestorProcessInfo"))
        self.RequestId = params.get("RequestId")


class DescribeReverseShellEventsExportRequest(AbstractModel):
    """DescribeReverseShellEventsExport request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param By: Sorting field
        :type By: str
        :param ExportField: Export field
        :type ExportField: list of str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None
        self.ExportField = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        self.ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReverseShellEventsExportResponse(AbstractModel):
    """DescribeReverseShellEventsExport response structure.

    """

    def __init__(self):
        r"""
        :param DownloadUrl: Excel download URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type DownloadUrl: str
        :param JobId: Task ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type JobId: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.DownloadUrl = None
        self.JobId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.DownloadUrl = params.get("DownloadUrl")
        self.JobId = params.get("JobId")
        self.RequestId = params.get("RequestId")


class DescribeReverseShellEventsRequest(AbstractModel):
    """DescribeReverseShellEvents request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param By: Sorting field
        :type By: str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReverseShellEventsResponse(AbstractModel):
    """DescribeReverseShellEvents response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number of events
        :type TotalCount: int
        :param EventSet: Array of reverse shells
        :type EventSet: list of ReverseShellEventInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.EventSet = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("EventSet") is not None:
            self.EventSet = []
            for item in params.get("EventSet"):
                obj = ReverseShellEventInfo()
                obj._deserialize(item)
                self.EventSet.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeReverseShellWhiteListDetailRequest(AbstractModel):
    """DescribeReverseShellWhiteListDetail request structure.

    """

    def __init__(self):
        r"""
        :param WhiteListId: Allowed item ID
        :type WhiteListId: str
        """
        self.WhiteListId = None


    def _deserialize(self, params):
        self.WhiteListId = params.get("WhiteListId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReverseShellWhiteListDetailResponse(AbstractModel):
    """DescribeReverseShellWhiteListDetail response structure.

    """

    def __init__(self):
        r"""
        :param WhiteListDetailInfo: Basic information of the event
        :type WhiteListDetailInfo: :class:`tencentcloud.tcss.v20201101.models.ReverseShellWhiteListInfo`
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.WhiteListDetailInfo = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("WhiteListDetailInfo") is not None:
            self.WhiteListDetailInfo = ReverseShellWhiteListInfo()
            self.WhiteListDetailInfo._deserialize(params.get("WhiteListDetailInfo"))
        self.RequestId = params.get("RequestId")


class DescribeReverseShellWhiteListsRequest(AbstractModel):
    """DescribeReverseShellWhiteLists request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param By: Sorting field
        :type By: str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReverseShellWhiteListsResponse(AbstractModel):
    """DescribeReverseShellWhiteLists response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number of events
        :type TotalCount: int
        :param WhiteListSet: Allowlist
        :type WhiteListSet: list of ReverseShellWhiteListBaseInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.WhiteListSet = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("WhiteListSet") is not None:
            self.WhiteListSet = []
            for item in params.get("WhiteListSet"):
                obj = ReverseShellWhiteListBaseInfo()
                obj._deserialize(item)
                self.WhiteListSet.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeRiskListRequest(AbstractModel):
    """DescribeRiskList request structure.

    """

    def __init__(self):
        r"""
        :param ClusterId: ID of the cluster to be queried. If it is not specified, all risk items will be queried.
        :type ClusterId: str
        :param Offset: Offset
        :type Offset: int
        :param Limit: Maximum number of records per query
        :type Limit: int
        :param Filters: Name - String
Name. Valid values: `RiskLevel` (risk level); `RiskTarget` (check target and risky target); `RiskType` (risk type); `RiskAttribute` (risk type of the check item).
        :type Filters: list of ComplianceFilters
        :param By: Sorting field
        :type By: str
        :param Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self.ClusterId = None
        self.Offset = None
        self.Limit = None
        self.Filters = None
        self.By = None
        self.Order = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.By = params.get("By")
        self.Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRiskListResponse(AbstractModel):
    """DescribeRiskList response structure.

    """

    def __init__(self):
        r"""
        :param ClusterRiskItems: Array of risk details
        :type ClusterRiskItems: list of ClusterRiskItem
        :param TotalCount: Total number of risk items
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.ClusterRiskItems = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("ClusterRiskItems") is not None:
            self.ClusterRiskItems = []
            for item in params.get("ClusterRiskItems"):
                obj = ClusterRiskItem()
                obj._deserialize(item)
                self.ClusterRiskItems.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeRiskSyscallDetailRequest(AbstractModel):
    """DescribeRiskSyscallDetail request structure.

    """

    def __init__(self):
        r"""
        :param EventId: Unique event ID
        :type EventId: str
        """
        self.EventId = None


    def _deserialize(self, params):
        self.EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRiskSyscallDetailResponse(AbstractModel):
    """DescribeRiskSyscallDetail response structure.

    """

    def __init__(self):
        r"""
        :param EventBaseInfo: Basic information of the event
        :type EventBaseInfo: :class:`tencentcloud.tcss.v20201101.models.RunTimeEventBaseInfo`
        :param ProcessInfo: Process information
        :type ProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessDetailInfo`
        :param ParentProcessInfo: Parent process information
        :type ParentProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessDetailBaseInfo`
        :param EventDetail: Event description
        :type EventDetail: :class:`tencentcloud.tcss.v20201101.models.RiskSyscallEventDescription`
        :param AncestorProcessInfo: Ancestor process information
Note: This field may return null, indicating that no valid values can be obtained.
        :type AncestorProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessBaseInfo`
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.EventBaseInfo = None
        self.ProcessInfo = None
        self.ParentProcessInfo = None
        self.EventDetail = None
        self.AncestorProcessInfo = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("EventBaseInfo") is not None:
            self.EventBaseInfo = RunTimeEventBaseInfo()
            self.EventBaseInfo._deserialize(params.get("EventBaseInfo"))
        if params.get("ProcessInfo") is not None:
            self.ProcessInfo = ProcessDetailInfo()
            self.ProcessInfo._deserialize(params.get("ProcessInfo"))
        if params.get("ParentProcessInfo") is not None:
            self.ParentProcessInfo = ProcessDetailBaseInfo()
            self.ParentProcessInfo._deserialize(params.get("ParentProcessInfo"))
        if params.get("EventDetail") is not None:
            self.EventDetail = RiskSyscallEventDescription()
            self.EventDetail._deserialize(params.get("EventDetail"))
        if params.get("AncestorProcessInfo") is not None:
            self.AncestorProcessInfo = ProcessBaseInfo()
            self.AncestorProcessInfo._deserialize(params.get("AncestorProcessInfo"))
        self.RequestId = params.get("RequestId")


class DescribeRiskSyscallEventsExportRequest(AbstractModel):
    """DescribeRiskSyscallEventsExport request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param By: Sorting field
        :type By: str
        :param ExportField: Export field
        :type ExportField: list of str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None
        self.ExportField = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        self.ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRiskSyscallEventsExportResponse(AbstractModel):
    """DescribeRiskSyscallEventsExport response structure.

    """

    def __init__(self):
        r"""
        :param DownloadUrl: Excel download URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type DownloadUrl: str
        :param JobId: Task ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type JobId: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.DownloadUrl = None
        self.JobId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.DownloadUrl = params.get("DownloadUrl")
        self.JobId = params.get("JobId")
        self.RequestId = params.get("RequestId")


class DescribeRiskSyscallEventsRequest(AbstractModel):
    """DescribeRiskSyscallEvents request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param By: Sorting field
        :type By: str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRiskSyscallEventsResponse(AbstractModel):
    """DescribeRiskSyscallEvents response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number of events
        :type TotalCount: int
        :param EventSet: Array of high-risk syscalls
        :type EventSet: list of RiskSyscallEventInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.EventSet = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("EventSet") is not None:
            self.EventSet = []
            for item in params.get("EventSet"):
                obj = RiskSyscallEventInfo()
                obj._deserialize(item)
                self.EventSet.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeRiskSyscallNamesRequest(AbstractModel):
    """DescribeRiskSyscallNames request structure.

    """


class DescribeRiskSyscallNamesResponse(AbstractModel):
    """DescribeRiskSyscallNames response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number of events
        :type TotalCount: int
        :param SyscallNames: List of syscall names
        :type SyscallNames: list of str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.SyscallNames = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        self.SyscallNames = params.get("SyscallNames")
        self.RequestId = params.get("RequestId")


class DescribeRiskSyscallWhiteListDetailRequest(AbstractModel):
    """DescribeRiskSyscallWhiteListDetail request structure.

    """

    def __init__(self):
        r"""
        :param WhiteListId: Allowed item ID
        :type WhiteListId: str
        """
        self.WhiteListId = None


    def _deserialize(self, params):
        self.WhiteListId = params.get("WhiteListId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRiskSyscallWhiteListDetailResponse(AbstractModel):
    """DescribeRiskSyscallWhiteListDetail response structure.

    """

    def __init__(self):
        r"""
        :param WhiteListDetailInfo: Basic information of the allowlist
        :type WhiteListDetailInfo: :class:`tencentcloud.tcss.v20201101.models.RiskSyscallWhiteListInfo`
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.WhiteListDetailInfo = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("WhiteListDetailInfo") is not None:
            self.WhiteListDetailInfo = RiskSyscallWhiteListInfo()
            self.WhiteListDetailInfo._deserialize(params.get("WhiteListDetailInfo"))
        self.RequestId = params.get("RequestId")


class DescribeRiskSyscallWhiteListsRequest(AbstractModel):
    """DescribeRiskSyscallWhiteLists request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param By: Sorting field
        :type By: str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRiskSyscallWhiteListsResponse(AbstractModel):
    """DescribeRiskSyscallWhiteLists response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number of events
        :type TotalCount: int
        :param WhiteListSet: Allowlist
        :type WhiteListSet: list of RiskSyscallWhiteListBaseInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.WhiteListSet = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("WhiteListSet") is not None:
            self.WhiteListSet = []
            for item in params.get("WhiteListSet"):
                obj = RiskSyscallWhiteListBaseInfo()
                obj._deserialize(item)
                self.WhiteListSet.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeScanIgnoreVulListRequest(AbstractModel):
    """DescribeScanIgnoreVulList request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>CVEID- string - Required: No - CVE No.</li>
<li>VulName- string - Required: No - Vulnerability name</li>
        :type Filters: list of RunTimeFilters
        :param Order: Sorting order. Valid values: `DESC`, `ASC`.
        :type Order: str
        :param By: Sorting field: `UpdateTime`.
        :type By: str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeScanIgnoreVulListResponse(AbstractModel):
    """DescribeScanIgnoreVulList response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number
        :type TotalCount: int
        :param List: List of vulnerabilities
        :type List: list of ScanIgnoreVul
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.List = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = ScanIgnoreVul()
                obj._deserialize(item)
                self.List.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeSearchExportListRequest(AbstractModel):
    """DescribeSearchExportList request structure.

    """

    def __init__(self):
        r"""
        :param Query: ES query condition in JSON
        :type Query: str
        """
        self.Query = None


    def _deserialize(self, params):
        self.Query = params.get("Query")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSearchExportListResponse(AbstractModel):
    """DescribeSearchExportList response structure.

    """

    def __init__(self):
        r"""
        :param JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.JobId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.JobId = params.get("JobId")
        self.RequestId = params.get("RequestId")


class DescribeSearchLogsRequest(AbstractModel):
    """DescribeSearchLogs request structure.

    """


class DescribeSearchLogsResponse(AbstractModel):
    """DescribeSearchLogs response structure.

    """

    def __init__(self):
        r"""
        :param Data: Historical search records, the latest ten of which are retained.
        :type Data: list of str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.Data = None
        self.RequestId = None


    def _deserialize(self, params):
        self.Data = params.get("Data")
        self.RequestId = params.get("RequestId")


class DescribeSearchTemplatesRequest(AbstractModel):
    """DescribeSearchTemplates request structure.

    """

    def __init__(self):
        r"""
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        """
        self.Offset = None
        self.Limit = None


    def _deserialize(self, params):
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSearchTemplatesResponse(AbstractModel):
    """DescribeSearchTemplates response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number
        :type TotalCount: int
        :param List: Template list
        :type List: list of SearchTemplate
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.List = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = SearchTemplate()
                obj._deserialize(item)
                self.List.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeSecEventsTendencyRequest(AbstractModel):
    """DescribeSecEventsTendency request structure.

    """

    def __init__(self):
        r"""
        :param StartTime: Start time
        :type StartTime: str
        :param EndTime: End time
        :type EndTime: str
        """
        self.StartTime = None
        self.EndTime = None


    def _deserialize(self, params):
        self.StartTime = params.get("StartTime")
        self.EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecEventsTendencyResponse(AbstractModel):
    """DescribeSecEventsTendency response structure.

    """

    def __init__(self):
        r"""
        :param EventTendencySet: List of trends of security events at runtime
        :type EventTendencySet: list of SecTendencyEventInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.EventTendencySet = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("EventTendencySet") is not None:
            self.EventTendencySet = []
            for item in params.get("EventTendencySet"):
                obj = SecTendencyEventInfo()
                obj._deserialize(item)
                self.EventTendencySet.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeSecLogAlertMsgRequest(AbstractModel):
    """DescribeSecLogAlertMsg request structure.

    """

    def __init__(self):
        r"""
        :param Type: Alert type
Log storage alert: log_reserve_full
Log storage period alert: log_save_day_limit
Unavailable Kafka instance/public domain name: kafka_instance_domain_unavailable
Incorrect Kafka username/password: kafka_user_passwd_wrong
Kafka backend error field: kafka_field_wrong
        :type Type: list of str
        """
        self.Type = None


    def _deserialize(self, params):
        self.Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecLogAlertMsgResponse(AbstractModel):
    """DescribeSecLogAlertMsg response structure.

    """

    def __init__(self):
        r"""
        :param List: Alert message queue
        :type List: list of SecLogAlertMsgInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = SecLogAlertMsgInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeSecLogCleanSettingInfoRequest(AbstractModel):
    """DescribeSecLogCleanSettingInfo request structure.

    """


class DescribeSecLogCleanSettingInfoResponse(AbstractModel):
    """DescribeSecLogCleanSettingInfo response structure.

    """

    def __init__(self):
        r"""
        :param ReservesLimit: Minimum storage for triggering clearing
        :type ReservesLimit: int
        :param ReservesDeadline: Storage limit for stopping clearing
        :type ReservesDeadline: int
        :param DayLimit: Storage period for triggering clearing
        :type DayLimit: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.ReservesLimit = None
        self.ReservesDeadline = None
        self.DayLimit = None
        self.RequestId = None


    def _deserialize(self, params):
        self.ReservesLimit = params.get("ReservesLimit")
        self.ReservesDeadline = params.get("ReservesDeadline")
        self.DayLimit = params.get("DayLimit")
        self.RequestId = params.get("RequestId")


class DescribeSecLogDeliveryClsOptionsRequest(AbstractModel):
    """DescribeSecLogDeliveryClsOptions request structure.

    """

    def __init__(self):
        r"""
        :param ClsRegion: Region
        :type ClsRegion: str
        """
        self.ClsRegion = None


    def _deserialize(self, params):
        self.ClsRegion = params.get("ClsRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecLogDeliveryClsOptionsResponse(AbstractModel):
    """DescribeSecLogDeliveryClsOptions response structure.

    """

    def __init__(self):
        r"""
        :param LogSetList: List of optional CLS logsets, which is returned only when `ClsRegion` is not empty.
        :type LogSetList: list of ClsLogsetInfo
        :param RegionList: List of optional regions, which is returned only when `ClsRegion` is empty.
        :type RegionList: list of RegionInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.LogSetList = None
        self.RegionList = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("LogSetList") is not None:
            self.LogSetList = []
            for item in params.get("LogSetList"):
                obj = ClsLogsetInfo()
                obj._deserialize(item)
                self.LogSetList.append(obj)
        if params.get("RegionList") is not None:
            self.RegionList = []
            for item in params.get("RegionList"):
                obj = RegionInfo()
                obj._deserialize(item)
                self.RegionList.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeSecLogDeliveryClsSettingRequest(AbstractModel):
    """DescribeSecLogDeliveryClsSetting request structure.

    """


class DescribeSecLogDeliveryClsSettingResponse(AbstractModel):
    """DescribeSecLogDeliveryClsSetting response structure.

    """

    def __init__(self):
        r"""
        :param LogTypeList: List of log types
        :type LogTypeList: list of SecLogDeliveryClsSettingInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.LogTypeList = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("LogTypeList") is not None:
            self.LogTypeList = []
            for item in params.get("LogTypeList"):
                obj = SecLogDeliveryClsSettingInfo()
                obj._deserialize(item)
                self.LogTypeList.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeSecLogDeliveryKafkaOptionsRequest(AbstractModel):
    """DescribeSecLogDeliveryKafkaOptions request structure.

    """

    def __init__(self):
        r"""
        :param RegionID: Region. If this field was left blank, return all available regions.
        :type RegionID: str
        """
        self.RegionID = None


    def _deserialize(self, params):
        self.RegionID = params.get("RegionID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecLogDeliveryKafkaOptionsResponse(AbstractModel):
    """DescribeSecLogDeliveryKafkaOptions response structure.

    """

    def __init__(self):
        r"""
        :param InstanceList: Instance list
        :type InstanceList: list of CKafkaInstanceInfo
        :param RegionList: Region list
        :type RegionList: list of RegionInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.InstanceList = None
        self.RegionList = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("InstanceList") is not None:
            self.InstanceList = []
            for item in params.get("InstanceList"):
                obj = CKafkaInstanceInfo()
                obj._deserialize(item)
                self.InstanceList.append(obj)
        if params.get("RegionList") is not None:
            self.RegionList = []
            for item in params.get("RegionList"):
                obj = RegionInfo()
                obj._deserialize(item)
                self.RegionList.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeSecLogDeliveryKafkaSettingRequest(AbstractModel):
    """DescribeSecLogDeliveryKafkaSetting request structure.

    """


class DescribeSecLogDeliveryKafkaSettingResponse(AbstractModel):
    """DescribeSecLogDeliveryKafkaSetting response structure.

    """

    def __init__(self):
        r"""
        :param InstanceID: Message queue instance ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceID: str
        :param InstanceName: Message queue instance name
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceName: str
        :param Domain: Domain
Note: This field may return null, indicating that no valid values can be obtained.
        :type Domain: str
        :param LogTypeList: List of log types
Note: This field may return null, indicating that no valid values can be obtained.
        :type LogTypeList: list of SecLogDeliveryKafkaSettingInfo
        :param User: Username
Note: This field may return null, indicating that no valid values can be obtained.
        :type User: str
        :param RegionID: Region ID
Note: This field may return `null`, indicating that no valid value was found.
        :type RegionID: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.InstanceID = None
        self.InstanceName = None
        self.Domain = None
        self.LogTypeList = None
        self.User = None
        self.RegionID = None
        self.RequestId = None


    def _deserialize(self, params):
        self.InstanceID = params.get("InstanceID")
        self.InstanceName = params.get("InstanceName")
        self.Domain = params.get("Domain")
        if params.get("LogTypeList") is not None:
            self.LogTypeList = []
            for item in params.get("LogTypeList"):
                obj = SecLogDeliveryKafkaSettingInfo()
                obj._deserialize(item)
                self.LogTypeList.append(obj)
        self.User = params.get("User")
        self.RegionID = params.get("RegionID")
        self.RequestId = params.get("RequestId")


class DescribeSecLogJoinObjectListRequest(AbstractModel):
    """DescribeSecLogJoinObjectList request structure.

    """

    def __init__(self):
        r"""
        :param LogType: Log type
Container bash: "container_bash",
Container startup: "container_launch",
K8s API: "k8s_api"
        :type LogType: str
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filters.
<li>`Status` - String - Optional - Host status</li>
<li>`HostIP` - String - Optional - Private IP of the host</li>
<li>`PublicIP` - String - Optional - Public IP of the host</li>
<li>`HostName - String - Optional - Host name</li>
        :type Filters: list of RunTimeFilters
        :param By: Sorting field
        :type By: str
        :param Order: Sorting order
        :type Order: str
        """
        self.LogType = None
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.By = None
        self.Order = None


    def _deserialize(self, params):
        self.LogType = params.get("LogType")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.By = params.get("By")
        self.Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecLogJoinObjectListResponse(AbstractModel):
    """DescribeSecLogJoinObjectList response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number
        :type TotalCount: int
        :param List: List of accessed objects
        :type List: list of SecLogJoinObjectInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.List = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = SecLogJoinObjectInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeSecLogJoinTypeListRequest(AbstractModel):
    """DescribeSecLogJoinTypeList request structure.

    """


class DescribeSecLogJoinTypeListResponse(AbstractModel):
    """DescribeSecLogJoinTypeList response structure.

    """

    def __init__(self):
        r"""
        :param List: List of log access types
        :type List: list of SecLogJoinInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = SecLogJoinInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeSecLogKafkaUINRequest(AbstractModel):
    """DescribeSecLogKafkaUIN request structure.

    """


class DescribeSecLogKafkaUINResponse(AbstractModel):
    """DescribeSecLogKafkaUIN response structure.

    """

    def __init__(self):
        r"""
        :param DstUIN: Target UIN
Note: This field may return null, indicating that no valid values can be obtained.
        :type DstUIN: str
        :param Status: Licensing status
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: bool
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.DstUIN = None
        self.Status = None
        self.RequestId = None


    def _deserialize(self, params):
        self.DstUIN = params.get("DstUIN")
        self.Status = params.get("Status")
        self.RequestId = params.get("RequestId")


class DescribeSecLogVasInfoRequest(AbstractModel):
    """DescribeSecLogVasInfo request structure.

    """


class DescribeSecLogVasInfoResponse(AbstractModel):
    """DescribeSecLogVasInfo response structure.

    """

    def __init__(self):
        r"""
        :param BuyStatus: Purchase status
`Pending`: To be purchased.
`Normal`: Purchased.
`Isolate`: Isolated.
        :type BuyStatus: str
        :param LogSaveMonth: Storage period in months
        :type LogSaveMonth: int
        :param StartTime: Start time
        :type StartTime: str
        :param EndTime: End time
        :type EndTime: str
        :param LogCapacity: Storage capacity (GB)
        :type LogCapacity: int
        :param ResourceID: Resource ID
        :type ResourceID: str
        :param IsPurchased: Whether it has been purchased before. Valid values: `false` (no); `true` (yes).
        :type IsPurchased: bool
        :param TrialCapacity: Trial storage capacity (GB)
        :type TrialCapacity: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.BuyStatus = None
        self.LogSaveMonth = None
        self.StartTime = None
        self.EndTime = None
        self.LogCapacity = None
        self.ResourceID = None
        self.IsPurchased = None
        self.TrialCapacity = None
        self.RequestId = None


    def _deserialize(self, params):
        self.BuyStatus = params.get("BuyStatus")
        self.LogSaveMonth = params.get("LogSaveMonth")
        self.StartTime = params.get("StartTime")
        self.EndTime = params.get("EndTime")
        self.LogCapacity = params.get("LogCapacity")
        self.ResourceID = params.get("ResourceID")
        self.IsPurchased = params.get("IsPurchased")
        self.TrialCapacity = params.get("TrialCapacity")
        self.RequestId = params.get("RequestId")


class DescribeSupportDefenceVulRequest(AbstractModel):
    """DescribeSupportDefenceVul request structure.

    """

    def __init__(self):
        r"""
        :param Filters: Filter
<li>Level- String - Required: No - Severity. Valid values: `CRITICAL` (critical); `HIGH` (high); `MIDDLE` (medium); `LOW` (low).</li>
<li>CVEID- string - Required: No - CVE No.</li>
<li>Name- string - Required: No - Vulnerability name</li>
        :type Filters: list of RunTimeFilters
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        :param By: Sorting field. Disclosure time: `SubmitTime`.
        :type By: str
        """
        self.Filters = None
        self.Limit = None
        self.Offset = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSupportDefenceVulResponse(AbstractModel):
    """DescribeSupportDefenceVul response structure.

    """

    def __init__(self):
        r"""
        :param List: List of vulnerabilities that can be prevented
        :type List: list of SupportDefenceVul
        :param TotalCount: Total number
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = SupportDefenceVul()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeSystemVulListRequest(AbstractModel):
    """DescribeSystemVulList request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>OnlyAffectedContainer- string - Required: No - Show only vulnerabilities that affect containers. Valid values: `true`, `false`.</li>
<li>OnlyAffectedNewestImage-string - Required: No - Show only vulnerabilities that affect the latest image tags. Valid values: `true`, `false`.</li>
<li>Level- String - Required: No - Severity. Valid values: `CRITICAL` (critical); `HIGH` (high); `MIDDLE` (medium); `LOW` (low).</li>
<li>Tags- string - Required: No - Vulnerability tag. Valid values: `POC`, `EXP`.</li>
<li>CanBeFixed- string - Required: No - Whether the vulnerability can be fixed. Valid values: `true`, `false`.</li>
<li>CVEID- string - Required: No - CVE No.</li>
<li>ImageID- string - Required: No - Image ID</li>
<li>ImageName- String - Required: No - Image name</li>
<li>ContainerID- string - Required: No - Container ID</li>
<li>ContainerName- string - Required: No - Container name</li>
<li>ComponentName- string - Required: No - Component name</li>
<li>ComponentVersion- string - Required: No - Component version</li>
<li>Name- string - Required: No - Vulnerability name</li>
<li>FocusOnType - string - Required: No - Urgency. Valid values: `ALL` (all); `SERIOUS_LEVEL (critical and high risks); `IS_SUGGEST` (high-priority); `POC_EXP` (POC/EXP); `NETWORK_EXP` (remote EXP).</li>
        :type Filters: list of RunTimeFilters
        :param Order: Sorting order
        :type Order: str
        :param By: Sorting field
        :type By: str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSystemVulListResponse(AbstractModel):
    """DescribeSystemVulList response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number of vulnerabilities
        :type TotalCount: int
        :param List: List of vulnerabilities
        :type List: list of VulInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.List = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = VulInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeTaskResultSummaryRequest(AbstractModel):
    """DescribeTaskResultSummary request structure.

    """


class DescribeTaskResultSummaryResponse(AbstractModel):
    """DescribeTaskResultSummary response structure.

    """

    def __init__(self):
        r"""
        :param SeriousRiskNodeCount: Number of nodes affected by critical risks in the last seven days
        :type SeriousRiskNodeCount: list of int non-negative
        :param HighRiskNodeCount: Number of nodes affected by high risks in the last seven days
        :type HighRiskNodeCount: list of int non-negative
        :param MiddleRiskNodeCount: Number of nodes affected by medium risks in the last seven days
        :type MiddleRiskNodeCount: list of int non-negative
        :param HintRiskNodeCount: Number of nodes affected by prompt risks in the last seven days
        :type HintRiskNodeCount: list of int non-negative
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.SeriousRiskNodeCount = None
        self.HighRiskNodeCount = None
        self.MiddleRiskNodeCount = None
        self.HintRiskNodeCount = None
        self.RequestId = None


    def _deserialize(self, params):
        self.SeriousRiskNodeCount = params.get("SeriousRiskNodeCount")
        self.HighRiskNodeCount = params.get("HighRiskNodeCount")
        self.MiddleRiskNodeCount = params.get("MiddleRiskNodeCount")
        self.HintRiskNodeCount = params.get("HintRiskNodeCount")
        self.RequestId = params.get("RequestId")


class DescribeTcssSummaryRequest(AbstractModel):
    """DescribeTcssSummary request structure.

    """


class DescribeTcssSummaryResponse(AbstractModel):
    """DescribeTcssSummary response structure.

    """

    def __init__(self):
        r"""
        :param ImageCnt: Total number of images
        :type ImageCnt: int
        :param ScannedImageCnt: Number of scanned images
        :type ScannedImageCnt: int
        :param UnScannedImageCnt: Number of images to be scanned
        :type UnScannedImageCnt: int
        :param LocalImageCnt: Number of local images
        :type LocalImageCnt: int
        :param RepositoryImageCnt: Number of repository images
        :type RepositoryImageCnt: int
        :param RiskLocalImageCnt: Number of local images at risk
        :type RiskLocalImageCnt: int
        :param RiskRepositoryImageCnt: Number of repository images at risk
        :type RiskRepositoryImageCnt: int
        :param ContainerCnt: Number of containers
        :type ContainerCnt: int
        :param RiskContainerCnt: Number of containers at risk
        :type RiskContainerCnt: int
        :param ClusterCnt: Number of clusters
        :type ClusterCnt: int
        :param RiskClusterCnt: Number of clusters at risk
        :type RiskClusterCnt: int
        :param UnScannedVulCnt: Number of vulnerabilities to be scanned
        :type UnScannedVulCnt: int
        :param RiskVulCnt: Number of risk vulnerabilities
        :type RiskVulCnt: int
        :param UnScannedBaseLineCnt: Number of security baseline items to be scanned
        :type UnScannedBaseLineCnt: int
        :param RiskBaseLineCnt: Number of security baseline risks
        :type RiskBaseLineCnt: int
        :param RuntimeUnhandleEventCnt: Number of pending (high-risk) events at runtime
        :type RuntimeUnhandleEventCnt: int
        :param UnScannedClusterCnt: Number of clusters to be scanned
        :type UnScannedClusterCnt: int
        :param ScanImageStatus: Whether images are scanned
        :type ScanImageStatus: bool
        :param ScanClusterStatus: Whether clusters are scanned
        :type ScanClusterStatus: bool
        :param ScanBaseLineStatus: Whether baseline items are scanned
        :type ScanBaseLineStatus: bool
        :param ScanVulStatus: Whether vulnerabilities are scanned for
        :type ScanVulStatus: bool
        :param VulRiskImageCnt: Number of images affected by vulnerabilities
        :type VulRiskImageCnt: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.ImageCnt = None
        self.ScannedImageCnt = None
        self.UnScannedImageCnt = None
        self.LocalImageCnt = None
        self.RepositoryImageCnt = None
        self.RiskLocalImageCnt = None
        self.RiskRepositoryImageCnt = None
        self.ContainerCnt = None
        self.RiskContainerCnt = None
        self.ClusterCnt = None
        self.RiskClusterCnt = None
        self.UnScannedVulCnt = None
        self.RiskVulCnt = None
        self.UnScannedBaseLineCnt = None
        self.RiskBaseLineCnt = None
        self.RuntimeUnhandleEventCnt = None
        self.UnScannedClusterCnt = None
        self.ScanImageStatus = None
        self.ScanClusterStatus = None
        self.ScanBaseLineStatus = None
        self.ScanVulStatus = None
        self.VulRiskImageCnt = None
        self.RequestId = None


    def _deserialize(self, params):
        self.ImageCnt = params.get("ImageCnt")
        self.ScannedImageCnt = params.get("ScannedImageCnt")
        self.UnScannedImageCnt = params.get("UnScannedImageCnt")
        self.LocalImageCnt = params.get("LocalImageCnt")
        self.RepositoryImageCnt = params.get("RepositoryImageCnt")
        self.RiskLocalImageCnt = params.get("RiskLocalImageCnt")
        self.RiskRepositoryImageCnt = params.get("RiskRepositoryImageCnt")
        self.ContainerCnt = params.get("ContainerCnt")
        self.RiskContainerCnt = params.get("RiskContainerCnt")
        self.ClusterCnt = params.get("ClusterCnt")
        self.RiskClusterCnt = params.get("RiskClusterCnt")
        self.UnScannedVulCnt = params.get("UnScannedVulCnt")
        self.RiskVulCnt = params.get("RiskVulCnt")
        self.UnScannedBaseLineCnt = params.get("UnScannedBaseLineCnt")
        self.RiskBaseLineCnt = params.get("RiskBaseLineCnt")
        self.RuntimeUnhandleEventCnt = params.get("RuntimeUnhandleEventCnt")
        self.UnScannedClusterCnt = params.get("UnScannedClusterCnt")
        self.ScanImageStatus = params.get("ScanImageStatus")
        self.ScanClusterStatus = params.get("ScanClusterStatus")
        self.ScanBaseLineStatus = params.get("ScanBaseLineStatus")
        self.ScanVulStatus = params.get("ScanVulStatus")
        self.VulRiskImageCnt = params.get("VulRiskImageCnt")
        self.RequestId = params.get("RequestId")


class DescribeUnauthorizedCoresTendencyRequest(AbstractModel):
    """DescribeUnauthorizedCoresTendency request structure.

    """


class DescribeUnauthorizedCoresTendencyResponse(AbstractModel):
    """DescribeUnauthorizedCoresTendency response structure.

    """

    def __init__(self):
        r"""
        :param List: Trend of unlicensed cores
        :type List: list of UnauthorizedCoresTendency
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = UnauthorizedCoresTendency()
                obj._deserialize(item)
                self.List.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeUnfinishRefreshTaskRequest(AbstractModel):
    """DescribeUnfinishRefreshTask request structure.

    """


class DescribeUnfinishRefreshTaskResponse(AbstractModel):
    """DescribeUnfinishRefreshTask response structure.

    """

    def __init__(self):
        r"""
        :param TaskId: ID of the last task
        :type TaskId: int
        :param TaskStatus: Task status. Valid values: `Task_New`, `Task_Running`, `Task_Finish`, `Task_Error`, `Task_NoExist`. `Task_New` and `Task_Running` indicate that a task exists and no new task can be distributed.
        :type TaskStatus: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskId = None
        self.TaskStatus = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.TaskStatus = params.get("TaskStatus")
        self.RequestId = params.get("RequestId")


class DescribeUserClusterRequest(AbstractModel):
    """DescribeUserCluster request structure.

    """

    def __init__(self):
        r"""
        :param Offset: Offset
        :type Offset: int
        :param Limit: Maximum number of records per query
        :type Limit: int
        :param Filters: Name - String
Name. Valid values: `ClusterName`, `ClusterId`, `ClusterType`, `Region`, `ClusterCheckMode`, `ClusterAutoCheck`.
        :type Filters: list of ComplianceFilters
        :param By: Sorting field
        :type By: str
        :param Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self.Offset = None
        self.Limit = None
        self.Filters = None
        self.By = None
        self.Order = None


    def _deserialize(self, params):
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.By = params.get("By")
        self.Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserClusterResponse(AbstractModel):
    """DescribeUserCluster response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number of clusters
        :type TotalCount: int
        :param ClusterInfoList: Cluster details
        :type ClusterInfoList: list of ClusterInfoItem
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.ClusterInfoList = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("ClusterInfoList") is not None:
            self.ClusterInfoList = []
            for item in params.get("ClusterInfoList"):
                obj = ClusterInfoItem()
                obj._deserialize(item)
                self.ClusterInfoList.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeValueAddedSrvInfoRequest(AbstractModel):
    """DescribeValueAddedSrvInfo request structure.

    """


class DescribeValueAddedSrvInfoResponse(AbstractModel):
    """DescribeValueAddedSrvInfo response structure.

    """

    def __init__(self):
        r"""
        :param RegistryImageCnt: Number of unlicensed repository images
        :type RegistryImageCnt: int
        :param LocalImageCnt: Number of unlicensed local images
        :type LocalImageCnt: int
        :param UnusedAuthorizedCnt: Number of unused image security scan licenses
        :type UnusedAuthorizedCnt: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RegistryImageCnt = None
        self.LocalImageCnt = None
        self.UnusedAuthorizedCnt = None
        self.RequestId = None


    def _deserialize(self, params):
        self.RegistryImageCnt = params.get("RegistryImageCnt")
        self.LocalImageCnt = params.get("LocalImageCnt")
        self.UnusedAuthorizedCnt = params.get("UnusedAuthorizedCnt")
        self.RequestId = params.get("RequestId")


class DescribeVirusAutoIsolateSampleDetailRequest(AbstractModel):
    """DescribeVirusAutoIsolateSampleDetail request structure.

    """

    def __init__(self):
        r"""
        :param MD5: MD5 checksum of the file
        :type MD5: str
        """
        self.MD5 = None


    def _deserialize(self, params):
        self.MD5 = params.get("MD5")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVirusAutoIsolateSampleDetailResponse(AbstractModel):
    """DescribeVirusAutoIsolateSampleDetail response structure.

    """

    def __init__(self):
        r"""
        :param MD5: MD5 checksum of the file
        :type MD5: str
        :param Size: File size (B)
Note: This field may return null, indicating that no valid values can be obtained.
        :type Size: int
        :param VirusName: Virus name
Note: This field may return null, indicating that no valid values can be obtained.
        :type VirusName: str
        :param RiskLevel: Risk level. Valid values: `RISK_CRITICAL`, `RISK_HIGH`, `RISK_MEDIUM`, `RISK_LOW`, `RISK_NOTICE`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskLevel: str
        :param KillEngine: Anti-virus engine
Note: This field may return null, indicating that no valid values can be obtained.
        :type KillEngine: list of str
        :param Tags: Tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tags: list of str
        :param HarmDescribe: Event description
Note: This field may return null, indicating that no valid values can be obtained.
        :type HarmDescribe: str
        :param SuggestScheme: Solution
Note: This field may return null, indicating that no valid values can be obtained.
        :type SuggestScheme: str
        :param ReferenceLink: Reference link
Note: This field may return null, indicating that no valid values can be obtained.
        :type ReferenceLink: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.MD5 = None
        self.Size = None
        self.VirusName = None
        self.RiskLevel = None
        self.KillEngine = None
        self.Tags = None
        self.HarmDescribe = None
        self.SuggestScheme = None
        self.ReferenceLink = None
        self.RequestId = None


    def _deserialize(self, params):
        self.MD5 = params.get("MD5")
        self.Size = params.get("Size")
        self.VirusName = params.get("VirusName")
        self.RiskLevel = params.get("RiskLevel")
        self.KillEngine = params.get("KillEngine")
        self.Tags = params.get("Tags")
        self.HarmDescribe = params.get("HarmDescribe")
        self.SuggestScheme = params.get("SuggestScheme")
        self.ReferenceLink = params.get("ReferenceLink")
        self.RequestId = params.get("RequestId")


class DescribeVirusAutoIsolateSampleDownloadURLRequest(AbstractModel):
    """DescribeVirusAutoIsolateSampleDownloadURL request structure.

    """

    def __init__(self):
        r"""
        :param MD5: MD5 checksum of the sample
        :type MD5: str
        """
        self.MD5 = None


    def _deserialize(self, params):
        self.MD5 = params.get("MD5")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVirusAutoIsolateSampleDownloadURLResponse(AbstractModel):
    """DescribeVirusAutoIsolateSampleDownloadURL response structure.

    """

    def __init__(self):
        r"""
        :param FileUrl: Sample download URL
        :type FileUrl: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.FileUrl = None
        self.RequestId = None


    def _deserialize(self, params):
        self.FileUrl = params.get("FileUrl")
        self.RequestId = params.get("RequestId")


class DescribeVirusAutoIsolateSampleListRequest(AbstractModel):
    """DescribeVirusAutoIsolateSampleList request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filters.
<li>`MD5` - String - Optional - md5</li>
<li>`AutoIsolateSwitch` - String - Optional - Automatic isolation switch</li>
<li>`VirusName` - String - Optional - Virus name</li>
        :type Filters: list of RunTimeFilters
        :param By: Sorting field
        :type By: str
        :param Order: Sorting order
        :type Order: str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.By = None
        self.Order = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.By = params.get("By")
        self.Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVirusAutoIsolateSampleListResponse(AbstractModel):
    """DescribeVirusAutoIsolateSampleList response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number
        :type TotalCount: int
        :param List: List of automatically isolated trojan samples
        :type List: list of VirusAutoIsolateSampleInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.List = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = VirusAutoIsolateSampleInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeVirusAutoIsolateSettingRequest(AbstractModel):
    """DescribeVirusAutoIsolateSetting request structure.

    """


class DescribeVirusAutoIsolateSettingResponse(AbstractModel):
    """DescribeVirusAutoIsolateSetting response structure.

    """

    def __init__(self):
        r"""
        :param AutoIsolateSwitch: Automatic isolation switch. Valid values: `true` (on); `false` (off).
        :type AutoIsolateSwitch: bool
        :param IsKillProgress: Whether the process associated with the isolated file is interrupted. Valid values: `true` (yes); `false` (no).
        :type IsKillProgress: bool
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.AutoIsolateSwitch = None
        self.IsKillProgress = None
        self.RequestId = None


    def _deserialize(self, params):
        self.AutoIsolateSwitch = params.get("AutoIsolateSwitch")
        self.IsKillProgress = params.get("IsKillProgress")
        self.RequestId = params.get("RequestId")


class DescribeVirusDetailRequest(AbstractModel):
    """DescribeVirusDetail request structure.

    """

    def __init__(self):
        r"""
        :param Id: Trojan file ID
        :type Id: str
        """
        self.Id = None


    def _deserialize(self, params):
        self.Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVirusDetailResponse(AbstractModel):
    """DescribeVirusDetail response structure.

    """

    def __init__(self):
        r"""
        :param ImageId: Image ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageId: str
        :param ImageName: Image name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageName: str
        :param CreateTime: Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param Size: Trojan file size
Note: This field may return null, indicating that no valid values can be obtained.
        :type Size: int
        :param FilePath: Trojan file path
Note: This field may return null, indicating that no valid values can be obtained.
        :type FilePath: str
        :param ModifyTime: Last generation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type ModifyTime: str
        :param VirusName: Virus name
Note: This field may return null, indicating that no valid values can be obtained.
        :type VirusName: str
        :param RiskLevel: Risk level. Valid values: `RISK_CRITICAL`, `RISK_HIGH`, `RISK_MEDIUM`, `RISK_LOW`, `RISK_NOTICE`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskLevel: str
        :param ContainerName: Container name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ContainerName: str
        :param ContainerId: Container ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ContainerId: str
        :param HostName: Server name
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostName: str
        :param HostId: Server ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostId: str
        :param ProcessName: Process name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProcessName: str
        :param ProcessPath: Process path
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProcessPath: str
        :param ProcessMd5: Process MD5
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProcessMd5: str
        :param ProcessId: Process ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProcessId: int
        :param ProcessArgv: Process parameter
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProcessArgv: str
        :param ProcessChan: Process chain
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProcessChan: str
        :param ProcessAccountGroup: Process group
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProcessAccountGroup: str
        :param ProcessStartAccount: Process initiator
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProcessStartAccount: str
        :param ProcessFileAuthority: Process file permission
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProcessFileAuthority: str
        :param SourceType: Source. Valid values: `0` (quick scan); `1` (scheduled scan); `2` (real-time monitoring).
Note: This field may return null, indicating that no valid values can be obtained.
        :type SourceType: int
        :param PodName: Cluster name
Note: This field may return null, indicating that no valid values can be obtained.
        :type PodName: str
        :param Tags: Tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tags: list of str
        :param HarmDescribe: Event description
Note: This field may return null, indicating that no valid values can be obtained.
        :type HarmDescribe: str
        :param SuggestScheme: Solution
Note: This field may return null, indicating that no valid values can be obtained.
        :type SuggestScheme: str
        :param Mark: Remarks
Note: This field may return null, indicating that no valid values can be obtained.
        :type Mark: str
        :param FileName: Suspicious file name
Note: This field may return null, indicating that no valid values can be obtained.
        :type FileName: str
        :param FileMd5: MD5 checksum of the file
Note: This field may return null, indicating that no valid values can be obtained.
        :type FileMd5: str
        :param EventType: Event type
Note: This field may return null, indicating that no valid values can be obtained.
        :type EventType: str
        :param Status: `DEAL_NONE`: Pending.
`DEAL_IGNORE`: Ignored.
`DEAL_ADD_WHITELIST`: Allowed.
`DEAL_DEL`: Deleted.
`DEAL_ISOLATE`: Isolated.
`DEAL_ISOLATING`: Isolating.
`DEAL_ISOLATE_FAILED`: Isolation failed.
`DEAL_RECOVERING`: Recovering.
`DEAL_RECOVER_FAILED`: Recovery failed.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: str
        :param SubStatus: Sub-status of the failure:
`FILE_NOT_FOUND`: The file does not exist.
`FILE_ABNORMAL`: The file is abnormal.
`FILE_ABNORMAL_DEAL_RECOVER`: The file is abnormal when recovered.
`BACKUP_FILE_NOT_FOUND`: The backup file does not exist.
`CONTAINER_NOT_FOUND_DEAL_ISOLATE`: The container does not exist during isolation.
`CONTAINER_NOT_FOUND_DEAL_RECOVER`: The container does not exist during recovery.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SubStatus: str
        :param HostIP: Private IP
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostIP: str
        :param ClientIP: Public IP
Note: This field may return null, indicating that no valid values can be obtained.
        :type ClientIP: str
        :param PProcessStartUser: Parent process initiator
Note: This field may return null, indicating that no valid values can be obtained.
        :type PProcessStartUser: str
        :param PProcessUserGroup: User group of the parent process
Note: This field may return null, indicating that no valid values can be obtained.
        :type PProcessUserGroup: str
        :param PProcessPath: Path of the parent process
Note: This field may return null, indicating that no valid values can be obtained.
        :type PProcessPath: str
        :param PProcessParam: Command line parameters of the parent process
Note: This field may return null, indicating that no valid values can be obtained.
        :type PProcessParam: str
        :param AncestorProcessStartUser: Ancestor process initiator
Note: This field may return null, indicating that no valid values can be obtained.
        :type AncestorProcessStartUser: str
        :param AncestorProcessUserGroup: Ancestor process user group
Note: This field may return null, indicating that no valid values can be obtained.
        :type AncestorProcessUserGroup: str
        :param AncestorProcessPath: Ancestor process path
Note: This field may return null, indicating that no valid values can be obtained.
        :type AncestorProcessPath: str
        :param AncestorProcessParam: Command line parameters of the ancestor process
Note: This field may return null, indicating that no valid values can be obtained.
        :type AncestorProcessParam: str
        :param OperationTime: Last processing time of the event
Note: This field may return null, indicating that no valid values can be obtained.
        :type OperationTime: str
        :param ContainerNetStatus: Container isolation status
Note: This field may return null, indicating that no valid values can be obtained.
        :type ContainerNetStatus: str
        :param ContainerNetSubStatus: Sub-status of container isolation
Note: This field may return null, indicating that no valid values can be obtained.
        :type ContainerNetSubStatus: str
        :param ContainerIsolateOperationSrc: Container isolation operation source
Note: This field may return null, indicating that no valid values can be obtained.
        :type ContainerIsolateOperationSrc: str
        :param CheckPlatform: Check platform
`1`: Tencent Cloud Security Engine.
`2`: tav.
`3`: binaryAi.
`4`: Unusual behavior.
`5`: Threat intelligence.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CheckPlatform: list of str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.ImageId = None
        self.ImageName = None
        self.CreateTime = None
        self.Size = None
        self.FilePath = None
        self.ModifyTime = None
        self.VirusName = None
        self.RiskLevel = None
        self.ContainerName = None
        self.ContainerId = None
        self.HostName = None
        self.HostId = None
        self.ProcessName = None
        self.ProcessPath = None
        self.ProcessMd5 = None
        self.ProcessId = None
        self.ProcessArgv = None
        self.ProcessChan = None
        self.ProcessAccountGroup = None
        self.ProcessStartAccount = None
        self.ProcessFileAuthority = None
        self.SourceType = None
        self.PodName = None
        self.Tags = None
        self.HarmDescribe = None
        self.SuggestScheme = None
        self.Mark = None
        self.FileName = None
        self.FileMd5 = None
        self.EventType = None
        self.Status = None
        self.SubStatus = None
        self.HostIP = None
        self.ClientIP = None
        self.PProcessStartUser = None
        self.PProcessUserGroup = None
        self.PProcessPath = None
        self.PProcessParam = None
        self.AncestorProcessStartUser = None
        self.AncestorProcessUserGroup = None
        self.AncestorProcessPath = None
        self.AncestorProcessParam = None
        self.OperationTime = None
        self.ContainerNetStatus = None
        self.ContainerNetSubStatus = None
        self.ContainerIsolateOperationSrc = None
        self.CheckPlatform = None
        self.RequestId = None


    def _deserialize(self, params):
        self.ImageId = params.get("ImageId")
        self.ImageName = params.get("ImageName")
        self.CreateTime = params.get("CreateTime")
        self.Size = params.get("Size")
        self.FilePath = params.get("FilePath")
        self.ModifyTime = params.get("ModifyTime")
        self.VirusName = params.get("VirusName")
        self.RiskLevel = params.get("RiskLevel")
        self.ContainerName = params.get("ContainerName")
        self.ContainerId = params.get("ContainerId")
        self.HostName = params.get("HostName")
        self.HostId = params.get("HostId")
        self.ProcessName = params.get("ProcessName")
        self.ProcessPath = params.get("ProcessPath")
        self.ProcessMd5 = params.get("ProcessMd5")
        self.ProcessId = params.get("ProcessId")
        self.ProcessArgv = params.get("ProcessArgv")
        self.ProcessChan = params.get("ProcessChan")
        self.ProcessAccountGroup = params.get("ProcessAccountGroup")
        self.ProcessStartAccount = params.get("ProcessStartAccount")
        self.ProcessFileAuthority = params.get("ProcessFileAuthority")
        self.SourceType = params.get("SourceType")
        self.PodName = params.get("PodName")
        self.Tags = params.get("Tags")
        self.HarmDescribe = params.get("HarmDescribe")
        self.SuggestScheme = params.get("SuggestScheme")
        self.Mark = params.get("Mark")
        self.FileName = params.get("FileName")
        self.FileMd5 = params.get("FileMd5")
        self.EventType = params.get("EventType")
        self.Status = params.get("Status")
        self.SubStatus = params.get("SubStatus")
        self.HostIP = params.get("HostIP")
        self.ClientIP = params.get("ClientIP")
        self.PProcessStartUser = params.get("PProcessStartUser")
        self.PProcessUserGroup = params.get("PProcessUserGroup")
        self.PProcessPath = params.get("PProcessPath")
        self.PProcessParam = params.get("PProcessParam")
        self.AncestorProcessStartUser = params.get("AncestorProcessStartUser")
        self.AncestorProcessUserGroup = params.get("AncestorProcessUserGroup")
        self.AncestorProcessPath = params.get("AncestorProcessPath")
        self.AncestorProcessParam = params.get("AncestorProcessParam")
        self.OperationTime = params.get("OperationTime")
        self.ContainerNetStatus = params.get("ContainerNetStatus")
        self.ContainerNetSubStatus = params.get("ContainerNetSubStatus")
        self.ContainerIsolateOperationSrc = params.get("ContainerIsolateOperationSrc")
        self.CheckPlatform = params.get("CheckPlatform")
        self.RequestId = params.get("RequestId")


class DescribeVirusEventTendencyRequest(AbstractModel):
    """DescribeVirusEventTendency request structure.

    """

    def __init__(self):
        r"""
        :param TendencyPeriod: Trend cycle in days. Default value: `7`.
        :type TendencyPeriod: int
        """
        self.TendencyPeriod = None


    def _deserialize(self, params):
        self.TendencyPeriod = params.get("TendencyPeriod")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVirusEventTendencyResponse(AbstractModel):
    """DescribeVirusEventTendency response structure.

    """

    def __init__(self):
        r"""
        :param List: List of trends
        :type List: list of VirusTendencyInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = VirusTendencyInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeVirusListRequest(AbstractModel):
    """DescribeVirusList request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>FileName - String - Required: No - Filename</li>
<li>FilePath - String - Required: No - File path</li>
<li>VirusName - String - Required: No - Virus name</li>
<li>ContainerName- String - Required: Yes - Container name</li>
<li>ContainerId- string - Required: No - Container ID</li>
<li>ImageName- string - Required: No - Image name</li>
<li>ImageId- string - Required: No - Image ID</li>
<li>IsRealTime- int - Required: No - Whether it is real-time monitoring data</li>
<li>TaskId- string - Required: No - Task ID</li>
<li>ContainerNetStatus - String - Required: No - Container network status. Valid values: `NORMAL`, `ISOLATED`, `ISOLATING`, `RESTORING`, `RESTORE_FAILED`.</li>
<li>TimeRange - string - Required: No - Time range ["2022-03-31 16:55:00", "2022-03-31 17:00:00"]</li>
<li>ContainerStatus - string - Required: No - Container status. Valid values: `RUNNING`, `PAUSED`, `STOPPED`, `CREATED`, `DESTROYED`, `RESTARTING`, `REMOVING`.</li>
<li>AutoIsolateMode - string - Required: No - Isolation method. Valid values: `MANUAL`, `AUTO`.</li>
<li>MD5 - string - Required: No - MD5</li>
        :type Filters: list of RunTimeFilters
        :param Order: Sorting order
        :type Order: str
        :param By: Sorting field
        :type By: str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVirusListResponse(AbstractModel):
    """DescribeVirusList response structure.

    """

    def __init__(self):
        r"""
        :param List: List of trojans
        :type List: list of VirusInfo
        :param TotalCount: Total number
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = VirusInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeVirusManualScanEstimateTimeoutRequest(AbstractModel):
    """DescribeVirusManualScanEstimateTimeout request structure.

    """

    def __init__(self):
        r"""
        :param ScanRangeType: Scanning scope. Valid values: `0` (container); `1` (server).
        :type ScanRangeType: int
        :param ScanRangeAll: Valid values: `true` (all); `false` (specified).
        :type ScanRangeAll: bool
        :param ScanIds: ID of the specified container or server to be scanned, which is based on `ScanRangeType`.
        :type ScanIds: list of str
        """
        self.ScanRangeType = None
        self.ScanRangeAll = None
        self.ScanIds = None


    def _deserialize(self, params):
        self.ScanRangeType = params.get("ScanRangeType")
        self.ScanRangeAll = params.get("ScanRangeAll")
        self.ScanIds = params.get("ScanIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVirusManualScanEstimateTimeoutResponse(AbstractModel):
    """DescribeVirusManualScanEstimateTimeout response structure.

    """

    def __init__(self):
        r"""
        :param Timeout: Estimated timeout period (hour)
        :type Timeout: float
        :param ContainerScanConcurrencyCount: Number of containers scanned in parallel on a single server
        :type ContainerScanConcurrencyCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.Timeout = None
        self.ContainerScanConcurrencyCount = None
        self.RequestId = None


    def _deserialize(self, params):
        self.Timeout = params.get("Timeout")
        self.ContainerScanConcurrencyCount = params.get("ContainerScanConcurrencyCount")
        self.RequestId = params.get("RequestId")


class DescribeVirusMonitorSettingRequest(AbstractModel):
    """DescribeVirusMonitorSetting request structure.

    """


class DescribeVirusMonitorSettingResponse(AbstractModel):
    """DescribeVirusMonitorSetting response structure.

    """

    def __init__(self):
        r"""
        :param EnableScan: Whether to enable real-time monitoring
        :type EnableScan: bool
        :param ScanPathAll: Scan all paths
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanPathAll: bool
        :param ScanPathType: Valid when `ScanPathAll` is `true`. Valid values of `ScanPathAll`: `0` (scan the following paths); `1` (scan all paths except the following).
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanPathType: int
        :param ScanPath: Specified path to be excluded or scanned
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanPath: list of str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.EnableScan = None
        self.ScanPathAll = None
        self.ScanPathType = None
        self.ScanPath = None
        self.RequestId = None


    def _deserialize(self, params):
        self.EnableScan = params.get("EnableScan")
        self.ScanPathAll = params.get("ScanPathAll")
        self.ScanPathType = params.get("ScanPathType")
        self.ScanPath = params.get("ScanPath")
        self.RequestId = params.get("RequestId")


class DescribeVirusSampleDownloadUrlRequest(AbstractModel):
    """DescribeVirusSampleDownloadUrl request structure.

    """

    def __init__(self):
        r"""
        :param ID: Trojan ID
        :type ID: str
        """
        self.ID = None


    def _deserialize(self, params):
        self.ID = params.get("ID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVirusSampleDownloadUrlResponse(AbstractModel):
    """DescribeVirusSampleDownloadUrl response structure.

    """

    def __init__(self):
        r"""
        :param FileUrl: Sample download URL
        :type FileUrl: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.FileUrl = None
        self.RequestId = None


    def _deserialize(self, params):
        self.FileUrl = params.get("FileUrl")
        self.RequestId = params.get("RequestId")


class DescribeVirusScanSettingRequest(AbstractModel):
    """DescribeVirusScanSetting request structure.

    """


class DescribeVirusScanSettingResponse(AbstractModel):
    """DescribeVirusScanSetting response structure.

    """

    def __init__(self):
        r"""
        :param EnableScan: Whether to enable scheduled scan
        :type EnableScan: bool
        :param Cycle: Check cycle in days
        :type Cycle: int
        :param BeginScanAt: Scan start time
        :type BeginScanAt: str
        :param ScanPathAll: Scan all paths
        :type ScanPathAll: bool
        :param ScanPathType: Valid when `ScanPathAll` is `true`. Valid values of `ScanPathAll`: `0` (scan the following paths); `1` (scan all paths except the following).
        :type ScanPathType: int
        :param Timeout: Timeout period in hours
        :type Timeout: int
        :param ScanRangeType: Scanning scope. Valid values: `0` (container); `1` (server).
        :type ScanRangeType: int
        :param ScanRangeAll: Valid values: `true` (all); `false` (specified).
        :type ScanRangeAll: bool
        :param ScanIds: ID of the specified container or server to be scanned, which is based on `ScanRangeType`.
        :type ScanIds: list of str
        :param ScanPath: Specified path to be excluded or scanned
        :type ScanPath: list of str
        :param ClickTimeout: Timeout settings of quick check
Note: This field may return null, indicating that no valid values can be obtained.
        :type ClickTimeout: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.EnableScan = None
        self.Cycle = None
        self.BeginScanAt = None
        self.ScanPathAll = None
        self.ScanPathType = None
        self.Timeout = None
        self.ScanRangeType = None
        self.ScanRangeAll = None
        self.ScanIds = None
        self.ScanPath = None
        self.ClickTimeout = None
        self.RequestId = None


    def _deserialize(self, params):
        self.EnableScan = params.get("EnableScan")
        self.Cycle = params.get("Cycle")
        self.BeginScanAt = params.get("BeginScanAt")
        self.ScanPathAll = params.get("ScanPathAll")
        self.ScanPathType = params.get("ScanPathType")
        self.Timeout = params.get("Timeout")
        self.ScanRangeType = params.get("ScanRangeType")
        self.ScanRangeAll = params.get("ScanRangeAll")
        self.ScanIds = params.get("ScanIds")
        self.ScanPath = params.get("ScanPath")
        self.ClickTimeout = params.get("ClickTimeout")
        self.RequestId = params.get("RequestId")


class DescribeVirusScanTaskStatusRequest(AbstractModel):
    """DescribeVirusScanTaskStatus request structure.

    """

    def __init__(self):
        r"""
        :param TaskID: Task ID
        :type TaskID: str
        """
        self.TaskID = None


    def _deserialize(self, params):
        self.TaskID = params.get("TaskID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVirusScanTaskStatusResponse(AbstractModel):
    """DescribeVirusScanTaskStatus response structure.

    """

    def __init__(self):
        r"""
        :param ContainerTotal: Number of scanned containers
        :type ContainerTotal: int
        :param RiskContainerCnt: Number of containers at risk
        :type RiskContainerCnt: int
        :param Status: Scan task status:
`SCAN_NONE`: None. 
`SCAN_SCANNING`: Scanning.
`SCAN_FINISH`: Scanned. 
`SCAN_TIMEOUT`: Scan timed out.
`SCAN_CANCELING`: Canceling.
`SCAN_CANCELED`: Canceled.
        :type Status: str
        :param Schedule: Scanning progress
        :type Schedule: int
        :param ContainerScanCnt: Number of scanned containers
        :type ContainerScanCnt: int
        :param RiskCnt: Number of risks
        :type RiskCnt: int
        :param LeftSeconds: Remaining scan time
        :type LeftSeconds: int
        :param StartTime: Scan start time
        :type StartTime: str
        :param EndTime: Scan end time
        :type EndTime: str
        :param ScanType: Scan type. Valid values: `CYCLE` (periodic scan); `MANUAL` (manual scan).
        :type ScanType: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.ContainerTotal = None
        self.RiskContainerCnt = None
        self.Status = None
        self.Schedule = None
        self.ContainerScanCnt = None
        self.RiskCnt = None
        self.LeftSeconds = None
        self.StartTime = None
        self.EndTime = None
        self.ScanType = None
        self.RequestId = None


    def _deserialize(self, params):
        self.ContainerTotal = params.get("ContainerTotal")
        self.RiskContainerCnt = params.get("RiskContainerCnt")
        self.Status = params.get("Status")
        self.Schedule = params.get("Schedule")
        self.ContainerScanCnt = params.get("ContainerScanCnt")
        self.RiskCnt = params.get("RiskCnt")
        self.LeftSeconds = params.get("LeftSeconds")
        self.StartTime = params.get("StartTime")
        self.EndTime = params.get("EndTime")
        self.ScanType = params.get("ScanType")
        self.RequestId = params.get("RequestId")


class DescribeVirusScanTimeoutSettingRequest(AbstractModel):
    """DescribeVirusScanTimeoutSetting request structure.

    """

    def __init__(self):
        r"""
        :param ScanType: Scan type. Valid values: `0` (quick scan); `1` (scheduled scan).
        :type ScanType: int
        """
        self.ScanType = None


    def _deserialize(self, params):
        self.ScanType = params.get("ScanType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVirusScanTimeoutSettingResponse(AbstractModel):
    """DescribeVirusScanTimeoutSetting response structure.

    """

    def __init__(self):
        r"""
        :param Timeout: Timeout period in hours
Note: This field may return null, indicating that no valid values can be obtained.
        :type Timeout: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.Timeout = None
        self.RequestId = None


    def _deserialize(self, params):
        self.Timeout = params.get("Timeout")
        self.RequestId = params.get("RequestId")


class DescribeVirusSummaryRequest(AbstractModel):
    """DescribeVirusSummary request structure.

    """


class DescribeVirusSummaryResponse(AbstractModel):
    """DescribeVirusSummary response structure.

    """

    def __init__(self):
        r"""
        :param TaskId: ID of the last scan task
        :type TaskId: str
        :param RiskContainerCnt: Number of containers affected by the trojan
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskContainerCnt: int
        :param RiskCnt: Number of pending risks
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskCnt: int
        :param VirusDataBaseModifyTime: Update time of the virus library
Note: This field may return null, indicating that no valid values can be obtained.
        :type VirusDataBaseModifyTime: str
        :param RiskContainerIncrease: Increase in the number of containers affected by trojans from yesterday
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskContainerIncrease: int
        :param RiskIncrease: Increase in the number of pending risks from yesterday
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskIncrease: int
        :param IsolateIncrease: Increase in the number of isolated events from yesterday
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsolateIncrease: int
        :param IsolateCnt: Total number of isolated events
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsolateCnt: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskId = None
        self.RiskContainerCnt = None
        self.RiskCnt = None
        self.VirusDataBaseModifyTime = None
        self.RiskContainerIncrease = None
        self.RiskIncrease = None
        self.IsolateIncrease = None
        self.IsolateCnt = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RiskContainerCnt = params.get("RiskContainerCnt")
        self.RiskCnt = params.get("RiskCnt")
        self.VirusDataBaseModifyTime = params.get("VirusDataBaseModifyTime")
        self.RiskContainerIncrease = params.get("RiskContainerIncrease")
        self.RiskIncrease = params.get("RiskIncrease")
        self.IsolateIncrease = params.get("IsolateIncrease")
        self.IsolateCnt = params.get("IsolateCnt")
        self.RequestId = params.get("RequestId")


class DescribeVirusTaskListRequest(AbstractModel):
    """DescribeVirusTaskList request structure.

    """

    def __init__(self):
        r"""
        :param TaskId: Task ID
        :type TaskId: str
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>ContainerName- String - Required: No - Container name</li>
<li>ContainerId - String - Required: No - Container ID</li>
<li>Hostname - String - Required: No - Server name</li>
<li>HostIp- String - Required: No - Server IP</li>
<li>ImageId- String - Required: No - Image ID</li>
<li>ImageName- String - Required: No - Image name</li>
<li>Status- String - Required: No - Status</li>
        :type Filters: list of RunTimeFilters
        :param By: Sorting field
        :type By: str
        :param Order: Sorting order
        :type Order: str
        """
        self.TaskId = None
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.By = None
        self.Order = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.By = params.get("By")
        self.Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVirusTaskListResponse(AbstractModel):
    """DescribeVirusTaskList response structure.

    """

    def __init__(self):
        r"""
        :param List: Virus scanning list
        :type List: list of VirusTaskInfo
        :param TotalCount: Total number (number of container tasks)
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = VirusTaskInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeVulContainerListRequest(AbstractModel):
    """DescribeVulContainerList request structure.

    """

    def __init__(self):
        r"""
        :param PocID: POC ID
        :type PocID: str
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>OnlyAffectedNewestImage- Bool- Required: No - Show only vulnerabilities that affect the latest image tags</li>
<li>ContainerID- string - Required: No - Container ID</li>
<li>ContainerName- String - Required: No - Container name</li>
        :type Filters: list of RunTimeFilters
        """
        self.PocID = None
        self.Limit = None
        self.Offset = None
        self.Filters = None


    def _deserialize(self, params):
        self.PocID = params.get("PocID")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVulContainerListResponse(AbstractModel):
    """DescribeVulContainerList response structure.

    """

    def __init__(self):
        r"""
        :param List: List of containers
        :type List: list of VulAffectedContainerInfo
        :param TotalCount: Total number of containers
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = VulAffectedContainerInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeVulDefenceEventDetailRequest(AbstractModel):
    """DescribeVulDefenceEventDetail request structure.

    """

    def __init__(self):
        r"""
        :param EventID: Event ID
        :type EventID: int
        """
        self.EventID = None


    def _deserialize(self, params):
        self.EventID = params.get("EventID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVulDefenceEventDetailResponse(AbstractModel):
    """DescribeVulDefenceEventDetail response structure.

    """

    def __init__(self):
        r"""
        :param EventDetail: Exploit prevention event details
        :type EventDetail: :class:`tencentcloud.tcss.v20201101.models.VulDefenceEventDetail`
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.EventDetail = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("EventDetail") is not None:
            self.EventDetail = VulDefenceEventDetail()
            self.EventDetail._deserialize(params.get("EventDetail"))
        self.RequestId = params.get("RequestId")


class DescribeVulDefenceEventRequest(AbstractModel):
    """DescribeVulDefenceEvent request structure.

    """

    def __init__(self):
        r"""
        :param Filters: Filter
<li>Status- String - Required: No - Plugin status. Valid values: `EVENT_UNDEAL` (pending); `EVENT_DEALED` (processed); `EVENT_IGNORE` (ignored); `EVENT_DEFENDED` (defended).</li>
<li>ContainerStatus- String - Required: No - Container status. Valid values: `CREATED` (created); `RUNNING` (running); `PAUSED` (suspended); 	`STOPPED` (stopped); `RESTARTING` (restarting); `REMOVING` (removing); `DESTROYED` (terminated).</li>
<li>ContainerNetStatus- String - Required: No - Container network status. Valid values: `NORMAL` (not isolated); `ISOLATED` (isolated); `ISOLATE_FAILED` (isolation failed); `RESTORE_FAILED` (recovery failed); `RESTORING` (recovering); `ISOLATING` (isolating).</li>
<li>EventType - String - Required: No - Intrusion status. Valid values: `EVENT_DEFENDED` (defended successfully); `EVENT_ATTACK` (attack attempt).</li>
<li>TimeRange- String - Required: No - Time range. The first value indicates the start time, and the second the end time.</li>
<li>VulName- string - Required: No - Vulnerability name</li>
<li>CVEID- string - Required: No - CVE No.</li>
<li>SourceIP- string - Required: No - Attacker IP</li>
<li>ContainerName- string - Required: No - Container name</li>
<li>ContainerID- string - Required: No - Container ID</li>
<li>ImageName- string - Required: No - Image name</li>
<li>ImageID- string - Required: No - Image ID</li>
<li>HostName- string - Required: No - Server name</li>
<li>HostIP- string - Required: No - Private IP</li>
        :type Filters: list of RunTimeFilters
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        :param By: Sorting field: `EventCount` (number of events).
        :type By: str
        """
        self.Filters = None
        self.Limit = None
        self.Offset = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVulDefenceEventResponse(AbstractModel):
    """DescribeVulDefenceEvent response structure.

    """

    def __init__(self):
        r"""
        :param List: List of exploit prevention events
        :type List: list of VulDefenceEvent
        :param TotalCount: Total number
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = VulDefenceEvent()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeVulDefenceEventTendencyRequest(AbstractModel):
    """DescribeVulDefenceEventTendency request structure.

    """

    def __init__(self):
        r"""
        :param StartTime: Start time
        :type StartTime: str
        :param EndTime: End time
        :type EndTime: str
        """
        self.StartTime = None
        self.EndTime = None


    def _deserialize(self, params):
        self.StartTime = params.get("StartTime")
        self.EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVulDefenceEventTendencyResponse(AbstractModel):
    """DescribeVulDefenceEventTendency response structure.

    """

    def __init__(self):
        r"""
        :param DefendedList: Trend of exploit prevention events
        :type DefendedList: list of VulDefenceEventTendency
        :param AttackList: Trend of vulnerability attack events
        :type AttackList: list of VulDefenceEventTendency
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.DefendedList = None
        self.AttackList = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("DefendedList") is not None:
            self.DefendedList = []
            for item in params.get("DefendedList"):
                obj = VulDefenceEventTendency()
                obj._deserialize(item)
                self.DefendedList.append(obj)
        if params.get("AttackList") is not None:
            self.AttackList = []
            for item in params.get("AttackList"):
                obj = VulDefenceEventTendency()
                obj._deserialize(item)
                self.AttackList.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeVulDefenceHostRequest(AbstractModel):
    """DescribeVulDefenceHost request structure.

    """

    def __init__(self):
        r"""
        :param Filters: Filter
<li>Status- String - Required: No - Plugin status. Valid values: `SUCCESS` (normal); `FAIL` (abnormal); `NO_DEFENCE` (not defended).</li>
<li>KeyWords- string - Required: No - Server name/IP</li>
        :type Filters: list of RunTimeFilters
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        :param By: Sorting field. Valid values: `ModifyTime` (update time); `CreateTime` (first enablement time).
        :type By: str
        """
        self.Filters = None
        self.Limit = None
        self.Offset = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVulDefenceHostResponse(AbstractModel):
    """DescribeVulDefenceHost response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number
        :type TotalCount: int
        :param List: List of servers with exploit prevention
        :type List: list of VulDefenceHost
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.List = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = VulDefenceHost()
                obj._deserialize(item)
                self.List.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeVulDefencePluginRequest(AbstractModel):
    """DescribeVulDefencePlugin request structure.

    """

    def __init__(self):
        r"""
        :param HostID: Server host ID, i.e., QUuid
        :type HostID: str
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>Status- String - Required: No - Plugin status. Valid values: `INJECTING` (injecting); `SUCCESS` (injected successfully); `FAIL` (injection failed); `TIMEOUT` (plugin timed out); `QUIT` (plugin exited).</li>
        :type Filters: list of RunTimeFilters
        """
        self.HostID = None
        self.Limit = None
        self.Offset = None
        self.Filters = None


    def _deserialize(self, params):
        self.HostID = params.get("HostID")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVulDefencePluginResponse(AbstractModel):
    """DescribeVulDefencePlugin response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number
        :type TotalCount: int
        :param List: List of exploit prevention plugins
        :type List: list of VulDefencePlugin
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.List = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = VulDefencePlugin()
                obj._deserialize(item)
                self.List.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeVulDefenceSettingRequest(AbstractModel):
    """DescribeVulDefenceSetting request structure.

    """


class DescribeVulDefenceSettingResponse(AbstractModel):
    """DescribeVulDefenceSetting response structure.

    """

    def __init__(self):
        r"""
        :param IsEnabled: Whether it is enabled. Valid values: `0` (disabled); `1` (enabled).
        :type IsEnabled: int
        :param Scope: Scope of servers with exploit prevention enabled. Valid values: `0` (specified servers); `1` (all servers).
        :type Scope: int
        :param HostCount: Number of servers with exploit prevention enabled
        :type HostCount: int
        :param ExceptionHostCount: Number of abnormal servers with exploit prevention enabled
        :type ExceptionHostCount: int
        :param HostIDs: Specified servers with exploit prevention enabled
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostIDs: list of str
        :param HostTotalCount: Total number of servers with TCSS activated
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostTotalCount: int
        :param SupportDefenseVulCount: Number of vulnerabilities that can be prevented
Note: This field may return null, indicating that no valid values can be obtained.
        :type SupportDefenseVulCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.IsEnabled = None
        self.Scope = None
        self.HostCount = None
        self.ExceptionHostCount = None
        self.HostIDs = None
        self.HostTotalCount = None
        self.SupportDefenseVulCount = None
        self.RequestId = None


    def _deserialize(self, params):
        self.IsEnabled = params.get("IsEnabled")
        self.Scope = params.get("Scope")
        self.HostCount = params.get("HostCount")
        self.ExceptionHostCount = params.get("ExceptionHostCount")
        self.HostIDs = params.get("HostIDs")
        self.HostTotalCount = params.get("HostTotalCount")
        self.SupportDefenseVulCount = params.get("SupportDefenseVulCount")
        self.RequestId = params.get("RequestId")


class DescribeVulDetailRequest(AbstractModel):
    """DescribeVulDetail request structure.

    """

    def __init__(self):
        r"""
        :param PocID: POC ID
        :type PocID: str
        """
        self.PocID = None


    def _deserialize(self, params):
        self.PocID = params.get("PocID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVulDetailResponse(AbstractModel):
    """DescribeVulDetail response structure.

    """

    def __init__(self):
        r"""
        :param VulInfo: Vulnerability details
        :type VulInfo: :class:`tencentcloud.tcss.v20201101.models.VulDetailInfo`
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.VulInfo = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("VulInfo") is not None:
            self.VulInfo = VulDetailInfo()
            self.VulInfo._deserialize(params.get("VulInfo"))
        self.RequestId = params.get("RequestId")


class DescribeVulIgnoreLocalImageListRequest(AbstractModel):
    """DescribeVulIgnoreLocalImageList request structure.

    """

    def __init__(self):
        r"""
        :param PocID: POC ID
        :type PocID: str
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Order: Sorting order. Valid values: `DESC`, `ASC`.
        :type Order: str
        :param By: Sorting field: `ImageSize`.
        :type By: str
        """
        self.PocID = None
        self.Limit = None
        self.Offset = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.PocID = params.get("PocID")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVulIgnoreLocalImageListResponse(AbstractModel):
    """DescribeVulIgnoreLocalImageList response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number
        :type TotalCount: int
        :param List: List of images
        :type List: list of VulIgnoreLocalImage
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.List = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = VulIgnoreLocalImage()
                obj._deserialize(item)
                self.List.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeVulIgnoreRegistryImageListRequest(AbstractModel):
    """DescribeVulIgnoreRegistryImageList request structure.

    """

    def __init__(self):
        r"""
        :param PocID: POC ID
        :type PocID: str
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        """
        self.PocID = None
        self.Limit = None
        self.Offset = None


    def _deserialize(self, params):
        self.PocID = params.get("PocID")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVulIgnoreRegistryImageListResponse(AbstractModel):
    """DescribeVulIgnoreRegistryImageList response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number
        :type TotalCount: int
        :param List: List of images
        :type List: list of VulIgnoreRegistryImage
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.List = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = VulIgnoreRegistryImage()
                obj._deserialize(item)
                self.List.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeVulImageListRequest(AbstractModel):
    """DescribeVulImageList request structure.

    """

    def __init__(self):
        r"""
        :param PocID: POC ID
        :type PocID: str
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>OnlyAffectedNewestImage- Bool- Required: No - Show only vulnerabilities that affect the latest image tags</li>
<li>ImageID- string - Required: No - Image ID</li>
<li>ImageName- String - Required: No - Image name</li>
<li>HostIP- string - Required: No - Private IP</li>
<li>PublicIP- string - Required: No - Public IP</li>
<li>ComponentName- string - Required: No - Component name</li>
<li>ComponentVersion- string - Required: No - Component version</li>
<li>HostName- string - Required: No - Server name</li>
        :type Filters: list of RunTimeFilters
        :param Order: Sorting order
        :type Order: str
        :param By: Sorting field
        :type By: str
        """
        self.PocID = None
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.PocID = params.get("PocID")
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVulImageListResponse(AbstractModel):
    """DescribeVulImageList response structure.

    """

    def __init__(self):
        r"""
        :param List: List of affected images
        :type List: list of VulAffectedImageInfo
        :param TotalCount: Total number of images
        :type TotalCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = VulAffectedImageInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeVulImageSummaryRequest(AbstractModel):
    """DescribeVulImageSummary request structure.

    """


class DescribeVulImageSummaryResponse(AbstractModel):
    """DescribeVulImageSummary response structure.

    """

    def __init__(self):
        r"""
        :param SeriousVulImageCount: Number of images affected by critical or high-risk vulnerabilities
        :type SeriousVulImageCount: int
        :param ScannedImageCount: Number of scanned images
        :type ScannedImageCount: int
        :param VulTotalCount: Total number of vulnerabilities
        :type VulTotalCount: int
        :param SysTemVulCount: Number of system vulnerabilities
        :type SysTemVulCount: int
        :param WebVulCount: Number of web application vulnerabilities
        :type WebVulCount: int
        :param AllAuthorizedImageCount: Number of licensed images
        :type AllAuthorizedImageCount: int
        :param EmergencyVulCount: Number of emergency vulnerabilities
        :type EmergencyVulCount: int
        :param SupportVulTotalCount: Total number of vulnerabilities that can be scanned for
        :type SupportVulTotalCount: int
        :param VulLibraryUpdateTime: Vulnerability library update time
        :type VulLibraryUpdateTime: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.SeriousVulImageCount = None
        self.ScannedImageCount = None
        self.VulTotalCount = None
        self.SysTemVulCount = None
        self.WebVulCount = None
        self.AllAuthorizedImageCount = None
        self.EmergencyVulCount = None
        self.SupportVulTotalCount = None
        self.VulLibraryUpdateTime = None
        self.RequestId = None


    def _deserialize(self, params):
        self.SeriousVulImageCount = params.get("SeriousVulImageCount")
        self.ScannedImageCount = params.get("ScannedImageCount")
        self.VulTotalCount = params.get("VulTotalCount")
        self.SysTemVulCount = params.get("SysTemVulCount")
        self.WebVulCount = params.get("WebVulCount")
        self.AllAuthorizedImageCount = params.get("AllAuthorizedImageCount")
        self.EmergencyVulCount = params.get("EmergencyVulCount")
        self.SupportVulTotalCount = params.get("SupportVulTotalCount")
        self.VulLibraryUpdateTime = params.get("VulLibraryUpdateTime")
        self.RequestId = params.get("RequestId")


class DescribeVulLevelImageSummaryRequest(AbstractModel):
    """DescribeVulLevelImageSummary request structure.

    """


class DescribeVulLevelImageSummaryResponse(AbstractModel):
    """DescribeVulLevelImageSummary response structure.

    """

    def __init__(self):
        r"""
        :param HighLevelVulLocalImagePercent: Percentage of high-risk vulnerabilities in the latest local images
        :type HighLevelVulLocalImagePercent: float
        :param MediumLevelVulLocalImagePercent: Percentage of medium-risk vulnerabilities in the latest local images
        :type MediumLevelVulLocalImagePercent: float
        :param LowLevelVulLocalImagePercent: Percentage of low-risk vulnerabilities in the latest local images
        :type LowLevelVulLocalImagePercent: float
        :param CriticalLevelVulLocalImagePercent: Percentage of critical vulnerabilities in the latest local images
        :type CriticalLevelVulLocalImagePercent: float
        :param LocalNewestImageCount: Number of affected local images on the latest version
        :type LocalNewestImageCount: int
        :param RegistryNewestImageCount: Number of affected repository images on the latest version
        :type RegistryNewestImageCount: int
        :param HighLevelVulRegistryImagePercent: Percentage of high-risk vulnerabilities in the latest repository image
        :type HighLevelVulRegistryImagePercent: float
        :param MediumLevelVulRegistryImagePercent: Percentage of medium-risk vulnerabilities in the latest repository image
        :type MediumLevelVulRegistryImagePercent: float
        :param LowLevelVulRegistryImagePercent: Percentage of low-risk vulnerabilities in the latest repository image
        :type LowLevelVulRegistryImagePercent: float
        :param CriticalLevelVulRegistryImagePercent: Percentage of critical vulnerabilities in the latest repository image
        :type CriticalLevelVulRegistryImagePercent: float
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.HighLevelVulLocalImagePercent = None
        self.MediumLevelVulLocalImagePercent = None
        self.LowLevelVulLocalImagePercent = None
        self.CriticalLevelVulLocalImagePercent = None
        self.LocalNewestImageCount = None
        self.RegistryNewestImageCount = None
        self.HighLevelVulRegistryImagePercent = None
        self.MediumLevelVulRegistryImagePercent = None
        self.LowLevelVulRegistryImagePercent = None
        self.CriticalLevelVulRegistryImagePercent = None
        self.RequestId = None


    def _deserialize(self, params):
        self.HighLevelVulLocalImagePercent = params.get("HighLevelVulLocalImagePercent")
        self.MediumLevelVulLocalImagePercent = params.get("MediumLevelVulLocalImagePercent")
        self.LowLevelVulLocalImagePercent = params.get("LowLevelVulLocalImagePercent")
        self.CriticalLevelVulLocalImagePercent = params.get("CriticalLevelVulLocalImagePercent")
        self.LocalNewestImageCount = params.get("LocalNewestImageCount")
        self.RegistryNewestImageCount = params.get("RegistryNewestImageCount")
        self.HighLevelVulRegistryImagePercent = params.get("HighLevelVulRegistryImagePercent")
        self.MediumLevelVulRegistryImagePercent = params.get("MediumLevelVulRegistryImagePercent")
        self.LowLevelVulRegistryImagePercent = params.get("LowLevelVulRegistryImagePercent")
        self.CriticalLevelVulRegistryImagePercent = params.get("CriticalLevelVulRegistryImagePercent")
        self.RequestId = params.get("RequestId")


class DescribeVulLevelSummaryRequest(AbstractModel):
    """DescribeVulLevelSummary request structure.

    """

    def __init__(self):
        r"""
        :param CategoryType: Vulnerability type. Valid values: `SYSTEM` (system vulnerability); `WEB` (web application vulnerability); `EMERGENCY` (emergency vulnerability).
        :type CategoryType: str
        """
        self.CategoryType = None


    def _deserialize(self, params):
        self.CategoryType = params.get("CategoryType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVulLevelSummaryResponse(AbstractModel):
    """DescribeVulLevelSummary response structure.

    """

    def __init__(self):
        r"""
        :param HighLevelVulCount: Number of high-risk vulnerabilities
        :type HighLevelVulCount: int
        :param MediumLevelVulCount: Number of medium-risk vulnerabilities
        :type MediumLevelVulCount: int
        :param LowLevelVulCount: Number of low-risk vulnerabilities
        :type LowLevelVulCount: int
        :param CriticalLevelVulCount: Number of critical vulnerabilities
        :type CriticalLevelVulCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.HighLevelVulCount = None
        self.MediumLevelVulCount = None
        self.LowLevelVulCount = None
        self.CriticalLevelVulCount = None
        self.RequestId = None


    def _deserialize(self, params):
        self.HighLevelVulCount = params.get("HighLevelVulCount")
        self.MediumLevelVulCount = params.get("MediumLevelVulCount")
        self.LowLevelVulCount = params.get("LowLevelVulCount")
        self.CriticalLevelVulCount = params.get("CriticalLevelVulCount")
        self.RequestId = params.get("RequestId")


class DescribeVulScanAuthorizedImageSummaryRequest(AbstractModel):
    """DescribeVulScanAuthorizedImageSummary request structure.

    """


class DescribeVulScanAuthorizedImageSummaryResponse(AbstractModel):
    """DescribeVulScanAuthorizedImageSummary response structure.

    """

    def __init__(self):
        r"""
        :param AllAuthorizedImageCount: Number of all licensed local images
        :type AllAuthorizedImageCount: int
        :param UnScanAuthorizedImageCount: Number of licensed but not scanned local images
        :type UnScanAuthorizedImageCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.AllAuthorizedImageCount = None
        self.UnScanAuthorizedImageCount = None
        self.RequestId = None


    def _deserialize(self, params):
        self.AllAuthorizedImageCount = params.get("AllAuthorizedImageCount")
        self.UnScanAuthorizedImageCount = params.get("UnScanAuthorizedImageCount")
        self.RequestId = params.get("RequestId")


class DescribeVulScanInfoRequest(AbstractModel):
    """DescribeVulScanInfo request structure.

    """

    def __init__(self):
        r"""
        :param LocalTaskID: ID of the task to scan local images for vulnerabilities. If it is not specified, the ID of the last scan will be returned.
        :type LocalTaskID: int
        :param RegistryTaskID: ID of the task to scan repository images for vulnerabilities. If it is not specified, the ID of the last scan will be returned.
        :type RegistryTaskID: int
        """
        self.LocalTaskID = None
        self.RegistryTaskID = None


    def _deserialize(self, params):
        self.LocalTaskID = params.get("LocalTaskID")
        self.RegistryTaskID = params.get("RegistryTaskID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVulScanInfoResponse(AbstractModel):
    """DescribeVulScanInfo response structure.

    """

    def __init__(self):
        r"""
        :param LocalImageScanCount: Total number of local images scanned this time
        :type LocalImageScanCount: int
        :param IgnoreVulCount: Number of ignored vulnerabilities
        :type IgnoreVulCount: int
        :param ScanStartTime: Start time of the vulnerability scan
        :type ScanStartTime: str
        :param ScanEndTime: End time of the vulnerability scan
        :type ScanEndTime: str
        :param FoundRiskImageCount: Number of images found to be at risk
        :type FoundRiskImageCount: int
        :param FoundVulCount: Number of vulnerabilities found in local images
        :type FoundVulCount: int
        :param ScanProgress: Scanning progress
        :type ScanProgress: float
        :param RegistryImageScanCount: Total number of repository images scanned this time
        :type RegistryImageScanCount: int
        :param LocalTaskID: ID of the last task to scan local images for vulnerabilities
        :type LocalTaskID: int
        :param Status: Scanning status. Valid values: `NOT_SCAN` (not scanned); `SCANNING` (scanning); `SCANNED` (scanned); `CANCELED` (stopped).
        :type Status: str
        :param RemainingTime: Remaining time in seconds
        :type RemainingTime: float
        :param RegistryTaskID: ID of the last task to scan repository images for vulnerabilities
        :type RegistryTaskID: int
        :param RegistryFoundVulCount: Number of vulnerabilities found in the repository
        :type RegistryFoundVulCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.LocalImageScanCount = None
        self.IgnoreVulCount = None
        self.ScanStartTime = None
        self.ScanEndTime = None
        self.FoundRiskImageCount = None
        self.FoundVulCount = None
        self.ScanProgress = None
        self.RegistryImageScanCount = None
        self.LocalTaskID = None
        self.Status = None
        self.RemainingTime = None
        self.RegistryTaskID = None
        self.RegistryFoundVulCount = None
        self.RequestId = None


    def _deserialize(self, params):
        self.LocalImageScanCount = params.get("LocalImageScanCount")
        self.IgnoreVulCount = params.get("IgnoreVulCount")
        self.ScanStartTime = params.get("ScanStartTime")
        self.ScanEndTime = params.get("ScanEndTime")
        self.FoundRiskImageCount = params.get("FoundRiskImageCount")
        self.FoundVulCount = params.get("FoundVulCount")
        self.ScanProgress = params.get("ScanProgress")
        self.RegistryImageScanCount = params.get("RegistryImageScanCount")
        self.LocalTaskID = params.get("LocalTaskID")
        self.Status = params.get("Status")
        self.RemainingTime = params.get("RemainingTime")
        self.RegistryTaskID = params.get("RegistryTaskID")
        self.RegistryFoundVulCount = params.get("RegistryFoundVulCount")
        self.RequestId = params.get("RequestId")


class DescribeVulScanLocalImageListRequest(AbstractModel):
    """DescribeVulScanLocalImageList request structure.

    """

    def __init__(self):
        r"""
        :param TaskID: Vulnerability scan task ID
        :type TaskID: int
        :param Filters: Filter
<li>OnlyAffectedNewestImage- Bool- Required: No - Show only vulnerabilities that affect the latest image tags</li>
<li>ImageID- string - Required: No - Image ID</li>
<li>ImageName- String - Required: No - Image name</li>
<li>ScanStatus- string - Required: No - Check status. Valid values: `WAIT_SCAN` (pending); `SCANNING` (checking); `SCANNED` (checked); `SCAN_ERR` (failed to check); `CANCELED` (check ended).</li>
        :type Filters: list of RunTimeFilters
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Order: Sorting order
        :type Order: str
        :param By: Sorting field
        :type By: str
        """
        self.TaskID = None
        self.Filters = None
        self.Limit = None
        self.Offset = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.TaskID = params.get("TaskID")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVulScanLocalImageListResponse(AbstractModel):
    """DescribeVulScanLocalImageList response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number of images
        :type TotalCount: int
        :param List: List of images
        :type List: list of VulScanImageInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.List = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = VulScanImageInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeVulSummaryRequest(AbstractModel):
    """DescribeVulSummary request structure.

    """

    def __init__(self):
        r"""
        :param Filters: Filter
<li>OnlyAffectedNewestImage- string- Required: No - Show only vulnerabilities that affect the latest image tags. Valid values: `true`, `false`.</li>
<li>OnlyAffectedContainer-string- Required: No - Show only vulnerabilities that affect containers. Valid values: `true`, `false`.</li>
<li>CategoryType- string - Required: No - Vulnerability type. Valid values: `SYSTEM` (system vulnerability); `WEB` (web application vulnerability); `ALL` (all vulnerabilities).</li>
        :type Filters: list of RunTimeFilters
        """
        self.Filters = None


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVulSummaryResponse(AbstractModel):
    """DescribeVulSummary response structure.

    """

    def __init__(self):
        r"""
        :param VulTotalCount: Total number of vulnerabilities
        :type VulTotalCount: int
        :param SeriousVulCount: Number of critical and high-risk vulnerabilities
        :type SeriousVulCount: int
        :param SuggestVulCount: Number of high-priority vulnerabilities
        :type SuggestVulCount: int
        :param PocExpLevelVulCount: Number of vulnerabilities with POC or EXP
        :type PocExpLevelVulCount: int
        :param RemoteExpLevelVulCount: Number of vulnerabilities with remote EXP
        :type RemoteExpLevelVulCount: int
        :param SeriousVulNewestImageCount: Number of images on the latest version affected by critical or high-risk vulnerabilities
        :type SeriousVulNewestImageCount: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.VulTotalCount = None
        self.SeriousVulCount = None
        self.SuggestVulCount = None
        self.PocExpLevelVulCount = None
        self.RemoteExpLevelVulCount = None
        self.SeriousVulNewestImageCount = None
        self.RequestId = None


    def _deserialize(self, params):
        self.VulTotalCount = params.get("VulTotalCount")
        self.SeriousVulCount = params.get("SeriousVulCount")
        self.SuggestVulCount = params.get("SuggestVulCount")
        self.PocExpLevelVulCount = params.get("PocExpLevelVulCount")
        self.RemoteExpLevelVulCount = params.get("RemoteExpLevelVulCount")
        self.SeriousVulNewestImageCount = params.get("SeriousVulNewestImageCount")
        self.RequestId = params.get("RequestId")


class DescribeVulTendencyRequest(AbstractModel):
    """DescribeVulTendency request structure.

    """

    def __init__(self):
        r"""
        :param StartTime: Start time
        :type StartTime: str
        :param EndTime: End time
        :type EndTime: str
        :param SphereOfInfluence: Enumeration:
`LATEST`: Latest version.
`CONTAINER`: Running container.
        :type SphereOfInfluence: str
        """
        self.StartTime = None
        self.EndTime = None
        self.SphereOfInfluence = None


    def _deserialize(self, params):
        self.StartTime = params.get("StartTime")
        self.EndTime = params.get("EndTime")
        self.SphereOfInfluence = params.get("SphereOfInfluence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVulTendencyResponse(AbstractModel):
    """DescribeVulTendency response structure.

    """

    def __init__(self):
        r"""
        :param VulTendencySet: List of vulnerability trends
        :type VulTendencySet: list of VulTendencyInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.VulTendencySet = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("VulTendencySet") is not None:
            self.VulTendencySet = []
            for item in params.get("VulTendencySet"):
                obj = VulTendencyInfo()
                obj._deserialize(item)
                self.VulTendencySet.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeVulTopRankingRequest(AbstractModel):
    """DescribeVulTopRanking request structure.

    """

    def __init__(self):
        r"""
        :param CategoryType: Vulnerability type. Valid values: `SYSTEM` (system vulnerability); `WEB` (web application vulnerability); `EMERGENCY` (emergency vulnerability).
        :type CategoryType: str
        """
        self.CategoryType = None


    def _deserialize(self, params):
        self.CategoryType = params.get("CategoryType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVulTopRankingResponse(AbstractModel):
    """DescribeVulTopRanking response structure.

    """

    def __init__(self):
        r"""
        :param List: List of top vulnerabilities
        :type List: list of VulTopRankingInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.List = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = VulTopRankingInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeWarningRulesRequest(AbstractModel):
    """DescribeWarningRules request structure.

    """


class DescribeWarningRulesResponse(AbstractModel):
    """DescribeWarningRules response structure.

    """

    def __init__(self):
        r"""
        :param WarningRules: List of alert policies
        :type WarningRules: list of WarningRule
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.WarningRules = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("WarningRules") is not None:
            self.WarningRules = []
            for item in params.get("WarningRules"):
                obj = WarningRule()
                obj._deserialize(item)
                self.WarningRules.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeWebVulListRequest(AbstractModel):
    """DescribeWebVulList request structure.

    """

    def __init__(self):
        r"""
        :param Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param Offset: Offset. Default value: `0`.
        :type Offset: int
        :param Filters: Filter
<li>OnlyAffectedContainer- string - Required: No - Show only vulnerabilities that affect containers. Valid values: `true`, `false`.</li>
<li>OnlyAffectedNewestImage-string - Required: No - Show only vulnerabilities that affect the latest image tags. Valid values: `true`, `false`.</li>
<li>Level- String - Required: No - Severity. Valid values: `CRITICAL` (critical); `HIGH` (high); `MIDDLE` (medium); `LOW` (low).</li>
<li>Tags- string - Required: No - Vulnerability tag. Valid values: `POC`, `EXP`.</li>
<li>CanBeFixed- string - Required: No - Whether the vulnerability can be fixed. Valid values: `true`, `false`.</li>
<li>CVEID- string - Required: No - CVE No.</li>
<li>ImageID- string - Required: No - Image ID</li>
<li>ImageName- String - Required: No - Image name</li>
<li>ContainerID- string - Required: No - Container ID</li>
<li>ContainerName- string - Required: No - Container name</li>
<li>ComponentName- string - Required: No - Component name</li>
<li>ComponentVersion- string - Required: No - Component version</li>
<li>Name- string - Required: No - Vulnerability name</li>
<li>FocusOnType - string - Required: No - Urgency. Valid values: `ALL` (all); `SERIOUS_LEVEL (critical and high risks); `IS_SUGGEST` (high-priority); `POC_EXP` (POC/EXP); `NETWORK_EXP` (remote EXP).</li>
        :type Filters: list of RunTimeFilters
        :param Order: Sorting order
        :type Order: str
        :param By: Sorting field
        :type By: str
        """
        self.Limit = None
        self.Offset = None
        self.Filters = None
        self.Order = None
        self.By = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        self.Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWebVulListResponse(AbstractModel):
    """DescribeWebVulList response structure.

    """

    def __init__(self):
        r"""
        :param TotalCount: Total number of vulnerabilities
        :type TotalCount: int
        :param List: List of vulnerabilities
        :type List: list of VulInfo
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TotalCount = None
        self.List = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = VulInfo()
                obj._deserialize(item)
                self.List.append(obj)
        self.RequestId = params.get("RequestId")


class EmergencyVulInfo(AbstractModel):
    """List of emergency vulnerabilities

    """

    def __init__(self):
        r"""
        :param Name: Vulnerability name
        :type Name: str
        :param Tags: Vulnerability tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tags: list of str
        :param CVSSV3Score: CVSS V3 score
Note: This field may return null, indicating that no valid values can be obtained.
        :type CVSSV3Score: float
        :param Level: Risk level
Note: This field may return null, indicating that no valid values can be obtained.
        :type Level: str
        :param CVEID: CVE No.
        :type CVEID: str
        :param Category: Vulnerability type
Note: This field may return null, indicating that no valid values can be obtained.
        :type Category: str
        :param SubmitTime: Vulnerability disclosure time
Note: This field may return null, indicating that no valid values can be obtained.
        :type SubmitTime: str
        :param LatestFoundTime: Last discovery time
Note: This field may return null, indicating that no valid values can be obtained.
        :type LatestFoundTime: str
        :param Status: Emergency vulnerability risk information. Valid values: `NOT_SCAN` (not scanned); `SCANNING` (scanning); `SCANNED_NOT_RISK` (scanned and at no risk); `SCANNED_RISK` (scanned and at risk).
        :type Status: str
        :param ID: Vulnerability ID
        :type ID: int
        :param PocID: POC ID
        :type PocID: str
        :param DefenceStatus: Defense status. Valid values: `NO_DEFENDED`, `DEFENDED`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type DefenceStatus: str
        :param DefenceScope: Scope of servers with exploit prevention enabled. Valid values: `MANUAL` (specified servers); `ALL` (all servers).
Note: This field may return null, indicating that no valid values can be obtained.
        :type DefenceScope: str
        :param DefenceHostCount: Number of servers with exploit prevention enabled
Note: This field may return null, indicating that no valid values can be obtained.
        :type DefenceHostCount: int
        :param DefendedCount: Number of attacks defended against
Note: This field may return null, indicating that no valid values can be obtained.
        :type DefendedCount: int
        """
        self.Name = None
        self.Tags = None
        self.CVSSV3Score = None
        self.Level = None
        self.CVEID = None
        self.Category = None
        self.SubmitTime = None
        self.LatestFoundTime = None
        self.Status = None
        self.ID = None
        self.PocID = None
        self.DefenceStatus = None
        self.DefenceScope = None
        self.DefenceHostCount = None
        self.DefendedCount = None


    def _deserialize(self, params):
        self.Name = params.get("Name")
        self.Tags = params.get("Tags")
        self.CVSSV3Score = params.get("CVSSV3Score")
        self.Level = params.get("Level")
        self.CVEID = params.get("CVEID")
        self.Category = params.get("Category")
        self.SubmitTime = params.get("SubmitTime")
        self.LatestFoundTime = params.get("LatestFoundTime")
        self.Status = params.get("Status")
        self.ID = params.get("ID")
        self.PocID = params.get("PocID")
        self.DefenceStatus = params.get("DefenceStatus")
        self.DefenceScope = params.get("DefenceScope")
        self.DefenceHostCount = params.get("DefenceHostCount")
        self.DefendedCount = params.get("DefendedCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EscapeEventDescription(AbstractModel):
    """Description of the container escape event at runtime

    """

    def __init__(self):
        r"""
        :param Description: Event rule
        :type Description: str
        :param Solution: Solution
        :type Solution: str
        :param Remark: Event remarks
Note: This field may return null, indicating that no valid values can be obtained.
        :type Remark: str
        :param OperationTime: Last processing time of the event
Note: This field may return null, indicating that no valid values can be obtained.
        :type OperationTime: str
        """
        self.Description = None
        self.Solution = None
        self.Remark = None
        self.OperationTime = None


    def _deserialize(self, params):
        self.Description = params.get("Description")
        self.Solution = params.get("Solution")
        self.Remark = params.get("Remark")
        self.OperationTime = params.get("OperationTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EscapeEventInfo(AbstractModel):
    """List of container escape events

    """

    def __init__(self):
        r"""
        :param EventType: Event type
   `ESCAPE_HOST_ACESS_FILE`: Host file access escape.
   `ESCAPE_MOUNT_NAMESPACE`: Mount namespace escape.
   `ESCAPE_PRIVILEDGE`: Program privilege escalation escape.
   `ESCAPE_PRIVILEDGE_CONTAINER_START`: Privileged container startup escape.
   `ESCAPE_MOUNT_SENSITIVE_PTAH`: Sensitive path mount.
   `ESCAPE_SYSCALL`: Syscall escape.
        :type EventType: str
        :param ContainerName: Container name
        :type ContainerName: str
        :param ImageName: Image name
        :type ImageName: str
        :param Status: Status. Valid values: `EVENT_UNDEAL` (pending); `EVENT_DEALED` (processed); `EVENT_INGNORE` (ignored).
        :type Status: str
        :param EventId: Unique event ID
        :type EventId: str
        :param NodeName: Node name
        :type NodeName: str
        :param PodName: Pod (instance) name
        :type PodName: str
        :param FoundTime: Generation time
        :type FoundTime: str
        :param EventName: Event name
Host file access escape
Syscall escape
Mount namespace escape
Program privilege escalation escape
Privileged container startup escape
Sensitive path mount
        :type EventName: str
        :param ImageId: Image ID, which is used for redirect.
        :type ImageId: str
        :param ContainerId: Container ID, which is used for redirect.
        :type ContainerId: str
        :param Solution: Event solution
        :type Solution: str
        :param Description: Event description
        :type Description: str
        :param EventCount: Number of events
        :type EventCount: int
        :param LatestFoundTime: Last generation time
        :type LatestFoundTime: str
        :param NodeIP: Node IP
Note: This field may return null, indicating that no valid values can be obtained.
        :type NodeIP: str
        :param HostID: Server IP
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostID: str
        :param ContainerNetStatus: Network status
`NORMAL`: 	Not isolated.
`ISOLATED`: 		Isolated.
`ISOLATING`: 		Isolating.
`ISOLATE_FAILED`: 	Isolation failed.
`RESTORING`: Recovering.
`RESTORE_FAILED`: Recovery failed.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ContainerNetStatus: str
        :param ContainerNetSubStatus: Sub-status of the container
"AGENT_OFFLINE"       // The agent is offline.
"NODE_DESTROYED"      // The node is terminated.
"CONTAINER_EXITED"    // The container exited.
"CONTAINER_DESTROYED" // The container was terminated.
"SHARED_HOST"         // The container shares the network with the server.
"RESOURCE_LIMIT"      // The number of resources to be isolated exceeds the limit.
"UNKNOW"              // The reason is unknown.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ContainerNetSubStatus: str
        :param ContainerIsolateOperationSrc: Container isolation operation source
Note: This field may return null, indicating that no valid values can be obtained.
        :type ContainerIsolateOperationSrc: str
        :param ContainerStatus: Container status
`RUNNING`: Running.
`PAUSED`: Paused.
`STOPPED`: Stopped.
`CREATED`: Created.
`DESTROYED`: Terminated.
`RESTARTING`: Restarting.
`REMOVING`: Removing.
        :type ContainerStatus: str
        """
        self.EventType = None
        self.ContainerName = None
        self.ImageName = None
        self.Status = None
        self.EventId = None
        self.NodeName = None
        self.PodName = None
        self.FoundTime = None
        self.EventName = None
        self.ImageId = None
        self.ContainerId = None
        self.Solution = None
        self.Description = None
        self.EventCount = None
        self.LatestFoundTime = None
        self.NodeIP = None
        self.HostID = None
        self.ContainerNetStatus = None
        self.ContainerNetSubStatus = None
        self.ContainerIsolateOperationSrc = None
        self.ContainerStatus = None


    def _deserialize(self, params):
        self.EventType = params.get("EventType")
        self.ContainerName = params.get("ContainerName")
        self.ImageName = params.get("ImageName")
        self.Status = params.get("Status")
        self.EventId = params.get("EventId")
        self.NodeName = params.get("NodeName")
        self.PodName = params.get("PodName")
        self.FoundTime = params.get("FoundTime")
        self.EventName = params.get("EventName")
        self.ImageId = params.get("ImageId")
        self.ContainerId = params.get("ContainerId")
        self.Solution = params.get("Solution")
        self.Description = params.get("Description")
        self.EventCount = params.get("EventCount")
        self.LatestFoundTime = params.get("LatestFoundTime")
        self.NodeIP = params.get("NodeIP")
        self.HostID = params.get("HostID")
        self.ContainerNetStatus = params.get("ContainerNetStatus")
        self.ContainerNetSubStatus = params.get("ContainerNetSubStatus")
        self.ContainerIsolateOperationSrc = params.get("ContainerIsolateOperationSrc")
        self.ContainerStatus = params.get("ContainerStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EscapeEventTendencyInfo(AbstractModel):
    """Trend of pending escape events

    """

    def __init__(self):
        r"""
        :param RiskContainerEventCount: Total number of pending containers at risk
        :type RiskContainerEventCount: int
        :param ProcessPrivilegeEventCount: Total number of pending program privilege escalation events
        :type ProcessPrivilegeEventCount: int
        :param ContainerEscapeEventCount: Total number of pending container escape events
        :type ContainerEscapeEventCount: int
        :param Date: Date
        :type Date: str
        """
        self.RiskContainerEventCount = None
        self.ProcessPrivilegeEventCount = None
        self.ContainerEscapeEventCount = None
        self.Date = None


    def _deserialize(self, params):
        self.RiskContainerEventCount = params.get("RiskContainerEventCount")
        self.ProcessPrivilegeEventCount = params.get("ProcessPrivilegeEventCount")
        self.ContainerEscapeEventCount = params.get("ContainerEscapeEventCount")
        self.Date = params.get("Date")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EscapeRule(AbstractModel):
    """Enablement/Disablement of the container escape scan policy

    """

    def __init__(self):
        r"""
        :param Type: Rule type   
`ESCAPE_HOST_ACESS_FILE`: Host file access escape.
   `ESCAPE_MOUNT_NAMESPACE`: Mount namespace escape.
   `ESCAPE_PRIVILEDGE`: Program privilege escalation escape.
   `ESCAPE_PRIVILEDGE_CONTAINER_START`: Privileged container startup escape.
   `ESCAPE_MOUNT_SENSITIVE_PTAH`: Sensitive path mount.
`ESCAPE_SYSCALL`: Syscall escape.
        :type Type: str
        :param Name: Rule name
Host file access escape
Syscall escape
Mount namespace escape
Program privilege escalation escape
Privileged container startup escape
Sensitive path mount
        :type Name: str
        :param IsEnable: Whether to enable. Valid values: `false` (no); `true` (yes).
        :type IsEnable: bool
        :param Group: Rule group. Valid values: `RISK_CONTAINER` (container in risk); `PROCESS_PRIVILEGE` (program privilege escalation); `CONTAINER_ESCAPE` (container escape).
        :type Group: str
        """
        self.Type = None
        self.Name = None
        self.IsEnable = None
        self.Group = None


    def _deserialize(self, params):
        self.Type = params.get("Type")
        self.Name = params.get("Name")
        self.IsEnable = params.get("IsEnable")
        self.Group = params.get("Group")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EscapeRuleEnabled(AbstractModel):
    """Enablement/Disablement of the container escape scan policy

    """

    def __init__(self):
        r"""
        :param Type: Rule type
   `ESCAPE_HOST_ACESS_FILE`: Host file access escape.
   `ESCAPE_MOUNT_NAMESPACE`: Mount namespace escape.
   `ESCAPE_PRIVILEDGE`: Program privilege escalation escape.
   `ESCAPE_PRIVILEDGE_CONTAINER_START`: Privileged container startup escape.
   `ESCAPE_MOUNT_SENSITIVE_PTAH`: Sensitive path mount.
   `ESCAPE_SYSCALL`: Syscall escape.
        :type Type: str
        :param IsEnable: Whether to enable. Valid values: `false` (no); `true` (yes).
        :type IsEnable: bool
        """
        self.Type = None
        self.IsEnable = None


    def _deserialize(self, params):
        self.Type = params.get("Type")
        self.IsEnable = params.get("IsEnable")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EscapeWhiteListInfo(AbstractModel):
    """Escape allowlist

    """

    def __init__(self):
        r"""
        :param ImageID: Image ID
        :type ImageID: str
        :param ImageName: Image name
        :type ImageName: str
        :param ID: Allowed item ID
        :type ID: int
        :param HostCount: Number of associated servers
        :type HostCount: int
        :param ContainerCount: Number of associated containers
        :type ContainerCount: int
        :param EventType: Allowed event type
        :type EventType: list of str
        :param InsertTime: Creation time
        :type InsertTime: str
        :param UpdateTime: Update time
        :type UpdateTime: str
        :param ImageSize: Image size
        :type ImageSize: int
        """
        self.ImageID = None
        self.ImageName = None
        self.ID = None
        self.HostCount = None
        self.ContainerCount = None
        self.EventType = None
        self.InsertTime = None
        self.UpdateTime = None
        self.ImageSize = None


    def _deserialize(self, params):
        self.ImageID = params.get("ImageID")
        self.ImageName = params.get("ImageName")
        self.ID = params.get("ID")
        self.HostCount = params.get("HostCount")
        self.ContainerCount = params.get("ContainerCount")
        self.EventType = params.get("EventType")
        self.InsertTime = params.get("InsertTime")
        self.UpdateTime = params.get("UpdateTime")
        self.ImageSize = params.get("ImageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportJobInfo(AbstractModel):
    """Export job details

    """

    def __init__(self):
        r"""
        :param JobID: Job ID
        :type JobID: str
        :param JobName: Job name
        :type JobName: str
        :param Source: Source
        :type Source: str
        :param ExportStatus: Export status
        :type ExportStatus: str
        :param ExportProgress: Export progress
        :type ExportProgress: int
        :param FailureMsg: Reason for failure
        :type FailureMsg: str
        :param Timeout: Timeout threshold
        :type Timeout: str
        :param InsertTime: Insertion time
        :type InsertTime: str
        """
        self.JobID = None
        self.JobName = None
        self.Source = None
        self.ExportStatus = None
        self.ExportProgress = None
        self.FailureMsg = None
        self.Timeout = None
        self.InsertTime = None


    def _deserialize(self, params):
        self.JobID = params.get("JobID")
        self.JobName = params.get("JobName")
        self.Source = params.get("Source")
        self.ExportStatus = params.get("ExportStatus")
        self.ExportProgress = params.get("ExportProgress")
        self.FailureMsg = params.get("FailureMsg")
        self.Timeout = params.get("Timeout")
        self.InsertTime = params.get("InsertTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportVirusListRequest(AbstractModel):
    """ExportVirusList request structure.

    """

    def __init__(self):
        r"""
        :param Filters: Filter
<li>FileName - String - Required: No - Filename</li>
<li>FilePath - String - Required: No - File path</li>
<li>VirusName - String - Required: No - Virus name</li>
<li>ContainerName- String - Required: Yes - Container name</li>
<li>ContainerId- string - Required: No - Container ID</li>
<li>ImageName- string - Required: No - Image name</li>
<li>ImageId- string - Required: No - Image ID</li>
<li>IsRealTime- int - Required: No - Whether it is real-time monitoring data</li>
<li>TaskId- string - Required: No - Task ID</li>
<li>TimeRange - string - Required: No - Time range ["2022-03-31 16:55:00", "2022-03-31 17:00:00"]</li>
<li>ContainerNetStatus - String - Required: No - Container network status. Valid values: `NORMAL`, `ISOLATED`, `ISOLATING`, `RESTORING`, `RESTORE_FAILED`.</li>
<li>ContainerStatus - string - Required: No - Container status. Valid values: `RUNNING`, `PAUSED`, `STOPPED`, `CREATED`, `DESTROYED`, `RESTARTING`, `REMOVING`.</li>
<li>AutoIsolateMode - string - Required: No - Isolation method. Valid values: `MANUAL`, `AUTO`.</li>
<li>MD5 - string - Required: No - MD5</li>
        :type Filters: list of RunTimeFilters
        :param Order: Sorting order
        :type Order: str
        :param By: Sorting field
        :type By: str
        :param ExportField: Export field
        :type ExportField: list of str
        """
        self.Filters = None
        self.Order = None
        self.By = None
        self.ExportField = None


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Order = params.get("Order")
        self.By = params.get("By")
        self.ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportVirusListResponse(AbstractModel):
    """ExportVirusList response structure.

    """

    def __init__(self):
        r"""
        :param JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.JobId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.JobId = params.get("JobId")
        self.RequestId = params.get("RequestId")


class FileAttributeInfo(AbstractModel):
    """Container runtime security - File attribute information

    """

    def __init__(self):
        r"""
        :param FileName: Filename
        :type FileName: str
        :param FileType: File type
        :type FileType: str
        :param FileSize: File size in bytes
        :type FileSize: int
        :param FilePath: File path
        :type FilePath: str
        :param FileCreateTime: File creation time
        :type FileCreateTime: str
        :param LatestTamperedFileMTime: Time when the file is last tampered with
        :type LatestTamperedFileMTime: str
        :param NewFile: Content of the new file
        :type NewFile: str
        :param FileDiff: Differences between old and new files
        :type FileDiff: str
        """
        self.FileName = None
        self.FileType = None
        self.FileSize = None
        self.FilePath = None
        self.FileCreateTime = None
        self.LatestTamperedFileMTime = None
        self.NewFile = None
        self.FileDiff = None


    def _deserialize(self, params):
        self.FileName = params.get("FileName")
        self.FileType = params.get("FileType")
        self.FileSize = params.get("FileSize")
        self.FilePath = params.get("FilePath")
        self.FileCreateTime = params.get("FileCreateTime")
        self.LatestTamperedFileMTime = params.get("LatestTamperedFileMTime")
        self.NewFile = params.get("NewFile")
        self.FileDiff = params.get("FileDiff")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HostInfo(AbstractModel):
    """List of server IDs

    """

    def __init__(self):
        r"""
        :param HostID: Server ID
        :type HostID: str
        :param HostIP: Server IP, which is the private IP
        :type HostIP: str
        :param HostName: Server name
        :type HostName: str
        :param Group: Project
        :type Group: str
        :param DockerVersion: Docker version
        :type DockerVersion: str
        :param DockerFileSystemDriver: Docker file system type
        :type DockerFileSystemDriver: str
        :param ImageCnt: Number of images
        :type ImageCnt: int
        :param ContainerCnt: Number of containers
        :type ContainerCnt: int
        :param Status: Agent status
        :type Status: str
        :param IsContainerd: Whether it is Containerd
        :type IsContainerd: bool
        :param MachineType: Server source. Valid values: `CVM`, `ECM`, `LH`, `BM`, `Other`. The first four values indicate Tencent Cloud instances, while the last one indicates non-Tencent Cloud instances.
        :type MachineType: str
        :param PublicIp: Public IP
        :type PublicIp: str
        :param Uuid: Server UUID
        :type Uuid: str
        :param InstanceID: Server instance ID
        :type InstanceID: str
        :param RegionID: Region ID
        :type RegionID: int
        :param Project: Project
Note: This field may return `null`, indicating that no valid value was found.
        :type Project: :class:`tencentcloud.tcss.v20201101.models.ProjectInfo`
        :param Tags: Tags
Note: This field may return `null`, indicating that no valid value was found.
        :type Tags: list of TagInfo
        """
        self.HostID = None
        self.HostIP = None
        self.HostName = None
        self.Group = None
        self.DockerVersion = None
        self.DockerFileSystemDriver = None
        self.ImageCnt = None
        self.ContainerCnt = None
        self.Status = None
        self.IsContainerd = None
        self.MachineType = None
        self.PublicIp = None
        self.Uuid = None
        self.InstanceID = None
        self.RegionID = None
        self.Project = None
        self.Tags = None


    def _deserialize(self, params):
        self.HostID = params.get("HostID")
        self.HostIP = params.get("HostIP")
        self.HostName = params.get("HostName")
        self.Group = params.get("Group")
        self.DockerVersion = params.get("DockerVersion")
        self.DockerFileSystemDriver = params.get("DockerFileSystemDriver")
        self.ImageCnt = params.get("ImageCnt")
        self.ContainerCnt = params.get("ContainerCnt")
        self.Status = params.get("Status")
        self.IsContainerd = params.get("IsContainerd")
        self.MachineType = params.get("MachineType")
        self.PublicIp = params.get("PublicIp")
        self.Uuid = params.get("Uuid")
        self.InstanceID = params.get("InstanceID")
        self.RegionID = params.get("RegionID")
        if params.get("Project") is not None:
            self.Project = ProjectInfo()
            self.Project._deserialize(params.get("Project"))
        if params.get("Tags") is not None:
            self.Tags = []
            for item in params.get("Tags"):
                obj = TagInfo()
                obj._deserialize(item)
                self.Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageAutoAuthorizedTask(AbstractModel):
    """Information of the automatic image licensing task

    """

    def __init__(self):
        r"""
        :param TaskId: Task ID
        :type TaskId: int
        :param Type: Licensing method. Valid values: `AUTO` (automatic licensing); `MANUAL` (manual licensing).
        :type Type: str
        :param AuthorizedDate: Task date
        :type AuthorizedDate: str
        :param Source: Image source. Valid values: `LOCAL` (local image); `REGISTRY` (repository image).
        :type Source: str
        :param LastAuthorizedTime: Last licensing time
        :type LastAuthorizedTime: str
        :param SuccessCount: Number of images automatically licensed successfully
        :type SuccessCount: int
        :param FailCount: Number of images failed to be automatically licensed
        :type FailCount: int
        :param LatestFailCode: Error code for the last task. Valid values: `REACH_LIMIT` (reaching the upper limit on licenses); `LICENSE_INSUFFICIENT` (insufficient licenses).
        :type LatestFailCode: str
        """
        self.TaskId = None
        self.Type = None
        self.AuthorizedDate = None
        self.Source = None
        self.LastAuthorizedTime = None
        self.SuccessCount = None
        self.FailCount = None
        self.LatestFailCode = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.Type = params.get("Type")
        self.AuthorizedDate = params.get("AuthorizedDate")
        self.Source = params.get("Source")
        self.LastAuthorizedTime = params.get("LastAuthorizedTime")
        self.SuccessCount = params.get("SuccessCount")
        self.FailCount = params.get("FailCount")
        self.LatestFailCode = params.get("LatestFailCode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageComponent(AbstractModel):
    """Information of a component in the image

    """

    def __init__(self):
        r"""
        :param Name: Component name
        :type Name: str
        :param Version: Component version
        :type Version: str
        :param Path: Component path
        :type Path: str
        :param Type: Component type
        :type Type: str
        :param VulCount: Number of component vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained.
        :type VulCount: int
        :param ImageID: Image ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageID: str
        """
        self.Name = None
        self.Version = None
        self.Path = None
        self.Type = None
        self.VulCount = None
        self.ImageID = None


    def _deserialize(self, params):
        self.Name = params.get("Name")
        self.Version = params.get("Version")
        self.Path = params.get("Path")
        self.Type = params.get("Type")
        self.VulCount = params.get("VulCount")
        self.ImageID = params.get("ImageID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageHost(AbstractModel):
    """List of images associated with servers

    """

    def __init__(self):
        r"""
        :param ImageID: Image ID
        :type ImageID: str
        :param HostID: Server ID
        :type HostID: str
        """
        self.ImageID = None
        self.HostID = None


    def _deserialize(self, params):
        self.ImageID = params.get("ImageID")
        self.HostID = params.get("HostID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageInfo(AbstractModel):
    """Basic image information

    """

    def __init__(self):
        r"""
        :param InstanceName: Instance name
        :type InstanceName: str
        :param Namespace: Namespace
        :type Namespace: str
        :param ImageName: Image name
        :type ImageName: str
        :param ImageTag: Image tag
        :type ImageTag: str
        :param Force: Forced scan
        :type Force: str
        :param ImageDigest: Image ID
        :type ImageDigest: str
        :param RegistryType: Repository type
        :type RegistryType: str
        :param ImageRepoAddress: Image repository address
        :type ImageRepoAddress: str
        :param InstanceId: Instance ID
        :type InstanceId: str
        """
        self.InstanceName = None
        self.Namespace = None
        self.ImageName = None
        self.ImageTag = None
        self.Force = None
        self.ImageDigest = None
        self.RegistryType = None
        self.ImageRepoAddress = None
        self.InstanceId = None


    def _deserialize(self, params):
        self.InstanceName = params.get("InstanceName")
        self.Namespace = params.get("Namespace")
        self.ImageName = params.get("ImageName")
        self.ImageTag = params.get("ImageTag")
        self.Force = params.get("Force")
        self.ImageDigest = params.get("ImageDigest")
        self.RegistryType = params.get("RegistryType")
        self.ImageRepoAddress = params.get("ImageRepoAddress")
        self.InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageProgress(AbstractModel):
    """Basic image information

    """

    def __init__(self):
        r"""
        :param ImageId: Image ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageId: str
        :param RegistryType: Repository type
Note: This field may return null, indicating that no valid values can be obtained.
        :type RegistryType: str
        :param ImageRepoAddress: Image repository address
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageRepoAddress: str
        :param InstanceId: Instance ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceId: str
        :param InstanceName: Instance name
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceName: str
        :param Namespace: Namespace
Note: This field may return null, indicating that no valid values can be obtained.
        :type Namespace: str
        :param ImageName: Repository name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageName: str
        :param ImageTag: Image tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageTag: str
        :param ScanStatus: Image scanning status
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanStatus: str
        :param CveProgress: CVE scanning progress of the image
Note: This field may return null, indicating that no valid values can be obtained.
        :type CveProgress: int
        :param RiskProgress: Sensitive data scanning progress of the image
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskProgress: int
        :param VirusProgress: Trojan scanning progress of the image
Note: This field may return null, indicating that no valid values can be obtained.
        :type VirusProgress: int
        """
        self.ImageId = None
        self.RegistryType = None
        self.ImageRepoAddress = None
        self.InstanceId = None
        self.InstanceName = None
        self.Namespace = None
        self.ImageName = None
        self.ImageTag = None
        self.ScanStatus = None
        self.CveProgress = None
        self.RiskProgress = None
        self.VirusProgress = None


    def _deserialize(self, params):
        self.ImageId = params.get("ImageId")
        self.RegistryType = params.get("RegistryType")
        self.ImageRepoAddress = params.get("ImageRepoAddress")
        self.InstanceId = params.get("InstanceId")
        self.InstanceName = params.get("InstanceName")
        self.Namespace = params.get("Namespace")
        self.ImageName = params.get("ImageName")
        self.ImageTag = params.get("ImageTag")
        self.ScanStatus = params.get("ScanStatus")
        self.CveProgress = params.get("CveProgress")
        self.RiskProgress = params.get("RiskProgress")
        self.VirusProgress = params.get("VirusProgress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageRepoInfo(AbstractModel):
    """List of image repositories

    """

    def __init__(self):
        r"""
        :param ImageDigest: Image digest
        :type ImageDigest: str
        :param ImageRepoAddress: Image repository address
        :type ImageRepoAddress: str
        :param RegistryType: Repository type
        :type RegistryType: str
        :param ImageName: Image name
        :type ImageName: str
        :param ImageTag: Image tag
        :type ImageTag: str
        :param ImageSize: Image size
        :type ImageSize: int
        :param ScanTime: Last scan time
        :type ScanTime: str
        :param ScanStatus: Scanning status
        :type ScanStatus: str
        :param VulCnt: Number of vulnerabilities
        :type VulCnt: int
        :param VirusCnt: Number of viruses and trojans
        :type VirusCnt: int
        :param RiskCnt: Number of risky behaviors
        :type RiskCnt: int
        :param SentiveInfoCnt: Number of sensitive data items
        :type SentiveInfoCnt: int
        :param IsTrustImage: Whether it is a trusted image
        :type IsTrustImage: bool
        :param OsName: Image system
        :type OsName: str
        :param ScanVirusError: Trojan scan error
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanVirusError: str
        :param ScanVulError: Vulnerability scan error
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanVulError: str
        :param InstanceId: Instance ID
        :type InstanceId: str
        :param InstanceName: Instance name
        :type InstanceName: str
        :param Namespace: Namespace
        :type Namespace: str
        :param ScanRiskError: High-risk scan error
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanRiskError: str
        :param ScanVirusProgress: Sensitive data scanning progress
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanVirusProgress: int
        :param ScanVulProgress: Trojan scanning progress
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanVulProgress: int
        :param ScanRiskProgress: Vulnerability scanning progress
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanRiskProgress: int
        :param ScanRemainTime: Remaining scan time in seconds
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanRemainTime: int
        :param CveStatus: CVE scanning status
Note: This field may return null, indicating that no valid values can be obtained.
        :type CveStatus: str
        :param RiskStatus: High-risk scanning status
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskStatus: str
        :param VirusStatus: Trojan scanning status
Note: This field may return null, indicating that no valid values can be obtained.
        :type VirusStatus: str
        :param Progress: Overall progress
Note: This field may return null, indicating that no valid values can be obtained.
        :type Progress: int
        :param IsAuthorized: Licensing status
        :type IsAuthorized: int
        :param RegistryRegion: Repository region
        :type RegistryRegion: str
        :param Id: List of IDs
        :type Id: int
        :param ImageId: Image ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageId: str
        :param ImageCreateTime: Image creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageCreateTime: str
        :param IsLatestImage: Whether it is the latest image tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsLatestImage: bool
        """
        self.ImageDigest = None
        self.ImageRepoAddress = None
        self.RegistryType = None
        self.ImageName = None
        self.ImageTag = None
        self.ImageSize = None
        self.ScanTime = None
        self.ScanStatus = None
        self.VulCnt = None
        self.VirusCnt = None
        self.RiskCnt = None
        self.SentiveInfoCnt = None
        self.IsTrustImage = None
        self.OsName = None
        self.ScanVirusError = None
        self.ScanVulError = None
        self.InstanceId = None
        self.InstanceName = None
        self.Namespace = None
        self.ScanRiskError = None
        self.ScanVirusProgress = None
        self.ScanVulProgress = None
        self.ScanRiskProgress = None
        self.ScanRemainTime = None
        self.CveStatus = None
        self.RiskStatus = None
        self.VirusStatus = None
        self.Progress = None
        self.IsAuthorized = None
        self.RegistryRegion = None
        self.Id = None
        self.ImageId = None
        self.ImageCreateTime = None
        self.IsLatestImage = None


    def _deserialize(self, params):
        self.ImageDigest = params.get("ImageDigest")
        self.ImageRepoAddress = params.get("ImageRepoAddress")
        self.RegistryType = params.get("RegistryType")
        self.ImageName = params.get("ImageName")
        self.ImageTag = params.get("ImageTag")
        self.ImageSize = params.get("ImageSize")
        self.ScanTime = params.get("ScanTime")
        self.ScanStatus = params.get("ScanStatus")
        self.VulCnt = params.get("VulCnt")
        self.VirusCnt = params.get("VirusCnt")
        self.RiskCnt = params.get("RiskCnt")
        self.SentiveInfoCnt = params.get("SentiveInfoCnt")
        self.IsTrustImage = params.get("IsTrustImage")
        self.OsName = params.get("OsName")
        self.ScanVirusError = params.get("ScanVirusError")
        self.ScanVulError = params.get("ScanVulError")
        self.InstanceId = params.get("InstanceId")
        self.InstanceName = params.get("InstanceName")
        self.Namespace = params.get("Namespace")
        self.ScanRiskError = params.get("ScanRiskError")
        self.ScanVirusProgress = params.get("ScanVirusProgress")
        self.ScanVulProgress = params.get("ScanVulProgress")
        self.ScanRiskProgress = params.get("ScanRiskProgress")
        self.ScanRemainTime = params.get("ScanRemainTime")
        self.CveStatus = params.get("CveStatus")
        self.RiskStatus = params.get("RiskStatus")
        self.VirusStatus = params.get("VirusStatus")
        self.Progress = params.get("Progress")
        self.IsAuthorized = params.get("IsAuthorized")
        self.RegistryRegion = params.get("RegistryRegion")
        self.Id = params.get("Id")
        self.ImageId = params.get("ImageId")
        self.ImageCreateTime = params.get("ImageCreateTime")
        self.IsLatestImage = params.get("IsLatestImage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageRisk(AbstractModel):
    """Information of a high-risk behavior in the image

    """

    def __init__(self):
        r"""
        :param Behavior: High-risk behavior
Note: This field may return null, indicating that no valid values can be obtained.
        :type Behavior: int
        :param Type: Type
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: int
        :param Level: Risk level
Note: This field may return null, indicating that no valid values can be obtained.
        :type Level: str
        :param Desc: Description
Note: This field may return null, indicating that no valid values can be obtained.
        :type Desc: str
        :param InstructionContent: Solution
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstructionContent: str
        """
        self.Behavior = None
        self.Type = None
        self.Level = None
        self.Desc = None
        self.InstructionContent = None


    def _deserialize(self, params):
        self.Behavior = params.get("Behavior")
        self.Type = params.get("Type")
        self.Level = params.get("Level")
        self.Desc = params.get("Desc")
        self.InstructionContent = params.get("InstructionContent")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageRiskInfo(AbstractModel):
    """Image risk details

    """

    def __init__(self):
        r"""
        :param Behavior: Behavior
        :type Behavior: int
        :param Type: Type
        :type Type: int
        :param Level: Level
        :type Level: int
        :param Desc: Details
        :type Desc: str
        :param InstructionContent: Solution
        :type InstructionContent: str
        """
        self.Behavior = None
        self.Type = None
        self.Level = None
        self.Desc = None
        self.InstructionContent = None


    def _deserialize(self, params):
        self.Behavior = params.get("Behavior")
        self.Type = params.get("Type")
        self.Level = params.get("Level")
        self.Desc = params.get("Desc")
        self.InstructionContent = params.get("InstructionContent")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageRiskTendencyInfo(AbstractModel):
    """Trend information of security events at runtime

    """

    def __init__(self):
        r"""
        :param ImageRiskSet: List of trends
        :type ImageRiskSet: list of RunTimeTendencyInfo
        :param ImageRiskType: Risk type:
`IRT_VULNERABILITY`: Vulnerability.
`IRT_MALWARE_VIRUS`: Virus and trojan.
`IRT_RISK`: Sensitive data.
        :type ImageRiskType: str
        """
        self.ImageRiskSet = None
        self.ImageRiskType = None


    def _deserialize(self, params):
        if params.get("ImageRiskSet") is not None:
            self.ImageRiskSet = []
            for item in params.get("ImageRiskSet"):
                obj = RunTimeTendencyInfo()
                obj._deserialize(item)
                self.ImageRiskSet.append(obj)
        self.ImageRiskType = params.get("ImageRiskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageSimpleInfo(AbstractModel):
    """List of images

    """

    def __init__(self):
        r"""
        :param ImageID: Image ID
        :type ImageID: str
        :param ImageName: Image name
        :type ImageName: str
        :param Size: Image size
        :type Size: int
        :param ImageType: Type
        :type ImageType: str
        :param ContainerCnt: Number of associated containers
        :type ContainerCnt: int
        """
        self.ImageID = None
        self.ImageName = None
        self.Size = None
        self.ImageType = None
        self.ContainerCnt = None


    def _deserialize(self, params):
        self.ImageID = params.get("ImageID")
        self.ImageName = params.get("ImageName")
        self.Size = params.get("Size")
        self.ImageType = params.get("ImageType")
        self.ContainerCnt = params.get("ContainerCnt")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageVirus(AbstractModel):
    """Information of a virus in the image

    """

    def __init__(self):
        r"""
        :param Path: Path
Note: This field may return null, indicating that no valid values can be obtained.
        :type Path: str
        :param RiskLevel: Risk level
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskLevel: str
        :param Category: Category
Note: This field may return null, indicating that no valid values can be obtained.
        :type Category: str
        :param VirusName: Virus name
Note: This field may return null, indicating that no valid values can be obtained.
        :type VirusName: str
        :param Tags: Tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tags: list of str
        :param Desc: Description
Note: This field may return null, indicating that no valid values can be obtained.
        :type Desc: str
        :param Solution: Solution
Note: This field may return null, indicating that no valid values can be obtained.
        :type Solution: str
        :param FileType: File type
Note: This field may return null, indicating that no valid values can be obtained.
        :type FileType: str
        :param FileName: File path
Note: This field may return null, indicating that no valid values can be obtained.
        :type FileName: str
        :param FileMd5: MD5 checksum of the file
Note: This field may return null, indicating that no valid values can be obtained.
        :type FileMd5: str
        :param FileSize: Size
Note: This field may return null, indicating that no valid values can be obtained.
        :type FileSize: int
        :param FirstScanTime: First discovery time
Note: This field may return null, indicating that no valid values can be obtained.
        :type FirstScanTime: str
        :param LatestScanTime: Last scan time
Note: This field may return null, indicating that no valid values can be obtained.
        :type LatestScanTime: str
        """
        self.Path = None
        self.RiskLevel = None
        self.Category = None
        self.VirusName = None
        self.Tags = None
        self.Desc = None
        self.Solution = None
        self.FileType = None
        self.FileName = None
        self.FileMd5 = None
        self.FileSize = None
        self.FirstScanTime = None
        self.LatestScanTime = None


    def _deserialize(self, params):
        self.Path = params.get("Path")
        self.RiskLevel = params.get("RiskLevel")
        self.Category = params.get("Category")
        self.VirusName = params.get("VirusName")
        self.Tags = params.get("Tags")
        self.Desc = params.get("Desc")
        self.Solution = params.get("Solution")
        self.FileType = params.get("FileType")
        self.FileName = params.get("FileName")
        self.FileMd5 = params.get("FileMd5")
        self.FileSize = params.get("FileSize")
        self.FirstScanTime = params.get("FirstScanTime")
        self.LatestScanTime = params.get("LatestScanTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageVirusInfo(AbstractModel):
    """Information of a virus in the image

    """

    def __init__(self):
        r"""
        :param Path: Path
Note: This field may return null, indicating that no valid values can be obtained.
        :type Path: str
        :param RiskLevel: Risk level
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskLevel: int
        :param VirusName: Virus name
Note: This field may return null, indicating that no valid values can be obtained.
        :type VirusName: str
        :param Tags: Tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tags: list of str
        :param Desc: Description
Note: This field may return null, indicating that no valid values can be obtained.
        :type Desc: str
        :param Solution: Fix suggestion
Note: This field may return null, indicating that no valid values can be obtained.
        :type Solution: str
        :param Size: Size
Note: This field may return null, indicating that no valid values can be obtained.
        :type Size: int
        :param FirstScanTime: First discovery time
Note: This field may return null, indicating that no valid values can be obtained.
        :type FirstScanTime: str
        :param LatestScanTime: Last scan time
Note: This field may return null, indicating that no valid values can be obtained.
        :type LatestScanTime: str
        :param Md5: MD5 checksum of the file
Note: This field may return null, indicating that no valid values can be obtained.
        :type Md5: str
        :param FileName: Filename
Note: This field may return null, indicating that no valid values can be obtained.
        :type FileName: str
        :param CheckPlatform: Check platform
`1`: Tencent Cloud Security Engine.
`2`: tav.
`3`: binaryAi.
`4`: Unusual behavior.
`5`: Threat intelligence.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CheckPlatform: list of str
        """
        self.Path = None
        self.RiskLevel = None
        self.VirusName = None
        self.Tags = None
        self.Desc = None
        self.Solution = None
        self.Size = None
        self.FirstScanTime = None
        self.LatestScanTime = None
        self.Md5 = None
        self.FileName = None
        self.CheckPlatform = None


    def _deserialize(self, params):
        self.Path = params.get("Path")
        self.RiskLevel = params.get("RiskLevel")
        self.VirusName = params.get("VirusName")
        self.Tags = params.get("Tags")
        self.Desc = params.get("Desc")
        self.Solution = params.get("Solution")
        self.Size = params.get("Size")
        self.FirstScanTime = params.get("FirstScanTime")
        self.LatestScanTime = params.get("LatestScanTime")
        self.Md5 = params.get("Md5")
        self.FileName = params.get("FileName")
        self.CheckPlatform = params.get("CheckPlatform")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageVul(AbstractModel):
    """Information of a vulnerability in the image

    """

    def __init__(self):
        r"""
        :param CVEID: Vulnerability ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type CVEID: str
        :param POCID: POC ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type POCID: str
        :param Name: Vulnerability name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Name: str
        :param Components: Component information
Note: This field may return null, indicating that no valid values can be obtained.
        :type Components: list of ComponentsInfo
        :param Category: Category
Note: This field may return null, indicating that no valid values can be obtained.
        :type Category: str
        :param CategoryType: Category 2
Note: This field may return null, indicating that no valid values can be obtained.
        :type CategoryType: str
        :param Level: Risk level
Note: This field may return null, indicating that no valid values can be obtained.
        :type Level: str
        :param Des: Description
Note: This field may return null, indicating that no valid values can be obtained.
        :type Des: str
        :param OfficialSolution: Solution
Note: This field may return null, indicating that no valid values can be obtained.
        :type OfficialSolution: str
        :param Reference: Reference
Note: This field may return null, indicating that no valid values can be obtained.
        :type Reference: str
        :param DefenseSolution: Defense solution
Note: This field may return null, indicating that no valid values can be obtained.
        :type DefenseSolution: str
        :param SubmitTime: Submission time
Note: This field may return null, indicating that no valid values can be obtained.
        :type SubmitTime: str
        :param CvssScore: CVSS score
Note: This field may return null, indicating that no valid values can be obtained.
        :type CvssScore: str
        :param CvssVector: CVSS information
Note: This field may return null, indicating that no valid values can be obtained.
        :type CvssVector: str
        :param IsSuggest: Whether fix is suggested
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsSuggest: str
        :param FixedVersions: Number of the fixed version
Note: This field may return null, indicating that no valid values can be obtained.
        :type FixedVersions: str
        :param Tag: Vulnerability tag. Valid values: `CanBeFixed`, `DynamicLevelPoc`, `DynamicLevelExp`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tag: list of str
        :param Component: Component name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Component: str
        :param Version: Component version
Note: This field may return null, indicating that no valid values can be obtained.
        :type Version: str
        """
        self.CVEID = None
        self.POCID = None
        self.Name = None
        self.Components = None
        self.Category = None
        self.CategoryType = None
        self.Level = None
        self.Des = None
        self.OfficialSolution = None
        self.Reference = None
        self.DefenseSolution = None
        self.SubmitTime = None
        self.CvssScore = None
        self.CvssVector = None
        self.IsSuggest = None
        self.FixedVersions = None
        self.Tag = None
        self.Component = None
        self.Version = None


    def _deserialize(self, params):
        self.CVEID = params.get("CVEID")
        self.POCID = params.get("POCID")
        self.Name = params.get("Name")
        if params.get("Components") is not None:
            self.Components = []
            for item in params.get("Components"):
                obj = ComponentsInfo()
                obj._deserialize(item)
                self.Components.append(obj)
        self.Category = params.get("Category")
        self.CategoryType = params.get("CategoryType")
        self.Level = params.get("Level")
        self.Des = params.get("Des")
        self.OfficialSolution = params.get("OfficialSolution")
        self.Reference = params.get("Reference")
        self.DefenseSolution = params.get("DefenseSolution")
        self.SubmitTime = params.get("SubmitTime")
        self.CvssScore = params.get("CvssScore")
        self.CvssVector = params.get("CvssVector")
        self.IsSuggest = params.get("IsSuggest")
        self.FixedVersions = params.get("FixedVersions")
        self.Tag = params.get("Tag")
        self.Component = params.get("Component")
        self.Version = params.get("Version")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImagesBindRuleInfo(AbstractModel):
    """Information of the runtime rule bound to the image

    """

    def __init__(self):
        r"""
        :param ImageId: Image ID
        :type ImageId: str
        :param ImageName: Image name
        :type ImageName: str
        :param ContainerCnt: Number of associated containers
        :type ContainerCnt: int
        :param RuleId: Bound rule ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleId: str
        :param RuleName: Rule name
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleName: str
        :param ImageSize: Image size
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageSize: int
        :param ScanTime: Last scan time
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanTime: str
        """
        self.ImageId = None
        self.ImageName = None
        self.ContainerCnt = None
        self.RuleId = None
        self.RuleName = None
        self.ImageSize = None
        self.ScanTime = None


    def _deserialize(self, params):
        self.ImageId = params.get("ImageId")
        self.ImageName = params.get("ImageName")
        self.ContainerCnt = params.get("ContainerCnt")
        self.RuleId = params.get("RuleId")
        self.RuleName = params.get("RuleName")
        self.ImageSize = params.get("ImageSize")
        self.ScanTime = params.get("ScanTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImagesInfo(AbstractModel):
    """List of image IDs

    """

    def __init__(self):
        r"""
        :param ImageID: Image ID
        :type ImageID: str
        :param ImageName: Image name
        :type ImageName: str
        :param CreateTime: Creation time
        :type CreateTime: str
        :param Size: Image size
        :type Size: int
        :param HostCnt: Number of servers
        :type HostCnt: int
        :param ContainerCnt: Number of containers
        :type ContainerCnt: int
        :param ScanTime: Scan time
        :type ScanTime: str
        :param VulCnt: Number of vulnerabilities
        :type VulCnt: int
        :param VirusCnt: Number of viruses
        :type VirusCnt: int
        :param RiskCnt: Number of sensitive data items
        :type RiskCnt: int
        :param IsTrustImage: Whether it is a trusted image
        :type IsTrustImage: bool
        :param OsName: Image system
        :type OsName: str
        :param AgentError: Image scan error in the agent
        :type AgentError: str
        :param ScanError: Image scan error on the backend
        :type ScanError: str
        :param ScanStatus: Scanning status
        :type ScanStatus: str
        :param ScanVirusError: Trojan scan error message
        :type ScanVirusError: str
        :param ScanVulError: Vulnerability scan error message
        :type ScanVulError: str
        :param ScanRiskError: Risk scan error message
        :type ScanRiskError: str
        :param IsSuggest: Whether the image is of high priority. Valid values: `0` (no); others (yes).
        :type IsSuggest: int
        :param IsAuthorized: Whether it is licensed. Valid values: `1` (yes); `0` (no).
        :type IsAuthorized: int
        :param ComponentCnt: Number of components
        :type ComponentCnt: int
        """
        self.ImageID = None
        self.ImageName = None
        self.CreateTime = None
        self.Size = None
        self.HostCnt = None
        self.ContainerCnt = None
        self.ScanTime = None
        self.VulCnt = None
        self.VirusCnt = None
        self.RiskCnt = None
        self.IsTrustImage = None
        self.OsName = None
        self.AgentError = None
        self.ScanError = None
        self.ScanStatus = None
        self.ScanVirusError = None
        self.ScanVulError = None
        self.ScanRiskError = None
        self.IsSuggest = None
        self.IsAuthorized = None
        self.ComponentCnt = None


    def _deserialize(self, params):
        self.ImageID = params.get("ImageID")
        self.ImageName = params.get("ImageName")
        self.CreateTime = params.get("CreateTime")
        self.Size = params.get("Size")
        self.HostCnt = params.get("HostCnt")
        self.ContainerCnt = params.get("ContainerCnt")
        self.ScanTime = params.get("ScanTime")
        self.VulCnt = params.get("VulCnt")
        self.VirusCnt = params.get("VirusCnt")
        self.RiskCnt = params.get("RiskCnt")
        self.IsTrustImage = params.get("IsTrustImage")
        self.OsName = params.get("OsName")
        self.AgentError = params.get("AgentError")
        self.ScanError = params.get("ScanError")
        self.ScanStatus = params.get("ScanStatus")
        self.ScanVirusError = params.get("ScanVirusError")
        self.ScanVulError = params.get("ScanVulError")
        self.ScanRiskError = params.get("ScanRiskError")
        self.IsSuggest = params.get("IsSuggest")
        self.IsAuthorized = params.get("IsAuthorized")
        self.ComponentCnt = params.get("ComponentCnt")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImagesVul(AbstractModel):
    """Vulnerability in the image

    """

    def __init__(self):
        r"""
        :param CVEID: Vulnerability ID
        :type CVEID: str
        :param Name: Vulnerability name
        :type Name: str
        :param Component: Component
        :type Component: str
        :param Version: Version
        :type Version: str
        :param Category: Category
        :type Category: str
        :param CategoryType: Category 2
        :type CategoryType: str
        :param Level: Risk level
        :type Level: int
        :param Des: Description
        :type Des: str
        :param OfficialSolution: Solution
        :type OfficialSolution: str
        :param Reference: Reference
        :type Reference: str
        :param DefenseSolution: Defense solution
        :type DefenseSolution: str
        :param SubmitTime: Submission time
        :type SubmitTime: str
        :param CVSSV3Score: CVSS V3 score
        :type CVSSV3Score: float
        :param CVSSV3Desc: CVSS V3 description
        :type CVSSV3Desc: str
        :param IsSuggest: Whether it is of high priority. Valid values: `true` (yes); `false` (no).
        :type IsSuggest: bool
        :param FixedVersions: Number of the fixed version
Note: This field may return null, indicating that no valid values can be obtained.
        :type FixedVersions: str
        :param Tag: Vulnerability tag. Valid values: `CanBeFixed`, `DynamicLevelPoc`, `DynamicLevelExp`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tag: list of str
        """
        self.CVEID = None
        self.Name = None
        self.Component = None
        self.Version = None
        self.Category = None
        self.CategoryType = None
        self.Level = None
        self.Des = None
        self.OfficialSolution = None
        self.Reference = None
        self.DefenseSolution = None
        self.SubmitTime = None
        self.CVSSV3Score = None
        self.CVSSV3Desc = None
        self.IsSuggest = None
        self.FixedVersions = None
        self.Tag = None


    def _deserialize(self, params):
        self.CVEID = params.get("CVEID")
        self.Name = params.get("Name")
        self.Component = params.get("Component")
        self.Version = params.get("Version")
        self.Category = params.get("Category")
        self.CategoryType = params.get("CategoryType")
        self.Level = params.get("Level")
        self.Des = params.get("Des")
        self.OfficialSolution = params.get("OfficialSolution")
        self.Reference = params.get("Reference")
        self.DefenseSolution = params.get("DefenseSolution")
        self.SubmitTime = params.get("SubmitTime")
        self.CVSSV3Score = params.get("CVSSV3Score")
        self.CVSSV3Desc = params.get("CVSSV3Desc")
        self.IsSuggest = params.get("IsSuggest")
        self.FixedVersions = params.get("FixedVersions")
        self.Tag = params.get("Tag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InitializeUserComplianceEnvironmentRequest(AbstractModel):
    """InitializeUserComplianceEnvironment request structure.

    """


class InitializeUserComplianceEnvironmentResponse(AbstractModel):
    """InitializeUserComplianceEnvironment response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class K8sApiAbnormalEventInfo(AbstractModel):
    """K8sApi api abnormal event details

    """

    def __init__(self):
        r"""
        :param MatchRuleName: Hit rule name
        :type MatchRuleName: str
        :param MatchRuleType: Hit rule type
        :type MatchRuleType: str
        :param RiskLevel: Alarm level
        :type RiskLevel: str
        :param ClusterID: Cluster ID
        :type ClusterID: str
        :param ClusterName: Cluster name
        :type ClusterName: str
        :param ClusterRunningStatus: Cluster running status
        :type ClusterRunningStatus: str
        :param FirstCreateTime: First creation time
        :type FirstCreateTime: str
        :param LastCreateTime: Last creation time
        :type LastCreateTime: str
        :param AlarmCount: Number of alarms
        :type AlarmCount: int
        :param Status: Status
`EVENT_UNDEAL`: Unhandled
`EVENT_DEALED`: Handled
`EVENT_IGNORE`: Ignored
`EVENT_DEL`: Deleted
`EVENT_ADD_WHITE`: Added to an allowlist
        :type Status: str
        :param ClusterMasterIP: The master IP of a cluster
        :type ClusterMasterIP: str
        :param K8sVersion: K8s version
        :type K8sVersion: str
        :param RunningComponent: Runtime component
        :type RunningComponent: list of str
        :param Desc: Description
        :type Desc: str
        :param Suggestion: Suggestion
        :type Suggestion: str
        :param Info: Request information
        :type Info: str
        :param MatchRuleID: Rule ID
        :type MatchRuleID: str
        :param HighLightFields: An array of highlighted fields
        :type HighLightFields: list of str
        :param MatchRule: Hit rule
        :type MatchRule: :class:`tencentcloud.tcss.v20201101.models.K8sApiAbnormalRuleScopeInfo`
        """
        self.MatchRuleName = None
        self.MatchRuleType = None
        self.RiskLevel = None
        self.ClusterID = None
        self.ClusterName = None
        self.ClusterRunningStatus = None
        self.FirstCreateTime = None
        self.LastCreateTime = None
        self.AlarmCount = None
        self.Status = None
        self.ClusterMasterIP = None
        self.K8sVersion = None
        self.RunningComponent = None
        self.Desc = None
        self.Suggestion = None
        self.Info = None
        self.MatchRuleID = None
        self.HighLightFields = None
        self.MatchRule = None


    def _deserialize(self, params):
        self.MatchRuleName = params.get("MatchRuleName")
        self.MatchRuleType = params.get("MatchRuleType")
        self.RiskLevel = params.get("RiskLevel")
        self.ClusterID = params.get("ClusterID")
        self.ClusterName = params.get("ClusterName")
        self.ClusterRunningStatus = params.get("ClusterRunningStatus")
        self.FirstCreateTime = params.get("FirstCreateTime")
        self.LastCreateTime = params.get("LastCreateTime")
        self.AlarmCount = params.get("AlarmCount")
        self.Status = params.get("Status")
        self.ClusterMasterIP = params.get("ClusterMasterIP")
        self.K8sVersion = params.get("K8sVersion")
        self.RunningComponent = params.get("RunningComponent")
        self.Desc = params.get("Desc")
        self.Suggestion = params.get("Suggestion")
        self.Info = params.get("Info")
        self.MatchRuleID = params.get("MatchRuleID")
        self.HighLightFields = params.get("HighLightFields")
        if params.get("MatchRule") is not None:
            self.MatchRule = K8sApiAbnormalRuleScopeInfo()
            self.MatchRule._deserialize(params.get("MatchRule"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class K8sApiAbnormalEventListItem(AbstractModel):
    """Items in the K8sApi abnormal event list

    """

    def __init__(self):
        r"""
        :param ID: Event ID
        :type ID: int
        :param MatchRuleType: Hit rule type
        :type MatchRuleType: str
        :param RiskLevel: Threat level
        :type RiskLevel: str
        :param ClusterID: Cluster ID
        :type ClusterID: str
        :param ClusterName: Cluster name
        :type ClusterName: str
        :param ClusterRunningStatus: Cluster running status
        :type ClusterRunningStatus: str
        :param FirstCreateTime: First creation time
        :type FirstCreateTime: str
        :param LastCreateTime: Last creation time
        :type LastCreateTime: str
        :param AlarmCount: Number of alarms
        :type AlarmCount: int
        :param Status: Status
        :type Status: str
        :param RuleType: Rule type
        :type RuleType: str
        :param Desc: Description
        :type Desc: str
        :param Suggestion: Solution
        :type Suggestion: str
        :param RuleName: Rule name
        :type RuleName: str
        :param MatchRule: Hit rule
        :type MatchRule: :class:`tencentcloud.tcss.v20201101.models.K8sApiAbnormalRuleScopeInfo`
        """
        self.ID = None
        self.MatchRuleType = None
        self.RiskLevel = None
        self.ClusterID = None
        self.ClusterName = None
        self.ClusterRunningStatus = None
        self.FirstCreateTime = None
        self.LastCreateTime = None
        self.AlarmCount = None
        self.Status = None
        self.RuleType = None
        self.Desc = None
        self.Suggestion = None
        self.RuleName = None
        self.MatchRule = None


    def _deserialize(self, params):
        self.ID = params.get("ID")
        self.MatchRuleType = params.get("MatchRuleType")
        self.RiskLevel = params.get("RiskLevel")
        self.ClusterID = params.get("ClusterID")
        self.ClusterName = params.get("ClusterName")
        self.ClusterRunningStatus = params.get("ClusterRunningStatus")
        self.FirstCreateTime = params.get("FirstCreateTime")
        self.LastCreateTime = params.get("LastCreateTime")
        self.AlarmCount = params.get("AlarmCount")
        self.Status = params.get("Status")
        self.RuleType = params.get("RuleType")
        self.Desc = params.get("Desc")
        self.Suggestion = params.get("Suggestion")
        self.RuleName = params.get("RuleName")
        if params.get("MatchRule") is not None:
            self.MatchRule = K8sApiAbnormalRuleScopeInfo()
            self.MatchRule._deserialize(params.get("MatchRule"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class K8sApiAbnormalRuleInfo(AbstractModel):
    """K8sApi abnormal request rule details

    """

    def __init__(self):
        r"""
        :param RuleName: Rule name
        :type RuleName: str
        :param Status: Status
        :type Status: bool
        :param RuleInfoList: Rule information list
        :type RuleInfoList: list of K8sApiAbnormalRuleScopeInfo
        :param EffectClusterIDSet: Effective cluster IDSet
        :type EffectClusterIDSet: list of str
        :param RuleType: Rule type
RT_SYSTEM: System rules
RT_USER: User-defined rules
        :type RuleType: str
        :param EffectAllCluster: Whether all clusters are effective
        :type EffectAllCluster: bool
        :param RuleID: Rule ID
        :type RuleID: str
        """
        self.RuleName = None
        self.Status = None
        self.RuleInfoList = None
        self.EffectClusterIDSet = None
        self.RuleType = None
        self.EffectAllCluster = None
        self.RuleID = None


    def _deserialize(self, params):
        self.RuleName = params.get("RuleName")
        self.Status = params.get("Status")
        if params.get("RuleInfoList") is not None:
            self.RuleInfoList = []
            for item in params.get("RuleInfoList"):
                obj = K8sApiAbnormalRuleScopeInfo()
                obj._deserialize(item)
                self.RuleInfoList.append(obj)
        self.EffectClusterIDSet = params.get("EffectClusterIDSet")
        self.RuleType = params.get("RuleType")
        self.EffectAllCluster = params.get("EffectAllCluster")
        self.RuleID = params.get("RuleID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class K8sApiAbnormalRuleListItem(AbstractModel):
    """Items in the list of K8sApi abnormal request rules

    """

    def __init__(self):
        r"""
        :param RuleID: Rule ID
        :type RuleID: str
        :param RuleName: Rule name
        :type RuleName: str
        :param RuleType: Rule type
RT_SYSTEM System rules
RT_USER User defined
        :type RuleType: str
        :param EffectClusterCount: Total number of affected clusters
        :type EffectClusterCount: int
        :param UpdateTime: Update time
        :type UpdateTime: str
        :param OprUin: Edit account
        :type OprUin: str
        :param Status: Status
        :type Status: bool
        """
        self.RuleID = None
        self.RuleName = None
        self.RuleType = None
        self.EffectClusterCount = None
        self.UpdateTime = None
        self.OprUin = None
        self.Status = None


    def _deserialize(self, params):
        self.RuleID = params.get("RuleID")
        self.RuleName = params.get("RuleName")
        self.RuleType = params.get("RuleType")
        self.EffectClusterCount = params.get("EffectClusterCount")
        self.UpdateTime = params.get("UpdateTime")
        self.OprUin = params.get("OprUin")
        self.Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class K8sApiAbnormalRuleScopeInfo(AbstractModel):
    """Configuration range of K8sApi abnormal event rules

    """

    def __init__(self):
        r"""
        :param Scope: Range
System event:
ANONYMOUS_ACCESS: Anonymous access
ABNORMAL_UA_REQ: Abnormal UA request
ANONYMOUS_ABNORMAL_PERMISSION: Abnormal changes on permissions of an anonymous user
GET_CREDENTIALS: Credential information acquisition
MOUNT_SENSITIVE_PATH: Sensitive path mounting
COMMAND_RUN: Command execution
PRIVILEGE_CONTAINER: Privilege container
EXCEPTION_CRONTAB_TASK: Aabnormal scheduled task
STATICS_POD: Static pod creation
ABNORMAL_CREATE_POD: Abnormal pod creation
USER_DEFINED: User defined
        :type Scope: str
        :param Action: Action (RULE_MODE_ALERT: Alarm RULE_MODE_RELEASE: Release)
        :type Action: str
        :param RiskLevel: Threat level: "HIGH": High-risk level; "MIDDLE": Middle-risk level; "LOW": Low-risk level; "NOTICE": Notice level
Note: This field may return `null`, indicating that no valid value was found.
        :type RiskLevel: str
        :param Status: Switch status (true: On; false: Off): applicable to system rules.
Note: This field may return `null`, indicating that no valid value was found.
        :type Status: bool
        :param IsDelete: Whether to delete: applicable to custom rule input parameters.
Note: This field may return `null`, indicating that no valid value was found.
        :type IsDelete: bool
        """
        self.Scope = None
        self.Action = None
        self.RiskLevel = None
        self.Status = None
        self.IsDelete = None


    def _deserialize(self, params):
        self.Scope = params.get("Scope")
        self.Action = params.get("Action")
        self.RiskLevel = params.get("RiskLevel")
        self.Status = params.get("Status")
        self.IsDelete = params.get("IsDelete")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class K8sApiAbnormalTendencyItem(AbstractModel):
    """Items in the list of K8sApi abnormal request trends

    """

    def __init__(self):
        r"""
        :param Date: Date
        :type Date: str
        :param ExceptionUARequestCount: The number of abnormal UA request events
        :type ExceptionUARequestCount: int
        :param AnonymousUserRightCount: The number of anonymous user permission events
        :type AnonymousUserRightCount: int
        :param CredentialInformationObtainCount: The number of credential information acquisition events
        :type CredentialInformationObtainCount: int
        :param SensitiveDataMountCount: The number of sensitive data mounting events
        :type SensitiveDataMountCount: int
        :param CmdExecCount: The number of command execution events
        :type CmdExecCount: int
        :param AbnormalScheduledTaskCount: The number of abnormal scheduled task events
        :type AbnormalScheduledTaskCount: int
        :param StaticsPodCreateCount: The number of static pods created
        :type StaticsPodCreateCount: int
        :param DoubtfulContainerCreateCount: The number of suspicious containers created
        :type DoubtfulContainerCreateCount: int
        :param UserDefinedRuleCount: The number of custom rule events
        :type UserDefinedRuleCount: int
        :param AnonymousAccessCount: The number of anonymous access events
        :type AnonymousAccessCount: int
        :param PrivilegeContainerCount: The number of privilege container events
        :type PrivilegeContainerCount: int
        """
        self.Date = None
        self.ExceptionUARequestCount = None
        self.AnonymousUserRightCount = None
        self.CredentialInformationObtainCount = None
        self.SensitiveDataMountCount = None
        self.CmdExecCount = None
        self.AbnormalScheduledTaskCount = None
        self.StaticsPodCreateCount = None
        self.DoubtfulContainerCreateCount = None
        self.UserDefinedRuleCount = None
        self.AnonymousAccessCount = None
        self.PrivilegeContainerCount = None


    def _deserialize(self, params):
        self.Date = params.get("Date")
        self.ExceptionUARequestCount = params.get("ExceptionUARequestCount")
        self.AnonymousUserRightCount = params.get("AnonymousUserRightCount")
        self.CredentialInformationObtainCount = params.get("CredentialInformationObtainCount")
        self.SensitiveDataMountCount = params.get("SensitiveDataMountCount")
        self.CmdExecCount = params.get("CmdExecCount")
        self.AbnormalScheduledTaskCount = params.get("AbnormalScheduledTaskCount")
        self.StaticsPodCreateCount = params.get("StaticsPodCreateCount")
        self.DoubtfulContainerCreateCount = params.get("DoubtfulContainerCreateCount")
        self.UserDefinedRuleCount = params.get("UserDefinedRuleCount")
        self.AnonymousAccessCount = params.get("AnonymousAccessCount")
        self.PrivilegeContainerCount = params.get("PrivilegeContainerCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAbnormalProcessRuleStatusRequest(AbstractModel):
    """ModifyAbnormalProcessRuleStatus request structure.

    """

    def __init__(self):
        r"""
        :param RuleIdSet: Policy IDs
        :type RuleIdSet: list of str
        :param IsEnable: Policy switch. Valid values: `true` (on); `false` (off).
        :type IsEnable: bool
        """
        self.RuleIdSet = None
        self.IsEnable = None


    def _deserialize(self, params):
        self.RuleIdSet = params.get("RuleIdSet")
        self.IsEnable = params.get("IsEnable")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAbnormalProcessRuleStatusResponse(AbstractModel):
    """ModifyAbnormalProcessRuleStatus response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifyAbnormalProcessStatusRequest(AbstractModel):
    """ModifyAbnormalProcessStatus request structure.

    """

    def __init__(self):
        r"""
        :param EventIdSet: List of event IDs
        :type EventIdSet: list of str
        :param Status: Event status   
    `EVENT_DEALED`: Processed.
    `EVENT_INGNORE`: Ignored.
     `EVENT_DEL`: Deleted.
     `EVENT_ADD_WHITE`: Allowed.
        :type Status: str
        :param Remark: Event remarks
        :type Remark: str
        """
        self.EventIdSet = None
        self.Status = None
        self.Remark = None


    def _deserialize(self, params):
        self.EventIdSet = params.get("EventIdSet")
        self.Status = params.get("Status")
        self.Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAbnormalProcessStatusResponse(AbstractModel):
    """ModifyAbnormalProcessStatus response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifyAccessControlRuleStatusRequest(AbstractModel):
    """ModifyAccessControlRuleStatus request structure.

    """

    def __init__(self):
        r"""
        :param RuleIdSet: Policy IDs
        :type RuleIdSet: list of str
        :param IsEnable: Policy switch. Valid values: `true` (on); `false` (off).
        :type IsEnable: bool
        """
        self.RuleIdSet = None
        self.IsEnable = None


    def _deserialize(self, params):
        self.RuleIdSet = params.get("RuleIdSet")
        self.IsEnable = params.get("IsEnable")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAccessControlRuleStatusResponse(AbstractModel):
    """ModifyAccessControlRuleStatus response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifyAccessControlStatusRequest(AbstractModel):
    """ModifyAccessControlStatus request structure.

    """

    def __init__(self):
        r"""
        :param EventIdSet: List of event IDs
        :type EventIdSet: list of str
        :param Status: Event status     
`EVENT_DEALED`: Processed.
     `EVENT_INGNORE`: Ignored.
     `EVENT_DEL`: Deleted.
     `EVENT_ADD_WHITE`: Allowed.
        :type Status: str
        :param Remark: Remarks
        :type Remark: str
        """
        self.EventIdSet = None
        self.Status = None
        self.Remark = None


    def _deserialize(self, params):
        self.EventIdSet = params.get("EventIdSet")
        self.Status = params.get("Status")
        self.Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAccessControlStatusResponse(AbstractModel):
    """ModifyAccessControlStatus response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifyAssetImageRegistryScanStopOneKeyRequest(AbstractModel):
    """ModifyAssetImageRegistryScanStopOneKey request structure.

    """

    def __init__(self):
        r"""
        :param All: Whether to scan all images
        :type All: bool
        :param Images: List of scanned images
        :type Images: list of ImageInfo
        :param Id: List of IDs of scanned images
        :type Id: list of int non-negative
        """
        self.All = None
        self.Images = None
        self.Id = None


    def _deserialize(self, params):
        self.All = params.get("All")
        if params.get("Images") is not None:
            self.Images = []
            for item in params.get("Images"):
                obj = ImageInfo()
                obj._deserialize(item)
                self.Images.append(obj)
        self.Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAssetImageRegistryScanStopOneKeyResponse(AbstractModel):
    """ModifyAssetImageRegistryScanStopOneKey response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifyAssetImageRegistryScanStopRequest(AbstractModel):
    """ModifyAssetImageRegistryScanStop request structure.

    """

    def __init__(self):
        r"""
        :param All: Whether to scan all images
        :type All: bool
        :param Images: List of scanned images
        :type Images: list of ImageInfo
        :param Id: List of scanned images
        :type Id: list of int non-negative
        :param Filters: Filter
        :type Filters: list of AssetFilters
        :param ExcludeImageList: List of images not to be scanned, which is used together with `Filters`.
        :type ExcludeImageList: list of int non-negative
        :param OnlyScanLatest: Whether to scan only the latest repository images
        :type OnlyScanLatest: bool
        """
        self.All = None
        self.Images = None
        self.Id = None
        self.Filters = None
        self.ExcludeImageList = None
        self.OnlyScanLatest = None


    def _deserialize(self, params):
        self.All = params.get("All")
        if params.get("Images") is not None:
            self.Images = []
            for item in params.get("Images"):
                obj = ImageInfo()
                obj._deserialize(item)
                self.Images.append(obj)
        self.Id = params.get("Id")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.ExcludeImageList = params.get("ExcludeImageList")
        self.OnlyScanLatest = params.get("OnlyScanLatest")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAssetImageRegistryScanStopResponse(AbstractModel):
    """ModifyAssetImageRegistryScanStop response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifyAssetImageScanStopRequest(AbstractModel):
    """ModifyAssetImageScanStop request structure.

    """

    def __init__(self):
        r"""
        :param TaskID: Task ID
        :type TaskID: str
        :param Images: Image ID
        :type Images: list of str
        :param Filters: Filter
        :type Filters: list of AssetFilters
        :param ExcludeImageIds: Specified image IDs to be excluded
        :type ExcludeImageIds: str
        """
        self.TaskID = None
        self.Images = None
        self.Filters = None
        self.ExcludeImageIds = None


    def _deserialize(self, params):
        self.TaskID = params.get("TaskID")
        self.Images = params.get("Images")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.ExcludeImageIds = params.get("ExcludeImageIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAssetImageScanStopResponse(AbstractModel):
    """ModifyAssetImageScanStop response structure.

    """

    def __init__(self):
        r"""
        :param Status: Paused
        :type Status: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.Status = None
        self.RequestId = None


    def _deserialize(self, params):
        self.Status = params.get("Status")
        self.RequestId = params.get("RequestId")


class ModifyAssetRequest(AbstractModel):
    """ModifyAsset request structure.

    """

    def __init__(self):
        r"""
        :param All: Sync all
        :type All: bool
        :param Hosts: List of servers to be synced. Either this parameter or `All` (preferred) must be selected.
        :type Hosts: list of str
        """
        self.All = None
        self.Hosts = None


    def _deserialize(self, params):
        self.All = params.get("All")
        self.Hosts = params.get("Hosts")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAssetResponse(AbstractModel):
    """ModifyAsset response structure.

    """

    def __init__(self):
        r"""
        :param Status: Sending result of the sync task
        :type Status: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.Status = None
        self.RequestId = None


    def _deserialize(self, params):
        self.Status = params.get("Status")
        self.RequestId = params.get("RequestId")


class ModifyCompliancePeriodTaskRequest(AbstractModel):
    """ModifyCompliancePeriodTask request structure.

    """

    def __init__(self):
        r"""
        :param PeriodTaskId: ID of the scheduled task to be modified, which is returned by the `DescribeCompliancePeriodTaskList` API.
        :type PeriodTaskId: int
        :param PeriodRule: Cycle rule of the scheduled task, which indicates no modification if the field is not specified.
        :type PeriodRule: :class:`tencentcloud.tcss.v20201101.models.CompliancePeriodTaskRule`
        :param StandardSettings: Compliance standard, which indicates no modification if the field is not specified.
        :type StandardSettings: list of ComplianceBenchmarkStandardEnable
        """
        self.PeriodTaskId = None
        self.PeriodRule = None
        self.StandardSettings = None


    def _deserialize(self, params):
        self.PeriodTaskId = params.get("PeriodTaskId")
        if params.get("PeriodRule") is not None:
            self.PeriodRule = CompliancePeriodTaskRule()
            self.PeriodRule._deserialize(params.get("PeriodRule"))
        if params.get("StandardSettings") is not None:
            self.StandardSettings = []
            for item in params.get("StandardSettings"):
                obj = ComplianceBenchmarkStandardEnable()
                obj._deserialize(item)
                self.StandardSettings.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyCompliancePeriodTaskResponse(AbstractModel):
    """ModifyCompliancePeriodTask response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifyContainerNetStatusRequest(AbstractModel):
    """ModifyContainerNetStatus request structure.

    """

    def __init__(self):
        r"""
        :param ContainerID: Container ID
        :type ContainerID: str
        :param Status: Status
`EVENT_ISOLATE_CONTAINER`: Isolate the container.
`EVENT_RESOTRE_CONTAINER`: Recover the container.
)
        :type Status: str
        """
        self.ContainerID = None
        self.Status = None


    def _deserialize(self, params):
        self.ContainerID = params.get("ContainerID")
        self.Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyContainerNetStatusResponse(AbstractModel):
    """ModifyContainerNetStatus response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifyEscapeEventStatusRequest(AbstractModel):
    """ModifyEscapeEventStatus request structure.

    """

    def __init__(self):
        r"""
        :param EventIdSet: List of event IDs
        :type EventIdSet: list of str
        :param Status: Event status:
`EVENT_UNDEAL`: Pending (Unignored).
`EVENT_DEALED`: Processed.
`EVENT_IGNORE`: Ignored.
`EVENT_DELETE`: Deleted.
`EVENT_ADD_WHITE`: Allowed.
        :type Status: str
        :param Remark: Remarks
        :type Remark: str
        :param ImageIDs: Array of allowed image IDs
        :type ImageIDs: list of str
        :param EventType: Allowed event type
   `ESCAPE_CGROUPS`: Cgroup escape.
   `ESCAPE_TAMPER_SENSITIVE_FILE`: File tamper escape.
   `ESCAPE_DOCKER_API`: Docker API access escape.
   `ESCAPE_VUL_OCCURRED`: Vulnerability exploit.
   `MOUNT_SENSITIVE_PTAH`: Sensitive path mount.
   `PRIVILEGE_CONTAINER_START`: Privileged container.
   `PRIVILEGE`: Program privilege escalation escape.
        :type EventType: list of str
        """
        self.EventIdSet = None
        self.Status = None
        self.Remark = None
        self.ImageIDs = None
        self.EventType = None


    def _deserialize(self, params):
        self.EventIdSet = params.get("EventIdSet")
        self.Status = params.get("Status")
        self.Remark = params.get("Remark")
        self.ImageIDs = params.get("ImageIDs")
        self.EventType = params.get("EventType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyEscapeEventStatusResponse(AbstractModel):
    """ModifyEscapeEventStatus response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifyEscapeRuleRequest(AbstractModel):
    """ModifyEscapeRule request structure.

    """

    def __init__(self):
        r"""
        :param RuleSet: Array to be modified
        :type RuleSet: list of EscapeRuleEnabled
        """
        self.RuleSet = None


    def _deserialize(self, params):
        if params.get("RuleSet") is not None:
            self.RuleSet = []
            for item in params.get("RuleSet"):
                obj = EscapeRuleEnabled()
                obj._deserialize(item)
                self.RuleSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyEscapeRuleResponse(AbstractModel):
    """ModifyEscapeRule response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifyEscapeWhiteListRequest(AbstractModel):
    """ModifyEscapeWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param EventType: Allowed event type
   `ESCAPE_CGROUPS`: Cgroup escape.
   `ESCAPE_TAMPER_SENSITIVE_FILE`: File tamper escape.
   `ESCAPE_DOCKER_API`: Docker API access escape.
   `ESCAPE_VUL_OCCURRED`: Vulnerability exploit.
   `MOUNT_SENSITIVE_PTAH`: Sensitive path mount.
   `PRIVILEGE_CONTAINER_START`: Privileged container.
   `PRIVILEGE`: Program privilege escalation escape.
        :type EventType: list of str
        :param IDSet: Allowed item ID
        :type IDSet: list of int
        """
        self.EventType = None
        self.IDSet = None


    def _deserialize(self, params):
        self.EventType = params.get("EventType")
        self.IDSet = params.get("IDSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyEscapeWhiteListResponse(AbstractModel):
    """ModifyEscapeWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifyIgnoreVul(AbstractModel):
    """Input parameters for adding and unignoring vulnerabilities in the scan

    """

    def __init__(self):
        r"""
        :param PocID: POC ID
        :type PocID: str
        :param ImageIDs: IDs of images to be ignored. If it is not specified, it indicates to ignore all.
        :type ImageIDs: list of str
        :param ImageType: When there is an image
Image type. Valid values: `LOCAL` (local image); `REGISTRY` (repository image).
        :type ImageType: str
        """
        self.PocID = None
        self.ImageIDs = None
        self.ImageType = None


    def _deserialize(self, params):
        self.PocID = params.get("PocID")
        self.ImageIDs = params.get("ImageIDs")
        self.ImageType = params.get("ImageType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyImageAuthorizedRequest(AbstractModel):
    """ModifyImageAuthorized request structure.

    """

    def __init__(self):
        r"""
        :param AllLocalImages: Whether to license all local images, which has a higher priority than licensing by local image ID. When it is `true`, `UpdatedLocalImageCnt` should be greater than `0`.
        :type AllLocalImages: bool
        :param AllRegistryImages: Whether to license all repository images, with a higher priority than licensing by image ID. When it is `true`, `UpdatedRegistryImageCnt` should be greater than `0`.
        :type AllRegistryImages: bool
        :param UpdatedLocalImageCnt: Specified number of local images to be licensed, with the highest priority. Any difference between this number and the actual number will be randomly ignored.
        :type UpdatedLocalImageCnt: int
        :param UpdatedRegistryImageCnt: Specified number of repository images to be licensed, with the highest priority. Any difference between this number and the actual number will be randomly ignored.
        :type UpdatedRegistryImageCnt: int
        :param ImageSourceType: Licensing by eligible local images. Valid values of local image source: `ASSETIMAGE` (local image list); `IMAGEALL` (local image sync). This parameter is required when `AllLocalImages` is `false`, `LocalImageIds` is empty, and `UpdatedLocalImageCnt` is greater than `0`.
        :type ImageSourceType: str
        :param LocalImageFilter: Licensing by eligible local images. This parameter is required when `AllLocalImages` is `false`, `LocalImageIds` is empty, and `UpdatedLocalImageCnt` is greater than `0`.
        :type LocalImageFilter: list of AssetFilters
        :param RegistryImageFilter: Licensing by eligible repository images. This parameter is required when `AllRegistryImages` is `false`, `RegistryImageIds` is empty, and `UpdatedRegistryImageCnt` is greater than `0`.
        :type RegistryImageFilter: list of AssetFilters
        :param ExcludeLocalImageIds: Licensing by eligible images, excluding specified local image IDs
        :type ExcludeLocalImageIds: list of str
        :param ExcludeRegistryImageIds: Licensing by eligible images, excluding specified repository image IDs
        :type ExcludeRegistryImageIds: list of str
        :param LocalImageIds: Licensing by local image ID. This parameter has a higher priority than licensing by eligible images. It is required when `AllLocalImages` is `false`, `LocalImageFilter` is empty, and `UpdatedLocalImageCnt` is greater than `0`.
        :type LocalImageIds: list of str
        :param RegistryImageIds: Licensing by repository image ID. This parameter has a higher priority than licensing by eligible images. It is required when `AllRegistryImages` is `false`, `RegistryImageFilter` is empty, and `UpdatedRegistryImageCnt` is greater than `0`.
        :type RegistryImageIds: list of str
        :param OnlyShowLatest: Whether to only include latest images. This parameter is required for repository images when `RegistryImageFilter` is not empty and `UpdatedRegistryImageCnt` is greater than `0`.
        :type OnlyShowLatest: bool
        """
        self.AllLocalImages = None
        self.AllRegistryImages = None
        self.UpdatedLocalImageCnt = None
        self.UpdatedRegistryImageCnt = None
        self.ImageSourceType = None
        self.LocalImageFilter = None
        self.RegistryImageFilter = None
        self.ExcludeLocalImageIds = None
        self.ExcludeRegistryImageIds = None
        self.LocalImageIds = None
        self.RegistryImageIds = None
        self.OnlyShowLatest = None


    def _deserialize(self, params):
        self.AllLocalImages = params.get("AllLocalImages")
        self.AllRegistryImages = params.get("AllRegistryImages")
        self.UpdatedLocalImageCnt = params.get("UpdatedLocalImageCnt")
        self.UpdatedRegistryImageCnt = params.get("UpdatedRegistryImageCnt")
        self.ImageSourceType = params.get("ImageSourceType")
        if params.get("LocalImageFilter") is not None:
            self.LocalImageFilter = []
            for item in params.get("LocalImageFilter"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.LocalImageFilter.append(obj)
        if params.get("RegistryImageFilter") is not None:
            self.RegistryImageFilter = []
            for item in params.get("RegistryImageFilter"):
                obj = AssetFilters()
                obj._deserialize(item)
                self.RegistryImageFilter.append(obj)
        self.ExcludeLocalImageIds = params.get("ExcludeLocalImageIds")
        self.ExcludeRegistryImageIds = params.get("ExcludeRegistryImageIds")
        self.LocalImageIds = params.get("LocalImageIds")
        self.RegistryImageIds = params.get("RegistryImageIds")
        self.OnlyShowLatest = params.get("OnlyShowLatest")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyImageAuthorizedResponse(AbstractModel):
    """ModifyImageAuthorized response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifyK8sApiAbnormalEventStatusRequest(AbstractModel):
    """ModifyK8sApiAbnormalEventStatus request structure.

    """

    def __init__(self):
        r"""
        :param EventIDSet: Event ID set
        :type EventIDSet: list of int non-negative
        :param Status: Status
        :type Status: str
        :param Remark: Remarks
        :type Remark: str
        """
        self.EventIDSet = None
        self.Status = None
        self.Remark = None


    def _deserialize(self, params):
        self.EventIDSet = params.get("EventIDSet")
        self.Status = params.get("Status")
        self.Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyK8sApiAbnormalEventStatusResponse(AbstractModel):
    """ModifyK8sApiAbnormalEventStatus response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifyK8sApiAbnormalRuleInfoRequest(AbstractModel):
    """ModifyK8sApiAbnormalRuleInfo request structure.

    """

    def __init__(self):
        r"""
        :param RuleInfo: Rule details
        :type RuleInfo: :class:`tencentcloud.tcss.v20201101.models.K8sApiAbnormalRuleInfo`
        """
        self.RuleInfo = None


    def _deserialize(self, params):
        if params.get("RuleInfo") is not None:
            self.RuleInfo = K8sApiAbnormalRuleInfo()
            self.RuleInfo._deserialize(params.get("RuleInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyK8sApiAbnormalRuleInfoResponse(AbstractModel):
    """ModifyK8sApiAbnormalRuleInfo response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifyK8sApiAbnormalRuleStatusRequest(AbstractModel):
    """ModifyK8sApiAbnormalRuleStatus request structure.

    """

    def __init__(self):
        r"""
        :param RuleID: Rule ID
        :type RuleID: str
        :param Status: Status of the rule. Values: `true` (Enabled), `false` (Disabled)
        :type Status: bool
        """
        self.RuleID = None
        self.Status = None


    def _deserialize(self, params):
        self.RuleID = params.get("RuleID")
        self.Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyK8sApiAbnormalRuleStatusResponse(AbstractModel):
    """ModifyK8sApiAbnormalRuleStatus response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifyReverseShellStatusRequest(AbstractModel):
    """ModifyReverseShellStatus request structure.

    """

    def __init__(self):
        r"""
        :param EventIdSet: List of event IDs
        :type EventIdSet: list of str
        :param Status: Event status   
    `EVENT_DEALED`: Processed.
    `EVENT_INGNORE`: Ignored.
     `EVENT_DEL`: Deleted.
     `EVENT_ADD_WHITE`: Allowed.
        :type Status: str
        :param Remark: Event remarks
        :type Remark: str
        """
        self.EventIdSet = None
        self.Status = None
        self.Remark = None


    def _deserialize(self, params):
        self.EventIdSet = params.get("EventIdSet")
        self.Status = params.get("Status")
        self.Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyReverseShellStatusResponse(AbstractModel):
    """ModifyReverseShellStatus response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifyRiskSyscallStatusRequest(AbstractModel):
    """ModifyRiskSyscallStatus request structure.

    """

    def __init__(self):
        r"""
        :param EventIdSet: List of event IDs
        :type EventIdSet: list of str
        :param Status: Event status   
    `EVENT_DEALED`: Processed.
    `EVENT_INGNORE`: Ignored.
     `EVENT_DEL`: Deleted.
     `EVENT_ADD_WHITE`: Allowed.
        :type Status: str
        :param Remark: Event remarks
        :type Remark: str
        """
        self.EventIdSet = None
        self.Status = None
        self.Remark = None


    def _deserialize(self, params):
        self.EventIdSet = params.get("EventIdSet")
        self.Status = params.get("Status")
        self.Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyRiskSyscallStatusResponse(AbstractModel):
    """ModifyRiskSyscallStatus response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifySecLogCleanSettingInfoRequest(AbstractModel):
    """ModifySecLogCleanSettingInfo request structure.

    """

    def __init__(self):
        r"""
        :param ReservesLimit: Minimum storage (50-99) for triggering clearing
        :type ReservesLimit: int
        :param ReservesDeadline: Storage limit (greater than 0 and smaller than `ReservesLimit`) for stopping clearing
        :type ReservesDeadline: int
        :param DayLimit: Storage period (no less than one day) for triggering clearing
        :type DayLimit: int
        """
        self.ReservesLimit = None
        self.ReservesDeadline = None
        self.DayLimit = None


    def _deserialize(self, params):
        self.ReservesLimit = params.get("ReservesLimit")
        self.ReservesDeadline = params.get("ReservesDeadline")
        self.DayLimit = params.get("DayLimit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifySecLogCleanSettingInfoResponse(AbstractModel):
    """ModifySecLogCleanSettingInfo response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifySecLogDeliveryClsSettingRequest(AbstractModel):
    """ModifySecLogDeliveryClsSetting request structure.

    """

    def __init__(self):
        r"""
        :param List: Log information
        :type List: list of SecLogDeliveryClsSettingInfo
        """
        self.List = None


    def _deserialize(self, params):
        if params.get("List") is not None:
            self.List = []
            for item in params.get("List"):
                obj = SecLogDeliveryClsSettingInfo()
                obj._deserialize(item)
                self.List.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifySecLogDeliveryClsSettingResponse(AbstractModel):
    """ModifySecLogDeliveryClsSetting response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifySecLogDeliveryKafkaSettingRequest(AbstractModel):
    """ModifySecLogDeliveryKafkaSetting request structure.

    """

    def __init__(self):
        r"""
        :param InstanceID: Instance ID
        :type InstanceID: str
        :param InstanceName: Instance name
        :type InstanceName: str
        :param Domain: Domain
        :type Domain: str
        :param User: Username
        :type User: str
        :param Password: Password
        :type Password: str
        :param LogTypeList: List of log types
        :type LogTypeList: list of SecLogDeliveryKafkaSettingInfo
        :param AccessType: Access type
        :type AccessType: int
        :param KafkaVersion: Kafka version number
        :type KafkaVersion: str
        :param RegionID: Region ID
        :type RegionID: str
        """
        self.InstanceID = None
        self.InstanceName = None
        self.Domain = None
        self.User = None
        self.Password = None
        self.LogTypeList = None
        self.AccessType = None
        self.KafkaVersion = None
        self.RegionID = None


    def _deserialize(self, params):
        self.InstanceID = params.get("InstanceID")
        self.InstanceName = params.get("InstanceName")
        self.Domain = params.get("Domain")
        self.User = params.get("User")
        self.Password = params.get("Password")
        if params.get("LogTypeList") is not None:
            self.LogTypeList = []
            for item in params.get("LogTypeList"):
                obj = SecLogDeliveryKafkaSettingInfo()
                obj._deserialize(item)
                self.LogTypeList.append(obj)
        self.AccessType = params.get("AccessType")
        self.KafkaVersion = params.get("KafkaVersion")
        self.RegionID = params.get("RegionID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifySecLogDeliveryKafkaSettingResponse(AbstractModel):
    """ModifySecLogDeliveryKafkaSetting response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifySecLogJoinObjectsRequest(AbstractModel):
    """ModifySecLogJoinObjects request structure.

    """

    def __init__(self):
        r"""
        :param LogType: Log type
Container bash: container_bash
Container startup: container_launch
K8s API: k8s_api
        :type LogType: str
        :param BindList: List of QUuids of bound servers
        :type BindList: list of str
        :param UnBindList: List of QUuids of servers to be unbound
        :type UnBindList: list of str
        """
        self.LogType = None
        self.BindList = None
        self.UnBindList = None


    def _deserialize(self, params):
        self.LogType = params.get("LogType")
        self.BindList = params.get("BindList")
        self.UnBindList = params.get("UnBindList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifySecLogJoinObjectsResponse(AbstractModel):
    """ModifySecLogJoinObjects response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifySecLogJoinStateRequest(AbstractModel):
    """ModifySecLogJoinState request structure.

    """

    def __init__(self):
        r"""
        :param LogType: Log type
Container bash: container_bash
Container startup: container_launch
K8s API: k8s_api
        :type LogType: str
        :param State: Status. Valid values: `true` (enabled); `false` (disabled).
        :type State: bool
        """
        self.LogType = None
        self.State = None


    def _deserialize(self, params):
        self.LogType = params.get("LogType")
        self.State = params.get("State")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifySecLogJoinStateResponse(AbstractModel):
    """ModifySecLogJoinState response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifySecLogKafkaUINRequest(AbstractModel):
    """ModifySecLogKafkaUIN request structure.

    """

    def __init__(self):
        r"""
        :param DstUIN: Target UIN
        :type DstUIN: str
        """
        self.DstUIN = None


    def _deserialize(self, params):
        self.DstUIN = params.get("DstUIN")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifySecLogKafkaUINResponse(AbstractModel):
    """ModifySecLogKafkaUIN response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifyVirusAutoIsolateExampleSwitchRequest(AbstractModel):
    """ModifyVirusAutoIsolateExampleSwitch request structure.

    """

    def __init__(self):
        r"""
        :param MD5: MD5 checksum of the file
        :type MD5: str
        :param Status: Switch. Valid values: `true` (on); `false` (off).
        :type Status: bool
        """
        self.MD5 = None
        self.Status = None


    def _deserialize(self, params):
        self.MD5 = params.get("MD5")
        self.Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyVirusAutoIsolateExampleSwitchResponse(AbstractModel):
    """ModifyVirusAutoIsolateExampleSwitch response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifyVirusAutoIsolateSettingRequest(AbstractModel):
    """ModifyVirusAutoIsolateSetting request structure.

    """

    def __init__(self):
        r"""
        :param AutoIsolateSwitch: Automatic isolation switch. Valid values: `true` (on); `false` (off).
        :type AutoIsolateSwitch: bool
        :param IsKillProgress: Whether to interrupt the process associated with the isolated file. Valid values: `true` (yes); `false` (no).
        :type IsKillProgress: bool
        """
        self.AutoIsolateSwitch = None
        self.IsKillProgress = None


    def _deserialize(self, params):
        self.AutoIsolateSwitch = params.get("AutoIsolateSwitch")
        self.IsKillProgress = params.get("IsKillProgress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyVirusAutoIsolateSettingResponse(AbstractModel):
    """ModifyVirusAutoIsolateSetting response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifyVirusFileStatusRequest(AbstractModel):
    """ModifyVirusFileStatus request structure.

    """

    def __init__(self):
        r"""
        :param EventIdSet: IDs of events
        :type EventIdSet: list of str
        :param Status: Event status   
    `EVENT_DEALED`: Processed.
    `EVENT_INGNORE`: Ignored.
    `EVENT_DEL`: Deleted.
    `EVENT_ADD_WHITE`: Allowed.
    `EVENT_PENDING`: Pending.
	`EVENT_ISOLATE_CONTAINER`: Container isolated.
	`EVENT_RESOTRE_CONTAINER`: Container recovered.
        :type Status: str
        :param Remark: Event remarks
        :type Remark: str
        :param AutoIsolate: Whether to automatically isolate files with the same MD5 checksum
        :type AutoIsolate: bool
        """
        self.EventIdSet = None
        self.Status = None
        self.Remark = None
        self.AutoIsolate = None


    def _deserialize(self, params):
        self.EventIdSet = params.get("EventIdSet")
        self.Status = params.get("Status")
        self.Remark = params.get("Remark")
        self.AutoIsolate = params.get("AutoIsolate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyVirusFileStatusResponse(AbstractModel):
    """ModifyVirusFileStatus response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifyVirusMonitorSettingRequest(AbstractModel):
    """ModifyVirusMonitorSetting request structure.

    """

    def __init__(self):
        r"""
        :param EnableScan: Whether to enable scheduled scan
        :type EnableScan: bool
        :param ScanPathAll: Scan all paths
        :type ScanPathAll: bool
        :param ScanPathType: Valid when `ScanPathAll` is `true`. Valid values of `ScanPathAll`: `0` (scan the following paths); `1` (scan all paths except the following; the scope cannot be greater than `1`).
        :type ScanPathType: int
        :param ScanPath: Specified path to be excluded or scanned
        :type ScanPath: list of str
        """
        self.EnableScan = None
        self.ScanPathAll = None
        self.ScanPathType = None
        self.ScanPath = None


    def _deserialize(self, params):
        self.EnableScan = params.get("EnableScan")
        self.ScanPathAll = params.get("ScanPathAll")
        self.ScanPathType = params.get("ScanPathType")
        self.ScanPath = params.get("ScanPath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyVirusMonitorSettingResponse(AbstractModel):
    """ModifyVirusMonitorSetting response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifyVirusScanSettingRequest(AbstractModel):
    """ModifyVirusScanSetting request structure.

    """

    def __init__(self):
        r"""
        :param EnableScan: Whether to enable scheduled scan
        :type EnableScan: bool
        :param Cycle: Check cycle in days. Valid values: `1`, `3`, `7`.
        :type Cycle: int
        :param BeginScanAt: Scan start time
        :type BeginScanAt: str
        :param ScanPathAll: Scan all paths. Valid values: `true` (all); `false` (specified).
        :type ScanPathAll: bool
        :param ScanPathType: Valid when `ScanPathAll` is `true`. Valid values of `ScanPathAll`: `0` (scan the following paths); `1` (scan all paths except the following).
        :type ScanPathType: int
        :param Timeout: Timeout period in hours. Value range: 5-24.
        :type Timeout: int
        :param ScanRangeType: Scanning scope. Valid values: `0` (container); `1` (server).
        :type ScanRangeType: int
        :param ScanRangeAll: Valid values: `true` (all); `false` (specified).
        :type ScanRangeAll: bool
        :param ScanIds: ID of the specified container or server to be scanned, which is based on `ScanRangeType`.
        :type ScanIds: list of str
        :param ScanPath: Scanned path
        :type ScanPath: list of str
        """
        self.EnableScan = None
        self.Cycle = None
        self.BeginScanAt = None
        self.ScanPathAll = None
        self.ScanPathType = None
        self.Timeout = None
        self.ScanRangeType = None
        self.ScanRangeAll = None
        self.ScanIds = None
        self.ScanPath = None


    def _deserialize(self, params):
        self.EnableScan = params.get("EnableScan")
        self.Cycle = params.get("Cycle")
        self.BeginScanAt = params.get("BeginScanAt")
        self.ScanPathAll = params.get("ScanPathAll")
        self.ScanPathType = params.get("ScanPathType")
        self.Timeout = params.get("Timeout")
        self.ScanRangeType = params.get("ScanRangeType")
        self.ScanRangeAll = params.get("ScanRangeAll")
        self.ScanIds = params.get("ScanIds")
        self.ScanPath = params.get("ScanPath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyVirusScanSettingResponse(AbstractModel):
    """ModifyVirusScanSetting response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifyVirusScanTimeoutSettingRequest(AbstractModel):
    """ModifyVirusScanTimeoutSetting request structure.

    """

    def __init__(self):
        r"""
        :param Timeout: Timeout period in hours. Value range: 5-24.
        :type Timeout: int
        :param ScanType: Scan type. Valid values: `0` (quick scan); `1` (scheduled scan).
        :type ScanType: int
        """
        self.Timeout = None
        self.ScanType = None


    def _deserialize(self, params):
        self.Timeout = params.get("Timeout")
        self.ScanType = params.get("ScanType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyVirusScanTimeoutSettingResponse(AbstractModel):
    """ModifyVirusScanTimeoutSetting response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifyVulDefenceEventStatusRequest(AbstractModel):
    """ModifyVulDefenceEventStatus request structure.

    """

    def __init__(self):
        r"""
        :param EventIDs: Array of event IDs
        :type EventIDs: list of int
        :param Status: Operation status:
Valid values: `EVENT_DEALED` (processed); `EVENT_IGNORE` (ignore); `EVENT_ISOLATE_CONTAINER` (isolate the container); `EVENT_DEL` (delete).
        :type Status: str
        :param Remark: Remarks
        :type Remark: str
        """
        self.EventIDs = None
        self.Status = None
        self.Remark = None


    def _deserialize(self, params):
        self.EventIDs = params.get("EventIDs")
        self.Status = params.get("Status")
        self.Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyVulDefenceEventStatusResponse(AbstractModel):
    """ModifyVulDefenceEventStatus response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifyVulDefenceSettingRequest(AbstractModel):
    """ModifyVulDefenceSetting request structure.

    """

    def __init__(self):
        r"""
        :param IsEnabled: Whether it is enabled. Valid values: `0` (disabled); `1` (enabled).
        :type IsEnabled: int
        :param Scope: Scope of servers for which to enable exploit prevention. Valid values: `0` (specified servers); `1` (all servers). This parameter is required when `IsEnabled` is `1`.
        :type Scope: int
        :param HostIDs: Specified servers for which to enable exploit prevention. This parameter is required when `Scope` is `0`.
        :type HostIDs: list of str
        """
        self.IsEnabled = None
        self.Scope = None
        self.HostIDs = None


    def _deserialize(self, params):
        self.IsEnabled = params.get("IsEnabled")
        self.Scope = params.get("Scope")
        self.HostIDs = params.get("HostIDs")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyVulDefenceSettingResponse(AbstractModel):
    """ModifyVulDefenceSetting response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class NetworkAuditRecord(AbstractModel):
    """The structure returned by the audit of the network cluster asset

    """

    def __init__(self):
        r"""
        :param ClusterId: Cluster ID
        :type ClusterId: str
        :param ClusterName: Cluster name
        :type ClusterName: str
        :param Region: Cluster region
        :type Region: str
        :param Action: Action
        :type Action: str
        :param Operation: Operator
        :type Operation: str
        :param NetworkPolicyName: Policy name
        :type NetworkPolicyName: str
        :param OperationTime: Operation time
        :type OperationTime: str
        :param AppId: Operator `appid`
Note: This field may return null, indicating that no valid values can be obtained.
        :type AppId: int
        :param Uin: Operator UIN
        :type Uin: str
        """
        self.ClusterId = None
        self.ClusterName = None
        self.Region = None
        self.Action = None
        self.Operation = None
        self.NetworkPolicyName = None
        self.OperationTime = None
        self.AppId = None
        self.Uin = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        self.ClusterName = params.get("ClusterName")
        self.Region = params.get("Region")
        self.Action = params.get("Action")
        self.Operation = params.get("Operation")
        self.NetworkPolicyName = params.get("NetworkPolicyName")
        self.OperationTime = params.get("OperationTime")
        self.AppId = params.get("AppId")
        self.Uin = params.get("Uin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NetworkClusterInfoItem(AbstractModel):
    """Response parameters structure of the network cluster asset

    """

    def __init__(self):
        r"""
        :param ClusterId: Cluster ID
        :type ClusterId: str
        :param ClusterName: Cluster name
        :type ClusterName: str
        :param ClusterVersion: Cluster version
        :type ClusterVersion: str
        :param ClusterOs: Cluster OS
        :type ClusterOs: str
        :param ClusterType: Cluster type
        :type ClusterType: str
        :param Region: Cluster region
        :type Region: str
        :param NetworkPolicyPlugin: Cluster network plugin
        :type NetworkPolicyPlugin: str
        :param ClusterStatus: Cluster status
        :type ClusterStatus: str
        :param TotalRuleCount: Total number of policies
        :type TotalRuleCount: int
        :param EnableRuleCount: Number of enabled policies
        :type EnableRuleCount: int
        :param NetworkPolicyPluginStatus: Status of the cluster network plugin. Valid values: `Running` (normal); `Error` (abnormal).
        :type NetworkPolicyPluginStatus: str
        :param NetworkPolicyPluginError: Error message of the cluster network plugin
Note: This field may return null, indicating that no valid values can be obtained.
        :type NetworkPolicyPluginError: str
        """
        self.ClusterId = None
        self.ClusterName = None
        self.ClusterVersion = None
        self.ClusterOs = None
        self.ClusterType = None
        self.Region = None
        self.NetworkPolicyPlugin = None
        self.ClusterStatus = None
        self.TotalRuleCount = None
        self.EnableRuleCount = None
        self.NetworkPolicyPluginStatus = None
        self.NetworkPolicyPluginError = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        self.ClusterName = params.get("ClusterName")
        self.ClusterVersion = params.get("ClusterVersion")
        self.ClusterOs = params.get("ClusterOs")
        self.ClusterType = params.get("ClusterType")
        self.Region = params.get("Region")
        self.NetworkPolicyPlugin = params.get("NetworkPolicyPlugin")
        self.ClusterStatus = params.get("ClusterStatus")
        self.TotalRuleCount = params.get("TotalRuleCount")
        self.EnableRuleCount = params.get("EnableRuleCount")
        self.NetworkPolicyPluginStatus = params.get("NetworkPolicyPluginStatus")
        self.NetworkPolicyPluginError = params.get("NetworkPolicyPluginError")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NetworkClusterNamespaceLabelInfo(AbstractModel):
    """Response parameters structure of the network space label

    """

    def __init__(self):
        r"""
        :param Labels: Network space label
        :type Labels: str
        :param Name: Network space name
        :type Name: str
        """
        self.Labels = None
        self.Name = None


    def _deserialize(self, params):
        self.Labels = params.get("Labels")
        self.Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NetworkClusterPodInfo(AbstractModel):
    """Response parameters structure of the network cluster Pod

    """

    def __init__(self):
        r"""
        :param PodName: Pod name
        :type PodName: str
        :param Namespace: Pod space
Note: This field may return null, indicating that no valid values can be obtained.
        :type Namespace: str
        :param Labels: Pod label
Note: This field may return null, indicating that no valid values can be obtained.
        :type Labels: str
        :param WorkloadKind: Pod type
Note: This field may return null, indicating that no valid values can be obtained.
        :type WorkloadKind: str
        """
        self.PodName = None
        self.Namespace = None
        self.Labels = None
        self.WorkloadKind = None


    def _deserialize(self, params):
        self.PodName = params.get("PodName")
        self.Namespace = params.get("Namespace")
        self.Labels = params.get("Labels")
        self.WorkloadKind = params.get("WorkloadKind")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NetworkCustomPolicy(AbstractModel):
    """Custom rule of the network cluster policy

    """

    def __init__(self):
        r"""
        :param Direction: Network policy direction. Valid values: `FROM`, `TO`.
        :type Direction: str
        :param Ports: Network policy port
Note: This field may return null, indicating that no valid values can be obtained.
        :type Ports: list of NetworkPorts
        :param Peer: Network policy object

`PublishedNoConfirm`: Enabled and to be confirmed.

`PublishedConfirmed`: Enabled and confirmed.

`unPublishing`: Disabled.

`Publishing`: Enabled.

`unPublishEdit`: To be enabled.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Peer: list of NetworkPeer
        """
        self.Direction = None
        self.Ports = None
        self.Peer = None


    def _deserialize(self, params):
        self.Direction = params.get("Direction")
        if params.get("Ports") is not None:
            self.Ports = []
            for item in params.get("Ports"):
                obj = NetworkPorts()
                obj._deserialize(item)
                self.Ports.append(obj)
        if params.get("Peer") is not None:
            self.Peer = []
            for item in params.get("Peer"):
                obj = NetworkPeer()
                obj._deserialize(item)
                self.Peer.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NetworkPeer(AbstractModel):
    """Custom rule of the network cluster policy

    """

    def __init__(self):
        r"""
        :param PeerType: Object type:

Namespace: `NamespaceSelector`, which indicates that `NamespaceSelector` has a value.

Pod type: `PodSelector`, which indicates that both `NamespaceSelector` and `PodSelector` have values.

IP type: `IPBlock`, which indicates that only `IPBlock` has a value.
        :type PeerType: str
        :param NamespaceSelector: Namespace selector
Note: This field may return null, indicating that no valid values can be obtained.
        :type NamespaceSelector: str
        :param PodSelector: Pod selector
Note: This field may return null, indicating that no valid values can be obtained.
        :type PodSelector: str
        :param IPBlock: IP selector
Note: This field may return null, indicating that no valid values can be obtained.
        :type IPBlock: str
        """
        self.PeerType = None
        self.NamespaceSelector = None
        self.PodSelector = None
        self.IPBlock = None


    def _deserialize(self, params):
        self.PeerType = params.get("PeerType")
        self.NamespaceSelector = params.get("NamespaceSelector")
        self.PodSelector = params.get("PodSelector")
        self.IPBlock = params.get("IPBlock")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NetworkPolicyInfoItem(AbstractModel):
    """Response parameters structure of the network cluster policy

    """

    def __init__(self):
        r"""
        :param Name: Network policy name
        :type Name: str
        :param Description: Network policy description
Note: This field may return null, indicating that no valid values can be obtained.
        :type Description: str
        :param PublishStatus: Publishing status:

`PublishedNoConfirm`: Enabled and to be confirmed.

`PublishedConfirmed`: Enabled and confirmed.

`unPublishing`: Disabled.

`Publishing`: Enabled.

`unPublishEdit`: To be enabled.
        :type PublishStatus: str
        :param PolicySourceType: Policy type:

`System`: Synched from the cluster.

`Manual`: Added manually.
        :type PolicySourceType: str
        :param Namespace: Policy space
        :type Namespace: str
        :param PolicyCreateTime: Policy creation date
        :type PolicyCreateTime: str
        :param NetworkPolicyPlugin: Policy type

kube-router: KubeRouter

cilium: Cilium
        :type NetworkPolicyPlugin: str
        :param PublishResult: Policy publishing result
Note: This field may return null, indicating that no valid values can be obtained.
        :type PublishResult: str
        :param FromPolicyRule: Inbound rule

`1`: Allow all.

`2`: Reject all.

`3`: Custom.
        :type FromPolicyRule: int
        :param ToPolicyRule: Inbound rule

`1`: Allow all.

`2`: Reject all.

`3`: Custom.
        :type ToPolicyRule: int
        :param PodSelector: Object
Note: This field may return null, indicating that no valid values can be obtained.
        :type PodSelector: str
        :param Id: Network policy ID
        :type Id: int
        """
        self.Name = None
        self.Description = None
        self.PublishStatus = None
        self.PolicySourceType = None
        self.Namespace = None
        self.PolicyCreateTime = None
        self.NetworkPolicyPlugin = None
        self.PublishResult = None
        self.FromPolicyRule = None
        self.ToPolicyRule = None
        self.PodSelector = None
        self.Id = None


    def _deserialize(self, params):
        self.Name = params.get("Name")
        self.Description = params.get("Description")
        self.PublishStatus = params.get("PublishStatus")
        self.PolicySourceType = params.get("PolicySourceType")
        self.Namespace = params.get("Namespace")
        self.PolicyCreateTime = params.get("PolicyCreateTime")
        self.NetworkPolicyPlugin = params.get("NetworkPolicyPlugin")
        self.PublishResult = params.get("PublishResult")
        self.FromPolicyRule = params.get("FromPolicyRule")
        self.ToPolicyRule = params.get("ToPolicyRule")
        self.PodSelector = params.get("PodSelector")
        self.Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NetworkPorts(AbstractModel):
    """Port of the custom rule of the network cluster policy

    """

    def __init__(self):
        r"""
        :param Protocol: Protocol of the network policy
Note: This field may return null, indicating that no valid values can be obtained.
        :type Protocol: str
        :param Port: Port of the network policy
Note: This field may return null, indicating that no valid values can be obtained.
        :type Port: str
        """
        self.Protocol = None
        self.Port = None


    def _deserialize(self, params):
        self.Protocol = params.get("Protocol")
        self.Port = params.get("Port")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenTcssTrialRequest(AbstractModel):
    """OpenTcssTrial request structure.

    """


class OpenTcssTrialResponse(AbstractModel):
    """OpenTcssTrial response structure.

    """

    def __init__(self):
        r"""
        :param EndTime: End time of the trial
        :type EndTime: str
        :param StartTime: Start time of the trial
        :type StartTime: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.EndTime = None
        self.StartTime = None
        self.RequestId = None


    def _deserialize(self, params):
        self.EndTime = params.get("EndTime")
        self.StartTime = params.get("StartTime")
        self.RequestId = params.get("RequestId")


class PortInfo(AbstractModel):
    """List of ports

    """

    def __init__(self):
        r"""
        :param Type: Type
        :type Type: str
        :param PublicIP: Public IP
        :type PublicIP: str
        :param PublicPort: Server port
        :type PublicPort: int
        :param ContainerPort: Container port
        :type ContainerPort: int
        :param ContainerPID: Container PID
        :type ContainerPID: int
        :param ContainerName: Container name
        :type ContainerName: str
        :param HostID: Server ID
        :type HostID: str
        :param HostIP: Server IP
        :type HostIP: str
        :param ProcessName: Process name
        :type ProcessName: str
        :param ListenContainer: Monitored address in the container
        :type ListenContainer: str
        :param ListenHost: Monitored address outside the container
        :type ListenHost: str
        :param RunAs: Operating account
        :type RunAs: str
        :param HostName: Server name
        :type HostName: str
        :param PublicIp: Public IP
        :type PublicIp: str
        """
        self.Type = None
        self.PublicIP = None
        self.PublicPort = None
        self.ContainerPort = None
        self.ContainerPID = None
        self.ContainerName = None
        self.HostID = None
        self.HostIP = None
        self.ProcessName = None
        self.ListenContainer = None
        self.ListenHost = None
        self.RunAs = None
        self.HostName = None
        self.PublicIp = None


    def _deserialize(self, params):
        self.Type = params.get("Type")
        self.PublicIP = params.get("PublicIP")
        self.PublicPort = params.get("PublicPort")
        self.ContainerPort = params.get("ContainerPort")
        self.ContainerPID = params.get("ContainerPID")
        self.ContainerName = params.get("ContainerName")
        self.HostID = params.get("HostID")
        self.HostIP = params.get("HostIP")
        self.ProcessName = params.get("ProcessName")
        self.ListenContainer = params.get("ListenContainer")
        self.ListenHost = params.get("ListenHost")
        self.RunAs = params.get("RunAs")
        self.HostName = params.get("HostName")
        self.PublicIp = params.get("PublicIp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProcessBaseInfo(AbstractModel):
    """Runtime security - Basic process information

    """

    def __init__(self):
        r"""
        :param ProcessStartUser: Process initiator
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProcessStartUser: str
        :param ProcessUserGroup: Process user group
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProcessUserGroup: str
        :param ProcessPath: Process path
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProcessPath: str
        :param ProcessParam: Process command line parameter
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProcessParam: str
        """
        self.ProcessStartUser = None
        self.ProcessUserGroup = None
        self.ProcessPath = None
        self.ProcessParam = None


    def _deserialize(self, params):
        self.ProcessStartUser = params.get("ProcessStartUser")
        self.ProcessUserGroup = params.get("ProcessUserGroup")
        self.ProcessPath = params.get("ProcessPath")
        self.ProcessParam = params.get("ProcessParam")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProcessDetailBaseInfo(AbstractModel):
    """Runtime security details - Basic process information

    """

    def __init__(self):
        r"""
        :param ProcessName: Process name
        :type ProcessName: str
        :param ProcessId: Process PID
        :type ProcessId: int
        :param ProcessStartUser: Process initiator
        :type ProcessStartUser: str
        :param ProcessUserGroup: Process user group
        :type ProcessUserGroup: str
        :param ProcessPath: Process path
        :type ProcessPath: str
        :param ProcessParam: Process command line parameter
        :type ProcessParam: str
        """
        self.ProcessName = None
        self.ProcessId = None
        self.ProcessStartUser = None
        self.ProcessUserGroup = None
        self.ProcessPath = None
        self.ProcessParam = None


    def _deserialize(self, params):
        self.ProcessName = params.get("ProcessName")
        self.ProcessId = params.get("ProcessId")
        self.ProcessStartUser = params.get("ProcessStartUser")
        self.ProcessUserGroup = params.get("ProcessUserGroup")
        self.ProcessPath = params.get("ProcessPath")
        self.ProcessParam = params.get("ProcessParam")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProcessDetailInfo(AbstractModel):
    """Runtime security details - Process information

    """

    def __init__(self):
        r"""
        :param ProcessName: Process name
        :type ProcessName: str
        :param ProcessAuthority: Process permission
        :type ProcessAuthority: str
        :param ProcessId: Process PID
        :type ProcessId: int
        :param ProcessStartUser: Process initiator
        :type ProcessStartUser: str
        :param ProcessUserGroup: Process user group
        :type ProcessUserGroup: str
        :param ProcessPath: Process path
        :type ProcessPath: str
        :param ProcessTree: Process tree
        :type ProcessTree: str
        :param ProcessMd5: Process MD5
        :type ProcessMd5: str
        :param ProcessParam: Process command line parameter
        :type ProcessParam: str
        """
        self.ProcessName = None
        self.ProcessAuthority = None
        self.ProcessId = None
        self.ProcessStartUser = None
        self.ProcessUserGroup = None
        self.ProcessPath = None
        self.ProcessTree = None
        self.ProcessMd5 = None
        self.ProcessParam = None


    def _deserialize(self, params):
        self.ProcessName = params.get("ProcessName")
        self.ProcessAuthority = params.get("ProcessAuthority")
        self.ProcessId = params.get("ProcessId")
        self.ProcessStartUser = params.get("ProcessStartUser")
        self.ProcessUserGroup = params.get("ProcessUserGroup")
        self.ProcessPath = params.get("ProcessPath")
        self.ProcessTree = params.get("ProcessTree")
        self.ProcessMd5 = params.get("ProcessMd5")
        self.ProcessParam = params.get("ProcessParam")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProcessInfo(AbstractModel):
    """List of processes

    """

    def __init__(self):
        r"""
        :param StartTime: Process start time
        :type StartTime: str
        :param RunAs: Operator
        :type RunAs: str
        :param CmdLine: Command line parameter
        :type CmdLine: str
        :param Exe: Exe path
        :type Exe: str
        :param PID: Server PID
        :type PID: int
        :param ContainerPID: Container PID
        :type ContainerPID: int
        :param ContainerName: Container name
        :type ContainerName: str
        :param HostID: Server ID
        :type HostID: str
        :param HostIP: Server IP
        :type HostIP: str
        :param ProcessName: Process name
        :type ProcessName: str
        :param HostName: Server name
        :type HostName: str
        :param PublicIp: Public IP
        :type PublicIp: str
        """
        self.StartTime = None
        self.RunAs = None
        self.CmdLine = None
        self.Exe = None
        self.PID = None
        self.ContainerPID = None
        self.ContainerName = None
        self.HostID = None
        self.HostIP = None
        self.ProcessName = None
        self.HostName = None
        self.PublicIp = None


    def _deserialize(self, params):
        self.StartTime = params.get("StartTime")
        self.RunAs = params.get("RunAs")
        self.CmdLine = params.get("CmdLine")
        self.Exe = params.get("Exe")
        self.PID = params.get("PID")
        self.ContainerPID = params.get("ContainerPID")
        self.ContainerName = params.get("ContainerName")
        self.HostID = params.get("HostID")
        self.HostIP = params.get("HostIP")
        self.ProcessName = params.get("ProcessName")
        self.HostName = params.get("HostName")
        self.PublicIp = params.get("PublicIp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProjectInfo(AbstractModel):
    """The project to which the host belongs

    """

    def __init__(self):
        r"""
        :param ProjectName: Project name
        :type ProjectName: str
        :param ProjectID: Project ID
        :type ProjectID: int
        """
        self.ProjectName = None
        self.ProjectID = None


    def _deserialize(self, params):
        self.ProjectName = params.get("ProjectName")
        self.ProjectID = params.get("ProjectID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PromotionActivityContent(AbstractModel):
    """Promotion content

    """

    def __init__(self):
        r"""
        :param MonthNum: Number of months
        :type MonthNum: int
        :param CoresCountLimit: Minimum number of cores
        :type CoresCountLimit: int
        :param ProfessionalDiscount: Discount on the Pro Edition
        :type ProfessionalDiscount: int
        :param ImageAuthorizationNum: Number of free images
        :type ImageAuthorizationNum: int
        """
        self.MonthNum = None
        self.CoresCountLimit = None
        self.ProfessionalDiscount = None
        self.ImageAuthorizationNum = None


    def _deserialize(self, params):
        self.MonthNum = params.get("MonthNum")
        self.CoresCountLimit = params.get("CoresCountLimit")
        self.ProfessionalDiscount = params.get("ProfessionalDiscount")
        self.ImageAuthorizationNum = params.get("ImageAuthorizationNum")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RaspInfo(AbstractModel):
    """RASP information of vulnerability defense plugin

    """

    def __init__(self):
        r"""
        :param Name: RASP name
        :type Name: str
        :param Value: RASP description
        :type Value: str
        """
        self.Name = None
        self.Value = None


    def _deserialize(self, params):
        self.Name = params.get("Name")
        self.Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RegionInfo(AbstractModel):
    """Region information

    """

    def __init__(self):
        r"""
        :param Region: Region identifier
        :type Region: str
        :param RegionName: Region name
        :type RegionName: str
        """
        self.Region = None
        self.RegionName = None


    def _deserialize(self, params):
        self.Region = params.get("Region")
        self.RegionName = params.get("RegionName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RemoveAssetImageRegistryRegistryDetailRequest(AbstractModel):
    """RemoveAssetImageRegistryRegistryDetail request structure.

    """

    def __init__(self):
        r"""
        :param RegistryId: Unique repository ID
        :type RegistryId: int
        """
        self.RegistryId = None


    def _deserialize(self, params):
        self.RegistryId = params.get("RegistryId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RemoveAssetImageRegistryRegistryDetailResponse(AbstractModel):
    """RemoveAssetImageRegistryRegistryDetail response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class RenewImageAuthorizeStateRequest(AbstractModel):
    """RenewImageAuthorizeState request structure.

    """

    def __init__(self):
        r"""
        :param AllImages: Whether all images are unlicensed
        :type AllImages: bool
        :param ImageIds: Image IDs
        :type ImageIds: list of str
        """
        self.AllImages = None
        self.ImageIds = None


    def _deserialize(self, params):
        self.AllImages = params.get("AllImages")
        self.ImageIds = params.get("ImageIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RenewImageAuthorizeStateResponse(AbstractModel):
    """RenewImageAuthorizeState response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ResetSecLogTopicConfigRequest(AbstractModel):
    """ResetSecLogTopicConfig request structure.

    """

    def __init__(self):
        r"""
        :param ConfigType: Configuration type. Valid values: `ckafka`, `cls`.
        :type ConfigType: str
        :param LogType: Log type
        :type LogType: str
        """
        self.ConfigType = None
        self.LogType = None


    def _deserialize(self, params):
        self.ConfigType = params.get("ConfigType")
        self.LogType = params.get("LogType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResetSecLogTopicConfigResponse(AbstractModel):
    """ResetSecLogTopicConfig response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ReverseShellEventDescription(AbstractModel):
    """Description of the container reverse shell event at runtime

    """

    def __init__(self):
        r"""
        :param Description: Description
        :type Description: str
        :param Solution: Solution
        :type Solution: str
        :param Remark: Event remarks
Note: This field may return null, indicating that no valid values can be obtained.
        :type Remark: str
        :param DstAddress: Destination address
        :type DstAddress: str
        :param OperationTime: Last processing time of the event
Note: This field may return null, indicating that no valid values can be obtained.
        :type OperationTime: str
        """
        self.Description = None
        self.Solution = None
        self.Remark = None
        self.DstAddress = None
        self.OperationTime = None


    def _deserialize(self, params):
        self.Description = params.get("Description")
        self.Solution = params.get("Solution")
        self.Remark = params.get("Remark")
        self.DstAddress = params.get("DstAddress")
        self.OperationTime = params.get("OperationTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ReverseShellEventInfo(AbstractModel):
    """Container runtime security - Information of the reverse shell

    """

    def __init__(self):
        r"""
        :param ProcessName: Process name
        :type ProcessName: str
        :param ProcessPath: Process path
        :type ProcessPath: str
        :param ImageId: Image ID
        :type ImageId: str
        :param ContainerId: Container ID
        :type ContainerId: str
        :param ImageName: Image name
        :type ImageName: str
        :param ContainerName: Container name
        :type ContainerName: str
        :param FoundTime: Generation time
        :type FoundTime: str
        :param Solution: Event solution
        :type Solution: str
        :param Description: Event description
        :type Description: str
        :param Status: Status. `EVENT_UNDEAL`: Pending.
    `EVENT_DEALED`: Processed.
    `EVENT_INGNORE`: Ignored.
    `EVENT_ADD_WHITE`: Allowed.
        :type Status: str
        :param EventId: Event ID
        :type EventId: str
        :param Remark: Remarks
        :type Remark: str
        :param PProcessName: Parent process name
        :type PProcessName: str
        :param EventCount: Number of events
        :type EventCount: int
        :param LatestFoundTime: Last generation time
        :type LatestFoundTime: str
        :param DstAddress: Destination address
        :type DstAddress: str
        :param ContainerNetStatus: Network status
`NORMAL`: 	Not isolated.
`ISOLATED`: 		Isolated.
`ISOLATING`: 		Isolating.
`ISOLATE_FAILED`: 	Isolation failed.
`RESTORING`: Recovering.
`RESTORE_FAILED`: Recovery failed.
        :type ContainerNetStatus: str
        :param ContainerNetSubStatus: Sub-status of the container
"AGENT_OFFLINE"       // The agent is offline.
	"NODE_DESTROYED"      // The node is terminated.
	"CONTAINER_EXITED"    // The container exited.
	"CONTAINER_DESTROYED" // The container was terminated.
	"SHARED_HOST"         // The container shares the network with the server.
	"RESOURCE_LIMIT"      // The number of resources to be isolated exceeds the limit.
	"UNKNOW"              // The reason is unknown.
        :type ContainerNetSubStatus: str
        :param ContainerIsolateOperationSrc: Container isolation operation source
        :type ContainerIsolateOperationSrc: str
        :param ContainerStatus: Container status
`RUNNING`: Running.
`PAUSED`: Paused.
`STOPPED`: Stopped.
`CREATED`: Created.
`DESTROYED`: Terminated.
`RESTARTING`: Restarting.
`REMOVING`: Removing.
        :type ContainerStatus: str
        """
        self.ProcessName = None
        self.ProcessPath = None
        self.ImageId = None
        self.ContainerId = None
        self.ImageName = None
        self.ContainerName = None
        self.FoundTime = None
        self.Solution = None
        self.Description = None
        self.Status = None
        self.EventId = None
        self.Remark = None
        self.PProcessName = None
        self.EventCount = None
        self.LatestFoundTime = None
        self.DstAddress = None
        self.ContainerNetStatus = None
        self.ContainerNetSubStatus = None
        self.ContainerIsolateOperationSrc = None
        self.ContainerStatus = None


    def _deserialize(self, params):
        self.ProcessName = params.get("ProcessName")
        self.ProcessPath = params.get("ProcessPath")
        self.ImageId = params.get("ImageId")
        self.ContainerId = params.get("ContainerId")
        self.ImageName = params.get("ImageName")
        self.ContainerName = params.get("ContainerName")
        self.FoundTime = params.get("FoundTime")
        self.Solution = params.get("Solution")
        self.Description = params.get("Description")
        self.Status = params.get("Status")
        self.EventId = params.get("EventId")
        self.Remark = params.get("Remark")
        self.PProcessName = params.get("PProcessName")
        self.EventCount = params.get("EventCount")
        self.LatestFoundTime = params.get("LatestFoundTime")
        self.DstAddress = params.get("DstAddress")
        self.ContainerNetStatus = params.get("ContainerNetStatus")
        self.ContainerNetSubStatus = params.get("ContainerNetSubStatus")
        self.ContainerIsolateOperationSrc = params.get("ContainerIsolateOperationSrc")
        self.ContainerStatus = params.get("ContainerStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ReverseShellWhiteListBaseInfo(AbstractModel):
    """Information of an allowed reverse shell

    """

    def __init__(self):
        r"""
        :param Id: Allowed item ID
        :type Id: str
        :param ImageCount: Number of images
        :type ImageCount: int
        :param ProcessName: Connection process name
        :type ProcessName: str
        :param DstIp: Destination address IP
        :type DstIp: str
        :param CreateTime: Creation time
        :type CreateTime: str
        :param UpdateTime: Update time
        :type UpdateTime: str
        :param DstPort: Target port
        :type DstPort: str
        :param IsGlobal: Whether it is allowed globally. `true`: Yes.
        :type IsGlobal: bool
        :param ImageIds: Array of image IDs. An empty array indicates all.
        :type ImageIds: list of str
        """
        self.Id = None
        self.ImageCount = None
        self.ProcessName = None
        self.DstIp = None
        self.CreateTime = None
        self.UpdateTime = None
        self.DstPort = None
        self.IsGlobal = None
        self.ImageIds = None


    def _deserialize(self, params):
        self.Id = params.get("Id")
        self.ImageCount = params.get("ImageCount")
        self.ProcessName = params.get("ProcessName")
        self.DstIp = params.get("DstIp")
        self.CreateTime = params.get("CreateTime")
        self.UpdateTime = params.get("UpdateTime")
        self.DstPort = params.get("DstPort")
        self.IsGlobal = params.get("IsGlobal")
        self.ImageIds = params.get("ImageIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ReverseShellWhiteListInfo(AbstractModel):
    """Information of an allowed reverse shell

    """

    def __init__(self):
        r"""
        :param DstIp: Target IP
        :type DstIp: str
        :param DstPort: Target port
        :type DstPort: str
        :param ProcessName: Target process
        :type ProcessName: str
        :param ImageIds: Array of image IDs. An empty array indicates all.
        :type ImageIds: list of str
        :param Id: Allowed item ID, which is empty if the item is newly created.
        :type Id: str
        """
        self.DstIp = None
        self.DstPort = None
        self.ProcessName = None
        self.ImageIds = None
        self.Id = None


    def _deserialize(self, params):
        self.DstIp = params.get("DstIp")
        self.DstPort = params.get("DstPort")
        self.ProcessName = params.get("ProcessName")
        self.ImageIds = params.get("ImageIds")
        self.Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RiskSyscallEventDescription(AbstractModel):
    """Description of the high-risk container syscall event at runtime

    """

    def __init__(self):
        r"""
        :param Description: Description
        :type Description: str
        :param Solution: Solution
        :type Solution: str
        :param Remark: Event remarks
Note: This field may return null, indicating that no valid values can be obtained.
        :type Remark: str
        :param SyscallName: Syscall name
        :type SyscallName: str
        :param OperationTime: Last processing time of the event
Note: This field may return null, indicating that no valid values can be obtained.
        :type OperationTime: str
        """
        self.Description = None
        self.Solution = None
        self.Remark = None
        self.SyscallName = None
        self.OperationTime = None


    def _deserialize(self, params):
        self.Description = params.get("Description")
        self.Solution = params.get("Solution")
        self.Remark = params.get("Remark")
        self.SyscallName = params.get("SyscallName")
        self.OperationTime = params.get("OperationTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RiskSyscallEventInfo(AbstractModel):
    """Container runtime security - Information of the high-risk syscall

    """

    def __init__(self):
        r"""
        :param ProcessName: Process name
        :type ProcessName: str
        :param ProcessPath: Process path
        :type ProcessPath: str
        :param ImageId: Image ID
        :type ImageId: str
        :param ContainerId: Container ID
        :type ContainerId: str
        :param ImageName: Image name
        :type ImageName: str
        :param ContainerName: Container name
        :type ContainerName: str
        :param FoundTime: Generation time
        :type FoundTime: str
        :param Solution: Event solution
        :type Solution: str
        :param Description: Event description
        :type Description: str
        :param SyscallName: Syscall name
        :type SyscallName: str
        :param Status: Status. `EVENT_UNDEAL`: Pending.
    `EVENT_DEALED`: Processed.
    `EVENT_INGNORE`: Ignored.
    `EVENT_ADD_WHITE`: Allowed.
        :type Status: str
        :param EventId: Event ID
        :type EventId: str
        :param NodeName: Node name
        :type NodeName: str
        :param PodName: Pod (instance) name
        :type PodName: str
        :param Remark: Remarks
        :type Remark: str
        :param RuleExist: Whether the system monitoring rule name exists
        :type RuleExist: bool
        :param EventCount: Number of events
        :type EventCount: int
        :param LatestFoundTime: Last generation time
        :type LatestFoundTime: str
        :param ContainerNetStatus: Network status
`NORMAL`: 	Not isolated.
`ISOLATED`: 		Isolated.
`ISOLATING`: 		Isolating.
`ISOLATE_FAILED`: 	Isolation failed.
`RESTORING`: Recovering.
`RESTORE_FAILED`: Recovery failed.
        :type ContainerNetStatus: str
        :param ContainerNetSubStatus: Sub-status of the container
"AGENT_OFFLINE"       // The agent is offline.
"NODE_DESTROYED"      // The node is terminated.
"CONTAINER_EXITED"    // The container exited.
"CONTAINER_DESTROYED" // The container was terminated.
"SHARED_HOST"         // The container shares the network with the server.
"RESOURCE_LIMIT"      // The number of resources to be isolated exceeds the limit.
"UNKNOW"              // The reason is unknown.
        :type ContainerNetSubStatus: str
        :param ContainerIsolateOperationSrc: Container isolation operation source
        :type ContainerIsolateOperationSrc: str
        :param ContainerStatus: Container status
`RUNNING`: Running.
`PAUSED`: Paused.
`STOPPED`: Stopped.
`CREATED`: Created.
`DESTROYED`: Terminated.
`RESTARTING`: Restarting.
`REMOVING`: Removing.
        :type ContainerStatus: str
        """
        self.ProcessName = None
        self.ProcessPath = None
        self.ImageId = None
        self.ContainerId = None
        self.ImageName = None
        self.ContainerName = None
        self.FoundTime = None
        self.Solution = None
        self.Description = None
        self.SyscallName = None
        self.Status = None
        self.EventId = None
        self.NodeName = None
        self.PodName = None
        self.Remark = None
        self.RuleExist = None
        self.EventCount = None
        self.LatestFoundTime = None
        self.ContainerNetStatus = None
        self.ContainerNetSubStatus = None
        self.ContainerIsolateOperationSrc = None
        self.ContainerStatus = None


    def _deserialize(self, params):
        self.ProcessName = params.get("ProcessName")
        self.ProcessPath = params.get("ProcessPath")
        self.ImageId = params.get("ImageId")
        self.ContainerId = params.get("ContainerId")
        self.ImageName = params.get("ImageName")
        self.ContainerName = params.get("ContainerName")
        self.FoundTime = params.get("FoundTime")
        self.Solution = params.get("Solution")
        self.Description = params.get("Description")
        self.SyscallName = params.get("SyscallName")
        self.Status = params.get("Status")
        self.EventId = params.get("EventId")
        self.NodeName = params.get("NodeName")
        self.PodName = params.get("PodName")
        self.Remark = params.get("Remark")
        self.RuleExist = params.get("RuleExist")
        self.EventCount = params.get("EventCount")
        self.LatestFoundTime = params.get("LatestFoundTime")
        self.ContainerNetStatus = params.get("ContainerNetStatus")
        self.ContainerNetSubStatus = params.get("ContainerNetSubStatus")
        self.ContainerIsolateOperationSrc = params.get("ContainerIsolateOperationSrc")
        self.ContainerStatus = params.get("ContainerStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RiskSyscallWhiteListBaseInfo(AbstractModel):
    """Information of the allowlist of high-risk syscalls

    """

    def __init__(self):
        r"""
        :param Id: Allowed item ID
        :type Id: str
        :param ImageCount: Number of images
        :type ImageCount: int
        :param ProcessPath: Connection process path
        :type ProcessPath: str
        :param SyscallNames: List of syscall names
        :type SyscallNames: list of str
        :param CreateTime: Creation time
        :type CreateTime: str
        :param UpdateTime: Update time
        :type UpdateTime: str
        :param IsGlobal: Whether it is allowed globally. `true`: Yes.
        :type IsGlobal: bool
        :param ImageIds: Array of image IDs
        :type ImageIds: list of str
        """
        self.Id = None
        self.ImageCount = None
        self.ProcessPath = None
        self.SyscallNames = None
        self.CreateTime = None
        self.UpdateTime = None
        self.IsGlobal = None
        self.ImageIds = None


    def _deserialize(self, params):
        self.Id = params.get("Id")
        self.ImageCount = params.get("ImageCount")
        self.ProcessPath = params.get("ProcessPath")
        self.SyscallNames = params.get("SyscallNames")
        self.CreateTime = params.get("CreateTime")
        self.UpdateTime = params.get("UpdateTime")
        self.IsGlobal = params.get("IsGlobal")
        self.ImageIds = params.get("ImageIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RiskSyscallWhiteListInfo(AbstractModel):
    """Information of the allowlist of high-risk syscalls

    """

    def __init__(self):
        r"""
        :param ImageIds: Array of image IDs. An empty array indicates all.
        :type ImageIds: list of str
        :param SyscallNames: Syscall name. The `DescribeRiskSyscallNames` API can be called to get the list of enumerated values.
        :type SyscallNames: list of str
        :param ProcessPath: Target process
        :type ProcessPath: str
        :param Id: Allowed item ID, which is empty if the item is newly created.
        :type Id: str
        """
        self.ImageIds = None
        self.SyscallNames = None
        self.ProcessPath = None
        self.Id = None


    def _deserialize(self, params):
        self.ImageIds = params.get("ImageIds")
        self.SyscallNames = params.get("SyscallNames")
        self.ProcessPath = params.get("ProcessPath")
        self.Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleBaseInfo(AbstractModel):
    """Runtime security - Basic policy information

    """

    def __init__(self):
        r"""
        :param IsDefault: Valid values: `true` (default policy); `false` (custom policy).
        :type IsDefault: bool
        :param EffectImageCount: Number of associated images
        :type EffectImageCount: int
        :param RuleId: Policy ID
        :type RuleId: str
        :param UpdateTime: Policy update time, which can be empty.
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param RuleName: Policy name
        :type RuleName: str
        :param EditUserName: Name of the editing user
        :type EditUserName: str
        :param IsEnable: Valid values: `true` (enable the policy); `false` (disable the policy).
        :type IsEnable: bool
        """
        self.IsDefault = None
        self.EffectImageCount = None
        self.RuleId = None
        self.UpdateTime = None
        self.RuleName = None
        self.EditUserName = None
        self.IsEnable = None


    def _deserialize(self, params):
        self.IsDefault = params.get("IsDefault")
        self.EffectImageCount = params.get("EffectImageCount")
        self.RuleId = params.get("RuleId")
        self.UpdateTime = params.get("UpdateTime")
        self.RuleName = params.get("RuleName")
        self.EditUserName = params.get("EditUserName")
        self.IsEnable = params.get("IsEnable")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RunTimeEventBaseInfo(AbstractModel):
    """Runtime security - Basic event information

    """

    def __init__(self):
        r"""
        :param EventId: Unique event ID
        :type EventId: str
        :param FoundTime: Event discovery time
        :type FoundTime: str
        :param ContainerId: Container ID
        :type ContainerId: str
        :param ContainerName: Container name
        :type ContainerName: str
        :param ImageId: Image ID
        :type ImageId: str
        :param ImageName: Image name
        :type ImageName: str
        :param NodeName: Node name
        :type NodeName: str
        :param PodName: Pod name
        :type PodName: str
        :param Status: Status. `EVENT_UNDEAL`: Pending.
    `EVENT_DEALED`: Processed.
    `EVENT_INGNORE`: Ignored.
        :type Status: str
        :param EventName: Event name:
Host file access escape
Syscall escape
Mount namespace escape
Program privilege escalation escape
Privileged container startup escape
Sensitive path mount
Malicious process startup
File tampering
        :type EventName: str
        :param EventType: Event type
   `ESCAPE_HOST_ACESS_FILE`: Host file access escape.
   `ESCAPE_MOUNT_NAMESPACE`: Mount namespace escape.
   `ESCAPE_PRIVILEDGE`: Program privilege escalation escape.
   `ESCAPE_PRIVILEDGE_CONTAINER_START`: Privileged container startup escape.
   `ESCAPE_MOUNT_SENSITIVE_PTAH`: Sensitive path mount.
   `ESCAPE_SYSCALL`: Syscall escape.
        :type EventType: str
        :param EventCount: Number of events
        :type EventCount: int
        :param LatestFoundTime: Last generation time
        :type LatestFoundTime: str
        :param HostIP: Private IP
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostIP: str
        :param ClientIP: Public IP
Note: This field may return null, indicating that no valid values can be obtained.
        :type ClientIP: str
        :param ContainerNetStatus: Network status
`NORMAL`: 	Not isolated.
`ISOLATED`: 		Isolated.
`ISOLATING`: 		Isolating.
`ISOLATE_FAILED`: 	Isolation failed.
`RESTORING`: Recovering.
`RESTORE_FAILED`: Recovery failed.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ContainerNetStatus: str
        :param ContainerNetSubStatus: Sub-status of the container
"AGENT_OFFLINE"       // The agent is offline.
"NODE_DESTROYED"      // The node is terminated.
"CONTAINER_EXITED"    // The container exited.
"CONTAINER_DESTROYED" // The container was terminated.
"SHARED_HOST"         // The container shares the network with the server.
"RESOURCE_LIMIT"      // The number of resources to be isolated exceeds the limit.
"UNKNOW"              // The reason is unknown.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ContainerNetSubStatus: str
        :param ContainerIsolateOperationSrc: Container isolation operation source
Note: This field may return null, indicating that no valid values can be obtained.
        :type ContainerIsolateOperationSrc: str
        """
        self.EventId = None
        self.FoundTime = None
        self.ContainerId = None
        self.ContainerName = None
        self.ImageId = None
        self.ImageName = None
        self.NodeName = None
        self.PodName = None
        self.Status = None
        self.EventName = None
        self.EventType = None
        self.EventCount = None
        self.LatestFoundTime = None
        self.HostIP = None
        self.ClientIP = None
        self.ContainerNetStatus = None
        self.ContainerNetSubStatus = None
        self.ContainerIsolateOperationSrc = None


    def _deserialize(self, params):
        self.EventId = params.get("EventId")
        self.FoundTime = params.get("FoundTime")
        self.ContainerId = params.get("ContainerId")
        self.ContainerName = params.get("ContainerName")
        self.ImageId = params.get("ImageId")
        self.ImageName = params.get("ImageName")
        self.NodeName = params.get("NodeName")
        self.PodName = params.get("PodName")
        self.Status = params.get("Status")
        self.EventName = params.get("EventName")
        self.EventType = params.get("EventType")
        self.EventCount = params.get("EventCount")
        self.LatestFoundTime = params.get("LatestFoundTime")
        self.HostIP = params.get("HostIP")
        self.ClientIP = params.get("ClientIP")
        self.ContainerNetStatus = params.get("ContainerNetStatus")
        self.ContainerNetSubStatus = params.get("ContainerNetSubStatus")
        self.ContainerIsolateOperationSrc = params.get("ContainerIsolateOperationSrc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RunTimeFilters(AbstractModel):
    """TCSS
    Key-value pair filter for conditional filtering queries, such as filter ID, name, and status
    If more than one filter exists, the logical relationship between these filters is `AND`.
    If multiple values exist in one filter, the logical relationship between these values is `OR`.

    """

    def __init__(self):
        r"""
        :param Name: Filter name
        :type Name: str
        :param Values: One or more filter values
        :type Values: list of str
        :param ExactMatch: Whether to use fuzzy query
        :type ExactMatch: bool
        """
        self.Name = None
        self.Values = None
        self.ExactMatch = None


    def _deserialize(self, params):
        self.Name = params.get("Name")
        self.Values = params.get("Values")
        self.ExactMatch = params.get("ExactMatch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RunTimeRiskInfo(AbstractModel):
    """Runtime risk information

    """

    def __init__(self):
        r"""
        :param Cnt: Number
        :type Cnt: int
        :param Level: Risk level:
`CRITICAL`: Critical.
`HIGH`: High.
`MEDIUM`: Medium.
`LOW`: Low.
        :type Level: str
        """
        self.Cnt = None
        self.Level = None


    def _deserialize(self, params):
        self.Cnt = params.get("Cnt")
        self.Level = params.get("Level")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RunTimeTendencyInfo(AbstractModel):
    """Runtime trend information

    """

    def __init__(self):
        r"""
        :param CurTime: The time of the day
        :type CurTime: str
        :param Cnt: Current quantity
        :type Cnt: int
        """
        self.CurTime = None
        self.Cnt = None


    def _deserialize(self, params):
        self.CurTime = params.get("CurTime")
        self.Cnt = params.get("Cnt")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ScanComplianceAssetsByPolicyItemRequest(AbstractModel):
    """ScanComplianceAssetsByPolicyItem request structure.

    """

    def __init__(self):
        r"""
        :param CustomerPolicyItemId: ID of the specified check item
        :type CustomerPolicyItemId: int
        :param CustomerAssetIdSet: List of IDs of customer assets to be scanned again
        :type CustomerAssetIdSet: list of int non-negative
        """
        self.CustomerPolicyItemId = None
        self.CustomerAssetIdSet = None


    def _deserialize(self, params):
        self.CustomerPolicyItemId = params.get("CustomerPolicyItemId")
        self.CustomerAssetIdSet = params.get("CustomerAssetIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ScanComplianceAssetsByPolicyItemResponse(AbstractModel):
    """ScanComplianceAssetsByPolicyItem response structure.

    """

    def __init__(self):
        r"""
        :param TaskId: ID of another check task
        :type TaskId: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class ScanComplianceAssetsRequest(AbstractModel):
    """ScanComplianceAssets request structure.

    """

    def __init__(self):
        r"""
        :param CustomerAssetIdSet: List of IDs of customer assets to be scanned again
        :type CustomerAssetIdSet: list of int non-negative
        """
        self.CustomerAssetIdSet = None


    def _deserialize(self, params):
        self.CustomerAssetIdSet = params.get("CustomerAssetIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ScanComplianceAssetsResponse(AbstractModel):
    """ScanComplianceAssets response structure.

    """

    def __init__(self):
        r"""
        :param TaskId: ID of another check task
        :type TaskId: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class ScanCompliancePolicyItemsRequest(AbstractModel):
    """ScanCompliancePolicyItems request structure.

    """

    def __init__(self):
        r"""
        :param CustomerPolicyItemIdSet: List of customer check items to be scanned again
        :type CustomerPolicyItemIdSet: list of int non-negative
        """
        self.CustomerPolicyItemIdSet = None


    def _deserialize(self, params):
        self.CustomerPolicyItemIdSet = params.get("CustomerPolicyItemIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ScanCompliancePolicyItemsResponse(AbstractModel):
    """ScanCompliancePolicyItems response structure.

    """

    def __init__(self):
        r"""
        :param TaskId: ID of another check task
        :type TaskId: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class ScanComplianceScanFailedAssetsRequest(AbstractModel):
    """ScanComplianceScanFailedAssets request structure.

    """

    def __init__(self):
        r"""
        :param CustomerAssetIdSet: List of IDs of customer assets to be scanned again
        :type CustomerAssetIdSet: list of int non-negative
        """
        self.CustomerAssetIdSet = None


    def _deserialize(self, params):
        self.CustomerAssetIdSet = params.get("CustomerAssetIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ScanComplianceScanFailedAssetsResponse(AbstractModel):
    """ScanComplianceScanFailedAssets response structure.

    """

    def __init__(self):
        r"""
        :param TaskId: ID of another check task
        :type TaskId: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class ScanIgnoreVul(AbstractModel):
    """Scan for ignored vulnerabilities

    """

    def __init__(self):
        r"""
        :param VulName: Vulnerability name
        :type VulName: str
        :param CVEID: Vulnerability CVE ID
        :type CVEID: str
        :param PocID: POC ID
        :type PocID: str
        :param RegistryImageCount: Number of ignored repository images
        :type RegistryImageCount: int
        :param UpdateTime: Update time
        :type UpdateTime: str
        :param IsIgnoreAll: Whether to ignore all images. Valid values: `0` (no); `1` (yes).
        :type IsIgnoreAll: int
        :param LocalImageCount: Number of ignored local images
        :type LocalImageCount: int
        """
        self.VulName = None
        self.CVEID = None
        self.PocID = None
        self.RegistryImageCount = None
        self.UpdateTime = None
        self.IsIgnoreAll = None
        self.LocalImageCount = None


    def _deserialize(self, params):
        self.VulName = params.get("VulName")
        self.CVEID = params.get("CVEID")
        self.PocID = params.get("PocID")
        self.RegistryImageCount = params.get("RegistryImageCount")
        self.UpdateTime = params.get("UpdateTime")
        self.IsIgnoreAll = params.get("IsIgnoreAll")
        self.LocalImageCount = params.get("LocalImageCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SearchTemplate(AbstractModel):
    """Quick search template

    """

    def __init__(self):
        r"""
        :param Name: Search name
        :type Name: str
        :param LogType: Search index type
        :type LogType: str
        :param Condition: Search statement
        :type Condition: str
        :param TimeRange: Time range
        :type TimeRange: str
        :param Query: Converted search statement content
        :type Query: str
        :param Flag: Search method. Valid values: `standard` (search in the search box); `simple` (search by filter).
        :type Flag: str
        :param DisplayData: Displayed data
        :type DisplayData: str
        :param Id: Rule ID
        :type Id: int
        """
        self.Name = None
        self.LogType = None
        self.Condition = None
        self.TimeRange = None
        self.Query = None
        self.Flag = None
        self.DisplayData = None
        self.Id = None


    def _deserialize(self, params):
        self.Name = params.get("Name")
        self.LogType = params.get("LogType")
        self.Condition = params.get("Condition")
        self.TimeRange = params.get("TimeRange")
        self.Query = params.get("Query")
        self.Flag = params.get("Flag")
        self.DisplayData = params.get("DisplayData")
        self.Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SecLogAlertMsgInfo(AbstractModel):
    """Security log alert message

    """

    def __init__(self):
        r"""
        :param MsgType: Alert type
        :type MsgType: str
        :param MsgValue: Alert value
        :type MsgValue: str
        :param State: Status. Valid values: `0` (disabled); `1` (enabled).
        :type State: bool
        """
        self.MsgType = None
        self.MsgValue = None
        self.State = None


    def _deserialize(self, params):
        self.MsgType = params.get("MsgType")
        self.MsgValue = params.get("MsgValue")
        self.State = params.get("State")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SecLogDeliveryClsSettingInfo(AbstractModel):
    """Security log - Settings of delivery to CLS

    """

    def __init__(self):
        r"""
        :param LogType: Log type
        :type LogType: str
        :param State: Delivery status. Valid values: `true` (enabled); `false` (disabled).
        :type State: bool
        :param Region: Region
        :type Region: str
        :param LogSet: Logset
        :type LogSet: str
        :param TopicID: Topic ID
        :type TopicID: str
        :param LogSetName: Logset name
Note: This field may return null, indicating that no valid values can be obtained.
        :type LogSetName: str
        :param TopicName: Topic name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TopicName: str
        """
        self.LogType = None
        self.State = None
        self.Region = None
        self.LogSet = None
        self.TopicID = None
        self.LogSetName = None
        self.TopicName = None


    def _deserialize(self, params):
        self.LogType = params.get("LogType")
        self.State = params.get("State")
        self.Region = params.get("Region")
        self.LogSet = params.get("LogSet")
        self.TopicID = params.get("TopicID")
        self.LogSetName = params.get("LogSetName")
        self.TopicName = params.get("TopicName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SecLogDeliveryKafkaSettingInfo(AbstractModel):
    """Settings of security log delivery to Kafka

    """

    def __init__(self):
        r"""
        :param LogType: Log type
        :type LogType: str
        :param TopicID: Topic ID
        :type TopicID: str
        :param TopicName: Topic name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TopicName: str
        :param State: Delivery status. Valid values: `false` (disabled); `true` (enabled).
        :type State: bool
        """
        self.LogType = None
        self.TopicID = None
        self.TopicName = None
        self.State = None


    def _deserialize(self, params):
        self.LogType = params.get("LogType")
        self.TopicID = params.get("TopicID")
        self.TopicName = params.get("TopicName")
        self.State = params.get("State")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SecLogJoinInfo(AbstractModel):
    """Security log access details

    """

    def __init__(self):
        r"""
        :param Count: Number of accessed servers
        :type Count: int
        :param IsJoined: Whether it is accessed. Valid values: `true` (accessed); `false` (not accessed).
        :type IsJoined: bool
        :param LogType: Log type (
Container bash: "container_bash"
Container startup: "container_launch"
K8s API: "k8s_api"
)
        :type LogType: str
        """
        self.Count = None
        self.IsJoined = None
        self.LogType = None


    def _deserialize(self, params):
        self.Count = params.get("Count")
        self.IsJoined = params.get("IsJoined")
        self.LogType = params.get("LogType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SecLogJoinObjectInfo(AbstractModel):
    """Details of the accessed security log object

    """

    def __init__(self):
        r"""
        :param HostID: Server ID
        :type HostID: str
        :param HostName: Server name
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostName: str
        :param HostIP: Server IP
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostIP: str
        :param HostStatus: Server status
        :type HostStatus: str
        :param ClusterID: Cluster ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ClusterID: str
        :param ClusterName: Cluster name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ClusterName: str
        :param PublicIP: Public IP
Note: This field may return null, indicating that no valid values can be obtained.
        :type PublicIP: str
        :param JoinState: Access status. Valid values: `true` (accessed); `false` (not accessed).
        :type JoinState: bool
        :param ClusterVersion: Cluster version
Note: This field may return null, indicating that no valid values can be obtained.
        :type ClusterVersion: str
        :param ClusterMainAddress: Master node address of the cluster
        :type ClusterMainAddress: str
        """
        self.HostID = None
        self.HostName = None
        self.HostIP = None
        self.HostStatus = None
        self.ClusterID = None
        self.ClusterName = None
        self.PublicIP = None
        self.JoinState = None
        self.ClusterVersion = None
        self.ClusterMainAddress = None


    def _deserialize(self, params):
        self.HostID = params.get("HostID")
        self.HostName = params.get("HostName")
        self.HostIP = params.get("HostIP")
        self.HostStatus = params.get("HostStatus")
        self.ClusterID = params.get("ClusterID")
        self.ClusterName = params.get("ClusterName")
        self.PublicIP = params.get("PublicIP")
        self.JoinState = params.get("JoinState")
        self.ClusterVersion = params.get("ClusterVersion")
        self.ClusterMainAddress = params.get("ClusterMainAddress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SecTendencyEventInfo(AbstractModel):
    """Trend information of security events at runtime

    """

    def __init__(self):
        r"""
        :param EventSet: List of trends
        :type EventSet: list of RunTimeTendencyInfo
        :param EventType: Event type:
ET_ESCAPE: Container escape
ET_REVERSE_SHELL: Reverse shell
ET_RISK_SYSCALL: High-risk system calls
ET_ABNORMAL_PROCESS: Abnormal process
ET_ACCESS_CONTROL: File tampering
ET_VIRUS: Trojan event
ET_MALICIOUS_CONNECTION: Malicious connection event
        :type EventType: str
        """
        self.EventSet = None
        self.EventType = None


    def _deserialize(self, params):
        if params.get("EventSet") is not None:
            self.EventSet = []
            for item in params.get("EventSet"):
                obj = RunTimeTendencyInfo()
                obj._deserialize(item)
                self.EventSet.append(obj)
        self.EventType = params.get("EventType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ServiceInfo(AbstractModel):
    """Information list of TCSS

    """

    def __init__(self):
        r"""
        :param ServiceID: Service ID
        :type ServiceID: str
        :param HostID: Server ID
        :type HostID: str
        :param HostIP: Server IP
        :type HostIP: str
        :param ContainerName: Container name
        :type ContainerName: str
        :param Type: Service name, such as `nginx` and `redis`
        :type Type: str
        :param Version: Version
        :type Version: str
        :param RunAs: Account
        :type RunAs: str
        :param Listen: Listened port
        :type Listen: list of str
        :param Config: Configuration
        :type Config: str
        :param ProcessCnt: Number of associated processes
        :type ProcessCnt: int
        :param AccessLog: Access log
        :type AccessLog: str
        :param ErrorLog: Error log
        :type ErrorLog: str
        :param DataPath: Data directory
        :type DataPath: str
        :param WebRoot: Web directory
        :type WebRoot: str
        :param Pids: ID of the associated process
        :type Pids: list of int non-negative
        :param MainType: Service type. Valid values: `app`, `web`, `db`.
        :type MainType: str
        :param Exe: Execution file
        :type Exe: str
        :param Parameter: Service command line parameter
        :type Parameter: str
        :param ContainerId: Container ID
        :type ContainerId: str
        :param HostName: Server name
        :type HostName: str
        :param PublicIp: Public IP
        :type PublicIp: str
        """
        self.ServiceID = None
        self.HostID = None
        self.HostIP = None
        self.ContainerName = None
        self.Type = None
        self.Version = None
        self.RunAs = None
        self.Listen = None
        self.Config = None
        self.ProcessCnt = None
        self.AccessLog = None
        self.ErrorLog = None
        self.DataPath = None
        self.WebRoot = None
        self.Pids = None
        self.MainType = None
        self.Exe = None
        self.Parameter = None
        self.ContainerId = None
        self.HostName = None
        self.PublicIp = None


    def _deserialize(self, params):
        self.ServiceID = params.get("ServiceID")
        self.HostID = params.get("HostID")
        self.HostIP = params.get("HostIP")
        self.ContainerName = params.get("ContainerName")
        self.Type = params.get("Type")
        self.Version = params.get("Version")
        self.RunAs = params.get("RunAs")
        self.Listen = params.get("Listen")
        self.Config = params.get("Config")
        self.ProcessCnt = params.get("ProcessCnt")
        self.AccessLog = params.get("AccessLog")
        self.ErrorLog = params.get("ErrorLog")
        self.DataPath = params.get("DataPath")
        self.WebRoot = params.get("WebRoot")
        self.Pids = params.get("Pids")
        self.MainType = params.get("MainType")
        self.Exe = params.get("Exe")
        self.Parameter = params.get("Parameter")
        self.ContainerId = params.get("ContainerId")
        self.HostName = params.get("HostName")
        self.PublicIp = params.get("PublicIp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SetCheckModeRequest(AbstractModel):
    """SetCheckMode request structure.

    """

    def __init__(self):
        r"""
        :param ClusterIds: List of cluster IDs to be set
        :type ClusterIds: list of str
        :param ClusterCheckMode: Cluster check mode. Valid values: `Cluster_Normal` (normal mode); `Cluster_Actived` (proactive mode); `Cluster_Unset` (not set).
        :type ClusterCheckMode: str
        :param ClusterAutoCheck: Valid values: `0` (not set); `1` (on); `2` (off).
        :type ClusterAutoCheck: int
        """
        self.ClusterIds = None
        self.ClusterCheckMode = None
        self.ClusterAutoCheck = None


    def _deserialize(self, params):
        self.ClusterIds = params.get("ClusterIds")
        self.ClusterCheckMode = params.get("ClusterCheckMode")
        self.ClusterAutoCheck = params.get("ClusterAutoCheck")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SetCheckModeResponse(AbstractModel):
    """SetCheckMode response structure.

    """

    def __init__(self):
        r"""
        :param SetCheckResult: Valid values: `Succ` (set successfully); `Failed` (failed to set).
        :type SetCheckResult: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.SetCheckResult = None
        self.RequestId = None


    def _deserialize(self, params):
        self.SetCheckResult = params.get("SetCheckResult")
        self.RequestId = params.get("RequestId")


class SoftQuotaDayInfo(AbstractModel):
    """Pay-as-you-go billing details

    """

    def __init__(self):
        r"""
        :param PayTime: Deduction time
        :type PayTime: str
        :param CoresCnt: Number of billed cores
        :type CoresCnt: int
        """
        self.PayTime = None
        self.CoresCnt = None


    def _deserialize(self, params):
        self.PayTime = params.get("PayTime")
        self.CoresCnt = params.get("CoresCnt")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StopVirusScanTaskRequest(AbstractModel):
    """StopVirusScanTask request structure.

    """

    def __init__(self):
        r"""
        :param TaskId: Task ID
        :type TaskId: str
        :param ContainerIds: ID of the container to be stopped. If it is left empty, the entire task will be stopped.
        :type ContainerIds: list of str
        """
        self.TaskId = None
        self.ContainerIds = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.ContainerIds = params.get("ContainerIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StopVirusScanTaskResponse(AbstractModel):
    """StopVirusScanTask response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class StopVulScanTaskRequest(AbstractModel):
    """StopVulScanTask request structure.

    """

    def __init__(self):
        r"""
        :param LocalTaskID: ID of the task to scan local images for vulnerabilities
        :type LocalTaskID: int
        :param LocalImageIDs: Local image ID. If it is not specified, it indicates all.
        :type LocalImageIDs: list of str
        :param RegistryImageIDs: Repository image ID. If it is not specified, it indicates all.
        :type RegistryImageIDs: list of int non-negative
        :param RegistryTaskID: ID of the task to scan repository images for vulnerabilities
        :type RegistryTaskID: int
        """
        self.LocalTaskID = None
        self.LocalImageIDs = None
        self.RegistryImageIDs = None
        self.RegistryTaskID = None


    def _deserialize(self, params):
        self.LocalTaskID = params.get("LocalTaskID")
        self.LocalImageIDs = params.get("LocalImageIDs")
        self.RegistryImageIDs = params.get("RegistryImageIDs")
        self.RegistryTaskID = params.get("RegistryTaskID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StopVulScanTaskResponse(AbstractModel):
    """StopVulScanTask response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class SupportDefenceVul(AbstractModel):
    """Vulnerability that can be prevented

    """

    def __init__(self):
        r"""
        :param PocID: POC ID
        :type PocID: str
        :param Name: Vulnerability name
        :type Name: str
        :param Tags: Vulnerability tag
        :type Tags: list of str
        :param CVSSV3Score: Vulnerability CVSS
        :type CVSSV3Score: float
        :param Level: Vulnerability severity
        :type Level: str
        :param CVEID: Vulnerability CVE ID
        :type CVEID: str
        :param SubmitTime: Vulnerability disclosure time
        :type SubmitTime: str
        """
        self.PocID = None
        self.Name = None
        self.Tags = None
        self.CVSSV3Score = None
        self.Level = None
        self.CVEID = None
        self.SubmitTime = None


    def _deserialize(self, params):
        self.PocID = params.get("PocID")
        self.Name = params.get("Name")
        self.Tags = params.get("Tags")
        self.CVSSV3Score = params.get("CVSSV3Score")
        self.Level = params.get("Level")
        self.CVEID = params.get("CVEID")
        self.SubmitTime = params.get("SubmitTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SwitchImageAutoAuthorizedRuleRequest(AbstractModel):
    """SwitchImageAutoAuthorizedRule request structure.

    """

    def __init__(self):
        r"""
        :param IsEnabled: Whether the rule takes effect. Valid values: `0` (no); `1` (yes).
        :type IsEnabled: int
        :param RuleId: Rule ID
        :type RuleId: int
        """
        self.IsEnabled = None
        self.RuleId = None


    def _deserialize(self, params):
        self.IsEnabled = params.get("IsEnabled")
        self.RuleId = params.get("RuleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SwitchImageAutoAuthorizedRuleResponse(AbstractModel):
    """SwitchImageAutoAuthorizedRule response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class SyncAssetImageRegistryAssetRequest(AbstractModel):
    """SyncAssetImageRegistryAsset request structure.

    """


class SyncAssetImageRegistryAssetResponse(AbstractModel):
    """SyncAssetImageRegistryAsset response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class TagInfo(AbstractModel):
    """Host tag information

    """

    def __init__(self):
        r"""
        :param TagKey: Tag key
        :type TagKey: str
        :param TagValue: Tag value
        :type TagValue: str
        """
        self.TagKey = None
        self.TagValue = None


    def _deserialize(self, params):
        self.TagKey = params.get("TagKey")
        self.TagValue = params.get("TagValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UnauthorizedCoresTendency(AbstractModel):
    """Trend of unlicensed cores

    """

    def __init__(self):
        r"""
        :param DateTime: Date
        :type DateTime: str
        :param CoresCount: Number of unlicensed cores
        :type CoresCount: int
        """
        self.DateTime = None
        self.CoresCount = None


    def _deserialize(self, params):
        self.DateTime = params.get("DateTime")
        self.CoresCount = params.get("CoresCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateAndPublishNetworkFirewallPolicyDetailRequest(AbstractModel):
    """UpdateAndPublishNetworkFirewallPolicyDetail request structure.

    """

    def __init__(self):
        r"""
        :param ClusterId: Cluster ID
        :type ClusterId: str
        :param Id: Policy ID
        :type Id: int
        :param FromPolicyRule: Inbound rule

`1`: Allow all.

`2`: Reject all.

`3`: Custom.
        :type FromPolicyRule: int
        :param ToPolicyRule: Outbound rule

`1`: Allow all.

`2`: Reject all.

`3`: Custom.
        :type ToPolicyRule: int
        :param PodSelector: Pod selector
        :type PodSelector: str
        :param Namespace: Namespace
        :type Namespace: str
        :param Description: Policy description
        :type Description: str
        :param CustomPolicy: Custom rule
        :type CustomPolicy: list of NetworkCustomPolicy
        """
        self.ClusterId = None
        self.Id = None
        self.FromPolicyRule = None
        self.ToPolicyRule = None
        self.PodSelector = None
        self.Namespace = None
        self.Description = None
        self.CustomPolicy = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        self.Id = params.get("Id")
        self.FromPolicyRule = params.get("FromPolicyRule")
        self.ToPolicyRule = params.get("ToPolicyRule")
        self.PodSelector = params.get("PodSelector")
        self.Namespace = params.get("Namespace")
        self.Description = params.get("Description")
        if params.get("CustomPolicy") is not None:
            self.CustomPolicy = []
            for item in params.get("CustomPolicy"):
                obj = NetworkCustomPolicy()
                obj._deserialize(item)
                self.CustomPolicy.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateAndPublishNetworkFirewallPolicyDetailResponse(AbstractModel):
    """UpdateAndPublishNetworkFirewallPolicyDetail response structure.

    """

    def __init__(self):
        r"""
        :param TaskId: ID of the created task. `0` indicates that the creation failed.
        :type TaskId: int
        :param Result: Result of creating the task. Valid values: `Succ`, `Failed`.
        :type Result: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskId = None
        self.Result = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.Result = params.get("Result")
        self.RequestId = params.get("RequestId")


class UpdateAndPublishNetworkFirewallPolicyYamlDetailRequest(AbstractModel):
    """UpdateAndPublishNetworkFirewallPolicyYamlDetail request structure.

    """

    def __init__(self):
        r"""
        :param ClusterId: Cluster ID
        :type ClusterId: str
        :param Id: Policy ID
        :type Id: int
        :param Yaml: Base64-encoded NetworkPolicy YAML string
        :type Yaml: str
        :param Description: Policy description
        :type Description: str
        """
        self.ClusterId = None
        self.Id = None
        self.Yaml = None
        self.Description = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        self.Id = params.get("Id")
        self.Yaml = params.get("Yaml")
        self.Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateAndPublishNetworkFirewallPolicyYamlDetailResponse(AbstractModel):
    """UpdateAndPublishNetworkFirewallPolicyYamlDetail response structure.

    """

    def __init__(self):
        r"""
        :param TaskId: ID of the created task. `0` indicates that the creation failed.
        :type TaskId: int
        :param Result: Result of creating the task. Valid values: `Succ`, `Failed`.
        :type Result: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskId = None
        self.Result = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.Result = params.get("Result")
        self.RequestId = params.get("RequestId")


class UpdateAssetImageRegistryRegistryDetailRequest(AbstractModel):
    """UpdateAssetImageRegistryRegistryDetail request structure.

    """

    def __init__(self):
        r"""
        :param Name: Repository name
        :type Name: str
        :param Username: Username
        :type Username: str
        :param Password: Password
        :type Password: str
        :param Url: Repository URL
        :type Url: str
        :param RegistryType: Repository type, which can be `harbor`.
        :type RegistryType: str
        :param NetType: Network type, which can be `public` (public network).
        :type NetType: str
        :param RegistryVersion: Repository version
        :type RegistryVersion: str
        :param RegistryRegion: Region. Default value: `default`.
        :type RegistryRegion: str
        :param SpeedLimit: Speed limit
        :type SpeedLimit: int
        :param Insecure: Valid values: `0` (secure mode with certificate verification, which is the default value); `1` (unsecure mode that skips certificate verification).
        :type Insecure: int
        """
        self.Name = None
        self.Username = None
        self.Password = None
        self.Url = None
        self.RegistryType = None
        self.NetType = None
        self.RegistryVersion = None
        self.RegistryRegion = None
        self.SpeedLimit = None
        self.Insecure = None


    def _deserialize(self, params):
        self.Name = params.get("Name")
        self.Username = params.get("Username")
        self.Password = params.get("Password")
        self.Url = params.get("Url")
        self.RegistryType = params.get("RegistryType")
        self.NetType = params.get("NetType")
        self.RegistryVersion = params.get("RegistryVersion")
        self.RegistryRegion = params.get("RegistryRegion")
        self.SpeedLimit = params.get("SpeedLimit")
        self.Insecure = params.get("Insecure")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateAssetImageRegistryRegistryDetailResponse(AbstractModel):
    """UpdateAssetImageRegistryRegistryDetail response structure.

    """

    def __init__(self):
        r"""
        :param HealthCheckErr: Connection error message
Note: This field may return null, indicating that no valid values can be obtained.
        :type HealthCheckErr: str
        :param NameRepeatErr: Name error message
Note: This field may return null, indicating that no valid values can be obtained.
        :type NameRepeatErr: str
        :param RegistryId: Unique repository ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type RegistryId: int
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.HealthCheckErr = None
        self.NameRepeatErr = None
        self.RegistryId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.HealthCheckErr = params.get("HealthCheckErr")
        self.NameRepeatErr = params.get("NameRepeatErr")
        self.RegistryId = params.get("RegistryId")
        self.RequestId = params.get("RequestId")


class UpdateImageRegistryTimingScanTaskRequest(AbstractModel):
    """UpdateImageRegistryTimingScanTask request structure.

    """

    def __init__(self):
        r"""
        :param ScanPeriod: Scheduled scan cycle
        :type ScanPeriod: int
        :param Enable: Scheduled scan switch
        :type Enable: bool
        :param ScanTime: Scheduled scan time
        :type ScanTime: str
        :param ScanType: Array of the scanned trojan types
        :type ScanType: list of str
        :param Images: Scanned image
        :type Images: list of ImageInfo
        :param All: Whether to scan all
        :type All: bool
        :param Id: ID of the image to be scanned
        :type Id: list of int non-negative
        """
        self.ScanPeriod = None
        self.Enable = None
        self.ScanTime = None
        self.ScanType = None
        self.Images = None
        self.All = None
        self.Id = None


    def _deserialize(self, params):
        self.ScanPeriod = params.get("ScanPeriod")
        self.Enable = params.get("Enable")
        self.ScanTime = params.get("ScanTime")
        self.ScanType = params.get("ScanType")
        if params.get("Images") is not None:
            self.Images = []
            for item in params.get("Images"):
                obj = ImageInfo()
                obj._deserialize(item)
                self.Images.append(obj)
        self.All = params.get("All")
        self.Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateImageRegistryTimingScanTaskResponse(AbstractModel):
    """UpdateImageRegistryTimingScanTask response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class UpdateNetworkFirewallPolicyDetailRequest(AbstractModel):
    """UpdateNetworkFirewallPolicyDetail request structure.

    """

    def __init__(self):
        r"""
        :param ClusterId: Cluster ID
        :type ClusterId: str
        :param Id: Policy ID
        :type Id: int
        :param FromPolicyRule: Inbound rule

`1`: Allow all.

`2`: Reject all.

`3`: Custom.
        :type FromPolicyRule: int
        :param ToPolicyRule: Outbound rule

`1`: Allow all.

`2`: Reject all.

`3`: Custom.
        :type ToPolicyRule: int
        :param PodSelector: Pod selector
        :type PodSelector: str
        :param Namespace: Namespace
        :type Namespace: str
        :param Description: Policy description
        :type Description: str
        :param CustomPolicy: Custom rule
        :type CustomPolicy: list of NetworkCustomPolicy
        """
        self.ClusterId = None
        self.Id = None
        self.FromPolicyRule = None
        self.ToPolicyRule = None
        self.PodSelector = None
        self.Namespace = None
        self.Description = None
        self.CustomPolicy = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        self.Id = params.get("Id")
        self.FromPolicyRule = params.get("FromPolicyRule")
        self.ToPolicyRule = params.get("ToPolicyRule")
        self.PodSelector = params.get("PodSelector")
        self.Namespace = params.get("Namespace")
        self.Description = params.get("Description")
        if params.get("CustomPolicy") is not None:
            self.CustomPolicy = []
            for item in params.get("CustomPolicy"):
                obj = NetworkCustomPolicy()
                obj._deserialize(item)
                self.CustomPolicy.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateNetworkFirewallPolicyDetailResponse(AbstractModel):
    """UpdateNetworkFirewallPolicyDetail response structure.

    """

    def __init__(self):
        r"""
        :param TaskId: ID of the created task. `0` indicates that the creation failed.
        :type TaskId: int
        :param Result: Result of creating the task. Valid values: `Succ`, `Failed`.
        :type Result: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskId = None
        self.Result = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.Result = params.get("Result")
        self.RequestId = params.get("RequestId")


class UpdateNetworkFirewallPolicyYamlDetailRequest(AbstractModel):
    """UpdateNetworkFirewallPolicyYamlDetail request structure.

    """

    def __init__(self):
        r"""
        :param ClusterId: Cluster ID
        :type ClusterId: str
        :param Id: Policy ID
        :type Id: int
        :param Yaml: Base64-encoded NetworkPolicy YAML string
        :type Yaml: str
        :param Description: Policy description
        :type Description: str
        """
        self.ClusterId = None
        self.Id = None
        self.Yaml = None
        self.Description = None


    def _deserialize(self, params):
        self.ClusterId = params.get("ClusterId")
        self.Id = params.get("Id")
        self.Yaml = params.get("Yaml")
        self.Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateNetworkFirewallPolicyYamlDetailResponse(AbstractModel):
    """UpdateNetworkFirewallPolicyYamlDetail response structure.

    """

    def __init__(self):
        r"""
        :param TaskId: ID of the created task. `0` indicates that the creation failed.
        :type TaskId: int
        :param Result: Result of creating the task. Valid values: `Succ`, `Failed`.
        :type Result: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskId = None
        self.Result = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.Result = params.get("Result")
        self.RequestId = params.get("RequestId")


class VirusAutoIsolateSampleInfo(AbstractModel):
    """Information of the automatically isolated trojan sample

    """

    def __init__(self):
        r"""
        :param MD5: MD5 checksum of the file
        :type MD5: str
        :param VirusName: Virus name
        :type VirusName: str
        :param ModifyTime: Last edit time
        :type ModifyTime: str
        :param AutoIsolateSwitch: Automatic isolation switch. Valid values: `true` (on); `false` (off).
        :type AutoIsolateSwitch: bool
        """
        self.MD5 = None
        self.VirusName = None
        self.ModifyTime = None
        self.AutoIsolateSwitch = None


    def _deserialize(self, params):
        self.MD5 = params.get("MD5")
        self.VirusName = params.get("VirusName")
        self.ModifyTime = params.get("ModifyTime")
        self.AutoIsolateSwitch = params.get("AutoIsolateSwitch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class VirusInfo(AbstractModel):
    """List of trojans at runtime

    """

    def __init__(self):
        r"""
        :param FileName: Filename
        :type FileName: str
        :param FilePath: File path
        :type FilePath: str
        :param VirusName: Virus name
        :type VirusName: str
        :param CreateTime: Creation time
        :type CreateTime: str
        :param ModifyTime: Update time
        :type ModifyTime: str
        :param ContainerName: Container name
        :type ContainerName: str
        :param ContainerId: Container ID
        :type ContainerId: str
        :param ContainerStatus: Container status
`RUNNING`: Running.
`PAUSED`: Paused.
`STOPPED`: Stopped.
`CREATED`: Created.
`DESTROYED`: Terminated.
`RESTARTING`: Restarting.
`REMOVING`: Removing.
        :type ContainerStatus: str
        :param ImageName: Image name
        :type ImageName: str
        :param ImageId: Image ID
        :type ImageId: str
        :param Status: `DEAL_NONE`: Pending.
`DEAL_IGNORE`: Ignored.
`DEAL_ADD_WHITELIST`: Allowed.
`DEAL_DEL`: Deleted.
`DEAL_ISOLATE`: Isolated.
`DEAL_ISOLATING`: Isolating.
`DEAL_ISOLATE_FAILED`: Isolation failed.
`DEAL_RECOVERING`: Recovering.
`DEAL_RECOVER_FAILED`: Recovery failed.
        :type Status: str
        :param Id: Event ID
        :type Id: str
        :param HarmDescribe: Event description
        :type HarmDescribe: str
        :param SuggestScheme: Solution
        :type SuggestScheme: str
        :param SubStatus: Sub-status of the failure:
`FILE_NOT_FOUND`: The file does not exist.
`FILE_ABNORMAL`: The file is abnormal.
`FILE_ABNORMAL_DEAL_RECOVER`: The file is abnormal when recovered.
`BACKUP_FILE_NOT_FOUND`: The backup file does not exist.
`CONTAINER_NOT_FOUND_DEAL_ISOLATE`: The container does not exist during isolation.
`CONTAINER_NOT_FOUND_DEAL_RECOVER`: The container does not exist during recovery.
`TIMEOUT`: Timed out.
`TOO_MANY`: Too many tasks.
`OFFLINE`: Offline.
`INTERNAL`: Internal service error.
`VALIDATION`: Invalid parameter.
        :type SubStatus: str
        :param ContainerNetStatus: Network status
`NORMAL`: 	Not isolated.
`ISOLATED`: 		Isolated.
`ISOLATING`: 		Isolating.
`ISOLATE_FAILED`: 	Isolation failed.
`RESTORING`: Recovering.
`RESTORE_FAILED`: Recovery failed.
        :type ContainerNetStatus: str
        :param ContainerNetSubStatus: Sub-status of the container
"AGENT_OFFLINE"       // The agent is offline.
	"NODE_DESTROYED"      // The node is terminated.
	"CONTAINER_EXITED"    // The container exited.
	"CONTAINER_DESTROYED" // The container was terminated.
	"SHARED_HOST"         // The container shares the network with the server.
	"RESOURCE_LIMIT"      // The number of resources to be isolated exceeds the limit.
	"UNKNOW"              // The reason is unknown.
        :type ContainerNetSubStatus: str
        :param ContainerIsolateOperationSrc: Container isolation operation source
        :type ContainerIsolateOperationSrc: str
        :param MD5: MD5 checksum
Note: This field may return null, indicating that no valid values can be obtained.
        :type MD5: str
        :param RiskLevel: Risk level. Valid values: `RISK_CRITICAL`, `RISK_HIGH`, `RISK_MEDIUM`, `RISK_LOW`, `RISK_NOTICE`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskLevel: str
        :param CheckPlatform: Check platform
`1`: Tencent Cloud Security Engine.
`2`: tav.
`3`: binaryAi.
`4`: Unusual behavior.
`5`: Threat intelligence.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CheckPlatform: list of str
        """
        self.FileName = None
        self.FilePath = None
        self.VirusName = None
        self.CreateTime = None
        self.ModifyTime = None
        self.ContainerName = None
        self.ContainerId = None
        self.ContainerStatus = None
        self.ImageName = None
        self.ImageId = None
        self.Status = None
        self.Id = None
        self.HarmDescribe = None
        self.SuggestScheme = None
        self.SubStatus = None
        self.ContainerNetStatus = None
        self.ContainerNetSubStatus = None
        self.ContainerIsolateOperationSrc = None
        self.MD5 = None
        self.RiskLevel = None
        self.CheckPlatform = None


    def _deserialize(self, params):
        self.FileName = params.get("FileName")
        self.FilePath = params.get("FilePath")
        self.VirusName = params.get("VirusName")
        self.CreateTime = params.get("CreateTime")
        self.ModifyTime = params.get("ModifyTime")
        self.ContainerName = params.get("ContainerName")
        self.ContainerId = params.get("ContainerId")
        self.ContainerStatus = params.get("ContainerStatus")
        self.ImageName = params.get("ImageName")
        self.ImageId = params.get("ImageId")
        self.Status = params.get("Status")
        self.Id = params.get("Id")
        self.HarmDescribe = params.get("HarmDescribe")
        self.SuggestScheme = params.get("SuggestScheme")
        self.SubStatus = params.get("SubStatus")
        self.ContainerNetStatus = params.get("ContainerNetStatus")
        self.ContainerNetSubStatus = params.get("ContainerNetSubStatus")
        self.ContainerIsolateOperationSrc = params.get("ContainerIsolateOperationSrc")
        self.MD5 = params.get("MD5")
        self.RiskLevel = params.get("RiskLevel")
        self.CheckPlatform = params.get("CheckPlatform")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class VirusTaskInfo(AbstractModel):
    """List of containers in the virus scanning task at runtime

    """

    def __init__(self):
        r"""
        :param ContainerName: Container name
        :type ContainerName: str
        :param ContainerId: Container ID
        :type ContainerId: str
        :param ImageName: Image name
        :type ImageName: str
        :param ImageId: Image ID
        :type ImageId: str
        :param HostName: Server name
        :type HostName: str
        :param HostIp: Server IP
        :type HostIp: str
        :param Status: Scanning status:
`WAIT`: Pending scanning.
`FAILED`: Failed.
`SCANNING`: Scanning.
`FINISHED`: Ended.
`CANCELING`: Canceling.
`CANCELED`: Canceled.
`CANCEL_FAILED`: Failed to cancel.
        :type Status: str
        :param StartTime: Check start time
        :type StartTime: str
        :param EndTime: Check end time
        :type EndTime: str
        :param RiskCnt: Number of risks
        :type RiskCnt: int
        :param Id: Event ID
        :type Id: str
        :param ErrorMsg: Cause:
`SEND_SUCCESSED`: Task submitted.
`SCAN_WAIT`: Waiting to scan...
`OFFLINE`: Offline.
`SEND_FAILED`: Failed to deploy.
`TIMEOUT`: Timed out.
`LOW_AGENT_VERSION`: The Agent version is too old.
`AGENT_NOT_FOUND`: The image's agent doesn't exist.
`TOO_MANY`: Too many tasks.
`VALIDATION`: Invalid parameter.
`INTERNAL`: Internal service error.
`MISC`: Other errors.
`UNAUTH`: The image is not assigned with a license.
`SEND_CANCEL_SUCCESSED`: Task submitted.
        :type ErrorMsg: str
        """
        self.ContainerName = None
        self.ContainerId = None
        self.ImageName = None
        self.ImageId = None
        self.HostName = None
        self.HostIp = None
        self.Status = None
        self.StartTime = None
        self.EndTime = None
        self.RiskCnt = None
        self.Id = None
        self.ErrorMsg = None


    def _deserialize(self, params):
        self.ContainerName = params.get("ContainerName")
        self.ContainerId = params.get("ContainerId")
        self.ImageName = params.get("ImageName")
        self.ImageId = params.get("ImageId")
        self.HostName = params.get("HostName")
        self.HostIp = params.get("HostIp")
        self.Status = params.get("Status")
        self.StartTime = params.get("StartTime")
        self.EndTime = params.get("EndTime")
        self.RiskCnt = params.get("RiskCnt")
        self.Id = params.get("Id")
        self.ErrorMsg = params.get("ErrorMsg")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class VirusTendencyInfo(AbstractModel):
    """Trojan trend details

    """

    def __init__(self):
        r"""
        :param Date: Date
        :type Date: str
        :param PendingEventCount: Total number of pending events
        :type PendingEventCount: int
        :param RiskContainerCount: Total number of containers at risk
        :type RiskContainerCount: int
        :param EventCount: Total number of events
        :type EventCount: int
        :param IsolateEventCount: Total number of isolated events
        :type IsolateEventCount: int
        """
        self.Date = None
        self.PendingEventCount = None
        self.RiskContainerCount = None
        self.EventCount = None
        self.IsolateEventCount = None


    def _deserialize(self, params):
        self.Date = params.get("Date")
        self.PendingEventCount = params.get("PendingEventCount")
        self.RiskContainerCount = params.get("RiskContainerCount")
        self.EventCount = params.get("EventCount")
        self.IsolateEventCount = params.get("IsolateEventCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class VulAffectedComponentInfo(AbstractModel):
    """Information of the component affected by the vulnerability

    """

    def __init__(self):
        r"""
        :param Name: Component name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Name: str
        :param Version: Component version
Note: This field may return null, indicating that no valid values can be obtained.
        :type Version: list of str
        :param FixedVersion: Fixed component version
Note: This field may return null, indicating that no valid values can be obtained.
        :type FixedVersion: list of str
        """
        self.Name = None
        self.Version = None
        self.FixedVersion = None


    def _deserialize(self, params):
        self.Name = params.get("Name")
        self.Version = params.get("Version")
        self.FixedVersion = params.get("FixedVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class VulAffectedContainerInfo(AbstractModel):
    """Information of the container affected by the vulnerability

    """

    def __init__(self):
        r"""
        :param HostIP: Private IP
        :type HostIP: str
        :param ContainerID: Container ID
        :type ContainerID: str
        :param ContainerName: Container name
        :type ContainerName: str
        :param PodName: Pod name
        :type PodName: str
        :param PodIP: Pod IP
        :type PodIP: str
        :param HostName: Server name
        :type HostName: str
        :param HostID: Server ID
        :type HostID: str
        :param PublicIP: Public IP
        :type PublicIP: str
        """
        self.HostIP = None
        self.ContainerID = None
        self.ContainerName = None
        self.PodName = None
        self.PodIP = None
        self.HostName = None
        self.HostID = None
        self.PublicIP = None


    def _deserialize(self, params):
        self.HostIP = params.get("HostIP")
        self.ContainerID = params.get("ContainerID")
        self.ContainerName = params.get("ContainerName")
        self.PodName = params.get("PodName")
        self.PodIP = params.get("PodIP")
        self.HostName = params.get("HostName")
        self.HostID = params.get("HostID")
        self.PublicIP = params.get("PublicIP")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class VulAffectedImageComponentInfo(AbstractModel):
    """Information of the component affected by the vulnerability

    """

    def __init__(self):
        r"""
        :param Name: Component name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Name: str
        :param Version: Component version
Note: This field may return null, indicating that no valid values can be obtained.
        :type Version: str
        :param FixedVersion: Fixed component version
Note: This field may return null, indicating that no valid values can be obtained.
        :type FixedVersion: str
        :param Path: Component path
Note: This field may return null, indicating that no valid values can be obtained.
        :type Path: str
        """
        self.Name = None
        self.Version = None
        self.FixedVersion = None
        self.Path = None


    def _deserialize(self, params):
        self.Name = params.get("Name")
        self.Version = params.get("Version")
        self.FixedVersion = params.get("FixedVersion")
        self.Path = params.get("Path")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            i