# Generated by Django 3.2.12 on 2022-03-07 10:28

from django.db import migrations, models

import django_better_admin_arrayfield.models.fields


class Migration(migrations.Migration):

    dependencies = [
        ("mozilla_django_oidc_db", "0006_openidconnectconfig_unique_id_claim"),
    ]

    operations = [
        migrations.AddField(
            model_name="openidconnectconfig",
            name="oidc_exempt_urls",
            field=django_better_admin_arrayfield.models.fields.ArrayField(
                base_field=models.CharField(max_length=1000, verbose_name="Exempt URL"),
                blank=True,
                default=list,
                help_text="This is a list of absolute url paths, regular expressions for url paths, or Django view names. This plus the mozilla-django-oidc urls are exempted from the session renewal by the SessionRefresh middleware.",
                size=None,
                verbose_name="URLs exempt from session renewal",
            ),
        ),
        migrations.AddField(
            model_name="openidconnectconfig",
            name="oidc_nonce_size",
            field=models.PositiveIntegerField(
                default=32,
                help_text="Sets the length of the random string used for OpenID Connect nonce verification",
                verbose_name="Nonce size",
            ),
        ),
        migrations.AddField(
            model_name="openidconnectconfig",
            name="oidc_state_size",
            field=models.PositiveIntegerField(
                default=32,
                help_text="Sets the length of the random string used for OpenID Connect state verification",
                verbose_name="State size",
            ),
        ),
        migrations.AddField(
            model_name="openidconnectconfig",
            name="oidc_use_nonce",
            field=models.BooleanField(
                default=True,
                help_text="Controls whether the OpenID Connect client uses nonce verification",
                verbose_name="Use nonce",
            ),
        ),
    ]
