// This file is auto-generated by build.rs.

use crate::{LineSenderBuffer, Result};
use crate::tests::{TestResult};

fn matches_any_line(line: &str, expected: &[&str]) -> bool {
    for &exp in expected {
        if line == exp {
            return true;
        }
    }
    eprintln!(
        "Could not match:\n    {:?}\nTo any of: {:#?}",
        line, expected);
    false
}

/// all column types
#[test]
fn test_000_all_column_types() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    buffer
        .table("test_table")?
        .symbol("sym_col", "sym_val")?
        .column_str("str_col", "foo bar baz")?
        .column_i64("long_col", 42)?
        .column_f64("double_col", 42.5)?
        .column_bool("bool_col", true)?
        .at_now()?;
    let exp = "test_table,sym_col=sym_val str_col=\"foo bar baz\",long_col=42i,double_col=42.5,bool_col=t\n";
    assert_eq!(buffer.as_str(), exp);
    Ok(())
}
/// double serialization
#[test]
fn test_001_double_serialization() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    buffer
        .table("doubles")?
        .column_f64("d0", 0.0)?
        .column_f64("dm0", -0.0)?
        .column_f64("d1", 1.0)?
        .column_f64("dE100", 1e100)?
        .column_f64("d0000001", 1e-6)?
        .column_f64("dN0000001", -1e-6)?
        .at_now()?;
    let any = [
            "doubles d0=0,dm0=-0,d1=1,dE100=1E+100,d0000001=1E-06,dN0000001=-1E-06\n",
            "doubles d0=0.0,dm0=-0.0,d1=1.0,dE100=1e100,d0000001=1e-6,dN0000001=-1e-6\n",
        ];
    assert!(matches_any_line(buffer.as_str(), &any));
    Ok(())
}
/// escaped chars in table name
#[test]
fn test_002_escaped_chars_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    buffer
        .table("test 1=2")?
        .column_i64("a_col", 42)?
        .at_now()?;
    let exp = "test\\ 1\\=2 a_col=42i\n";
    assert_eq!(buffer.as_str(), exp);
    Ok(())
}
/// '.' in the middle of table name
#[test]
fn test_003_in_the_middle_of_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    buffer
        .table("foobar.csv")?
        .column_bool("a_col", false)?
        .at_now()?;
    let exp = "foobar.csv a_col=f\n";
    assert_eq!(buffer.as_str(), exp);
    Ok(())
}
/// escaped chars in string column
#[test]
fn test_004_escaped_chars_in_string_column() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    buffer
        .table("test_table")?
        .column_str("name 1=2", "value 1,2=3\n4\r5\"6\\7")?
        .at_now()?;
    let exp = "test_table name\\ 1\\=2=\"value 1,2=3\\\n4\\\r5\\\"6\\\\7\"\n";
    assert_eq!(buffer.as_str(), exp);
    Ok(())
}
/// escaped chars in symbol
#[test]
fn test_005_escaped_chars_in_symbol() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    buffer
        .table("test_table")?
        .symbol("name 1=2", "value 1,2=3\n4\r5\"6\\7")?
        .at_now()?;
    let exp = "test_table,name\\ 1\\=2=value\\ 1\\,2\\=3\\\n4\\\r5\"6\\\\7\n";
    assert_eq!(buffer.as_str(), exp);
    Ok(())
}
/// escaped chars mixed with UTF-8 in string column
#[test]
fn test_006_escaped_chars_mixed_with_utf_8_in_string_column() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    buffer
        .table("таблица")?
        .column_str("имя раз=два", "значение раз,два=три\nчетыре\rпять\"шесть\\семь")?
        .at_now()?;
    let exp = "таблица имя\\ раз\\=два=\"значение раз,два=три\\\nчетыре\\\rпять\\\"шесть\\\\семь\"\n";
    assert_eq!(buffer.as_str(), exp);
    Ok(())
}
/// escaped chars mixed with UTF-8 in symbol
#[test]
fn test_007_escaped_chars_mixed_with_utf_8_in_symbol() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    buffer
        .table("таблица")?
        .symbol("имя раз=два", "значение раз,два=три\nчетыре\rпять\"шесть\\семь")?
        .at_now()?;
    let exp = "таблица,имя\\ раз\\=два=значение\\ раз\\,два\\=три\\\nчетыре\\\rпять\"шесть\\\\семь\n";
    assert_eq!(buffer.as_str(), exp);
    Ok(())
}
/// no symbols or columns
#[test]
fn test_008_no_symbols_or_columns() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// empty table name
#[test]
fn test_009_empty_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("")?
            .column_f64("a_col", 42.0)?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// empty symbol name
#[test]
fn test_010_empty_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("", "foobar")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// empty column name
#[test]
fn test_011_empty_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_bool("", true)?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '.' at the start of table name
#[test]
fn test_012_at_the_start_of_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table(".foobar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '.' at the end of table name
#[test]
fn test_013_at_the_end_of_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foobar.")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '\n' in table name
#[test]
fn test_014_n_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo\nbar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '\r,' in table name
#[test]
fn test_015_r_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo\rbar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '?' in table name
#[test]
fn test_016_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo?bar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// ',' in table name
#[test]
fn test_017_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo,bar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// ''' in table name
#[test]
fn test_018_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo'bar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '"' in table name
#[test]
fn test_019_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo\"bar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '\' in table name
#[test]
fn test_020_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo\\bar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '/' in table name
#[test]
fn test_021_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo/bar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// ':' in table name
#[test]
fn test_022_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo:bar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// ')' in table name
#[test]
fn test_023_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo)bar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '(' in table name
#[test]
fn test_024_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo(bar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '+' in table name
#[test]
fn test_025_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo+bar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '*' in table name
#[test]
fn test_026_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo*bar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '%' in table name
#[test]
fn test_027_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo%bar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '~' in table name
#[test]
fn test_028_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo~bar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0000' in table name
#[test]
fn test_029_u0000_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo\0bar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0001' in table name
#[test]
fn test_030_u0001_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo\u{1}bar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0002' in table name
#[test]
fn test_031_u0002_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo\u{2}bar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0003' in table name
#[test]
fn test_032_u0003_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo\u{3}bar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0004' in table name
#[test]
fn test_033_u0004_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo\u{4}bar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0005' in table name
#[test]
fn test_034_u0005_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo\u{5}bar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0006' in table name
#[test]
fn test_035_u0006_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo\u{6}bar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0007' in table name
#[test]
fn test_036_u0007_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo\u{7}bar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0008' in table name
#[test]
fn test_037_u0008_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo\u{8}bar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0009' in table name
#[test]
fn test_038_u0009_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo\tbar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u000b' in table name
#[test]
fn test_039_u000b_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo\u{b}bar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u000c' in table name
#[test]
fn test_040_u000c_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo\u{c}bar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u000e' in table name
#[test]
fn test_041_u000e_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo\u{e}bar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u000f' in table name
#[test]
fn test_042_u000f_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo\u{f}bar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u007f' in table name
#[test]
fn test_043_u007f_in_table_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("foo\u{7f}bar")?
            .column_str("a_col", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '\n' in symbol name
#[test]
fn test_044_n_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo\nbar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '\r,' in symbol name
#[test]
fn test_045_r_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo\rbar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '?' in symbol name
#[test]
fn test_046_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo?bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '.' in symbol name
#[test]
fn test_047_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foobar.", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// ',' in symbol name
#[test]
fn test_048_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo,bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// ''' in symbol name
#[test]
fn test_049_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo'bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '"' in symbol name
#[test]
fn test_050_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo\"bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '\' in symbol name
#[test]
fn test_051_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo\\bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '/' in symbol name
#[test]
fn test_052_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo/bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// ':' in symbol name
#[test]
fn test_053_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo:bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// ')' in symbol name
#[test]
fn test_054_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo)bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '(' in symbol name
#[test]
fn test_055_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo(bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '+' in symbol name
#[test]
fn test_056_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo+bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '-' in symbol name
#[test]
fn test_057_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo-bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '*' in symbol name
#[test]
fn test_058_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo*bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '%' in symbol name
#[test]
fn test_059_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo%bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '~' in symbol name
#[test]
fn test_060_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo~bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0000' in symbol name
#[test]
fn test_061_u0000_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo\0bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0001' in symbol name
#[test]
fn test_062_u0001_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo\u{1}bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0002' in symbol name
#[test]
fn test_063_u0002_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo\u{2}bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0003' in symbol name
#[test]
fn test_064_u0003_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo\u{3}bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0004' in symbol name
#[test]
fn test_065_u0004_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo\u{4}bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0005' in symbol name
#[test]
fn test_066_u0005_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo\u{5}bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0006' in symbol name
#[test]
fn test_067_u0006_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo\u{6}bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0007' in symbol name
#[test]
fn test_068_u0007_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo\u{7}bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0008' in symbol name
#[test]
fn test_069_u0008_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo\u{8}bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0009' in symbol name
#[test]
fn test_070_u0009_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo\tbar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u000b' in symbol name
#[test]
fn test_071_u000b_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo\u{b}bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u000c' in symbol name
#[test]
fn test_072_u000c_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo\u{c}bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u000e' in symbol name
#[test]
fn test_073_u000e_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo\u{e}bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u000f' in symbol name
#[test]
fn test_074_u000f_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo\u{f}bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u007f' in symbol name
#[test]
fn test_075_u007f_in_symbol_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .symbol("foo\u{7f}bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '\n' in column name
#[test]
fn test_076_n_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo\nbar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '\r,' in column name
#[test]
fn test_077_r_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo\rbar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '?' in column name
#[test]
fn test_078_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo?bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '.' in column name
#[test]
fn test_079_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foobar.", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// ',' in column name
#[test]
fn test_080_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo,bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// ''' in column name
#[test]
fn test_081_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo'bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '"' in column name
#[test]
fn test_082_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo\"bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '\' in column name
#[test]
fn test_083_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo\\bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '/' in column name
#[test]
fn test_084_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo/bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// ':' in column name
#[test]
fn test_085_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo:bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// ')' in column name
#[test]
fn test_086_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo)bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '(' in column name
#[test]
fn test_087_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo(bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '+' in column name
#[test]
fn test_088_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo+bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '-' in column name
#[test]
fn test_089_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo-bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '*' in column name
#[test]
fn test_090_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo*bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '%' in column name
#[test]
fn test_091_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo%bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// '~' in column name
#[test]
fn test_092_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo~bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0000' in column name
#[test]
fn test_093_u0000_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo\0bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0001' in column name
#[test]
fn test_094_u0001_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo\u{1}bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0002' in column name
#[test]
fn test_095_u0002_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo\u{2}bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0003' in column name
#[test]
fn test_096_u0003_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo\u{3}bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0004' in column name
#[test]
fn test_097_u0004_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo\u{4}bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0005' in column name
#[test]
fn test_098_u0005_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo\u{5}bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0006' in column name
#[test]
fn test_099_u0006_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo\u{6}bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0007' in column name
#[test]
fn test_100_u0007_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo\u{7}bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0008' in column name
#[test]
fn test_101_u0008_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo\u{8}bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u0009' in column name
#[test]
fn test_102_u0009_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo\tbar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u000b' in column name
#[test]
fn test_103_u000b_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo\u{b}bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u000c' in column name
#[test]
fn test_104_u000c_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo\u{c}bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u000e' in column name
#[test]
fn test_105_u000e_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo\u{e}bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u000f' in column name
#[test]
fn test_106_u000f_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo\u{f}bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
/// 'u007f' in column name
#[test]
fn test_107_u007f_in_column_name() -> TestResult {
    let mut buffer = LineSenderBuffer::new();
    || -> Result<()> {
        buffer
            .table("test_table")?
            .column_str("foo\u{7f}bar", "42")?
            .at_now()?;
        Ok(())
    }().unwrap_err();
    Ok(())
}
