"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomActionRegistration = void 0;
const codepipeline = require("@aws-cdk/aws-codepipeline");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_1 = require("@aws-cdk/core");
/**
 * The resource representing registering a custom Action with CodePipeline.
 * For the Action to be usable, it has to be registered for every region and every account it's used in.
 * In addition to this class, you should most likely also provide your clients a class
 * representing your custom Action, extending the Action class,
 * and taking the `actionProperties` as properly typed, construction properties.
 */
class CustomActionRegistration extends core_1.Construct {
    constructor(parent, id, props) {
        var _a;
        super(parent, id);
        new codepipeline.CfnCustomActionType(this, 'Resource', {
            category: props.category,
            inputArtifactDetails: {
                minimumCount: props.artifactBounds.minInputs,
                maximumCount: props.artifactBounds.maxInputs,
            },
            outputArtifactDetails: {
                minimumCount: props.artifactBounds.minOutputs,
                maximumCount: props.artifactBounds.maxOutputs,
            },
            provider: props.provider,
            version: props.version || '1',
            settings: {
                entityUrlTemplate: props.entityUrl,
                executionUrlTemplate: props.executionUrl,
            },
            configurationProperties: (_a = props.actionProperties) === null || _a === void 0 ? void 0 : _a.map((ap) => {
                return {
                    key: ap.key || false,
                    secret: ap.secret || false,
                    ...ap,
                };
            }),
        });
    }
}
exports.CustomActionRegistration = CustomActionRegistration;
//# sourceMappingURL=data:application/json;base64,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