/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.types;

import com.datapps.linkoopdb.jdbc.ColumnSchema;
import com.datapps.linkoopdb.jdbc.LdbSqlNameManager;
import com.datapps.linkoopdb.jdbc.lib.HashMappedList;
import com.datapps.linkoopdb.jdbc.types.TableType;
import com.datapps.linkoopdb.jdbc.types.Type;

public class ModelType
extends TableType {
    public static final HashMappedList MODEL_COLUMNS = new HashMappedList();
    public static final Type[] MODEL_COL_TYPES = new Type[]{Type.SQL_VARCHAR_DEFAULT, Type.SQL_VARCHAR_DEFAULT, Type.SQL_VARCHAR_DEFAULT};
    private String algorithm;

    public ModelType() {
        this("unknown");
    }

    public ModelType(String algorithm) {
        super(115, MODEL_COLUMNS, MODEL_COL_TYPES);
        this.algorithm = algorithm;
    }

    @Override
    public String getDefinition() {
        return "MODEL(" + this.algorithm + ")";
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public boolean canBeAssignedFrom(Type otherType) {
        return otherType.typeCode == 115 && this.algorithm.equalsIgnoreCase(((ModelType)otherType).algorithm) || otherType.typeCode == 0;
    }

    static {
        MODEL_COLUMNS.add("NAME", new ColumnSchema(LdbSqlNameManager.newSystemObjectName("NAME", 9), Type.SQL_VARCHAR_DEFAULT));
        MODEL_COLUMNS.add("VALUE", new ColumnSchema(LdbSqlNameManager.newSystemObjectName("VALUE", 9), Type.SQL_VARCHAR_DEFAULT));
        MODEL_COLUMNS.add("DOC", new ColumnSchema(LdbSqlNameManager.newSystemObjectName("DOC", 9), Type.SQL_VARCHAR_DEFAULT));
    }
}

