/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.proxy;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import oracle.jdbc.proxy.AnnotationsRegistry;
import oracle.jdbc.proxy.ClassGenerator;
import oracle.jdbc.proxy.GeneratedProxiesRegistry;
import oracle.jdbc.proxy.ProxyFactory;

public class ProxyExport {
    public static void main(String[] stringArray) throws ClassNotFoundException, IOException {
        if (stringArray.length <= 4 || !"-p".equals(stringArray[0]) || !"-d".equals(stringArray[2])) {
            System.out.println("Usage:");
            System.out.println("java -classpath ojdbc6.jar oracle.jdbc.proxy.ProxyExport -p <package> -d <dir> class1 class2 class3 ...");
            System.out.println("  package - package to define generated proxies in");
            System.out.println("  dir - directory to store exported proxy classes");
            System.out.println("  class1 class2 class3 ... - superclasses annotated with @ProxyFor annotation");
            return;
        }
        String string = stringArray[1];
        String string2 = stringArray[3];
        ArrayList arrayList = new ArrayList();
        for (int i2 = 4; i2 < stringArray.length; ++i2) {
            arrayList.add(Class.forName(stringArray[i2]));
        }
        ProxyFactory proxyFactory = ProxyFactory.createProxyFactory(string, arrayList.toArray(new Class[0]));
        AnnotationsRegistry annotationsRegistry = proxyFactory.annotationsRegistry;
        for (AnnotationsRegistry.Value value : annotationsRegistry.values()) {
            Class clazz = value.getSuperclass();
            for (Class clazz2 : value.getIfacesToProxy()) {
                Object object;
                GeneratedProxiesRegistry.Key key = new GeneratedProxiesRegistry.Key(string, clazz2, clazz);
                byte[] byArray = ClassGenerator.generateBytecode(string, key, proxyFactory.annotationsRegistry);
                String string3 = key.makePathname();
                int n2 = string3.lastIndexOf(File.separator);
                if (-1 != n2) {
                    object = string3.substring(0, n2);
                    new File(string2 + File.separator + (String)object).mkdirs();
                }
                object = new BufferedOutputStream(new FileOutputStream(string2 + File.separator + string3));
                ((FilterOutputStream)object).write(byArray);
                ((FilterOutputStream)object).close();
            }
        }
    }
}

