import * as lambda from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
import { BundlingOptions } from './types';
/**
 * (experimental) Properties for PythonLayerVersion.
 *
 * @experimental
 */
export interface PythonLayerVersionProps extends lambda.LayerVersionOptions {
    /**
     * (experimental) The path to the root directory of the lambda layer.
     *
     * @experimental
     */
    readonly entry: string;
    /**
     * (experimental) The runtimes compatible with the python layer.
     *
     * @default - Only Python 3.7 is supported.
     * @experimental
     */
    readonly compatibleRuntimes?: lambda.Runtime[];
    /**
     * (experimental) The system architectures compatible with this layer.
     *
     * @default [Architecture.X86_64]
     * @experimental
     */
    readonly compatibleArchitectures?: lambda.Architecture[];
    /**
     * (experimental) Bundling options to use for this function.
     *
     * Use this to specify custom bundling options like
     * the bundling Docker image, asset hash type, custom hash, architecture, etc.
     *
     * @default - Use the default bundling Docker image, with x86_64 architecture.
     * @experimental
     */
    readonly bundling?: BundlingOptions;
}
/**
 * (experimental) A lambda layer version.
 *
 * @experimental
 */
export declare class PythonLayerVersion extends lambda.LayerVersion {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: PythonLayerVersionProps);
}
