/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.tools;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TestToolBase {
    public static boolean isTestMode;
    public static final String MASK_HOST_PORT_PRE = "X";
    Set<String> testCantPingNodeId = new HashSet<String>();
    Map<String, String> testCantReadWriteNodeId = new HashMap<String, String>();
    protected static TestToolBase testTool;

    public static TestToolBase getInstance() {
        return testTool;
    }

    public static void setTestMode(boolean testMode) {
        isTestMode = testMode;
    }

    public void clear() {
        this.testCantPingNodeId.clear();
        this.testCantReadWriteNodeId.clear();
    }

    public boolean cantPing(String nodeId) {
        return isTestMode ? this.testCantPingNodeId.contains(nodeId) : false;
    }

    public boolean cantReadWrite(String nodeId) {
        return isTestMode ? this.testCantReadWriteNodeId.containsKey(nodeId) : false;
    }

    public void addCantPingNodeId(String nodeId) {
        this.testCantPingNodeId.add(nodeId);
    }

    public void clearCantPingNodeId() {
        this.testCantPingNodeId.clear();
    }

    public void addCantReadWriteNodeId(String nodeId, String hostAndPort) {
        this.testCantReadWriteNodeId.put(nodeId, hostAndPort);
    }

    public void clearCantReadWriteNodeId() {
        this.testCantReadWriteNodeId.clear();
    }

    public Set<String> allCantReadWriteHostAndPort() {
        return new HashSet<String>(this.testCantReadWriteNodeId.values());
    }

    public String tryClearStorageNodeHostAndPort(String hostAndPort) {
        if (isTestMode && hostAndPort.startsWith(MASK_HOST_PORT_PRE)) {
            hostAndPort = hostAndPort.substring(1);
        }
        return hostAndPort;
    }

    public String maskHostOrDomainForNodeId(String nodeId, String host) {
        return this.testCantReadWriteNodeId.containsKey(nodeId) ? MASK_HOST_PORT_PRE + host : host;
    }

    public String maskStorageNodeHostAndPort(String hostAndPort) {
        return this.maskStorageNodeHostAndPorts(Collections.singleton(hostAndPort)).iterator().next();
    }

    public Set<String> maskStorageNodeHostAndPorts(Set<String> hostAndPorts) {
        HashSet<String> newHostAndPorts = new HashSet<String>();
        if (isTestMode) {
            for (String hostAndPort : hostAndPorts) {
                if (hostAndPort.startsWith(MASK_HOST_PORT_PRE)) {
                    hostAndPort = hostAndPort.replaceFirst(MASK_HOST_PORT_PRE, "");
                }
                hostAndPort = this.allCantReadWriteHostAndPort().contains(hostAndPort) ? MASK_HOST_PORT_PRE + hostAndPort : hostAndPort;
                newHostAndPorts.add(hostAndPort);
            }
        } else {
            newHostAndPorts.addAll(hostAndPorts);
        }
        return newHostAndPorts;
    }

    public Set<String> filterNodeIds(Set<String> nodeIds) {
        HashSet<String> newNodeIds = new HashSet<String>();
        if (isTestMode) {
            for (String nodeId : nodeIds) {
                if (this.cantPing(nodeId) || this.allCantReadWriteHostAndPort().contains(nodeId)) continue;
                newNodeIds.add(nodeId);
            }
        } else {
            newNodeIds.addAll(nodeIds);
        }
        return newNodeIds;
    }

    static {
        testTool = null;
    }
}

