/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLXML;
import oracle.jdbc.LargeObjectAccessMode;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleClob;
import oracle.jdbc.driver.OracleNClob;
import oracle.jdbc.internal.OracleConcreteProxy;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableClob;
import oracle.jdbc.replay.driver.TxnReplayableConnection;
import oracle.jdbc.replay.driver.TxnReplayableNClob;
import oracle.sql.ClobDBAccess;
import oracle.sql.ConcreteProxyUtil;
import oracle.sql.DatumWithConnection;
import oracle.xdb.XMLType;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.LOB_DATUM})
public class CLOB
extends DatumWithConnection
implements oracle.jdbc.internal.OracleClob,
OracleConcreteProxy {
    public static final int MAX_CHUNK_SIZE = 32768;
    public static final int DURATION_INVALID = -1;
    public static final int DURATION_SESSION = 10;
    public static final int DURATION_CALL = 12;
    public static final int OLD_WRONG_DURATION_SESSION = 1;
    public static final int OLD_WRONG_DURATION_CALL = 2;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    protected OracleClob target = null;
    private oracle.jdbc.internal.OracleClob ojiOracleClob = null;

    protected CLOB() {
        OracleClob oracleClob = new OracleClob();
        this.setTarget(null, oracleClob, null, (short)1, false);
    }

    protected CLOB(OracleClob oracleClob) {
        this.setTarget(null, oracleClob, null, (short)1, false);
    }

    public OracleClob getTarget() {
        return this.target;
    }

    private void setTarget(oracle.jdbc.OracleConnection oracleConnection, OracleClob oracleClob, byte[] byArray, short s2, boolean bl) {
        Class clazz = s2 == 2 ? TxnReplayableNClob.class : TxnReplayableClob.class;
        this.ojiOracleClob = ConcreteProxyUtil.getProxyObject(oracleConnection, oracleClob, clazz, this);
        this.target = oracleClob;
        this.setShareBytes(this.target.shareBytes());
        this.targetDatumWithConnection = this.target;
        this.targetDatum = this.target;
        if (this.ojiOracleClob != null) {
            try {
                Object object = ConcreteProxyUtil.checkAndGetACProxyConnection(oracleConnection);
                if (object != null && bl) {
                    ((TxnReplayableConnection)object).CLOBConstructorRecording(byArray, s2, this);
                }
            }
            catch (SQLException sQLException) {
            }
            this.ojiOracleDatumWithConnection = this.ojiOracleClob;
        } else {
            this.ojiOracleClob = this.target;
        }
    }

    @Override
    public TxnReplayableBase getConcreteProxy() {
        if (this.ojiOracleClob instanceof TxnReplayableBase) {
            return (TxnReplayableBase)((Object)this.ojiOracleClob);
        }
        return null;
    }

    public CLOB(oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        this(oracleConnection, null);
    }

    public CLOB(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray, boolean bl) throws SQLException {
        this(oracleConnection, byArray);
        this.target.setFromobject(bl);
    }

    public static final short getFormOfUseFromLocator(byte[] byArray) {
        int n2 = -1;
        if (byArray != null && byArray.length > 5) {
            n2 = (byArray[5] & 0x40) != 0 && (byArray[5] & 0xFFFFFF80) == 0 ? 2 : 1;
        }
        return (short)n2;
    }

    public CLOB(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray) throws SQLException {
        oracle.jdbc.OracleConnection oracleConnection2 = null;
        short s2 = 1;
        oracleConnection2 = ConcreteProxyUtil.getThinDriverReplayableConnectionDelegate(oracleConnection);
        if (oracleConnection2 != null) {
            oracleConnection = oracleConnection2;
        }
        if (byArray != null) {
            s2 = CLOB.getFormOfUseFromLocator(byArray);
        }
        OracleClob oracleClob = s2 == 2 ? new OracleNClob(oracleConnection, byArray) : new OracleClob(oracleConnection, byArray);
        this.setTarget(oracleConnection, oracleClob, byArray, oracleClob.getCsform(), oracleConnection2 != null);
    }

    public CLOB(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray, short s2) throws SQLException {
        this(oracleConnection, byArray);
        this.target.setCsform(s2);
    }

    @Override
    public boolean isNCLOB() {
        return this.ojiOracleClob.isNCLOB();
    }

    @Override
    public long length() throws SQLException {
        return this.ojiOracleClob.length();
    }

    @Override
    public String getSubString(long l2, int n2) throws SQLException {
        return this.ojiOracleClob.getSubString(l2, n2);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return this.ojiOracleClob.getCharacterStream();
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return this.ojiOracleClob.getAsciiStream();
    }

    public InputStream getAsciiStream(boolean bl) throws SQLException {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        return this.target.getAsciiStream(bl);
    }

    @Override
    public long position(String string, long l2) throws SQLException {
        return this.ojiOracleClob.position(string, l2);
    }

    @Override
    public long position(Clob clob, long l2) throws SQLException {
        return this.ojiOracleClob.position(clob, l2);
    }

    @Override
    public int getChars(long l2, int n2, char[] cArray) throws SQLException {
        return this.ojiOracleClob.getChars(l2, n2, cArray);
    }

    @Override
    public Writer getCharacterOutputStream() throws SQLException {
        return this.ojiOracleClob.getCharacterOutputStream();
    }

    @Override
    public OutputStream getAsciiOutputStream() throws SQLException {
        return this.ojiOracleClob.getAsciiOutputStream();
    }

    @Override
    public byte[] getLocator() {
        return this.ojiOracleClob.getLocator();
    }

    @Override
    public void setLocator(byte[] byArray) {
        this.ojiOracleClob.setLocator(byArray);
    }

    @Override
    public int putChars(long l2, char[] cArray) throws SQLException {
        return this.ojiOracleClob.putChars(l2, cArray);
    }

    public int putChars(long l2, char[] cArray, int n2) throws SQLException {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        return this.target.putChars(l2, cArray, n2);
    }

    @Override
    public int putChars(long l2, char[] cArray, int n2, int n3) throws SQLException {
        return this.ojiOracleClob.putChars(l2, cArray, n2, n3);
    }

    @Override
    public int putString(long l2, String string) throws SQLException {
        return this.ojiOracleClob.putString(l2, string);
    }

    @Override
    public int getChunkSize() throws SQLException {
        return this.ojiOracleClob.getChunkSize();
    }

    @Override
    public int getBufferSize() throws SQLException {
        return this.ojiOracleClob.getBufferSize();
    }

    public static CLOB empty_lob() throws SQLException {
        return CLOB.getEmptyCLOB();
    }

    public static CLOB getEmptyCLOB() throws SQLException {
        byte[] byArray = new byte[86];
        byArray[1] = 84;
        byArray[5] = 24;
        CLOB cLOB = new CLOB();
        cLOB.setShareBytes(byArray);
        OracleClob oracleClob = cLOB.getTarget();
        oracleClob.setShareBytes(byArray);
        return cLOB;
    }

    @Override
    public boolean isEmptyLob() throws SQLException {
        return this.ojiOracleClob.isEmptyLob();
    }

    @Override
    public boolean isSecureFile() throws SQLException {
        return this.ojiOracleClob.isSecureFile();
    }

    @Override
    public OutputStream getAsciiOutputStream(long l2) throws SQLException {
        return this.ojiOracleClob.getAsciiOutputStream(l2);
    }

    @Override
    public Writer getCharacterOutputStream(long l2) throws SQLException {
        return this.ojiOracleClob.getCharacterOutputStream(l2);
    }

    @Override
    public InputStream getAsciiStream(long l2) throws SQLException {
        return this.ojiOracleClob.getAsciiStream(l2);
    }

    @Override
    public Reader getCharacterStream(long l2) throws SQLException {
        return this.ojiOracleClob.getCharacterStream(l2);
    }

    @Override
    public void trim(long l2) throws SQLException {
        this.ojiOracleClob.trim(l2);
    }

    public static CLOB createTemporary(Connection connection, boolean bl, int n2) throws SQLException {
        return CLOB.createTemporary(connection, bl, n2, (short)1);
    }

    public static CLOB createTemporary(Connection connection, boolean bl, int n2, short s2) throws SQLException {
        int n3 = n2;
        if (n2 == 1) {
            n3 = 10;
        }
        if (n2 == 2) {
            n3 = 12;
        }
        if (connection == null || n3 != 10 && n3 != 12) {
            throw (SQLException)DatabaseError.createSqlException(68, "'conn' should not be null and 'duration' should either be equal to DURATION_SESSION or DURATION_CALL").fillInStackTrace();
        }
        OracleConnection oracleConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
        CLOB cLOB = CLOB.getDBAccess(oracleConnection).createTemporaryClob(oracleConnection, bl, n3, s2);
        if (cLOB != null) {
            OracleClob oracleClob = cLOB.getTarget();
            short s3 = CLOB.getFormOfUseFromLocator(cLOB.shareBytes());
            oracleClob.setCsform(s3);
        }
        return cLOB;
    }

    public static void freeTemporary(CLOB cLOB) throws SQLException {
        if (cLOB == null) {
            return;
        }
        cLOB.freeTemporary();
    }

    public static boolean isTemporary(CLOB cLOB) throws SQLException {
        if (cLOB == null) {
            return false;
        }
        return cLOB.isTemporary();
    }

    public static short getDuration(CLOB cLOB) throws SQLException {
        if (cLOB == null) {
            return -1;
        }
        return cLOB.getDuration();
    }

    @Override
    public void freeTemporary() throws SQLException {
        this.ojiOracleClob.freeTemporary();
    }

    @Override
    public boolean isTemporary() throws SQLException {
        return this.ojiOracleClob.isTemporary();
    }

    @Override
    public short getDuration() throws SQLException {
        return this.ojiOracleClob.getDuration();
    }

    @Override
    public void open(LargeObjectAccessMode largeObjectAccessMode) throws SQLException {
        this.ojiOracleClob.open(largeObjectAccessMode);
    }

    public void open(int n2) throws SQLException {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        this.target.open(n2);
    }

    @Override
    public void close() throws SQLException {
        this.ojiOracleClob.close();
    }

    @Override
    public boolean isOpen() throws SQLException {
        return this.ojiOracleClob.isOpen();
    }

    @Override
    public int setString(long l2, String string) throws SQLException {
        return this.ojiOracleClob.setString(l2, string);
    }

    @Override
    public int setString(long l2, String string, int n2, int n3) throws SQLException {
        return this.ojiOracleClob.setString(l2, string, n2, n3);
    }

    @Override
    public OutputStream setAsciiStream(long l2) throws SQLException {
        return this.ojiOracleClob.setAsciiStream(l2);
    }

    @Override
    public Writer setCharacterStream(long l2) throws SQLException {
        return this.ojiOracleClob.setCharacterStream(l2);
    }

    @Override
    public void truncate(long l2) throws SQLException {
        this.ojiOracleClob.truncate(l2);
    }

    @Override
    public Object toJdbc() throws SQLException {
        this.ojiOracleClob.toJdbc();
        return this;
    }

    @Override
    public boolean isConvertibleTo(Class clazz) {
        return this.ojiOracleClob.isConvertibleTo(clazz);
    }

    @Override
    public Reader characterStreamValue() throws SQLException {
        return this.ojiOracleClob.characterStreamValue();
    }

    @Override
    public InputStream asciiStreamValue() throws SQLException {
        return this.ojiOracleClob.asciiStreamValue();
    }

    @Override
    public InputStream binaryStreamValue() throws SQLException {
        return this.ojiOracleClob.binaryStreamValue();
    }

    @Override
    public String stringValue() throws SQLException {
        return this.ojiOracleClob.stringValue();
    }

    @Override
    public Object makeJdbcArray(int n2) {
        return this.ojiOracleClob.makeJdbcArray(n2);
    }

    @Override
    public ClobDBAccess getDBAccess() throws SQLException {
        return this.ojiOracleClob.getDBAccess();
    }

    public static ClobDBAccess getDBAccess(Connection connection) throws SQLException {
        return ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().createClobDBAccess();
    }

    @Override
    public Connection getJavaSqlConnection() throws SQLException {
        return this.ojiOracleClob.getJavaSqlConnection();
    }

    @Override
    public final void setLength(long l2) {
        this.ojiOracleClob.setLength(l2);
    }

    @Override
    public final void setChunkSize(int n2) {
        this.ojiOracleClob.setChunkSize(n2);
    }

    @Override
    public final void setPrefetchedData(char[] cArray) {
        this.ojiOracleClob.setPrefetchedData(cArray);
    }

    @Override
    public final void setPrefetchedData(char[] cArray, int n2) {
        this.ojiOracleClob.setPrefetchedData(cArray, n2);
    }

    @Override
    public final char[] getPrefetchedData() {
        return this.ojiOracleClob.getPrefetchedData();
    }

    @Override
    public final int getPrefetchedDataSize() {
        return this.ojiOracleClob.getPrefetchedDataSize();
    }

    @Override
    public final void setActivePrefetch(boolean bl) {
        this.ojiOracleClob.setActivePrefetch(bl);
    }

    @Override
    public final void clearCachedData() {
        this.ojiOracleClob.clearCachedData();
    }

    @Override
    public final boolean isActivePrefetch() {
        return this.ojiOracleClob.isActivePrefetch();
    }

    @Override
    public boolean canReadBasicLobDataInLocator() throws SQLException {
        return this.ojiOracleClob.canReadBasicLobDataInLocator();
    }

    @Override
    public void free() throws SQLException {
        this.ojiOracleClob.free();
    }

    @Override
    public Reader getCharacterStream(long l2, long l3) throws SQLException {
        return this.ojiOracleClob.getCharacterStream(l2, l3);
    }

    @Override
    public void setBytes(byte[] byArray) {
        this.ojiOracleClob.setBytes(byArray);
    }

    @Override
    public void setACProxy(Object object) {
        this.ojiOracleClob.setACProxy(object);
    }

    @Override
    public Object getACProxy() {
        return this.ojiOracleClob.getACProxy();
    }

    @Override
    public SQLXML toSQLXML() throws SQLException {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        return XMLType.createXML((Connection)this.getPhysicalConnection(), (CLOB)this);
    }

    @Override
    public SQLXML toSQLXML(String string) throws SQLException {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        return XMLType.createXML((Connection)this.getPhysicalConnection(), (CLOB)this, (String)string, (boolean)true, (boolean)true);
    }
}

