import { ApiObject, GroupVersionKind } from 'cdk8s';
import { Construct } from 'constructs';
import * as k8s from './imports/k8s';
export { HttpIngressPath, ListMeta, StatusDetails, StatusCause, IngressSpec, ObjectMeta, OwnerReference, IngressBackend, IngressRule, IngressTls, Initializers, ManagedFieldsEntry, HttpIngressRuleValue, Initializer, IntOrString, KubeStatusProps } from './imports/k8s';
/**
 * @experimental
 */
export interface AWSLoadBalancerControllerProps {
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     */
    readonly metadata?: k8s.ObjectMeta;
    /**
     * (experimental) Spec defines the behavior of the ingress.
     *
     * @experimental
     */
    readonly spec?: k8s.IngressSpec;
}
/**
 * @experimental
 */
export declare class AWSLoadBalancerControllerObject extends ApiObject {
    /**
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for an ingress object. https://github.com/kubernetes-sigs/aws-load-balancer-controller.
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: AWSLoadBalancerControllerProps): any;
    /**
     * (experimental) Defines an "extentions" API object for AWS Load Balancer Controller - https://github.com/kubernetes-sigs/aws-load-balancer-controller.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: AWSLoadBalancerControllerProps);
}
