# -*- coding: utf-8 -*-

##############################################################################
#  Copyright Kitware Inc.
#
#  Licensed under the Apache License, Version 2.0 ( the "License" );
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
##############################################################################

import cherrypy

from girder_large_image.girder_tilesource import GirderTileSource
from . import BioformatsFileTileSource, _stopJavabridge


cherrypy.engine.subscribe('stop', _stopJavabridge)


class BioformatsGirderTileSource(BioformatsFileTileSource, GirderTileSource):
    """
    Provides tile access to Girder items that can be read with bioformats.
    """

    cacheName = 'tilesource'
    name = 'bioformats'

    def mayHaveAdjacentFiles(self, largeImageFile):
        # bioformats uses extensions to determine how to open a file, so this
        # needs to be set for all file formats.
        return True
