"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedPlantUmlDocs = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const projen_1 = require("projen");
const utils_1 = require("../utils");
/**
 * Generates the plantuml documentation using OpenAPI Generator
 */
class GeneratedPlantUmlDocs extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    /**
     * @inheritDoc
     */
    synthesize() {
        super.synthesize();
        // Generate the plantuml docs
        utils_1.invokeOpenApiGenerator({
            generator: "plantuml",
            specPath: this.options.specPath,
            outputPath: path.join(this.project.outdir, "plantuml"),
            generatorDirectory: utils_1.NonClientGeneratorDirectory.DOCS,
        });
    }
}
exports.GeneratedPlantUmlDocs = GeneratedPlantUmlDocs;
//# sourceMappingURL=data:application/json;base64,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