"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CallApiGatewayHttpApiEndpoint = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const base_1 = require("./base");
/**
 * Call HTTP API endpoint as a Task.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-api-gateway.html
 * @stability stable
 */
class CallApiGatewayHttpApiEndpoint extends base_1.CallApiGatewayEndpointBase {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        this.apiEndpoint = this.getApiEndpoint();
        this.arnForExecuteApi = this.getArnForExecuteApi();
        this.stageName = props.stageName;
        this.taskPolicies = this.createPolicyStatements();
    }
    getApiEndpoint() {
        const apiStack = this.props.apiStack;
        return `${this.props.apiId}.execute-api.${apiStack.region}.${apiStack.urlSuffix}`;
    }
    getArnForExecuteApi() {
        const { apiId, stageName, method, apiPath } = this.props;
        return this.props.apiStack.formatArn({
            service: 'execute-api',
            resource: apiId,
            sep: '/',
            resourceName: `${stageName}/${method}${apiPath}`,
        });
    }
}
exports.CallApiGatewayHttpApiEndpoint = CallApiGatewayHttpApiEndpoint;
_a = JSII_RTTI_SYMBOL_1;
CallApiGatewayHttpApiEndpoint[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.CallApiGatewayHttpApiEndpoint", version: "1.117.0" };
//# sourceMappingURL=data:application/json;base64,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