# Generated by Django 2.2.11 on 2020-03-17 04:30

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Data',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(max_length=64)),
                ('f1', models.CharField(max_length=64)),
                ('f2', models.CharField(max_length=64)),
            ],
        ),
        migrations.CreateModel(
            name='Node',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=64, verbose_name='Title')),
                ('order', models.IntegerField(default=999, verbose_name='Order')),
                ('is_end', models.BooleanField(default=False, verbose_name='Is End Node')),
            ],
            options={
                'verbose_name': 'Simple Workflow Node',
                'verbose_name_plural': 'Simple Workflow Node',
                'ordering': ['pd', 'order', 'pk'],
            },
        ),
        migrations.CreateModel(
            name='ProcessDefinition',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64, unique=True, verbose_name='Name')),
                ('image', models.ImageField(blank=True, null=True, upload_to='django-simple-workflow/process-definitions/', verbose_name='Image')),
            ],
            options={
                'verbose_name': 'Process Definition',
                'verbose_name_plural': 'Process Definitions',
            },
        ),
        migrations.CreateModel(
            name='Role',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64, verbose_name='Name')),
                ('pd', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='roles', to='django_simple_workflow.ProcessDefinition', verbose_name='Process Definition')),
            ],
            options={
                'verbose_name': 'Simple Workflow Role',
                'verbose_name_plural': 'Simple Workflow Role',
                'unique_together': {('pd', 'name')},
            },
        ),
        migrations.CreateModel(
            name='Transition',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=64, verbose_name='Title')),
                ('order', models.IntegerField(default=999, verbose_name='Order')),
                ('end', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='ins', to='django_simple_workflow.Node', verbose_name='End Node')),
                ('pd', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='transitions', to='django_simple_workflow.ProcessDefinition', verbose_name='Process Definition')),
                ('role', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='django_simple_workflow.Role', verbose_name='Role')),
                ('start', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='outs', to='django_simple_workflow.Node', verbose_name='Start Node')),
            ],
            options={
                'verbose_name': 'Simple Workflow Transition',
                'verbose_name_plural': 'Simple Workflow Transition',
                'ordering': ['pd', 'start', 'order', 'pk'],
            },
        ),
        migrations.AddField(
            model_name='node',
            name='pd',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='nodes', to='django_simple_workflow.ProcessDefinition', verbose_name='Process Definition'),
        ),
    ]
