import re

SMPTE_NDF_REGEX = re.compile(r'^(?:-)?(?:(?:(?:(\d\d{1}):){1}([0-5]?\d):){1}([0-5]?\d):){1}(\d?\d\d{1}){1}$')
# SMPTE NDF 形如01:23:45:12或-01:23:45:12 对于高帧率（>=100fps） 形如01:01:23:45:102或-01:01:23:45:102
SMPTE_DF_REGEX = re.compile(r'^(?:-)?(?:(?:(?:(\d\d{1}):){1}([0-5]?\d):){1}([0-5]?\d);){1}(\d?\d\d{1}){1}$')
# SMPTE DF 形如01:23:45;12或-01:23:45;12 对于高帧率（>=100fps） 形如01:00:00;102或-01:00:00;102
SMPTE_REGEX = re.compile(r'^(?:-)?(?:(?:(?:(\d\d{1}):){1}([0-5]?\d):){1}([0-5]?\d);?:?){1}(\d?\d\d{1}){1}$')
# SMPTE全匹配 即SMPTE NDF与SMPTE DF的并集
SRT_REGEX = re.compile(r'^(?:-)?(?:(?:(?:(\d\d{1}):){1}([0-5]?\d):){1}([0-5]?\d),){1}(\d\d\d){1}$')
# SRT 形如01:23:45,678或-01:23:45,678
FFMPEG_REGEX = re.compile(r'^(?:-)?(?:(?:(?:(\d\d{1}):){1}([0-5]?\d):){1}([0-5]?\d)\.){1}(\d?\d+){1}$')
# FFMPEG 形如01:23:45.67或-01:23:45.67
DLP_REGEX = re.compile(r'^(?:-)?(?:(?:(?:(\d\d{1}):){1}([0-5]?\d):){1}([0-5]?\d):){1}([0-2][0-4]\d{1}){1}$')
# DLP 形如01:23:45:102或-01:23:45:102（末三位取值范围是0-249）
FCPX_REGEX = re.compile(r'^(?:-)?(\d+)[/]?(\d+)?s$')
# FCPX 形如1/24s或-1/24s s可有可无
FRAME_REGEX = re.compile(r'^(-?\d+?)f?$')
# 帧号 形如1234f或-1234f f可有可无
TIME_REGEX = re.compile(r'^(-?\d+?(\.{1})\d+?|-?\d+?)s?$')
# 时间戳 形如1234s或-1234.5s s可有可无


