import * as dynamodb from '@aws-cdk/aws-dynamodb';
import * as lambda from '@aws-cdk/aws-lambda';
import { StreamEventSource, StreamEventSourceProps } from './stream';
/**
 * @stability stable
 */
export interface DynamoEventSourceProps extends StreamEventSourceProps {
}
/**
 * Use an Amazon DynamoDB stream as an event source for AWS Lambda.
 *
 * @stability stable
 */
export declare class DynamoEventSource extends StreamEventSource {
    private readonly table;
    private _eventSourceMappingId?;
    /**
     * @stability stable
     */
    constructor(table: dynamodb.ITable, props: DynamoEventSourceProps);
    /**
     * Called by `lambda.addEventSource` to allow the event source to bind to this function.
     *
     * @stability stable
     */
    bind(target: lambda.IFunction): void;
    /**
     * The identifier for this EventSourceMapping.
     *
     * @stability stable
     */
    get eventSourceMappingId(): string;
}
