import * as lambda from '@aws-cdk/aws-lambda';
import { Duration } from '@aws-cdk/core';
/**
 * The set of properties for event sources that follow the streaming model, such as, Dynamo, Kinesis and Kafka.
 *
 * @stability stable
 */
export interface StreamEventSourceProps {
    /**
     * The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function.
     *
     * Your function receives an
     * event with all the retrieved records.
     *
     * Valid Range:
     * * Minimum value of 1
     * * Maximum value of:
     *    * 1000 for {@link DynamoEventSource}
     *    * 10000 for {@link KinesisEventSource}
     *
     * @default 100
     * @stability stable
     */
    readonly batchSize?: number;
    /**
     * If the function returns an error, split the batch in two and retry.
     *
     * @default false
     * @stability stable
     */
    readonly bisectBatchOnError?: boolean;
    /**
     * An Amazon SQS queue or Amazon SNS topic destination for discarded records.
     *
     * @default discarded records are ignored
     * @stability stable
     */
    readonly onFailure?: lambda.IEventSourceDlq;
    /**
     * The maximum age of a record that Lambda sends to a function for processing.
     *
     * Valid Range:
     * * Minimum value of 60 seconds
     * * Maximum value of 7 days
     *
     * @default - the retention period configured on the stream
     * @stability stable
     */
    readonly maxRecordAge?: Duration;
    /**
     * Maximum number of retry attempts Valid Range: * Minimum value of 0 * Maximum value of 10000.
     *
     * @default - retry until the record expires
     * @stability stable
     */
    readonly retryAttempts?: number;
    /**
     * The number of batches to process from each shard concurrently.
     *
     * Valid Range:
     * * Minimum value of 1
     * * Maximum value of 10
     *
     * @default 1
     * @stability stable
     */
    readonly parallelizationFactor?: number;
    /**
     * Where to begin consuming the stream.
     *
     * @stability stable
     */
    readonly startingPosition: lambda.StartingPosition;
    /**
     * The maximum amount of time to gather records before invoking the function.
     *
     * Maximum of Duration.minutes(5)
     *
     * @default Duration.seconds(0)
     * @stability stable
     */
    readonly maxBatchingWindow?: Duration;
    /**
     * The size of the tumbling windows to group records sent to DynamoDB or Kinesis Valid Range: 0 - 15 minutes.
     *
     * @default - None
     * @stability stable
     */
    readonly tumblingWindow?: Duration;
    /**
     * If the stream event source mapping should be enabled.
     *
     * @default true
     * @stability stable
     */
    readonly enabled?: boolean;
}
/**
 * Use an stream as an event source for AWS Lambda.
 *
 * @stability stable
 */
export declare abstract class StreamEventSource implements lambda.IEventSource {
    protected readonly props: StreamEventSourceProps;
    /**
     * @stability stable
     */
    protected constructor(props: StreamEventSourceProps);
    /**
     * Called by `lambda.addEventSource` to allow the event source to bind to this function.
     *
     * @stability stable
     */
    abstract bind(_target: lambda.IFunction): void;
    /**
     * @stability stable
     */
    protected enrichMappingOptions(options: lambda.EventSourceMappingOptions): lambda.EventSourceMappingOptions;
}
