/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.Const;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc.ConnectionFactory;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.util.ErrorAnalyzer;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.TimeZone;

public class ClientAttributesParcel
extends Parcel {
    private static final short PCLCLIATT_HOSTNAME = 7;
    private static final short PCLCLIATT_PROCTHRID = 8;
    private static final short PCLCLIATT_SYSUSERID = 9;
    private static final short PCLCLIATT_PROGNAME = 10;
    private static final short PCLCLIATT_OSNAME = 11;
    private static final short PCLCLIATT_VMNAME = 22;
    private static final short PCLCLIATT_CLIENTKIND = 28;
    private static final short PCLCLIATT_CLIENTVERSION = 29;
    private static final short PCLCLIATT_ClIENTATTRIBUTESEX = 30;
    private static final short PCLCLIATT_CLIENT_IPADDR_BY_CLIENT = 31;
    private static final short PCLCLIATT_CLIENT_PORT_BY_CLIENT = 32;
    private static final short PCLCLIATT_SERVER_IPADDR_BY_CLIENT = 33;
    private static final short PCLCLIATT_SERVER_PORT_BY_CLIENT = 34;
    private static final short PCLCLIATT_COP_SUFFIXED_HOST_NAME = 45;
    private static final short PCLCLIATT_END = Short.MAX_VALUE;

    public ClientAttributesParcel(GenericTeradataConnection genericTeradataConnection) throws SQLException {
        super(genericTeradataConnection);
        Object object;
        byte by = genericTeradataConnection.getTdSessionCharSetCode();
        TDNetworkIOIF tDNetworkIOIF = genericTeradataConnection.getIO();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            object = tDNetworkIOIF.getOriginalHostName() + (genericTeradataConnection.getConfigResponse().areUnityClientAttributesSupported() ? "" : ";" + tDNetworkIOIF.getRemoteAddress() + ":" + tDNetworkIOIF.getRemotePort());
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)7, (String)object);
            long l = System.currentTimeMillis();
            String string = ClientAttributesParcel.getJVMProcessID();
            if (this.log.isTimingEnabled()) {
                this.log.timing("getJVMProcessID " + string + " took " + (System.currentTimeMillis() - l) + " ms");
            }
            if (string != null) {
                ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)8, string);
            }
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)9, System.getProperty("user.name"));
            String string2 = ClientAttributesParcel.getJavaProgramName();
            if (string2 != null) {
                ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)10, string2);
            }
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)11, System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
            String string3 = System.getProperty("java.vm.info");
            if (string3 != null) {
                string3 = string3.replaceAll("\\s+", " ").trim();
            }
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)22, System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + " " + string3);
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)28, "J");
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)29, Const.DRIVER_VERSION);
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)30, "JAVA=" + System.getProperty("java.version") + ";MEM=" + Runtime.getRuntime().maxMemory() + ";TZ=" + TDPreparedStatement.formatTimeZone(TimeZone.getDefault()) + ";CID=" + tDNetworkIOIF.getConnectionID() + ";TYPE=" + genericTeradataConnection.getURLParameters().getType() + ";GOV=" + (genericTeradataConnection.getURLParameters().isGoverned() ? "Y" : "N") + ";SCS=" + genericTeradataConnection.getURLParameters().getCharSet() + ";CCS=" + genericTeradataConnection.getCharsetInfo().getClientCharsetNameForClientAttributes() + ";LOB=" + (genericTeradataConnection.isLobSupported() ? "Y" : "N") + ";SIP=" + (genericTeradataConnection.isStatementInfoSupported() ? "Y" : "N") + ";TM=" + (genericTeradataConnection.isAnsiMode() ? "A" : "T") + ";ENC=" + (genericTeradataConnection.getEncryptData() ? "Y" : "N") + ";SE=" + (genericTeradataConnection.isStrictEncode() ? "Y" : "N") + ";RED=" + genericTeradataConnection.desiredRedriveLevel() + "," + genericTeradataConnection.databaseCapableOfRedriveLevel() + ";");
            if (genericTeradataConnection.getConfigResponse().areUnityClientAttributesSupported()) {
                boolean bl;
                ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)31, tDNetworkIOIF.getLocalAddress().getHostAddress());
                dataOutputStream.writeShort(32);
                dataOutputStream.writeShort(2);
                dataOutputStream.writeShort(tDNetworkIOIF.getLocalPort());
                ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)33, tDNetworkIOIF.getRemoteAddress().getHostAddress());
                dataOutputStream.writeShort(34);
                dataOutputStream.writeShort(2);
                dataOutputStream.writeShort(tDNetworkIOIF.getRemotePort());
                boolean bl2 = bl = !tDNetworkIOIF.getRemoteAddress().toString().startsWith("/");
                if (bl) {
                    ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)45, tDNetworkIOIF.getRemoteAddress().getHostName());
                }
            }
            dataOutputStream.writeShort(Short.MAX_VALUE);
            dataOutputStream.writeShort(0);
        }
        catch (IOException iOException) {
            throw ErrorAnalyzer.analyzeIoError("ClientAttributesParcel construction", tDNetworkIOIF, iOException, false, false);
        }
        object = byteArrayOutputStream.toByteArray();
        this.setFlavor((short)189);
        this.setLength(this.headerLength() + ((Object)object).length);
        this.createBuffer(this.getLength());
        this.parcelHeaderToStream();
        this.buffer.put((byte[])object);
        this.buffer.rewind();
    }

    public TDPacketStream toStream() throws SQLException {
        return this.buffer;
    }

    private static void serializeStringAttribute(DataOutputStream dataOutputStream, byte by, GenericTeradataConnection genericTeradataConnection, short s, String string) throws SQLException, IOException {
        if (string == null) {
            return;
        }
        if (string.length() > 500) {
            string = string.substring(500);
        }
        byte[] byArray = Encoder.encodeStringReplace(genericTeradataConnection, string);
        dataOutputStream.writeShort(s);
        dataOutputStream.writeShort(1 + byArray.length);
        dataOutputStream.writeByte(by);
        dataOutputStream.write(byArray);
    }

    public static String getJVMProcessID() {
        Object object;
        Object object2;
        GenericDeclaration genericDeclaration;
        Method method;
        Class<?> clazz;
        if (ConnectionFactory.JAVA_VERSION >= 9000) {
            try {
                clazz = Class.forName("java.lang.ProcessHandle");
                method = clazz.getMethod("current", null);
                genericDeclaration = clazz.getMethod("pid", null);
                object2 = method.invoke(null, (Object[])null);
                object = ((Method)genericDeclaration).invoke(object2, null);
                if (object instanceof Long) {
                    return object.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            clazz = Class.forName("java.lang.management.ManagementFactory");
            method = clazz.getMethod("getRuntimeMXBean", null);
            genericDeclaration = Class.forName("java.lang.management.RuntimeMXBean");
            object2 = ((Class)genericDeclaration).getMethod("getName", null);
            object = method.invoke(null, (Object[])null);
            Object object3 = ((Method)object2).invoke(object, (Object[])null);
            if (object3 instanceof String) {
                return (String)object3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getJavaProgramName() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        String string = null;
        if (stackTraceElementArray != null) {
            for (int i = stackTraceElementArray.length - 1; i >= 0; --i) {
                String string2;
                String string3 = string2 = stackTraceElementArray[i] != null ? stackTraceElementArray[i].toString() : null;
                if (string2 == null) continue;
                if (!string2.startsWith("java.")) {
                    string = string2;
                    break;
                }
                if (string != null) continue;
                string = string2;
            }
        }
        return string;
    }
}

