/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.util;

import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.sql.SQLException;

public class ErrorAnalyzer {
    private ErrorAnalyzer() {
    }

    public static SQLException analyzeError(SQLException sQLException) {
        SQLException sQLException2 = null;
        switch (sQLException.getErrorCode()) {
            case 3110: {
                sQLException2 = ErrorFactory.makeDriverJDBCException("TJ057");
                break;
            }
            default: {
                sQLException2 = sQLException;
            }
        }
        return sQLException2;
    }

    public static SQLException analyzeIoError(String string, TDNetworkIOIF tDNetworkIOIF, Throwable throwable, boolean bl, boolean bl2) {
        boolean bl3;
        if (throwable instanceof SQLException) {
            return (SQLException)throwable;
        }
        boolean bl4 = bl3 = throwable instanceof InterruptedIOException || throwable instanceof IOException && throwable.getMessage().toUpperCase().indexOf("TIMED OUT") >= 0;
        String string2 = bl2 ? (bl3 ? "TJ159" : "TJ164") : (bl3 ? "TJ590" : "TJ300");
        boolean bl5 = !bl2 || !bl3;
        return ErrorFactory.makeIoJDBCException(string2, string, tDNetworkIOIF, throwable, bl ? null : tDNetworkIOIF.getLog(), bl5);
    }

    public static SQLException analyzeInterrupt(int n, Throwable throwable) {
        SQLException sQLException = ErrorFactory.makeDriverJDBCException(n == 11 ? "TJ057" : "TJ626");
        sQLException.initCause(throwable);
        return sQLException;
    }

    public static boolean warningIsReallyError(int n) {
        switch (n) {
            case 5526: 
            case 5603: 
            case 7980: {
                return true;
            }
        }
        return false;
    }
}

