# Generated by Django 2.2.12 on 2020-07-21 07:56

from typing import List
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = []  # type: List[str]

    operations = [
        migrations.CreateModel(
            name="Export",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                ("started", models.DateTimeField(null=True)),
                ("completed", models.DateTimeField(null=True)),
                ("export_type", models.CharField(max_length=256)),
                ("priority", models.SmallIntegerField(db_index=True, default=1)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("QUEUED", "QUEUED"),
                            ("RUNNING", "RUNNING"),
                            ("COMPLETE", "COMPLETE"),
                            ("FAILED", "FAILED"),
                        ],
                        db_index=True,
                        default="QUEUED",
                        max_length=24,
                    ),
                ),
                ("status_detail", models.CharField(max_length=2048, null=True)),
                ("result_reference", models.CharField(max_length=2048, null=True)),
                (
                    "export_params",
                    django.contrib.postgres.fields.jsonb.JSONField(null=True),
                ),
            ],
            options={"ordering": ["created"],},
        ),
    ]
