# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from properly_model_python.search_models.models.base_model_ import Model
from properly_model_python.search_models import util
from properly_model_python.search_models.models.lat_lng_bounds import LatLngBounds


class Search(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(
        self,
        id: str = None,
        search_hash: str = None,
        last_run_millis: int = None,
        properly_city_code: str = None,
        cities: List[str] = None,
        neighbourhoods: List[str] = None,
        neighbourhoods_v2: List[object] = None,
        addresses: List[str] = None,
        building_types: List[str] = None,
        min_price: int = None,
        max_price: int = None,
        min_beds: int = None,
        min_baths: int = None,
        min_parking: int = None,
        min_square_foot: int = None,
        max_square_foot: int = None,
        geohash6_areas: List[str] = None,
        bounds: LatLngBounds = None,
    ):  # noqa: E501
        """Search - a model defined in Swagger

        :param id: The id of this Search.  # noqa: E501
        :type id: str
        :param search_hash: The search_hash of this Search.  # noqa: E501
        :type search_hash: str
        :param last_run_millis: The last_run_millis of this Search.  # noqa: E501
        :type last_run_millis: int
        :param properly_city_code: The properly_city_code of this Search.  # noqa: E501
        :type properly_city_code: str
        :param cities: The cities of this Search.  # noqa: E501
        :type cities: List[str]
        :param neighbourhoods: The neighbourhoods of this Search.  # noqa: E501
        :type neighbourhoods: List[str]
        :param neighbourhoods_v2: The neighbourhoods_v2 of this Search.  # noqa: E501
        :type neighbourhoods_v2: List[object]
        :param addresses: The addresses of this Search.  # noqa: E501
        :type addresses: List[str]
        :param building_types: The building_types of this Search.  # noqa: E501
        :type building_types: List[str]
        :param min_price: The min_price of this Search.  # noqa: E501
        :type min_price: int
        :param max_price: The max_price of this Search.  # noqa: E501
        :type max_price: int
        :param min_beds: The min_beds of this Search.  # noqa: E501
        :type min_beds: int
        :param min_baths: The min_baths of this Search.  # noqa: E501
        :type min_baths: int
        :param min_parking: The min_parking of this Search.  # noqa: E501
        :type min_parking: int
        :param min_square_foot: The min_square_foot of this Search.  # noqa: E501
        :type min_square_foot: int
        :param max_square_foot: The max_square_foot of this Search.  # noqa: E501
        :type max_square_foot: int
        :param geohash6_areas: The geohash6_areas of this Search.  # noqa: E501
        :type geohash6_areas: List[str]
        :param bounds: The bounds of this Search.  # noqa: E501
        :type bounds: LatLngBounds
        """
        self.swagger_types = {
            "id": str,
            "search_hash": str,
            "last_run_millis": int,
            "properly_city_code": str,
            "cities": List[str],
            "neighbourhoods": List[str],
            "neighbourhoods_v2": List[object],
            "addresses": List[str],
            "building_types": List[str],
            "min_price": int,
            "max_price": int,
            "min_beds": int,
            "min_baths": int,
            "min_parking": int,
            "min_square_foot": int,
            "max_square_foot": int,
            "geohash6_areas": List[str],
            "bounds": LatLngBounds,
        }

        self.attribute_map = {
            "id": "id",
            "search_hash": "searchHash",
            "last_run_millis": "lastRunMillis",
            "properly_city_code": "properlyCityCode",
            "cities": "cities",
            "neighbourhoods": "neighbourhoods",
            "neighbourhoods_v2": "neighbourhoods_v2",
            "addresses": "addresses",
            "building_types": "buildingTypes",
            "min_price": "minPrice",
            "max_price": "maxPrice",
            "min_beds": "minBeds",
            "min_baths": "minBaths",
            "min_parking": "minParking",
            "min_square_foot": "minSquareFoot",
            "max_square_foot": "maxSquareFoot",
            "geohash6_areas": "geohash6Areas",
            "bounds": "bounds",
        }

        self._id = id
        self._search_hash = search_hash
        self._last_run_millis = last_run_millis
        self._properly_city_code = properly_city_code
        self._cities = cities
        self._neighbourhoods = neighbourhoods
        self._neighbourhoods_v2 = neighbourhoods_v2
        self._addresses = addresses
        self._building_types = building_types
        self._min_price = min_price
        self._max_price = max_price
        self._min_beds = min_beds
        self._min_baths = min_baths
        self._min_parking = min_parking
        self._min_square_foot = min_square_foot
        self._max_square_foot = max_square_foot
        self._geohash6_areas = geohash6_areas
        self._bounds = bounds

    @classmethod
    def from_dict(cls, dikt) -> "Search":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Search of this Search.  # noqa: E501
        :rtype: Search
        """
        return util.deserialize_model(dikt, cls)

    @property
    def id(self) -> str:
        """Gets the id of this Search.

        unique id for this search definition  # noqa: E501

        :return: The id of this Search.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str):
        """Sets the id of this Search.

        unique id for this search definition  # noqa: E501

        :param id: The id of this Search.
        :type id: str
        """

        self._id = id

    @property
    def search_hash(self) -> str:
        """Gets the search_hash of this Search.

        proposed as base64urlsafeof(sha512of(jsonstringof(sorted(searchparms))))  # noqa: E501

        :return: The search_hash of this Search.
        :rtype: str
        """
        return self._search_hash

    @search_hash.setter
    def search_hash(self, search_hash: str):
        """Sets the search_hash of this Search.

        proposed as base64urlsafeof(sha512of(jsonstringof(sorted(searchparms))))  # noqa: E501

        :param search_hash: The search_hash of this Search.
        :type search_hash: str
        """

        self._search_hash = search_hash

    @property
    def last_run_millis(self) -> int:
        """Gets the last_run_millis of this Search.


        :return: The last_run_millis of this Search.
        :rtype: int
        """
        return self._last_run_millis

    @last_run_millis.setter
    def last_run_millis(self, last_run_millis: int):
        """Sets the last_run_millis of this Search.


        :param last_run_millis: The last_run_millis of this Search.
        :type last_run_millis: int
        """

        self._last_run_millis = last_run_millis

    @property
    def properly_city_code(self) -> str:
        """Gets the properly_city_code of this Search.

        scoping qualifier for other strings like neighbourhood.  # noqa: E501

        :return: The properly_city_code of this Search.
        :rtype: str
        """
        return self._properly_city_code

    @properly_city_code.setter
    def properly_city_code(self, properly_city_code: str):
        """Sets the properly_city_code of this Search.

        scoping qualifier for other strings like neighbourhood.  # noqa: E501

        :param properly_city_code: The properly_city_code of this Search.
        :type properly_city_code: str
        """

        self._properly_city_code = properly_city_code

    @property
    def cities(self) -> List[str]:
        """Gets the cities of this Search.

        City strings  # noqa: E501

        :return: The cities of this Search.
        :rtype: List[str]
        """
        return self._cities

    @cities.setter
    def cities(self, cities: List[str]):
        """Sets the cities of this Search.

        City strings  # noqa: E501

        :param cities: The cities of this Search.
        :type cities: List[str]
        """

        self._cities = cities

    @property
    def neighbourhoods(self) -> List[str]:
        """Gets the neighbourhoods of this Search.

        Neighbourhood strings  # noqa: E501

        :return: The neighbourhoods of this Search.
        :rtype: List[str]
        """
        return self._neighbourhoods

    @neighbourhoods.setter
    def neighbourhoods(self, neighbourhoods: List[str]):
        """Sets the neighbourhoods of this Search.

        Neighbourhood strings  # noqa: E501

        :param neighbourhoods: The neighbourhoods of this Search.
        :type neighbourhoods: List[str]
        """

        self._neighbourhoods = neighbourhoods

    @property
    def neighbourhoods_v2(self) -> List[object]:
        """Gets the neighbourhoods_v2 of this Search.

        Neighbourhood_v2 objects  # noqa: E501

        :return: The neighbourhoods_v2 of this Search.
        :rtype: List[object]
        """
        return self._neighbourhoods_v2

    @neighbourhoods_v2.setter
    def neighbourhoods_v2(self, neighbourhoods_v2: List[object]):
        """Sets the neighbourhoods_v2 of this Search.

        Neighbourhood_v2 objects  # noqa: E501

        :param neighbourhoods_v2: The neighbourhoods_v2 of this Search.
        :type neighbourhoods_v2: List[object]
        """

        self._neighbourhoods_v2 = neighbourhoods_v2

    @property
    def addresses(self) -> List[str]:
        """Gets the addresses of this Search.

        Specific addresses  # noqa: E501

        :return: The addresses of this Search.
        :rtype: List[str]
        """
        return self._addresses

    @addresses.setter
    def addresses(self, addresses: List[str]):
        """Sets the addresses of this Search.

        Specific addresses  # noqa: E501

        :param addresses: The addresses of this Search.
        :type addresses: List[str]
        """

        self._addresses = addresses

    @property
    def building_types(self) -> List[str]:
        """Gets the building_types of this Search.

        types of homes  # noqa: E501

        :return: The building_types of this Search.
        :rtype: List[str]
        """
        return self._building_types

    @building_types.setter
    def building_types(self, building_types: List[str]):
        """Sets the building_types of this Search.

        types of homes  # noqa: E501

        :param building_types: The building_types of this Search.
        :type building_types: List[str]
        """

        self._building_types = building_types

    @property
    def min_price(self) -> int:
        """Gets the min_price of this Search.

        minimum price to include  # noqa: E501

        :return: The min_price of this Search.
        :rtype: int
        """
        return self._min_price

    @min_price.setter
    def min_price(self, min_price: int):
        """Sets the min_price of this Search.

        minimum price to include  # noqa: E501

        :param min_price: The min_price of this Search.
        :type min_price: int
        """

        self._min_price = min_price

    @property
    def max_price(self) -> int:
        """Gets the max_price of this Search.

        maximum price to include  # noqa: E501

        :return: The max_price of this Search.
        :rtype: int
        """
        return self._max_price

    @max_price.setter
    def max_price(self, max_price: int):
        """Sets the max_price of this Search.

        maximum price to include  # noqa: E501

        :param max_price: The max_price of this Search.
        :type max_price: int
        """

        self._max_price = max_price

    @property
    def min_beds(self) -> int:
        """Gets the min_beds of this Search.


        :return: The min_beds of this Search.
        :rtype: int
        """
        return self._min_beds

    @min_beds.setter
    def min_beds(self, min_beds: int):
        """Sets the min_beds of this Search.


        :param min_beds: The min_beds of this Search.
        :type min_beds: int
        """

        self._min_beds = min_beds

    @property
    def min_baths(self) -> int:
        """Gets the min_baths of this Search.

        inclusive minimum full baths to include  # noqa: E501

        :return: The min_baths of this Search.
        :rtype: int
        """
        return self._min_baths

    @min_baths.setter
    def min_baths(self, min_baths: int):
        """Sets the min_baths of this Search.

        inclusive minimum full baths to include  # noqa: E501

        :param min_baths: The min_baths of this Search.
        :type min_baths: int
        """

        self._min_baths = min_baths

    @property
    def min_parking(self) -> int:
        """Gets the min_parking of this Search.

        inclusive minimum number of parking spots available  # noqa: E501

        :return: The min_parking of this Search.
        :rtype: int
        """
        return self._min_parking

    @min_parking.setter
    def min_parking(self, min_parking: int):
        """Sets the min_parking of this Search.

        inclusive minimum number of parking spots available  # noqa: E501

        :param min_parking: The min_parking of this Search.
        :type min_parking: int
        """

        self._min_parking = min_parking

    @property
    def min_square_foot(self) -> int:
        """Gets the min_square_foot of this Search.

        inclusive minimum above ground size home  # noqa: E501

        :return: The min_square_foot of this Search.
        :rtype: int
        """
        return self._min_square_foot

    @min_square_foot.setter
    def min_square_foot(self, min_square_foot: int):
        """Sets the min_square_foot of this Search.

        inclusive minimum above ground size home  # noqa: E501

        :param min_square_foot: The min_square_foot of this Search.
        :type min_square_foot: int
        """

        self._min_square_foot = min_square_foot

    @property
    def max_square_foot(self) -> int:
        """Gets the max_square_foot of this Search.

        inclusive maxiumum above ground size of home  # noqa: E501

        :return: The max_square_foot of this Search.
        :rtype: int
        """
        return self._max_square_foot

    @max_square_foot.setter
    def max_square_foot(self, max_square_foot: int):
        """Sets the max_square_foot of this Search.

        inclusive maxiumum above ground size of home  # noqa: E501

        :param max_square_foot: The max_square_foot of this Search.
        :type max_square_foot: int
        """

        self._max_square_foot = max_square_foot

    @property
    def geohash6_areas(self) -> List[str]:
        """Gets the geohash6_areas of this Search.

        list of geohash6 areas to include  # noqa: E501

        :return: The geohash6_areas of this Search.
        :rtype: List[str]
        """
        return self._geohash6_areas

    @geohash6_areas.setter
    def geohash6_areas(self, geohash6_areas: List[str]):
        """Sets the geohash6_areas of this Search.

        list of geohash6 areas to include  # noqa: E501

        :param geohash6_areas: The geohash6_areas of this Search.
        :type geohash6_areas: List[str]
        """

        self._geohash6_areas = geohash6_areas

    @property
    def bounds(self) -> LatLngBounds:
        """Gets the bounds of this Search.


        :return: The bounds of this Search.
        :rtype: LatLngBounds
        """
        return self._bounds

    @bounds.setter
    def bounds(self, bounds: LatLngBounds):
        """Sets the bounds of this Search.


        :param bounds: The bounds of this Search.
        :type bounds: LatLngBounds
        """

        self._bounds = bounds
