/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.text.MessageFormat;

class DLLException
extends Exception {
    private int category = -9;
    private int status = -9;
    private int state = -9;
    private int errCode = -1;
    private String param1 = "";
    private String param2 = "";
    private String param3 = "";

    DLLException(String string, int n, int n2, int n3) {
        super(string);
        this.category = n;
        this.status = n2;
        this.state = n3;
    }

    DLLException(String string, String string2, String string3, int n) {
        this.errCode = n;
        this.param1 = string;
        this.param2 = string2;
        this.param3 = string3;
    }

    int GetCategory() {
        return this.category;
    }

    int GetStatus() {
        return this.status;
    }

    int GetState() {
        return this.state;
    }

    int GetErrCode() {
        return this.errCode;
    }

    String GetParam1() {
        return this.param1;
    }

    String GetParam2() {
        return this.param2;
    }

    String GetParam3() {
        return this.param3;
    }

    static void buildException(int n, String string, String string2, String string3) throws SQLServerException {
        String string4 = DLLException.getErrMessage(n);
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString(string4));
        Object[] objectArray = new Object[]{null, null, null};
        DLLException.buildMsgParams(string4, objectArray, string, string2, string3);
        throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, false);
    }

    private static void buildMsgParams(String string, Object[] objectArray, String string2, String string3, String string4) {
        if (string.equalsIgnoreCase("R_AECertLocBad")) {
            objectArray[0] = string2;
            objectArray[1] = string2 + "/" + string3 + "/" + string4;
        } else if (string.equalsIgnoreCase("R_AECertStoreBad")) {
            objectArray[0] = string3;
            objectArray[1] = string2 + "/" + string3 + "/" + string4;
        } else if (string.equalsIgnoreCase("R_AECertHashEmpty")) {
            objectArray[0] = string2 + "/" + string3 + "/" + string4;
        } else {
            objectArray[0] = string2;
            objectArray[1] = string3;
            objectArray[2] = string4;
        }
    }

    private static String getErrMessage(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "R_AEKeypathEmpty";
                break;
            }
            case 2: {
                string = "R_EncryptedCEKNull";
                break;
            }
            case 3: {
                string = "R_NullKeyEncryptionAlgorithm";
                break;
            }
            case 4: {
                string = "R_AEWinApiErr";
                break;
            }
            case 5: {
                string = "R_AECertpathBad";
                break;
            }
            case 6: {
                string = "R_AECertLocBad";
                break;
            }
            case 7: {
                string = "R_AECertStoreBad";
                break;
            }
            case 8: {
                string = "R_AECertHashEmpty";
                break;
            }
            case 9: {
                string = "R_AECertNotFound";
                break;
            }
            case 10: {
                string = "R_AEMaloc";
                break;
            }
            case 11: {
                string = "R_EmptyEncryptedCEK";
                break;
            }
            case 12: {
                string = "R_InvalidKeyEncryptionAlgorithm";
                break;
            }
            case 13: {
                string = "R_AEKeypathLong";
                break;
            }
            case 14: {
                string = "R_InvalidEcryptionAlgorithmVersion";
                break;
            }
            case 15: {
                string = "R_AEECEKLenBad";
                break;
            }
            case 16: {
                string = "R_AEECEKSigLenBad";
                break;
            }
            case 17: {
                string = "R_InvalidCertificateSignature";
                break;
            }
            default: {
                string = "R_AEWinApiErr";
            }
        }
        return string;
    }
}

