"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
// CloudFormation supports InlineCode only for a subset of runtimes. This integration test
// is used to verify that the ones marked in the CDK are in fact supported by CloudFormation.
// Running `cdk deploy` on this stack will confirm if all the runtimes here are supported.
//
// To verify that the lambda function works correctly, use the function names that are part
// of the stack output (printed on the console at the end of 'cdk deploy') and run the command -
// aws lambda invoke --function-name <function-name>
//
// If successful, the output will contain "success"
const app = new core_1.App();
const stack = new core_1.Stack(app, 'aws-cdk-lambda-runtime-inlinecode');
const node10xfn = new lib_1.Function(stack, 'NODEJS_10_X', {
    code: new lib_1.InlineCode('exports.handler = async function(event) { return "success" }'),
    handler: 'index.handler',
    runtime: lib_1.Runtime.NODEJS_10_X,
});
new core_1.CfnOutput(stack, 'NODEJS_10_X-functionName', { value: node10xfn.functionName });
const node12xfn = new lib_1.Function(stack, 'NODEJS_12_X', {
    code: new lib_1.InlineCode('exports.handler = async function(event) { return "success" }'),
    handler: 'index.handler',
    runtime: lib_1.Runtime.NODEJS_12_X,
});
new core_1.CfnOutput(stack, 'NODEJS_12_X-functionName', { value: node12xfn.functionName });
const python27 = new lib_1.Function(stack, 'PYTHON_2_7', {
    code: new lib_1.InlineCode('def handler(event, context):\n  return "success"'),
    handler: 'index.handler',
    runtime: lib_1.Runtime.PYTHON_2_7,
});
new core_1.CfnOutput(stack, 'PYTHON_2_7-functionName', { value: python27.functionName });
const python36 = new lib_1.Function(stack, 'PYTHON_3_6', {
    code: new lib_1.InlineCode('def handler(event, context):\n  return "success"'),
    handler: 'index.handler',
    runtime: lib_1.Runtime.PYTHON_3_6,
});
new core_1.CfnOutput(stack, 'PYTHON_3_6-functionName', { value: python36.functionName });
const python37 = new lib_1.Function(stack, 'PYTHON_3_7', {
    code: new lib_1.InlineCode('def handler(event, context):\n  return "success"'),
    handler: 'index.handler',
    runtime: lib_1.Runtime.PYTHON_3_7,
});
new core_1.CfnOutput(stack, 'PYTHON_3_7-functionName', { value: python37.functionName });
app.synth();
//# sourceMappingURL=data:application/json;base64,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