"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const lambda = require("../lib");
module.exports = {
    'can add same singleton Lambda multiple times, only instantiated once in template'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        for (let i = 0; i < 5; i++) {
            new lambda.SingletonFunction(stack, `Singleton${i}`, {
                uuid: '84c0de93-353f-4217-9b0b-45b6c993251a',
                code: new lambda.InlineCode('def hello(): pass'),
                runtime: lambda.Runtime.PYTHON_2_7,
                handler: 'index.hello',
                timeout: cdk.Duration.minutes(5),
            });
        }
        // THEN
        assert_1.expect(stack).to(assert_1.matchTemplate({
            Resources: {
                SingletonLambda84c0de93353f42179b0b45b6c993251aServiceRole26D59235: {
                    Type: "AWS::IAM::Role",
                    Properties: {
                        AssumeRolePolicyDocument: {
                            Statement: [
                                {
                                    Action: "sts:AssumeRole",
                                    Effect: "Allow",
                                    Principal: { Service: "lambda.amazonaws.com" }
                                }
                            ],
                            Version: "2012-10-17"
                        },
                        ManagedPolicyArns: [
                            {
                                "Fn::Join": ["", ["arn:", { Ref: "AWS::Partition" }, ":iam::aws:policy/service-role/AWSLambdaBasicExecutionRole"]]
                            }
                        ]
                    }
                },
                SingletonLambda84c0de93353f42179b0b45b6c993251a840BCC38: {
                    Type: "AWS::Lambda::Function",
                    Properties: {
                        Code: {
                            ZipFile: "def hello(): pass"
                        },
                        Handler: "index.hello",
                        Role: { "Fn::GetAtt": ["SingletonLambda84c0de93353f42179b0b45b6c993251aServiceRole26D59235", "Arn"] },
                        Runtime: "python2.7",
                        Timeout: 300
                    },
                    DependsOn: ["SingletonLambda84c0de93353f42179b0b45b6c993251aServiceRole26D59235"]
                }
            }
        }));
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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