"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("fs");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const bundling_1 = require("../lib/bundling");
jest.mock('@aws-cdk/aws-lambda');
const existsSyncOriginal = fs.existsSync;
const existsSyncMock = jest.spyOn(fs, 'existsSync');
beforeEach(() => {
    jest.clearAllMocks();
});
test('Bundling', () => {
    bundling_1.bundle({
        entry: '/project/folder',
        runtime: aws_lambda_1.Runtime.PYTHON_3_7,
    });
    // Correctly bundles
    expect(aws_lambda_1.Code.fromAsset).toHaveBeenCalledWith('/project/folder', {
        bundling: expect.objectContaining({
            command: [
                'bash', '-c',
                'cp -au . /asset-output',
            ],
        }),
    });
    // Searches for requirements.txt in entry
    expect(existsSyncMock).toHaveBeenCalledWith('/project/folder/requirements.txt');
});
test('Bundling with requirements.txt installed', () => {
    existsSyncMock.mockImplementation((p) => {
        if (/requirements.txt/.test(p.toString())) {
            return true;
        }
        return existsSyncOriginal(p);
    });
    bundling_1.bundle({
        entry: '/project/folder',
        runtime: aws_lambda_1.Runtime.PYTHON_3_7,
    });
    // Correctly bundles with requirements.txt pip installed
    expect(aws_lambda_1.Code.fromAsset).toHaveBeenCalledWith('/project/folder', {
        bundling: expect.objectContaining({
            command: [
                'bash', '-c',
                'pip3 install -r requirements.txt -t /asset-output && cp -au . /asset-output',
            ],
        }),
    });
});
test('Bundling Python 2.7 with requirements.txt installed', () => {
    existsSyncMock.mockImplementation((p) => {
        if (/requirements.txt/.test(p.toString())) {
            return true;
        }
        return existsSyncOriginal(p);
    });
    bundling_1.bundle({
        entry: '/project/folder',
        runtime: aws_lambda_1.Runtime.PYTHON_2_7,
    });
    // Correctly bundles with requirements.txt pip installed
    expect(aws_lambda_1.Code.fromAsset).toHaveBeenCalledWith('/project/folder', {
        bundling: expect.objectContaining({
            command: [
                'bash', '-c',
                'pip install -r requirements.txt -t /asset-output && cp -au . /asset-output',
            ],
        }),
    });
});
//# sourceMappingURL=data:application/json;base64,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