import { PrepareApiSpecOptions } from "./prepare-spec";
/**
 * Represents an object location in an s3 bucket
 */
export interface S3Location {
    /**
     * The bucket in which the object resides
     */
    readonly bucket: string;
    /**
     * The object key
     */
    readonly key: string;
}
/**
 * Properties required to prepare the api specification with the given integrations, authorizers, etc
 */
export interface PrepareApiSpecCustomResourceProperties extends PrepareApiSpecOptions {
    /**
     * The location from which to read the spec to prepare
     */
    readonly inputSpecLocation: S3Location;
    /**
     * The location to write the prepared spec
     */
    readonly outputSpecLocation: S3Location;
}
