"use strict";
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLabelledFunctions = void 0;
const predicates_1 = require("../authorizers/predicates");
const api_gateway_auth_1 = require("./api-gateway-auth");
/**
 * Return all lambda functions used as authorizers, labelled by authorizer id
 */
const getLabelledAuthorizerFunctions = (options) => api_gateway_auth_1.getAllAuthorizers(options.integrations, options.defaultAuthorizer)
    .filter((authorizer) => predicates_1.isCustomAuthorizer(authorizer))
    .map((authorizer) => ({
    label: authorizer.authorizerId,
    function: authorizer.function,
}));
/**
 * Return all lambda functions used in integrations, labelled by operation
 */
const getLabelledIntegrationFunctions = (options) => Object.entries(options.integrations).map(([operationId, integration]) => ({
    label: operationId,
    function: integration.function,
}));
/**
 * Return all lambda functions that may be invoked by api gateway
 */
exports.getLabelledFunctions = (options) => getLabelledAuthorizerFunctions(options).concat(getLabelledIntegrationFunctions(options));
//# sourceMappingURL=data:application/json;base64,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