/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.tools.ldbdist;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class LDBDistOutputStream
extends OutputStream {
    private static final int BATCH_SIZE = 0x1E00000;
    private final String uri;
    private byte[] buffer = new byte[0x1E00000];
    private HttpURLConnection httpUrlConnection;
    private int index = 0;
    private long position;

    public LDBDistOutputStream(String uri, boolean overwrite, long position) throws IOException {
        this.uri = uri;
        this.position = position;
        this.index = 0;
        try {
            URL url = new URL(uri);
            this.httpUrlConnection = (HttpURLConnection)url.openConnection();
            this.httpUrlConnection.setDoOutput(true);
            this.httpUrlConnection.setUseCaches(false);
            this.httpUrlConnection.setRequestMethod("CREATE");
            this.httpUrlConnection.setRequestProperty("Overwrite", String.valueOf(overwrite));
            this.httpUrlConnection.connect();
            int responseCode = this.httpUrlConnection.getResponseCode();
            if (responseCode != 201) {
                throw new RuntimeException("Create file [" + this.uri + "] failed.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Create file [" + this.uri + "] failed.");
        }
        finally {
            if (this.httpUrlConnection != null) {
                this.httpUrlConnection.disconnect();
                this.httpUrlConnection = null;
            }
        }
    }

    public LDBDistOutputStream(String uri, boolean overwrite) throws IOException {
        this.uri = uri;
        this.index = 0;
        try {
            URL url = new URL(uri);
            this.httpUrlConnection = (HttpURLConnection)url.openConnection();
            this.httpUrlConnection.setDoOutput(false);
            this.httpUrlConnection.setUseCaches(false);
            this.httpUrlConnection.setRequestMethod("CREATE");
            this.httpUrlConnection.setRequestProperty("Overwrite", String.valueOf(overwrite));
            this.httpUrlConnection.setRequestProperty("createdir", "true");
            this.httpUrlConnection.connect();
            int responseCode = this.httpUrlConnection.getResponseCode();
            if (responseCode != 201) {
                throw new RuntimeException("Create file [" + this.uri + "] failed.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Create file [" + this.uri + "] failed.");
        }
        finally {
            if (this.httpUrlConnection != null) {
                this.httpUrlConnection.disconnect();
                this.httpUrlConnection = null;
            }
        }
    }

    public LDBDistOutputStream(String uri) {
        this.uri = uri;
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer[this.index] = (byte)b;
        ++this.position;
        ++this.index;
        if (this.index == 0x1E00000) {
            this.putToServer(0, 0x1E00000);
        }
    }

    public void copyStream(InputStream inputStream) throws Exception {
        int len;
        while ((len = inputStream.read(this.buffer)) != -1) {
            this.position += (long)len;
            this.index += len;
            this.putToServer(0, len);
        }
    }

    public void downLoadFromUrl(String savePath) {
        try {
            if (this.httpUrlConnection == null) {
                URL url = new URL(this.uri);
                this.httpUrlConnection = (HttpURLConnection)url.openConnection();
            }
            this.httpUrlConnection.setConnectTimeout(10000);
            InputStream inputStream = this.httpUrlConnection.getInputStream();
            byte[] getData = LDBDistOutputStream.readInputStream(inputStream);
            File file = new File(savePath);
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(getData);
            if (fos != null) {
                fos.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("download file [" + this.uri + "] failed.");
        }
    }

    public static byte[] readInputStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[4096];
        int len = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = inputStream.read(buffer)) != -1) {
            bos.write(buffer, 0, len);
        }
        bos.close();
        return bos.toByteArray();
    }

    private void putToServer(int offset, int length) throws IOException {
        if (this.httpUrlConnection == null) {
            URL url = new URL(this.uri);
            this.httpUrlConnection = (HttpURLConnection)url.openConnection();
            this.httpUrlConnection.setDoOutput(true);
            this.httpUrlConnection.disconnect();
            this.httpUrlConnection.setRequestMethod("PUT");
            this.httpUrlConnection.setConnectTimeout(900000);
            this.httpUrlConnection.setReadTimeout(900000);
            this.httpUrlConnection.setChunkedStreamingMode(length);
            this.httpUrlConnection.connect();
        }
        OutputStream os = null;
        try {
            os = this.httpUrlConnection.getOutputStream();
            if (os != null) {
                os.write(this.buffer, offset, length);
            }
            this.index = 0;
        }
        catch (Exception e) {
            throw new RuntimeException("upload file [" + this.uri + "] failed.");
        }
        finally {
            try {
                if (os != null) {
                    os.flush();
                    os.close();
                    os = null;
                }
                if (this.httpUrlConnection != null) {
                    this.httpUrlConnection.disconnect();
                    this.httpUrlConnection = null;
                }
            }
            catch (Exception e1) {
                throw new RuntimeException("upload file [" + this.uri + "] failed.");
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.index == 0) {
                return;
            }
            this.putToServer(0, this.index);
        }
        finally {
            if (this.httpUrlConnection != null) {
                this.httpUrlConnection.disconnect();
            }
        }
    }
}

