/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gstreamer.Caps;
import org.gstreamer.Element;
import org.gstreamer.PadDirection;
import org.gstreamer.PluginFeature;
import org.gstreamer.StaticPadTemplate;
import org.gstreamer.lowlevel.GlibAPI;
import org.gstreamer.lowlevel.GstCapsAPI;
import org.gstreamer.lowlevel.GstElementFactoryAPI;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.lowlevel.GstPadTemplateAPI;
import org.gstreamer.lowlevel.GstPluginAPI;
import org.gstreamer.lowlevel.GstTypes;
import org.gstreamer.lowlevel.NativeObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementFactory
extends PluginFeature {
    private static Logger logger = Logger.getLogger(ElementFactory.class.getName());
    private static Level DEBUG = Level.FINE;
    private static final Map<String, Class<? extends Element>> typeMap = new HashMap<String, Class<? extends Element>>();
    public static final String GTYPE_NAME = "GstElementFactory";
    private static final API gst = GstNative.load(API.class);
    private static final GlibAPI glib = GlibAPI.GLIB_API;

    public static void registerElement(Class<? extends Element> klass, String name) {
        typeMap.put(name, klass);
    }

    public static ElementFactory find(String name) {
        logger.entering("ElementFactory", "find", name);
        ElementFactory factory = gst.gst_element_factory_find(name);
        if (factory == null) {
            throw new IllegalArgumentException("No such Gstreamer factory: " + name);
        }
        return factory;
    }

    public static Element make(String factoryName, String name) {
        logger.entering("ElementFactory", "make", new Object[]{factoryName, name});
        return ElementFactory.elementFor(ElementFactory.makeRawElement(factoryName, name), factoryName);
    }

    public static List<ElementFactory> listGetElement(ElementFactoryListType type, PluginFeature.Rank minrank) {
        GlibAPI.GList glist = gst.gst_element_factory_list_get_elements(type.getValue(), minrank.getValue());
        ArrayList<ElementFactory> list = new ArrayList<ElementFactory>();
        for (GlibAPI.GList next = glist; next != null; next = next.next()) {
            if (next.data == null) continue;
            ElementFactory fact = new ElementFactory(ElementFactory.initializer(next.data, true, true));
            list.add(fact);
        }
        gst.gst_plugin_list_free(glist);
        return list;
    }

    private static List<ElementFactory> lister(GlibAPI.GList glist, Caps caps, PadDirection direction, boolean subsetonly) {
        GlibAPI.GList gFilterList;
        ArrayList<ElementFactory> filterList = new ArrayList<ElementFactory>();
        for (GlibAPI.GList next = gFilterList = gst.gst_element_factory_list_filter(glist, caps, direction, subsetonly); next != null; next = next.next()) {
            if (next.data == null) continue;
            ElementFactory fact = new ElementFactory(ElementFactory.initializer(next.data, true, true));
            filterList.add(fact);
        }
        gst.gst_plugin_list_free(glist);
        gst.gst_plugin_list_free(gFilterList);
        return filterList;
    }

    public static List<ElementFactory> listFilter(List<ElementFactory> list, Caps caps, PadDirection direction, boolean subsetonly) {
        GlibAPI.GList glist = null;
        for (ElementFactory fact : list) {
            fact.ref();
            glist = glib.g_list_append(glist, fact.handle());
        }
        return ElementFactory.lister(glist, caps, direction, subsetonly);
    }

    public static List<ElementFactory> listGetElementFilter(ElementFactoryListType type, PluginFeature.Rank minrank, Caps caps, PadDirection direction, boolean subsetonly) {
        GlibAPI.GList glist = gst.gst_element_factory_list_get_elements(type.getValue(), minrank.getValue());
        return ElementFactory.lister(glist, caps, direction, subsetonly);
    }

    public static Pointer makeRawElement(String factoryName, String name) {
        logger.entering("ElementFactory", "makeRawElement", new Object[]{factoryName, name});
        Pointer elem = gst.ptr_gst_element_factory_make(factoryName, name);
        logger.log(DEBUG, "Return from gst_element_factory_make=" + elem);
        if (elem == null) {
            throw new IllegalArgumentException("No such Gstreamer factory: " + factoryName);
        }
        return elem;
    }

    private static Element elementFor(Pointer ptr, String factoryName) {
        Class<? extends Element> cls = typeMap.get(factoryName);
        cls = cls == null ? GstTypes.classFor(ptr) : cls;
        cls = cls == null || !Element.class.isAssignableFrom(cls) ? Element.class : cls;
        return NativeObject.objectFor(ptr, cls);
    }

    public ElementFactory(NativeObject.Initializer init) {
        super(init);
        logger.entering("ElementFactory", "<init>", new Object[]{init});
    }

    public Element create(String name) {
        logger.entering("ElementFactory", "create", name);
        Pointer elem = gst.ptr_gst_element_factory_create(this, name);
        logger.log(DEBUG, "gst_element_factory_create returned: " + elem);
        if (elem == null) {
            throw new IllegalArgumentException("Cannot create GstElement");
        }
        return ElementFactory.elementFor(elem, this.getName());
    }

    public String getAuthor() {
        logger.entering("ElementFactory", "getAuthor");
        return gst.gst_element_factory_get_author(this);
    }

    public String getDescription() {
        logger.entering("ElementFactory", "getDescription");
        return gst.gst_element_factory_get_description(this);
    }

    public String getLongName() {
        logger.entering("ElementFactory", "getLongName");
        return gst.gst_element_factory_get_longname(this);
    }

    public String getKlass() {
        logger.entering("ElementFactory", "getKlass");
        return gst.gst_element_factory_get_klass(this);
    }

    public List<StaticPadTemplate> getStaticPadTemplates() {
        logger.entering("ElementFactory", "getStaticPadTemplates");
        GlibAPI.GList glist = gst.gst_element_factory_get_static_pad_templates(this);
        logger.log(DEBUG, "gst.gst_element_factory_get_static_pad_templates returned: " + (Object)((Object)glist));
        ArrayList<StaticPadTemplate> templates = new ArrayList<StaticPadTemplate>();
        for (GlibAPI.GList next = glist; next != null; next = next.next()) {
            if (next.data == null) continue;
            GstPadTemplateAPI.GstStaticPadTemplate temp = new GstPadTemplateAPI.GstStaticPadTemplate(next.data);
            templates.add(new StaticPadTemplate(temp.name_template, temp.direction, temp.presence, gst.gst_static_caps_get(temp.static_caps)));
        }
        return templates;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ElementFactoryListType {
        DECODER(1L),
        ENCODER(2L),
        SINK(4L),
        SRC(8L),
        MUXER(16L),
        DEMUXER(32L),
        PARSER(64L),
        PAYLOADER(128L),
        DEPAYLOADER(256L),
        FORMATTER(512L),
        MAX_ELEMENTS(0x1000000000000L),
        ANY(0x1FFFFFFFFFFFFL),
        MEDIA_ANY(-281474976710656L),
        MEDIA_VIDEO(0x2000000000000L),
        MEDIA_AUDIO(0x4000000000000L),
        MEDIA_IMAGE(0x8000000000000L),
        MEDIA_SUBTITLE(0x10000000000000L),
        MEDIA_METADATA(0x20000000000000L),
        VIDEO_ENCODER(ENCODER.getValue() | MEDIA_VIDEO.getValue() | MEDIA_IMAGE.getValue()),
        AUDIO_ENCODER(ENCODER.getValue() | MEDIA_AUDIO.getValue()),
        AUDIOVIDEO_SINKS(SINK.getValue() | MEDIA_AUDIO.getValue() | MEDIA_VIDEO.getValue() | MEDIA_IMAGE.getValue()),
        DECODABLE(ENCODER.getValue() | DEMUXER.getValue() | DEPAYLOADER.getValue() | PARSER.getValue());

        private long value;

        private ElementFactoryListType(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }
    }

    private static interface API
    extends GstElementFactoryAPI,
    GstCapsAPI,
    GstPadTemplateAPI,
    GstPluginAPI {
    }
}

