/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.event;

import com.jogamp.common.util.PropertyAccess;
import com.jogamp.newt.event.GestureHandler;
import com.jogamp.newt.event.InputEvent;
import com.jogamp.newt.event.MouseEvent;
import jogamp.newt.Debug;

public class DoubleTapScrollGesture
implements GestureHandler {
    public static final int SCROLL_SLOP_PIXEL;
    public static final int DOUBLE_TAP_SLOP_PIXEL;
    public static final float SCROLL_SLOP_MM;
    public static final float DOUBLE_TAP_SLOP_MM;
    private static final int ST_NONE = 0;
    private static final int ST_1PRESS = 1;
    private static final int ST_2PRESS_T = 2;
    private static final int ST_2PRESS_C = 3;
    private static final int ST_SCROLL = 4;
    private final int scrollSlop;
    private final int scrollSlopSquare;
    private final int doubleTapSlop;
    private final int doubleTapSlopSquare;
    private final float[] scrollDistance = new float[]{0.0f, 0.0f};
    private final int[] pIds = new int[]{-1, -1};
    private int gestureState;
    private int sqStartDist;
    private int lastX;
    private int lastY;
    private int pointerDownCount;
    private MouseEvent hitGestureEvent;

    private static final int getSquareDistance(float f, float f2, float f3, float f4) {
        int n = (int)f - (int)f3;
        int n2 = (int)f2 - (int)f4;
        return n * n + n2 * n2;
    }

    private int gesturePointers(MouseEvent mouseEvent, int n) {
        int n2 = 0;
        for (int i = mouseEvent.getPointerCount() - 1; i >= 0; --i) {
            short s;
            if (n == i || this.pIds[0] != (s = mouseEvent.getPointerId(i)) && this.pIds[1] != s) continue;
            ++n2;
        }
        return n2;
    }

    public DoubleTapScrollGesture(int n, int n2) {
        this.scrollSlop = n;
        this.scrollSlopSquare = n * n;
        this.doubleTapSlop = n2;
        this.doubleTapSlopSquare = n2 * n2;
        this.pointerDownCount = 0;
        this.clear(true);
        if (DEBUG) {
            System.err.println("DoubleTapScroll    scrollSlop (scaled) " + this.scrollSlop);
            System.err.println("DoubleTapScroll doubleTapSlop (scaled) " + this.doubleTapSlop);
        }
    }

    public String toString() {
        return "DoubleTapScroll[state " + this.gestureState + ", in " + this.isWithinGesture() + ", has " + (null != this.hitGestureEvent) + ", pc " + this.pointerDownCount + "]";
    }

    @Override
    public void clear(boolean bl) {
        this.scrollDistance[0] = 0.0f;
        this.scrollDistance[1] = 0.0f;
        this.hitGestureEvent = null;
        if (bl) {
            this.gestureState = 0;
            this.sqStartDist = 0;
            this.pIds[0] = -1;
            this.pIds[1] = -1;
            this.lastX = 0;
            this.lastY = 0;
        }
    }

    @Override
    public boolean isWithinGesture() {
        return 3 <= this.gestureState;
    }

    @Override
    public boolean hasGesture() {
        return null != this.hitGestureEvent;
    }

    @Override
    public InputEvent getGestureEvent() {
        if (null != this.hitGestureEvent) {
            MouseEvent mouseEvent = this.hitGestureEvent;
            int n = mouseEvent.getModifiers();
            float[] fArray = mouseEvent.getRotation();
            fArray[0] = this.scrollDistance[0] / (float)this.scrollSlop;
            fArray[1] = this.scrollDistance[1] / (float)this.scrollSlop;
            if (fArray[0] * fArray[0] > fArray[1] * fArray[1]) {
                n |= 1;
            }
            return new MouseEvent(207, mouseEvent.getSource(), mouseEvent.getWhen(), n, mouseEvent.getAllPointerTypes(), mouseEvent.getAllPointerIDs(), mouseEvent.getAllX(), mouseEvent.getAllY(), mouseEvent.getAllPressures(), mouseEvent.getMaxPressure(), mouseEvent.getButton(), mouseEvent.getClickCount(), fArray, this.scrollSlop);
        }
        return null;
    }

    public final float[] getScrollDistanceXY() {
        return this.scrollDistance;
    }

    @Override
    public boolean process(InputEvent inputEvent) {
        if (null != this.hitGestureEvent || !(inputEvent instanceof MouseEvent)) {
            return true;
        }
        MouseEvent mouseEvent = (MouseEvent)inputEvent;
        if (mouseEvent.getPointerType(0).getPointerClass() != MouseEvent.PointerClass.Onscreen) {
            return false;
        }
        this.pointerDownCount = mouseEvent.getPointerCount();
        short s = mouseEvent.getEventType();
        int n = mouseEvent.getX(0);
        int n2 = mouseEvent.getY(0);
        switch (s) {
            case 203: {
                int n3 = 0;
                if (0 == this.gestureState && 1 == this.pointerDownCount) {
                    this.pIds[0] = mouseEvent.getPointerId(0);
                    this.pIds[1] = -1;
                    this.gestureState = 1;
                } else if (0 < this.gestureState && 2 == this.pointerDownCount && 1 == this.gesturePointers(mouseEvent, 0)) {
                    int n4 = mouseEvent.getX(1);
                    int n5 = mouseEvent.getY(1);
                    int n6 = (n + n4) / 2;
                    int n7 = (n2 + n5) / 2;
                    if (1 == this.gestureState) {
                        boolean bl;
                        int n8 = DoubleTapScrollGesture.getSquareDistance(n, n2, n4, n5);
                        boolean bl2 = bl = n8 < this.doubleTapSlopSquare;
                        if (bl) {
                            n3 = 2;
                            this.pIds[0] = mouseEvent.getPointerId(0);
                            this.pIds[1] = mouseEvent.getPointerId(1);
                            this.lastX = n6;
                            this.lastY = n7;
                            this.sqStartDist = n8;
                            this.gestureState = 2;
                        }
                        if (DEBUG) {
                            int n9 = (int)Math.round(Math.sqrt(n8));
                            System.err.println(this + ".pressed.1: dist " + n9 + ", gPtr " + n3 + ", distWithin2DTSlop " + bl + ", last " + this.lastX + "/" + this.lastY + ", " + mouseEvent);
                        }
                    } else if (3 == this.gestureState) {
                        n3 = this.gesturePointers(mouseEvent, -1);
                        if (2 == n3) {
                            this.lastX = n6;
                            this.lastY = n7;
                        } else {
                            this.clear(true);
                        }
                    }
                }
                if (!DEBUG) break;
                System.err.println(this + ".pressed: gPtr " + n3 + ", this " + this.lastX + "/" + this.lastY + ", " + mouseEvent);
                break;
            }
            case 204: {
                --this.pointerDownCount;
                int n10 = this.gesturePointers(mouseEvent, 0);
                if (1 == n10) {
                    this.gestureState = 3;
                } else if (0 == n10) {
                    this.clear(true);
                }
                if (!DEBUG) break;
                System.err.println(this + ".released: gPtr " + n10 + ", " + mouseEvent);
                break;
            }
            case 206: {
                if (2 != this.pointerDownCount || 1 >= this.gestureState) break;
                int n11 = this.gesturePointers(mouseEvent, -1);
                if (2 == n11) {
                    boolean bl;
                    int n12 = mouseEvent.getX(1);
                    int n13 = mouseEvent.getY(1);
                    int n14 = (n + n12) / 2;
                    int n15 = (n2 + n13) / 2;
                    int n16 = DoubleTapScrollGesture.getSquareDistance(n, n2, n12, n13);
                    boolean bl3 = bl = Math.abs(n16 - this.sqStartDist) <= this.doubleTapSlopSquare;
                    if (bl) {
                        switch (this.gestureState) {
                            case 2: {
                                int bl4 = DoubleTapScrollGesture.getSquareDistance(this.lastX, this.lastY, n14, n15);
                                if (bl4 <= this.scrollSlopSquare) break;
                                this.gestureState = 4;
                                break;
                            }
                            case 3: {
                                this.gestureState = 4;
                                break;
                            }
                            case 4: {
                                this.scrollDistance[0] = this.lastX - n14;
                                this.scrollDistance[1] = this.lastY - n15;
                                this.hitGestureEvent = mouseEvent;
                            }
                        }
                        if (DEBUG) {
                            boolean bl5 = n16 < this.doubleTapSlopSquare;
                            int n20 = (int)Math.round(Math.sqrt(n16));
                            int n21 = DoubleTapScrollGesture.getSquareDistance(this.lastX, this.lastY, n14, n15);
                            int n3 = (int)Math.round(Math.sqrt(n21));
                            System.err.println(this + ".dragged.1: pDist " + n20 + ", scrollLen " + n3 + ", gPtr " + n11 + " [" + this.pIds[0] + ", " + this.pIds[1] + "]" + ", diffDistWithinTapSlop " + bl + ", distWithin2DTSlop " + bl5 + ", this " + n14 + "/" + n15 + ", last " + this.lastX + "/" + this.lastY + ", d " + this.scrollDistance[0] + "/" + this.scrollDistance[1]);
                        }
                    } else {
                        if (DEBUG) {
                            boolean bl4 = n16 < this.doubleTapSlopSquare;
                            int n4 = (int)Math.round(Math.sqrt(n16));
                            int n5 = (int)Math.round(Math.sqrt(this.sqStartDist));
                            System.err.println(this + ".dragged.X1: pDist " + n4 + ", distStart " + n5 + ", gPtr " + n11 + " [" + this.pIds[0] + ", " + this.pIds[1] + "]" + ", diffDistWithinTapSlop " + bl + ", distWithin2DTSlop " + bl4 + ", this " + n14 + "/" + n15 + ", last " + this.lastX + "/" + this.lastY + ", d " + this.scrollDistance[0] + "/" + this.scrollDistance[1]);
                        }
                        this.clear(true);
                    }
                    if (2 >= this.gestureState) break;
                    this.lastX = n14;
                    this.lastY = n15;
                    break;
                }
                if (DEBUG) {
                    System.err.println(this + ".dragged.X2: gPtr " + n11 + " [" + this.pIds[0] + ", " + this.pIds[1] + "]" + ", last " + this.lastX + "/" + this.lastY + ", d " + this.scrollDistance[0] + "/" + this.scrollDistance[1]);
                }
                this.clear(true);
                break;
            }
        }
        return null != this.hitGestureEvent;
    }

    static {
        Debug.initSingleton();
        SCROLL_SLOP_PIXEL = PropertyAccess.getIntProperty("newt.event.scroll_slop_pixel", true, 16);
        DOUBLE_TAP_SLOP_PIXEL = PropertyAccess.getIntProperty("newt.event.double_tap_slop_pixel", true, 104);
        SCROLL_SLOP_MM = PropertyAccess.getIntProperty("newt.event.scroll_slop_mm", true, 3);
        DOUBLE_TAP_SLOP_MM = PropertyAccess.getIntProperty("newt.event.double_tap_slop_mm", true, 20);
    }
}

