/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.texture;

import com.jogamp.common.util.IOUtil;
import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2GL3;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.GLPixelBuffer;
import com.jogamp.opengl.util.GLPixelStorageModes;
import com.jogamp.opengl.util.PNGPixelRect;
import com.jogamp.opengl.util.texture.ImageType;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.spi.DDSImage;
import com.jogamp.opengl.util.texture.spi.JPEGImage;
import com.jogamp.opengl.util.texture.spi.NetPbmTextureWriter;
import com.jogamp.opengl.util.texture.spi.SGIImage;
import com.jogamp.opengl.util.texture.spi.TGAImage;
import com.jogamp.opengl.util.texture.spi.TextureProvider;
import com.jogamp.opengl.util.texture.spi.TextureWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jogamp.opengl.Debug;

public class TextureIO {
    public static final String DDS = "dds";
    public static final String SGI = "sgi";
    public static final String SGI_RGB = "rgb";
    public static final String GIF = "gif";
    public static final String JPG = "jpg";
    public static final String PNG = "png";
    public static final String TGA = "tga";
    public static final String TIFF = "tiff";
    public static final String PAM = "pam";
    public static final String PPM = "ppm";
    private static final boolean DEBUG;
    private static boolean texRectEnabled;
    private static List<TextureProvider> textureProviders;
    private static Map<ImageType, TextureProvider> imageType2TextureProvider;
    private static List<TextureWriter> textureWriters;

    public static TextureData newTextureData(GLProfile gLProfile, File file, boolean bl, String string2) throws IOException {
        if (string2 == null) {
            string2 = IOUtil.getFileSuffix(file);
        }
        return TextureIO.newTextureDataImpl(gLProfile, file, 0, 0, bl, string2);
    }

    public static TextureData newTextureData(GLProfile gLProfile, InputStream inputStream, boolean bl, String string2) throws IOException {
        return TextureIO.newTextureDataImpl(gLProfile, inputStream, 0, 0, bl, string2);
    }

    public static TextureData newTextureData(GLProfile gLProfile, URL uRL, boolean bl, String string2) throws IOException {
        if (string2 == null) {
            string2 = IOUtil.getFileSuffix(uRL.getPath());
        }
        return TextureIO.newTextureDataImpl(gLProfile, uRL, 0, 0, bl, string2);
    }

    public static TextureData newTextureData(GLProfile gLProfile, File file, int n, int n2, boolean bl, String string2) throws IOException, IllegalArgumentException {
        if (n == 0 || n2 == 0) {
            throw new IllegalArgumentException("internalFormat and pixelFormat must be non-zero");
        }
        if (string2 == null) {
            string2 = IOUtil.getFileSuffix(file);
        }
        return TextureIO.newTextureDataImpl(gLProfile, file, n, n2, bl, string2);
    }

    public static TextureData newTextureData(GLProfile gLProfile, InputStream inputStream, int n, int n2, boolean bl, String string2) throws IOException, IllegalArgumentException {
        if (n == 0 || n2 == 0) {
            throw new IllegalArgumentException("internalFormat and pixelFormat must be non-zero");
        }
        return TextureIO.newTextureDataImpl(gLProfile, inputStream, n, n2, bl, string2);
    }

    public static TextureData newTextureData(GLProfile gLProfile, URL uRL, int n, int n2, boolean bl, String string2) throws IOException, IllegalArgumentException {
        if (n == 0 || n2 == 0) {
            throw new IllegalArgumentException("internalFormat and pixelFormat must be non-zero");
        }
        if (string2 == null) {
            string2 = IOUtil.getFileSuffix(uRL.getPath());
        }
        return TextureIO.newTextureDataImpl(gLProfile, uRL, n, n2, bl, string2);
    }

    public static Texture newTexture(TextureData textureData) throws GLException, IllegalArgumentException {
        return TextureIO.newTexture(GLContext.getCurrentGL(), textureData);
    }

    public static Texture newTexture(GL gL, TextureData textureData) throws GLException, IllegalArgumentException {
        if (textureData == null) {
            throw new IllegalArgumentException("Null TextureData");
        }
        return new Texture(gL, textureData);
    }

    public static Texture newTexture(File file, boolean bl) throws IOException, GLException {
        GL gL = GLContext.getCurrentGL();
        GLProfile gLProfile = gL.getGLProfile();
        TextureData textureData = TextureIO.newTextureData(gLProfile, file, bl, IOUtil.getFileSuffix(file));
        Texture texture = TextureIO.newTexture(gL, textureData);
        textureData.flush();
        return texture;
    }

    public static Texture newTexture(InputStream inputStream, boolean bl, String string2) throws IOException, GLException {
        GL gL = GLContext.getCurrentGL();
        GLProfile gLProfile = gL.getGLProfile();
        TextureData textureData = TextureIO.newTextureData(gLProfile, inputStream, bl, string2);
        Texture texture = TextureIO.newTexture(gL, textureData);
        textureData.flush();
        return texture;
    }

    public static Texture newTexture(URL uRL, boolean bl, String string2) throws IOException, GLException {
        if (string2 == null) {
            string2 = IOUtil.getFileSuffix(uRL.getPath());
        }
        GL gL = GLContext.getCurrentGL();
        GLProfile gLProfile = gL.getGLProfile();
        TextureData textureData = TextureIO.newTextureData(gLProfile, uRL, bl, string2);
        Texture texture = TextureIO.newTexture(gL, textureData);
        textureData.flush();
        return texture;
    }

    public static Texture newTexture(int n) {
        return new Texture(n);
    }

    public static void write(Texture texture, File file) throws IOException, GLException {
        if (texture.getTarget() != 3553) {
            throw new GLException("Only GL_TEXTURE_2D textures are supported");
        }
        GL gL = GLContext.getCurrentGL();
        if (!gL.isGL2GL3()) {
            throw new GLException("Implementation only supports GL2GL3 (Use GLReadBufferUtil and the TextureData variant), have: " + gL);
        }
        GL2GL3 gL2GL3 = gL.getGL2GL3();
        texture.bind(gL2GL3);
        int n = TextureIO.glGetTexLevelParameteri(gL2GL3, 3553, 0, 4099);
        int n2 = TextureIO.glGetTexLevelParameteri(gL2GL3, 3553, 0, 4096);
        int n3 = TextureIO.glGetTexLevelParameteri(gL2GL3, 3553, 0, 4097);
        int n4 = TextureIO.glGetTexLevelParameteri(gL2GL3, 3553, 0, 4101);
        TextureData textureData = null;
        if (n == 33776 || n == 33777 || n == 33778 || n == 33779) {
            int n5 = TextureIO.glGetTexLevelParameteri(gL2GL3, 3553, 0, 34464);
            ByteBuffer byteBuffer = ByteBuffer.allocate(n5);
            gL2GL3.glGetCompressedTexImage(3553, 0, byteBuffer);
            textureData = new TextureData(gL2GL3.getGLProfile(), n, n2, n3, n4, n, 5121, false, true, true, byteBuffer, null);
        } else {
            int n6 = 0;
            int n7 = 0;
            switch (n) {
                case 6407: 
                case 32849: 
                case 32992: {
                    n6 = 3;
                    n7 = 6407;
                    break;
                }
                case 6408: 
                case 32768: 
                case 32856: 
                case 32993: {
                    n6 = 4;
                    n7 = 6408;
                    break;
                }
                default: {
                    throw new IOException("Unsupported texture internal format 0x" + Integer.toHexString(n));
                }
            }
            GLPixelStorageModes gLPixelStorageModes = new GLPixelStorageModes();
            gLPixelStorageModes.setPackAlignment(gL2GL3, 1);
            ByteBuffer byteBuffer = ByteBuffer.allocate((n2 + 2 * n4) * (n3 + 2 * n4) * n6);
            if (DEBUG) {
                System.out.println("Allocated buffer of size " + byteBuffer.remaining() + " for fetched image (" + (n7 == 6407 ? "GL_RGB" : "GL_RGBA") + ")");
            }
            gL2GL3.glGetTexImage(3553, 0, n7, 5121, byteBuffer);
            gLPixelStorageModes.restore(gL2GL3);
            textureData = new TextureData(gL2GL3.getGLProfile(), n, n2, n3, n4, n7, 5121, false, false, false, byteBuffer, null);
            if (DEBUG) {
                System.out.println("data.getPixelFormat() = " + (textureData.getPixelFormat() == 6407 ? "GL_RGB" : "GL_RGBA"));
            }
        }
        TextureIO.write(textureData, file);
    }

    public static void write(TextureData textureData, File file) throws IOException, GLException {
        for (TextureWriter textureWriter : textureWriters) {
            if (!textureWriter.write(file, textureData)) continue;
            return;
        }
        throw new IOException("No suitable texture writer found for " + file.getAbsolutePath());
    }

    public static void addTextureProvider(TextureProvider textureProvider) {
        ImageType[] imageTypeArray;
        textureProviders.add(0, textureProvider);
        if (textureProvider instanceof TextureProvider.SupportsImageTypes && null != (imageTypeArray = ((TextureProvider.SupportsImageTypes)((Object)textureProvider)).getImageTypes())) {
            for (int i = 0; i < imageTypeArray.length; ++i) {
                imageType2TextureProvider.put(imageTypeArray[i], textureProvider);
            }
        }
    }

    public static void addTextureWriter(TextureWriter textureWriter) {
        textureWriters.add(0, textureWriter);
    }

    public static void setTexRectEnabled(boolean bl) {
        texRectEnabled = bl;
    }

    public static boolean isTexRectEnabled() {
        return texRectEnabled;
    }

    private static TextureData newTextureDataImpl(GLProfile gLProfile, InputStream inputStream, int n, int n2, boolean bl, String string2) throws IOException {
        TextureData textureData;
        block7: {
            if (inputStream == null) {
                throw new IOException("Stream was null");
            }
            if (!(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
            try {
                TextureProvider textureProvider;
                ImageType imageType = new ImageType(inputStream);
                if (imageType.isDefined() && null != (textureProvider = imageType2TextureProvider.get(imageType)) && (textureData = textureProvider.newTextureData(gLProfile, inputStream, n, n2, bl, imageType.type)) != null) {
                    textureData.srcImageType = imageType;
                    return textureData;
                }
            }
            catch (IOException iOException) {
                if (!DEBUG) break block7;
                System.err.println("Caught " + iOException.getMessage());
                iOException.printStackTrace();
            }
        }
        string2 = TextureIO.toLowerCase(string2);
        for (TextureProvider textureProvider : textureProviders) {
            textureData = textureProvider.newTextureData(gLProfile, inputStream, n, n2, bl, string2);
            if (textureData == null) continue;
            if (textureProvider instanceof TextureProvider.SupportsImageTypes) {
                textureData.srcImageType = ((TextureProvider.SupportsImageTypes)((Object)textureProvider)).getImageTypes()[0];
            }
            return textureData;
        }
        throw new IOException("No suitable reader for given stream");
    }

    private static TextureData newTextureDataImpl(GLProfile gLProfile, File file, int n, int n2, boolean bl, String string2) throws IOException {
        if (file == null) {
            throw new IOException("File was null");
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            TextureData textureData = TextureIO.newTextureDataImpl(gLProfile, bufferedInputStream, n, n2, bl, string2 != null ? string2 : IOUtil.getFileSuffix(file));
            return textureData;
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage() + ", given file " + file.getAbsolutePath(), iOException);
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }

    private static TextureData newTextureDataImpl(GLProfile gLProfile, URL uRL, int n, int n2, boolean bl, String string2) throws IOException {
        if (uRL == null) {
            throw new IOException("URL was null");
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
        try {
            TextureData textureData = TextureIO.newTextureDataImpl(gLProfile, bufferedInputStream, n, n2, bl, string2);
            return textureData;
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage() + ", given URL " + uRL, iOException);
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }

    private static int glGetTexLevelParameteri(GL2GL3 gL2GL3, int n, int n2, int n3) {
        int[] nArray = new int[1];
        gL2GL3.glGetTexLevelParameteriv(n, 0, n3, nArray, 0);
        return nArray[0];
    }

    private static String toLowerCase(String string2) {
        if (string2 == null) {
            return null;
        }
        return string2.toLowerCase();
    }

    static {
        block9: {
            Object object;
            block8: {
                DEBUG = Debug.debug("TextureIO");
                texRectEnabled = true;
                textureProviders = new ArrayList<TextureProvider>();
                imageType2TextureProvider = new HashMap<ImageType, TextureProvider>();
                textureWriters = new ArrayList<TextureWriter>();
                if (GLProfile.isAWTAvailable()) {
                    try {
                        object = (TextureProvider)Class.forName("com.jogamp.opengl.util.texture.spi.awt.IIOTextureProvider").newInstance();
                        TextureIO.addTextureProvider((TextureProvider)object);
                    }
                    catch (Exception exception) {
                        if (!DEBUG) break block8;
                        exception.printStackTrace();
                    }
                }
            }
            TextureIO.addTextureProvider(new DDSTextureProvider());
            TextureIO.addTextureProvider(new SGITextureProvider());
            TextureIO.addTextureProvider(new TGATextureProvider());
            TextureIO.addTextureProvider(new JPGTextureProvider());
            TextureIO.addTextureProvider(new PNGTextureProvider());
            if (GLProfile.isAWTAvailable()) {
                try {
                    object = (TextureWriter)Class.forName("com.jogamp.opengl.util.texture.spi.awt.IIOTextureWriter").newInstance();
                    TextureIO.addTextureWriter((TextureWriter)object);
                }
                catch (Exception exception) {
                    if (DEBUG) {
                        exception.printStackTrace();
                    }
                }
                catch (Error error) {
                    if (!DEBUG) break block9;
                    error.printStackTrace();
                }
            }
        }
        TextureIO.addTextureWriter(new DDSTextureWriter());
        TextureIO.addTextureWriter(new SGITextureWriter());
        TextureIO.addTextureWriter(new TGATextureWriter());
        TextureIO.addTextureWriter(new NetPbmTextureWriter());
        TextureIO.addTextureWriter(new PNGTextureWriter());
    }

    static class PNGTextureWriter
    implements TextureWriter {
        PNGTextureWriter() {
        }

        @Override
        public boolean write(File file, TextureData textureData) throws IOException {
            if (TextureIO.PNG.equals(IOUtil.getFileSuffix(file))) {
                GLPixelBuffer.GLPixelAttributes gLPixelAttributes = textureData.getPixelAttributes();
                int n = gLPixelAttributes.format;
                int n2 = gLPixelAttributes.type;
                int n3 = gLPixelAttributes.pfmt.comp.bytesPerPixel();
                PixelFormat pixelFormat = gLPixelAttributes.pfmt;
                if (!(1 != n3 && 3 != n3 && 4 != n3 || n2 != 5120 && n2 != 5121)) {
                    Buffer buffer = textureData.getBuffer();
                    if (null == buffer) {
                        buffer = textureData.getMipmapData()[0];
                    }
                    if (null == buffer) {
                        throw new IOException("Pixel storage buffer is null");
                    }
                    Dimension dimension = new Dimension(textureData.getWidth(), textureData.getHeight());
                    if (buffer instanceof ByteBuffer) {
                        ByteBuffer byteBuffer = (ByteBuffer)buffer;
                        byteBuffer.rewind();
                        PNGPixelRect pNGPixelRect = new PNGPixelRect(pixelFormat, dimension, 0, !textureData.getMustFlipVertically(), byteBuffer, -1.0, -1.0);
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(IOUtil.getFileOutputStream(file, true));
                        pNGPixelRect.write(bufferedOutputStream, true);
                        return true;
                    }
                    if (buffer instanceof IntBuffer) {
                        IntBuffer intBuffer = (IntBuffer)buffer;
                        intBuffer.rewind();
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(IOUtil.getFileOutputStream(file, true));
                        PNGPixelRect.write(pixelFormat, dimension, 0, !textureData.getMustFlipVertically(), intBuffer, -1.0, -1.0, bufferedOutputStream, true);
                        return true;
                    }
                    throw new IOException("PNG writer doesn't support pixel storage buffer of type " + buffer.getClass().getName());
                }
                throw new IOException("PNG writer doesn't support this pixel format 0x" + Integer.toHexString(n) + " / type 0x" + Integer.toHexString(n) + " (only GL_RGB/A, GL_BGR/A + bytes)");
            }
            return false;
        }
    }

    static class TGATextureWriter
    implements TextureWriter {
        TGATextureWriter() {
        }

        @Override
        public boolean write(File file, TextureData textureData) throws IOException {
            if (TextureIO.TGA.equals(IOUtil.getFileSuffix(file))) {
                GLPixelBuffer.GLPixelAttributes gLPixelAttributes = textureData.getPixelAttributes();
                int n = gLPixelAttributes.format;
                int n2 = gLPixelAttributes.type;
                if (!(n != 6407 && n != 6408 && n != 32992 && n != 32993 || n2 != 5120 && n2 != 5121)) {
                    ByteBuffer byteBuffer = (ByteBuffer)textureData.getBuffer();
                    if (null == byteBuffer) {
                        byteBuffer = (ByteBuffer)textureData.getMipmapData()[0];
                    }
                    byteBuffer.rewind();
                    if (n == 6407 || n == 6408) {
                        int n3 = n == 6407 ? 3 : 4;
                        for (int i = 0; i < byteBuffer.remaining(); i += n3) {
                            byte by = byteBuffer.get(i + 0);
                            byte by2 = byteBuffer.get(i + 2);
                            byteBuffer.put(i + 0, by2);
                            byteBuffer.put(i + 2, by);
                        }
                    }
                    TGAImage tGAImage = TGAImage.createFromData(textureData.getWidth(), textureData.getHeight(), n == 6408 || n == 32993, false, byteBuffer);
                    tGAImage.write(file);
                    return true;
                }
                throw new IOException("TGA writer doesn't support this pixel format 0x" + Integer.toHexString(n) + " / type 0x" + Integer.toHexString(n) + " (only GL_RGB/A, GL_BGR/A + bytes)");
            }
            return false;
        }
    }

    static class SGITextureWriter
    implements TextureWriter {
        SGITextureWriter() {
        }

        @Override
        public boolean write(File file, TextureData textureData) throws IOException {
            String string2 = IOUtil.getFileSuffix(file);
            if (TextureIO.SGI.equals(string2) || TextureIO.SGI_RGB.equals(string2)) {
                GLPixelBuffer.GLPixelAttributes gLPixelAttributes = textureData.getPixelAttributes();
                int n = gLPixelAttributes.format;
                int n2 = gLPixelAttributes.type;
                if (!(n != 6407 && n != 6408 || n2 != 5120 && n2 != 5121)) {
                    byte[] byArray;
                    ByteBuffer byteBuffer;
                    ByteBuffer byteBuffer2 = byteBuffer = textureData.getBuffer() != null ? (ByteBuffer)textureData.getBuffer() : (ByteBuffer)textureData.getMipmapData()[0];
                    if (byteBuffer.hasArray()) {
                        byArray = byteBuffer.array();
                    } else {
                        byteBuffer.rewind();
                        byArray = new byte[byteBuffer.remaining()];
                        byteBuffer.get(byArray);
                        byteBuffer.rewind();
                    }
                    SGIImage sGIImage = SGIImage.createFromData(textureData.getWidth(), textureData.getHeight(), n == 6408, byArray);
                    sGIImage.write(file, false);
                    return true;
                }
                throw new IOException("SGI writer doesn't support this pixel format / type (only GL_RGB/A + bytes)");
            }
            return false;
        }
    }

    static class DDSTextureWriter
    implements TextureWriter {
        DDSTextureWriter() {
        }

        @Override
        public boolean write(File file, TextureData textureData) throws IOException {
            if (TextureIO.DDS.equals(IOUtil.getFileSuffix(file))) {
                GLPixelBuffer.GLPixelAttributes gLPixelAttributes = textureData.getPixelAttributes();
                int n = gLPixelAttributes.format;
                int n2 = gLPixelAttributes.type;
                if (n2 != 5120 && n2 != 5121) {
                    throw new IOException("DDS writer only supports byte / unsigned byte textures");
                }
                int n3 = 0;
                switch (n) {
                    case 6407: {
                        n3 = 20;
                        break;
                    }
                    case 6408: {
                        n3 = 21;
                        break;
                    }
                    case 33776: {
                        n3 = 827611204;
                        break;
                    }
                    case 33777: {
                        throw new IOException("RGBA DXT1 not yet supported");
                    }
                    case 33778: {
                        n3 = 861165636;
                        break;
                    }
                    case 33779: {
                        n3 = 894720068;
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported pixel format 0x" + Integer.toHexString(n) + " by DDS writer");
                    }
                }
                ByteBuffer[] byteBufferArray = null;
                if (textureData.getMipmapData() != null) {
                    byteBufferArray = new ByteBuffer[textureData.getMipmapData().length];
                    for (int i = 0; i < byteBufferArray.length; ++i) {
                        byteBufferArray[i] = (ByteBuffer)textureData.getMipmapData()[i];
                    }
                } else {
                    byteBufferArray = new ByteBuffer[]{(ByteBuffer)textureData.getBuffer()};
                }
                DDSImage dDSImage = DDSImage.createFromData(n3, textureData.getWidth(), textureData.getHeight(), byteBufferArray);
                dDSImage.write(file);
                return true;
            }
            return false;
        }
    }

    static class JPGTextureProvider
    extends StreamBasedTextureProvider {
        private static final ImageType[] imageTypes = new ImageType[]{new ImageType("jpg")};

        JPGTextureProvider() {
        }

        @Override
        public final ImageType[] getImageTypes() {
            return imageTypes;
        }

        @Override
        public TextureData newTextureData(GLProfile gLProfile, InputStream inputStream, int n, int n2, boolean bl, String string2) throws IOException {
            if (TextureIO.JPG.equals(string2) || TextureIO.JPG.equals(ImageType.Util.getFileSuffix(inputStream))) {
                JPEGImage jPEGImage = JPEGImage.read(inputStream);
                if (n2 == 0) {
                    n2 = jPEGImage.getGLFormat();
                }
                if (n == 0) {
                    n = gLProfile.isGL2ES3() ? (jPEGImage.getBytesPerPixel() == 4 ? 32856 : 32849) : (jPEGImage.getBytesPerPixel() == 4 ? 6408 : 6407);
                }
                return new TextureData(gLProfile, n, jPEGImage.getWidth(), jPEGImage.getHeight(), 0, n2, jPEGImage.getGLType(), bl, false, false, jPEGImage.getData(), null);
            }
            return null;
        }
    }

    static class PNGTextureProvider
    extends StreamBasedTextureProvider {
        private static final ImageType[] imageTypes = new ImageType[]{new ImageType("png")};

        PNGTextureProvider() {
        }

        @Override
        public final ImageType[] getImageTypes() {
            return imageTypes;
        }

        @Override
        public TextureData newTextureData(GLProfile gLProfile, InputStream inputStream, int n, int n2, boolean bl, String string2) throws IOException {
            if (TextureIO.PNG.equals(string2) || TextureIO.PNG.equals(ImageType.Util.getFileSuffix(inputStream))) {
                PNGPixelRect pNGPixelRect = PNGPixelRect.read(inputStream, null, true, 0, true);
                GLPixelBuffer.GLPixelAttributes gLPixelAttributes = new GLPixelBuffer.GLPixelAttributes(gLProfile, pNGPixelRect.getPixelformat(), false);
                if (0 == n2) {
                    n2 = gLPixelAttributes.format;
                }
                if (0 == n) {
                    boolean bl2;
                    boolean bl3 = bl2 = 4 == gLPixelAttributes.pfmt.comp.bytesPerPixel();
                    n = gLProfile.isGL2ES3() ? (bl2 ? 32856 : 32849) : (bl2 ? 6408 : 6407);
                }
                return new TextureData(gLProfile, n, pNGPixelRect.getSize().getWidth(), pNGPixelRect.getSize().getHeight(), 0, n2, gLPixelAttributes.type, bl, false, false, pNGPixelRect.getPixels(), null);
            }
            return null;
        }
    }

    static class TGATextureProvider
    extends StreamBasedTextureProvider {
        private static final ImageType[] imageTypes = new ImageType[]{new ImageType("tga")};

        TGATextureProvider() {
        }

        @Override
        public final ImageType[] getImageTypes() {
            return imageTypes;
        }

        @Override
        public TextureData newTextureData(GLProfile gLProfile, InputStream inputStream, int n, int n2, boolean bl, String string2) throws IOException {
            if (TextureIO.TGA.equals(string2)) {
                TGAImage tGAImage = TGAImage.read(gLProfile, inputStream);
                if (n2 == 0) {
                    n2 = tGAImage.getGLFormat();
                }
                if (n == 0) {
                    n = gLProfile.isGL2ES3() ? (tGAImage.getBytesPerPixel() == 4 ? 32856 : 32849) : (tGAImage.getBytesPerPixel() == 4 ? 6408 : 6407);
                }
                return new TextureData(gLProfile, n, tGAImage.getWidth(), tGAImage.getHeight(), 0, n2, 5121, bl, false, false, tGAImage.getData(), null);
            }
            return null;
        }
    }

    static class SGITextureProvider
    extends StreamBasedTextureProvider {
        private static final ImageType[] imageTypes = new ImageType[]{new ImageType("rgb")};

        SGITextureProvider() {
        }

        @Override
        public final ImageType[] getImageTypes() {
            return imageTypes;
        }

        @Override
        public TextureData newTextureData(GLProfile gLProfile, InputStream inputStream, int n, int n2, boolean bl, String string2) throws IOException {
            if (TextureIO.SGI.equals(string2) || TextureIO.SGI_RGB.equals(string2) || TextureIO.SGI.equals(ImageType.Util.getFileSuffix(inputStream)) || TextureIO.SGI_RGB.equals(ImageType.Util.getFileSuffix(inputStream))) {
                SGIImage sGIImage = SGIImage.read(inputStream);
                if (n2 == 0) {
                    n2 = sGIImage.getFormat();
                }
                if (n == 0) {
                    n = sGIImage.getFormat();
                }
                return new TextureData(gLProfile, n, sGIImage.getWidth(), sGIImage.getHeight(), 0, n2, 5121, bl, false, false, ByteBuffer.wrap(sGIImage.getData()), null);
            }
            return null;
        }
    }

    static class DDSTextureProvider
    extends StreamBasedTextureProvider {
        private static final ImageType[] imageTypes = new ImageType[]{new ImageType("dds")};

        DDSTextureProvider() {
        }

        @Override
        public final ImageType[] getImageTypes() {
            return imageTypes;
        }

        @Override
        public TextureData newTextureData(GLProfile gLProfile, InputStream inputStream, int n, int n2, boolean bl, String string2) throws IOException {
            if (TextureIO.DDS.equals(string2) || TextureIO.DDS.equals(ImageType.Util.getFileSuffix(inputStream))) {
                byte[] byArray = IOUtil.copyStream2ByteArray(inputStream);
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                DDSImage dDSImage = DDSImage.read(byteBuffer);
                return this.newTextureData(gLProfile, dDSImage, n, n2, bl);
            }
            return null;
        }

        private TextureData newTextureData(GLProfile gLProfile, final DDSImage dDSImage, int n, int n2, boolean bl) {
            TextureData textureData;
            DDSImage.ImageInfo imageInfo = dDSImage.getMipMap(0);
            if (n2 == 0) {
                switch (dDSImage.getPixelFormat()) {
                    case 20: {
                        n2 = 6407;
                        break;
                    }
                    default: {
                        n2 = 6408;
                    }
                }
            }
            if (imageInfo.isCompressed()) {
                switch (imageInfo.getCompressionFormat()) {
                    case 827611204: {
                        n = 33776;
                        break;
                    }
                    case 861165636: {
                        n = 33778;
                        break;
                    }
                    case 894720068: {
                        n = 33779;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported DDS compression format \"" + DDSImage.getCompressionFormatName(imageInfo.getCompressionFormat()) + "\"");
                    }
                }
            }
            if (n == 0) {
                switch (dDSImage.getPixelFormat()) {
                    case 20: {
                        n2 = 6407;
                        break;
                    }
                    default: {
                        n2 = 6408;
                    }
                }
            }
            TextureData.Flusher flusher = new TextureData.Flusher(){

                @Override
                public void flush() {
                    dDSImage.close();
                }
            };
            if (bl && dDSImage.getNumMipMaps() > 0) {
                Buffer[] bufferArray = new Buffer[dDSImage.getNumMipMaps()];
                for (int i = 0; i < dDSImage.getNumMipMaps(); ++i) {
                    bufferArray[i] = dDSImage.getMipMap(i).getData();
                }
                textureData = new TextureData(gLProfile, n, imageInfo.getWidth(), imageInfo.getHeight(), 0, n2, 5121, imageInfo.isCompressed(), true, bufferArray, flusher);
            } else {
                bl = false;
                textureData = new TextureData(gLProfile, n, imageInfo.getWidth(), imageInfo.getHeight(), 0, n2, 5121, bl, imageInfo.isCompressed(), true, imageInfo.getData(), flusher);
            }
            return textureData;
        }
    }

    static abstract class StreamBasedTextureProvider
    implements TextureProvider,
    TextureProvider.SupportsImageTypes {
        StreamBasedTextureProvider() {
        }

        @Override
        public final TextureData newTextureData(GLProfile gLProfile, File file, int n, int n2, boolean bl, String string2) throws IOException {
            throw new UnsupportedOperationException("Only stream is supported");
        }

        @Override
        public final TextureData newTextureData(GLProfile gLProfile, URL uRL, int n, int n2, boolean bl, String string2) throws IOException {
            throw new UnsupportedOperationException("Only stream is supported");
        }
    }
}

