/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.util.locks;

import com.jogamp.common.util.locks.RecursiveLock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class RecursiveLockImplJava5
implements RecursiveLock {
    volatile Thread owner = null;
    ReentrantLock lock;

    public RecursiveLockImplJava5(boolean bl) {
        this.lock = new ReentrantLock(bl);
    }

    @Override
    public void lock() {
        try {
            if (!this.tryLock(TIMEOUT)) {
                throw new RuntimeException("Waited " + TIMEOUT + "ms for: " + this.threadName(this.owner) + " - " + this.threadName(Thread.currentThread()) + ", with count " + this.getHoldCount() + ", lock: " + this);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted", interruptedException);
        }
        this.owner = Thread.currentThread();
    }

    @Override
    public boolean tryLock(long l) throws InterruptedException {
        if (this.lock.tryLock(l, TimeUnit.MILLISECONDS)) {
            this.owner = Thread.currentThread();
            return true;
        }
        return false;
    }

    @Override
    public void unlock() throws RuntimeException {
        this.unlock(null);
    }

    @Override
    public void unlock(Runnable runnable) {
        this.validateLocked();
        this.owner = null;
        if (null != runnable) {
            runnable.run();
        }
        this.lock.unlock();
    }

    @Override
    public boolean isLocked() {
        return this.lock.isLocked();
    }

    @Override
    public Thread getOwner() {
        return this.owner;
    }

    @Override
    public boolean isLockedByOtherThread() {
        return this.lock.isLocked() && !this.lock.isHeldByCurrentThread();
    }

    @Override
    public boolean isOwner(Thread thread2) {
        return this.lock.isLocked() && this.owner == thread2;
    }

    @Override
    public void validateLocked() throws RuntimeException {
        if (!this.lock.isHeldByCurrentThread()) {
            if (!this.lock.isLocked()) {
                throw new RuntimeException(Thread.currentThread() + ": Not locked");
            }
            throw new RuntimeException(Thread.currentThread() + ": Not owner, owner is " + this.owner);
        }
    }

    @Override
    public int getHoldCount() {
        return this.lock.getHoldCount();
    }

    @Override
    public int getQueueLength() {
        return this.lock.getQueueLength();
    }

    private String threadName(Thread thread2) {
        return null != thread2 ? "<" + thread2.getName() + ">" : "<NULL>";
    }
}

