/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow;

import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.ProxySurface;
import com.jogamp.nativewindow.SurfaceUpdatedListener;
import com.jogamp.nativewindow.UpstreamSurfaceHook;
import java.io.PrintStream;
import jogamp.nativewindow.SurfaceUpdatedHelper;

public abstract class ProxySurfaceImpl
implements ProxySurface {
    private final SurfaceUpdatedHelper surfaceUpdatedHelper = new SurfaceUpdatedHelper();
    private AbstractGraphicsConfiguration config;
    private UpstreamSurfaceHook upstream;
    private long surfaceHandle_old;
    private final RecursiveLock surfaceLock = LockFactory.createRecursiveLock();
    private int implBitfield;
    private boolean upstreamSurfaceHookLifecycleEnabled;

    protected ProxySurfaceImpl(AbstractGraphicsConfiguration abstractGraphicsConfiguration, UpstreamSurfaceHook upstreamSurfaceHook, boolean bl) {
        if (null == abstractGraphicsConfiguration) {
            throw new IllegalArgumentException("null AbstractGraphicsConfiguration");
        }
        if (null == upstreamSurfaceHook) {
            throw new IllegalArgumentException("null UpstreamSurfaceHook");
        }
        this.config = abstractGraphicsConfiguration;
        this.upstream = upstreamSurfaceHook;
        this.surfaceHandle_old = 0L;
        this.implBitfield = 0;
        this.upstreamSurfaceHookLifecycleEnabled = true;
        if (bl) {
            this.addUpstreamOptionBits(128);
        }
    }

    @Override
    public final NativeSurface getUpstreamSurface() {
        return this.upstream.getUpstreamSurface();
    }

    @Override
    public final UpstreamSurfaceHook getUpstreamSurfaceHook() {
        return this.upstream;
    }

    @Override
    public void setUpstreamSurfaceHook(UpstreamSurfaceHook upstreamSurfaceHook) {
        if (null == upstreamSurfaceHook) {
            throw new IllegalArgumentException("null UpstreamSurfaceHook");
        }
        this.upstream = upstreamSurfaceHook;
    }

    @Override
    public final void enableUpstreamSurfaceHookLifecycle(boolean bl) {
        this.upstreamSurfaceHookLifecycleEnabled = bl;
    }

    @Override
    public void createNotify() {
        if (this.upstreamSurfaceHookLifecycleEnabled) {
            this.upstream.create(this);
        }
        this.surfaceHandle_old = 0L;
    }

    @Override
    public void destroyNotify() {
        if (this.upstreamSurfaceHookLifecycleEnabled) {
            this.upstream.destroy(this);
            if (this.containsUpstreamOptionBits(128)) {
                AbstractGraphicsDevice abstractGraphicsDevice = this.getGraphicsConfiguration().getScreen().getDevice();
                abstractGraphicsDevice.close();
                this.clearUpstreamOptionBits(128);
            }
            this.invalidateImpl();
        }
        this.surfaceHandle_old = 0L;
    }

    protected void invalidateImpl() {
        throw new InternalError("UpstreamSurfaceHook given, but required method not implemented.");
    }

    @Override
    public final AbstractGraphicsConfiguration getGraphicsConfiguration() {
        return this.config.getNativeGraphicsConfiguration();
    }

    @Override
    public final long getDisplayHandle() {
        return this.config.getNativeGraphicsConfiguration().getScreen().getDevice().getHandle();
    }

    @Override
    public final void setGraphicsConfiguration(AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        this.config = abstractGraphicsConfiguration;
    }

    @Override
    public final int getScreenIndex() {
        return this.getGraphicsConfiguration().getScreen().getIndex();
    }

    @Override
    public abstract long getSurfaceHandle();

    @Override
    public abstract void setSurfaceHandle(long var1);

    @Override
    public final int getSurfaceWidth() {
        return this.upstream.getSurfaceWidth(this);
    }

    @Override
    public final int getSurfaceHeight() {
        return this.upstream.getSurfaceHeight(this);
    }

    @Override
    public boolean surfaceSwap() {
        return false;
    }

    @Override
    public void addSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.surfaceUpdatedHelper.addSurfaceUpdatedListener(surfaceUpdatedListener);
    }

    @Override
    public void addSurfaceUpdatedListener(int n, SurfaceUpdatedListener surfaceUpdatedListener) throws IndexOutOfBoundsException {
        this.surfaceUpdatedHelper.addSurfaceUpdatedListener(n, surfaceUpdatedListener);
    }

    @Override
    public void removeSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.surfaceUpdatedHelper.removeSurfaceUpdatedListener(surfaceUpdatedListener);
    }

    @Override
    public void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
        this.surfaceUpdatedHelper.surfaceUpdated(object, nativeSurface, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lockSurface() throws NativeWindowException, RuntimeException {
        int n;
        this.surfaceLock.lock();
        int n2 = n = this.surfaceLock.getHoldCount() == 1 ? 1 : 3;
        if (1 == n) {
            try {
                AbstractGraphicsDevice abstractGraphicsDevice = this.getGraphicsConfiguration().getScreen().getDevice();
                abstractGraphicsDevice.lock();
                try {
                    n = this.lockSurfaceImpl();
                    if (3 == n && this.surfaceHandle_old != this.getSurfaceHandle()) {
                        n = 2;
                        if (DEBUG) {
                            System.err.println("ProxySurfaceImpl: surface change 0x" + Long.toHexString(this.surfaceHandle_old) + " -> 0x" + Long.toHexString(this.getSurfaceHandle()));
                        }
                    }
                }
                finally {
                    if (1 >= n) {
                        abstractGraphicsDevice.unlock();
                    }
                }
            }
            finally {
                if (1 >= n) {
                    this.surfaceLock.unlock();
                }
            }
        }
        return n;
    }

    @Override
    public final void unlockSurface() {
        this.surfaceLock.validateLocked();
        this.surfaceHandle_old = this.getSurfaceHandle();
        if (this.surfaceLock.getHoldCount() == 1) {
            AbstractGraphicsDevice abstractGraphicsDevice = this.getGraphicsConfiguration().getScreen().getDevice();
            try {
                this.unlockSurfaceImpl();
            }
            finally {
                abstractGraphicsDevice.unlock();
            }
        }
        this.surfaceLock.unlock();
    }

    protected abstract int lockSurfaceImpl();

    protected abstract void unlockSurfaceImpl();

    public final void validateSurfaceLocked() {
        this.surfaceLock.validateLocked();
    }

    @Override
    public final boolean isSurfaceLockedByOtherThread() {
        return this.surfaceLock.isLockedByOtherThread();
    }

    @Override
    public final Thread getSurfaceLockOwner() {
        return this.surfaceLock.getOwner();
    }

    @Override
    public final StringBuilder getUpstreamOptionBits(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("UOB[ ");
        if (0 == this.implBitfield) {
            stringBuilder.append("]");
            return stringBuilder;
        }
        boolean bl = false;
        if (0 != (this.implBitfield & 0x40)) {
            stringBuilder.append("OWNS_SURFACE");
            bl = true;
        }
        if (0 != (this.implBitfield & 0x80)) {
            if (bl) {
                stringBuilder.append(" | ");
            }
            stringBuilder.append("OWNS_DEVICE");
            bl = true;
        }
        if (0 != (this.implBitfield & 0x100)) {
            if (bl) {
                stringBuilder.append(" | ");
            }
            stringBuilder.append("WINDOW_INVISIBLE");
            bl = true;
        }
        if (0 != (this.implBitfield & 0x200)) {
            if (bl) {
                stringBuilder.append(" | ");
            }
            stringBuilder.append("SURFACELESS");
            bl = true;
        }
        stringBuilder.append(" ]");
        return stringBuilder;
    }

    @Override
    public final int getUpstreamOptionBits() {
        return this.implBitfield;
    }

    @Override
    public final boolean containsUpstreamOptionBits(int n) {
        return n == (this.implBitfield & n);
    }

    @Override
    public final void addUpstreamOptionBits(int n) {
        this.implBitfield |= n;
    }

    @Override
    public final void clearUpstreamOptionBits(int n) {
        this.implBitfield &= ~n;
    }

    public static void dumpHierarchy(PrintStream printStream, ProxySurface proxySurface) {
        printStream.println("Surface Hierarchy of " + proxySurface.getClass().getName());
        ProxySurfaceImpl.dumpHierarchy(printStream, proxySurface, "");
        printStream.println();
    }

    private static void dumpHierarchy(PrintStream printStream, NativeSurface nativeSurface, String string2) {
        string2 = string2 + "  ";
        printStream.println(string2 + "Surface device " + nativeSurface.getGraphicsConfiguration().getScreen().getDevice());
        printStream.println(string2 + "Surface size " + nativeSurface.getSurfaceWidth() + "x" + nativeSurface.getSurfaceHeight() + ", handle 0x" + Long.toHexString(nativeSurface.getSurfaceHandle()));
        if (nativeSurface instanceof ProxySurfaceImpl) {
            ProxySurface proxySurface = (ProxySurface)nativeSurface;
            printStream.println(string2 + "Upstream options " + proxySurface.getUpstreamOptionBits(null).toString());
            UpstreamSurfaceHook upstreamSurfaceHook = proxySurface.getUpstreamSurfaceHook();
            if (null != upstreamSurfaceHook) {
                printStream.println(string2 + "Upstream Hook " + upstreamSurfaceHook.getClass().getName());
                NativeSurface nativeSurface2 = upstreamSurfaceHook.getUpstreamSurface();
                string2 = string2 + "  ";
                if (null != nativeSurface2) {
                    printStream.println(string2 + "Upstream Hook's Surface " + nativeSurface2.getClass().getName());
                    ProxySurfaceImpl.dumpHierarchy(printStream, nativeSurface2, string2);
                } else {
                    printStream.println(string2 + "Upstream Hook's Surface NULL");
                }
            }
        }
    }

    @Override
    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("displayHandle 0x" + Long.toHexString(this.getDisplayHandle())).append("\n, surfaceHandle 0x" + Long.toHexString(this.getSurfaceHandle())).append("\n, size " + this.getSurfaceWidth() + "x" + this.getSurfaceHeight()).append("\n, ");
        this.getUpstreamOptionBits(stringBuilder);
        stringBuilder.append("\n, " + this.config).append("\n, surfaceLock " + this.surfaceLock + "\n, ").append(this.getUpstreamSurfaceHook()).append("\n, upstreamSurface " + (null != this.getUpstreamSurface()));
        return stringBuilder;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName()).append("[ ");
        this.toString(stringBuilder);
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }
}

