/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.opengl.FPSCounter;
import java.io.PrintStream;
import java.util.concurrent.TimeUnit;

public class FPSCounterImpl
implements FPSCounter {
    private int fpsUpdateFramesInterval;
    private PrintStream fpsOutputStream;
    private long fpsStartTime;
    private long fpsLastUpdateTime;
    private long fpsLastPeriod;
    private long fpsTotalDuration;
    private int fpsTotalFrames;
    private float fpsLast;
    private float fpsTotal;

    public FPSCounterImpl() {
        this.setUpdateFPSFrames(0, null);
    }

    public final synchronized void tickFPS() {
        ++this.fpsTotalFrames;
        if (this.fpsUpdateFramesInterval > 0 && this.fpsTotalFrames % this.fpsUpdateFramesInterval == 0) {
            long l = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            this.fpsLastPeriod = l - this.fpsLastUpdateTime;
            this.fpsLastPeriod = Math.max(this.fpsLastPeriod, 1L);
            this.fpsLast = (float)this.fpsUpdateFramesInterval * 1000.0f / (float)this.fpsLastPeriod;
            this.fpsTotalDuration = l - this.fpsStartTime;
            this.fpsTotalDuration = Math.max(this.fpsTotalDuration, 1L);
            this.fpsTotal = (float)this.fpsTotalFrames * 1000.0f / (float)this.fpsTotalDuration;
            if (null != this.fpsOutputStream) {
                this.fpsOutputStream.println(this.toString());
            }
            this.fpsLastUpdateTime = l;
        }
    }

    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        String string2 = String.valueOf(this.fpsLast);
        string2 = string2.substring(0, string2.indexOf(46) + 2);
        String string3 = String.valueOf(this.fpsTotal);
        string3 = string3.substring(0, string3.indexOf(46) + 2);
        stringBuilder.append(this.fpsTotalDuration / 1000L + " s: " + this.fpsUpdateFramesInterval + " f / " + this.fpsLastPeriod + " ms, " + string2 + " fps, " + this.fpsLastPeriod / (long)this.fpsUpdateFramesInterval + " ms/f; " + "total: " + this.fpsTotalFrames + " f, " + string3 + " fps, " + this.fpsTotalDuration / (long)this.fpsTotalFrames + " ms/f");
        return stringBuilder;
    }

    public String toString() {
        return this.toString(null).toString();
    }

    @Override
    public final synchronized void setUpdateFPSFrames(int n, PrintStream printStream) {
        this.fpsUpdateFramesInterval = n;
        this.fpsOutputStream = printStream;
        this.resetFPSCounter();
    }

    @Override
    public final synchronized void resetFPSCounter() {
        this.fpsLastUpdateTime = this.fpsStartTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        this.fpsLastPeriod = 0L;
        this.fpsTotalFrames = 0;
        this.fpsLast = 0.0f;
        this.fpsTotal = 0.0f;
        this.fpsLastPeriod = 0L;
        this.fpsTotalDuration = 0L;
    }

    @Override
    public final synchronized int getUpdateFPSFrames() {
        return this.fpsUpdateFramesInterval;
    }

    @Override
    public final synchronized long getFPSStartTime() {
        return this.fpsStartTime;
    }

    @Override
    public final synchronized long getLastFPSUpdateTime() {
        return this.fpsLastUpdateTime;
    }

    @Override
    public final synchronized long getLastFPSPeriod() {
        return this.fpsLastPeriod;
    }

    @Override
    public final synchronized float getLastFPS() {
        return this.fpsLast;
    }

    @Override
    public final synchronized int getTotalFPSFrames() {
        return this.fpsTotalFrames;
    }

    @Override
    public final synchronized long getTotalFPSDuration() {
        return this.fpsTotalDuration;
    }

    @Override
    public final synchronized float getTotalFPS() {
        return this.fpsTotal;
    }
}

