/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.av;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.net.Uri;
import com.jogamp.common.net.UriQueryProps;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.common.util.InterruptedRuntimeException;
import com.jogamp.common.util.LFRingbuffer;
import com.jogamp.common.util.Ringbuffer;
import com.jogamp.common.util.SourcedInterruptedException;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.TimeFrameI;
import com.jogamp.opengl.util.av.AudioSink;
import com.jogamp.opengl.util.av.GLMediaPlayer;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jogamp.opengl.Debug;

public abstract class GLMediaPlayerImpl
implements GLMediaPlayer {
    private static final int STREAM_WORKER_DELAY = Debug.getIntProperty("jogl.debug.GLMediaPlayer.StreamWorker.delay", false, 0);
    private static final String unknown = "unknown";
    private volatile GLMediaPlayer.State state;
    private final Object stateLock = new Object();
    private int textureCount = 0;
    private int textureTarget = 3553;
    private int textureFormat = 6408;
    private int textureInternalFormat = 6408;
    private int textureType = 5121;
    private int texUnit = 0;
    private int textureFragmentShaderHashCode = 0;
    private final int[] texMinMagFilter = new int[]{9728, 9728};
    private final int[] texWrapST = new int[]{33071, 33071};
    private Uri streamLoc = null;
    protected Uri.Encoded cameraPath = null;
    protected Map<String, String> cameraProps = null;
    private volatile float playSpeed = 1.0f;
    private float audioVolume = 1.0f;
    private int vid = -1;
    private int aid = -1;
    private int width = 0;
    private int height = 0;
    private float fps = 0.0f;
    private float frame_duration = 0.0f;
    private int bps_stream = 0;
    private int bps_video = 0;
    private int bps_audio = 0;
    private int videoFrames = 0;
    private int audioFrames = 0;
    private int duration = 0;
    private String acodec = "unknown";
    private String vcodec = "unknown";
    private volatile int decodedFrameCount = 0;
    private int presentedFrameCount = 0;
    private int displayedFrameCount = 0;
    private volatile int video_pts_last = 0;
    private int nullFrameCount = 0;
    private int maxNullFrameCountUntilEOS = 0;
    private static final int MAX_FRAMELESS_MS_UNTIL_EOS = 5000;
    private static final int MAX_FRAMELESS_UNTIL_EOS_DEFAULT = 166;
    protected AudioSink audioSink = null;
    protected boolean audioSinkPlaySpeedSet = false;
    private long audio_scr_t0 = 0L;
    private boolean audioSCR_reset = true;
    private long video_scr_t0 = 0L;
    private int video_scr_pts = 0;
    private float video_dpts_cum = 0.0f;
    private int video_dpts_count = 0;
    private static final int VIDEO_DPTS_NUM = 20;
    private static final float VIDEO_DPTS_COEFF = 0.7943282f;
    private static final int VIDEO_DPTS_MAX = 5000;
    private boolean videoSCR_reset = false;
    private TextureSequence.TextureFrame[] videoFramesOrig = null;
    private Ringbuffer<TextureSequence.TextureFrame> videoFramesFree = null;
    private Ringbuffer<TextureSequence.TextureFrame> videoFramesDecoded = null;
    private volatile TextureSequence.TextureFrame lastFrame = null;
    private boolean isInGLOrientation = false;
    private final ArrayList<GLMediaPlayer.GLMediaEventListener> eventListeners = new ArrayList();
    private TextureSequence.TextureFrame cachedFrame = null;
    private long lastTimeMillis = 0L;
    private final boolean[] stGotVFrame = new boolean[]{false};
    static int StreamWorkerInstanceId = 0;
    private volatile StreamWorker streamWorker = null;
    private volatile GLMediaPlayer.StreamException streamErr = null;
    private final Object eventListenersLock = new Object();
    private final HashMap<String, Object> attachedObjects = new HashMap();

    protected GLMediaPlayerImpl() {
        this.state = GLMediaPlayer.State.Uninitialized;
    }

    @Override
    public final void setTextureUnit(int n) {
        this.texUnit = n;
    }

    @Override
    public final int getTextureUnit() {
        return this.texUnit;
    }

    @Override
    public final int getTextureTarget() {
        return this.textureTarget;
    }

    protected final int getTextureFormat() {
        return this.textureFormat;
    }

    protected final int getTextureType() {
        return this.textureType;
    }

    @Override
    public final int getTextureCount() {
        return this.textureCount;
    }

    protected final void setTextureTarget(int n) {
        this.textureTarget = n;
    }

    protected final void setTextureFormat(int n, int n2) {
        this.textureInternalFormat = n;
        this.textureFormat = n2;
    }

    protected final void setTextureType(int n) {
        this.textureType = n;
    }

    @Override
    public final void setTextureMinMagFilter(int[] nArray) {
        this.texMinMagFilter[0] = nArray[0];
        this.texMinMagFilter[1] = nArray[1];
    }

    @Override
    public final int[] getTextureMinMagFilter() {
        return this.texMinMagFilter;
    }

    @Override
    public final void setTextureWrapST(int[] nArray) {
        this.texWrapST[0] = nArray[0];
        this.texWrapST[1] = nArray[1];
    }

    @Override
    public final int[] getTextureWrapST() {
        return this.texWrapST;
    }

    private final void checkGLInit() {
        if (GLMediaPlayer.State.Uninitialized == this.state || GLMediaPlayer.State.Initialized == this.state) {
            throw new IllegalStateException("GL not initialized: " + this);
        }
    }

    @Override
    public String getRequiredExtensionsShaderStub() throws IllegalStateException {
        this.checkGLInit();
        if (36197 == this.textureTarget) {
            return ShaderCode.createExtensionDirective("GL_OES_EGL_image_external", "enable");
        }
        return "";
    }

    @Override
    public String getTextureSampler2DType() throws IllegalStateException {
        this.checkGLInit();
        switch (this.textureTarget) {
            case 3553: 
            case 34037: {
                return "sampler2D";
            }
            case 36197: {
                return "samplerExternalOES";
            }
        }
        throw new GLException("Unsuported texture target: " + GLMediaPlayerImpl.toHexString(this.textureTarget));
    }

    @Override
    public String getTextureLookupFunctionName(String string2) throws IllegalStateException {
        this.checkGLInit();
        return "texture2D";
    }

    @Override
    public String getTextureLookupFragmentShaderImpl() throws IllegalStateException {
        this.checkGLInit();
        return "";
    }

    @Override
    public final int getTextureFragmentShaderHashCode() {
        if (!this.isTextureAvailable()) {
            this.textureFragmentShaderHashCode = 0;
            return 0;
        }
        if (0 == this.textureFragmentShaderHashCode) {
            int n = 31 + this.getTextureLookupFragmentShaderImpl().hashCode();
            this.textureFragmentShaderHashCode = n = (n << 5) - n + this.getTextureSampler2DType().hashCode();
        }
        return this.textureFragmentShaderHashCode;
    }

    @Override
    public final int getDecodedFrameCount() {
        return this.decodedFrameCount;
    }

    @Override
    public final int getPresentedFrameCount() {
        return this.presentedFrameCount;
    }

    @Override
    public final int getVideoPTS() {
        return this.video_pts_last;
    }

    @Override
    public final int getAudioPTS() {
        if (GLMediaPlayer.State.Uninitialized != this.state) {
            return this.getAudioPTSImpl();
        }
        return 0;
    }

    protected int getAudioPTSImpl() {
        if (null != this.audioSink) {
            return this.audioSink.getPTS();
        }
        return 0;
    }

    @Override
    public final GLMediaPlayer.State getState() {
        return this.state;
    }

    protected final void setState(GLMediaPlayer.State state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GLMediaPlayer.State play() {
        Object object = this.stateLock;
        synchronized (object) {
            GLMediaPlayer.State state = this.state;
            switch (this.state) {
                case Paused: {
                    if (!this.playImpl()) break;
                    this.resetAVPTS();
                    if (null != this.audioSink) {
                        this.audioSink.play();
                    }
                    if (null != this.streamWorker) {
                        this.streamWorker.doResume();
                    }
                    this.changeState(0, GLMediaPlayer.State.Playing);
                }
            }
            if (DEBUG) {
                System.err.println("Play: " + (Object)((Object)state) + " -> " + (Object)((Object)this.state) + ", " + this.toString());
            }
            return this.state;
        }
    }

    protected abstract boolean playImpl();

    @Override
    public final GLMediaPlayer.State pause(boolean bl) {
        return this.pauseImpl(bl, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final GLMediaPlayer.State pauseImpl(boolean bl, int n) {
        Object object = this.stateLock;
        synchronized (object) {
            GLMediaPlayer.State state = this.state;
            if (GLMediaPlayer.State.Playing == this.state) {
                n = this.addStateEventMask(n, GLMediaPlayer.State.Paused);
                this.setState(GLMediaPlayer.State.Paused);
                if (null != this.streamWorker) {
                    this.streamWorker.doPause(true);
                }
                if (bl) {
                    this.resetAVPTSAndFlush();
                } else if (null != this.audioSink) {
                    this.audioSink.pause();
                }
                this.attributesUpdated(n);
                if (!this.pauseImpl()) {
                    this.play();
                }
            }
            if (DEBUG) {
                System.err.println("Pause: " + (Object)((Object)state) + " -> " + (Object)((Object)this.state) + ", " + this.toString());
            }
            return this.state;
        }
    }

    protected abstract boolean pauseImpl();

    @Override
    public final GLMediaPlayer.State destroy(GL gL) {
        return this.destroyImpl(gL, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final GLMediaPlayer.State destroyImpl(GL gL, int n) {
        Object object = this.stateLock;
        synchronized (object) {
            if (null != this.streamWorker) {
                this.streamWorker.doStop();
                this.streamWorker = null;
            }
            this.destroyImpl(gL);
            this.removeAllTextureFrames(gL);
            this.textureCount = 0;
            this.changeState(n, GLMediaPlayer.State.Uninitialized);
            this.attachedObjects.clear();
            return this.state;
        }
    }

    protected abstract void destroyImpl(GL var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int seek(int n) {
        Object object = this.stateLock;
        synchronized (object) {
            int n2;
            GLMediaPlayer.State state = this.state;
            switch (this.state) {
                case Paused: 
                case Playing: {
                    GLMediaPlayer.State state2 = this.state;
                    this.setState(GLMediaPlayer.State.Paused);
                    if (null != this.streamWorker) {
                        this.streamWorker.doPause(true);
                    }
                    if (n >= this.duration) {
                        n = this.duration - (int)Math.floor(this.frame_duration);
                    } else if (n < 0) {
                        n = 0;
                    }
                    n2 = this.seekImpl(n);
                    this.resetAVPTSAndFlush();
                    if (null != this.audioSink && GLMediaPlayer.State.Playing == state2) {
                        this.audioSink.play();
                    }
                    if (DEBUG) {
                        System.err.println("Seek(" + n + "): " + this.getPerfString());
                    }
                    if (null != this.streamWorker) {
                        this.streamWorker.doResume();
                    }
                    this.setState(state2);
                    break;
                }
                default: {
                    n2 = 0;
                }
            }
            if (DEBUG) {
                System.err.println("Seek(" + n + "): " + (Object)((Object)state) + " -> " + (Object)((Object)this.state) + ", " + this.toString());
            }
            return n2;
        }
    }

    protected abstract int seekImpl(int var1);

    @Override
    public final float getPlaySpeed() {
        return this.playSpeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean setPlaySpeed(float f) {
        Object object = this.stateLock;
        synchronized (object) {
            float f2 = this.playSpeed;
            boolean bl = false;
            if (GLMediaPlayer.State.Uninitialized != this.state && f > 0.01f) {
                if (Math.abs(1.0f - f) < 0.01f) {
                    f = 1.0f;
                }
                if (this.setPlaySpeedImpl(f)) {
                    this.resetAVPTS();
                    this.playSpeed = f;
                    bl = true;
                }
            }
            if (DEBUG) {
                System.err.println("setPlaySpeed(" + f + "): " + (Object)((Object)this.state) + ", " + f2 + " -> " + this.playSpeed + ", " + this.toString());
            }
            return bl;
        }
    }

    protected boolean setPlaySpeedImpl(float f) {
        if (null != this.audioSink) {
            this.audioSinkPlaySpeedSet = this.audioSink.setPlaySpeed(f);
        }
        return true;
    }

    @Override
    public final float getAudioVolume() {
        this.getAudioVolumeImpl();
        return this.audioVolume;
    }

    protected void getAudioVolumeImpl() {
        if (null != this.audioSink) {
            this.audioVolume = this.audioSink.getVolume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setAudioVolume(float f) {
        Object object = this.stateLock;
        synchronized (object) {
            float f2 = this.audioVolume;
            boolean bl = false;
            if (GLMediaPlayer.State.Uninitialized != this.state) {
                if (Math.abs(f) < 0.01f) {
                    f = 0.0f;
                } else if (Math.abs(1.0f - f) < 0.01f) {
                    f = 1.0f;
                }
                if (this.setAudioVolumeImpl(f)) {
                    this.audioVolume = f;
                    bl = true;
                }
            }
            if (DEBUG) {
                System.err.println("setAudioVolume(" + f + "): " + (Object)((Object)this.state) + ", " + f2 + " -> " + this.audioVolume + ", " + this.toString());
            }
            return bl;
        }
    }

    protected boolean setAudioVolumeImpl(float f) {
        if (null != this.audioSink) {
            return this.audioSink.setVolume(f);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void initStream(Uri uri, final int n, final int n2, int n3) throws IllegalStateException, IllegalArgumentException {
        Object object = this.stateLock;
        synchronized (object) {
            if (GLMediaPlayer.State.Uninitialized != this.state) {
                throw new IllegalStateException("Instance not in state unintialized: " + this);
            }
            if (null == uri) {
                throw new IllegalArgumentException("streamLock is null");
            }
            if (-2 != n) {
                this.textureCount = this.validateTextureCount(n3);
                if (this.textureCount < 1) {
                    throw new InternalError("Validated texture count < 1: " + this.textureCount);
                }
            } else {
                this.textureCount = 0;
            }
            this.decodedFrameCount = 0;
            this.presentedFrameCount = 0;
            this.displayedFrameCount = 0;
            this.nullFrameCount = 0;
            this.maxNullFrameCountUntilEOS = 166;
            this.streamLoc = uri;
            this.cameraPath = null;
            this.cameraProps = null;
            Uri.Encoded encoded = uri.scheme;
            if (null != encoded && encoded.equals(CameraInputScheme)) {
                Uri.Encoded encoded2 = uri.path;
                if (null != encoded2 && encoded2.length() > 0) {
                    this.cameraPath = encoded2.substring(1);
                    UriQueryProps uriQueryProps = UriQueryProps.create(uri, ';');
                    this.cameraProps = uriQueryProps.getProperties();
                } else {
                    throw new IllegalArgumentException("Camera path is empty: " + uri.toString());
                }
            }
            this.vid = n;
            this.aid = n2;
            new InterruptSource.Thread(){

                @Override
                public void run() {
                    try {
                        GLMediaPlayerImpl.this.initStreamImpl(n, n2);
                    }
                    catch (Throwable throwable) {
                        GLMediaPlayerImpl.this.streamErr = new GLMediaPlayer.StreamException(throwable.getClass().getSimpleName() + " while initializing: " + GLMediaPlayerImpl.this.toString(), throwable);
                        GLMediaPlayerImpl.this.changeState(32, GLMediaPlayer.State.Uninitialized);
                    }
                }
            }.start();
        }
    }

    protected abstract void initStreamImpl(int var1, int var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GLMediaPlayer.StreamException getStreamException() {
        GLMediaPlayer.StreamException streamException;
        Object object = this.stateLock;
        synchronized (object) {
            streamException = this.streamErr;
            this.streamErr = null;
        }
        return streamException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void initGL(GL gL) throws IllegalStateException, GLMediaPlayer.StreamException, GLException {
        Object object = this.stateLock;
        synchronized (object) {
            GLMediaPlayer.StreamException streamException;
            if (GLMediaPlayer.State.Initialized != this.state) {
                throw new IllegalStateException("Stream not in state initialized: " + this);
            }
            if (null != this.streamWorker && null != (streamException = this.getStreamException())) {
                this.streamWorker = null;
                this.destroy(null);
                throw streamException;
            }
            try {
                if (-2 != this.vid) {
                    this.removeAllTextureFrames(gL);
                    this.initGLImpl(gL);
                    if (DEBUG) {
                        System.err.println("initGLImpl.X " + this);
                    }
                    this.videoFramesOrig = this.createTexFrames(gL, this.textureCount);
                    if (1 == this.textureCount) {
                        this.videoFramesFree = null;
                        this.videoFramesDecoded = null;
                        this.lastFrame = this.videoFramesOrig[0];
                    } else {
                        this.videoFramesFree = new LFRingbuffer<TextureSequence.TextureFrame>(this.videoFramesOrig);
                        this.videoFramesDecoded = new LFRingbuffer<TextureSequence.TextureFrame>(TextureSequence.TextureFrame[].class, this.textureCount);
                        this.lastFrame = this.videoFramesFree.getBlocking();
                    }
                    if (null != this.streamWorker) {
                        this.streamWorker.initGL(gL);
                    }
                } else {
                    this.removeAllTextureFrames(null);
                    this.initGLImpl(null);
                    this.setTextureFormat(-1, -1);
                    this.setTextureType(-1);
                    this.videoFramesOrig = null;
                    this.videoFramesFree = null;
                    this.videoFramesDecoded = null;
                    this.lastFrame = null;
                }
                this.changeState(0, GLMediaPlayer.State.Paused);
            }
            catch (Throwable throwable) {
                this.destroyImpl(gL, 32);
                throw new GLException("Error initializing GL resources", throwable);
            }
        }
    }

    protected abstract void initGLImpl(GL var1) throws IOException, GLException;

    protected int validateTextureCount(int n) {
        return n < 1 ? 1 : n;
    }

    protected TextureSequence.TextureFrame[] createTexFrames(GL gL, int n) {
        int[] nArray = new int[n];
        gL.glGenTextures(n, nArray, 0);
        int n2 = gL.glGetError();
        if (0 != n2) {
            throw new RuntimeException("TextureNames creation failed (num: " + n + "): err " + GLMediaPlayerImpl.toHexString(n2));
        }
        TextureSequence.TextureFrame[] textureFrameArray = new TextureSequence.TextureFrame[n];
        for (int i = 0; i < n; ++i) {
            textureFrameArray[i] = this.createTexImage(gL, nArray[i]);
        }
        return textureFrameArray;
    }

    protected abstract TextureSequence.TextureFrame createTexImage(GL var1, int var2);

    protected final Texture createTexImageImpl(GL gL, int n, int n2, int n3) {
        if (0 > n) {
            throw new RuntimeException("TextureName " + GLMediaPlayerImpl.toHexString(n) + " invalid.");
        }
        gL.glActiveTexture(33984 + this.getTextureUnit());
        gL.glBindTexture(this.textureTarget, n);
        int n4 = gL.glGetError();
        if (0 != n4) {
            throw new RuntimeException("Couldn't bind textureName " + GLMediaPlayerImpl.toHexString(n) + " to 2D target, err " + GLMediaPlayerImpl.toHexString(n4));
        }
        if (36197 != this.textureTarget) {
            gL.glTexImage2D(this.textureTarget, 0, this.textureInternalFormat, n2, n3, 0, this.textureFormat, this.textureType, null);
            n4 = gL.glGetError();
            if (0 != n4) {
                throw new RuntimeException("Couldn't create TexImage2D RGBA " + n2 + "x" + n3 + ", target " + GLMediaPlayerImpl.toHexString(this.textureTarget) + ", ifmt " + GLMediaPlayerImpl.toHexString(this.textureInternalFormat) + ", fmt " + GLMediaPlayerImpl.toHexString(this.textureFormat) + ", type " + GLMediaPlayerImpl.toHexString(this.textureType) + ", err " + GLMediaPlayerImpl.toHexString(n4));
            }
            if (DEBUG) {
                System.err.println("Created TexImage2D RGBA " + n2 + "x" + n3 + ", target " + GLMediaPlayerImpl.toHexString(this.textureTarget) + ", ifmt " + GLMediaPlayerImpl.toHexString(this.textureInternalFormat) + ", fmt " + GLMediaPlayerImpl.toHexString(this.textureFormat) + ", type " + GLMediaPlayerImpl.toHexString(this.textureType));
            }
        }
        gL.glTexParameteri(this.textureTarget, 10241, this.texMinMagFilter[0]);
        gL.glTexParameteri(this.textureTarget, 10240, this.texMinMagFilter[1]);
        gL.glTexParameteri(this.textureTarget, 10242, this.texWrapST[0]);
        gL.glTexParameteri(this.textureTarget, 10243, this.texWrapST[1]);
        return new Texture(n, this.textureTarget, n2, n3, this.width, this.height, !this.isInGLOrientation);
    }

    protected void destroyTexFrame(GL gL, TextureSequence.TextureFrame textureFrame) {
        textureFrame.getTexture().destroy(gL);
    }

    @Override
    public final boolean isTextureAvailable() {
        return GLMediaPlayer.State.Paused == this.state || GLMediaPlayer.State.Playing == this.state;
    }

    @Override
    public final TextureSequence.TextureFrame getLastTexture() throws IllegalStateException {
        if (GLMediaPlayer.State.Paused != this.state && GLMediaPlayer.State.Playing != this.state) {
            throw new IllegalStateException("Instance not paused or playing: " + this);
        }
        return this.lastFrame;
    }

    private final void removeAllTextureFrames(GL gL) {
        TextureSequence.TextureFrame[] textureFrameArray = this.videoFramesOrig;
        this.videoFramesOrig = null;
        this.videoFramesFree = null;
        this.videoFramesDecoded = null;
        this.lastFrame = null;
        if (null != textureFrameArray) {
            for (int i = 0; i < textureFrameArray.length; ++i) {
                TextureSequence.TextureFrame textureFrame = textureFrameArray[i];
                if (null != textureFrame) {
                    if (null != gL) {
                        this.destroyTexFrame(gL, textureFrame);
                    }
                    textureFrameArray[i] = null;
                }
                if (!DEBUG) continue;
                System.err.println(Thread.currentThread().getName() + "> Clear TexFrame[" + i + "]: " + textureFrame + " -> null");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final TextureSequence.TextureFrame getNextTexture(GL gL) throws IllegalStateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (GLMediaPlayer.State.Paused != this.state && GLMediaPlayer.State.Playing != this.state) {
                throw new IllegalStateException("Instance not paused or playing: " + this);
            }
            if (GLMediaPlayer.State.Playing == this.state) {
                boolean bl = false;
                try {
                    do {
                        int n;
                        int n2;
                        int n3;
                        int n4;
                        boolean bl2;
                        int n5;
                        TextureSequence.TextureFrame textureFrame;
                        boolean bl3;
                        boolean bl4;
                        if (bl) {
                            --this.presentedFrameCount;
                            bl = false;
                            bl4 = true;
                        } else {
                            bl4 = false;
                        }
                        boolean bl5 = bl3 = null != this.cachedFrame;
                        if (bl3) {
                            textureFrame = this.cachedFrame;
                            this.cachedFrame = null;
                            --this.presentedFrameCount;
                            n5 = textureFrame.getPTS();
                            bl2 = true;
                        } else if (null != this.videoFramesDecoded) {
                            textureFrame = this.videoFramesDecoded.get();
                            if (null != textureFrame) {
                                n5 = textureFrame.getPTS();
                                bl2 = true;
                            } else {
                                n5 = Integer.MIN_VALUE;
                                bl2 = false;
                            }
                        } else {
                            n5 = this.getNextSingleThreaded(gL, this.lastFrame, this.stGotVFrame);
                            textureFrame = this.lastFrame;
                            bl2 = this.stGotVFrame[0];
                        }
                        long l = Platform.currentTimeMillis();
                        if (Integer.MAX_VALUE == n5 || this.duration > 0 && this.duration <= n5 || this.maxNullFrameCountUntilEOS <= this.nullFrameCount) {
                            if (DEBUG) {
                                System.err.println("AV-EOS (getNextTexture): EOS_PTS " + (Integer.MAX_VALUE == n5) + ", " + this);
                            }
                            this.pauseImpl(true, 16);
                        } else if (Integer.MIN_VALUE == n5) {
                            if (null == this.videoFramesDecoded || !this.videoFramesDecoded.isEmpty()) {
                                ++this.nullFrameCount;
                            }
                            if (DEBUG) {
                                int n6 = this.getAudioPTSImpl();
                                n4 = (int)((float)(l - this.audio_scr_t0) * this.playSpeed);
                                n3 = n6 != Integer.MIN_VALUE ? n6 - n4 : 0;
                                n2 = this.video_scr_pts + (int)((float)(l - this.video_scr_t0) * this.playSpeed);
                                n = n5 - n2;
                                System.err.println("AV~: dT " + (l - this.lastTimeMillis) + ", nullFrames " + this.nullFrameCount + this.getPerfStringImpl(n2, n5, n, n4, n6, n3, 0) + ", droppedFrame " + bl4);
                            }
                        } else {
                            this.nullFrameCount = 0;
                            if (bl2) {
                                int n7;
                                ++this.presentedFrameCount;
                                int n8 = this.getAudioPTSImpl();
                                n4 = (int)((float)(l - this.audio_scr_t0) * this.playSpeed);
                                n3 = n8 != Integer.MIN_VALUE ? n8 - n4 : 0;
                                n2 = n5 - this.video_pts_last;
                                if (this.videoSCR_reset || (float)n2 > this.frame_duration * 10.0f) {
                                    this.videoSCR_reset = false;
                                    this.video_scr_t0 = l;
                                    this.video_scr_pts = n5;
                                }
                                if (-5000 > (n7 = n5 - (n = this.video_scr_pts + (int)((float)(l - this.video_scr_t0) * this.playSpeed))) || n7 > 5000) {
                                    if (DEBUG) {
                                        System.err.println("AV*: dT " + (l - this.lastTimeMillis) + ", " + this.getPerfStringImpl(n, n5, n7, n4, n8, n3, 0) + ", " + textureFrame + ", playCached " + bl3 + ", dropFrame " + bl);
                                    }
                                } else {
                                    int n9 = this.displayedFrameCount > 0 ? this.displayedFrameCount : 1;
                                    int n10 = (int)(l - this.video_scr_t0) / n9;
                                    int n11 = Math.min(n10, 22);
                                    ++this.video_dpts_count;
                                    this.video_dpts_cum = (float)n7 + 0.7943282f * this.video_dpts_cum;
                                    int n12 = this.video_dpts_count >= 20 ? this.getVideoDPTSAvg() : 0;
                                    int n13 = (int)((float)n12 / this.playSpeed + 0.5f);
                                    TextureSequence.TextureFrame textureFrame2 = textureFrame;
                                    if (n13 > n11) {
                                        this.cachedFrame = textureFrame;
                                        textureFrame = null;
                                    } else if (!bl4 && n13 < -n11 && null != this.videoFramesDecoded && this.videoFramesDecoded.size() > 0) {
                                        bl = true;
                                    }
                                    this.video_pts_last = n5;
                                    if (DEBUG) {
                                        System.err.println("AV_: dT " + (l - this.lastTimeMillis) + ", " + this.getPerfStringImpl(n, n5, n7, n4, n8, n3, n12) + ", avg dpy-fps " + n10 + " ms/f, maxD " + n11 + " ms, " + textureFrame2 + ", playCached " + bl3 + ", dropFrame " + bl);
                                    }
                                }
                            }
                        }
                        if (null != this.videoFramesFree && null != textureFrame) {
                            TextureSequence.TextureFrame textureFrame3 = this.lastFrame;
                            this.lastFrame = textureFrame;
                            if (null != textureFrame3) {
                                this.videoFramesFree.putBlocking(textureFrame3);
                            }
                        }
                        this.lastTimeMillis = l;
                    } while (bl);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            ++this.displayedFrameCount;
            return this.lastFrame;
        }
    }

    protected void preNextTextureImpl(GL gL) {
    }

    protected void postNextTextureImpl(GL gL) {
    }

    protected abstract int getNextTextureImpl(GL var1, TextureSequence.TextureFrame var2) throws InterruptedException;

    protected final int getNextSingleThreaded(GL gL, TextureSequence.TextureFrame textureFrame, boolean[] blArray) throws InterruptedException {
        int n;
        if (-2 != this.vid) {
            this.preNextTextureImpl(gL);
            n = this.getNextTextureImpl(gL, textureFrame);
            this.postNextTextureImpl(gL);
            if (Integer.MIN_VALUE != n) {
                this.newFrameAvailable(textureFrame, Platform.currentTimeMillis());
                blArray[0] = true;
            } else {
                blArray[0] = false;
            }
        } else {
            n = this.getNextTextureImpl(null, null);
            blArray[0] = false;
        }
        return n;
    }

    @Override
    public final AudioSink getAudioSink() {
        return this.audioSink;
    }

    protected void setFirstAudioPTS2SCR(int n) {
        if (this.audioSCR_reset) {
            this.audio_scr_t0 = Platform.currentTimeMillis() - (long)n;
            this.audioSCR_reset = false;
        }
    }

    private void flushAllVideoFrames() {
        if (null != this.videoFramesFree) {
            this.videoFramesFree.resetFull((TextureSequence.TextureFrame[])this.videoFramesOrig);
            this.lastFrame = this.videoFramesFree.get();
            if (null == this.lastFrame) {
                throw new InternalError("XXX");
            }
            this.videoFramesDecoded.clear();
        }
        this.cachedFrame = null;
    }

    private void resetAVPTSAndFlush() {
        this.video_dpts_cum = 0.0f;
        this.video_dpts_count = 0;
        this.resetAVPTS();
        this.flushAllVideoFrames();
        if (null != this.audioSink) {
            this.audioSink.flush();
        }
    }

    private void resetAVPTS() {
        this.nullFrameCount = 0;
        this.presentedFrameCount = 0;
        this.displayedFrameCount = 0;
        this.decodedFrameCount = 0;
        this.audioSCR_reset = true;
        this.videoSCR_reset = true;
    }

    private final int getVideoDPTSAvg() {
        return (int)(this.video_dpts_cum * 0.20567179f + 0.5f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void newFrameAvailable(TextureSequence.TextureFrame textureFrame, long l) {
        ++this.decodedFrameCount;
        if (0 == textureFrame.getDuration()) {
            textureFrame.setDuration((int)this.frame_duration);
        }
        Object object = this.eventListenersLock;
        synchronized (object) {
            Iterator<GLMediaPlayer.GLMediaEventListener> iterator = this.eventListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().newFrameAvailable(this, textureFrame, l);
            }
        }
    }

    protected final int addStateEventMask(int n, GLMediaPlayer.State state) {
        if (this.state != state) {
            switch (state) {
                case Uninitialized: {
                    n |= 2;
                    break;
                }
                case Initialized: {
                    n |= 1;
                    break;
                }
                case Playing: {
                    n |= 4;
                    break;
                }
                case Paused: {
                    n |= 8;
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void attributesUpdated(int n) {
        if (0 != n) {
            long l = Platform.currentTimeMillis();
            Object object = this.eventListenersLock;
            synchronized (object) {
                Iterator<GLMediaPlayer.GLMediaEventListener> iterator = this.eventListeners.iterator();
                while (iterator.hasNext()) {
                    iterator.next().attributesChanged(this, n, l);
                }
            }
        }
    }

    protected final void changeState(int n, GLMediaPlayer.State state) {
        if (0 != (n = this.addStateEventMask(n, state))) {
            this.setState(state);
            if (!this.isTextureAvailable()) {
                this.textureFragmentShaderHashCode = 0;
            }
            this.attributesUpdated(n);
        }
    }

    protected final void updateAttributes(int n, int n2, int n3, int n4, int n5, int n6, int n7, float f, int n8, int n9, int n10, String string2, String string3) {
        boolean bl;
        int n11 = 0;
        boolean bl2 = bl = this.state == GLMediaPlayer.State.Uninitialized;
        if (bl) {
            n11 |= 1;
            this.setState(GLMediaPlayer.State.Initialized);
        }
        if (-1 == n) {
            n = -2;
        }
        if (this.vid != n) {
            n11 |= 0x10000;
            this.vid = n;
        }
        if (-1 == n) {
            n = -2;
        }
        if (this.aid != n2) {
            n11 |= 0x20000;
            this.aid = n2;
        }
        if (this.width != n3 || this.height != n4) {
            n11 |= 0x40000;
            this.width = n3;
            this.height = n4;
        }
        if (this.fps != f) {
            n11 |= 0x80000;
            this.fps = f;
            if (0.0f != f) {
                this.frame_duration = 1000.0f / f;
                int n12 = (int)this.frame_duration;
                this.maxNullFrameCountUntilEOS = 0 < n12 ? 5000 / n12 : 166;
            } else {
                this.frame_duration = 0.0f;
                this.maxNullFrameCountUntilEOS = 166;
            }
        }
        if (this.bps_stream != n5 || this.bps_video != n6 || this.bps_audio != n7) {
            n11 |= 0x100000;
            this.bps_stream = n5;
            this.bps_video = n6;
            this.bps_audio = n7;
        }
        if (this.videoFrames != n8 || this.audioFrames != n9 || this.duration != n10) {
            n11 |= 0x200000;
            this.videoFrames = n8;
            this.audioFrames = n9;
            this.duration = n10;
        }
        if (null != string3 && string3.length() > 0 && !this.acodec.equals(string3)) {
            n11 |= 0x400000;
            this.acodec = string3;
        }
        if (null != string2 && string2.length() > 0 && !this.vcodec.equals(string2)) {
            n11 |= 0x400000;
            this.vcodec = string2;
        }
        if (0 == n11) {
            return;
        }
        if (bl) {
            if (null != this.streamWorker) {
                throw new InternalError("XXX: StreamWorker not null - " + this);
            }
            if (1 < this.textureCount || -2 == n) {
                this.streamWorker = new StreamWorker();
            }
            if (DEBUG) {
                System.err.println("XXX Initialize @ updateAttributes: " + this);
            }
        }
        this.attributesUpdated(n11);
    }

    protected void setIsGLOriented(boolean bl) {
        if (this.isInGLOrientation != bl) {
            if (DEBUG) {
                System.err.println("XXX gl-orient " + this.isInGLOrientation + " -> " + bl);
            }
            this.isInGLOrientation = bl;
            if (null != this.videoFramesOrig) {
                for (int i = 0; i < this.videoFramesOrig.length; ++i) {
                    this.videoFramesOrig[i].getTexture().setMustFlipVertically(!bl);
                }
                this.attributesUpdated(262144);
            }
        }
    }

    @Override
    public final Uri getUri() {
        return this.streamLoc;
    }

    @Override
    public final int getVID() {
        return this.vid;
    }

    @Override
    public final int getAID() {
        return this.aid;
    }

    @Override
    public final String getVideoCodec() {
        return this.vcodec;
    }

    @Override
    public final String getAudioCodec() {
        return this.acodec;
    }

    @Override
    public final int getVideoFrames() {
        return this.videoFrames;
    }

    @Override
    public final int getAudioFrames() {
        return this.audioFrames;
    }

    @Override
    public final int getDuration() {
        return this.duration;
    }

    @Override
    public final long getStreamBitrate() {
        return this.bps_stream;
    }

    @Override
    public final int getVideoBitrate() {
        return this.bps_video;
    }

    @Override
    public final int getAudioBitrate() {
        return this.bps_audio;
    }

    @Override
    public final float getFramerate() {
        return this.fps;
    }

    @Override
    public final boolean isGLOriented() {
        return this.isInGLOrientation;
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    @Override
    public final String toString() {
        float f = (float)this.getDuration() / 1000.0f;
        String string2 = null != this.streamLoc ? this.streamLoc.toString() : "<undefined stream>";
        int n = null != this.videoFramesFree ? this.videoFramesFree.size() : 0;
        int n2 = null != this.videoFramesDecoded ? this.videoFramesDecoded.size() : 0;
        int n3 = this.video_scr_pts + (int)((float)(Platform.currentTimeMillis() - this.video_scr_t0) * this.playSpeed);
        String string3 = null != this.cameraPath ? ", camera: " + this.cameraPath : "";
        return this.getClass().getSimpleName() + "[" + (Object)((Object)this.state) + ", vSCR " + n3 + ", frames[p " + this.presentedFrameCount + ", d " + this.decodedFrameCount + ", t " + this.videoFrames + " (" + f + " s), z " + this.nullFrameCount + " / " + this.maxNullFrameCountUntilEOS + "], " + "speed " + this.playSpeed + ", " + this.bps_stream + " bps, hasSW " + (null != this.streamWorker) + ", Texture[count " + this.textureCount + ", free " + n + ", dec " + n2 + ", tagt " + GLMediaPlayerImpl.toHexString(this.textureTarget) + ", ifmt " + GLMediaPlayerImpl.toHexString(this.textureInternalFormat) + ", fmt " + GLMediaPlayerImpl.toHexString(this.textureFormat) + ", type " + GLMediaPlayerImpl.toHexString(this.textureType) + "], " + "Video[id " + this.vid + ", <" + this.vcodec + ">, " + this.width + "x" + this.height + ", glOrient " + this.isInGLOrientation + ", " + this.fps + " fps, " + this.frame_duration + " fdur, " + this.bps_video + " bps], " + "Audio[id " + this.aid + ", <" + this.acodec + ">, " + this.bps_audio + " bps, " + this.audioFrames + " frames], uri " + string2 + string3 + "]";
    }

    @Override
    public final String getPerfString() {
        long l = Platform.currentTimeMillis();
        int n = this.video_scr_pts + (int)((float)(l - this.video_scr_t0) * this.playSpeed);
        int n2 = this.video_pts_last - n;
        int n3 = (int)((float)(l - this.audio_scr_t0) * this.playSpeed);
        int n4 = this.getAudioPTSImpl();
        int n5 = n4 - n3;
        return this.getPerfStringImpl(n, this.video_pts_last, n2, n3, n4, n5, this.getVideoDPTSAvg());
    }

    private final String getPerfStringImpl(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        float f = (float)this.getDuration() / 1000.0f;
        AudioSink audioSink = this.getAudioSink();
        String string2 = null != audioSink ? "AudioSink[frames [p " + audioSink.getEnqueuedFrameCount() + ", q " + audioSink.getQueuedFrameCount() + ", f " + audioSink.getFreeFrameCount() + ", c " + audioSink.getFrameCount() + "], time " + audioSink.getQueuedTime() + ", bytes " + audioSink.getQueuedByteCount() + "]" : "";
        if (null != this.videoFramesFree) {
            n9 = this.videoFramesFree.size();
            n8 = this.videoFramesDecoded.size();
        } else {
            n9 = 0;
            n8 = 0;
        }
        return (Object)((Object)this.state) + ", frames[(p " + this.presentedFrameCount + ", d " + this.decodedFrameCount + ") / " + this.videoFrames + ", " + f + " s, z " + this.nullFrameCount + " / " + this.maxNullFrameCountUntilEOS + "], " + "speed " + this.playSpeed + ", dAV " + (n3 - n6) + ", vSCR " + n + ", vpts " + n2 + ", dSCR[" + n3 + ", avrg " + n7 + "], " + "aSCR " + n4 + ", apts " + n5 + " ( " + n6 + " ), " + string2 + ", Texture[count " + this.textureCount + ", free " + n9 + ", dec " + n8 + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addEventListener(GLMediaPlayer.GLMediaEventListener gLMediaEventListener) {
        if (gLMediaEventListener == null) {
            return;
        }
        Object object = this.eventListenersLock;
        synchronized (object) {
            this.eventListeners.add(gLMediaEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeEventListener(GLMediaPlayer.GLMediaEventListener gLMediaEventListener) {
        if (gLMediaEventListener == null) {
            return;
        }
        Object object = this.eventListenersLock;
        synchronized (object) {
            this.eventListeners.remove(gLMediaEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GLMediaPlayer.GLMediaEventListener[] getEventListeners() {
        Object object = this.eventListenersLock;
        synchronized (object) {
            return this.eventListeners.toArray(new GLMediaPlayer.GLMediaEventListener[this.eventListeners.size()]);
        }
    }

    @Override
    public final Object getAttachedObject(String string2) {
        return this.attachedObjects.get(string2);
    }

    @Override
    public final Object attachObject(String string2, Object object) {
        return this.attachedObjects.put(string2, object);
    }

    @Override
    public final Object detachObject(String string2) {
        return this.attachedObjects.remove(string2);
    }

    protected static final String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }

    protected static final String toHexString(int n) {
        return "0x" + Integer.toHexString(n);
    }

    protected static final int getPropIntVal(Map<String, String> map, String string2) {
        String string3 = map.get(string2);
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            if (DEBUG) {
                System.err.println("Not a valid integer for <" + string2 + ">: <" + string3 + ">");
            }
            return 0;
        }
    }

    class StreamWorker
    extends InterruptSource.Thread {
        private volatile boolean isRunning = false;
        private volatile boolean isActive = false;
        private volatile boolean isBlocked = false;
        private volatile boolean shallPause = true;
        private volatile boolean shallStop = false;
        private volatile GLContext sharedGLCtx = null;
        private boolean sharedGLCtxCurrent = false;
        private GLDrawable dummyDrawable = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StreamWorker() {
            this.setDaemon(true);
            StreamWorker streamWorker = this;
            synchronized (streamWorker) {
                this.start();
                try {
                    this.notifyAll();
                    while (!this.isRunning && !this.shallStop) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedRuntimeException(interruptedException);
                }
            }
        }

        private void makeCurrent(GLContext gLContext) {
            if (0 >= gLContext.makeCurrent()) {
                throw new GLException("Couldn't make ctx current: " + gLContext);
            }
        }

        private void destroySharedGL() {
            if (null != this.sharedGLCtx) {
                if (this.sharedGLCtx.isCreated()) {
                    try {
                        this.sharedGLCtx.destroy();
                    }
                    catch (GLException gLException) {
                        gLException.printStackTrace();
                    }
                }
                this.sharedGLCtx = null;
            }
            if (null != this.dummyDrawable) {
                AbstractGraphicsDevice abstractGraphicsDevice = this.dummyDrawable.getNativeSurface().getGraphicsConfiguration().getScreen().getDevice();
                this.dummyDrawable.setRealized(false);
                this.dummyDrawable = null;
                abstractGraphicsDevice.close();
            }
        }

        public final synchronized void initGL(GL gL) {
            GLContext gLContext = gL.getContext();
            boolean bl = gLContext.isCurrent();
            GLProfile gLProfile = gL.getGLProfile();
            GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(gLProfile);
            AbstractGraphicsDevice abstractGraphicsDevice = gLContext.getGLDrawable().getNativeSurface().getGraphicsConfiguration().getScreen().getDevice();
            this.dummyDrawable = gLDrawableFactory.createDummyDrawable(abstractGraphicsDevice, true, gLContext.getGLDrawable().getChosenGLCapabilities(), null);
            this.dummyDrawable.setRealized(true);
            this.sharedGLCtx = this.dummyDrawable.createContext(gLContext);
            this.makeCurrent(this.sharedGLCtx);
            if (bl) {
                this.makeCurrent(gLContext);
            } else {
                this.sharedGLCtx.release();
            }
        }

        public final synchronized void doPause(boolean bl) {
            if (this.isActive) {
                this.shallPause = true;
                if (Thread.currentThread() != this) {
                    if (this.isBlocked && this.isActive) {
                        this.interrupt();
                    }
                    if (bl) {
                        try {
                            while (this.isActive && this.isRunning) {
                                this.wait();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            throw new InterruptedRuntimeException(interruptedException);
                        }
                    }
                }
            }
        }

        public final synchronized void doResume() {
            if (this.isRunning && !this.isActive) {
                this.shallPause = false;
                if (Thread.currentThread() != this) {
                    try {
                        this.notifyAll();
                        while (!this.isActive && !this.shallPause && this.isRunning) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        InterruptedException interruptedException2 = SourcedInterruptedException.wrap(interruptedException);
                        this.doPause(false);
                        throw new InterruptedRuntimeException(interruptedException2);
                    }
                }
            }
        }

        public final synchronized void doStop() {
            if (this.isRunning) {
                this.shallStop = true;
                if (Thread.currentThread() != this) {
                    if (this.isBlocked && this.isRunning) {
                        this.interrupt();
                    }
                    try {
                        this.notifyAll();
                        while (this.isRunning) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedRuntimeException(interruptedException);
                    }
                }
            }
        }

        public final boolean isRunning() {
            return this.isRunning;
        }

        public final boolean isActive() {
            return this.isActive;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            this.setName(this.getName() + "-StreamWorker_" + StreamWorkerInstanceId);
            ++StreamWorkerInstanceId;
            Object object = this;
            synchronized (object) {
                this.isRunning = true;
                this.notifyAll();
            }
            while (!this.shallStop) {
                Object object2;
                object = null;
                try {
                    if (this.shallPause) {
                        object2 = this;
                        synchronized (object2) {
                            if (this.sharedGLCtxCurrent) {
                                GLMediaPlayerImpl.this.postNextTextureImpl(this.sharedGLCtx.getGL());
                                this.sharedGLCtx.release();
                            }
                            while (this.shallPause && !this.shallStop) {
                                this.isActive = false;
                                this.notifyAll();
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    if (this.shallPause) continue;
                                    throw SourcedInterruptedException.wrap(interruptedException);
                                }
                            }
                            if (this.sharedGLCtxCurrent) {
                                this.makeCurrent(this.sharedGLCtx);
                                GLMediaPlayerImpl.this.preNextTextureImpl(this.sharedGLCtx.getGL());
                            }
                            this.isActive = true;
                            this.notifyAll();
                        }
                    }
                    if (!this.sharedGLCtxCurrent && null != this.sharedGLCtx) {
                        object2 = this;
                        synchronized (object2) {
                            if (null != this.sharedGLCtx) {
                                this.makeCurrent(this.sharedGLCtx);
                                GLMediaPlayerImpl.this.preNextTextureImpl(this.sharedGLCtx.getGL());
                                this.sharedGLCtxCurrent = true;
                            }
                            if (null == GLMediaPlayerImpl.this.videoFramesFree) {
                                throw new InternalError("XXX videoFramesFree is null");
                            }
                        }
                    }
                    if (this.shallStop) continue;
                    this.isBlocked = true;
                    if (-2 != GLMediaPlayerImpl.this.vid) {
                        object = (TextureSequence.TextureFrame)GLMediaPlayerImpl.this.videoFramesFree.getBlocking();
                        ((TimeFrameI)object).setPTS(Integer.MIN_VALUE);
                        object2 = this.sharedGLCtx.getGL();
                    } else {
                        object2 = null;
                    }
                    this.isBlocked = false;
                    int n = GLMediaPlayerImpl.this.getNextTextureImpl((GL)object2, (TextureSequence.TextureFrame)object);
                    boolean bl = false;
                    if (Integer.MIN_VALUE != n) {
                        if (null != object) {
                            if (STREAM_WORKER_DELAY > 0) {
                                Thread.sleep(STREAM_WORKER_DELAY);
                            }
                            if (!GLMediaPlayerImpl.this.videoFramesDecoded.put(object)) {
                                throw new InternalError("XXX: free " + GLMediaPlayerImpl.this.videoFramesFree + ", decoded " + GLMediaPlayerImpl.this.videoFramesDecoded + ", " + GLMediaPlayerImpl.this);
                            }
                            GLMediaPlayerImpl.this.newFrameAvailable((TextureSequence.TextureFrame)object, Platform.currentTimeMillis());
                            object = null;
                        } else if (Integer.MAX_VALUE == n || GLMediaPlayerImpl.this.duration > 0 && GLMediaPlayerImpl.this.duration < n) {
                            bl = true;
                        } else {
                            GLMediaPlayerImpl.this.nullFrameCount = 0;
                        }
                    } else if (null == object) {
                        boolean bl2 = bl = GLMediaPlayerImpl.this.maxNullFrameCountUntilEOS <= GLMediaPlayerImpl.this.nullFrameCount;
                        if (null == GLMediaPlayerImpl.this.audioSink || 0 == GLMediaPlayerImpl.this.audioSink.getEnqueuedFrameCount()) {
                            GLMediaPlayerImpl.this.nullFrameCount++;
                        }
                    }
                    if (!bl) continue;
                    StreamWorker streamWorker = this;
                    synchronized (streamWorker) {
                        this.shallPause = true;
                        this.isActive = false;
                        this.notifyAll();
                    }
                    if (GLMediaPlayer.DEBUG) {
                        System.err.println("AV-EOS (StreamWorker): EOS_PTS " + (Integer.MAX_VALUE == n) + ", " + GLMediaPlayerImpl.this);
                    }
                    GLMediaPlayerImpl.this.pauseImpl(true, 16);
                }
                catch (InterruptedException interruptedException) {
                    if (!this.isBlocked) {
                        GLMediaPlayerImpl.this.streamErr = new GLMediaPlayer.StreamException("InterruptedException while decoding: " + GLMediaPlayerImpl.this.toString(), SourcedInterruptedException.wrap(interruptedException));
                    }
                    this.isBlocked = false;
                }
                catch (Throwable throwable) {
                    GLMediaPlayerImpl.this.streamErr = new GLMediaPlayer.StreamException(throwable.getClass().getSimpleName() + " while decoding: " + GLMediaPlayerImpl.this.toString(), throwable);
                }
                finally {
                    if (null != object) {
                        GLMediaPlayerImpl.this.videoFramesFree.put(object);
                    }
                    if (null == GLMediaPlayerImpl.this.streamErr) continue;
                    if (GLMediaPlayer.DEBUG) {
                        ExceptionUtils.dumpThrowable("handled", GLMediaPlayerImpl.this.streamErr);
                    }
                    object2 = this;
                    synchronized (object2) {
                        this.shallPause = true;
                        this.isActive = false;
                        this.notifyAll();
                    }
                    GLMediaPlayerImpl.this.pauseImpl(true, 32);
                }
            }
            object = this;
            synchronized (object) {
                if (this.sharedGLCtxCurrent) {
                    GLMediaPlayerImpl.this.postNextTextureImpl(this.sharedGLCtx.getGL());
                }
                this.destroySharedGL();
                this.isRunning = false;
                this.isActive = false;
                this.notifyAll();
            }
        }
    }
}

