/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj;

import java.util.Random;
import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngjExceptionInternal;

class PngDeinterlacer {
    private final ImageInfo imi;
    private int pass;
    private int rows;
    private int cols;
    private int dY;
    private int dX;
    private int oY;
    private int oX;
    private int oXsamples;
    private int dXsamples;
    private int currRowSubimg = -1;
    private int currRowReal = -1;
    private final int packedValsPerPixel;
    private final int packedMask;
    private final int packedShift;
    private int[][] imageInt;
    private short[][] imageShort;
    private byte[][] imageByte;

    PngDeinterlacer(ImageInfo imageInfo) {
        this.imi = imageInfo;
        this.pass = 0;
        if (this.imi.packed) {
            this.packedValsPerPixel = 8 / this.imi.bitDepth;
            this.packedShift = this.imi.bitDepth;
            this.packedMask = this.imi.bitDepth == 1 ? 128 : (this.imi.bitDepth == 2 ? 192 : 240);
        } else {
            this.packedValsPerPixel = 1;
            this.packedShift = 1;
            this.packedMask = 1;
        }
        this.setPass(1);
        this.setRow(0);
    }

    void setRow(int n) {
        this.currRowSubimg = n;
        this.currRowReal = n * this.dY + this.oY;
        if (this.currRowReal < 0 || this.currRowReal >= this.imi.rows) {
            throw new PngjExceptionInternal("bad row - this should not happen");
        }
    }

    void setPass(int n) {
        if (this.pass == n) {
            return;
        }
        this.pass = n;
        switch (this.pass) {
            case 1: {
                this.dX = 8;
                this.dY = 8;
                this.oY = 0;
                this.oX = 0;
                break;
            }
            case 2: {
                this.dX = 8;
                this.dY = 8;
                this.oX = 4;
                this.oY = 0;
                break;
            }
            case 3: {
                this.dX = 4;
                this.dY = 8;
                this.oX = 0;
                this.oY = 4;
                break;
            }
            case 4: {
                this.dY = 4;
                this.dX = 4;
                this.oX = 2;
                this.oY = 0;
                break;
            }
            case 5: {
                this.dX = 2;
                this.dY = 4;
                this.oX = 0;
                this.oY = 2;
                break;
            }
            case 6: {
                this.dY = 2;
                this.dX = 2;
                this.oX = 1;
                this.oY = 0;
                break;
            }
            case 7: {
                this.dX = 1;
                this.dY = 2;
                this.oX = 0;
                this.oY = 1;
                break;
            }
            default: {
                throw new PngjExceptionInternal("bad interlace pass" + this.pass);
            }
        }
        this.rows = (this.imi.rows - this.oY) / this.dY + 1;
        if ((this.rows - 1) * this.dY + this.oY >= this.imi.rows) {
            --this.rows;
        }
        this.cols = (this.imi.cols - this.oX) / this.dX + 1;
        if ((this.cols - 1) * this.dX + this.oX >= this.imi.cols) {
            --this.cols;
        }
        if (this.cols == 0) {
            this.rows = 0;
        }
        this.dXsamples = this.dX * this.imi.channels;
        this.oXsamples = this.oX * this.imi.channels;
    }

    void deinterlaceInt(int[] nArray, int[] nArray2, boolean bl) {
        if (!this.imi.packed || !bl) {
            int n = 0;
            int n2 = this.oXsamples;
            while (n < this.cols * this.imi.channels) {
                for (int i = 0; i < this.imi.channels; ++i) {
                    nArray2[n2 + i] = nArray[n + i];
                }
                n += this.imi.channels;
                n2 += this.dXsamples;
            }
        } else {
            this.deinterlaceIntPacked(nArray, nArray2);
        }
    }

    private void deinterlaceIntPacked(int[] nArray, int[] nArray2) {
        int n = 0;
        int n2 = this.packedMask;
        int n3 = -1;
        int n4 = 0;
        int n5 = this.oX;
        while (n4 < this.cols) {
            n = n4 / this.packedValsPerPixel;
            if (++n3 >= this.packedValsPerPixel) {
                n3 = 0;
            }
            n2 >>= this.packedShift;
            if (n3 == 0) {
                n2 = this.packedMask;
            }
            int n6 = n5 / this.packedValsPerPixel;
            int n7 = n5 % this.packedValsPerPixel;
            int n8 = nArray[n] & n2;
            int n9 = n7 - n3;
            if (n9 > 0) {
                n8 >>= n9 * this.packedShift;
            } else if (n9 < 0) {
                n8 <<= -n9 * this.packedShift;
            }
            int n10 = n6;
            nArray2[n10] = nArray2[n10] | n8;
            ++n4;
            n5 += this.dX;
        }
    }

    void deinterlaceByte(byte[] byArray, byte[] byArray2, boolean bl) {
        if (!this.imi.packed || !bl) {
            int n = 0;
            int n2 = this.oXsamples;
            while (n < this.cols * this.imi.channels) {
                for (int i = 0; i < this.imi.channels; ++i) {
                    byArray2[n2 + i] = byArray[n + i];
                }
                n += this.imi.channels;
                n2 += this.dXsamples;
            }
        } else {
            this.deinterlacePackedByte(byArray, byArray2);
        }
    }

    private void deinterlacePackedByte(byte[] byArray, byte[] byArray2) {
        int n = 0;
        int n2 = this.packedMask;
        int n3 = -1;
        int n4 = 0;
        int n5 = this.oX;
        while (n4 < this.cols) {
            n = n4 / this.packedValsPerPixel;
            if (++n3 >= this.packedValsPerPixel) {
                n3 = 0;
            }
            n2 >>= this.packedShift;
            if (n3 == 0) {
                n2 = this.packedMask;
            }
            int n6 = n5 / this.packedValsPerPixel;
            int n7 = n5 % this.packedValsPerPixel;
            int n8 = byArray[n] & n2;
            int n9 = n7 - n3;
            if (n9 > 0) {
                n8 >>= n9 * this.packedShift;
            } else if (n9 < 0) {
                n8 <<= -n9 * this.packedShift;
            }
            int n10 = n6;
            byArray2[n10] = (byte)(byArray2[n10] | n8);
            ++n4;
            n5 += this.dX;
        }
    }

    boolean isAtLastRow() {
        return this.pass == 7 && this.currRowSubimg == this.rows - 1;
    }

    int getCurrRowSubimg() {
        return this.currRowSubimg;
    }

    int getCurrRowReal() {
        return this.currRowReal;
    }

    int getPass() {
        return this.pass;
    }

    int getRows() {
        return this.rows;
    }

    int getCols() {
        return this.cols;
    }

    public int getPixelsToRead() {
        return this.getCols();
    }

    int[][] getImageInt() {
        return this.imageInt;
    }

    void setImageInt(int[][] nArray) {
        this.imageInt = nArray;
    }

    short[][] getImageShort() {
        return this.imageShort;
    }

    void setImageShort(short[][] sArray) {
        this.imageShort = sArray;
    }

    byte[][] getImageByte() {
        return this.imageByte;
    }

    void setImageByte(byte[][] byArray) {
        this.imageByte = byArray;
    }

    static void test() {
        Random random2 = new Random();
        PngDeinterlacer pngDeinterlacer = new PngDeinterlacer(new ImageInfo(random2.nextInt(35) + 1, random2.nextInt(52) + 1, 8, true));
        int n = pngDeinterlacer.imi.cols * pngDeinterlacer.imi.rows;
        System.out.println(pngDeinterlacer.imi);
        for (int i = 1; i <= 7; ++i) {
            pngDeinterlacer.setPass(i);
            for (int j = 0; j < pngDeinterlacer.getRows(); ++j) {
                pngDeinterlacer.setRow(j);
                int n2 = pngDeinterlacer.getCols();
                n -= n2;
                System.out.printf("Read %d pixels. Pass:%d Realline:%d cols=%d dX=%d oX=%d last:%b\n", n2, pngDeinterlacer.pass, pngDeinterlacer.currRowReal, pngDeinterlacer.cols, pngDeinterlacer.dX, pngDeinterlacer.oX, pngDeinterlacer.isAtLastRow());
            }
        }
        if (n != 0) {
            throw new PngjExceptionInternal("wtf??" + pngDeinterlacer.imi);
        }
    }

    public static void main(String[] stringArray) {
        PngDeinterlacer.test();
    }
}

