/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkHelper;
import jogamp.opengl.util.pngj.chunks.ChunkPredicate;
import jogamp.opengl.util.pngj.chunks.PngChunk;
import jogamp.opengl.util.pngj.chunks.PngChunkSPLT;
import jogamp.opengl.util.pngj.chunks.PngChunkTextVar;

public class ChunksList {
    public static final int CHUNK_GROUP_0_IDHR = 0;
    public static final int CHUNK_GROUP_1_AFTERIDHR = 1;
    public static final int CHUNK_GROUP_2_PLTE = 2;
    public static final int CHUNK_GROUP_3_AFTERPLTE = 3;
    public static final int CHUNK_GROUP_4_IDAT = 4;
    public static final int CHUNK_GROUP_5_AFTERIDAT = 5;
    public static final int CHUNK_GROUP_6_END = 6;
    protected List<PngChunk> chunks = new ArrayList<PngChunk>();
    final ImageInfo imageInfo;

    public ChunksList(ImageInfo imageInfo) {
        this.imageInfo = imageInfo;
    }

    public HashMap<String, Integer> getChunksKeys() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (PngChunk pngChunk : this.chunks) {
            hashMap.put(pngChunk.id, hashMap.containsKey(pngChunk.id) ? hashMap.get(pngChunk.id) + 1 : 1);
        }
        return hashMap;
    }

    public ArrayList<PngChunk> getChunks() {
        return new ArrayList<PngChunk>(this.chunks);
    }

    protected static List<PngChunk> getXById(List<PngChunk> list, final String string2, final String string3) {
        if (string3 == null) {
            return ChunkHelper.filterList(list, new ChunkPredicate(){

                @Override
                public boolean match(PngChunk pngChunk) {
                    return pngChunk.id.equals(string2);
                }
            });
        }
        return ChunkHelper.filterList(list, new ChunkPredicate(){

            @Override
            public boolean match(PngChunk pngChunk) {
                if (!pngChunk.id.equals(string2)) {
                    return false;
                }
                if (pngChunk instanceof PngChunkTextVar && !((PngChunkTextVar)pngChunk).getKey().equals(string3)) {
                    return false;
                }
                return !(pngChunk instanceof PngChunkSPLT) || ((PngChunkSPLT)pngChunk).getPalName().equals(string3);
            }
        });
    }

    public void appendReadChunk(PngChunk pngChunk, int n) {
        pngChunk.setChunkGroup(n);
        this.chunks.add(pngChunk);
    }

    public List<? extends PngChunk> getById(String string2) {
        return this.getById(string2, null);
    }

    public List<? extends PngChunk> getById(String string2, String string3) {
        return ChunksList.getXById(this.chunks, string2, string3);
    }

    public PngChunk getById1(String string2) {
        return this.getById1(string2, false);
    }

    public PngChunk getById1(String string2, boolean bl) {
        return this.getById1(string2, null, bl);
    }

    public PngChunk getById1(String string2, String string3, boolean bl) {
        List<? extends PngChunk> list = this.getById(string2, string3);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1 && (bl || !list.get(0).allowsMultiple())) {
            throw new PngjException("unexpected multiple chunks id=" + string2);
        }
        return list.get(list.size() - 1);
    }

    public List<PngChunk> getEquivalent(final PngChunk pngChunk) {
        return ChunkHelper.filterList(this.chunks, new ChunkPredicate(){

            @Override
            public boolean match(PngChunk pngChunk2) {
                return ChunkHelper.equivalent(pngChunk2, pngChunk);
            }
        });
    }

    public String toString() {
        return "ChunkList: read: " + this.chunks.size();
    }

    public String toStringFull() {
        StringBuilder stringBuilder = new StringBuilder(this.toString());
        stringBuilder.append("\n Read:\n");
        for (PngChunk pngChunk : this.chunks) {
            stringBuilder.append(pngChunk).append(" G=" + pngChunk.getChunkGroup() + "\n");
        }
        return stringBuilder.toString();
    }
}

