/*
 * Decompiled with CFR 0.152.
 */
package jycessing;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import jycessing.TreeCopier;

public class IOUtil {
    private static final Charset UTF8 = Charset.forName("utf-8");

    public static String readResourceAsText(Class<?> clazz, String resource) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream in = clazz.getResourceAsStream(resource);){
                return IOUtil.readText(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readText(InputStream in) throws IOException {
        return new String(IOUtil.readFully(in), UTF8);
    }

    public static String readText(Path path) throws IOException {
        return new String(Files.readAllBytes(path), UTF8);
    }

    public static void rm(Path target) throws IOException {
        Files.walkFileTree(target, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (exc != null) {
                    throw exc;
                }
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void copy(Path src, Path target) throws IOException {
        Path dest = Files.isDirectory(target, new LinkOption[0]) ? target.resolve(src.getFileName()) : target;
        EnumSet<FileVisitOption> doNotResolveLinks = EnumSet.noneOf(FileVisitOption.class);
        Files.walkFileTree(src, doNotResolveLinks, Integer.MAX_VALUE, new TreeCopier(src, dest));
    }

    public static byte[] readFully(InputStream in) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ByteArrayOutputStream bytes = new ByteArrayOutputStream(1024);){
            int n;
            byte[] buf = new byte[1024];
            while ((n = in.read(buf)) != -1) {
                bytes.write(buf, 0, n);
            }
            return bytes.toByteArray();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static class ResourceReader {
        private final Class<?> clazz;

        public ResourceReader(Class<?> clazz) {
            this.clazz = clazz;
        }

        public String readText(String resource) {
            return IOUtil.readResourceAsText(this.clazz, resource);
        }
    }
}

