/*
 * Decompiled with CFR 0.152.
 */
package jycessing;

import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jycessing.Runner;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.google.common.base.Joiner;
import org.python.util.InteractiveConsole;
import processing.core.PApplet;

class LibraryImporter {
    private static final String PLATFORM = PApplet.platformNames[PApplet.platform];
    private static final String BITS = System.getProperty("os.arch").contains("64") ? "64" : "32";
    private final List<File> libSearchPath;
    private final Set<String> loadedLibs = new HashSet<String>();
    private final InteractiveConsole interp;
    private static final Pattern validPythonIdentifier = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");

    private static void log(String msg) {
        if (Runner.VERBOSE) {
            System.err.println(String.valueOf(LibraryImporter.class.getSimpleName()) + ": " + msg);
        }
    }

    public LibraryImporter(List<File> libdirs, InteractiveConsole interp) {
        this.libSearchPath = libdirs;
        this.interp = interp;
        PyStringMap builtins = (PyStringMap)interp.getSystemState().getBuiltins();
        builtins.__setitem__("add_library", new PyObject(){

            @Override
            public PyObject __call__(PyObject[] args, String[] kws) {
                LibraryImporter.log("Adding library " + args[0].asString());
                LibraryImporter.this.addLibrary(args[0].asString());
                return Py.None;
            }
        });
    }

    protected void addLibrary(String libName) {
        File contentsDir;
        if (this.loadedLibs.contains(libName)) {
            LibraryImporter.log("...never mind, we already did");
            return;
        }
        this.loadedLibs.add(libName);
        File libDir = null;
        for (File searchDir : this.libSearchPath) {
            File handRolledJar = new File(searchDir.getAbsoluteFile(), String.valueOf(libName) + ".jar");
            if (handRolledJar.exists()) {
                LibraryImporter.log("Found hand-rolled jar lib " + handRolledJar);
                this.addJarToClassLoader(handRolledJar);
                this.importPublicClassesFromJar(handRolledJar);
                return;
            }
            File potentialDir = new File(searchDir.getAbsoluteFile(), libName);
            if (!potentialDir.exists()) continue;
            if (libDir == null) {
                libDir = potentialDir;
                continue;
            }
            System.err.println("Multiple libraries could be " + libName + ";");
            System.err.println("Picking " + libDir + " over " + potentialDir);
        }
        if (libDir == null) {
            this.interp.exec("raise Exception('This sketch requires the \"" + libName + "\" library.')");
        }
        if (!(contentsDir = new File(libDir, "library")).exists()) {
            this.interp.exec("raise Exception('The library " + libName + " is malformed and won't import.')");
        }
        File mainJar = new File(contentsDir, String.valueOf(libName) + ".jar");
        List<File> resources = this.findResources(contentsDir);
        PySystemState sys = Py.getSystemState();
        for (File resource : resources) {
            String name = resource.getName();
            if (name.endsWith(".jar") || name.endsWith(".zip")) {
                this.addJarToClassLoader(resource.getAbsoluteFile());
                LibraryImporter.log("Appending " + resource.getAbsolutePath() + " to sys.path.");
                sys.path.append(Py.newString(resource.getAbsolutePath()));
                continue;
            }
            if (!name.matches("^.*\\.(so|dll|dylib|jnilib)$")) continue;
            this.addDirectoryToNativeSearchPath(resource.getAbsoluteFile().getParentFile());
        }
        this.importPublicClassesFromJar(mainJar);
    }

    protected List<File> findResources(File contentsDir) {
        LibraryImporter.log("Exploring " + contentsDir + " for resources.");
        List<File> resources = this.findResourcesFromExportTxt(contentsDir);
        if (resources == null) {
            LibraryImporter.log("Falling back to directory structure.");
            resources = this.findResourcesFromDirectoryStructure(contentsDir);
        }
        return resources;
    }

    private List<File> findResourcesFromExportTxt(File contentsDir) {
        String[] resourceNames;
        Map<String, String[]> exportTable;
        File exportTxt = new File(contentsDir, "export.txt");
        if (!exportTxt.exists()) {
            LibraryImporter.log("No export.txt in " + contentsDir.getAbsolutePath());
            return null;
        }
        try {
            exportTable = this.parseExportTxt(exportTxt);
        }
        catch (Exception e) {
            LibraryImporter.log("Couldn't parse export.txt: " + e.getMessage());
            return null;
        }
        if (exportTable.containsKey("application." + PLATFORM + BITS)) {
            LibraryImporter.log("Found 'application." + PLATFORM + BITS + "' in export.txt");
            resourceNames = exportTable.get("application." + PLATFORM + BITS);
        } else if (exportTable.containsKey("application." + PLATFORM)) {
            LibraryImporter.log("Found 'application." + PLATFORM + "' in export.txt");
            resourceNames = exportTable.get("application." + PLATFORM);
        } else if (exportTable.containsKey("application")) {
            LibraryImporter.log("Found 'application' in export.txt");
            resourceNames = exportTable.get("application");
        } else {
            LibraryImporter.log("No matching platform in " + exportTxt.getAbsolutePath());
            return null;
        }
        ArrayList<File> resources = new ArrayList<File>();
        String[] stringArray = resourceNames;
        int n = resourceNames.length;
        int n2 = 0;
        while (n2 < n) {
            String resourceName = stringArray[n2];
            File resource = new File(contentsDir, resourceName);
            if (resource.exists()) {
                resources.add(resource);
            } else {
                LibraryImporter.log(String.valueOf(resourceName) + " is mentioned in " + exportTxt.getAbsolutePath() + "but doesn't actually exist. Moving on.");
            }
            ++n2;
        }
        return resources;
    }

    private List<File> findResourcesFromDirectoryStructure(File contentsDir) {
        File[] commonResources;
        int n;
        File potentialPlatformDir;
        List<String> childNames = Arrays.asList(contentsDir.list());
        ArrayList<File> resources = new ArrayList<File>();
        File platformDir = null;
        if (childNames.contains(String.valueOf(PLATFORM) + BITS) && (potentialPlatformDir = new File(contentsDir, String.valueOf(PLATFORM) + BITS)).isDirectory()) {
            platformDir = potentialPlatformDir;
        }
        if (platformDir == null && childNames.contains(PLATFORM) && (potentialPlatformDir = new File(contentsDir, PLATFORM)).isDirectory()) {
            platformDir = potentialPlatformDir;
        }
        if (platformDir != null) {
            LibraryImporter.log("Found platform-specific directory " + platformDir.getAbsolutePath());
            File[] fileArray = platformDir.listFiles();
            n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File resource = fileArray[n2];
                resources.add(resource);
                ++n2;
            }
        }
        File[] fileArray = commonResources = contentsDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isDirectory();
            }
        });
        int n3 = commonResources.length;
        n = 0;
        while (n < n3) {
            File resource = fileArray[n];
            resources.add(resource);
            ++n;
        }
        return resources;
    }

    private Map<String, String[]> parseExportTxt(File exportTxt) throws Exception {
        LibraryImporter.log("Parsing " + exportTxt.getAbsolutePath());
        Properties exportProps = new Properties();
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileReader in = new FileReader(exportTxt);){
            exportProps.load(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        HashMap<String, String[]> exportTable = new HashMap<String, String[]>();
        for (String platform2 : exportProps.stringPropertyNames()) {
            String exportCSV = exportProps.getProperty(platform2);
            String[] exports = PApplet.splitTokens(exportCSV, ",");
            int i = 0;
            while (i < exports.length) {
                exports[i] = exports[i].trim();
                ++i;
            }
            exportTable.put(platform2, exports);
        }
        return exportTable;
    }

    private void addJarToClassLoader(File jar) {
        try {
            URL url = jar.toURI().toURL();
            URLClassLoader ucl = (URLClassLoader)ClassLoader.getSystemClassLoader();
            URL[] uRLArray = ucl.getURLs();
            int n = uRLArray.length;
            int n2 = 0;
            while (n2 < n) {
                URL existing = uRLArray[n2];
                if (existing.equals(url)) {
                    return;
                }
                ++n2;
            }
            LibraryImporter.log("Appending " + url + " to the system classloader.");
            Method addUrl = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            addUrl.setAccessible(true);
            addUrl.invoke((Object)ucl, url);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private void addDirectoryToNativeSearchPath(File dllDir) {
        String newPath = dllDir.getAbsolutePath();
        try {
            String[] paths;
            Field field = ClassLoader.class.getDeclaredField("usr_paths");
            field.setAccessible(true);
            String[] stringArray = paths = (String[])field.get(null);
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                if (newPath.equals(path)) {
                    return;
                }
                ++n2;
            }
            String[] tmp = Arrays.copyOf(paths, paths.length + 1);
            tmp[paths.length] = newPath;
            field.set(null, tmp);
            LibraryImporter.log("Added " + newPath + " to java.library.path.");
        }
        catch (Exception e) {
            System.err.println("While attempting to add " + newPath + " to the processing.py library search path: " + e.getClass().getSimpleName() + "--" + e.getMessage());
        }
    }

    private void importPublicClassesFromJar(File jarPath) {
        LibraryImporter.log("Importing public classes from " + jarPath.getAbsolutePath());
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ZipFile file = new ZipFile(jarPath);){
                Enumeration<? extends ZipEntry> entries = file.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory()) continue;
                    String name = entry.getName();
                    if (!name.endsWith(".class")) {
                        LibraryImporter.log("Rejecting non-class " + name);
                        continue;
                    }
                    int slash = name.lastIndexOf(47);
                    if (slash == -1) {
                        LibraryImporter.log("Rejecting " + name);
                        continue;
                    }
                    if (name.contains("$")) {
                        LibraryImporter.log("Rejecting " + name);
                        continue;
                    }
                    String[] path = name.split("/");
                    String className = path[path.length - 1].replace(".class", "");
                    String packageName = Joiner.on(".").join(Arrays.asList(path).subList(0, path.length - 1));
                    if (!validPythonIdentifier.matcher(className).matches()) {
                        LibraryImporter.log("Rejecting " + name);
                        continue;
                    }
                    String importStatement = String.format("from %s import %s", packageName, className);
                    LibraryImporter.log(importStatement);
                    this.interp.exec(importStatement);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

