/*
 * Decompiled with CFR 0.152.
 */
package jycessing;

import java.awt.SplashScreen;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import jycessing.DevNullPrinter;
import jycessing.IOUtil;
import jycessing.LibraryImporter;
import jycessing.PAppletJythonDriver;
import jycessing.Printer;
import jycessing.PythonSketchError;
import jycessing.ReflectionUtil;
import jycessing.RunnableSketch;
import jycessing.SketchPositionListener;
import jycessing.StreamPrinter;
import jycessing.launcher.LaunchHelper;
import jycessing.launcher.StandaloneSketch;
import jycessing.mode.export.ExportedSketch;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyStringMap;
import org.python.util.InteractiveConsole;
import org.python.util.PythonInterpreter;
import processing.core.PApplet;

public class Runner {
    private static final String BUILD_PROPERTIES = "build.properties";
    private static final String ARCH;
    private static final String BUILD_NUMBER;
    private static final String LAUNCHER_TEXT;
    private static final String CORE_TEXT;
    public static boolean VERBOSE;
    public static RunnableSketch sketch;

    static {
        int archBits = Integer.parseInt(System.getProperty("sun.arch.data.model"));
        ARCH = PApplet.platform == 2 ? "macosx" + archBits : (PApplet.platform == 1 ? "macosx" + archBits : (PApplet.platform == 3 ? "linux" + archBits : "unknown" + archBits));
        BUILD_NUMBER = Runner.loadBuildNumber();
        LAUNCHER_TEXT = IOUtil.readResourceAsText(LaunchHelper.class, "launcher.py");
        CORE_TEXT = IOUtil.readResourceAsText(Runner.class, "core.py");
        VERBOSE = Boolean.getBoolean("verbose");
    }

    private static String loadBuildNumber() {
        Properties buildProperties = new Properties();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream in = Runner.class.getResourceAsStream(BUILD_PROPERTIES);){
                buildProperties.load(in);
                return buildProperties.getProperty("build.number", "????");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.err.println("Can't read build.properties.");
            return "????";
        }
    }

    static void log(Object ... objs) {
        if (!VERBOSE) {
            return;
        }
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            System.err.print(String.valueOf(o));
            ++n2;
        }
        System.err.println();
    }

    private static void searchForExtraStuff(File dir, Set<String> entries) {
        int n;
        if (dir == null) {
            throw new IllegalArgumentException("null dir");
        }
        String dirName = dir.getName();
        if (!dirName.equals(ARCH) && dirName.matches("^(macosx|windows|linux)(32|64)$")) {
            Runner.log("Ignoring wrong architecture " + dir);
            return;
        }
        Runner.log("Searching: ", dir);
        File[] dlls = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches("^.+\\.(so|dll|jnilib|dylib)$");
            }
        });
        if (dlls != null && dlls.length > 0) {
            entries.add(dir.getAbsolutePath());
        } else {
            Runner.log("No DLLs in ", dir);
        }
        File[] jars = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches("^.+\\.jar$");
            }
        });
        if (jars != null && jars.length != 0) {
            File[] fileArray = jars;
            n = jars.length;
            int n2 = 0;
            while (n2 < n) {
                File jar = fileArray[n2];
                entries.add(jar.getAbsolutePath());
                ++n2;
            }
        } else {
            Runner.log("No JARs in ", dir);
        }
        File[] dirs = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() && f.getName().charAt(0) != '.';
            }
        });
        if (dirs != null && dirs.length != 0) {
            File[] fileArray = dirs;
            int n3 = dirs.length;
            n = 0;
            while (n < n3) {
                File d = fileArray[n];
                Runner.searchForExtraStuff(d, entries);
                ++n;
            }
        } else {
            Runner.log("No dirs in ", dir);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            throw new RuntimeException("I need the path of your Python script as an argument.");
        }
        Properties buildnum = new Properties();
        Throwable throwable = null;
        Object var3_5 = null;
        try (InputStream buildnumberStream = Runner.class.getResourceAsStream(BUILD_PROPERTIES);){
            buildnum.load(buildnumberStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Runner.log("processing.py build ", buildnum.getProperty("build.number"));
        try {
            sketch = Arrays.asList(args).contains("--exported") ? new ExportedSketch(args) : new StandaloneSketch(args);
            Runner.runSketchBlocking(sketch, new StreamPrinter(System.out), new StreamPrinter(System.err));
        }
        catch (Throwable t) {
            System.err.println(t);
            System.exit(-1);
        }
        System.exit(0);
    }

    public static void warmup() {
        try {
            Throwable throwable = null;
            Object var1_3 = null;
            try (WarmupSketch warmup = new WarmupSketch();){
                Runner.runSketchBlocking(warmup, new DevNullPrinter(), new DevNullPrinter());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Runner.log(e.getMessage());
        }
    }

    public static synchronized void runSketchBlocking(RunnableSketch sketch, Printer stdout, Printer stderr) throws PythonSketchError {
        Runner.runSketchBlocking(sketch, stdout, stderr, null);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static synchronized void runSketchBlocking(RunnableSketch sketch, Printer stdout, Printer stderr, SketchPositionListener sketchPositionListener) throws PythonSketchError {
        props = new Properties();
        props.setProperty("python.verbose", "error");
        pythonPath = new StringBuilder();
        libDirs = sketch.getLibraryDirectories();
        actualCodeLocation = sketch.getMainFile().getParentFile().getAbsolutePath();
        pythonPath.append(File.pathSeparator).append(actualCodeLocation);
        sketchDirPath = sketch.getHomeDirectory().getAbsolutePath();
        pythonPath.append(File.pathSeparator).append(sketchDirPath);
        props.setProperty("python.path", pythonPath.toString());
        props.setProperty("python.main", sketch.getMainFile().getAbsolutePath());
        props.setProperty("python.main.root", sketchDirPath);
        args = sketch.getPAppletArguments();
        PythonInterpreter.initialize(null, props, args);
        sys = Py.getSystemState();
        originalModules = ((PyStringMap)sys.modules).copy();
        originalPath = new PyList(sys.path);
        builtins = (PyStringMap)sys.getBuiltins();
        originalBuiltins = builtins.copy();
        try {
            interp = new InteractiveConsole();
            interp.set("__file__", sketch.getMainFile().getAbsolutePath());
            interp.exec("import sys\n");
            userLibs = new HashSet<String>();
            for (File entry : sketch.getPathEntries()) {
                sys.path.append(Py.newString(entry.getAbsolutePath()));
                Runner.searchForExtraStuff(entry, userLibs);
            }
            if (libDirs != null) {
                new LibraryImporter(sketch.getLibraryDirectories(), interp);
                if (sketch.getLibraryPolicy() == LibraryPolicy.PROMISCUOUS) {
                    Runner.log(new Object[]{"Promiscusouly adding all libraries in " + libDirs});
                    libs = new HashSet<String>();
                    for (File dir : libDirs) {
                        Runner.searchForExtraStuff(dir, libs);
                    }
                    for (Object lib : libs) {
                        sys.path.insert(0, Py.newString((String)lib));
                    }
                }
            }
            for (String lib : userLibs) {
                sys.path.insert(0, Py.newString(lib));
            }
            interp.exec(Runner.LAUNCHER_TEXT);
            interp.set("__cwd__", sketch.getHomeDirectory().getAbsolutePath());
            interp.set("__python_mode_build__", Runner.BUILD_NUMBER);
            interp.set("__stdout__", stdout);
            interp.set("__stderr__", stderr);
            applet = new PAppletJythonDriver(interp, sketch.getMainFile().toString(), sketch.getMainCode(), stdout);
            interp.set("__papplet__", applet);
            interp.exec(Runner.CORE_TEXT);
            applet.sketchPath();
            applet.setSketchPositionListener(sketchPositionListener);
            applet.findSketchMethods();
            splash = SplashScreen.getSplashScreen();
            if (splash != null) {
                splash.close();
            }
            try {
                if (sketch.shouldRun()) {
                    applet.runAndBlock(args);
                }
            }
            catch (Throwable var19_20) {
                interp.cleanup();
                throw var19_20;
            }
            interp.cleanup();
        }
        finally {
            sys.modules = originalModules;
            sys.path.clear();
            sys.path.addAll((Collection)originalPath);
            builtins.clear();
            ** for (k : originalBuiltins.keys().asIterable())
        }
lbl-1000:
        // 1 sources

        {
            builtins.__setitem__(k, originalBuiltins.get(k));
            continue;
        }
lbl81:
        // 1 sources

        Runner.resetCodecsModule();
    }

    private static void resetCodecsModule() {
        ReflectionUtil.setObject(Py.getSystemState(), "codecState", null);
    }

    public static enum LibraryPolicy {
        PROMISCUOUS,
        SELECTIVE;

    }

    private static class WarmupSketch
    implements RunnableSketch,
    AutoCloseable {
        final Path sketchDir = Files.createTempDirectory("pythonmode", new FileAttribute[0]);
        final File sketchFile = new File(this.sketchDir.toFile(), "warmup.pyde");

        WarmupSketch() throws IOException {
        }

        @Override
        public void close() throws Exception {
            try {
                IOUtil.rm(this.sketchDir);
            }
            catch (IOException e) {
                System.err.println("Unable to rm " + this.sketchDir);
                this.sketchFile.deleteOnExit();
                this.sketchDir.toFile().deleteOnExit();
            }
        }

        @Override
        public File getMainFile() {
            return this.sketchFile;
        }

        @Override
        public String getMainCode() {
            return "print \"warming up!\"\nexit()";
        }

        @Override
        public File getHomeDirectory() {
            return this.sketchFile.getAbsoluteFile().getParentFile();
        }

        @Override
        public String[] getPAppletArguments() {
            return new String[]{"warmup.pyde"};
        }

        @Override
        public List<File> getLibraryDirectories() {
            return new ArrayList<File>();
        }

        @Override
        public LibraryPolicy getLibraryPolicy() {
            return LibraryPolicy.SELECTIVE;
        }

        @Override
        public boolean shouldRun() {
            return false;
        }

        @Override
        public List<File> getPathEntries() {
            ArrayList<File> entries = new ArrayList<File>();
            entries.add(this.getHomeDirectory());
            return entries;
        }
    }
}

