/*
 * Decompiled with CFR 0.152.
 */
package jycessing;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;

class TreeCopier
implements FileVisitor<Path> {
    private final Path source;
    private final Path target;

    static void copyFile(Path source, Path target) {
        try {
            Files.copy(source, target, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException x) {
            System.err.format("Unable to copy: %s: %s%n", source, x);
        }
    }

    TreeCopier(Path source, Path target) {
        this.source = source;
        this.target = target;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
        Path newdir = this.target.resolve(this.source.relativize(dir));
        try {
            Files.copy(dir, newdir, StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException x) {
            System.err.format("Unable to create: %s: %s%n", newdir, x);
            return FileVisitResult.SKIP_SUBTREE;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
        TreeCopier.copyFile(file, this.target.resolve(this.source.relativize(file)));
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
        if (exc == null) {
            Path newdir = this.target.resolve(this.source.relativize(dir));
            try {
                FileTime time = Files.getLastModifiedTime(dir, new LinkOption[0]);
                Files.setLastModifiedTime(newdir, time);
            }
            catch (IOException x) {
                System.err.format("Unable to copy all attributes to: %s: %s%n", newdir, x);
            }
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) {
        if (exc instanceof FileSystemLoopException) {
            System.err.println("cycle detected: " + file);
        } else {
            System.err.format("Unable to copy: %s: %s%n", file, exc);
        }
        return FileVisitResult.CONTINUE;
    }
}

