/*
 * Decompiled with CFR 0.152.
 */
package jycessing.launcher;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jycessing.IOUtil;
import jycessing.RunnableSketch;
import jycessing.Runner;
import jycessing.annotations.PythonUsage;

public class StandaloneSketch
implements RunnableSketch {
    private final File sketchPath;
    private final String code;
    private final List<File> libraryDirs;

    static void log(Object ... objs) {
        if (!Runner.VERBOSE) {
            return;
        }
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            System.err.print(String.valueOf(o));
            ++n2;
        }
        System.err.println();
    }

    @PythonUsage(methodName="getMainJarFile")
    public File getMainJarFile() {
        try {
            return new File(Runner.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public File getRuntimeRoot() {
        File jar = this.getMainJarFile();
        if (jar.getAbsolutePath().contains(".app/Contents/")) {
            return jar.getParentFile().getParentFile();
        }
        return jar.getParentFile();
    }

    public StandaloneSketch(String[] args) throws Exception {
        String propsResource;
        List<String> argsList = Arrays.asList(args);
        this.sketchPath = argsList.contains("--internal") ? new File(this.getRuntimeRoot(), "Runtime/sketch.py").getAbsoluteFile() : new File(args[args.length - 1]).getAbsoluteFile();
        if (argsList.contains("--redirect")) {
            String name = this.sketchPath.getName().replaceAll("\\.py", "");
            String out = String.valueOf(this.sketchPath.getParent()) + "/" + name + ".out.txt";
            String err = String.valueOf(this.sketchPath.getParent()) + "/" + name + ".err.txt";
            System.setOut(new PrintStream(new FileOutputStream(out)));
            System.setErr(new PrintStream(new FileOutputStream(err)));
        }
        this.code = IOUtil.readText(this.sketchPath.toPath());
        this.libraryDirs = new ArrayList<File>();
        String BUILD_PROPERTIES = "build.properties";
        try {
            propsResource = URLDecoder.decode(Runner.class.getResource("build.properties").toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Impossible: " + e);
        }
        Pattern JAR_RESOURCE = Pattern.compile("jar:file:(.+?)/processing-py\\.jar!/jycessing/" + Pattern.quote("build.properties"));
        Pattern FILE_RESOURCE = Pattern.compile("file:(.+?)/bin/jycessing/" + Pattern.quote("build.properties"));
        Matcher jarMatcher = JAR_RESOURCE.matcher(propsResource);
        Matcher fileMatcher = FILE_RESOURCE.matcher(propsResource);
        if (jarMatcher.matches()) {
            StandaloneSketch.log("We're running from a JAR file.");
            this.libraryDirs.add(new File(jarMatcher.group(1), "libraries"));
        } else if (fileMatcher.matches()) {
            StandaloneSketch.log("We're running from class files.");
            this.libraryDirs.add(new File(fileMatcher.group(1), "libraries"));
        } else {
            StandaloneSketch.log("WARNING: I can't find my libraries directory!");
            this.libraryDirs.add(new File("libraries"));
        }
    }

    @Override
    public File getMainFile() {
        return this.sketchPath;
    }

    @Override
    public File getHomeDirectory() {
        return this.sketchPath.getParentFile();
    }

    @Override
    public String[] getPAppletArguments() {
        return new String[]{"--sketch-path=" + this.sketchPath.getParentFile().getAbsolutePath(), this.sketchPath.getName()};
    }

    @Override
    public List<File> getLibraryDirectories() {
        return this.libraryDirs;
    }

    @Override
    public Runner.LibraryPolicy getLibraryPolicy() {
        return Runner.LibraryPolicy.PROMISCUOUS;
    }

    @Override
    public String getMainCode() {
        return this.code;
    }

    @Override
    public boolean shouldRun() {
        return true;
    }

    @Override
    public List<File> getPathEntries() {
        ArrayList<File> entries = new ArrayList<File>();
        entries.add(this.sketchPath.getParentFile());
        for (File dir : this.getLibraryDirectories()) {
            entries.add(dir);
        }
        return entries;
    }
}

