/*
 * Decompiled with CFR 0.152.
 */
package jycessing.mode;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import jycessing.DisplayType;
import jycessing.IOUtil;
import jycessing.mode.PyInputHandler;
import jycessing.mode.PyToolbar;
import jycessing.mode.PythonMode;
import jycessing.mode.export.ExportDialog;
import jycessing.mode.run.PdeSketch;
import jycessing.mode.run.SketchServiceManager;
import jycessing.mode.run.SketchServiceProcess;
import processing.app.Base;
import processing.app.Formatter;
import processing.app.Language;
import processing.app.Library;
import processing.app.Messages;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.SketchCode;
import processing.app.SketchException;
import processing.app.syntax.InputHandler;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.PdeTextAreaDefaults;
import processing.app.syntax.TextAreaDefaults;
import processing.app.ui.Editor;
import processing.app.ui.EditorException;
import processing.app.ui.EditorState;
import processing.app.ui.EditorToolbar;
import processing.app.ui.Toolkit;

public class PyEditor
extends Editor {
    private final String id = UUID.randomUUID().toString();
    private final PythonMode pyMode;
    private final PyInputHandler inputHandler = new PyInputHandler(this);
    private final SketchServiceProcess sketchService;
    private Path tempSketch;

    private static void log(String msg) {
        if (PythonMode.VERBOSE) {
            System.err.println(String.valueOf(PyEditor.class.getSimpleName()) + ": " + msg);
        }
    }

    protected PyEditor(Base base2, String path, EditorState state, Mode mode) throws EditorException {
        super(base2, path, state, mode);
        this.pyMode = (PythonMode)mode;
        this.textarea.addMouseWheelListener(this.createHorizontalScrollListener());
        final SketchServiceManager sketchServiceManager = this.pyMode.getSketchServiceManager();
        this.sketchService = sketchServiceManager.createSketchService(this);
        final Thread cleanup = new Thread(new Runnable(){

            @Override
            public void run() {
                sketchServiceManager.destroySketchService(PyEditor.this);
            }
        });
        Runtime.getRuntime().addShutdownHook(cleanup);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                cleanup.run();
                Runtime.getRuntime().removeShutdownHook(cleanup);
            }
        });
    }

    protected JEditTextArea createTextArea() {
        return new JEditTextArea((TextAreaDefaults)new PdeTextAreaDefaults(this.mode), (InputHandler)new PyInputHandler(this));
    }

    public String getId() {
        return this.id;
    }

    private MouseWheelListener createHorizontalScrollListener() {
        return new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getScrollType() == 0 && e.isShiftDown()) {
                    int current = PyEditor.this.textarea.getHorizontalScrollPosition();
                    int delta = e.getUnitsToScroll() * 6;
                    PyEditor.this.textarea.setHorizontalScrollPosition(current + delta);
                }
            }
        };
    }

    public String getCommentPrefix() {
        return "# ";
    }

    public void internalCloseRunner() {
        try {
            try {
                this.sketchService.stopSketch();
            }
            catch (SketchException e) {
                this.statusError((Exception)((Object)e));
                this.cleanupTempSketch();
            }
        }
        finally {
            this.cleanupTempSketch();
        }
    }

    private void cleanupTempSketch() {
        if (this.tempSketch != null) {
            if (this.tempSketch.toFile().exists()) {
                try {
                    PyEditor.log("Deleting " + this.tempSketch);
                    IOUtil.rm(this.tempSketch);
                    PyEditor.log("Deleted " + this.tempSketch);
                    assert (!this.tempSketch.toFile().exists());
                }
                catch (IOException e) {
                    System.err.println(e);
                }
            }
            this.tempSketch = null;
        }
    }

    public JMenu buildFileMenu() {
        String appTitle = Language.text((String)"Export Application");
        JMenuItem exportApplication = Toolkit.newJMenuItem((String)appTitle, (int)69);
        exportApplication.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PyEditor.this.handleExportApplication();
            }
        });
        return this.buildFileMenu(new JMenuItem[]{exportApplication});
    }

    public JMenu buildHelpMenu() {
        JMenu menu = new JMenu("Help");
        menu.add(new JMenuItem(new AbstractAction("References"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Platform.openURL((String)"http://py.processing.org/reference/");
            }
        }));
        menu.add(new JMenuItem(new AbstractAction("Tutorials"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Platform.openURL((String)"http://py.processing.org/tutorials/");
            }
        }));
        menu.add(new JMenuItem(new AbstractAction("Examples"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Platform.openURL((String)"http://py.processing.org/examples/");
            }
        }));
        menu.add(new JMenuItem(new AbstractAction("Report a bug in Python Mode"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Platform.openURL((String)"http://github.com/jdf/processing.py-bugs/issues");
            }
        }));
        menu.add(new JMenuItem(new AbstractAction("Contribute to Python Mode"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Platform.openURL((String)"http://github.com/jdf/processing.py");
            }
        }));
        return menu;
    }

    public JMenu buildSketchMenu() {
        JMenuItem runItem = Toolkit.newJMenuItem((String)Language.text((String)"toolbar.run"), (int)82);
        runItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PyEditor.this.handleRun();
            }
        });
        JMenuItem presentItem = Toolkit.newJMenuItemShift((String)Language.text((String)"toolbar.present"), (int)82);
        presentItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PyEditor.this.handlePresent();
            }
        });
        JMenuItem stopItem = new JMenuItem(Language.text((String)"toolbar.stop"));
        stopItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PyEditor.this.handleStop();
            }
        });
        return this.buildSketchMenu(new JMenuItem[]{runItem, presentItem, stopItem});
    }

    public Formatter createFormatter() {
        return this.pyMode.getFormatter();
    }

    public EditorToolbar createToolbar() {
        return new PyToolbar(this);
    }

    public void handleExportApplication() {
        if (this.sketch.isModified()) {
            Object[] options = new Object[]{"OK", "Cancel"};
            int result2 = JOptionPane.showOptionDialog((Component)((Object)this), "Save changes before export?", "Save", 2, 3, null, options, options[0]);
            if (result2 == 0) {
                this.handleSave(true);
            } else {
                this.statusNotice("Export canceled, changes must first be saved.");
            }
        }
        new ExportDialog(this, this.sketch).go();
    }

    public File getModeContentFile(String filename) {
        return this.pyMode.getContentFile(filename);
    }

    public File getSplashFile() {
        return this.pyMode.getContentFile("theme/splash.png");
    }

    private Path createTempSketch() throws IOException {
        Path tmp = Files.createTempDirectory(this.sketch.getName(), new FileAttribute[0]);
        SketchCode[] sketchCodeArray = this.sketch.getCode();
        int n = sketchCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SketchCode code2 = sketchCodeArray[n2];
            Files.write(tmp.resolve(code2.getFileName()), code2.getProgram().getBytes("utf-8"), new OpenOption[0]);
            ++n2;
        }
        return tmp;
    }

    private void runSketch(DisplayType displayType) {
        Point location;
        PdeSketch.LocationType locationType;
        File sketchPath;
        this.prepareRun();
        this.toolbar.activateRun();
        if (this.sketch.isModified()) {
            PyEditor.log("Sketch is modified; must copy it to temp dir.");
            String sketchMainFileName = this.sketch.getCode(0).getFile().getName();
            try {
                this.tempSketch = this.createTempSketch();
                sketchPath = this.tempSketch.resolve(sketchMainFileName).toFile();
            }
            catch (IOException e) {
                Messages.showError((String)"Sketchy Behavior", (String)"I can't copy your unsaved work\nto a temp directory.", (Throwable)e);
                return;
            }
        } else {
            sketchPath = this.sketch.getCode(0).getFile().getAbsoluteFile();
        }
        if (this.getSketchLocation() != null) {
            locationType = PdeSketch.LocationType.SKETCH_LOCATION;
            location = new Point(this.getSketchLocation());
        } else {
            locationType = PdeSketch.LocationType.EDITOR_LOCATION;
            location = new Point(this.getLocation());
        }
        try {
            this.sketchService.runSketch(new PdeSketch(this.sketch, sketchPath, displayType, location, locationType));
        }
        catch (SketchException e) {
            this.statusError((Exception)((Object)e));
        }
    }

    public void deactivateRun() {
        this.restoreToolbar();
        this.cleanupTempSketch();
    }

    public void handleRun() {
        this.runSketch(DisplayType.WINDOWED);
    }

    public void handlePresent() {
        this.runSketch(DisplayType.PRESENTATION);
    }

    public void handleStop() {
        this.toolbar.activateStop();
        this.internalCloseRunner();
        this.restoreToolbar();
        this.requestFocus();
    }

    private void restoreToolbar() {
        this.toolbar.deactivateStop();
        this.toolbar.deactivateRun();
        this.toFront();
    }

    public void handleSaveImpl() {
        super.handleSaveImpl();
        this.recolor();
    }

    public void statusError(String what) {
        super.statusError(what);
        this.restoreToolbar();
    }

    public void handleImportLibrary(String libraryName) {
        this.sketch.ensureExistence();
        Library lib = this.mode.findLibraryByName(libraryName);
        if (lib == null) {
            this.statusError("Unable to locate library: " + libraryName);
            return;
        }
        String name = new File(lib.getJarPath()).getParentFile().getParentFile().getName();
        if (Pattern.compile("^add_library\\(\\s*'" + name + "'\\s*\\)\\s*$", 8).matcher(this.getText()).find()) {
            return;
        }
        this.setSelection(0, 0);
        this.setSelectedText(String.format("add_library('%s')\n", name));
        this.sketch.setModified(true);
        this.recolor();
    }

    public void handleIndentOutdent(boolean increase) {
        this.inputHandler.indent(increase ? 1 : -1);
    }

    public void handleAutoFormat() {
        super.handleAutoFormat();
        this.recolor();
    }

    public void handlePaste() {
        super.handlePaste();
        this.recolor();
    }

    public void handleCut() {
        super.handleCut();
        this.recolor();
    }

    protected void handleCommentUncomment() {
        super.handleCommentUncomment();
        this.recolor();
    }

    private void recolor() {
        this.textarea.getDocument().tokenizeLines();
    }

    public void printOut(String msg) {
        this.console.message(msg, false);
    }

    public void printErr(String msg) {
        this.console.message(msg, true);
    }
}

