/*
 * Decompiled with CFR 0.152.
 */
package jycessing.mode;

import javax.swing.text.Segment;
import jycessing.mode.SyntaxUtilities;

public class PyKeywordMap {
    private final Keyword[] map;
    protected int mapLength;

    public PyKeywordMap() {
        this(52);
    }

    public PyKeywordMap(int mapLength) {
        this.mapLength = mapLength;
        this.map = new Keyword[mapLength];
    }

    public byte lookup(Segment text2, int offset, int length) {
        if (length == 0) {
            return 0;
        }
        Keyword k = this.map[this.getSegmentMapKey(text2, offset, length)];
        while (k != null) {
            if (length != k.keyword.length) {
                k = k.next;
                continue;
            }
            if (SyntaxUtilities.regionMatches(text2, offset, k.keyword)) {
                return k.id;
            }
            k = k.next;
        }
        return 0;
    }

    public void add(String keyword2, byte id) {
        int key = this.getStringMapKey(keyword2);
        this.map[key] = new Keyword(keyword2.toCharArray(), id, this.map[key]);
    }

    protected int getStringMapKey(String s) {
        return (Character.toUpperCase(s.charAt(0)) + Character.toUpperCase(s.charAt(s.length() - 1))) % this.mapLength;
    }

    protected int getSegmentMapKey(Segment s, int off, int len) {
        return (Character.toUpperCase(s.array[off]) + Character.toUpperCase(s.array[off + len - 1])) % this.mapLength;
    }

    class Keyword {
        public char[] keyword;
        public byte id;
        public Keyword next;

        public Keyword(char[] keyword2, byte id, Keyword next) {
            this.keyword = keyword2;
            this.id = id;
            this.next = next;
        }
    }
}

