/*
 * Decompiled with CFR 0.152.
 */
package jycessing.mode;

import javax.swing.text.Segment;
import jycessing.mode.PyKeywordMap;
import jycessing.mode.SyntaxUtilities;
import processing.app.syntax.TokenMarker;

public class PythonTokenMarker
extends TokenMarker {
    private static final byte TRIPLEQUOTE1 = 100;
    private static final byte TRIPLEQUOTE2 = 126;
    private static PyKeywordMap pyKeywords;
    private final PyKeywordMap keywords = PythonTokenMarker.getKeywords();
    private int lastOffset;
    private int lastKeyword;
    private static final byte CONSTANT = 4;
    private static final byte KEYWORD = 6;
    private static final byte FIELD = 7;
    private static final byte LOOP_KEYWORD = 8;
    private static final byte FUNCTION = 12;
    private static final byte METHOD = 13;
    private static final byte BUILTIN_FUNCTION = 15;
    private static final byte OPERATOR = 16;

    public void addColoring(String keyword2, String coloring) {
        int num = coloring.charAt(coloring.length() - 1) - 49;
        int id = 0;
        boolean paren = false;
        switch (coloring.charAt(0)) {
            case 'K': {
                id = 6 + num;
                break;
            }
            case 'L': {
                id = 3 + num;
                break;
            }
            case 'F': {
                id = 12 + num;
                paren = true;
            }
        }
        this.keywords.add(keyword2, (byte)id);
    }

    public byte markTokensImpl(byte token2, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        boolean backslash = false;
        int i = offset;
        block16: while (i < length) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
            } else {
                block0 : switch (token2) {
                    case 0: {
                        switch (c) {
                            case '#': {
                                if (backslash) {
                                    backslash = false;
                                    break;
                                }
                                this.doKeyword(line, i, c);
                                this.addToken(i - this.lastOffset, token2);
                                this.addToken(length - i, (byte)1);
                                this.lastOffset = this.lastKeyword = length;
                                break block16;
                            }
                            case '\"': {
                                this.doKeyword(line, i, c);
                                if (backslash) {
                                    backslash = false;
                                    break;
                                }
                                this.addToken(i - this.lastOffset, token2);
                                token2 = SyntaxUtilities.regionMatches(line, i1, "\"\"") ? (byte)100 : (byte)3;
                                this.lastOffset = this.lastKeyword = i;
                                break;
                            }
                            case '\'': {
                                this.doKeyword(line, i, c);
                                if (backslash) {
                                    backslash = false;
                                    break;
                                }
                                this.addToken(i - this.lastOffset, token2);
                                token2 = SyntaxUtilities.regionMatches(line, i1, "''") ? (byte)126 : (byte)4;
                                this.lastOffset = this.lastKeyword = i;
                                break;
                            }
                            default: {
                                backslash = false;
                                if (Character.isLetterOrDigit(c) || c == '_') break block0;
                                this.doKeyword(line, i, c);
                                break;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (backslash) {
                            backslash = false;
                            break;
                        }
                        if (c != '\"') break;
                        this.addToken(i1 - this.lastOffset, token2);
                        token2 = 0;
                        this.lastOffset = this.lastKeyword = i1;
                        break;
                    }
                    case 4: {
                        if (backslash) {
                            backslash = false;
                            break;
                        }
                        if (c != '\'') break;
                        this.addToken(i1 - this.lastOffset, (byte)3);
                        token2 = 0;
                        this.lastOffset = this.lastKeyword = i1;
                        break;
                    }
                    case 100: {
                        if (backslash) {
                            backslash = false;
                            break;
                        }
                        if (!SyntaxUtilities.regionMatches(line, i, "\"\"\"")) break;
                        this.addToken((i += 3) - this.lastOffset, (byte)3);
                        token2 = 0;
                        this.lastOffset = this.lastKeyword = i;
                        break;
                    }
                    case 126: {
                        if (backslash) {
                            backslash = false;
                            break;
                        }
                        if (!SyntaxUtilities.regionMatches(line, i, "'''")) break;
                        this.addToken((i += 3) - this.lastOffset, (byte)3);
                        token2 = 0;
                        this.lastOffset = this.lastKeyword = i;
                        break;
                    }
                    default: {
                        throw new InternalError("Invalid state: " + token2);
                    }
                }
            }
            ++i;
        }
        switch (token2) {
            case 100: 
            case 126: {
                this.addToken(length - this.lastOffset, (byte)3);
                break;
            }
            case 0: {
                this.doKeyword(line, length, '\u0000');
            }
            default: {
                this.addToken(length - this.lastOffset, token2);
            }
        }
        return token2;
    }

    public static PyKeywordMap getKeywords() {
        if (pyKeywords == null) {
            pyKeywords = new PyKeywordMap();
            pyKeywords.add("__init__", (byte)13);
            pyKeywords.add("and", (byte)16);
            pyKeywords.add("as", (byte)8);
            pyKeywords.add("assert", (byte)6);
            pyKeywords.add("break", (byte)6);
            pyKeywords.add("chr", (byte)12);
            pyKeywords.add("class", (byte)7);
            pyKeywords.add("continue", (byte)8);
            pyKeywords.add("def", (byte)6);
            pyKeywords.add("del", (byte)6);
            pyKeywords.add("elif", (byte)8);
            pyKeywords.add("else", (byte)8);
            pyKeywords.add("except", (byte)6);
            pyKeywords.add("exec", (byte)12);
            pyKeywords.add("finally", (byte)8);
            pyKeywords.add("for", (byte)8);
            pyKeywords.add("from", (byte)7);
            pyKeywords.add("global", (byte)6);
            pyKeywords.add("if", (byte)8);
            pyKeywords.add("import", (byte)6);
            pyKeywords.add("in", (byte)8);
            pyKeywords.add("is", (byte)16);
            pyKeywords.add("lambda", (byte)16);
            pyKeywords.add("len", (byte)12);
            pyKeywords.add("not", (byte)16);
            pyKeywords.add("or", (byte)16);
            pyKeywords.add("pass", (byte)8);
            pyKeywords.add("print", (byte)12);
            pyKeywords.add("raise", (byte)6);
            pyKeywords.add("range", (byte)8);
            pyKeywords.add("return", (byte)6);
            pyKeywords.add("self", (byte)7);
            pyKeywords.add("try", (byte)8);
            pyKeywords.add("with", (byte)8);
            pyKeywords.add("while", (byte)8);
            pyKeywords.add("fullScreen", (byte)15);
            pyKeywords.add("settings", (byte)15);
            pyKeywords.add("SPAN", (byte)4);
        }
        return pyKeywords;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
        }
        this.lastKeyword = i1;
        return false;
    }
}

