/*
 * Decompiled with CFR 0.152.
 */
package jycessing.mode.export;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Set;
import jycessing.mode.PyEditor;
import jycessing.mode.PythonMode;
import jycessing.mode.export.Arch;
import jycessing.mode.export.Exporter;
import jycessing.mode.export.PlatformExport;
import processing.app.Library;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.Util;
import processing.core.PApplet;
import processing.core.PConstants;

public class LinuxExport
extends PlatformExport {
    @Override
    protected void log(String msg) {
        if (PythonMode.VERBOSE) {
            System.err.println(String.valueOf(LinuxExport.class.getSimpleName()) + ": " + msg);
        } else {
            System.err.println("Not logging.");
        }
    }

    public LinuxExport(Arch arch, Sketch sketch, PyEditor editor, Set<Library> libraries) {
        this.id = 3;
        this.arch = arch;
        this.name = String.valueOf(PConstants.platformNames[this.id]) + arch.bits;
        this.sketch = sketch;
        this.editor = editor;
        this.libraries = libraries;
    }

    @Override
    public void export() throws IOException {
        boolean embedJava = this.id == PApplet.platform && Preferences.getBoolean((String)"export.application.embed_java") && this.arch == Exporter.processingArch;
        File destFolder = new File(this.sketch.getFolder(), "application." + this.name);
        File javaFolder = new File(destFolder, "java");
        this.copyBasicStructure(destFolder);
        if (embedJava) {
            this.log("Embedding java in export.");
            javaFolder.mkdirs();
            Util.copyDir((File)Platform.getJavaHome(), (File)javaFolder);
        }
        this.buildShellScript(destFolder, embedJava);
        this.log("Done.");
    }

    private void buildShellScript(File destFolder, boolean embedJava) throws IOException {
        this.log("Creating shell script.");
        boolean setMemory = Preferences.getBoolean((String)"run.options.memory");
        boolean presentMode = Preferences.getBoolean((String)"export.application.fullscreen");
        boolean stopButton = Preferences.getBoolean((String)"export.application.stop") && presentMode;
        File jycessingFolder = new File(destFolder, "lib/jycessing");
        File scriptFile = new File(destFolder, this.sketch.getName());
        PrintWriter script = new PrintWriter(scriptFile);
        script.print("#!/bin/sh\n");
        script.print("APPDIR=\"$( cd \"$( dirname \"$0\" )\" && pwd )\"\n");
        if (embedJava) {
            script.print("JAVA=\"$APPDIR/java/bin/java\"\n");
        } else {
            script.print("JAVA=java\n");
        }
        ArrayList<String> options = new ArrayList<String>();
        options.add("-Djna.nosys=true");
        options.add("-Djava.library.path=\"$APPDIR:$APPDIR/lib:$APPDIR/lib/jycessing\"");
        options.add("-ea");
        if (setMemory) {
            options.add("-Xms" + Preferences.get((String)"run.options.memory.initial") + "m");
            options.add("-Xmx" + Preferences.get((String)"run.options.memory.maximum") + "m");
        }
        StringWriter classpath = new StringWriter();
        File[] fileArray = jycessingFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getName().toLowerCase().endsWith(".jar") || f.getName().toLowerCase().endsWith(".zip")) {
                classpath.append("$APPDIR/lib/jycessing/" + f.getName() + ":");
            }
            ++n2;
        }
        options.add("-cp");
        options.add("\"" + classpath.toString().substring(0, classpath.toString().length() - 1) + "\"");
        options.add("-splash:\"$APPDIR/lib/jycessing/splash.png\"");
        if (PythonMode.VERBOSE) {
            options.add("-Dverbose=true");
        }
        options.add("jycessing.Runner");
        options.add("--noredirect");
        options.add("--exported");
        if (presentMode) {
            options.add("fullScreen");
            options.add("BGCOLOR=" + Preferences.get((String)"run.present.bgcolor"));
        }
        if (stopButton) {
            options.add("--stop-color=" + Preferences.get((String)"run.present.stop.color"));
        } else {
            options.add("--hide-stop");
        }
        options.add("\"$APPDIR/source/" + this.sketch.getCode(0).getFileName() + "\"");
        script.print("$JAVA");
        for (String o : options) {
            script.print(" " + o);
        }
        script.print("\n");
        script.close();
        this.log("Setting script executable.");
        try {
            Files.setPosixFilePermissions(scriptFile.toPath(), PosixFilePermissions.fromString("rwxrwxrwx"));
        }
        catch (UnsupportedOperationException e) {
            this.log("Couldn't set script executable... we'll assume whoever gets it can handle it");
        }
    }
}

