/*
 * Decompiled with CFR 0.152.
 */
package jycessing.mode.run;

import java.awt.Point;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jycessing.DisplayType;
import jycessing.RunnableSketch;
import jycessing.Runner;
import processing.app.Base;
import processing.app.Platform;
import processing.app.Sketch;

public class PdeSketch
implements RunnableSketch,
Serializable {
    private final List<File> libraryDirs;
    private final File mainFile;
    private final String mainCode;
    private final File sketchHome;
    private final File realSketchPath;
    private final Point location;
    private final LocationType locationType;
    private final DisplayType displayType;
    public final String[] codeFileNames;

    public PdeSketch(Sketch sketch, File sketchPath, DisplayType displayType, Point location, LocationType locationType) {
        this.displayType = displayType;
        this.location = location;
        this.locationType = locationType;
        this.mainFile = sketchPath.getAbsoluteFile();
        this.mainCode = sketch.getMainProgram();
        this.sketchHome = sketch.getFolder().getAbsoluteFile();
        this.realSketchPath = sketchPath;
        ArrayList<File> libraryDirs = new ArrayList<File>();
        libraryDirs.add(Platform.getContentFile((String)"modes/java/libraries"));
        libraryDirs.add(Base.getSketchbookLibrariesFolder());
        libraryDirs.add(sketchPath);
        this.libraryDirs = libraryDirs;
        String[] codeFileNames = new String[sketch.getCodeCount()];
        int i = 0;
        while (i < codeFileNames.length) {
            codeFileNames[i] = sketch.getCode(i).getFile().getName();
            ++i;
        }
        this.codeFileNames = codeFileNames;
    }

    @Override
    public File getMainFile() {
        return this.mainFile;
    }

    @Override
    public String getMainCode() {
        return this.mainCode;
    }

    @Override
    public File getHomeDirectory() {
        return this.mainFile.getParentFile();
    }

    @Override
    public String[] getPAppletArguments() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--external");
        args.add("--sketch-path=" + this.sketchHome);
        switch (this.displayType) {
            case WINDOWED: {
                if (this.locationType == LocationType.EDITOR_LOCATION) {
                    args.add(String.format("%s=%d,%d", "--editor-location", this.location.x, this.location.y));
                    break;
                }
                if (this.locationType != LocationType.SKETCH_LOCATION) break;
                args.add(String.format("%s=%d,%d", "--location", this.location.x, this.location.y));
                break;
            }
            case PRESENTATION: {
                args.add("fullScreen");
            }
        }
        args.add(this.mainFile.getName());
        return args.toArray(new String[0]);
    }

    @Override
    public List<File> getLibraryDirectories() {
        return this.libraryDirs;
    }

    @Override
    public Runner.LibraryPolicy getLibraryPolicy() {
        return Runner.LibraryPolicy.SELECTIVE;
    }

    @Override
    public boolean shouldRun() {
        return true;
    }

    @Override
    public List<File> getPathEntries() {
        ArrayList<File> entries = new ArrayList<File>();
        entries.add(this.realSketchPath.getParentFile());
        entries.add(this.sketchHome);
        entries.add(new File(this.sketchHome, "source"));
        File code2 = new File(this.sketchHome, "code");
        if (code2.exists()) {
            entries.add(code2);
        }
        return entries;
    }

    public static enum LocationType {
        EDITOR_LOCATION,
        SKETCH_LOCATION;

    }
}

