/*
 * Decompiled with CFR 0.152.
 */
package jycessing.mode.run;

import java.awt.Point;
import java.rmi.RemoteException;
import jycessing.Printer;
import jycessing.PythonSketchError;
import jycessing.Runner;
import jycessing.SketchPositionListener;
import jycessing.mode.PythonMode;
import jycessing.mode.run.ModeService;
import jycessing.mode.run.ModeWaiter;
import jycessing.mode.run.OSXAdapter;
import jycessing.mode.run.PdeSketch;
import jycessing.mode.run.RMIUtils;
import jycessing.mode.run.SketchService;
import processing.app.SketchException;
import processing.core.PApplet;

public class SketchRunner
implements SketchService {
    private final String id;
    private final ModeService modeService;
    private Thread runner = null;
    private volatile boolean shutdownWasRequested = false;

    private static void log(String msg) {
        if (PythonMode.VERBOSE) {
            System.err.println(String.valueOf(SketchRunner.class.getSimpleName()) + ": " + msg);
        }
    }

    public SketchRunner(String id, ModeService modeService) {
        this.id = id;
        this.modeService = modeService;
        if (PApplet.platform == 2) {
            try {
                OSXAdapter.setQuitHandler(this, this.getClass().getMethod("preventUserQuit", new Class[0]));
            }
            catch (Throwable e) {
                System.err.println(e.getMessage());
            }
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runner.warmup();
            }
        }, "SketchRunner Warmup Thread").start();
    }

    public boolean preventUserQuit() {
        if (this.shutdownWasRequested) {
            SketchRunner.log("Permitting quit.");
            return true;
        }
        SketchRunner.log("Cancelling quit, but stopping sketch.");
        new Thread(new Runnable(){

            @Override
            public void run() {
                SketchRunner.this.stopSketch();
            }
        }).start();
        return false;
    }

    @Override
    public void shutdown() {
        this.shutdownWasRequested = true;
        SketchRunner.log("Calling system.exit(0)");
        System.exit(0);
    }

    @Override
    public void startSketch(final PdeSketch sketch) {
        this.runner = new Thread(new Runnable(){

            @Override
            public void run() {
                block11: {
                    try {
                        try {
                            Printer stdout = new Printer(){

                                @Override
                                public void print(Object o) {
                                    try {
                                        SketchRunner.this.modeService.printStdOut(SketchRunner.this.id, String.valueOf(o));
                                    }
                                    catch (RemoteException e) {
                                        System.err.println(e);
                                    }
                                }
                            };
                            Printer stderr = new Printer(){

                                @Override
                                public void print(Object o) {
                                    try {
                                        SketchRunner.this.modeService.printStdErr(SketchRunner.this.id, String.valueOf(o));
                                    }
                                    catch (RemoteException e) {
                                        System.err.println(e);
                                    }
                                }
                            };
                            SketchPositionListener sketchPositionListener = new SketchPositionListener(){

                                @Override
                                public void sketchMoved(Point leftTop) {
                                    try {
                                        SketchRunner.this.modeService.handleSketchMoved(SketchRunner.this.id, leftTop);
                                    }
                                    catch (RemoteException e) {
                                        System.err.println(e);
                                    }
                                }
                            };
                            Runner.runSketchBlocking(sketch, stdout, stderr, sketchPositionListener);
                        }
                        catch (PythonSketchError e) {
                            SketchRunner.log("Sketch runner caught " + e);
                            SketchRunner.this.modeService.handleSketchException(SketchRunner.this.id, (Exception)((Object)SketchRunner.this.convertPythonSketchError(e, sketch.codeFileNames)));
                            SketchRunner.log("Handling sketch stoppage...");
                            SketchRunner.this.modeService.handleSketchStopped(SketchRunner.this.id);
                            break block11;
                        }
                        catch (Exception e) {
                            try {
                                if (e.getCause() != null && e.getCause() instanceof PythonSketchError) {
                                    SketchRunner.this.modeService.handleSketchException(SketchRunner.this.id, (Exception)((Object)SketchRunner.this.convertPythonSketchError((PythonSketchError)e.getCause(), sketch.codeFileNames)));
                                } else {
                                    SketchRunner.this.modeService.handleSketchException(SketchRunner.this.id, e);
                                }
                                break block11;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                SketchRunner.log("Handling sketch stoppage...");
                                SketchRunner.this.modeService.handleSketchStopped(SketchRunner.this.id);
                            }
                        }
                        SketchRunner.log("Handling sketch stoppage...");
                        SketchRunner.this.modeService.handleSketchStopped(SketchRunner.this.id);
                    }
                    catch (RemoteException e) {
                        SketchRunner.log(e.toString());
                    }
                }
                SketchRunner.this.runner = null;
            }
        }, "processing.py mode runner");
        this.runner.start();
    }

    @Override
    public void stopSketch() {
        SketchRunner.log("stopSketch()");
        if (this.runner != null) {
            SketchRunner.log("Interrupting runner thread.");
            this.runner.interrupt();
            try {
                SketchRunner.log("Joining runner thread.");
                this.runner.join();
                SketchRunner.log("Runner thread terminated normally.");
            }
            catch (InterruptedException e) {
                SketchRunner.log("Interrupted while joined to runner thread.");
            }
            this.runner = null;
        }
    }

    public static void main(String[] args) {
        String id = args[0];
        if (PythonMode.SKETCH_RUNNER_FIRST) {
            SketchRunner.waitForMode(id);
        } else {
            SketchRunner.startSketchRunner(id);
        }
    }

    private static void waitForMode(String id) {
        try {
            RMIUtils.bind(new ModeWaiterImpl(id), ModeWaiter.class);
        }
        catch (RMIUtils.RMIProblem e) {
            throw new RuntimeException(e);
        }
    }

    private static void startSketchRunner(String id) {
        try {
            ModeService modeService = RMIUtils.lookup(ModeService.class);
            SketchRunner.launch(id, modeService);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void launch(final String id, final ModeService modeService) throws RMIUtils.RMIProblem, RemoteException {
        SketchRunner sketchRunner = new SketchRunner(id, modeService);
        SketchService stub = (SketchService)RMIUtils.export(sketchRunner);
        SketchRunner.log("Calling mode's handleReady().");
        modeService.handleReady(id, stub);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                SketchRunner.log("Exiting; telling modeService.");
                try {
                    modeService.handleSketchStopped(id);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }));
    }

    private SketchException convertPythonSketchError(PythonSketchError e, String[] fileNames) {
        if (e.fileName == null) {
            return new SketchException(e.getMessage());
        }
        int fileIndex = -1;
        int i = 0;
        while (i < fileNames.length) {
            if (fileNames[i].equals(e.fileName)) {
                fileIndex = i;
                break;
            }
            ++i;
        }
        if (fileIndex < 0) {
            return new SketchException(e.getMessage());
        }
        if (e.line < 0) {
            return new SketchException(e.getMessage(), fileIndex, 0);
        }
        if (e.column < 0) {
            return new SketchException(e.getMessage(), fileIndex, e.line);
        }
        return new SketchException(e.getMessage(), fileIndex, e.line, e.column);
    }

    private static class ModeWaiterImpl
    implements ModeWaiter {
        final String id;

        public ModeWaiterImpl(String id) {
            this.id = id;
        }

        @Override
        public void modeReady(ModeService modeService) {
            try {
                SketchRunner.launch(this.id, modeService);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

