import { ClientLanguage } from "../../languages";
/**
 * Enum for generator directories for non-client generators
 */
export declare enum NonClientGeneratorDirectory {
    DOCS = "docs"
}
/**
 * Generator directory for openapi generation containing templates, config etc.
 */
export declare type GeneratorDirectory = ClientLanguage | NonClientGeneratorDirectory;
/**
 * Options for generating client code or docs using OpenAPI Generator CLI
 */
export interface GenerationOptions {
    /**
     * The OpenAPI generator to use to generate the code/docs
     */
    readonly generator: string;
    /**
     * The directory to use for OpenAPI generation
     */
    readonly generatorDirectory: GeneratorDirectory;
    /**
     * The path of the OpenAPI spec to generate the client for
     */
    readonly specPath: string;
    /**
     * The directory in which the generated code should be output
     */
    readonly outputPath: string;
    /**
     * Additional properties to pass to the generate cli
     */
    readonly additionalProperties?: {
        [key: string]: string;
    };
}
/**
 * Generate client code or docs by invoking the root generate script
 */
export declare const invokeOpenApiGenerator: (options: GenerationOptions) => void;
/**
 * Options for generating documentation via a custom generator script
 */
export interface CustomDocsGenerationOptions {
    /**
     * Name of the generator script which exists in scripts/custom/docs
     */
    readonly generator: string;
    /**
     * Any arguments to pass to the script
     */
    readonly args?: string;
}
/**
 * Invoke a custom documentation generator script
 */
export declare const invokeCustomDocsGenerator: (options: CustomDocsGenerationOptions) => void;
