# coding: utf-8

"""
    Component Database API

    The API that provides access to Component Database data.  # noqa: E501

    The version of the OpenAPI document: 3.12.3
    Contact: djarosz@anl.gov
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from cdbApi.api_client import ApiClient
from cdbApi.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ComponentCatalogItemsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_catalog_element(self, catalog_item_id, new_catalog_element_information, **kwargs):  # noqa: E501
        """Create catalog item element.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_catalog_element(catalog_item_id, new_catalog_element_information, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int catalog_item_id: (required)
        :param NewCatalogElementInformation new_catalog_element_information: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ItemElement
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.add_catalog_element_with_http_info(catalog_item_id, new_catalog_element_information, **kwargs)  # noqa: E501

    def add_catalog_element_with_http_info(self, catalog_item_id, new_catalog_element_information, **kwargs):  # noqa: E501
        """Create catalog item element.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_catalog_element_with_http_info(catalog_item_id, new_catalog_element_information, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int catalog_item_id: (required)
        :param NewCatalogElementInformation new_catalog_element_information: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ItemElement, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'catalog_item_id',
            'new_catalog_element_information'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_catalog_element" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'catalog_item_id' is set
        if self.api_client.client_side_validation and ('catalog_item_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['catalog_item_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `catalog_item_id` when calling `add_catalog_element`")  # noqa: E501
        # verify the required parameter 'new_catalog_element_information' is set
        if self.api_client.client_side_validation and ('new_catalog_element_information' not in local_var_params or  # noqa: E501
                                                        local_var_params['new_catalog_element_information'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `new_catalog_element_information` when calling `add_catalog_element`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'catalog_item_id' in local_var_params:
            path_params['catalogItemId'] = local_var_params['catalog_item_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'new_catalog_element_information' in local_var_params:
            body_params = local_var_params['new_catalog_element_information']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['cdbAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/ComponentCatalogItems/createElement/{catalogItemId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemElement',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_catalog(self, new_catalog_information, **kwargs):  # noqa: E501
        """Create catalog item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_catalog(new_catalog_information, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param NewCatalogInformation new_catalog_information: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ItemDomainCatalog
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_catalog_with_http_info(new_catalog_information, **kwargs)  # noqa: E501

    def create_catalog_with_http_info(self, new_catalog_information, **kwargs):  # noqa: E501
        """Create catalog item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_catalog_with_http_info(new_catalog_information, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param NewCatalogInformation new_catalog_information: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ItemDomainCatalog, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'new_catalog_information'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_catalog" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'new_catalog_information' is set
        if self.api_client.client_side_validation and ('new_catalog_information' not in local_var_params or  # noqa: E501
                                                        local_var_params['new_catalog_information'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `new_catalog_information` when calling `create_catalog`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'new_catalog_information' in local_var_params:
            body_params = local_var_params['new_catalog_information']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['cdbAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/ComponentCatalogItems/create', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemDomainCatalog',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
